import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryDatasetJsonConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#additional_properties DataFactoryDatasetJson#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#annotations DataFactoryDatasetJson#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#data_factory_id DataFactoryDatasetJson#data_factory_id}
    */
    readonly dataFactoryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#data_factory_name DataFactoryDatasetJson#data_factory_name}
    */
    readonly dataFactoryName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#description DataFactoryDatasetJson#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#encoding DataFactoryDatasetJson#encoding}
    */
    readonly encoding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#folder DataFactoryDatasetJson#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#linked_service_name DataFactoryDatasetJson#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#name DataFactoryDatasetJson#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#parameters DataFactoryDatasetJson#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#resource_group_name DataFactoryDatasetJson#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * azure_blob_storage_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#azure_blob_storage_location DataFactoryDatasetJson#azure_blob_storage_location}
    */
    readonly azureBlobStorageLocation?: DataFactoryDatasetJsonAzureBlobStorageLocation;
    /**
    * http_server_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#http_server_location DataFactoryDatasetJson#http_server_location}
    */
    readonly httpServerLocation?: DataFactoryDatasetJsonHttpServerLocation;
    /**
    * schema_column block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#schema_column DataFactoryDatasetJson#schema_column}
    */
    readonly schemaColumn?: DataFactoryDatasetJsonSchemaColumn[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#timeouts DataFactoryDatasetJson#timeouts}
    */
    readonly timeouts?: DataFactoryDatasetJsonTimeouts;
}
export interface DataFactoryDatasetJsonAzureBlobStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#container DataFactoryDatasetJson#container}
    */
    readonly container: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#dynamic_filename_enabled DataFactoryDatasetJson#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#dynamic_path_enabled DataFactoryDatasetJson#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#filename DataFactoryDatasetJson#filename}
    */
    readonly filename: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#path DataFactoryDatasetJson#path}
    */
    readonly path: string;
}
export declare function dataFactoryDatasetJsonAzureBlobStorageLocationToTerraform(struct?: DataFactoryDatasetJsonAzureBlobStorageLocationOutputReference | DataFactoryDatasetJsonAzureBlobStorageLocation): any;
export declare class DataFactoryDatasetJsonAzureBlobStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDatasetJsonAzureBlobStorageLocation | undefined;
    set internalValue(value: DataFactoryDatasetJsonAzureBlobStorageLocation | undefined);
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    get filenameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataFactoryDatasetJsonHttpServerLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#dynamic_filename_enabled DataFactoryDatasetJson#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#dynamic_path_enabled DataFactoryDatasetJson#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#filename DataFactoryDatasetJson#filename}
    */
    readonly filename: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#path DataFactoryDatasetJson#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#relative_url DataFactoryDatasetJson#relative_url}
    */
    readonly relativeUrl: string;
}
export declare function dataFactoryDatasetJsonHttpServerLocationToTerraform(struct?: DataFactoryDatasetJsonHttpServerLocationOutputReference | DataFactoryDatasetJsonHttpServerLocation): any;
export declare class DataFactoryDatasetJsonHttpServerLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDatasetJsonHttpServerLocation | undefined;
    set internalValue(value: DataFactoryDatasetJsonHttpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    get filenameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _relativeUrl?;
    get relativeUrl(): string;
    set relativeUrl(value: string);
    get relativeUrlInput(): string | undefined;
}
export interface DataFactoryDatasetJsonSchemaColumn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#description DataFactoryDatasetJson#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#name DataFactoryDatasetJson#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#type DataFactoryDatasetJson#type}
    */
    readonly type?: string;
}
export declare function dataFactoryDatasetJsonSchemaColumnToTerraform(struct?: DataFactoryDatasetJsonSchemaColumn | cdktf.IResolvable): any;
export interface DataFactoryDatasetJsonTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#create DataFactoryDatasetJson#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#delete DataFactoryDatasetJson#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#read DataFactoryDatasetJson#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json#update DataFactoryDatasetJson#update}
    */
    readonly update?: string;
}
export declare function dataFactoryDatasetJsonTimeoutsToTerraform(struct?: DataFactoryDatasetJsonTimeoutsOutputReference | DataFactoryDatasetJsonTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryDatasetJsonTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDatasetJsonTimeouts | undefined;
    set internalValue(value: DataFactoryDatasetJsonTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json azurerm_data_factory_dataset_json}
*/
export declare class DataFactoryDatasetJson extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_dataset_json";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_json azurerm_data_factory_dataset_json} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryDatasetJsonConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetJsonConfig);
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    resetDataFactoryId(): void;
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    get dataFactoryName(): string;
    set dataFactoryName(value: string);
    resetDataFactoryName(): void;
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    get id(): string;
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _azureBlobStorageLocation;
    get azureBlobStorageLocation(): DataFactoryDatasetJsonAzureBlobStorageLocationOutputReference;
    putAzureBlobStorageLocation(value: DataFactoryDatasetJsonAzureBlobStorageLocation): void;
    resetAzureBlobStorageLocation(): void;
    get azureBlobStorageLocationInput(): DataFactoryDatasetJsonAzureBlobStorageLocation | undefined;
    private _httpServerLocation;
    get httpServerLocation(): DataFactoryDatasetJsonHttpServerLocationOutputReference;
    putHttpServerLocation(value: DataFactoryDatasetJsonHttpServerLocation): void;
    resetHttpServerLocation(): void;
    get httpServerLocationInput(): DataFactoryDatasetJsonHttpServerLocation | undefined;
    private _schemaColumn?;
    get schemaColumn(): DataFactoryDatasetJsonSchemaColumn[] | cdktf.IResolvable;
    set schemaColumn(value: DataFactoryDatasetJsonSchemaColumn[] | cdktf.IResolvable);
    resetSchemaColumn(): void;
    get schemaColumnInput(): cdktf.IResolvable | DataFactoryDatasetJsonSchemaColumn[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryDatasetJsonTimeoutsOutputReference;
    putTimeouts(value: DataFactoryDatasetJsonTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataFactoryDatasetJsonTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
