import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallNetworkRuleCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#action FirewallNetworkRuleCollection#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#azure_firewall_name FirewallNetworkRuleCollection#azure_firewall_name}
    */
    readonly azureFirewallName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#name FirewallNetworkRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#priority FirewallNetworkRuleCollection#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#resource_group_name FirewallNetworkRuleCollection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#rule FirewallNetworkRuleCollection#rule}
    */
    readonly rule: FirewallNetworkRuleCollectionRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#timeouts FirewallNetworkRuleCollection#timeouts}
    */
    readonly timeouts?: FirewallNetworkRuleCollectionTimeouts;
}
export interface FirewallNetworkRuleCollectionRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#description FirewallNetworkRuleCollection#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#destination_addresses FirewallNetworkRuleCollection#destination_addresses}
    */
    readonly destinationAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#destination_fqdns FirewallNetworkRuleCollection#destination_fqdns}
    */
    readonly destinationFqdns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#destination_ip_groups FirewallNetworkRuleCollection#destination_ip_groups}
    */
    readonly destinationIpGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#destination_ports FirewallNetworkRuleCollection#destination_ports}
    */
    readonly destinationPorts: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#name FirewallNetworkRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#protocols FirewallNetworkRuleCollection#protocols}
    */
    readonly protocols: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#source_addresses FirewallNetworkRuleCollection#source_addresses}
    */
    readonly sourceAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#source_ip_groups FirewallNetworkRuleCollection#source_ip_groups}
    */
    readonly sourceIpGroups?: string[];
}
export declare function firewallNetworkRuleCollectionRuleToTerraform(struct?: FirewallNetworkRuleCollectionRule | cdktf.IResolvable): any;
export interface FirewallNetworkRuleCollectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#create FirewallNetworkRuleCollection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#delete FirewallNetworkRuleCollection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#read FirewallNetworkRuleCollection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection#update FirewallNetworkRuleCollection#update}
    */
    readonly update?: string;
}
export declare function firewallNetworkRuleCollectionTimeoutsToTerraform(struct?: FirewallNetworkRuleCollectionTimeoutsOutputReference | FirewallNetworkRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare class FirewallNetworkRuleCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallNetworkRuleCollectionTimeouts | undefined;
    set internalValue(value: FirewallNetworkRuleCollectionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection azurerm_firewall_network_rule_collection}
*/
export declare class FirewallNetworkRuleCollection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_firewall_network_rule_collection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection azurerm_firewall_network_rule_collection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallNetworkRuleCollectionConfig
    */
    constructor(scope: Construct, id: string, config: FirewallNetworkRuleCollectionConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _azureFirewallName?;
    get azureFirewallName(): string;
    set azureFirewallName(value: string);
    get azureFirewallNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rule?;
    get rule(): FirewallNetworkRuleCollectionRule[] | cdktf.IResolvable;
    set rule(value: FirewallNetworkRuleCollectionRule[] | cdktf.IResolvable);
    get ruleInput(): cdktf.IResolvable | FirewallNetworkRuleCollectionRule[] | undefined;
    private _timeouts;
    get timeouts(): FirewallNetworkRuleCollectionTimeoutsOutputReference;
    putTimeouts(value: FirewallNetworkRuleCollectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FirewallNetworkRuleCollectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
