import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppIntegrationAccountCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#integration_account_name LogicAppIntegrationAccountCertificate#integration_account_name}
    */
    readonly integrationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#metadata LogicAppIntegrationAccountCertificate#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#name LogicAppIntegrationAccountCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#public_certificate LogicAppIntegrationAccountCertificate#public_certificate}
    */
    readonly publicCertificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#resource_group_name LogicAppIntegrationAccountCertificate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * key_vault_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#key_vault_key LogicAppIntegrationAccountCertificate#key_vault_key}
    */
    readonly keyVaultKey?: LogicAppIntegrationAccountCertificateKeyVaultKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#timeouts LogicAppIntegrationAccountCertificate#timeouts}
    */
    readonly timeouts?: LogicAppIntegrationAccountCertificateTimeouts;
}
export interface LogicAppIntegrationAccountCertificateKeyVaultKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#key_name LogicAppIntegrationAccountCertificate#key_name}
    */
    readonly keyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#key_vault_id LogicAppIntegrationAccountCertificate#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#key_version LogicAppIntegrationAccountCertificate#key_version}
    */
    readonly keyVersion?: string;
}
export declare function logicAppIntegrationAccountCertificateKeyVaultKeyToTerraform(struct?: LogicAppIntegrationAccountCertificateKeyVaultKeyOutputReference | LogicAppIntegrationAccountCertificateKeyVaultKey): any;
export declare class LogicAppIntegrationAccountCertificateKeyVaultKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppIntegrationAccountCertificateKeyVaultKey | undefined;
    set internalValue(value: LogicAppIntegrationAccountCertificateKeyVaultKey | undefined);
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    get keyNameInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _keyVersion?;
    get keyVersion(): string;
    set keyVersion(value: string);
    resetKeyVersion(): void;
    get keyVersionInput(): string | undefined;
}
export interface LogicAppIntegrationAccountCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#create LogicAppIntegrationAccountCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#delete LogicAppIntegrationAccountCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#read LogicAppIntegrationAccountCertificate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate#update LogicAppIntegrationAccountCertificate#update}
    */
    readonly update?: string;
}
export declare function logicAppIntegrationAccountCertificateTimeoutsToTerraform(struct?: LogicAppIntegrationAccountCertificateTimeoutsOutputReference | LogicAppIntegrationAccountCertificateTimeouts | cdktf.IResolvable): any;
export declare class LogicAppIntegrationAccountCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppIntegrationAccountCertificateTimeouts | undefined;
    set internalValue(value: LogicAppIntegrationAccountCertificateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate azurerm_logic_app_integration_account_certificate}
*/
export declare class LogicAppIntegrationAccountCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_integration_account_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_certificate azurerm_logic_app_integration_account_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppIntegrationAccountCertificateConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppIntegrationAccountCertificateConfig);
    get id(): string;
    private _integrationAccountName?;
    get integrationAccountName(): string;
    set integrationAccountName(value: string);
    get integrationAccountNameInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicCertificate?;
    get publicCertificate(): string;
    set publicCertificate(value: string);
    resetPublicCertificate(): void;
    get publicCertificateInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _keyVaultKey;
    get keyVaultKey(): LogicAppIntegrationAccountCertificateKeyVaultKeyOutputReference;
    putKeyVaultKey(value: LogicAppIntegrationAccountCertificateKeyVaultKey): void;
    resetKeyVaultKey(): void;
    get keyVaultKeyInput(): LogicAppIntegrationAccountCertificateKeyVaultKey | undefined;
    private _timeouts;
    get timeouts(): LogicAppIntegrationAccountCertificateTimeoutsOutputReference;
    putTimeouts(value: LogicAppIntegrationAccountCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LogicAppIntegrationAccountCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
