import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseSqlPoolExtendedAuditingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#log_monitoring_enabled SynapseSqlPoolExtendedAuditingPolicy#log_monitoring_enabled}
    */
    readonly logMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#retention_in_days SynapseSqlPoolExtendedAuditingPolicy#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#sql_pool_id SynapseSqlPoolExtendedAuditingPolicy#sql_pool_id}
    */
    readonly sqlPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#storage_account_access_key SynapseSqlPoolExtendedAuditingPolicy#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#storage_account_access_key_is_secondary SynapseSqlPoolExtendedAuditingPolicy#storage_account_access_key_is_secondary}
    */
    readonly storageAccountAccessKeyIsSecondary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#storage_endpoint SynapseSqlPoolExtendedAuditingPolicy#storage_endpoint}
    */
    readonly storageEndpoint?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#timeouts SynapseSqlPoolExtendedAuditingPolicy#timeouts}
    */
    readonly timeouts?: SynapseSqlPoolExtendedAuditingPolicyTimeouts;
}
export interface SynapseSqlPoolExtendedAuditingPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#create SynapseSqlPoolExtendedAuditingPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#delete SynapseSqlPoolExtendedAuditingPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#read SynapseSqlPoolExtendedAuditingPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy#update SynapseSqlPoolExtendedAuditingPolicy#update}
    */
    readonly update?: string;
}
export declare function synapseSqlPoolExtendedAuditingPolicyTimeoutsToTerraform(struct?: SynapseSqlPoolExtendedAuditingPolicyTimeoutsOutputReference | SynapseSqlPoolExtendedAuditingPolicyTimeouts | cdktf.IResolvable): any;
export declare class SynapseSqlPoolExtendedAuditingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseSqlPoolExtendedAuditingPolicyTimeouts | undefined;
    set internalValue(value: SynapseSqlPoolExtendedAuditingPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy azurerm_synapse_sql_pool_extended_auditing_policy}
*/
export declare class SynapseSqlPoolExtendedAuditingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_sql_pool_extended_auditing_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_extended_auditing_policy azurerm_synapse_sql_pool_extended_auditing_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseSqlPoolExtendedAuditingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolExtendedAuditingPolicyConfig);
    get id(): string;
    private _logMonitoringEnabled?;
    get logMonitoringEnabled(): boolean | cdktf.IResolvable;
    set logMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetLogMonitoringEnabled(): void;
    get logMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _sqlPoolId?;
    get sqlPoolId(): string;
    set sqlPoolId(value: string);
    get sqlPoolIdInput(): string | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountAccessKeyIsSecondary?;
    get storageAccountAccessKeyIsSecondary(): boolean | cdktf.IResolvable;
    set storageAccountAccessKeyIsSecondary(value: boolean | cdktf.IResolvable);
    resetStorageAccountAccessKeyIsSecondary(): void;
    get storageAccountAccessKeyIsSecondaryInput(): boolean | cdktf.IResolvable | undefined;
    private _storageEndpoint?;
    get storageEndpoint(): string;
    set storageEndpoint(value: string);
    resetStorageEndpoint(): void;
    get storageEndpointInput(): string | undefined;
    private _timeouts;
    get timeouts(): SynapseSqlPoolExtendedAuditingPolicyTimeoutsOutputReference;
    putTimeouts(value: SynapseSqlPoolExtendedAuditingPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SynapseSqlPoolExtendedAuditingPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
