"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CapabilityType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CapabilityTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _CapabilityType.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CAPABILITY_TYPE_UNSPECIFIED: _CapabilityType.ValueType  # 0
    CAPABILITY_TYPE_TEXT: _CapabilityType.ValueType  # 1
    """Basic text input/output capability"""
    CAPABILITY_TYPE_STRUCTURED_RESPONSE: _CapabilityType.ValueType  # 2
    """Structured output (JSON, XML, etc.)"""
    CAPABILITY_TYPE_STREAMING: _CapabilityType.ValueType  # 3
    """Server-sent or websocket streaming of partial outputs"""
    CAPABILITY_TYPE_FUNCTION_CALLING: _CapabilityType.ValueType  # 4
    """Tool/function calling with schemaed arguments"""
    CAPABILITY_TYPE_VISION: _CapabilityType.ValueType  # 5
    """Image understanding and/or generation"""
    CAPABILITY_TYPE_TOOL_USE: _CapabilityType.ValueType  # 6
    """General tool use beyond plain function calls"""
    CAPABILITY_TYPE_SYSTEM_PROMPT: _CapabilityType.ValueType  # 7
    """System messages/prompt steering support"""
    CAPABILITY_TYPE_CACHING: _CapabilityType.ValueType  # 8
    """Prompt/context caching capabilities"""
    CAPABILITY_TYPE_REASONING: _CapabilityType.ValueType  # 9
    """Advanced reasoning controls/strategies"""
    CAPABILITY_TYPE_AUDIO: _CapabilityType.ValueType  # 10
    """Audio STT/TTS support"""
    CAPABILITY_TYPE_VIDEO: _CapabilityType.ValueType  # 11
    """Video analysis/generation support"""
    CAPABILITY_TYPE_EMBEDDINGS: _CapabilityType.ValueType  # 12
    """Vector embedding generation"""
    CAPABILITY_TYPE_FINE_TUNING: _CapabilityType.ValueType  # 13
    """Custom model training/fine-tuning"""

class CapabilityType(_CapabilityType, metaclass=_CapabilityTypeEnumTypeWrapper):
    """Capabilities describe the discrete features that an LLM may support
    (e.g., function calling, vision, streaming). This file defines the
    enums and messages used to declare and configure these capabilities
    on a per-model basis. See model.proto for how capabilities are attached
    to a Model.

    Core capability types that models can support
    """

CAPABILITY_TYPE_UNSPECIFIED: CapabilityType.ValueType  # 0
CAPABILITY_TYPE_TEXT: CapabilityType.ValueType  # 1
"""Basic text input/output capability"""
CAPABILITY_TYPE_STRUCTURED_RESPONSE: CapabilityType.ValueType  # 2
"""Structured output (JSON, XML, etc.)"""
CAPABILITY_TYPE_STREAMING: CapabilityType.ValueType  # 3
"""Server-sent or websocket streaming of partial outputs"""
CAPABILITY_TYPE_FUNCTION_CALLING: CapabilityType.ValueType  # 4
"""Tool/function calling with schemaed arguments"""
CAPABILITY_TYPE_VISION: CapabilityType.ValueType  # 5
"""Image understanding and/or generation"""
CAPABILITY_TYPE_TOOL_USE: CapabilityType.ValueType  # 6
"""General tool use beyond plain function calls"""
CAPABILITY_TYPE_SYSTEM_PROMPT: CapabilityType.ValueType  # 7
"""System messages/prompt steering support"""
CAPABILITY_TYPE_CACHING: CapabilityType.ValueType  # 8
"""Prompt/context caching capabilities"""
CAPABILITY_TYPE_REASONING: CapabilityType.ValueType  # 9
"""Advanced reasoning controls/strategies"""
CAPABILITY_TYPE_AUDIO: CapabilityType.ValueType  # 10
"""Audio STT/TTS support"""
CAPABILITY_TYPE_VIDEO: CapabilityType.ValueType  # 11
"""Video analysis/generation support"""
CAPABILITY_TYPE_EMBEDDINGS: CapabilityType.ValueType  # 12
"""Vector embedding generation"""
CAPABILITY_TYPE_FINE_TUNING: CapabilityType.ValueType  # 13
"""Custom model training/fine-tuning"""
global___CapabilityType = CapabilityType

class _DataFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DataFormatEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DataFormat.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DATA_FORMAT_UNSPECIFIED: _DataFormat.ValueType  # 0
    DATA_FORMAT_JSON: _DataFormat.ValueType  # 1
    DATA_FORMAT_YAML: _DataFormat.ValueType  # 2
    DATA_FORMAT_XML: _DataFormat.ValueType  # 3
    DATA_FORMAT_JSONL: _DataFormat.ValueType  # 4
    DATA_FORMAT_CSV: _DataFormat.ValueType  # 5
    DATA_FORMAT_PARQUET: _DataFormat.ValueType  # 6
    DATA_FORMAT_PLAIN: _DataFormat.ValueType  # 7
    DATA_FORMAT_MARKDOWN: _DataFormat.ValueType  # 8
    DATA_FORMAT_STRUCTURED: _DataFormat.ValueType  # 9

class DataFormat(_DataFormat, metaclass=_DataFormatEnumTypeWrapper):
    """Data format types for structured responses, fine-tuning, etc."""

DATA_FORMAT_UNSPECIFIED: DataFormat.ValueType  # 0
DATA_FORMAT_JSON: DataFormat.ValueType  # 1
DATA_FORMAT_YAML: DataFormat.ValueType  # 2
DATA_FORMAT_XML: DataFormat.ValueType  # 3
DATA_FORMAT_JSONL: DataFormat.ValueType  # 4
DATA_FORMAT_CSV: DataFormat.ValueType  # 5
DATA_FORMAT_PARQUET: DataFormat.ValueType  # 6
DATA_FORMAT_PLAIN: DataFormat.ValueType  # 7
DATA_FORMAT_MARKDOWN: DataFormat.ValueType  # 8
DATA_FORMAT_STRUCTURED: DataFormat.ValueType  # 9
global___DataFormat = DataFormat

class _JsonSchemaType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _JsonSchemaTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _JsonSchemaType.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    JSON_SCHEMA_TYPE_UNSPECIFIED: _JsonSchemaType.ValueType  # 0
    JSON_SCHEMA_TYPE_OBJECT: _JsonSchemaType.ValueType  # 1
    JSON_SCHEMA_TYPE_ARRAY: _JsonSchemaType.ValueType  # 2
    JSON_SCHEMA_TYPE_STRING: _JsonSchemaType.ValueType  # 3
    JSON_SCHEMA_TYPE_NUMBER: _JsonSchemaType.ValueType  # 4
    JSON_SCHEMA_TYPE_BOOLEAN: _JsonSchemaType.ValueType  # 5
    JSON_SCHEMA_TYPE_NULL: _JsonSchemaType.ValueType  # 6
    JSON_SCHEMA_TYPE_INTEGER: _JsonSchemaType.ValueType  # 7

class JsonSchemaType(_JsonSchemaType, metaclass=_JsonSchemaTypeEnumTypeWrapper):
    """JSON schema types supported in structured responses"""

JSON_SCHEMA_TYPE_UNSPECIFIED: JsonSchemaType.ValueType  # 0
JSON_SCHEMA_TYPE_OBJECT: JsonSchemaType.ValueType  # 1
JSON_SCHEMA_TYPE_ARRAY: JsonSchemaType.ValueType  # 2
JSON_SCHEMA_TYPE_STRING: JsonSchemaType.ValueType  # 3
JSON_SCHEMA_TYPE_NUMBER: JsonSchemaType.ValueType  # 4
JSON_SCHEMA_TYPE_BOOLEAN: JsonSchemaType.ValueType  # 5
JSON_SCHEMA_TYPE_NULL: JsonSchemaType.ValueType  # 6
JSON_SCHEMA_TYPE_INTEGER: JsonSchemaType.ValueType  # 7
global___JsonSchemaType = JsonSchemaType

class _ImageFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ImageFormatEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ImageFormat.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IMAGE_FORMAT_UNSPECIFIED: _ImageFormat.ValueType  # 0
    IMAGE_FORMAT_JPEG: _ImageFormat.ValueType  # 1
    IMAGE_FORMAT_PNG: _ImageFormat.ValueType  # 2
    IMAGE_FORMAT_GIF: _ImageFormat.ValueType  # 3
    IMAGE_FORMAT_WEBP: _ImageFormat.ValueType  # 4
    IMAGE_FORMAT_BMP: _ImageFormat.ValueType  # 5
    IMAGE_FORMAT_TIFF: _ImageFormat.ValueType  # 6
    IMAGE_FORMAT_SVG: _ImageFormat.ValueType  # 7

class ImageFormat(_ImageFormat, metaclass=_ImageFormatEnumTypeWrapper):
    """Image formats"""

IMAGE_FORMAT_UNSPECIFIED: ImageFormat.ValueType  # 0
IMAGE_FORMAT_JPEG: ImageFormat.ValueType  # 1
IMAGE_FORMAT_PNG: ImageFormat.ValueType  # 2
IMAGE_FORMAT_GIF: ImageFormat.ValueType  # 3
IMAGE_FORMAT_WEBP: ImageFormat.ValueType  # 4
IMAGE_FORMAT_BMP: ImageFormat.ValueType  # 5
IMAGE_FORMAT_TIFF: ImageFormat.ValueType  # 6
IMAGE_FORMAT_SVG: ImageFormat.ValueType  # 7
global___ImageFormat = ImageFormat

class _AudioFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AudioFormatEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AudioFormat.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AUDIO_FORMAT_UNSPECIFIED: _AudioFormat.ValueType  # 0
    AUDIO_FORMAT_MP3: _AudioFormat.ValueType  # 1
    AUDIO_FORMAT_WAV: _AudioFormat.ValueType  # 2
    AUDIO_FORMAT_OGG: _AudioFormat.ValueType  # 3
    AUDIO_FORMAT_M4A: _AudioFormat.ValueType  # 4
    AUDIO_FORMAT_FLAC: _AudioFormat.ValueType  # 5
    AUDIO_FORMAT_AAC: _AudioFormat.ValueType  # 6
    AUDIO_FORMAT_WMA: _AudioFormat.ValueType  # 7
    AUDIO_FORMAT_OPUS: _AudioFormat.ValueType  # 8

class AudioFormat(_AudioFormat, metaclass=_AudioFormatEnumTypeWrapper):
    """Audio formats"""

AUDIO_FORMAT_UNSPECIFIED: AudioFormat.ValueType  # 0
AUDIO_FORMAT_MP3: AudioFormat.ValueType  # 1
AUDIO_FORMAT_WAV: AudioFormat.ValueType  # 2
AUDIO_FORMAT_OGG: AudioFormat.ValueType  # 3
AUDIO_FORMAT_M4A: AudioFormat.ValueType  # 4
AUDIO_FORMAT_FLAC: AudioFormat.ValueType  # 5
AUDIO_FORMAT_AAC: AudioFormat.ValueType  # 6
AUDIO_FORMAT_WMA: AudioFormat.ValueType  # 7
AUDIO_FORMAT_OPUS: AudioFormat.ValueType  # 8
global___AudioFormat = AudioFormat

class _VideoFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _VideoFormatEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_VideoFormat.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VIDEO_FORMAT_UNSPECIFIED: _VideoFormat.ValueType  # 0
    VIDEO_FORMAT_MP4: _VideoFormat.ValueType  # 1
    VIDEO_FORMAT_AVI: _VideoFormat.ValueType  # 2
    VIDEO_FORMAT_MOV: _VideoFormat.ValueType  # 3
    VIDEO_FORMAT_MKV: _VideoFormat.ValueType  # 4
    VIDEO_FORMAT_WEBM: _VideoFormat.ValueType  # 5
    VIDEO_FORMAT_FLV: _VideoFormat.ValueType  # 6
    VIDEO_FORMAT_WMV: _VideoFormat.ValueType  # 7

class VideoFormat(_VideoFormat, metaclass=_VideoFormatEnumTypeWrapper):
    """Video formats"""

VIDEO_FORMAT_UNSPECIFIED: VideoFormat.ValueType  # 0
VIDEO_FORMAT_MP4: VideoFormat.ValueType  # 1
VIDEO_FORMAT_AVI: VideoFormat.ValueType  # 2
VIDEO_FORMAT_MOV: VideoFormat.ValueType  # 3
VIDEO_FORMAT_MKV: VideoFormat.ValueType  # 4
VIDEO_FORMAT_WEBM: VideoFormat.ValueType  # 5
VIDEO_FORMAT_FLV: VideoFormat.ValueType  # 6
VIDEO_FORMAT_WMV: VideoFormat.ValueType  # 7
global___VideoFormat = VideoFormat

class _ToolType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ToolTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ToolType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TOOL_TYPE_UNSPECIFIED: _ToolType.ValueType  # 0
    TOOL_TYPE_FUNCTION: _ToolType.ValueType  # 1
    TOOL_TYPE_RETRIEVAL: _ToolType.ValueType  # 2
    TOOL_TYPE_CODE_INTERPRETER: _ToolType.ValueType  # 3
    TOOL_TYPE_WEB_BROWSER: _ToolType.ValueType  # 4
    TOOL_TYPE_DATABASE: _ToolType.ValueType  # 5
    TOOL_TYPE_API: _ToolType.ValueType  # 6
    TOOL_TYPE_CUSTOM: _ToolType.ValueType  # 7

class ToolType(_ToolType, metaclass=_ToolTypeEnumTypeWrapper):
    """Tool types supported"""

TOOL_TYPE_UNSPECIFIED: ToolType.ValueType  # 0
TOOL_TYPE_FUNCTION: ToolType.ValueType  # 1
TOOL_TYPE_RETRIEVAL: ToolType.ValueType  # 2
TOOL_TYPE_CODE_INTERPRETER: ToolType.ValueType  # 3
TOOL_TYPE_WEB_BROWSER: ToolType.ValueType  # 4
TOOL_TYPE_DATABASE: ToolType.ValueType  # 5
TOOL_TYPE_API: ToolType.ValueType  # 6
TOOL_TYPE_CUSTOM: ToolType.ValueType  # 7
global___ToolType = ToolType

class _CacheStrategy:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CacheStrategyEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _CacheStrategy.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CACHE_STRATEGY_UNSPECIFIED: _CacheStrategy.ValueType  # 0
    CACHE_STRATEGY_HASH: _CacheStrategy.ValueType  # 1
    CACHE_STRATEGY_SEMANTIC: _CacheStrategy.ValueType  # 2
    CACHE_STRATEGY_CUSTOM: _CacheStrategy.ValueType  # 3
    CACHE_STRATEGY_PREFIX: _CacheStrategy.ValueType  # 4
    CACHE_STRATEGY_SUFFIX: _CacheStrategy.ValueType  # 5

class CacheStrategy(_CacheStrategy, metaclass=_CacheStrategyEnumTypeWrapper):
    """Cache key strategies"""

CACHE_STRATEGY_UNSPECIFIED: CacheStrategy.ValueType  # 0
CACHE_STRATEGY_HASH: CacheStrategy.ValueType  # 1
CACHE_STRATEGY_SEMANTIC: CacheStrategy.ValueType  # 2
CACHE_STRATEGY_CUSTOM: CacheStrategy.ValueType  # 3
CACHE_STRATEGY_PREFIX: CacheStrategy.ValueType  # 4
CACHE_STRATEGY_SUFFIX: CacheStrategy.ValueType  # 5
global___CacheStrategy = CacheStrategy

class _ReasoningStrategy:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ReasoningStrategyEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _ReasoningStrategy.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    REASONING_STRATEGY_UNSPECIFIED: _ReasoningStrategy.ValueType  # 0
    REASONING_STRATEGY_CHAIN_OF_THOUGHT: _ReasoningStrategy.ValueType  # 1
    REASONING_STRATEGY_TREE_OF_THOUGHTS: _ReasoningStrategy.ValueType  # 2
    REASONING_STRATEGY_GRAPH_OF_THOUGHTS: _ReasoningStrategy.ValueType  # 3
    REASONING_STRATEGY_STEP_BY_STEP: _ReasoningStrategy.ValueType  # 4
    REASONING_STRATEGY_SELF_CONSISTENCY: _ReasoningStrategy.ValueType  # 5
    REASONING_STRATEGY_LEAST_TO_MOST: _ReasoningStrategy.ValueType  # 6

class ReasoningStrategy(
    _ReasoningStrategy, metaclass=_ReasoningStrategyEnumTypeWrapper
):
    """Reasoning strategies"""

REASONING_STRATEGY_UNSPECIFIED: ReasoningStrategy.ValueType  # 0
REASONING_STRATEGY_CHAIN_OF_THOUGHT: ReasoningStrategy.ValueType  # 1
REASONING_STRATEGY_TREE_OF_THOUGHTS: ReasoningStrategy.ValueType  # 2
REASONING_STRATEGY_GRAPH_OF_THOUGHTS: ReasoningStrategy.ValueType  # 3
REASONING_STRATEGY_STEP_BY_STEP: ReasoningStrategy.ValueType  # 4
REASONING_STRATEGY_SELF_CONSISTENCY: ReasoningStrategy.ValueType  # 5
REASONING_STRATEGY_LEAST_TO_MOST: ReasoningStrategy.ValueType  # 6
global___ReasoningStrategy = ReasoningStrategy

class _DistanceMetric:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DistanceMetricEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _DistanceMetric.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DISTANCE_METRIC_UNSPECIFIED: _DistanceMetric.ValueType  # 0
    DISTANCE_METRIC_COSINE: _DistanceMetric.ValueType  # 1
    DISTANCE_METRIC_EUCLIDEAN: _DistanceMetric.ValueType  # 2
    DISTANCE_METRIC_DOT_PRODUCT: _DistanceMetric.ValueType  # 3
    DISTANCE_METRIC_MANHATTAN: _DistanceMetric.ValueType  # 4
    DISTANCE_METRIC_HAMMING: _DistanceMetric.ValueType  # 5

class DistanceMetric(_DistanceMetric, metaclass=_DistanceMetricEnumTypeWrapper):
    """Distance metrics for embeddings"""

DISTANCE_METRIC_UNSPECIFIED: DistanceMetric.ValueType  # 0
DISTANCE_METRIC_COSINE: DistanceMetric.ValueType  # 1
DISTANCE_METRIC_EUCLIDEAN: DistanceMetric.ValueType  # 2
DISTANCE_METRIC_DOT_PRODUCT: DistanceMetric.ValueType  # 3
DISTANCE_METRIC_MANHATTAN: DistanceMetric.ValueType  # 4
DISTANCE_METRIC_HAMMING: DistanceMetric.ValueType  # 5
global___DistanceMetric = DistanceMetric

class _Hyperparameter:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _HyperparameterEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _Hyperparameter.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    HYPERPARAMETER_UNSPECIFIED: _Hyperparameter.ValueType  # 0
    HYPERPARAMETER_LEARNING_RATE: _Hyperparameter.ValueType  # 1
    HYPERPARAMETER_BATCH_SIZE: _Hyperparameter.ValueType  # 2
    HYPERPARAMETER_EPOCHS: _Hyperparameter.ValueType  # 3
    HYPERPARAMETER_WARMUP_STEPS: _Hyperparameter.ValueType  # 4
    HYPERPARAMETER_WEIGHT_DECAY: _Hyperparameter.ValueType  # 5
    HYPERPARAMETER_GRADIENT_ACCUMULATION: _Hyperparameter.ValueType  # 6
    HYPERPARAMETER_LR_SCHEDULER: _Hyperparameter.ValueType  # 7
    HYPERPARAMETER_OPTIMIZER: _Hyperparameter.ValueType  # 8
    HYPERPARAMETER_DROPOUT: _Hyperparameter.ValueType  # 9
    HYPERPARAMETER_MAX_SEQUENCE_LENGTH: _Hyperparameter.ValueType  # 10

class Hyperparameter(_Hyperparameter, metaclass=_HyperparameterEnumTypeWrapper):
    """Hyperparameter types for fine-tuning"""

HYPERPARAMETER_UNSPECIFIED: Hyperparameter.ValueType  # 0
HYPERPARAMETER_LEARNING_RATE: Hyperparameter.ValueType  # 1
HYPERPARAMETER_BATCH_SIZE: Hyperparameter.ValueType  # 2
HYPERPARAMETER_EPOCHS: Hyperparameter.ValueType  # 3
HYPERPARAMETER_WARMUP_STEPS: Hyperparameter.ValueType  # 4
HYPERPARAMETER_WEIGHT_DECAY: Hyperparameter.ValueType  # 5
HYPERPARAMETER_GRADIENT_ACCUMULATION: Hyperparameter.ValueType  # 6
HYPERPARAMETER_LR_SCHEDULER: Hyperparameter.ValueType  # 7
HYPERPARAMETER_OPTIMIZER: Hyperparameter.ValueType  # 8
HYPERPARAMETER_DROPOUT: Hyperparameter.ValueType  # 9
HYPERPARAMETER_MAX_SEQUENCE_LENGTH: Hyperparameter.ValueType  # 10
global___Hyperparameter = Hyperparameter

class _ModalityDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModalityDirectionEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _ModalityDirection.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MODALITY_DIRECTION_UNSPECIFIED: _ModalityDirection.ValueType  # 0
    MODALITY_DIRECTION_INPUT_ONLY: _ModalityDirection.ValueType  # 1
    """Can only process/analyze (e.g., image analysis)"""
    MODALITY_DIRECTION_OUTPUT_ONLY: _ModalityDirection.ValueType  # 2
    """Can only generate (e.g., TTS without STT)"""
    MODALITY_DIRECTION_INPUT_OUTPUT: _ModalityDirection.ValueType  # 3
    """Can both process and generate"""

class ModalityDirection(
    _ModalityDirection, metaclass=_ModalityDirectionEnumTypeWrapper
):
    """Modality direction - whether a modality supports input, output, or both"""

MODALITY_DIRECTION_UNSPECIFIED: ModalityDirection.ValueType  # 0
MODALITY_DIRECTION_INPUT_ONLY: ModalityDirection.ValueType  # 1
"""Can only process/analyze (e.g., image analysis)"""
MODALITY_DIRECTION_OUTPUT_ONLY: ModalityDirection.ValueType  # 2
"""Can only generate (e.g., TTS without STT)"""
MODALITY_DIRECTION_INPUT_OUTPUT: ModalityDirection.ValueType  # 3
"""Can both process and generate"""
global___ModalityDirection = ModalityDirection

@typing.final
class Capability(google.protobuf.message.Message):
    """Capability represents a specific feature/ability of a model with its configuration.
    Each capability has a type and optional detailed configuration.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    STRUCTURED_RESPONSE_FIELD_NUMBER: builtins.int
    STREAMING_FIELD_NUMBER: builtins.int
    FUNCTION_CALLING_FIELD_NUMBER: builtins.int
    VISION_FIELD_NUMBER: builtins.int
    TOOL_USE_FIELD_NUMBER: builtins.int
    SYSTEM_PROMPT_FIELD_NUMBER: builtins.int
    CACHING_FIELD_NUMBER: builtins.int
    REASONING_FIELD_NUMBER: builtins.int
    AUDIO_FIELD_NUMBER: builtins.int
    VIDEO_FIELD_NUMBER: builtins.int
    EMBEDDINGS_FIELD_NUMBER: builtins.int
    FINE_TUNING_FIELD_NUMBER: builtins.int
    ADDITIONAL_INFO_FIELD_NUMBER: builtins.int
    type: global___CapabilityType.ValueType
    """The type of capability this represents.
    Example: CAPABILITY_TYPE_FUNCTION_CALLING for function/tool calling
    """
    enabled: builtins.bool
    """Whether this capability is currently enabled/available.
    Example: true if the model supports and has this feature active
    """
    additional_info: builtins.str
    """Unstructured additional information about this capability.
    Used for provider-specific details that don't fit the structured fields.
    Example: "Supports up to 10 parallel function calls with automatic retry"
    Example: "Beta feature - may have unexpected behavior"
    Example: "Optimized for conversational use cases"
    """
    @property
    def text(self) -> global___Text: ...
    @property
    def structured_response(self) -> global___StructuredResponse: ...
    @property
    def streaming(self) -> global___Streaming: ...
    @property
    def function_calling(self) -> global___FunctionCalling: ...
    @property
    def vision(self) -> global___Vision: ...
    @property
    def tool_use(self) -> global___ToolUse: ...
    @property
    def system_prompt(self) -> global___SystemPrompt: ...
    @property
    def caching(self) -> global___Caching: ...
    @property
    def reasoning(self) -> global___Reasoning: ...
    @property
    def audio(self) -> global___Audio: ...
    @property
    def video(self) -> global___Video: ...
    @property
    def embeddings(self) -> global___Embeddings: ...
    @property
    def fine_tuning(self) -> global___FineTuning: ...
    def __init__(
        self,
        *,
        type: global___CapabilityType.ValueType = ...,
        enabled: builtins.bool = ...,
        text: global___Text | None = ...,
        structured_response: global___StructuredResponse | None = ...,
        streaming: global___Streaming | None = ...,
        function_calling: global___FunctionCalling | None = ...,
        vision: global___Vision | None = ...,
        tool_use: global___ToolUse | None = ...,
        system_prompt: global___SystemPrompt | None = ...,
        caching: global___Caching | None = ...,
        reasoning: global___Reasoning | None = ...,
        audio: global___Audio | None = ...,
        video: global___Video | None = ...,
        embeddings: global___Embeddings | None = ...,
        fine_tuning: global___FineTuning | None = ...,
        additional_info: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "audio",
            b"audio",
            "caching",
            b"caching",
            "config",
            b"config",
            "embeddings",
            b"embeddings",
            "fine_tuning",
            b"fine_tuning",
            "function_calling",
            b"function_calling",
            "reasoning",
            b"reasoning",
            "streaming",
            b"streaming",
            "structured_response",
            b"structured_response",
            "system_prompt",
            b"system_prompt",
            "text",
            b"text",
            "tool_use",
            b"tool_use",
            "video",
            b"video",
            "vision",
            b"vision",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "additional_info",
            b"additional_info",
            "audio",
            b"audio",
            "caching",
            b"caching",
            "config",
            b"config",
            "embeddings",
            b"embeddings",
            "enabled",
            b"enabled",
            "fine_tuning",
            b"fine_tuning",
            "function_calling",
            b"function_calling",
            "reasoning",
            b"reasoning",
            "streaming",
            b"streaming",
            "structured_response",
            b"structured_response",
            "system_prompt",
            b"system_prompt",
            "text",
            b"text",
            "tool_use",
            b"tool_use",
            "type",
            b"type",
            "video",
            b"video",
            "vision",
            b"vision",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing.Literal["config", b"config"]
    ) -> (
        typing.Literal[
            "text",
            "structured_response",
            "streaming",
            "function_calling",
            "vision",
            "tool_use",
            "system_prompt",
            "caching",
            "reasoning",
            "audio",
            "video",
            "embeddings",
            "fine_tuning",
        ]
        | None
    ): ...

global___Capability = Capability

@typing.final
class Text(google.protobuf.message.Message):
    """Text capability configuration for basic text input/output"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIRECTION_FIELD_NUMBER: builtins.int
    MAX_INPUT_LENGTH_FIELD_NUMBER: builtins.int
    MAX_OUTPUT_LENGTH_FIELD_NUMBER: builtins.int
    SUPPORTED_LANGUAGES_FIELD_NUMBER: builtins.int
    SUPPORTS_CONVERSATION_FIELD_NUMBER: builtins.int
    SUPPORTS_CONTEXT_FIELD_NUMBER: builtins.int
    direction: global___ModalityDirection.ValueType
    """Direction of text support (input, output, or both)
    Example: MODALITY_DIRECTION_INPUT_OUTPUT for chat models
    """
    max_input_length: builtins.int
    """Maximum input text length in characters (if limited)
    Example: 32000 for models with character limits
    """
    max_output_length: builtins.int
    """Maximum output text length in characters (if limited)
    Example: 4096 for models with output limits
    """
    supports_conversation: builtins.bool
    """Whether the model supports multi-turn conversations
    Example: true for chat models, false for completion-only models
    """
    supports_context: builtins.bool
    """Whether the model can maintain context across messages
    Example: true for stateful models
    """
    @property
    def supported_languages(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Supported languages for text processing
        Examples: ["en", "es", "fr", "de", "zh", "ja"]
        """

    def __init__(
        self,
        *,
        direction: global___ModalityDirection.ValueType = ...,
        max_input_length: builtins.int = ...,
        max_output_length: builtins.int = ...,
        supported_languages: collections.abc.Iterable[builtins.str] | None = ...,
        supports_conversation: builtins.bool = ...,
        supports_context: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "direction",
            b"direction",
            "max_input_length",
            b"max_input_length",
            "max_output_length",
            b"max_output_length",
            "supported_languages",
            b"supported_languages",
            "supports_context",
            b"supports_context",
            "supports_conversation",
            b"supports_conversation",
        ],
    ) -> None: ...

global___Text = Text

@typing.final
class StructuredResponse(google.protobuf.message.Message):
    """Structured response capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SYSTEM_PROMPT_HINT_FIELD_NUMBER: builtins.int
    SUPPORTED_FORMATS_FIELD_NUMBER: builtins.int
    MAX_SCHEMA_DEPTH_FIELD_NUMBER: builtins.int
    REQUIRES_TOOL_USE_FIELD_NUMBER: builtins.int
    REQUIRES_JSON_MODE_FIELD_NUMBER: builtins.int
    MAX_PROPERTIES_FIELD_NUMBER: builtins.int
    SUPPORTED_TYPES_FIELD_NUMBER: builtins.int
    SUPPORTS_STREAMING_FIELD_NUMBER: builtins.int
    system_prompt_hint: builtins.str
    """Optional guidance to include in the system prompt to elicit structured output
    Example: "Always return valid JSON matching the provided schema"
    """
    max_schema_depth: builtins.int
    """Maximum allowed nesting depth for JSON schema objects/arrays
    Example: 5 for moderately complex schemas
    """
    requires_tool_use: builtins.bool
    """Whether structured output requires tool/function use (vs. direct generation)
    Example: true for providers that only return JSON via tool calls
    """
    requires_json_mode: builtins.bool
    """Whether the model must be in a special "JSON mode" to honor schemas
    Example: true for models that enforce strict JSON output when enabled
    """
    max_properties: builtins.int
    """Maximum number of top-level properties in object schemas
    Example: 50
    """
    supports_streaming: builtins.bool
    """Can stream structured responses (not just generate them)
    Example: true if partial JSON chunks are streamed
    Can stream structured responses (not just generate them)
    """
    @property
    def supported_formats(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___DataFormat.ValueType
    ]:
        """Supported output formats for structured responses
        Examples: [DATA_FORMAT_JSON, DATA_FORMAT_YAML]
        """

    @property
    def supported_types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___JsonSchemaType.ValueType
    ]:
        """JSON Schema primitive/types supported by the model
        Examples: [JSON_SCHEMA_TYPE_OBJECT, JSON_SCHEMA_TYPE_ARRAY, JSON_SCHEMA_TYPE_STRING]
        """

    def __init__(
        self,
        *,
        system_prompt_hint: builtins.str = ...,
        supported_formats: collections.abc.Iterable[global___DataFormat.ValueType]
        | None = ...,
        max_schema_depth: builtins.int = ...,
        requires_tool_use: builtins.bool = ...,
        requires_json_mode: builtins.bool = ...,
        max_properties: builtins.int = ...,
        supported_types: collections.abc.Iterable[global___JsonSchemaType.ValueType]
        | None = ...,
        supports_streaming: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "max_properties",
            b"max_properties",
            "max_schema_depth",
            b"max_schema_depth",
            "requires_json_mode",
            b"requires_json_mode",
            "requires_tool_use",
            b"requires_tool_use",
            "supported_formats",
            b"supported_formats",
            "supported_types",
            b"supported_types",
            "supports_streaming",
            b"supports_streaming",
            "system_prompt_hint",
            b"system_prompt_hint",
        ],
    ) -> None: ...

global___StructuredResponse = StructuredResponse

@typing.final
class Streaming(google.protobuf.message.Message):
    """Streaming capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_DELIMITER_FIELD_NUMBER: builtins.int
    BUFFER_SIZE_FIELD_NUMBER: builtins.int
    SUPPORTS_SSE_FIELD_NUMBER: builtins.int
    SUPPORTS_USAGE_FIELD_NUMBER: builtins.int
    AVG_CHUNK_SIZE_BYTES_FIELD_NUMBER: builtins.int
    MAX_CHUNK_DELAY_MS_FIELD_NUMBER: builtins.int
    chunk_delimiter: builtins.str
    """Delimiter used between streamed chunks, if any
    Example: "\\n\\n" for event-stream boundaries
    """
    buffer_size: builtins.int
    """Preferred buffer size used by the provider when batching output
    Example: 1024 (bytes)
    """
    supports_sse: builtins.bool
    """Whether Server-Sent Events (SSE) is supported
    Example: true if provider uses text/event-stream
    """
    supports_usage: builtins.bool
    """Whether token usage info can be emitted incrementally during streaming
    Example: true if usage deltas are included in stream
    """
    avg_chunk_size_bytes: builtins.int
    """Typical size of individual streamed chunks in bytes
    Example: 256
    """
    max_chunk_delay_ms: builtins.int
    """Maximum delay between streamed chunks in milliseconds
    Example: 200
    """
    def __init__(
        self,
        *,
        chunk_delimiter: builtins.str = ...,
        buffer_size: builtins.int = ...,
        supports_sse: builtins.bool = ...,
        supports_usage: builtins.bool = ...,
        avg_chunk_size_bytes: builtins.int = ...,
        max_chunk_delay_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "avg_chunk_size_bytes",
            b"avg_chunk_size_bytes",
            "buffer_size",
            b"buffer_size",
            "chunk_delimiter",
            b"chunk_delimiter",
            "max_chunk_delay_ms",
            b"max_chunk_delay_ms",
            "supports_sse",
            b"supports_sse",
            "supports_usage",
            b"supports_usage",
        ],
    ) -> None: ...

global___Streaming = Streaming

@typing.final
class FunctionCalling(google.protobuf.message.Message):
    """Function calling capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_FUNCTIONS_FIELD_NUMBER: builtins.int
    MAX_PARALLEL_CALLS_FIELD_NUMBER: builtins.int
    SUPPORTS_PARALLEL_FIELD_NUMBER: builtins.int
    REQUIRES_TOOL_ROLE_FIELD_NUMBER: builtins.int
    SUPPORTS_STREAMING_FIELD_NUMBER: builtins.int
    SUPPORTED_PARAMETER_TYPES_FIELD_NUMBER: builtins.int
    MAX_NESTING_DEPTH_FIELD_NUMBER: builtins.int
    max_functions: builtins.int
    """Maximum number of functions that can be registered per request
    Example: 128
    """
    max_parallel_calls: builtins.int
    """Maximum number of tool/function calls that may be executed in parallel
    Example: 5
    """
    supports_parallel: builtins.bool
    """Whether the model can plan and invoke multiple tools concurrently
    Example: true for models with parallel tool-use orchestration
    """
    requires_tool_role: builtins.bool
    """Whether requests must use a special "tool" role or channel for calls
    Example: true if provider requires tool role messages
    """
    supports_streaming: builtins.bool
    """Whether intermediate tool call tokens/results are streamable
    Example: true if tool call arguments/results are streamed as they are produced
    """
    max_nesting_depth: builtins.int
    """Maximum nesting depth allowed for function/tool call plans
    Example: 3 for limited recursion
    """
    @property
    def supported_parameter_types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___JsonSchemaType.ValueType
    ]:
        """JSON schema types supported for function parameters
        Examples: [JSON_SCHEMA_TYPE_OBJECT, JSON_SCHEMA_TYPE_ARRAY, JSON_SCHEMA_TYPE_STRING]
        """

    def __init__(
        self,
        *,
        max_functions: builtins.int = ...,
        max_parallel_calls: builtins.int = ...,
        supports_parallel: builtins.bool = ...,
        requires_tool_role: builtins.bool = ...,
        supports_streaming: builtins.bool = ...,
        supported_parameter_types: collections.abc.Iterable[
            global___JsonSchemaType.ValueType
        ]
        | None = ...,
        max_nesting_depth: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "max_functions",
            b"max_functions",
            "max_nesting_depth",
            b"max_nesting_depth",
            "max_parallel_calls",
            b"max_parallel_calls",
            "requires_tool_role",
            b"requires_tool_role",
            "supported_parameter_types",
            b"supported_parameter_types",
            "supports_parallel",
            b"supports_parallel",
            "supports_streaming",
            b"supports_streaming",
        ],
    ) -> None: ...

global___FunctionCalling = FunctionCalling

@typing.final
class Vision(google.protobuf.message.Message):
    """Vision capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIRECTION_FIELD_NUMBER: builtins.int
    SUPPORTED_FORMATS_FIELD_NUMBER: builtins.int
    MAX_IMAGE_SIZE_BYTES_FIELD_NUMBER: builtins.int
    MAX_IMAGES_PER_REQUEST_FIELD_NUMBER: builtins.int
    MAX_RESOLUTION_WIDTH_FIELD_NUMBER: builtins.int
    MAX_RESOLUTION_HEIGHT_FIELD_NUMBER: builtins.int
    SUPPORTS_OCR_FIELD_NUMBER: builtins.int
    SUPPORTS_OBJECT_DETECTION_FIELD_NUMBER: builtins.int
    SUPPORTS_VIDEO_FRAMES_FIELD_NUMBER: builtins.int
    direction: global___ModalityDirection.ValueType
    """Direction of vision support
    Example: MODALITY_DIRECTION_INPUT_ONLY for analysis-only models
    Example: MODALITY_DIRECTION_OUTPUT_ONLY for image generation models (DALL-E)
    Example: MODALITY_DIRECTION_INPUT_OUTPUT for models that can both analyze and generate
    """
    max_image_size_bytes: builtins.int
    """Maximum size per image in bytes
    Example: 20971520 (20MB) for GPT-4-vision
    """
    max_images_per_request: builtins.int
    """Maximum images per API request (for input)
    Example: 10 for GPT-4-vision, 1 for some models
    """
    max_resolution_width: builtins.int
    """Maximum image width in pixels
    Example: 4096 for high-resolution support
    """
    max_resolution_height: builtins.int
    """Maximum image height in pixels
    Example: 4096 for high-resolution support
    """
    supports_ocr: builtins.bool
    """Supports optical character recognition
    Example: true if model can extract text from images
    """
    supports_object_detection: builtins.bool
    """Supports object detection/localization
    Example: true if model can identify and locate objects
    """
    supports_video_frames: builtins.bool
    """Can process video frames as images
    Example: true if model accepts video frame extraction
    """
    @property
    def supported_formats(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___ImageFormat.ValueType
    ]:
        """Supported image file formats
        Examples: [IMAGE_FORMAT_JPEG, IMAGE_FORMAT_PNG, IMAGE_FORMAT_WEBP]
        """

    def __init__(
        self,
        *,
        direction: global___ModalityDirection.ValueType = ...,
        supported_formats: collections.abc.Iterable[global___ImageFormat.ValueType]
        | None = ...,
        max_image_size_bytes: builtins.int = ...,
        max_images_per_request: builtins.int = ...,
        max_resolution_width: builtins.int = ...,
        max_resolution_height: builtins.int = ...,
        supports_ocr: builtins.bool = ...,
        supports_object_detection: builtins.bool = ...,
        supports_video_frames: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "direction",
            b"direction",
            "max_image_size_bytes",
            b"max_image_size_bytes",
            "max_images_per_request",
            b"max_images_per_request",
            "max_resolution_height",
            b"max_resolution_height",
            "max_resolution_width",
            b"max_resolution_width",
            "supported_formats",
            b"supported_formats",
            "supports_object_detection",
            b"supports_object_detection",
            "supports_ocr",
            b"supports_ocr",
            "supports_video_frames",
            b"supports_video_frames",
        ],
    ) -> None: ...

global___Vision = Vision

@typing.final
class ToolUse(google.protobuf.message.Message):
    """Tool use capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_TOOLS_FIELD_NUMBER: builtins.int
    SUPPORTS_SEQUENTIAL_FIELD_NUMBER: builtins.int
    SUPPORTS_PARALLEL_FIELD_NUMBER: builtins.int
    MAX_TOOL_ROUNDS_FIELD_NUMBER: builtins.int
    SUPPORTED_TOOL_TYPES_FIELD_NUMBER: builtins.int
    max_tools: builtins.int
    """Maximum number of tools that can be registered or considered
    Example: 64
    """
    supports_sequential: builtins.bool
    """Whether the model can chain tool invocations one after another
    Example: true for stepwise tool planning
    """
    supports_parallel: builtins.bool
    """Whether the model can invoke multiple tools concurrently
    Example: true for parallelized tool execution
    """
    max_tool_rounds: builtins.int
    """Maximum number of tool-use rounds allowed in a single request
    Example: 10
    """
    @property
    def supported_tool_types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___ToolType.ValueType
    ]:
        """Types of tools supported by the provider/model
        Examples: [TOOL_TYPE_FUNCTION, TOOL_TYPE_RETRIEVAL]
        """

    def __init__(
        self,
        *,
        max_tools: builtins.int = ...,
        supports_sequential: builtins.bool = ...,
        supports_parallel: builtins.bool = ...,
        max_tool_rounds: builtins.int = ...,
        supported_tool_types: collections.abc.Iterable[global___ToolType.ValueType]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "max_tool_rounds",
            b"max_tool_rounds",
            "max_tools",
            b"max_tools",
            "supported_tool_types",
            b"supported_tool_types",
            "supports_parallel",
            b"supports_parallel",
            "supports_sequential",
            b"supports_sequential",
        ],
    ) -> None: ...

global___ToolUse = ToolUse

@typing.final
class SystemPrompt(google.protobuf.message.Message):
    """System prompt capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_LENGTH_FIELD_NUMBER: builtins.int
    SUPPORTS_MULTIPLE_FIELD_NUMBER: builtins.int
    SUPPORTS_CACHING_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    max_length: builtins.int
    """Maximum allowed length of system prompt content (characters or tokens)
    Example: 8000 (characters)
    """
    supports_multiple: builtins.bool
    """Whether multiple system prompts (or segments) can be supplied
    Example: true if the provider supports multiple system messages
    """
    supports_caching: builtins.bool
    """Whether system prompts can be cached for re-use
    Example: true if provider supports prompt caching hints
    """
    format: global___DataFormat.ValueType
    """Preferred/required format for system prompts (plain, markdown, etc.)
    Example: DATA_FORMAT_MARKDOWN
    """
    def __init__(
        self,
        *,
        max_length: builtins.int = ...,
        supports_multiple: builtins.bool = ...,
        supports_caching: builtins.bool = ...,
        format: global___DataFormat.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "format",
            b"format",
            "max_length",
            b"max_length",
            "supports_caching",
            b"supports_caching",
            "supports_multiple",
            b"supports_multiple",
        ],
    ) -> None: ...

global___SystemPrompt = SystemPrompt

@typing.final
class Caching(google.protobuf.message.Message):
    """Caching capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CACHE_KEY_STRATEGY_FIELD_NUMBER: builtins.int
    MAX_CACHE_SIZE_BYTES_FIELD_NUMBER: builtins.int
    CACHE_TTL_SECONDS_FIELD_NUMBER: builtins.int
    SUPPORTS_CONTEXT_CACHING_FIELD_NUMBER: builtins.int
    SUPPORTS_PROMPT_CACHING_FIELD_NUMBER: builtins.int
    MIN_CACHEABLE_TOKENS_FIELD_NUMBER: builtins.int
    cache_key_strategy: global___CacheStrategy.ValueType
    """Strategy used to compute cache keys for requests/responses
    Examples: CACHE_STRATEGY_HASH, CACHE_STRATEGY_SEMANTIC
    """
    max_cache_size_bytes: builtins.int
    """Maximum total cache capacity (bytes)
    Example: 1073741824 for 1GB
    """
    cache_ttl_seconds: builtins.int
    """Default time-to-live for cache entries (seconds)
    Example: 3600 for 1 hour
    """
    supports_context_caching: builtins.bool
    """Whether the model/provider supports caching of conversation context
    Example: true for context window reuse
    """
    supports_prompt_caching: builtins.bool
    """Whether the model/provider supports caching of prompts/prefixes
    Example: true for prefix caching/token reuse
    """
    min_cacheable_tokens: builtins.int
    """Minimum number of tokens required for an entry to be cacheable
    Example: 128
    """
    def __init__(
        self,
        *,
        cache_key_strategy: global___CacheStrategy.ValueType = ...,
        max_cache_size_bytes: builtins.int = ...,
        cache_ttl_seconds: builtins.int = ...,
        supports_context_caching: builtins.bool = ...,
        supports_prompt_caching: builtins.bool = ...,
        min_cacheable_tokens: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "cache_key_strategy",
            b"cache_key_strategy",
            "cache_ttl_seconds",
            b"cache_ttl_seconds",
            "max_cache_size_bytes",
            b"max_cache_size_bytes",
            "min_cacheable_tokens",
            b"min_cacheable_tokens",
            "supports_context_caching",
            b"supports_context_caching",
            "supports_prompt_caching",
            b"supports_prompt_caching",
        ],
    ) -> None: ...

global___Caching = Caching

@typing.final
class Reasoning(google.protobuf.message.Message):
    """Reasoning capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUPPORTS_CHAIN_OF_THOUGHT_FIELD_NUMBER: builtins.int
    SUPPORTS_STEP_TRACKING_FIELD_NUMBER: builtins.int
    MAX_REASONING_STEPS_FIELD_NUMBER: builtins.int
    SUPPORTS_SELF_CORRECTION_FIELD_NUMBER: builtins.int
    REASONING_STRATEGIES_FIELD_NUMBER: builtins.int
    supports_chain_of_thought: builtins.bool
    """Whether the model can produce hidden chain-of-thought/assistant reasoning
    Example: true for models supporting private CoT traces
    """
    supports_step_tracking: builtins.bool
    """Whether the model can expose discrete step indices or markers
    Example: true for models that number reasoning steps
    """
    max_reasoning_steps: builtins.int
    """Maximum number of internal reasoning steps supported
    Example: 64
    """
    supports_self_correction: builtins.bool
    """Whether the model can revise earlier steps based on later insights
    Example: true for self-correction/self-reflection
    """
    @property
    def reasoning_strategies(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___ReasoningStrategy.ValueType
    ]:
        """Supported high-level reasoning strategies
        Examples: [REASONING_STRATEGY_STEP_BY_STEP, REASONING_STRATEGY_SELF_CONSISTENCY]
        """

    def __init__(
        self,
        *,
        supports_chain_of_thought: builtins.bool = ...,
        supports_step_tracking: builtins.bool = ...,
        max_reasoning_steps: builtins.int = ...,
        supports_self_correction: builtins.bool = ...,
        reasoning_strategies: collections.abc.Iterable[
            global___ReasoningStrategy.ValueType
        ]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "max_reasoning_steps",
            b"max_reasoning_steps",
            "reasoning_strategies",
            b"reasoning_strategies",
            "supports_chain_of_thought",
            b"supports_chain_of_thought",
            "supports_self_correction",
            b"supports_self_correction",
            "supports_step_tracking",
            b"supports_step_tracking",
        ],
    ) -> None: ...

global___Reasoning = Reasoning

@typing.final
class Audio(google.protobuf.message.Message):
    """Audio capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIRECTION_FIELD_NUMBER: builtins.int
    SUPPORTED_FORMATS_FIELD_NUMBER: builtins.int
    MAX_DURATION_SECONDS_FIELD_NUMBER: builtins.int
    MAX_FILE_SIZE_BYTES_FIELD_NUMBER: builtins.int
    SUPPORTED_LANGUAGES_FIELD_NUMBER: builtins.int
    SUPPORTS_STREAMING_FIELD_NUMBER: builtins.int
    SUPPORTS_VOICE_SELECTION_FIELD_NUMBER: builtins.int
    direction: global___ModalityDirection.ValueType
    """Direction of audio support
    Example: MODALITY_DIRECTION_INPUT_ONLY for speech-to-text only
    Example: MODALITY_DIRECTION_OUTPUT_ONLY for text-to-speech only
    Example: MODALITY_DIRECTION_INPUT_OUTPUT for models supporting both STT and TTS
    """
    max_duration_seconds: builtins.int
    """Maximum audio duration in seconds
    Example: 600 for 10-minute limit
    """
    max_file_size_bytes: builtins.int
    """Maximum audio file size in bytes
    Example: 26214400 (25MB) limit
    """
    supports_streaming: builtins.bool
    """Supports real-time streaming (for live audio)
    Example: true for real-time voice models
    """
    supports_voice_selection: builtins.bool
    """Supports voice cloning or voice selection
    Example: true if TTS can use different voices
    """
    @property
    def supported_formats(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___AudioFormat.ValueType
    ]:
        """Supported audio file formats
        Examples: [AUDIO_FORMAT_MP3, AUDIO_FORMAT_WAV, AUDIO_FORMAT_M4A]
        """

    @property
    def supported_languages(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Supported languages for audio processing
        Examples: ["en", "es", "fr", "de", "zh", "ja"]
        """

    def __init__(
        self,
        *,
        direction: global___ModalityDirection.ValueType = ...,
        supported_formats: collections.abc.Iterable[global___AudioFormat.ValueType]
        | None = ...,
        max_duration_seconds: builtins.int = ...,
        max_file_size_bytes: builtins.int = ...,
        supported_languages: collections.abc.Iterable[builtins.str] | None = ...,
        supports_streaming: builtins.bool = ...,
        supports_voice_selection: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "direction",
            b"direction",
            "max_duration_seconds",
            b"max_duration_seconds",
            "max_file_size_bytes",
            b"max_file_size_bytes",
            "supported_formats",
            b"supported_formats",
            "supported_languages",
            b"supported_languages",
            "supports_streaming",
            b"supports_streaming",
            "supports_voice_selection",
            b"supports_voice_selection",
        ],
    ) -> None: ...

global___Audio = Audio

@typing.final
class Video(google.protobuf.message.Message):
    """Video capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIRECTION_FIELD_NUMBER: builtins.int
    SUPPORTED_FORMATS_FIELD_NUMBER: builtins.int
    MAX_DURATION_SECONDS_FIELD_NUMBER: builtins.int
    MAX_FILE_SIZE_BYTES_FIELD_NUMBER: builtins.int
    MAX_FPS_FIELD_NUMBER: builtins.int
    SUPPORTS_FRAME_EXTRACTION_FIELD_NUMBER: builtins.int
    MAX_FRAMES_FIELD_NUMBER: builtins.int
    direction: global___ModalityDirection.ValueType
    """Direction of video support
    Example: MODALITY_DIRECTION_INPUT_ONLY for video analysis/understanding
    Example: MODALITY_DIRECTION_OUTPUT_ONLY for video generation
    Example: MODALITY_DIRECTION_INPUT_OUTPUT for models that can both analyze and generate
    """
    max_duration_seconds: builtins.int
    """Maximum video duration in seconds
    Example: 120 for 2-minute limit
    """
    max_file_size_bytes: builtins.int
    """Maximum video file size in bytes
    Example: 1073741824 (1GB) limit
    """
    max_fps: builtins.int
    """Maximum frames per second supported
    Example: 30 for standard frame rate
    """
    supports_frame_extraction: builtins.bool
    """Supports extracting and analyzing individual frames
    Example: true if model can process video as a sequence of images
    """
    max_frames: builtins.int
    """Maximum number of frames that can be analyzed
    Example: 100 for frame-by-frame analysis limit
    """
    @property
    def supported_formats(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___VideoFormat.ValueType
    ]:
        """Supported video file formats
        Examples: [VIDEO_FORMAT_MP4, VIDEO_FORMAT_MOV, VIDEO_FORMAT_AVI]
        """

    def __init__(
        self,
        *,
        direction: global___ModalityDirection.ValueType = ...,
        supported_formats: collections.abc.Iterable[global___VideoFormat.ValueType]
        | None = ...,
        max_duration_seconds: builtins.int = ...,
        max_file_size_bytes: builtins.int = ...,
        max_fps: builtins.int = ...,
        supports_frame_extraction: builtins.bool = ...,
        max_frames: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "direction",
            b"direction",
            "max_duration_seconds",
            b"max_duration_seconds",
            "max_file_size_bytes",
            b"max_file_size_bytes",
            "max_fps",
            b"max_fps",
            "max_frames",
            b"max_frames",
            "supported_formats",
            b"supported_formats",
            "supports_frame_extraction",
            b"supports_frame_extraction",
        ],
    ) -> None: ...

global___Video = Video

@typing.final
class Embeddings(google.protobuf.message.Message):
    """Embeddings capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMBEDDING_DIMENSIONS_FIELD_NUMBER: builtins.int
    MAX_INPUT_TOKENS_FIELD_NUMBER: builtins.int
    SUPPORTS_BATCH_FIELD_NUMBER: builtins.int
    MAX_BATCH_SIZE_FIELD_NUMBER: builtins.int
    DISTANCE_METRICS_FIELD_NUMBER: builtins.int
    embedding_dimensions: builtins.int
    """Dimensionality of the vector space produced by the model
    Example: 1536
    """
    max_input_tokens: builtins.int
    """Maximum number of tokens accepted per input item
    Example: 8192
    """
    supports_batch: builtins.bool
    """Whether the API supports batching multiple inputs in one call
    Example: true
    """
    max_batch_size: builtins.int
    """Maximum number of items allowed per batch
    Example: 128
    """
    @property
    def distance_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___DistanceMetric.ValueType
    ]:
        """Supported similarity/distance metrics for index/search
        Examples: [DISTANCE_METRIC_COSINE, DISTANCE_METRIC_DOT_PRODUCT]
        """

    def __init__(
        self,
        *,
        embedding_dimensions: builtins.int = ...,
        max_input_tokens: builtins.int = ...,
        supports_batch: builtins.bool = ...,
        max_batch_size: builtins.int = ...,
        distance_metrics: collections.abc.Iterable[global___DistanceMetric.ValueType]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "distance_metrics",
            b"distance_metrics",
            "embedding_dimensions",
            b"embedding_dimensions",
            "max_batch_size",
            b"max_batch_size",
            "max_input_tokens",
            b"max_input_tokens",
            "supports_batch",
            b"supports_batch",
        ],
    ) -> None: ...

global___Embeddings = Embeddings

@typing.final
class FineTuning(google.protobuf.message.Message):
    """Fine-tuning capability configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_EXAMPLES_FIELD_NUMBER: builtins.int
    MAX_EXAMPLES_FIELD_NUMBER: builtins.int
    SUPPORTED_FORMATS_FIELD_NUMBER: builtins.int
    MAX_FILE_SIZE_MB_FIELD_NUMBER: builtins.int
    SUPPORTS_VALIDATION_SET_FIELD_NUMBER: builtins.int
    HYPERPARAMETERS_FIELD_NUMBER: builtins.int
    min_examples: builtins.int
    """Minimum number of training examples required to start fine-tuning
    Example: 50
    """
    max_examples: builtins.int
    """Maximum number of training examples supported in a single job
    Example: 500000
    """
    max_file_size_mb: builtins.int
    """Maximum size of individual training files (MB)
    Example: 512
    """
    supports_validation_set: builtins.bool
    """Whether a separate validation set can be provided
    Example: true
    """
    @property
    def supported_formats(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___DataFormat.ValueType
    ]:
        """Supported dataset/file formats for fine-tuning
        Examples: [DATA_FORMAT_JSONL, DATA_FORMAT_CSV]
        """

    @property
    def hyperparameters(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___Hyperparameter.ValueType
    ]:
        """Hyperparameters that can be configured for training
        Examples: [HYPERPARAMETER_LEARNING_RATE, HYPERPARAMETER_EPOCHS]
        """

    def __init__(
        self,
        *,
        min_examples: builtins.int = ...,
        max_examples: builtins.int = ...,
        supported_formats: collections.abc.Iterable[global___DataFormat.ValueType]
        | None = ...,
        max_file_size_mb: builtins.int = ...,
        supports_validation_set: builtins.bool = ...,
        hyperparameters: collections.abc.Iterable[global___Hyperparameter.ValueType]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "hyperparameters",
            b"hyperparameters",
            "max_examples",
            b"max_examples",
            "max_file_size_mb",
            b"max_file_size_mb",
            "min_examples",
            b"min_examples",
            "supported_formats",
            b"supported_formats",
            "supports_validation_set",
            b"supports_validation_set",
        ],
    ) -> None: ...

global___FineTuning = FineTuning
