"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import weaveapi.llmx.v1.architecture_pb2
import weaveapi.llmx.v1.capabilities_pb2
import weaveapi.llmx.v1.pricing_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Model(google.protobuf.message.Message):
    """Model represents a complete AI model with all its metadata, capabilities, and pricing.
    This is the primary entity for model discovery and comparison.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PROVIDER_ID_FIELD_NUMBER: builtins.int
    PROVIDER_SLUG_FIELD_NUMBER: builtins.int
    PROVIDER_NAME_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    SLUG_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    RELEASE_DATE_FIELD_NUMBER: builtins.int
    TRAINING_DATA_CUTOFF_FIELD_NUMBER: builtins.int
    DEPRECATION_DATE_FIELD_NUMBER: builtins.int
    CAPABILITIES_FIELD_NUMBER: builtins.int
    CLASSIFICATION_FIELD_NUMBER: builtins.int
    PERFORMANCE_FIELD_NUMBER: builtins.int
    TOKENS_FIELD_NUMBER: builtins.int
    PRICING_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    API_DETAILS_FIELD_NUMBER: builtins.int
    AVAILABILITY_FIELD_NUMBER: builtins.int
    ARCHITECTURE_FIELD_NUMBER: builtins.int
    TRAINING_FIELD_NUMBER: builtins.int
    SAFETY_FIELD_NUMBER: builtins.int
    LICENSING_FIELD_NUMBER: builtins.int
    TECHNICAL_SPECS_FIELD_NUMBER: builtins.int
    LAST_SCRAPED_AT_FIELD_NUMBER: builtins.int
    DATA_SOURCES_FIELD_NUMBER: builtins.int
    IS_ACTIVE_FIELD_NUMBER: builtins.int
    IS_DEPRECATED_FIELD_NUMBER: builtins.int
    REPLACEMENT_MODEL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique internal identifier for this model record in our database.
    Example: "mdl_01234567-89ab-cdef-0123-456789abcdef"
    Generated by our system, not provider-specific
    """
    provider_id: builtins.str
    """Provider's unique identifier in our system.
    Example: "pvd_openai_2024", "pvd_anthropic_2024"
    Links to Provider entity
    """
    provider_slug: builtins.str
    """URL-friendly provider identifier for routing.
    Examples: "openai", "anthropic", "google", "meta"
    Used in API paths like /models/openai/gpt-4
    """
    provider_name: builtins.str
    """Human-readable provider name for display.
    Examples: "OpenAI", "Anthropic", "Google AI", "Meta AI"
    """
    model_id: builtins.str
    """Provider's specific model identifier as they define it.
    Examples: "gpt-4-turbo-2024-04-09", "claude-3-opus-20240229"
    This is what you use in their API calls
    """
    slug: builtins.str
    """Combined provider/model identifier for unique referencing.
    Format: "{provider_slug}/{model_id}"
    Examples: "openai/gpt-4", "anthropic/claude-3-opus"
    """
    name: builtins.str
    """Model's full technical name from the provider.
    Examples: "gpt-4-turbo-2024-04-09", "claude-3-opus-20240229"
    May include version dates or technical details
    """
    display_name: builtins.str
    """User-friendly display name for UI presentation.
    Examples: "GPT-4 Turbo", "Claude 3 Opus", "Gemini Pro"
    Simplified version of technical name
    """
    description: builtins.str
    """Human-readable description of the model's purpose and capabilities.
    Example: "Most capable GPT-4 model, optimized for complex tasks requiring
    advanced reasoning, coding, and creative writing. Supports vision, function
    calling, and JSON mode."
    """
    version: builtins.str
    """Model version string from provider.
    Examples: "2024-04-09", "v1.0", "preview-0125"
    May be date-based or semantic versioning
    """
    is_active: builtins.bool
    """Whether the model is currently available for use.
    false if model is down, in maintenance, or discontinued
    """
    is_deprecated: builtins.bool
    """Whether the model has been officially deprecated.
    true once deprecation_date has passed or provider announces EOL
    """
    replacement_model_id: builtins.str
    """If deprecated, the recommended replacement model's ID.
    Example: "mdl_gpt4_turbo_2024" replacing "mdl_gpt4_2023"
    Helps with migration paths
    """
    @property
    def release_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """=== Temporal Information ===

        When the model was publicly released by the provider.
        Example: 2024-04-09 for GPT-4 Turbo April release
        """

    @property
    def training_data_cutoff(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Last date of data used in training (knowledge cutoff).
        Example: 2023-12-01 means model knows events up to this date
        Important for factual queries and current events
        """

    @property
    def deprecation_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the model will be/was deprecated (if scheduled).
        Example: 2025-01-15 for planned sunset
        Null if no deprecation planned
        """

    @property
    def capabilities(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.llmx.v1.capabilities_pb2.Capability
    ]:
        """=== Core Properties ===

        List of specific capabilities this model supports.
        Examples: text_generation, function_calling, vision, code_interpreter
        See capabilities.proto for full enumeration
        """

    @property
    def classification(self) -> global___ModelClassification:
        """Model type, architecture, and licensing classification.
        Categorizes the model for filtering and comparison
        """

    @property
    def performance(self) -> global___ModelPerformance:
        """Benchmark scores and performance metrics.
        Standardized scores for comparing model capabilities
        """

    @property
    def tokens(self) -> global___TokenInfo:
        """Token limits, processing speed, and tokenizer information.
        Critical for understanding model constraints
        """

    @property
    def pricing(self) -> weaveapi.llmx.v1.pricing_pb2.Pricing:
        """Complete pricing structure for all operations.
        Includes standard, batch, cached, and tool pricing
        """

    @property
    def configuration(self) -> global___Configuration:
        """Supported parameter ranges for generation.
        Temperature, top_p, and other sampling parameters
        """

    @property
    def api_details(self) -> global___APIDetails:
        """=== Integration Details ===

        API endpoint information and rate limits.
        Everything needed to call the model programmatically
        """

    @property
    def availability(self) -> global___Availability:
        """Available regions and platforms.
        Where and how the model can be accessed
        """

    @property
    def architecture(self) -> weaveapi.llmx.v1.architecture_pb2.Architecture:
        """=== Technical Details ===

        Technical architecture information.
        Transformer type, layer count, attention mechanism, etc.
        """

    @property
    def training(self) -> weaveapi.llmx.v1.architecture_pb2.Training:
        """Training dataset and methodology information.
        How the model was trained and on what data
        """

    @property
    def safety(self) -> weaveapi.llmx.v1.architecture_pb2.Safety:
        """Built-in safety features and content filtering.
        Moderation capabilities and safety guardrails
        """

    @property
    def licensing(self) -> weaveapi.llmx.v1.architecture_pb2.Licensing:
        """License type and usage restrictions.
        Legal terms for using the model
        """

    @property
    def technical_specs(self) -> weaveapi.llmx.v1.architecture_pb2.TechnicalSpecs:
        """Hardware requirements and technical details.
        Memory, compute requirements for self-hosting
        """

    @property
    def last_scraped_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """=== Metadata ===

        When this model information was last updated in our system.
        Example: 2024-08-25T10:30:00Z
        For tracking data freshness
        """

    @property
    def data_sources(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Sources where this model information was collected from.
        Examples: ["https://openai.com/pricing", "https://platform.openai.com/docs"]
        For data provenance and verification
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        provider_id: builtins.str = ...,
        provider_slug: builtins.str = ...,
        provider_name: builtins.str = ...,
        model_id: builtins.str = ...,
        slug: builtins.str = ...,
        name: builtins.str = ...,
        display_name: builtins.str = ...,
        description: builtins.str = ...,
        version: builtins.str = ...,
        release_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        training_data_cutoff: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        deprecation_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        capabilities: collections.abc.Iterable[
            weaveapi.llmx.v1.capabilities_pb2.Capability
        ]
        | None = ...,
        classification: global___ModelClassification | None = ...,
        performance: global___ModelPerformance | None = ...,
        tokens: global___TokenInfo | None = ...,
        pricing: weaveapi.llmx.v1.pricing_pb2.Pricing | None = ...,
        configuration: global___Configuration | None = ...,
        api_details: global___APIDetails | None = ...,
        availability: global___Availability | None = ...,
        architecture: weaveapi.llmx.v1.architecture_pb2.Architecture | None = ...,
        training: weaveapi.llmx.v1.architecture_pb2.Training | None = ...,
        safety: weaveapi.llmx.v1.architecture_pb2.Safety | None = ...,
        licensing: weaveapi.llmx.v1.architecture_pb2.Licensing | None = ...,
        technical_specs: weaveapi.llmx.v1.architecture_pb2.TechnicalSpecs | None = ...,
        last_scraped_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        data_sources: collections.abc.Iterable[builtins.str] | None = ...,
        is_active: builtins.bool = ...,
        is_deprecated: builtins.bool = ...,
        replacement_model_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "api_details",
            b"api_details",
            "architecture",
            b"architecture",
            "availability",
            b"availability",
            "classification",
            b"classification",
            "configuration",
            b"configuration",
            "deprecation_date",
            b"deprecation_date",
            "last_scraped_at",
            b"last_scraped_at",
            "licensing",
            b"licensing",
            "performance",
            b"performance",
            "pricing",
            b"pricing",
            "release_date",
            b"release_date",
            "safety",
            b"safety",
            "technical_specs",
            b"technical_specs",
            "tokens",
            b"tokens",
            "training",
            b"training",
            "training_data_cutoff",
            b"training_data_cutoff",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "api_details",
            b"api_details",
            "architecture",
            b"architecture",
            "availability",
            b"availability",
            "capabilities",
            b"capabilities",
            "classification",
            b"classification",
            "configuration",
            b"configuration",
            "data_sources",
            b"data_sources",
            "deprecation_date",
            b"deprecation_date",
            "description",
            b"description",
            "display_name",
            b"display_name",
            "id",
            b"id",
            "is_active",
            b"is_active",
            "is_deprecated",
            b"is_deprecated",
            "last_scraped_at",
            b"last_scraped_at",
            "licensing",
            b"licensing",
            "model_id",
            b"model_id",
            "name",
            b"name",
            "performance",
            b"performance",
            "pricing",
            b"pricing",
            "provider_id",
            b"provider_id",
            "provider_name",
            b"provider_name",
            "provider_slug",
            b"provider_slug",
            "release_date",
            b"release_date",
            "replacement_model_id",
            b"replacement_model_id",
            "safety",
            b"safety",
            "slug",
            b"slug",
            "technical_specs",
            b"technical_specs",
            "tokens",
            b"tokens",
            "training",
            b"training",
            "training_data_cutoff",
            b"training_data_cutoff",
            "version",
            b"version",
        ],
    ) -> None: ...

global___Model = Model

@typing.final
class ModelClassification(google.protobuf.message.Message):
    """ModelClassification categorizes models for filtering and comparison."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_TYPE_FIELD_NUMBER: builtins.int
    ARCHITECTURE_FIELD_NUMBER: builtins.int
    PARAMETER_COUNT_FIELD_NUMBER: builtins.int
    IS_OPEN_SOURCE_FIELD_NUMBER: builtins.int
    LICENSE_TYPE_FIELD_NUMBER: builtins.int
    model_type: builtins.str
    """Primary model type defining its training approach.
    Examples: "foundation", "fine-tuned", "instruct", "chat", "reasoning"
    "foundation" = base model, "instruct" = instruction-following
    """
    architecture: builtins.str
    """Underlying model architecture family.
    Examples: "GPT", "LLaMA", "BERT", "T5", "Transformer", "Mamba"
    """
    parameter_count: builtins.int
    """Approximate number of parameters in billions.
    Examples: 7 (7B), 70 (70B), 175 (175B for GPT-3)
    """
    is_open_source: builtins.bool
    """Whether model weights are publicly available.
    true for LLaMA, Mistral; false for GPT-4, Claude
    """
    license_type: builtins.str
    """Software license if open source.
    Examples: "MIT", "Apache-2.0", "Custom", "Proprietary"
    """
    def __init__(
        self,
        *,
        model_type: builtins.str = ...,
        architecture: builtins.str = ...,
        parameter_count: builtins.int = ...,
        is_open_source: builtins.bool = ...,
        license_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "architecture",
            b"architecture",
            "is_open_source",
            b"is_open_source",
            "license_type",
            b"license_type",
            "model_type",
            b"model_type",
            "parameter_count",
            b"parameter_count",
        ],
    ) -> None: ...

global___ModelClassification = ModelClassification

@typing.final
class ModelPerformance(google.protobuf.message.Message):
    """ModelPerformance captures standardized benchmark scores."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class BenchmarkScoresEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.float
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.float = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    REASONING_SCORE_FIELD_NUMBER: builtins.int
    CODING_SCORE_FIELD_NUMBER: builtins.int
    CREATIVE_SCORE_FIELD_NUMBER: builtins.int
    FACTUAL_SCORE_FIELD_NUMBER: builtins.int
    MATH_SCORE_FIELD_NUMBER: builtins.int
    BENCHMARK_SCORES_FIELD_NUMBER: builtins.int
    reasoning_score: builtins.float
    """General reasoning ability score (0-10 scale).
    Based on benchmarks like ARC, HellaSwag, MMLU
    Example: 8.5 for strong reasoning models
    """
    coding_score: builtins.float
    """Programming and code generation score (0-10).
    Based on HumanEval, MBPP benchmarks
    Example: 9.2 for specialized coding models
    """
    creative_score: builtins.float
    """Creative writing and generation score (0-10).
    Based on human evaluations and creative benchmarks
    Example: 7.8 for models good at storytelling
    """
    factual_score: builtins.float
    """Factual accuracy and knowledge score (0-10).
    Based on TruthfulQA, factual benchmarks
    Example: 8.0 for models with good factual recall
    """
    math_score: builtins.float
    """Mathematical reasoning score (0-10).
    Based on GSM8K, MATH benchmarks
    Example: 9.5 for models excelling at math
    """
    @property
    def benchmark_scores(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.float]:
        """Raw benchmark scores by name.
        Keys: "mmlu", "humaneval", "gsm8k", "truthfulqa", "arc", "hellaswag"
        Values: Actual benchmark scores (usually 0-100)
        Example: {"mmlu": 86.4, "humaneval": 92.0, "gsm8k": 95.0}
        """

    def __init__(
        self,
        *,
        reasoning_score: builtins.float = ...,
        coding_score: builtins.float = ...,
        creative_score: builtins.float = ...,
        factual_score: builtins.float = ...,
        math_score: builtins.float = ...,
        benchmark_scores: collections.abc.Mapping[builtins.str, builtins.float]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "benchmark_scores",
            b"benchmark_scores",
            "coding_score",
            b"coding_score",
            "creative_score",
            b"creative_score",
            "factual_score",
            b"factual_score",
            "math_score",
            b"math_score",
            "reasoning_score",
            b"reasoning_score",
        ],
    ) -> None: ...

global___ModelPerformance = ModelPerformance

@typing.final
class TokenInfo(google.protobuf.message.Message):
    """TokenInfo describes token limits and processing capabilities."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTEXT_WINDOW_FIELD_NUMBER: builtins.int
    MAX_OUTPUT_TOKENS_FIELD_NUMBER: builtins.int
    TOKENIZER_FIELD_NUMBER: builtins.int
    TOKENS_PER_SECOND_FIELD_NUMBER: builtins.int
    context_window: builtins.int
    """Maximum tokens the model can process in a single request.
    Examples: 4096, 8192, 32768, 128000, 200000
    Includes both input and output tokens
    """
    max_output_tokens: builtins.int
    """Maximum tokens that can be generated in response.
    Examples: 4096 for most models, 16384 for some
    May be less than context_window
    """
    tokenizer: builtins.str
    """Tokenizer algorithm used.
    Examples: "cl100k_base" (GPT-4), "claude", "sentencepiece"
    """
    tokens_per_second: builtins.int
    """Average generation speed in tokens per second.
    Example: 50 for typical API, 100+ for optimized inference
    May vary based on load and tier
    """
    def __init__(
        self,
        *,
        context_window: builtins.int = ...,
        max_output_tokens: builtins.int = ...,
        tokenizer: builtins.str = ...,
        tokens_per_second: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "context_window",
            b"context_window",
            "max_output_tokens",
            b"max_output_tokens",
            "tokenizer",
            b"tokenizer",
            "tokens_per_second",
            b"tokens_per_second",
        ],
    ) -> None: ...

global___TokenInfo = TokenInfo

@typing.final
class Configuration(google.protobuf.message.Message):
    """Configuration defines supported generation parameters."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEMPERATURE_MIN_FIELD_NUMBER: builtins.int
    TEMPERATURE_MAX_FIELD_NUMBER: builtins.int
    TEMPERATURE_DEFAULT_FIELD_NUMBER: builtins.int
    TOP_P_MIN_FIELD_NUMBER: builtins.int
    TOP_P_MAX_FIELD_NUMBER: builtins.int
    temperature_min: builtins.float
    """Minimum allowed temperature value.
    Usually 0.0 for deterministic output
    """
    temperature_max: builtins.float
    """Maximum allowed temperature value.
    Usually 1.0 or 2.0 for high randomness
    """
    temperature_default: builtins.float
    """Default temperature if not specified.
    Typically 0.7 or 1.0
    """
    top_p_min: builtins.float
    """Minimum allowed top_p (nucleus sampling).
    Usually 0.0 to disable
    """
    top_p_max: builtins.float
    """Maximum allowed top_p value.
    Usually 1.0 for full vocabulary
    """
    def __init__(
        self,
        *,
        temperature_min: builtins.float = ...,
        temperature_max: builtins.float = ...,
        temperature_default: builtins.float = ...,
        top_p_min: builtins.float = ...,
        top_p_max: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "temperature_default",
            b"temperature_default",
            "temperature_max",
            b"temperature_max",
            "temperature_min",
            b"temperature_min",
            "top_p_max",
            b"top_p_max",
            "top_p_min",
            b"top_p_min",
        ],
    ) -> None: ...

global___Configuration = Configuration

@typing.final
class APIDetails(google.protobuf.message.Message):
    """APIDetails provides integration information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENDPOINT_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    RATE_LIMIT_RPM_FIELD_NUMBER: builtins.int
    RATE_LIMIT_TPM_FIELD_NUMBER: builtins.int
    endpoint: builtins.str
    """Base API endpoint URL.
    Example: "https://api.openai.com/v1/chat/completions"
    """
    version: builtins.str
    """API version identifier.
    Examples: "v1", "2024-02-01", "beta"
    """
    rate_limit_rpm: builtins.int
    """Rate limit in requests per minute.
    Example: 500 for standard tier, 10000 for enterprise
    """
    rate_limit_tpm: builtins.int
    """Rate limit in tokens per minute.
    Example: 90000 for GPT-4, 200000 for GPT-3.5
    """
    def __init__(
        self,
        *,
        endpoint: builtins.str = ...,
        version: builtins.str = ...,
        rate_limit_rpm: builtins.int = ...,
        rate_limit_tpm: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "endpoint",
            b"endpoint",
            "rate_limit_rpm",
            b"rate_limit_rpm",
            "rate_limit_tpm",
            b"rate_limit_tpm",
            "version",
            b"version",
        ],
    ) -> None: ...

global___APIDetails = APIDetails

@typing.final
class Availability(google.protobuf.message.Message):
    """Availability describes where the model can be accessed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGIONS_FIELD_NUMBER: builtins.int
    PLATFORMS_FIELD_NUMBER: builtins.int
    @property
    def regions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Geographic regions where available.
        Examples: ["us-east-1", "eu-west-1", "asia-pacific"]
        May use provider-specific region codes
        """

    @property
    def platforms(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Platforms/services offering the model.
        Examples: ["api", "playground", "azure", "vertex-ai", "bedrock"]
        """

    def __init__(
        self,
        *,
        regions: collections.abc.Iterable[builtins.str] | None = ...,
        platforms: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["platforms", b"platforms", "regions", b"regions"],
    ) -> None: ...

global___Availability = Availability
