# Copyright (C) 2023 Bootloader.  All rights reserved.
#
# This software is the confidential and proprietary information of
# Bootloader or one of its subsidiaries.  You shall not disclose this
# confidential information and shall use it only in accordance with the
# terms of the license agreement or other applicable agreement you
# entered into with Bootloader.
#
# BOOTLOADER MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
# SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
# NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR
# A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  BOOTLOADER SHALL NOT BE
# LIABLE FOR ANY LOSSES OR DAMAGES SUFFERED BY LICENSEE AS A RESULT OF
# USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

from majormode.perseus.model.enum import Enum


# Classes of the Unreal Engine assets.
#
# :note: We found a list of Unreal Engine asset classes in the following
#     C++ header files:
#
#     ```shell
#     find "/Users/Shared/Epic Games/UE_5.2" -name EngineClasses.h
#     ```
#
#     which returns:
#
#     ```text
#     /Users/Shared/Epic Games/UE_5.2/Engine/Intermediate/Build/IOS/UnrealGame/Inc/Engine/UHT/EngineClasses.h
#     /Users/Shared/Epic Games/UE_5.2/Engine/Intermediate/Build/Mac/UnrealGame/Inc/Engine/UHT/EngineClasses.h
#     /Users/Shared/Epic Games/UE_5.2/Engine/Intermediate/Build/Mac/UnrealEditor/Inc/Engine/UHT/EngineClasses.h
#     /Users/Shared/Epic Games/UE_5.2/Engine/Intermediate/Build/Android/UnrealGame/Inc/Engine/UHT/EngineClasses.h
#     ```
#
#     We actually generated the list of asset classes in our Python
#     enumeration `AssetClass` from the asset icons' image files
#     located in the following folders:
#
#     - `/Users/Shared/Epic Games/UE_5.2/Engine/Content/Editor/Slate/Icons/AssetIcons`
#     - `/Users/Shared/Epic Games/UE_5.2/Engine/Content/Editor/Slate/Starship/AssetIcons`
#
#
# :warning: It appears that some Unreal Engine classes don't appear in
#     the list, such as `ControlRigBlueprint`, which we added manually
#     as items in our Python enumeration.
UnrealEngineAssetClass = Enum(
    'AbilitySystemComponent',
    'Actor',
    'ActorComponent',
    'AIController',
    'AimOffsetBlendSpace',
    'AimOffsetBlendSpace1D',
    'AIPerceptionComponent',
    'AnimationModifier',
    'AnimationSharingSetup',
    'AnimBlueprint',
    'AnimComposite',
    'AnimInstance',
    'AnimLayerInterface',
    'AnimMontage',
    'AnimSequence',
    'ApplicationLifecycleComponent',
    'AtmosphericFog',
    'BehaviorTree',
    'BlackboardData',
    'BlendSpace',
    'BlendSpace1D',
    'BlockingVolume',
    'Blueprint',
    'BlueprintFunctionLibrary',
    'BlueprintGeneratedClass',
    'BlueprintInterface',
    'BlueprintMacroLibrary',
    'BoxReflectionCapture',
    'ButtonStyleAsset',
    'CableActor',
    'CableComponent',
    'CameraActor',
    'CameraAnim',
    'CameraBlockingVolume',
    'CameraRig_Crane',
    'CameraRig_Rail',
    'Character',
    'CharacterMovementComponent',
    'CineCameraActor',
    'Class',
    'Cone',
    'ControlRigBlueprint',
    'Cube',
    'CullDistanceVolume',
    'CurveBase',
    'Cylinder',
    'DataAsset',
    'DataTable',
    'DecalActor',
    'Default',
    'DefaultPawn',
    'DialogueVoice',
    'DialogueWave',
    'DirectionalLight',
    'DirectionalLightMovable',
    'DirectionalLightStatic',
    'DirectionalLightStationary',
    'DocumentationActor',
    'EditorTutorial',
    'EnvQuery',
    'ExponentialHeightFog',
    'FileMediaSource',
    'FoliageType_Actor',
    'Font',
    'FontFace',
    'ForceFeedbackEffect',
    'FoundationActor',
    'GameModeBase',
    'GameStateBase',
    'HUD',
    'Interface',
    'InterpData',
    'KillZVolume',
    'Landscape',
    'LandscapeBlueprintBrushBase',
    'LevelBounds',
    'LevelSequence',
    'LevelSequenceActor',
    'LevelStreamingVolume',
    'LightmassCharacterIndirectDetailVolume',
    'LightmassImportanceVolume',
    'MassiveLODOverrideVolume',
    'Material',
    'MaterialFunction',
    'MaterialInstanceActor',
    'MaterialInstanceConstant',
    'MaterialParameterCollection',
    'MediaPlayer',
    'MediaTexture',
    'MultiFont',
    'NavLinkProxy',
    'NavMeshBoundsVolume',
    'NavModifierComponent',
    'NavModifierVolume',
    'Note',
    'ObjectLibrary',
    'PainCausingVolume',
    'ParticleSystem',
    'Pawn',
    'PawnNoiseEmitterComponent',
    'PawnSensingComponent',
    'PhysicalMaterial',
    'PhysicsAsset',
    'PhysicsConstraintActor',
    'PhysicsConstraintComponent',
    'PhysicsHandleComponent',
    'PhysicsThruster',
    'PhysicsThrusterComponent',
    'PhysicsVolume',
    'Plane',
    'PlaneReflectionCapture',
    'PlatformMediaSource',
    'PlayerController',
    'PlayerStart',
    'PointLight',
    'PoseAsset',
    'PostProcessVolume',
    'PrecomputedVisibilityOverrideVolume',
    'PrecomputedVisibilityVolume',
    'ProceduralFoliageBlockingVolume',
    'ProceduralFoliageVolume',
    'ProjectileMovementComponent',
    'RadialForceActor',
    'RadialForceComponent',
    'ReflectionCapture',
    'RotatingMovementComponent',
    'SceneCapture2D',
    'SceneCaptureCube',
    'SceneComponent',
    'SkeletalMesh',
    'Skeleton',
    'SkyAtmosphere',
    'SkyLight',
    'SkyLightComponent',
    'SlateBrushAsset',
    'SlateWidgetStyleAsset',
    'Sphere',
    'SphereReflectionCapture',
    'SpotLight',
    'SpotLightMovable',
    'SpotLightStatic',
    'SpotLightStationary',
    'SpringArmComponent',
    'StaticMesh',
    'StreamMediaSource',
    'StringTable',
    'SubsurfaceProfile',
    'TargetPoint',
    'TextRenderActor',
    'Texture2D',
    'TextureRenderTarget2D',
    'TextureRenderTargetCube',
    'TouchInterface',
    'TriggerBase',
    'TriggerBox',
    'TriggerCapsule',
    'TriggerSphere',
    'TriggerVolume',
    'UserDefinedCaptureProtocol',
    'UserDefinedEnum',
    'UserDefinedStruct',
    'UserWidget',
    'VolumetricCloud',
    'VolumetricLightmapDensityVolume',
    'WidgetBlueprint',
    'WidgetBlueprintGeneratedClass',
    'WindDirectionalSource',
    'World',
)


# Humanly readable names of asset classes.
ASSET_CLASS_NAME_MAPPING = {
    UnrealEngineAssetClass.AbilitySystemComponent: 'Ability System Component',
    UnrealEngineAssetClass.Actor: 'Actor',
    UnrealEngineAssetClass.ActorComponent: 'Actor Component',
    UnrealEngineAssetClass.AIController: 'AI Controller',
    UnrealEngineAssetClass.AimOffsetBlendSpace: 'Aim Offset Blend Space',
    UnrealEngineAssetClass.AimOffsetBlendSpace1D: 'Aim Offset Blend Space 1D',
    UnrealEngineAssetClass.AIPerceptionComponent: 'AI Perception Component',
    UnrealEngineAssetClass.AnimationModifier: 'Animation Modifier',
    UnrealEngineAssetClass.AnimationSharingSetup: 'Animation Sharing Setup',
    UnrealEngineAssetClass.AnimBlueprint: 'Animation Blueprint',
    UnrealEngineAssetClass.AnimComposite: 'Animation Composite',
    UnrealEngineAssetClass.AnimInstance: 'Animation Instance',
    UnrealEngineAssetClass.AnimLayerInterface: 'Animation Layer Interface',
    UnrealEngineAssetClass.AnimMontage: 'Animation Montage',
    UnrealEngineAssetClass.AnimSequence: 'Animation Sequence',
    UnrealEngineAssetClass.ApplicationLifecycleComponent: 'Application Lifecycle Component',
    UnrealEngineAssetClass.AtmosphericFog: 'Atmospheric Fog',
    UnrealEngineAssetClass.BehaviorTree: 'Behavior Tree',
    UnrealEngineAssetClass.BlackboardData: 'Blackboard Data',
    UnrealEngineAssetClass.BlendSpace: 'Blend Space',
    UnrealEngineAssetClass.BlendSpace1D: 'Blend Space 1D',
    UnrealEngineAssetClass.BlockingVolume: 'Blocking Volume',
    UnrealEngineAssetClass.Blueprint: 'Blueprint',
    UnrealEngineAssetClass.BlueprintFunctionLibrary: 'Blueprint Function Library',
    UnrealEngineAssetClass.BlueprintGeneratedClass: 'Blueprint Generated Class',
    UnrealEngineAssetClass.BlueprintInterface: 'Blueprint Interface',
    UnrealEngineAssetClass.BlueprintMacroLibrary: 'Blueprint Macro Library',
    UnrealEngineAssetClass.BoxReflectionCapture: 'Box Reflection Capture',
    UnrealEngineAssetClass.ButtonStyleAsset: 'Button Style Asset',
    UnrealEngineAssetClass.CableActor: 'Cable Actor',
    UnrealEngineAssetClass.CableComponent: 'Cable Component',
    UnrealEngineAssetClass.CameraActor: 'Camera Actor',
    UnrealEngineAssetClass.CameraAnim: 'Camera Animation',
    UnrealEngineAssetClass.CameraBlockingVolume: 'Camera Blocking Volume',
    UnrealEngineAssetClass.CameraRig_Crane: 'Camera Rig Crane',
    UnrealEngineAssetClass.CameraRig_Rail: 'Camera Rig Rail',
    UnrealEngineAssetClass.Character: 'Character',
    UnrealEngineAssetClass.CharacterMovementComponent: 'Character Movement Component',
    UnrealEngineAssetClass.CineCameraActor: 'Cine Camera Actor',
    UnrealEngineAssetClass.Class: 'Class',
    UnrealEngineAssetClass.Cone: 'Cone',
    UnrealEngineAssetClass.Cube: 'Cube',
    UnrealEngineAssetClass.CullDistanceVolume: 'Cull Distance Volume',
    UnrealEngineAssetClass.CurveBase: 'Curve Base',
    UnrealEngineAssetClass.Cylinder: 'Cylinder',
    UnrealEngineAssetClass.DataAsset: 'Data Asset',
    UnrealEngineAssetClass.DataTable: 'Data Table',
    UnrealEngineAssetClass.DecalActor: 'Decal Actor',
    UnrealEngineAssetClass.Default: 'Default',
    UnrealEngineAssetClass.DefaultPawn: 'Default Pawn',
    UnrealEngineAssetClass.DialogueVoice: 'Dialogue Voice',
    UnrealEngineAssetClass.DialogueWave: 'Dialogue Wave',
    UnrealEngineAssetClass.DirectionalLight: 'Directional Light',
    UnrealEngineAssetClass.DirectionalLightMovable: 'Directional Light Movable',
    UnrealEngineAssetClass.DirectionalLightStatic: 'Directional Light Static',
    UnrealEngineAssetClass.DirectionalLightStationary: 'Directional Light Stationary',
    UnrealEngineAssetClass.DocumentationActor: 'Documentation Actor',
    UnrealEngineAssetClass.EditorTutorial: 'Editor Tutorial',
    UnrealEngineAssetClass.EnvQuery: 'Environment Query',
    UnrealEngineAssetClass.ExponentialHeightFog: 'Exponential Height Fog',
    UnrealEngineAssetClass.FileMediaSource: 'FileMediaSource',
    UnrealEngineAssetClass.FoliageType_Actor: 'FoliageType_Actor',
    UnrealEngineAssetClass.Font: 'Font',
    UnrealEngineAssetClass.FontFace: 'Font Face',
    UnrealEngineAssetClass.ForceFeedbackEffect: 'Force Feedback Effect',
    UnrealEngineAssetClass.FoundationActor: 'Foundation Actor',
    UnrealEngineAssetClass.GameModeBase: 'Game Mode Base',
    UnrealEngineAssetClass.GameStateBase: 'Game State Base',
    UnrealEngineAssetClass.HUD: 'HUD',
    UnrealEngineAssetClass.Interface: 'Interface',
    UnrealEngineAssetClass.InterpData: 'Interpolation Data',
    UnrealEngineAssetClass.KillZVolume: 'Kill Z Volume',
    UnrealEngineAssetClass.Landscape: 'Landscape',
    UnrealEngineAssetClass.LandscapeBlueprintBrushBase: 'Landscape Blueprint Brush Base',
    UnrealEngineAssetClass.LevelBounds: 'Level Bounds',
    UnrealEngineAssetClass.LevelSequence: 'Level Sequence',
    UnrealEngineAssetClass.LevelSequenceActor: 'Level Sequence Actor',
    UnrealEngineAssetClass.LevelStreamingVolume: 'Level Streaming Volume',
    UnrealEngineAssetClass.LightmassCharacterIndirectDetailVolume: 'Lightmass Character Indirect Detail Volume',
    UnrealEngineAssetClass.LightmassImportanceVolume: 'Lightmass Importance Volume',
    UnrealEngineAssetClass.MassiveLODOverrideVolume: 'Massive LOD Override Volume',
    UnrealEngineAssetClass.Material: 'Material',
    UnrealEngineAssetClass.MaterialFunction: 'Material Function',
    UnrealEngineAssetClass.MaterialInstanceActor: 'Material Instance Actor',
    UnrealEngineAssetClass.MaterialInstanceConstant: 'Material Instance Constant',
    UnrealEngineAssetClass.MaterialParameterCollection: 'Material Parameter Collection',
    UnrealEngineAssetClass.MediaPlayer: 'Media Player',
    UnrealEngineAssetClass.MediaTexture: 'Media Texture',
    UnrealEngineAssetClass.MultiFont: 'Multi Font',
    UnrealEngineAssetClass.NavLinkProxy: 'Navigation Link Proxy',
    UnrealEngineAssetClass.NavMeshBoundsVolume: 'Navigation Mesh Bounds Volume',
    UnrealEngineAssetClass.NavModifierComponent: 'Navigation Modifier Component',
    UnrealEngineAssetClass.NavModifierVolume: 'Navigation Modifier Volume',
    UnrealEngineAssetClass.Note: 'Note',
    UnrealEngineAssetClass.ObjectLibrary: 'Object Library',
    UnrealEngineAssetClass.PainCausingVolume: 'Pain Causing Volume',
    UnrealEngineAssetClass.ParticleSystem: 'Particle System',
    UnrealEngineAssetClass.Pawn: 'Pawn',
    UnrealEngineAssetClass.PawnNoiseEmitterComponent: 'Pawn Noise Emitter Component',
    UnrealEngineAssetClass.PawnSensingComponent: 'Pawn Sensing Component',
    UnrealEngineAssetClass.PhysicalMaterial: 'Physical Material',
    UnrealEngineAssetClass.PhysicsAsset: 'Physics Asset',
    UnrealEngineAssetClass.PhysicsConstraintActor: 'Physics Constraint Actor',
    UnrealEngineAssetClass.PhysicsConstraintComponent: 'Physics Constraint Component',
    UnrealEngineAssetClass.PhysicsHandleComponent: 'Physics Handle Component',
    UnrealEngineAssetClass.PhysicsThruster: 'Physics Thruster',
    UnrealEngineAssetClass.PhysicsThrusterComponent: 'Physics Thruster Component',
    UnrealEngineAssetClass.PhysicsVolume: 'Physics Volume',
    UnrealEngineAssetClass.Plane: 'Plane',
    UnrealEngineAssetClass.PlaneReflectionCapture: 'Plane Reflection Capture',
    UnrealEngineAssetClass.PlatformMediaSource: 'Platform Media Source',
    UnrealEngineAssetClass.PlayerController: 'Player Controller',
    UnrealEngineAssetClass.PlayerStart: 'Player Start',
    UnrealEngineAssetClass.PointLight: 'Point Light',
    UnrealEngineAssetClass.PoseAsset: 'Pose Asset',
    UnrealEngineAssetClass.PostProcessVolume: 'Post Process Volume',
    UnrealEngineAssetClass.PrecomputedVisibilityOverrideVolume: 'Precomputed Visibility Override Volume',
    UnrealEngineAssetClass.PrecomputedVisibilityVolume: 'Precomputed Visibility Volume',
    UnrealEngineAssetClass.ProceduralFoliageBlockingVolume: 'Procedural Foliage Blocking Volume',
    UnrealEngineAssetClass.ProceduralFoliageVolume: 'Procedural Foliage Volume',
    UnrealEngineAssetClass.ProjectileMovementComponent: 'Projectile Movement Component',
    UnrealEngineAssetClass.RadialForceActor: 'Radial Force Actor',
    UnrealEngineAssetClass.RadialForceComponent: 'Radial Force Component',
    UnrealEngineAssetClass.ReflectionCapture: 'Reflection Capture',
    UnrealEngineAssetClass.RotatingMovementComponent: 'Rotating Movement Component',
    UnrealEngineAssetClass.SceneCapture2D: 'Scene Capture 2D',
    UnrealEngineAssetClass.SceneCaptureCube: 'Scene Capture Cube',
    UnrealEngineAssetClass.SceneComponent: 'Scene Component',
    UnrealEngineAssetClass.SkeletalMesh: 'Skeletal Mesh',
    UnrealEngineAssetClass.Skeleton: 'Skeleton',
    UnrealEngineAssetClass.SkyAtmosphere: 'Sky Atmosphere',
    UnrealEngineAssetClass.SkyLight: 'Sky Light',
    UnrealEngineAssetClass.SkyLightComponent: 'Sky Light Component',
    UnrealEngineAssetClass.SlateBrushAsset: 'Slate Brush Asset',
    UnrealEngineAssetClass.SlateWidgetStyleAsset: 'Slate Widget Style Asset',
    UnrealEngineAssetClass.Sphere: 'Sphere',
    UnrealEngineAssetClass.SphereReflectionCapture: 'Sphere Reflection Capture',
    UnrealEngineAssetClass.SpotLight: 'Spot Light',
    UnrealEngineAssetClass.SpotLightMovable: 'Spot Light Movable',
    UnrealEngineAssetClass.SpotLightStatic: 'Spot Light Static',
    UnrealEngineAssetClass.SpotLightStationary: 'Spot Light Stationary',
    UnrealEngineAssetClass.SpringArmComponent: 'Spring Arm Component',
    UnrealEngineAssetClass.StaticMesh: 'Static Mesh',
    UnrealEngineAssetClass.StreamMediaSource: 'Stream Media Source',
    UnrealEngineAssetClass.StringTable: 'String Table',
    UnrealEngineAssetClass.SubsurfaceProfile: 'Subsurface Profile',
    UnrealEngineAssetClass.TargetPoint: 'Target Point',
    UnrealEngineAssetClass.TextRenderActor: 'Text Render Actor',
    UnrealEngineAssetClass.Texture2D: 'Texture 2D',
    UnrealEngineAssetClass.TextureRenderTarget2D: 'Texture Render Target 2D',
    UnrealEngineAssetClass.TextureRenderTargetCube: 'Texture Render Target Cube',
    UnrealEngineAssetClass.TouchInterface: 'Touch Interface',
    UnrealEngineAssetClass.TriggerBase: 'Trigger Base',
    UnrealEngineAssetClass.TriggerBox: 'Trigger Box',
    UnrealEngineAssetClass.TriggerCapsule: 'Trigger Capsule',
    UnrealEngineAssetClass.TriggerSphere: 'Trigger Sphere',
    UnrealEngineAssetClass.TriggerVolume: 'Trigger Volume',
    UnrealEngineAssetClass.UserDefinedCaptureProtocol: 'User Defined Capture Protocol',
    UnrealEngineAssetClass.UserDefinedEnum: 'User Defined Enumeration',
    UnrealEngineAssetClass.UserDefinedStruct: 'User DefinedS truct',
    UnrealEngineAssetClass.UserWidget: 'User Widget',
    UnrealEngineAssetClass.VolumetricCloud: 'Volumetric Cloud',
    UnrealEngineAssetClass.VolumetricLightmapDensityVolume: 'Volumetric Lightmap Density Volume',
    UnrealEngineAssetClass.WidgetBlueprint: 'Widget Blueprint',
    UnrealEngineAssetClass.WidgetBlueprintGeneratedClass: 'Widget Blueprint Generated Class',
    UnrealEngineAssetClass.WindDirectionalSource: 'Wind Directional Source',
    UnrealEngineAssetClass.World: 'World',
}
