# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyxavi']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.11,<5.0', 'pyyaml>=6.0.1,<7.0.0', 'requests>=2.28.0,<3.0.0']

setup_kwargs = {
    'name': 'pyxavi',
    'version': '0.5.1',
    'description': 'Set of utilities to assist on simple Python projects',
    'long_description': '# The Xavi\'s Python package\n\nSet of utilities to assist on simple Python projects.\n\n## Disclaimer\n\nThis is a constant *work in progress* package, adding and improving the libraries within with\nthe goal of abstracting and reusing code, and easing the coding experience of real life\nprojects.\n\nSuggestions are welcome :)\n\n\n# Modules included in the package\n\nThis package contains a set of modules, divided by functionality.\n\n## The `storage` module\n\nA class to bring a basic load/write, get/set behaviour for key/value file based storage. Under\nthe hood it uses YAML files so they\'re human readable.\n\nWhat makes it special is the ability to read and write hierarchical keys like\n`family.category.parameter1`\n\n\n## The `config` module\n\nA class for read-only config values inheriting from the `storage` module.\n\n\n## The `logger` module\n\nA class that helps setting up a built-in logger based on the configuration in a file, handled\nby the `config` module.\n\nFor example, a `config.yaml` with parameters to configure the logger would look like this:\n```yaml\n# Logging config\nlogger:\n  # [Integer] Log level: NOTSET=0 | DEBUG=10 | INFO=20 | WARN=30 | ERROR=40 | CRITICAL=50\n  loglevel: 10\n  # [String] Name of the logger\n  name: "my_app"\n  # [Bool] Dump the log into a file\n  to_file: True\n  # [String] Path and filename of the log file\n  filename: "log/my_app.log"\n  # [Bool] Dump the log into a stdout\n  to_stdout: True\n  # [String] Format of the log\n  format: "[%(asctime)s] %(levelname)-8s %(name)-12s %(message)s"\n```\n\n\n## The `debugger` module\n\nA function library with a *PHP\'s var_dump()*-like function and other debugging tools\n\n\n## The `terminal_color` module\n\nA class with a basic set of terminal color codes, ready to assist on printing colorful\nterminal messages.\n\n\n## The `media` module\n\nA class for operations with media files, at this point extracting media URLs from texts and\ndownload files discovering the mime types.\n\n\n## The `janitor` module\n\nA class that wraps the API to report to [Janitor](https://github.com/XaviArnaus/janitor), a\nseparated GitHub repository project.\n\n## The `firefish` module\n\nA class that wraps the API for [Firefish](https://firefish.social/api-doc). It is meant to be \ninterchangeable with the [Mastodon.py](https://mastodonpy.readthedocs.io/en/latest/index.html) \nwrapper library, so one could inject any of both.\n\nAt this point of time it only covers posting a new status (creating a note in Firefish).\n\n## The `network` module\n\nA class to perform some networking actions. At this point:\n- Get the external IP addres for IPv4 and IPv6\n- Validate an IPv4 and IPv6 IP address\n\n\n# How to use it\n\n1. Assuming you have `pip` installed:\n```\npip install pyxavi\n```\n\nYou can also add the `pyxavi` package as a dependency of your project in its `requirements.txt`\nor `pyproject.toml` file.\n\n2. Import the desired module in your code. For example, in your `my_python_script.py`:\n```python\nfrom pyxavi.debugger import dd\n\nfoo = [1, 2, 3]\ndd(foo)\n```\n\n\n# Give me an example\n\n0. First of all you have installed the package, right?\n```bash\npip install pyxavi\n```\n\n1. Create a yaml file with some params, for example the app\'s name and the logger. Let\'s call\nit `config.yaml`:\n```yaml\napp:\n    name: My app\n\nlogger:\n    name: "my_app"\n    to_file: True\n```\n\n2. Create a python file called `test.py` and open it in your editor.\n\n2. Import the modules by adding these lines in the top of the script file:\n```python\nfrom pyxavi.config import Config\nfrom pyxavi.logger import Logger\n```\n\n3. Now just add the following lines to instantiate the config and the logger using the config.\n```python\nconfig = Config()\nlogger = Logger(config).get_logger()\n```\nThis will give you a `config` object with the parameters in the config file, and a `logger`\nobject ready to log events using the built-in interface.\n\n4. Simply use the objects!\n```python\napp_name = config.get("app.name", "Default app\'s name")\nlogger.info(f"The config file says the app\'s name is {app_name}")\n```\n\nLet\'s see it all together, and extend it a bit more:\n\n```python\nfrom pyxavi.config import Config\nfrom pyxavi.logger import Logger\nfrom pyxavi.debugger import dd\n\nconfig = Config()\nlogger = Logger(config).get_logger()\n\napp_name = config.get("app.name", "Default app\'s name")\nlogger.info(f"The config file says the app\'s name is {app_name}")\n\nlogger.debug("Inspecting the config object")\ndd(config)\n```\n\nNow, when it runs it should give the following output:\n```bash\n$ python3 test.py \n(Config){\n  "_filename": (str[11])"config.yaml",\n  "_content": (dict[2]){\n    "app": (dict[1]){"name": (str[6])"My app"},\n    "logger": (dict[2]){"name": (str[6])"my_app", "to_file": (bool)True}\n  },\n  class methods: _load_file_contents, get, get_all, get_hashed, read_file, set, set_hashed, write_file\n}\n```\n\n... and also create a `debug.log` file that contains the following content:\n```\n[2023-08-06 22:24:34,491] INFO     my_app       The config file says the app\'s name is My app\n```\n\nNote that the default `LOG_LEVEL` is 20, therefor the call `logger.debug` was not registered as\nit\'s level is 10.\n\n\n# ToDo\n- [ ] Documentation per module\n- [ ] Iterate inline documentation\n- [ ] Empty the [NEXT MAJOR](./NEXT_MAJOR.md) list\n',
    'author': 'Xavier Arnaus',
    'author_email': 'xavi@arnaus.net',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/XaviArnaus/pyxavi',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
