# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationArgs', 'Organization']

@pulumi.input_type
class OrganizationArgs:
    def __init__(__self__, *,
                 members: Optional[pulumi.Input[Mapping[str, pulumi.Input['OrganizationMembersArgs']]]] = None):
        """
        The set of arguments for constructing a Organization resource.
        :param pulumi.Input[Mapping[str, pulumi.Input['OrganizationMembersArgs']]] members: Manages the members of an Elastic Cloud organization. The key of each entry should be the email of the member.
        """
        if members is not None:
            pulumi.set(__self__, "members", members)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['OrganizationMembersArgs']]]]:
        """
        Manages the members of an Elastic Cloud organization. The key of each entry should be the email of the member.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['OrganizationMembersArgs']]]]):
        pulumi.set(self, "members", value)


@pulumi.input_type
class _OrganizationState:
    def __init__(__self__, *,
                 members: Optional[pulumi.Input[Mapping[str, pulumi.Input['OrganizationMembersArgs']]]] = None):
        """
        Input properties used for looking up and filtering Organization resources.
        :param pulumi.Input[Mapping[str, pulumi.Input['OrganizationMembersArgs']]] members: Manages the members of an Elastic Cloud organization. The key of each entry should be the email of the member.
        """
        if members is not None:
            pulumi.set(__self__, "members", members)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['OrganizationMembersArgs']]]]:
        """
        Manages the members of an Elastic Cloud organization. The key of each entry should be the email of the member.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['OrganizationMembersArgs']]]]):
        pulumi.set(self, "members", value)


@pulumi.type_token("ec:index/organization:Organization")
class Organization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 members: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['OrganizationMembersArgs', 'OrganizationMembersArgsDict']]]]] = None,
                 __props__=None):
        """
        Create a Organization resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['OrganizationMembersArgs', 'OrganizationMembersArgsDict']]]] members: Manages the members of an Elastic Cloud organization. The key of each entry should be the email of the member.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OrganizationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Organization resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 members: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['OrganizationMembersArgs', 'OrganizationMembersArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationArgs.__new__(OrganizationArgs)

            __props__.__dict__["members"] = members
        super(Organization, __self__).__init__(
            'ec:index/organization:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            members: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['OrganizationMembersArgs', 'OrganizationMembersArgsDict']]]]] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['OrganizationMembersArgs', 'OrganizationMembersArgsDict']]]] members: Manages the members of an Elastic Cloud organization. The key of each entry should be the email of the member.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationState.__new__(_OrganizationState)

        __props__.__dict__["members"] = members
        return Organization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[Mapping[str, 'outputs.OrganizationMembers']]]:
        """
        Manages the members of an Elastic Cloud organization. The key of each entry should be the email of the member.
        """
        return pulumi.get(self, "members")

