# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAiPrivateEndpointResult',
    'AwaitableGetAiPrivateEndpointResult',
    'get_ai_private_endpoint',
    'get_ai_private_endpoint_output',
]

@pulumi.output_type
class GetAiPrivateEndpointResult:
    """
    A collection of values returned by getAiPrivateEndpoint.
    """
    def __init__(__self__, ai_private_endpoint_id=None, attached_data_assets=None, compartment_id=None, defined_tags=None, display_name=None, dns_zones=None, freeform_tags=None, id=None, lifecycle_details=None, state=None, subnet_id=None, system_tags=None, time_created=None, time_updated=None):
        if ai_private_endpoint_id and not isinstance(ai_private_endpoint_id, str):
            raise TypeError("Expected argument 'ai_private_endpoint_id' to be a str")
        pulumi.set(__self__, "ai_private_endpoint_id", ai_private_endpoint_id)
        if attached_data_assets and not isinstance(attached_data_assets, list):
            raise TypeError("Expected argument 'attached_data_assets' to be a list")
        pulumi.set(__self__, "attached_data_assets", attached_data_assets)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dns_zones and not isinstance(dns_zones, list):
            raise TypeError("Expected argument 'dns_zones' to be a list")
        pulumi.set(__self__, "dns_zones", dns_zones)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="aiPrivateEndpointId")
    def ai_private_endpoint_id(self) -> str:
        return pulumi.get(self, "ai_private_endpoint_id")

    @property
    @pulumi.getter(name="attachedDataAssets")
    def attached_data_assets(self) -> Sequence[str]:
        """
        The list of dataAssets using the private reverse connection endpoint.
        """
        return pulumi.get(self, "attached_data_assets")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Private Reverse Connection Endpoint display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsZones")
    def dns_zones(self) -> Sequence[str]:
        """
        List of DNS zones to be used by the data assets. Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com
        """
        return pulumi.get(self, "dns_zones")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the private endpoint resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Subnet Identifier
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAiPrivateEndpointResult(GetAiPrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAiPrivateEndpointResult(
            ai_private_endpoint_id=self.ai_private_endpoint_id,
            attached_data_assets=self.attached_data_assets,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dns_zones=self.dns_zones,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_ai_private_endpoint(ai_private_endpoint_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAiPrivateEndpointResult:
    """
    This data source provides details about a specific Ai Private Endpoint resource in Oracle Cloud Infrastructure Ai Anomaly Detection service.

    Gets a specific private reverse connection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ai_private_endpoint = oci.AiAnomalyDetection.get_ai_private_endpoint(ai_private_endpoint_id=test_ai_private_endpoint_oci_ai_anomaly_detection_ai_private_endpoint["id"])
    ```


    :param str ai_private_endpoint_id: Unique private reverse connection identifier.
    """
    __args__ = dict()
    __args__['aiPrivateEndpointId'] = ai_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiAnomalyDetection/getAiPrivateEndpoint:getAiPrivateEndpoint', __args__, opts=opts, typ=GetAiPrivateEndpointResult).value

    return AwaitableGetAiPrivateEndpointResult(
        ai_private_endpoint_id=pulumi.get(__ret__, 'ai_private_endpoint_id'),
        attached_data_assets=pulumi.get(__ret__, 'attached_data_assets'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dns_zones=pulumi.get(__ret__, 'dns_zones'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_ai_private_endpoint_output(ai_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAiPrivateEndpointResult]:
    """
    This data source provides details about a specific Ai Private Endpoint resource in Oracle Cloud Infrastructure Ai Anomaly Detection service.

    Gets a specific private reverse connection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ai_private_endpoint = oci.AiAnomalyDetection.get_ai_private_endpoint(ai_private_endpoint_id=test_ai_private_endpoint_oci_ai_anomaly_detection_ai_private_endpoint["id"])
    ```


    :param str ai_private_endpoint_id: Unique private reverse connection identifier.
    """
    __args__ = dict()
    __args__['aiPrivateEndpointId'] = ai_private_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiAnomalyDetection/getAiPrivateEndpoint:getAiPrivateEndpoint', __args__, opts=opts, typ=GetAiPrivateEndpointResult)
    return __ret__.apply(lambda __response__: GetAiPrivateEndpointResult(
        ai_private_endpoint_id=pulumi.get(__response__, 'ai_private_endpoint_id'),
        attached_data_assets=pulumi.get(__response__, 'attached_data_assets'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        dns_zones=pulumi.get(__response__, 'dns_zones'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
