# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAlertPolicyRuleResult',
    'AwaitableGetAlertPolicyRuleResult',
    'get_alert_policy_rule',
    'get_alert_policy_rule_output',
]

@pulumi.output_type
class GetAlertPolicyRuleResult:
    """
    A collection of values returned by getAlertPolicyRule.
    """
    def __init__(__self__, alert_policy_id=None, description=None, display_name=None, expression=None, id=None, key=None, rule_key=None, state=None, time_created=None):
        if alert_policy_id and not isinstance(alert_policy_id, str):
            raise TypeError("Expected argument 'alert_policy_id' to be a str")
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if expression and not isinstance(expression, str):
            raise TypeError("Expected argument 'expression' to be a str")
        pulumi.set(__self__, "expression", expression)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if rule_key and not isinstance(rule_key, str):
            raise TypeError("Expected argument 'rule_key' to be a str")
        pulumi.set(__self__, "rule_key", rule_key)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> str:
        return pulumi.get(self, "alert_policy_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Describes the alert policy rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the alert policy rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        The conditional expression of the alert policy rule which evaluates to boolean value.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The unique key of the alert policy rule.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="ruleKey")
    def rule_key(self) -> str:
        return pulumi.get(self, "rule_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the alert policy rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Creation date and time of the alert policy rule, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")


class AwaitableGetAlertPolicyRuleResult(GetAlertPolicyRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertPolicyRuleResult(
            alert_policy_id=self.alert_policy_id,
            description=self.description,
            display_name=self.display_name,
            expression=self.expression,
            id=self.id,
            key=self.key,
            rule_key=self.rule_key,
            state=self.state,
            time_created=self.time_created)


def get_alert_policy_rule(alert_policy_id: Optional[str] = None,
                          rule_key: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertPolicyRuleResult:
    """
    This data source provides details about a specific Alert Policy Rule resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of a policy rule by its key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_policy_rule = oci.DataSafe.get_alert_policy_rule(alert_policy_id=test_alert_policy["id"],
        rule_key=alert_policy_rule_rule_key)
    ```


    :param str alert_policy_id: The OCID of the alert policy.
    :param str rule_key: The key of the alert policy rule.
    """
    __args__ = dict()
    __args__['alertPolicyId'] = alert_policy_id
    __args__['ruleKey'] = rule_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAlertPolicyRule:getAlertPolicyRule', __args__, opts=opts, typ=GetAlertPolicyRuleResult).value

    return AwaitableGetAlertPolicyRuleResult(
        alert_policy_id=pulumi.get(__ret__, 'alert_policy_id'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        expression=pulumi.get(__ret__, 'expression'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        rule_key=pulumi.get(__ret__, 'rule_key'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_alert_policy_rule_output(alert_policy_id: Optional[pulumi.Input[str]] = None,
                                 rule_key: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertPolicyRuleResult]:
    """
    This data source provides details about a specific Alert Policy Rule resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of a policy rule by its key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_policy_rule = oci.DataSafe.get_alert_policy_rule(alert_policy_id=test_alert_policy["id"],
        rule_key=alert_policy_rule_rule_key)
    ```


    :param str alert_policy_id: The OCID of the alert policy.
    :param str rule_key: The key of the alert policy rule.
    """
    __args__ = dict()
    __args__['alertPolicyId'] = alert_policy_id
    __args__['ruleKey'] = rule_key
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAlertPolicyRule:getAlertPolicyRule', __args__, opts=opts, typ=GetAlertPolicyRuleResult)
    return __ret__.apply(lambda __response__: GetAlertPolicyRuleResult(
        alert_policy_id=pulumi.get(__response__, 'alert_policy_id'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        expression=pulumi.get(__response__, 'expression'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        rule_key=pulumi.get(__response__, 'rule_key'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created')))
