# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAuditTrailsResult',
    'AwaitableGetAuditTrailsResult',
    'get_audit_trails',
    'get_audit_trails_output',
]

@pulumi.output_type
class GetAuditTrailsResult:
    """
    A collection of values returned by getAuditTrails.
    """
    def __init__(__self__, access_level=None, audit_trail_collections=None, audit_trail_id=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, state=None, status=None, target_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if audit_trail_collections and not isinstance(audit_trail_collections, list):
            raise TypeError("Expected argument 'audit_trail_collections' to be a list")
        pulumi.set(__self__, "audit_trail_collections", audit_trail_collections)
        if audit_trail_id and not isinstance(audit_trail_id, str):
            raise TypeError("Expected argument 'audit_trail_id' to be a str")
        pulumi.set(__self__, "audit_trail_id", audit_trail_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="auditTrailCollections")
    def audit_trail_collections(self) -> Sequence['outputs.GetAuditTrailsAuditTrailCollectionResult']:
        """
        The list of audit_trail_collection.
        """
        return pulumi.get(self, "audit_trail_collections")

    @property
    @pulumi.getter(name="auditTrailId")
    def audit_trail_id(self) -> Optional[str]:
        return pulumi.get(self, "audit_trail_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the audit trail and is the same as the compartment of the audit profile resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the audit trail.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAuditTrailsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the audit trail.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The current sub-state of the audit trail.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The OCID of the Data Safe target for which the audit trail is created.
        """
        return pulumi.get(self, "target_id")


class AwaitableGetAuditTrailsResult(GetAuditTrailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditTrailsResult(
            access_level=self.access_level,
            audit_trail_collections=self.audit_trail_collections,
            audit_trail_id=self.audit_trail_id,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            status=self.status,
            target_id=self.target_id)


def get_audit_trails(access_level: Optional[str] = None,
                     audit_trail_id: Optional[str] = None,
                     compartment_id: Optional[str] = None,
                     compartment_id_in_subtree: Optional[bool] = None,
                     display_name: Optional[str] = None,
                     filters: Optional[Sequence[Union['GetAuditTrailsFilterArgs', 'GetAuditTrailsFilterArgsDict']]] = None,
                     state: Optional[str] = None,
                     status: Optional[str] = None,
                     target_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditTrailsResult:
    """
    This data source provides the list of Audit Trails in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all audit trails.
    The ListAuditTrails operation returns only the audit trails in the specified `compartmentId`.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListAuditTrails on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_trails = oci.DataSafe.get_audit_trails(compartment_id=compartment_id,
        access_level=audit_trail_access_level,
        audit_trail_id=test_audit_trail["id"],
        compartment_id_in_subtree=audit_trail_compartment_id_in_subtree,
        display_name=audit_trail_display_name,
        state=audit_trail_state,
        status=audit_trail_status,
        target_id=test_target["id"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str audit_trail_id: A optional filter to return only resources that match the specified id.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str state: A optional filter to return only resources that match the specified lifecycle state.
    :param str status: A optional filter to return only resources that match the specified sub-state of audit trail.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['auditTrailId'] = audit_trail_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['status'] = status
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditTrails:getAuditTrails', __args__, opts=opts, typ=GetAuditTrailsResult).value

    return AwaitableGetAuditTrailsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        audit_trail_collections=pulumi.get(__ret__, 'audit_trail_collections'),
        audit_trail_id=pulumi.get(__ret__, 'audit_trail_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        target_id=pulumi.get(__ret__, 'target_id'))
def get_audit_trails_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                            audit_trail_id: Optional[pulumi.Input[Optional[str]]] = None,
                            compartment_id: Optional[pulumi.Input[str]] = None,
                            compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                            display_name: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAuditTrailsFilterArgs', 'GetAuditTrailsFilterArgsDict']]]]] = None,
                            state: Optional[pulumi.Input[Optional[str]]] = None,
                            status: Optional[pulumi.Input[Optional[str]]] = None,
                            target_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuditTrailsResult]:
    """
    This data source provides the list of Audit Trails in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all audit trails.
    The ListAuditTrails operation returns only the audit trails in the specified `compartmentId`.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListAuditTrails on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_trails = oci.DataSafe.get_audit_trails(compartment_id=compartment_id,
        access_level=audit_trail_access_level,
        audit_trail_id=test_audit_trail["id"],
        compartment_id_in_subtree=audit_trail_compartment_id_in_subtree,
        display_name=audit_trail_display_name,
        state=audit_trail_state,
        status=audit_trail_status,
        target_id=test_target["id"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str audit_trail_id: A optional filter to return only resources that match the specified id.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str state: A optional filter to return only resources that match the specified lifecycle state.
    :param str status: A optional filter to return only resources that match the specified sub-state of audit trail.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['auditTrailId'] = audit_trail_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['status'] = status
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAuditTrails:getAuditTrails', __args__, opts=opts, typ=GetAuditTrailsResult)
    return __ret__.apply(lambda __response__: GetAuditTrailsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        audit_trail_collections=pulumi.get(__response__, 'audit_trail_collections'),
        audit_trail_id=pulumi.get(__response__, 'audit_trail_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        target_id=pulumi.get(__response__, 'target_id')))
