# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserAssessmentsResult',
    'AwaitableGetUserAssessmentsResult',
    'get_user_assessments',
    'get_user_assessments_output',
]

@pulumi.output_type
class GetUserAssessmentsResult:
    """
    A collection of values returned by getUserAssessments.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, ignored_targets=None, is_baseline=None, is_schedule_assessment=None, schedule_user_assessment_id=None, state=None, target_id=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None, triggered_by=None, type=None, user_assessments=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignored_targets and not isinstance(ignored_targets, list):
            raise TypeError("Expected argument 'ignored_targets' to be a list")
        pulumi.set(__self__, "ignored_targets", ignored_targets)
        if is_baseline and not isinstance(is_baseline, bool):
            raise TypeError("Expected argument 'is_baseline' to be a bool")
        pulumi.set(__self__, "is_baseline", is_baseline)
        if is_schedule_assessment and not isinstance(is_schedule_assessment, bool):
            raise TypeError("Expected argument 'is_schedule_assessment' to be a bool")
        pulumi.set(__self__, "is_schedule_assessment", is_schedule_assessment)
        if schedule_user_assessment_id and not isinstance(schedule_user_assessment_id, str):
            raise TypeError("Expected argument 'schedule_user_assessment_id' to be a str")
        pulumi.set(__self__, "schedule_user_assessment_id", schedule_user_assessment_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)
        if triggered_by and not isinstance(triggered_by, str):
            raise TypeError("Expected argument 'triggered_by' to be a str")
        pulumi.set(__self__, "triggered_by", triggered_by)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if user_assessments and not isinstance(user_assessments, list):
            raise TypeError("Expected argument 'user_assessments' to be a list")
        pulumi.set(__self__, "user_assessments", user_assessments)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the user assessment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the user assessment.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUserAssessmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoredTargets")
    def ignored_targets(self) -> Sequence['outputs.GetUserAssessmentsIgnoredTargetResult']:
        """
        List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        """
        return pulumi.get(self, "ignored_targets")

    @property
    @pulumi.getter(name="isBaseline")
    def is_baseline(self) -> Optional[bool]:
        """
        Indicates if the user assessment is set as a baseline. This is applicable only to saved user assessments.
        """
        return pulumi.get(self, "is_baseline")

    @property
    @pulumi.getter(name="isScheduleAssessment")
    def is_schedule_assessment(self) -> Optional[bool]:
        return pulumi.get(self, "is_schedule_assessment")

    @property
    @pulumi.getter(name="scheduleUserAssessmentId")
    def schedule_user_assessment_id(self) -> Optional[str]:
        return pulumi.get(self, "schedule_user_assessment_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the user assessment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")

    @property
    @pulumi.getter(name="triggeredBy")
    def triggered_by(self) -> Optional[str]:
        """
        Indicates whether the user assessment was created by the system or the user.
        """
        return pulumi.get(self, "triggered_by")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the user assessment. The possible types are:
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssessments")
    def user_assessments(self) -> Sequence['outputs.GetUserAssessmentsUserAssessmentResult']:
        """
        The list of user_assessments.
        """
        return pulumi.get(self, "user_assessments")


class AwaitableGetUserAssessmentsResult(GetUserAssessmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserAssessmentsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            ignored_targets=self.ignored_targets,
            is_baseline=self.is_baseline,
            is_schedule_assessment=self.is_schedule_assessment,
            schedule_user_assessment_id=self.schedule_user_assessment_id,
            state=self.state,
            target_id=self.target_id,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than,
            triggered_by=self.triggered_by,
            type=self.type,
            user_assessments=self.user_assessments)


def get_user_assessments(access_level: Optional[str] = None,
                         compartment_id: Optional[str] = None,
                         compartment_id_in_subtree: Optional[bool] = None,
                         display_name: Optional[str] = None,
                         filters: Optional[Sequence[Union['GetUserAssessmentsFilterArgs', 'GetUserAssessmentsFilterArgsDict']]] = None,
                         is_baseline: Optional[bool] = None,
                         is_schedule_assessment: Optional[bool] = None,
                         schedule_user_assessment_id: Optional[str] = None,
                         state: Optional[str] = None,
                         target_id: Optional[str] = None,
                         time_created_greater_than_or_equal_to: Optional[str] = None,
                         time_created_less_than: Optional[str] = None,
                         triggered_by: Optional[str] = None,
                         type: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserAssessmentsResult:
    """
    This data source provides the list of User Assessments in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of user assessments.

    The ListUserAssessments operation returns only the assessments in the specified `compartmentId`.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListUserAssessments on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessments = oci.DataSafe.get_user_assessments(compartment_id=compartment_id,
        access_level=user_assessment_access_level,
        compartment_id_in_subtree=user_assessment_compartment_id_in_subtree,
        display_name=user_assessment_display_name,
        is_baseline=user_assessment_is_baseline,
        is_schedule_assessment=user_assessment_is_schedule_assessment,
        schedule_user_assessment_id=test_user_assessment["id"],
        state=user_assessment_state,
        target_id=test_target["id"],
        time_created_greater_than_or_equal_to=user_assessment_time_created_greater_than_or_equal_to,
        time_created_less_than=user_assessment_time_created_less_than,
        triggered_by=user_assessment_triggered_by,
        type=user_assessment_type)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param bool is_baseline: A filter to return only user assessments that are set as baseline.
    :param bool is_schedule_assessment: A filter to return only user assessments of type SAVE_SCHEDULE.
    :param str schedule_user_assessment_id: The OCID of the user assessment of type SAVE_SCHEDULE.
    :param str state: The current state of the user assessment.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_created_greater_than_or_equal_to: A filter to return only user assessments that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using timeCreatedGreaterThanOrEqualTo parameter retrieves all assessments created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str triggered_by: A filter to return user assessments that were created by either the system or by a user only.
    :param str type: A filter to return only items that match the specified assessment type.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isBaseline'] = is_baseline
    __args__['isScheduleAssessment'] = is_schedule_assessment
    __args__['scheduleUserAssessmentId'] = schedule_user_assessment_id
    __args__['state'] = state
    __args__['targetId'] = target_id
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    __args__['triggeredBy'] = triggered_by
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getUserAssessments:getUserAssessments', __args__, opts=opts, typ=GetUserAssessmentsResult).value

    return AwaitableGetUserAssessmentsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ignored_targets=pulumi.get(__ret__, 'ignored_targets'),
        is_baseline=pulumi.get(__ret__, 'is_baseline'),
        is_schedule_assessment=pulumi.get(__ret__, 'is_schedule_assessment'),
        schedule_user_assessment_id=pulumi.get(__ret__, 'schedule_user_assessment_id'),
        state=pulumi.get(__ret__, 'state'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'),
        triggered_by=pulumi.get(__ret__, 'triggered_by'),
        type=pulumi.get(__ret__, 'type'),
        user_assessments=pulumi.get(__ret__, 'user_assessments'))
def get_user_assessments_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                compartment_id: Optional[pulumi.Input[str]] = None,
                                compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUserAssessmentsFilterArgs', 'GetUserAssessmentsFilterArgsDict']]]]] = None,
                                is_baseline: Optional[pulumi.Input[Optional[bool]]] = None,
                                is_schedule_assessment: Optional[pulumi.Input[Optional[bool]]] = None,
                                schedule_user_assessment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                triggered_by: Optional[pulumi.Input[Optional[str]]] = None,
                                type: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserAssessmentsResult]:
    """
    This data source provides the list of User Assessments in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of user assessments.

    The ListUserAssessments operation returns only the assessments in the specified `compartmentId`.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListUserAssessments on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessments = oci.DataSafe.get_user_assessments(compartment_id=compartment_id,
        access_level=user_assessment_access_level,
        compartment_id_in_subtree=user_assessment_compartment_id_in_subtree,
        display_name=user_assessment_display_name,
        is_baseline=user_assessment_is_baseline,
        is_schedule_assessment=user_assessment_is_schedule_assessment,
        schedule_user_assessment_id=test_user_assessment["id"],
        state=user_assessment_state,
        target_id=test_target["id"],
        time_created_greater_than_or_equal_to=user_assessment_time_created_greater_than_or_equal_to,
        time_created_less_than=user_assessment_time_created_less_than,
        triggered_by=user_assessment_triggered_by,
        type=user_assessment_type)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param bool is_baseline: A filter to return only user assessments that are set as baseline.
    :param bool is_schedule_assessment: A filter to return only user assessments of type SAVE_SCHEDULE.
    :param str schedule_user_assessment_id: The OCID of the user assessment of type SAVE_SCHEDULE.
    :param str state: The current state of the user assessment.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_created_greater_than_or_equal_to: A filter to return only user assessments that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using timeCreatedGreaterThanOrEqualTo parameter retrieves all assessments created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str triggered_by: A filter to return user assessments that were created by either the system or by a user only.
    :param str type: A filter to return only items that match the specified assessment type.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isBaseline'] = is_baseline
    __args__['isScheduleAssessment'] = is_schedule_assessment
    __args__['scheduleUserAssessmentId'] = schedule_user_assessment_id
    __args__['state'] = state
    __args__['targetId'] = target_id
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    __args__['triggeredBy'] = triggered_by
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getUserAssessments:getUserAssessments', __args__, opts=opts, typ=GetUserAssessmentsResult)
    return __ret__.apply(lambda __response__: GetUserAssessmentsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ignored_targets=pulumi.get(__response__, 'ignored_targets'),
        is_baseline=pulumi.get(__response__, 'is_baseline'),
        is_schedule_assessment=pulumi.get(__response__, 'is_schedule_assessment'),
        schedule_user_assessment_id=pulumi.get(__response__, 'schedule_user_assessment_id'),
        state=pulumi.get(__response__, 'state'),
        target_id=pulumi.get(__response__, 'target_id'),
        time_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__response__, 'time_created_less_than'),
        triggered_by=pulumi.get(__response__, 'triggered_by'),
        type=pulumi.get(__response__, 'type'),
        user_assessments=pulumi.get(__response__, 'user_assessments')))
