# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchedulerDefinitionsResult',
    'AwaitableGetSchedulerDefinitionsResult',
    'get_scheduler_definitions',
    'get_scheduler_definitions_output',
]

@pulumi.output_type
class GetSchedulerDefinitionsResult:
    """
    A collection of values returned by getSchedulerDefinitions.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, fleet_id=None, id=None, maintenance_window_id=None, product=None, runbook_id=None, scheduler_definition_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_window_id and not isinstance(maintenance_window_id, str):
            raise TypeError("Expected argument 'maintenance_window_id' to be a str")
        pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if runbook_id and not isinstance(runbook_id, str):
            raise TypeError("Expected argument 'runbook_id' to be a str")
        pulumi.set(__self__, "runbook_id", runbook_id)
        if scheduler_definition_collections and not isinstance(scheduler_definition_collections, list):
            raise TypeError("Expected argument 'scheduler_definition_collections' to be a list")
        pulumi.set(__self__, "scheduler_definition_collections", scheduler_definition_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSchedulerDefinitionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[str]:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the Runbook
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> Optional[str]:
        """
        Provide MaintenanceWindowId if Schedule Type is Maintenance Window
        """
        return pulumi.get(self, "maintenance_window_id")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        Product associated. Only applicable if type is PRODUCT.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[str]:
        """
        ID of the runbook
        """
        return pulumi.get(self, "runbook_id")

    @property
    @pulumi.getter(name="schedulerDefinitionCollections")
    def scheduler_definition_collections(self) -> Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionResult']:
        """
        The list of scheduler_definition_collection.
        """
        return pulumi.get(self, "scheduler_definition_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the SchedulerDefinition.
        """
        return pulumi.get(self, "state")


class AwaitableGetSchedulerDefinitionsResult(GetSchedulerDefinitionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulerDefinitionsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            maintenance_window_id=self.maintenance_window_id,
            product=self.product,
            runbook_id=self.runbook_id,
            scheduler_definition_collections=self.scheduler_definition_collections,
            state=self.state)


def get_scheduler_definitions(compartment_id: Optional[str] = None,
                              display_name: Optional[str] = None,
                              filters: Optional[Sequence[Union['GetSchedulerDefinitionsFilterArgs', 'GetSchedulerDefinitionsFilterArgsDict']]] = None,
                              fleet_id: Optional[str] = None,
                              id: Optional[str] = None,
                              maintenance_window_id: Optional[str] = None,
                              product: Optional[str] = None,
                              runbook_id: Optional[str] = None,
                              state: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulerDefinitionsResult:
    """
    This data source provides the list of Scheduler Definitions in Oracle Cloud Infrastructure Fleet Apps Management service.

    List all lifecycle management schedules in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_definitions = oci.FleetAppsManagement.get_scheduler_definitions(compartment_id=compartment_id,
        display_name=scheduler_definition_display_name,
        fleet_id=test_fleet["id"],
        id=scheduler_definition_id,
        maintenance_window_id=test_maintenance_window["id"],
        product=scheduler_definition_product,
        runbook_id=test_runbook["id"],
        state=scheduler_definition_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fleet_id: unique Fleet identifier
    :param str id: A filter to return only schedule definitions whose identifier matches the given identifier.
    :param str maintenance_window_id: A filter to return only schedule definitions whose associated maintenanceWindowId matches the given maintenanceWindowId.
    :param str product: A filter to return only dchedule definitions whose assocaited product matches the given product
    :param str runbook_id: A filter to return only schedule definitions whose associated runbookId matches the given runbookId.
    :param str state: A filter to return only scheduleDefinitions whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['maintenanceWindowId'] = maintenance_window_id
    __args__['product'] = product
    __args__['runbookId'] = runbook_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getSchedulerDefinitions:getSchedulerDefinitions', __args__, opts=opts, typ=GetSchedulerDefinitionsResult).value

    return AwaitableGetSchedulerDefinitionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        maintenance_window_id=pulumi.get(__ret__, 'maintenance_window_id'),
        product=pulumi.get(__ret__, 'product'),
        runbook_id=pulumi.get(__ret__, 'runbook_id'),
        scheduler_definition_collections=pulumi.get(__ret__, 'scheduler_definition_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_scheduler_definitions_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSchedulerDefinitionsFilterArgs', 'GetSchedulerDefinitionsFilterArgsDict']]]]] = None,
                                     fleet_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     id: Optional[pulumi.Input[Optional[str]]] = None,
                                     maintenance_window_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     product: Optional[pulumi.Input[Optional[str]]] = None,
                                     runbook_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     state: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulerDefinitionsResult]:
    """
    This data source provides the list of Scheduler Definitions in Oracle Cloud Infrastructure Fleet Apps Management service.

    List all lifecycle management schedules in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_definitions = oci.FleetAppsManagement.get_scheduler_definitions(compartment_id=compartment_id,
        display_name=scheduler_definition_display_name,
        fleet_id=test_fleet["id"],
        id=scheduler_definition_id,
        maintenance_window_id=test_maintenance_window["id"],
        product=scheduler_definition_product,
        runbook_id=test_runbook["id"],
        state=scheduler_definition_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fleet_id: unique Fleet identifier
    :param str id: A filter to return only schedule definitions whose identifier matches the given identifier.
    :param str maintenance_window_id: A filter to return only schedule definitions whose associated maintenanceWindowId matches the given maintenanceWindowId.
    :param str product: A filter to return only dchedule definitions whose assocaited product matches the given product
    :param str runbook_id: A filter to return only schedule definitions whose associated runbookId matches the given runbookId.
    :param str state: A filter to return only scheduleDefinitions whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['maintenanceWindowId'] = maintenance_window_id
    __args__['product'] = product
    __args__['runbookId'] = runbook_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getSchedulerDefinitions:getSchedulerDefinitions', __args__, opts=opts, typ=GetSchedulerDefinitionsResult)
    return __ret__.apply(lambda __response__: GetSchedulerDefinitionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        maintenance_window_id=pulumi.get(__response__, 'maintenance_window_id'),
        product=pulumi.get(__response__, 'product'),
        runbook_id=pulumi.get(__response__, 'runbook_id'),
        scheduler_definition_collections=pulumi.get(__response__, 'scheduler_definition_collections'),
        state=pulumi.get(__response__, 'state')))
