# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFusionEnvironmentScheduledActivityResult',
    'AwaitableGetFusionEnvironmentScheduledActivityResult',
    'get_fusion_environment_scheduled_activity',
    'get_fusion_environment_scheduled_activity_output',
]

@pulumi.output_type
class GetFusionEnvironmentScheduledActivityResult:
    """
    A collection of values returned by getFusionEnvironmentScheduledActivity.
    """
    def __init__(__self__, actions=None, delay_in_hours=None, display_name=None, fusion_environment_id=None, id=None, lifecycle_details=None, run_cycle=None, scheduled_activity_id=None, service_availability=None, state=None, time_created=None, time_expected_finish=None, time_finished=None, time_scheduled_start=None, time_updated=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if delay_in_hours and not isinstance(delay_in_hours, int):
            raise TypeError("Expected argument 'delay_in_hours' to be a int")
        pulumi.set(__self__, "delay_in_hours", delay_in_hours)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fusion_environment_id and not isinstance(fusion_environment_id, str):
            raise TypeError("Expected argument 'fusion_environment_id' to be a str")
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if run_cycle and not isinstance(run_cycle, str):
            raise TypeError("Expected argument 'run_cycle' to be a str")
        pulumi.set(__self__, "run_cycle", run_cycle)
        if scheduled_activity_id and not isinstance(scheduled_activity_id, str):
            raise TypeError("Expected argument 'scheduled_activity_id' to be a str")
        pulumi.set(__self__, "scheduled_activity_id", scheduled_activity_id)
        if service_availability and not isinstance(service_availability, str):
            raise TypeError("Expected argument 'service_availability' to be a str")
        pulumi.set(__self__, "service_availability", service_availability)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_expected_finish and not isinstance(time_expected_finish, str):
            raise TypeError("Expected argument 'time_expected_finish' to be a str")
        pulumi.set(__self__, "time_expected_finish", time_expected_finish)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_scheduled_start and not isinstance(time_scheduled_start, str):
            raise TypeError("Expected argument 'time_scheduled_start' to be a str")
        pulumi.set(__self__, "time_scheduled_start", time_scheduled_start)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetFusionEnvironmentScheduledActivityActionResult']:
        """
        List of actions
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="delayInHours")
    def delay_in_hours(self) -> int:
        """
        Cumulative delay hours
        """
        return pulumi.get(self, "delay_in_hours")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        scheduled activity display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        """
        FAaaS Environment Identifier.
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="runCycle")
    def run_cycle(self) -> str:
        """
        run cadence.
        """
        return pulumi.get(self, "run_cycle")

    @property
    @pulumi.getter(name="scheduledActivityId")
    def scheduled_activity_id(self) -> str:
        return pulumi.get(self, "scheduled_activity_id")

    @property
    @pulumi.getter(name="serviceAvailability")
    def service_availability(self) -> str:
        """
        Service availability / impact during scheduled activity execution up down
        """
        return pulumi.get(self, "service_availability")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the scheduledActivity.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the scheduled activity record was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpectedFinish")
    def time_expected_finish(self) -> str:
        """
        Current time the scheduled activity is scheduled to end. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expected_finish")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The time the scheduled activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeScheduledStart")
    def time_scheduled_start(self) -> str:
        """
        Current time the scheduled activity is scheduled to start. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_scheduled_start")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the scheduled activity record was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetFusionEnvironmentScheduledActivityResult(GetFusionEnvironmentScheduledActivityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentScheduledActivityResult(
            actions=self.actions,
            delay_in_hours=self.delay_in_hours,
            display_name=self.display_name,
            fusion_environment_id=self.fusion_environment_id,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            run_cycle=self.run_cycle,
            scheduled_activity_id=self.scheduled_activity_id,
            service_availability=self.service_availability,
            state=self.state,
            time_created=self.time_created,
            time_expected_finish=self.time_expected_finish,
            time_finished=self.time_finished,
            time_scheduled_start=self.time_scheduled_start,
            time_updated=self.time_updated)


def get_fusion_environment_scheduled_activity(fusion_environment_id: Optional[str] = None,
                                              scheduled_activity_id: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentScheduledActivityResult:
    """
    This data source provides details about a specific Fusion Environment Scheduled Activity resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets a ScheduledActivity by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_scheduled_activity = oci.Functions.get_fusion_environment_scheduled_activity(fusion_environment_id=test_fusion_environment["id"],
        scheduled_activity_id=test_scheduled_activity["id"])
    ```


    :param str fusion_environment_id: unique FusionEnvironment identifier
    :param str scheduled_activity_id: Unique ScheduledActivity identifier.
    """
    __args__ = dict()
    __args__['fusionEnvironmentId'] = fusion_environment_id
    __args__['scheduledActivityId'] = scheduled_activity_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentScheduledActivity:getFusionEnvironmentScheduledActivity', __args__, opts=opts, typ=GetFusionEnvironmentScheduledActivityResult).value

    return AwaitableGetFusionEnvironmentScheduledActivityResult(
        actions=pulumi.get(__ret__, 'actions'),
        delay_in_hours=pulumi.get(__ret__, 'delay_in_hours'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fusion_environment_id=pulumi.get(__ret__, 'fusion_environment_id'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        run_cycle=pulumi.get(__ret__, 'run_cycle'),
        scheduled_activity_id=pulumi.get(__ret__, 'scheduled_activity_id'),
        service_availability=pulumi.get(__ret__, 'service_availability'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_expected_finish=pulumi.get(__ret__, 'time_expected_finish'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_scheduled_start=pulumi.get(__ret__, 'time_scheduled_start'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_fusion_environment_scheduled_activity_output(fusion_environment_id: Optional[pulumi.Input[str]] = None,
                                                     scheduled_activity_id: Optional[pulumi.Input[str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFusionEnvironmentScheduledActivityResult]:
    """
    This data source provides details about a specific Fusion Environment Scheduled Activity resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets a ScheduledActivity by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_scheduled_activity = oci.Functions.get_fusion_environment_scheduled_activity(fusion_environment_id=test_fusion_environment["id"],
        scheduled_activity_id=test_scheduled_activity["id"])
    ```


    :param str fusion_environment_id: unique FusionEnvironment identifier
    :param str scheduled_activity_id: Unique ScheduledActivity identifier.
    """
    __args__ = dict()
    __args__['fusionEnvironmentId'] = fusion_environment_id
    __args__['scheduledActivityId'] = scheduled_activity_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getFusionEnvironmentScheduledActivity:getFusionEnvironmentScheduledActivity', __args__, opts=opts, typ=GetFusionEnvironmentScheduledActivityResult)
    return __ret__.apply(lambda __response__: GetFusionEnvironmentScheduledActivityResult(
        actions=pulumi.get(__response__, 'actions'),
        delay_in_hours=pulumi.get(__response__, 'delay_in_hours'),
        display_name=pulumi.get(__response__, 'display_name'),
        fusion_environment_id=pulumi.get(__response__, 'fusion_environment_id'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        run_cycle=pulumi.get(__response__, 'run_cycle'),
        scheduled_activity_id=pulumi.get(__response__, 'scheduled_activity_id'),
        service_availability=pulumi.get(__response__, 'service_availability'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_expected_finish=pulumi.get(__response__, 'time_expected_finish'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_scheduled_start=pulumi.get(__response__, 'time_scheduled_start'),
        time_updated=pulumi.get(__response__, 'time_updated')))
