# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceGroupDetachSoftwareSourcesManagementArgs', 'ManagedInstanceGroupDetachSoftwareSourcesManagement']

@pulumi.input_type
class ManagedInstanceGroupDetachSoftwareSourcesManagementArgs:
    def __init__(__self__, *,
                 managed_instance_group_id: pulumi.Input[str],
                 software_sources: pulumi.Input[Sequence[pulumi.Input[str]]],
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a ManagedInstanceGroupDetachSoftwareSourcesManagement resource.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_sources: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
        :param pulumi.Input['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        pulumi.set(__self__, "software_sources", software_sources)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
        """
        return pulumi.get(self, "software_sources")

    @software_sources.setter
    def software_sources(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "software_sources", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _ManagedInstanceGroupDetachSoftwareSourcesManagementState:
    def __init__(__self__, *,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroupDetachSoftwareSourcesManagement resources.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_sources: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
        :param pulumi.Input['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if software_sources is not None:
            pulumi.set(__self__, "software_sources", software_sources)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
        """
        return pulumi.get(self, "software_sources")

    @software_sources.setter
    def software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "software_sources", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


class ManagedInstanceGroupDetachSoftwareSourcesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group Detach Software Sources Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Detaches the specified software sources from a managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_detach_software_sources_management = oci.os_management_hub.ManagedInstanceGroupDetachSoftwareSourcesManagement("test_managed_instance_group_detach_software_sources_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            software_sources=managed_instance_group_detach_software_sources_management_software_sources,
            work_request_details={
                "description": managed_instance_group_detach_software_sources_management_work_request_details_description,
                "display_name": managed_instance_group_detach_software_sources_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupDetachSoftwareSourcesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupDetachSoftwareSourcesManagement:ManagedInstanceGroupDetachSoftwareSourcesManagement test_managed_instance_group_detach_software_sources_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_sources: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
        :param pulumi.Input[Union['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupDetachSoftwareSourcesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group Detach Software Sources Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Detaches the specified software sources from a managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_detach_software_sources_management = oci.os_management_hub.ManagedInstanceGroupDetachSoftwareSourcesManagement("test_managed_instance_group_detach_software_sources_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            software_sources=managed_instance_group_detach_software_sources_management_software_sources,
            work_request_details={
                "description": managed_instance_group_detach_software_sources_management_work_request_details_description,
                "display_name": managed_instance_group_detach_software_sources_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupDetachSoftwareSourcesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupDetachSoftwareSourcesManagement:ManagedInstanceGroupDetachSoftwareSourcesManagement test_managed_instance_group_detach_software_sources_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupDetachSoftwareSourcesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupDetachSoftwareSourcesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupDetachSoftwareSourcesManagementArgs.__new__(ManagedInstanceGroupDetachSoftwareSourcesManagementArgs)

            if managed_instance_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_group_id'")
            __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
            if software_sources is None and not opts.urn:
                raise TypeError("Missing required property 'software_sources'")
            __props__.__dict__["software_sources"] = software_sources
            __props__.__dict__["work_request_details"] = work_request_details
        super(ManagedInstanceGroupDetachSoftwareSourcesManagement, __self__).__init__(
            'oci:OsManagementHub/managedInstanceGroupDetachSoftwareSourcesManagement:ManagedInstanceGroupDetachSoftwareSourcesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_instance_group_id: Optional[pulumi.Input[str]] = None,
            software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgsDict']]] = None) -> 'ManagedInstanceGroupDetachSoftwareSourcesManagement':
        """
        Get an existing ManagedInstanceGroupDetachSoftwareSourcesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_sources: List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
        :param pulumi.Input[Union['ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupDetachSoftwareSourcesManagementState.__new__(_ManagedInstanceGroupDetachSoftwareSourcesManagementState)

        __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
        __props__.__dict__["software_sources"] = software_sources
        __props__.__dict__["work_request_details"] = work_request_details
        return ManagedInstanceGroupDetachSoftwareSourcesManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> pulumi.Output[Sequence[str]]:
        """
        List of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
        """
        return pulumi.get(self, "software_sources")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.ManagedInstanceGroupDetachSoftwareSourcesManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

