# -*- coding: utf-8 -*-
from io import StringIO
from .... import __version__

# some constants definition
WHITESPACE = " "
INDENT = 2 * WHITESPACE
COMMENT = "! "
NEWLINE = "\n"
END = "End"

MESH_FILE = "Mesh"


def write(self, stream=None):
    """Write the Elmer Solver Input File. If no stream is given, the method
    will return a StringIO.
    """
    if not stream:
        stream = StringIO()

    # write SIF header
    _write_header(stream)

    for section in self.sections:
        section.write(stream)

    return stream


def _write_header(f):
    f.write(COMMENT + f"-" * 80 + NEWLINE)
    f.write(COMMENT + f"File Generated by pyleecan v{__version__}" + NEWLINE)
    f.write(COMMENT + f"-" * 80 + NEWLINE)

    f.write(NEWLINE)
    f.write(f"Header")
    f.write(NEWLINE + INDENT)
    f.write(f"CHECK KEYWORDS Warn")
    f.write(NEWLINE + INDENT)
    f.write(f'Mesh DB "." "{MESH_FILE}"')
    f.write(NEWLINE + INDENT)
    f.write(f'Include Path ""')
    f.write(NEWLINE + INDENT)
    f.write(f'Results Directory ""')
    f.write(NEWLINE + END + NEWLINE)
