from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="PostContainerNewManyBody")


@_attrs_define
class PostContainerNewManyBody:
    """
    Attributes:
        should_use_stock (Union[Unset, Any]):  Example: any.
        containers_data (Union[Unset, Any]):  Example: any.
        id (Union[Unset, Any]):  Example: any.
        location_type (Union[Unset, Any]):  Example: any.
    """

    should_use_stock: Union[Unset, Any] = UNSET
    containers_data: Union[Unset, Any] = UNSET
    id: Union[Unset, Any] = UNSET
    location_type: Union[Unset, Any] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        should_use_stock = self.should_use_stock

        containers_data = self.containers_data

        id = self.id

        location_type = self.location_type

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if should_use_stock is not UNSET:
            field_dict["shouldUseStock"] = should_use_stock
        if containers_data is not UNSET:
            field_dict["containersData"] = containers_data
        if id is not UNSET:
            field_dict["id"] = id
        if location_type is not UNSET:
            field_dict["locationType"] = location_type

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        should_use_stock = d.pop("shouldUseStock", UNSET)

        containers_data = d.pop("containersData", UNSET)

        id = d.pop("id", UNSET)

        location_type = d.pop("locationType", UNSET)

        post_container_new_many_body = cls(
            should_use_stock=should_use_stock,
            containers_data=containers_data,
            id=id,
            location_type=location_type,
        )

        post_container_new_many_body.additional_properties = d
        return post_container_new_many_body

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
