"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A policy managed by AWS
 *
 * For this managed policy, you only need to know the name to be able to use it.
 *
 * Some managed policy names start with "service-role/", some start with
 * "job-function/", and some don't start with anything. Do include the
 * prefix when constructing this object.
 */
class AwsManagedPolicy {
    constructor(managedPolicyName, scope) {
        this.managedPolicyName = managedPolicyName;
        this.scope = scope;
    }
    /**
     * The Arn of this managed policy
     */
    get policyArn() {
        // the arn is in the form of - arn:aws:iam::aws:policy/<policyName>
        return this.scope.node.stack.formatArn({
            service: "iam",
            region: "",
            account: "aws",
            resource: "policy",
            resourceName: this.managedPolicyName
        });
    }
}
exports.AwsManagedPolicy = AwsManagedPolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFuYWdlZC1wb2xpY3kuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtYW5hZ2VkLXBvbGljeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUVBOzs7Ozs7OztHQVFHO0FBQ0gsTUFBYSxnQkFBZ0I7SUFDM0IsWUFBNkIsaUJBQXlCLEVBQW1CLEtBQXFCO1FBQWpFLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBUTtRQUFtQixVQUFLLEdBQUwsS0FBSyxDQUFnQjtJQUM5RixDQUFDO0lBRUQ7O09BRUc7SUFDSCxJQUFXLFNBQVM7UUFDbEIsbUVBQW1FO1FBQ25FLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQztZQUNyQyxPQUFPLEVBQUUsS0FBSztZQUNkLE1BQU0sRUFBRSxFQUFFO1lBQ1YsT0FBTyxFQUFFLEtBQUs7WUFDZCxRQUFRLEVBQUUsUUFBUTtZQUNsQixZQUFZLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtTQUNyQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFqQkQsNENBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGNkayA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2NkaycpO1xuXG4vKipcbiAqIEEgcG9saWN5IG1hbmFnZWQgYnkgQVdTXG4gKlxuICogRm9yIHRoaXMgbWFuYWdlZCBwb2xpY3ksIHlvdSBvbmx5IG5lZWQgdG8ga25vdyB0aGUgbmFtZSB0byBiZSBhYmxlIHRvIHVzZSBpdC5cbiAqXG4gKiBTb21lIG1hbmFnZWQgcG9saWN5IG5hbWVzIHN0YXJ0IHdpdGggXCJzZXJ2aWNlLXJvbGUvXCIsIHNvbWUgc3RhcnQgd2l0aFxuICogXCJqb2ItZnVuY3Rpb24vXCIsIGFuZCBzb21lIGRvbid0IHN0YXJ0IHdpdGggYW55dGhpbmcuIERvIGluY2x1ZGUgdGhlXG4gKiBwcmVmaXggd2hlbiBjb25zdHJ1Y3RpbmcgdGhpcyBvYmplY3QuXG4gKi9cbmV4cG9ydCBjbGFzcyBBd3NNYW5hZ2VkUG9saWN5IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBtYW5hZ2VkUG9saWN5TmFtZTogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHNjb3BlOiBjZGsuSUNvbnN0cnVjdCkge1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBcm4gb2YgdGhpcyBtYW5hZ2VkIHBvbGljeVxuICAgKi9cbiAgcHVibGljIGdldCBwb2xpY3lBcm4oKTogc3RyaW5nIHtcbiAgICAvLyB0aGUgYXJuIGlzIGluIHRoZSBmb3JtIG9mIC0gYXJuOmF3czppYW06OmF3czpwb2xpY3kvPHBvbGljeU5hbWU+XG4gICAgcmV0dXJuIHRoaXMuc2NvcGUubm9kZS5zdGFjay5mb3JtYXRBcm4oe1xuICAgICAgc2VydmljZTogXCJpYW1cIixcbiAgICAgIHJlZ2lvbjogXCJcIiwgLy8gbm8gcmVnaW9uIGZvciBtYW5hZ2VkIHBvbGljeVxuICAgICAgYWNjb3VudDogXCJhd3NcIiwgLy8gdGhlIGFjY291bnQgZm9yIGEgbWFuYWdlZCBwb2xpY3kgaXMgJ2F3cydcbiAgICAgIHJlc291cmNlOiBcInBvbGljeVwiLFxuICAgICAgcmVzb3VyY2VOYW1lOiB0aGlzLm1hbmFnZWRQb2xpY3lOYW1lXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==