import cdk = require('@aws-cdk/cdk');
import { IPrincipal, ServicePrincipalOpts } from './principals';
export declare class PolicyDocument extends cdk.Token implements cdk.IResolvedValuePostProcessor {
    private readonly baseDocument;
    private statements;
    private _autoAssignSids;
    /**
     * Creates a new IAM policy document.
     * @param defaultDocument An IAM policy document to use as an initial
     * policy. All statements of this document will be copied in.
     */
    constructor(baseDocument?: any);
    /**
     * Will automatically assign a unique SID to each statement, unless an SID is provided.
     */
    autoAssignSids(): void;
    resolve(_context: cdk.IResolveContext): any;
    /**
     * Removes duplicate statements
     */
    postProcess(input: any, _context: cdk.IResolveContext): any;
    readonly isEmpty: boolean;
    /**
     * The number of statements already added to this policy.
     * Can be used, for example, to generate uniuqe "sid"s within the policy.
     */
    readonly statementCount: number;
    /**
     * Adds a statement to the policy document.
     *
     * @param statement the statement to add.
     */
    addStatement(statement: PolicyStatement): PolicyDocument;
}
/**
 * Represents a statement in an IAM policy document.
 */
export declare class PolicyStatement extends cdk.Token {
    sid?: string;
    private action;
    private principal;
    private resource;
    private condition;
    private effect?;
    constructor(effect?: PolicyStatementEffect);
    addAction(action: string): PolicyStatement;
    addActions(...actions: string[]): PolicyStatement;
    /**
     * Indicates if this permission has a "Principal" section.
     */
    readonly hasPrincipal: boolean;
    addPrincipal(principal: IPrincipal): this;
    addAwsPrincipal(arn: string): this;
    addAwsAccountPrincipal(accountId: string): this;
    addArnPrincipal(arn: string): this;
    /**
     * Adds a service principal to this policy statement.
     *
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`).
     * @param opts    options for adding the service principal (such as specifying a principal in a different region)
     */
    addServicePrincipal(service: string, opts?: ServicePrincipalOpts): this;
    addFederatedPrincipal(federated: any, conditions: {
        [key: string]: any;
    }): this;
    addAccountRootPrincipal(): this;
    addCanonicalUserPrincipal(canonicalUserId: string): this;
    addAnyPrincipal(): this;
    addResource(arn: string): PolicyStatement;
    /**
     * Adds a ``"*"`` resource to this statement.
     */
    addAllResources(): PolicyStatement;
    addResources(...arns: string[]): PolicyStatement;
    /**
     * Indicates if this permission as at least one resource associated with it.
     */
    readonly hasResource: boolean;
    /**
     * @deprecated Use `statement.sid = value`
     */
    describe(sid: string): PolicyStatement;
    /**
     * Sets the permission effect to allow access to resources.
     */
    allow(): PolicyStatement;
    /**
     * Sets the permission effect to deny access to resources.
     */
    deny(): PolicyStatement;
    /**
     * Add a condition to the Policy
     */
    addCondition(key: string, value: any): PolicyStatement;
    /**
     * Add multiple conditions to the Policy
     */
    addConditions(conditions: {
        [key: string]: any;
    }): PolicyStatement;
    /**
     * Add a condition to the Policy.
     *
     * @deprecated For backwards compatibility. Use addCondition() instead.
     */
    setCondition(key: string, value: any): PolicyStatement;
    limitToAccount(accountId: string): PolicyStatement;
    resolve(_context: cdk.IResolveContext): any;
    toJson(): any;
}
export declare enum PolicyStatementEffect {
    Allow = "Allow",
    Deny = "Deny"
}
