import { Construct, IResource, Resource } from '@aws-cdk/cdk';
import { IGroup } from './group';
import { PolicyDocument, PolicyStatement } from './policy-document';
import { IRole } from './role';
import { IUser } from './user';
export interface IPolicy extends IResource {
    /**
     * @attribute
     */
    readonly policyName: string;
}
export interface PolicyProps {
    /**
     * The name of the policy. If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     *
     * @default - Uses the logical ID of the policy resource, which is ensured
     * to be unique within the stack.
     */
    readonly policyName?: string;
    /**
     * Users to attach this policy to.
     * You can also use `attachToUser(user)` to attach this policy to a user.
     *
     * @default - No users.
     */
    readonly users?: IUser[];
    /**
     * Roles to attach this policy to.
     * You can also use `attachToRole(role)` to attach this policy to a role.
     *
     * @default - No roles.
     */
    readonly roles?: IRole[];
    /**
     * Groups to attach this policy to.
     * You can also use `attachToGroup(group)` to attach this policy to a group.
     *
     * @default - No groups.
     */
    readonly groups?: IGroup[];
    /**
     * Initial set of permissions to add to this policy document.
     * You can also use `addPermission(statement)` to add permissions later.
     *
     * @default - No statements.
     */
    readonly statements?: PolicyStatement[];
}
/**
 * The AWS::IAM::Policy resource associates an IAM policy with IAM users, roles,
 * or groups. For more information about IAM policies, see [Overview of IAM
 * Policies](http://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
 * in the IAM User Guide guide.
 */
export declare class Policy extends Resource implements IPolicy {
    static fromPolicyName(scope: Construct, id: string, policyName: string): IPolicy;
    /**
     * The policy document.
     */
    readonly document: PolicyDocument;
    /**
     * The name of this policy.
     *
     * @attribute
     */
    readonly policyName: string;
    private readonly roles;
    private readonly users;
    private readonly groups;
    constructor(scope: Construct, id: string, props?: PolicyProps);
    /**
     * Adds a statement to the policy document.
     */
    addStatement(statement: PolicyStatement): void;
    /**
     * Attaches this policy to a user.
     */
    attachToUser(user: IUser): void;
    /**
     * Attaches this policy to a role.
     */
    attachToRole(role: IRole): void;
    /**
     * Attaches this policy to a group.
     */
    attachToGroup(group: IGroup): void;
    protected validate(): string[];
}
