"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const iam = require("../lib");
module.exports = {
    'automatic exports are created when attributes are referneced across stacks'(test) {
        // GIVEN
        const app = new cdk.App();
        const stackWithUser = new cdk.Stack(app, 'stack1');
        const stackWithGroup = new cdk.Stack(app, 'stack2');
        const user = new iam.User(stackWithUser, 'User');
        const group = new iam.Group(stackWithGroup, 'Group');
        // WHEN
        group.addUser(user);
        //
        // `group.addUser` adds the group to the user resource definition, so we expect
        // that an automatic export will be created for the group and the user's stack
        // to use ImportValue to import it.
        // note that order of "expect"s matters. we first need to synthesize the user's
        // stack so that the cross stack reference will be reported and only then the
        // group's stack. in the real world, App will take care of this.
        //
        // THEN
        assert_1.expect(stackWithUser).toMatch({
            Resources: {
                User00B015A1: {
                    Type: "AWS::IAM::User",
                    Properties: {
                        Groups: [{ "Fn::ImportValue": "stack2:ExportsOutputRefGroupC77FDACD8CF7DD5B" }]
                    }
                }
            }
        });
        assert_1.expect(stackWithGroup).toMatch({
            Outputs: {
                ExportsOutputRefGroupC77FDACD8CF7DD5B: {
                    Value: { Ref: "GroupC77FDACD" },
                    Export: { Name: "stack2:ExportsOutputRefGroupC77FDACD8CF7DD5B" }
                }
            },
            Resources: {
                GroupC77FDACD: {
                    Type: "AWS::IAM::Group"
                }
            }
        });
        test.done();
    },
    'cannot reference tokens across apps'(test) {
        // GIVEN
        const stack1 = new cdk.Stack();
        const stack2 = new cdk.Stack();
        const user = new iam.User(stack1, 'User');
        const group = new iam.Group(stack2, 'Group');
        group.addUser(user);
        // THEN
        test.throws(() => assert_1.SynthUtils.synthesize(stack1), /Cannot reference across apps/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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