"use strict";
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const iam = require("../lib");
module.exports = {
    'Grant.drop() returns a no-op grant'(test) {
        const stack = new cdk_1.Stack();
        const user = new iam.User(stack, 'poo');
        const grant = lib_1.Grant.drop(user, 'dropping me');
        test.ok(!grant.success, 'grant should not be successul');
        test.deepEqual(grant.principalStatement, undefined);
        test.deepEqual(grant.resourceStatement, undefined);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5ncmFudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3QuZ3JhbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHNDQUFxQztBQUVyQyxnQ0FBK0I7QUFDL0IsOEJBQStCO0FBRS9CLGlCQUFTO0lBQ1Asb0NBQW9DLENBQUMsSUFBVTtRQUM3QyxNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssRUFBRSxDQUFDO1FBQzFCLE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDeEMsTUFBTSxLQUFLLEdBQUcsV0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsYUFBYSxDQUFDLENBQUM7UUFFOUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsK0JBQStCLENBQUMsQ0FBQztRQUN6RCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUNwRCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUNuRCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0NBQ0YsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY2RrJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgeyBHcmFudCB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgaWFtID0gcmVxdWlyZSgnLi4vbGliJyk7XG5cbmV4cG9ydCA9IHtcbiAgJ0dyYW50LmRyb3AoKSByZXR1cm5zIGEgbm8tb3AgZ3JhbnQnKHRlc3Q6IFRlc3QpIHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuICAgIGNvbnN0IHVzZXIgPSBuZXcgaWFtLlVzZXIoc3RhY2ssICdwb28nKTtcbiAgICBjb25zdCBncmFudCA9IEdyYW50LmRyb3AodXNlciwgJ2Ryb3BwaW5nIG1lJyk7XG5cbiAgICB0ZXN0Lm9rKCFncmFudC5zdWNjZXNzLCAnZ3JhbnQgc2hvdWxkIG5vdCBiZSBzdWNjZXNzdWwnKTtcbiAgICB0ZXN0LmRlZXBFcXVhbChncmFudC5wcmluY2lwYWxTdGF0ZW1lbnQsIHVuZGVmaW5lZCk7XG4gICAgdGVzdC5kZWVwRXF1YWwoZ3JhbnQucmVzb3VyY2VTdGF0ZW1lbnQsIHVuZGVmaW5lZCk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH1cbn07Il19