# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 2.1.0
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from songtradr_api_client_python.models.recording_for_similarity_search_dto import RecordingForSimilaritySearchDTO
from songtradr_api_client_python.models.recording_list_dto import RecordingListDTO
from songtradr_api_client_python.models.recording_medium_dto import RecordingMediumDTO
from songtradr_api_client_python.models.recording_minimal_with_musical_features_dto import RecordingMinimalWithMusicalFeaturesDTO
from songtradr_api_client_python.models.recording_minimal_with_taggrams_dto import RecordingMinimalWithTaggramsDTO
from songtradr_api_client_python.models.recording_minimal_with_tagstrengths_dto import RecordingMinimalWithTagstrengthsDTO

from songtradr_api_client_python.api_client import ApiClient, RequestSerialized
from songtradr_api_client_python.api_response import ApiResponse
from songtradr_api_client_python.rest import RESTResponseType


class RecordingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def prompt_search_recordings(
        self,
        query: Annotated[StrictStr, Field(description="Query.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RecordingListDTO:
        """Recordings for query.


        :param query: Query. (required)
        :type query: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._prompt_search_recordings_serialize(
            query=query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def prompt_search_recordings_with_http_info(
        self,
        query: Annotated[StrictStr, Field(description="Query.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RecordingListDTO]:
        """Recordings for query.


        :param query: Query. (required)
        :type query: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._prompt_search_recordings_serialize(
            query=query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def prompt_search_recordings_without_preload_content(
        self,
        query: Annotated[StrictStr, Field(description="Query.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Recordings for query.


        :param query: Query. (required)
        :type query: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._prompt_search_recordings_serialize(
            query=query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _prompt_search_recordings_serialize(
        self,
        query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/promptSearch',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_by_ids_with_musical_features(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMinimalWithMusicalFeaturesDTO]:
        """(Deprecated) AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/musicalFeatures is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_musical_features_serialize(
            ids=ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithMusicalFeaturesDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_by_ids_with_musical_features_with_http_info(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMinimalWithMusicalFeaturesDTO]]:
        """(Deprecated) AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/musicalFeatures is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_musical_features_serialize(
            ids=ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithMusicalFeaturesDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_by_ids_with_musical_features_without_preload_content(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/musicalFeatures is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_musical_features_serialize(
            ids=ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithMusicalFeaturesDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_by_ids_with_musical_features_serialize(
        self,
        ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ids is not None:
            _path_params['ids'] = ids
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/{ids}/musicalFeatures',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_by_ids_with_similarities1(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        identical_only: Annotated[Optional[StrictBool], Field(description="Whether a result list shall include only identical recordings.")] = None,
        usage: Annotated[Optional[StrictStr], Field(description="Filter by recording usage.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingForSimilaritySearchDTO]:
        """(Deprecated) Similar recordings for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param identical_only: Whether a result list shall include only identical recordings.
        :type identical_only: bool
        :param usage: Filter by recording usage.
        :type usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/similarities is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_similarities1_serialize(
            ids=ids,
            identical_only=identical_only,
            usage=usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingForSimilaritySearchDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_by_ids_with_similarities1_with_http_info(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        identical_only: Annotated[Optional[StrictBool], Field(description="Whether a result list shall include only identical recordings.")] = None,
        usage: Annotated[Optional[StrictStr], Field(description="Filter by recording usage.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingForSimilaritySearchDTO]]:
        """(Deprecated) Similar recordings for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param identical_only: Whether a result list shall include only identical recordings.
        :type identical_only: bool
        :param usage: Filter by recording usage.
        :type usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/similarities is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_similarities1_serialize(
            ids=ids,
            identical_only=identical_only,
            usage=usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingForSimilaritySearchDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_by_ids_with_similarities1_without_preload_content(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        identical_only: Annotated[Optional[StrictBool], Field(description="Whether a result list shall include only identical recordings.")] = None,
        usage: Annotated[Optional[StrictStr], Field(description="Filter by recording usage.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Similar recordings for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param identical_only: Whether a result list shall include only identical recordings.
        :type identical_only: bool
        :param usage: Filter by recording usage.
        :type usage: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/similarities is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_similarities1_serialize(
            ids=ids,
            identical_only=identical_only,
            usage=usage,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingForSimilaritySearchDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_by_ids_with_similarities1_serialize(
        self,
        ids,
        identical_only,
        usage,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ids is not None:
            _path_params['ids'] = ids
        # process the query parameters
        if identical_only is not None:
            
            _query_params.append(('identicalOnly', identical_only))
            
        if usage is not None:
            
            _query_params.append(('usage', usage))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/{ids}/similarities',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_by_ids_with_taggrams1(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMinimalWithTaggramsDTO]:
        """(Deprecated) Timeseries of AI generated moods, musical features and more for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/taggrams is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_taggrams1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_by_ids_with_taggrams1_with_http_info(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMinimalWithTaggramsDTO]]:
        """(Deprecated) Timeseries of AI generated moods, musical features and more for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/taggrams is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_taggrams1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_by_ids_with_taggrams1_without_preload_content(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Timeseries of AI generated moods, musical features and more for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/taggrams is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_taggrams1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_by_ids_with_taggrams1_serialize(
        self,
        ids,
        category_name,
        tag_name,
        genre_name,
        from_timestamp,
        to_timestamp,
        fill_with_zero,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ids is not None:
            _path_params['ids'] = ids
        # process the query parameters
        if category_name is not None:
            
            _query_params.append(('categoryName', category_name))
            
        if tag_name is not None:
            
            _query_params.append(('tagName', tag_name))
            
        if genre_name is not None:
            
            _query_params.append(('genreName', genre_name))
            
        if from_timestamp is not None:
            
            _query_params.append(('fromTimestamp', from_timestamp))
            
        if to_timestamp is not None:
            
            _query_params.append(('toTimestamp', to_timestamp))
            
        if fill_with_zero is not None:
            
            _query_params.append(('fillWithZero', fill_with_zero))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/{ids}/taggrams',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_by_ids_with_tagstrengths1(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMinimalWithTagstrengthsDTO]:
        """(Deprecated) Strengths as numerical representations for AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/tagstrengths is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_tagstrengths1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_by_ids_with_tagstrengths1_with_http_info(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMinimalWithTagstrengthsDTO]]:
        """(Deprecated) Strengths as numerical representations for AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/tagstrengths is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_tagstrengths1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_by_ids_with_tagstrengths1_without_preload_content(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Strengths as numerical representations for AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/tagstrengths is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_tagstrengths1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_by_ids_with_tagstrengths1_serialize(
        self,
        ids,
        category_name,
        tag_name,
        genre_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ids is not None:
            _path_params['ids'] = ids
        # process the query parameters
        if category_name is not None:
            
            _query_params.append(('categoryName', category_name))
            
        if tag_name is not None:
            
            _query_params.append(('tagName', tag_name))
            
        if genre_name is not None:
            
            _query_params.append(('genreName', genre_name))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/{ids}/tagstrengths',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_medium_by_ids1(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMediumDTO]:
        """(Deprecated) Recordings by IDs with a medium sized response.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/m/{ids} is deprecated.", DeprecationWarning)

        _param = self._recordings_medium_by_ids1_serialize(
            ids=ids,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMediumDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_medium_by_ids1_with_http_info(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMediumDTO]]:
        """(Deprecated) Recordings by IDs with a medium sized response.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/m/{ids} is deprecated.", DeprecationWarning)

        _param = self._recordings_medium_by_ids1_serialize(
            ids=ids,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMediumDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_medium_by_ids1_without_preload_content(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Recordings by IDs with a medium sized response.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/m/{ids} is deprecated.", DeprecationWarning)

        _param = self._recordings_medium_by_ids1_serialize(
            ids=ids,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMediumDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_medium_by_ids1_serialize(
        self,
        ids,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ids is not None:
            _path_params['ids'] = ids
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/m/{ids}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_recordings(
        self,
        similar_to_recording: Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording.")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre: Annotated[Optional[StrictStr], Field(description="Search for a genre.")] = None,
        primary_mood_cluster: Annotated[Optional[StrictStr], Field(description="Search for a mood.")] = None,
        valence: Annotated[Optional[StrictStr], Field(description="Search for valence.")] = None,
        arousal: Annotated[Optional[StrictStr], Field(description="Search for arousal.")] = None,
        pleasantness: Annotated[Optional[StrictStr], Field(description="Search for pleasantness.")] = None,
        engagement: Annotated[Optional[StrictStr], Field(description="Search for an engagement.")] = None,
        vocals: Annotated[Optional[StrictStr], Field(description="Search for a vocals gender or instrumental songs.")] = None,
        dominant_instrument: Annotated[Optional[StrictStr], Field(description="Search for a dominant instrument.")] = None,
        energy: Annotated[Optional[StrictStr], Field(description="Search for energy.")] = None,
        sound_generation: Annotated[Optional[StrictStr], Field(description="Search for type of sound generation.")] = None,
        tempo: Annotated[Optional[StrictStr], Field(description="Search for tempo.")] = None,
        scale: Annotated[Optional[StrictStr], Field(description="Search for tonal scale.")] = None,
        key: Annotated[Optional[StrictStr], Field(description="Search for harmonic key.")] = None,
        rhythm: Annotated[Optional[StrictStr], Field(description="Search for rhythm.")] = None,
        primary_sound_character: Annotated[Optional[StrictStr], Field(description="Search for a sound character.")] = None,
        timbre: Annotated[Optional[StrictStr], Field(description="Search for timbre.")] = None,
        roughness: Annotated[Optional[StrictStr], Field(description="Search for roughness.")] = None,
        tonality: Annotated[Optional[StrictStr], Field(description="Search for tonality.")] = None,
        harmony: Annotated[Optional[StrictStr], Field(description="Search for a degree of harmoniousness.")] = None,
        texture: Annotated[Optional[StrictStr], Field(description="Search for texture.")] = None,
        groovyness: Annotated[Optional[StrictStr], Field(description="Search for groovyness.")] = None,
        space: Annotated[Optional[StrictStr], Field(description="Search for space.")] = None,
        loudness: Annotated[Optional[StrictStr], Field(description="Search for loudness.")] = None,
        origin_decade: Annotated[Optional[StrictStr], Field(description="Search for origin decade.")] = None,
        curateability: Annotated[Optional[StrictStr], Field(description="Search for curateability.")] = None,
        use_case: Annotated[Optional[StrictStr], Field(description="Search for use case.")] = None,
        channel_suitability: Annotated[Optional[StrictStr], Field(description="Search for channel suitability.")] = None,
        songtradr_track_id: Annotated[Optional[StrictStr], Field(description="Search for Songtradr track id.")] = None,
        usage: Annotated[Optional[StrictStr], Field(description="Search for recording usage.")] = None,
        pretzel_station_suitability: Annotated[Optional[StrictStr], Field(description="Search for Pretzel station suitability.")] = None,
        similar_to_songtradr_track_id: Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording by songtradr Track Id.")] = None,
        shuffled: Annotated[Optional[StrictStr], Field(description="Sort the results randomly.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RecordingListDTO:
        """Recordings by contributors, moods, musical features and more.


        :param similar_to_recording: Search for songs similar to a recording.
        :type similar_to_recording: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre: Search for a genre.
        :type genre: str
        :param primary_mood_cluster: Search for a mood.
        :type primary_mood_cluster: str
        :param valence: Search for valence.
        :type valence: str
        :param arousal: Search for arousal.
        :type arousal: str
        :param pleasantness: Search for pleasantness.
        :type pleasantness: str
        :param engagement: Search for an engagement.
        :type engagement: str
        :param vocals: Search for a vocals gender or instrumental songs.
        :type vocals: str
        :param dominant_instrument: Search for a dominant instrument.
        :type dominant_instrument: str
        :param energy: Search for energy.
        :type energy: str
        :param sound_generation: Search for type of sound generation.
        :type sound_generation: str
        :param tempo: Search for tempo.
        :type tempo: str
        :param scale: Search for tonal scale.
        :type scale: str
        :param key: Search for harmonic key.
        :type key: str
        :param rhythm: Search for rhythm.
        :type rhythm: str
        :param primary_sound_character: Search for a sound character.
        :type primary_sound_character: str
        :param timbre: Search for timbre.
        :type timbre: str
        :param roughness: Search for roughness.
        :type roughness: str
        :param tonality: Search for tonality.
        :type tonality: str
        :param harmony: Search for a degree of harmoniousness.
        :type harmony: str
        :param texture: Search for texture.
        :type texture: str
        :param groovyness: Search for groovyness.
        :type groovyness: str
        :param space: Search for space.
        :type space: str
        :param loudness: Search for loudness.
        :type loudness: str
        :param origin_decade: Search for origin decade.
        :type origin_decade: str
        :param curateability: Search for curateability.
        :type curateability: str
        :param use_case: Search for use case.
        :type use_case: str
        :param channel_suitability: Search for channel suitability.
        :type channel_suitability: str
        :param songtradr_track_id: Search for Songtradr track id.
        :type songtradr_track_id: str
        :param usage: Search for recording usage.
        :type usage: str
        :param pretzel_station_suitability: Search for Pretzel station suitability.
        :type pretzel_station_suitability: str
        :param similar_to_songtradr_track_id: Search for songs similar to a recording by songtradr Track Id.
        :type similar_to_songtradr_track_id: str
        :param shuffled: Sort the results randomly.
        :type shuffled: str
        :param sort: Sort the results.
        :type sort: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_recordings_serialize(
            similar_to_recording=similar_to_recording,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre=genre,
            primary_mood_cluster=primary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            loudness=loudness,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            songtradr_track_id=songtradr_track_id,
            usage=usage,
            pretzel_station_suitability=pretzel_station_suitability,
            similar_to_songtradr_track_id=similar_to_songtradr_track_id,
            shuffled=shuffled,
            sort=sort,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_recordings_with_http_info(
        self,
        similar_to_recording: Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording.")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre: Annotated[Optional[StrictStr], Field(description="Search for a genre.")] = None,
        primary_mood_cluster: Annotated[Optional[StrictStr], Field(description="Search for a mood.")] = None,
        valence: Annotated[Optional[StrictStr], Field(description="Search for valence.")] = None,
        arousal: Annotated[Optional[StrictStr], Field(description="Search for arousal.")] = None,
        pleasantness: Annotated[Optional[StrictStr], Field(description="Search for pleasantness.")] = None,
        engagement: Annotated[Optional[StrictStr], Field(description="Search for an engagement.")] = None,
        vocals: Annotated[Optional[StrictStr], Field(description="Search for a vocals gender or instrumental songs.")] = None,
        dominant_instrument: Annotated[Optional[StrictStr], Field(description="Search for a dominant instrument.")] = None,
        energy: Annotated[Optional[StrictStr], Field(description="Search for energy.")] = None,
        sound_generation: Annotated[Optional[StrictStr], Field(description="Search for type of sound generation.")] = None,
        tempo: Annotated[Optional[StrictStr], Field(description="Search for tempo.")] = None,
        scale: Annotated[Optional[StrictStr], Field(description="Search for tonal scale.")] = None,
        key: Annotated[Optional[StrictStr], Field(description="Search for harmonic key.")] = None,
        rhythm: Annotated[Optional[StrictStr], Field(description="Search for rhythm.")] = None,
        primary_sound_character: Annotated[Optional[StrictStr], Field(description="Search for a sound character.")] = None,
        timbre: Annotated[Optional[StrictStr], Field(description="Search for timbre.")] = None,
        roughness: Annotated[Optional[StrictStr], Field(description="Search for roughness.")] = None,
        tonality: Annotated[Optional[StrictStr], Field(description="Search for tonality.")] = None,
        harmony: Annotated[Optional[StrictStr], Field(description="Search for a degree of harmoniousness.")] = None,
        texture: Annotated[Optional[StrictStr], Field(description="Search for texture.")] = None,
        groovyness: Annotated[Optional[StrictStr], Field(description="Search for groovyness.")] = None,
        space: Annotated[Optional[StrictStr], Field(description="Search for space.")] = None,
        loudness: Annotated[Optional[StrictStr], Field(description="Search for loudness.")] = None,
        origin_decade: Annotated[Optional[StrictStr], Field(description="Search for origin decade.")] = None,
        curateability: Annotated[Optional[StrictStr], Field(description="Search for curateability.")] = None,
        use_case: Annotated[Optional[StrictStr], Field(description="Search for use case.")] = None,
        channel_suitability: Annotated[Optional[StrictStr], Field(description="Search for channel suitability.")] = None,
        songtradr_track_id: Annotated[Optional[StrictStr], Field(description="Search for Songtradr track id.")] = None,
        usage: Annotated[Optional[StrictStr], Field(description="Search for recording usage.")] = None,
        pretzel_station_suitability: Annotated[Optional[StrictStr], Field(description="Search for Pretzel station suitability.")] = None,
        similar_to_songtradr_track_id: Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording by songtradr Track Id.")] = None,
        shuffled: Annotated[Optional[StrictStr], Field(description="Sort the results randomly.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RecordingListDTO]:
        """Recordings by contributors, moods, musical features and more.


        :param similar_to_recording: Search for songs similar to a recording.
        :type similar_to_recording: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre: Search for a genre.
        :type genre: str
        :param primary_mood_cluster: Search for a mood.
        :type primary_mood_cluster: str
        :param valence: Search for valence.
        :type valence: str
        :param arousal: Search for arousal.
        :type arousal: str
        :param pleasantness: Search for pleasantness.
        :type pleasantness: str
        :param engagement: Search for an engagement.
        :type engagement: str
        :param vocals: Search for a vocals gender or instrumental songs.
        :type vocals: str
        :param dominant_instrument: Search for a dominant instrument.
        :type dominant_instrument: str
        :param energy: Search for energy.
        :type energy: str
        :param sound_generation: Search for type of sound generation.
        :type sound_generation: str
        :param tempo: Search for tempo.
        :type tempo: str
        :param scale: Search for tonal scale.
        :type scale: str
        :param key: Search for harmonic key.
        :type key: str
        :param rhythm: Search for rhythm.
        :type rhythm: str
        :param primary_sound_character: Search for a sound character.
        :type primary_sound_character: str
        :param timbre: Search for timbre.
        :type timbre: str
        :param roughness: Search for roughness.
        :type roughness: str
        :param tonality: Search for tonality.
        :type tonality: str
        :param harmony: Search for a degree of harmoniousness.
        :type harmony: str
        :param texture: Search for texture.
        :type texture: str
        :param groovyness: Search for groovyness.
        :type groovyness: str
        :param space: Search for space.
        :type space: str
        :param loudness: Search for loudness.
        :type loudness: str
        :param origin_decade: Search for origin decade.
        :type origin_decade: str
        :param curateability: Search for curateability.
        :type curateability: str
        :param use_case: Search for use case.
        :type use_case: str
        :param channel_suitability: Search for channel suitability.
        :type channel_suitability: str
        :param songtradr_track_id: Search for Songtradr track id.
        :type songtradr_track_id: str
        :param usage: Search for recording usage.
        :type usage: str
        :param pretzel_station_suitability: Search for Pretzel station suitability.
        :type pretzel_station_suitability: str
        :param similar_to_songtradr_track_id: Search for songs similar to a recording by songtradr Track Id.
        :type similar_to_songtradr_track_id: str
        :param shuffled: Sort the results randomly.
        :type shuffled: str
        :param sort: Sort the results.
        :type sort: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_recordings_serialize(
            similar_to_recording=similar_to_recording,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre=genre,
            primary_mood_cluster=primary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            loudness=loudness,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            songtradr_track_id=songtradr_track_id,
            usage=usage,
            pretzel_station_suitability=pretzel_station_suitability,
            similar_to_songtradr_track_id=similar_to_songtradr_track_id,
            shuffled=shuffled,
            sort=sort,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_recordings_without_preload_content(
        self,
        similar_to_recording: Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording.")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre: Annotated[Optional[StrictStr], Field(description="Search for a genre.")] = None,
        primary_mood_cluster: Annotated[Optional[StrictStr], Field(description="Search for a mood.")] = None,
        valence: Annotated[Optional[StrictStr], Field(description="Search for valence.")] = None,
        arousal: Annotated[Optional[StrictStr], Field(description="Search for arousal.")] = None,
        pleasantness: Annotated[Optional[StrictStr], Field(description="Search for pleasantness.")] = None,
        engagement: Annotated[Optional[StrictStr], Field(description="Search for an engagement.")] = None,
        vocals: Annotated[Optional[StrictStr], Field(description="Search for a vocals gender or instrumental songs.")] = None,
        dominant_instrument: Annotated[Optional[StrictStr], Field(description="Search for a dominant instrument.")] = None,
        energy: Annotated[Optional[StrictStr], Field(description="Search for energy.")] = None,
        sound_generation: Annotated[Optional[StrictStr], Field(description="Search for type of sound generation.")] = None,
        tempo: Annotated[Optional[StrictStr], Field(description="Search for tempo.")] = None,
        scale: Annotated[Optional[StrictStr], Field(description="Search for tonal scale.")] = None,
        key: Annotated[Optional[StrictStr], Field(description="Search for harmonic key.")] = None,
        rhythm: Annotated[Optional[StrictStr], Field(description="Search for rhythm.")] = None,
        primary_sound_character: Annotated[Optional[StrictStr], Field(description="Search for a sound character.")] = None,
        timbre: Annotated[Optional[StrictStr], Field(description="Search for timbre.")] = None,
        roughness: Annotated[Optional[StrictStr], Field(description="Search for roughness.")] = None,
        tonality: Annotated[Optional[StrictStr], Field(description="Search for tonality.")] = None,
        harmony: Annotated[Optional[StrictStr], Field(description="Search for a degree of harmoniousness.")] = None,
        texture: Annotated[Optional[StrictStr], Field(description="Search for texture.")] = None,
        groovyness: Annotated[Optional[StrictStr], Field(description="Search for groovyness.")] = None,
        space: Annotated[Optional[StrictStr], Field(description="Search for space.")] = None,
        loudness: Annotated[Optional[StrictStr], Field(description="Search for loudness.")] = None,
        origin_decade: Annotated[Optional[StrictStr], Field(description="Search for origin decade.")] = None,
        curateability: Annotated[Optional[StrictStr], Field(description="Search for curateability.")] = None,
        use_case: Annotated[Optional[StrictStr], Field(description="Search for use case.")] = None,
        channel_suitability: Annotated[Optional[StrictStr], Field(description="Search for channel suitability.")] = None,
        songtradr_track_id: Annotated[Optional[StrictStr], Field(description="Search for Songtradr track id.")] = None,
        usage: Annotated[Optional[StrictStr], Field(description="Search for recording usage.")] = None,
        pretzel_station_suitability: Annotated[Optional[StrictStr], Field(description="Search for Pretzel station suitability.")] = None,
        similar_to_songtradr_track_id: Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording by songtradr Track Id.")] = None,
        shuffled: Annotated[Optional[StrictStr], Field(description="Sort the results randomly.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Recordings by contributors, moods, musical features and more.


        :param similar_to_recording: Search for songs similar to a recording.
        :type similar_to_recording: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre: Search for a genre.
        :type genre: str
        :param primary_mood_cluster: Search for a mood.
        :type primary_mood_cluster: str
        :param valence: Search for valence.
        :type valence: str
        :param arousal: Search for arousal.
        :type arousal: str
        :param pleasantness: Search for pleasantness.
        :type pleasantness: str
        :param engagement: Search for an engagement.
        :type engagement: str
        :param vocals: Search for a vocals gender or instrumental songs.
        :type vocals: str
        :param dominant_instrument: Search for a dominant instrument.
        :type dominant_instrument: str
        :param energy: Search for energy.
        :type energy: str
        :param sound_generation: Search for type of sound generation.
        :type sound_generation: str
        :param tempo: Search for tempo.
        :type tempo: str
        :param scale: Search for tonal scale.
        :type scale: str
        :param key: Search for harmonic key.
        :type key: str
        :param rhythm: Search for rhythm.
        :type rhythm: str
        :param primary_sound_character: Search for a sound character.
        :type primary_sound_character: str
        :param timbre: Search for timbre.
        :type timbre: str
        :param roughness: Search for roughness.
        :type roughness: str
        :param tonality: Search for tonality.
        :type tonality: str
        :param harmony: Search for a degree of harmoniousness.
        :type harmony: str
        :param texture: Search for texture.
        :type texture: str
        :param groovyness: Search for groovyness.
        :type groovyness: str
        :param space: Search for space.
        :type space: str
        :param loudness: Search for loudness.
        :type loudness: str
        :param origin_decade: Search for origin decade.
        :type origin_decade: str
        :param curateability: Search for curateability.
        :type curateability: str
        :param use_case: Search for use case.
        :type use_case: str
        :param channel_suitability: Search for channel suitability.
        :type channel_suitability: str
        :param songtradr_track_id: Search for Songtradr track id.
        :type songtradr_track_id: str
        :param usage: Search for recording usage.
        :type usage: str
        :param pretzel_station_suitability: Search for Pretzel station suitability.
        :type pretzel_station_suitability: str
        :param similar_to_songtradr_track_id: Search for songs similar to a recording by songtradr Track Id.
        :type similar_to_songtradr_track_id: str
        :param shuffled: Sort the results randomly.
        :type shuffled: str
        :param sort: Sort the results.
        :type sort: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_recordings_serialize(
            similar_to_recording=similar_to_recording,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre=genre,
            primary_mood_cluster=primary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            loudness=loudness,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            songtradr_track_id=songtradr_track_id,
            usage=usage,
            pretzel_station_suitability=pretzel_station_suitability,
            similar_to_songtradr_track_id=similar_to_songtradr_track_id,
            shuffled=shuffled,
            sort=sort,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_recordings_serialize(
        self,
        similar_to_recording,
        contributor,
        main_artist,
        composer,
        title,
        party_and_title,
        language,
        genre,
        primary_mood_cluster,
        valence,
        arousal,
        pleasantness,
        engagement,
        vocals,
        dominant_instrument,
        energy,
        sound_generation,
        tempo,
        scale,
        key,
        rhythm,
        primary_sound_character,
        timbre,
        roughness,
        tonality,
        harmony,
        texture,
        groovyness,
        space,
        loudness,
        origin_decade,
        curateability,
        use_case,
        channel_suitability,
        songtradr_track_id,
        usage,
        pretzel_station_suitability,
        similar_to_songtradr_track_id,
        shuffled,
        sort,
        page,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if similar_to_recording is not None:
            
            _query_params.append(('similarToRecording', similar_to_recording))
            
        if contributor is not None:
            
            _query_params.append(('contributor', contributor))
            
        if main_artist is not None:
            
            _query_params.append(('mainArtist', main_artist))
            
        if composer is not None:
            
            _query_params.append(('composer', composer))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if party_and_title is not None:
            
            _query_params.append(('partyAndTitle', party_and_title))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if genre is not None:
            
            _query_params.append(('genre', genre))
            
        if primary_mood_cluster is not None:
            
            _query_params.append(('primaryMoodCluster', primary_mood_cluster))
            
        if valence is not None:
            
            _query_params.append(('valence', valence))
            
        if arousal is not None:
            
            _query_params.append(('arousal', arousal))
            
        if pleasantness is not None:
            
            _query_params.append(('pleasantness', pleasantness))
            
        if engagement is not None:
            
            _query_params.append(('engagement', engagement))
            
        if vocals is not None:
            
            _query_params.append(('vocals', vocals))
            
        if dominant_instrument is not None:
            
            _query_params.append(('dominantInstrument', dominant_instrument))
            
        if energy is not None:
            
            _query_params.append(('energy', energy))
            
        if sound_generation is not None:
            
            _query_params.append(('soundGeneration', sound_generation))
            
        if tempo is not None:
            
            _query_params.append(('tempo', tempo))
            
        if scale is not None:
            
            _query_params.append(('scale', scale))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if rhythm is not None:
            
            _query_params.append(('rhythm', rhythm))
            
        if primary_sound_character is not None:
            
            _query_params.append(('primarySoundCharacter', primary_sound_character))
            
        if timbre is not None:
            
            _query_params.append(('timbre', timbre))
            
        if roughness is not None:
            
            _query_params.append(('roughness', roughness))
            
        if tonality is not None:
            
            _query_params.append(('tonality', tonality))
            
        if harmony is not None:
            
            _query_params.append(('harmony', harmony))
            
        if texture is not None:
            
            _query_params.append(('texture', texture))
            
        if groovyness is not None:
            
            _query_params.append(('groovyness', groovyness))
            
        if space is not None:
            
            _query_params.append(('space', space))
            
        if loudness is not None:
            
            _query_params.append(('loudness', loudness))
            
        if origin_decade is not None:
            
            _query_params.append(('originDecade', origin_decade))
            
        if curateability is not None:
            
            _query_params.append(('curateability', curateability))
            
        if use_case is not None:
            
            _query_params.append(('useCase', use_case))
            
        if channel_suitability is not None:
            
            _query_params.append(('channelSuitability', channel_suitability))
            
        if songtradr_track_id is not None:
            
            _query_params.append(('songtradrTrackId', songtradr_track_id))
            
        if usage is not None:
            
            _query_params.append(('usage', usage))
            
        if pretzel_station_suitability is not None:
            
            _query_params.append(('pretzelStationSuitability', pretzel_station_suitability))
            
        if similar_to_songtradr_track_id is not None:
            
            _query_params.append(('similarToSongtradrTrackId', similar_to_songtradr_track_id))
            
        if shuffled is not None:
            
            _query_params.append(('shuffled', shuffled))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/search',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


