"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from enum import Enum
from orq_poc_python_multi_env_version import models, utils
from orq_poc_python_multi_env_version._hooks import HookContext
from orq_poc_python_multi_env_version.metrics import Metrics
from orq_poc_python_multi_env_version.types import OptionalNullable, UNSET
from orq_poc_python_multi_env_version.utils import eventstreaming, get_security_from_env
from typing import Any, Dict, List, Optional, Union


class InvokeAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_EVENT_STREAM = "text/event-stream"


class DeploymentsSDK(BaseSDK):
    metrics: Metrics

    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.metrics = Metrics(self.sdk_configuration)

    def all(
        self,
        *,
        limit: Optional[float] = 10,
        after: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
    ) -> Optional[models.DeploymentsResponseBody]:
        r"""List all deployments

        Returns a list of your deployments. The deployments are returned sorted by creation date, with the most recent deployments appearing first.

        :param limit: A limit on the number of objects to be returned. Limit can range between 1 and 50, and the default is 10
        :param after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 20 objects, ending with `ed33dade-ae32-4959-8c5c-7ae4aad748b5`, your subsequent call can include `after=ed33dade-ae32-4959-8c5c-7ae4aad748b5` in order to fetch the next page of the list.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 600000

        if server_url is not None:
            base_url = server_url

        request = models.DeploymentsRequest(
            limit=limit,
            after=after,
        )

        req = self.build_request(
            method="GET",
            path="/v2/deployments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                operation_id="Deployments",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, Optional[models.DeploymentsResponseBody]
            )
        if utils.match_response(http_res, "500", "application/json"):
            data = utils.unmarshal_json(http_res.text, models.HonoAPIErrorData)
            raise models.HonoAPIError(data=data)
        if utils.match_response(http_res, ["4XX", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def all_async(
        self,
        *,
        limit: Optional[float] = 10,
        after: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
    ) -> Optional[models.DeploymentsResponseBody]:
        r"""List all deployments

        Returns a list of your deployments. The deployments are returned sorted by creation date, with the most recent deployments appearing first.

        :param limit: A limit on the number of objects to be returned. Limit can range between 1 and 50, and the default is 10
        :param after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 20 objects, ending with `ed33dade-ae32-4959-8c5c-7ae4aad748b5`, your subsequent call can include `after=ed33dade-ae32-4959-8c5c-7ae4aad748b5` in order to fetch the next page of the list.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 600000

        if server_url is not None:
            base_url = server_url

        request = models.DeploymentsRequest(
            limit=limit,
            after=after,
        )

        req = self.build_request_async(
            method="GET",
            path="/v2/deployments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                operation_id="Deployments",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, Optional[models.DeploymentsResponseBody]
            )
        if utils.match_response(http_res, "500", "application/json"):
            data = utils.unmarshal_json(http_res.text, models.HonoAPIErrorData)
            raise models.HonoAPIError(data=data)
        if utils.match_response(http_res, ["4XX", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get_config(
        self,
        *,
        key: str,
        inputs: Optional[
            Union[
                Dict[str, models.DeploymentGetConfigInputs],
                Dict[str, models.DeploymentGetConfigInputsTypedDict],
            ]
        ] = None,
        context: Optional[Dict[str, Any]] = None,
        prefix_messages: Optional[
            Union[
                List[models.DeploymentGetConfigPrefixMessages],
                List[models.DeploymentGetConfigPrefixMessagesTypedDict],
            ]
        ] = None,
        messages: Optional[
            Union[
                List[models.DeploymentGetConfigMessages],
                List[models.DeploymentGetConfigMessagesTypedDict],
            ]
        ] = None,
        file_ids: Optional[List[str]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        chain_id: Optional[str] = None,
        conversation_id: Optional[str] = None,
        user_id: Optional[
            Union[
                models.DeploymentGetConfigUserID,
                models.DeploymentGetConfigUserIDTypedDict,
            ]
        ] = None,
        deployment_id: Optional[str] = None,
        deployment_variant_id: Optional[str] = None,
        extra_params: Optional[Dict[str, Any]] = None,
        invoke_options: Optional[
            Union[
                models.DeploymentGetConfigInvokeOptions,
                models.DeploymentGetConfigInvokeOptionsTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
    ) -> Optional[models.DeploymentGetConfigResponseBody]:
        r"""Get config

        Retrieve the deployment configuration

        :param key: The deployment id to invoke
        :param inputs: Key-value pairs variables to replace in your prompts. If a variable is not provided that is defined in the prompt, the default variables are used.
        :param context: Key-value pairs that match your data model and fields declared in your configuration matrix. If you send multiple prompt keys, the context will be applied to the evaluation of each key.
        :param prefix_messages: A list of messages to include after the `System` message, but before the  `User` and `Assistant` pairs configured in your deployment.
        :param messages: A list of messages to send to the deployment.
        :param file_ids: A list of file IDs that are associated with the deployment request.
        :param metadata: Key-value pairs that you want to attach to the log generated by this request.
        :param chain_id: Unique ID that identifies a chaining operation. This is useful for tracking a chain of completions across multiple
        :param conversation_id: Unique ID that identifies a chat conversation. This is useful for tracking the same conversation across multiple requests
        :param user_id: Unique ID that identifies a user. This is useful for tracking the same user across multiple requests
        :param deployment_id: Unique ID that identifies a deployment entity.
        :param deployment_variant_id: Unique ID that identifies a specific variant of a deployment.
        :param extra_params: Utilized for passing additional parameters to the model provider. Exercise caution when using this feature, as the included parameters will overwrite any parameters specified in the deployment prompt configuration.
        :param invoke_options:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 600000

        if server_url is not None:
            base_url = server_url

        request = models.DeploymentGetConfigRequestBody(
            key=key,
            inputs=inputs,
            context=context,
            prefix_messages=utils.get_pydantic_model(
                prefix_messages,
                Optional[List[models.DeploymentGetConfigPrefixMessages]],
            ),
            messages=utils.get_pydantic_model(
                messages, Optional[List[models.DeploymentGetConfigMessages]]
            ),
            file_ids=file_ids,
            metadata=metadata,
            chain_id=chain_id,
            conversation_id=conversation_id,
            user_id=user_id,
            deployment_id=deployment_id,
            deployment_variant_id=deployment_variant_id,
            extra_params=extra_params,
            invoke_options=utils.get_pydantic_model(
                invoke_options, Optional[models.DeploymentGetConfigInvokeOptions]
            ),
        )

        req = self.build_request(
            method="POST",
            path="/v2/deployments/get_config",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.DeploymentGetConfigRequestBody
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                operation_id="DeploymentGetConfig",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, Optional[models.DeploymentGetConfigResponseBody]
            )
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(http_res, ["401", "4XX", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_config_async(
        self,
        *,
        key: str,
        inputs: Optional[
            Union[
                Dict[str, models.DeploymentGetConfigInputs],
                Dict[str, models.DeploymentGetConfigInputsTypedDict],
            ]
        ] = None,
        context: Optional[Dict[str, Any]] = None,
        prefix_messages: Optional[
            Union[
                List[models.DeploymentGetConfigPrefixMessages],
                List[models.DeploymentGetConfigPrefixMessagesTypedDict],
            ]
        ] = None,
        messages: Optional[
            Union[
                List[models.DeploymentGetConfigMessages],
                List[models.DeploymentGetConfigMessagesTypedDict],
            ]
        ] = None,
        file_ids: Optional[List[str]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        chain_id: Optional[str] = None,
        conversation_id: Optional[str] = None,
        user_id: Optional[
            Union[
                models.DeploymentGetConfigUserID,
                models.DeploymentGetConfigUserIDTypedDict,
            ]
        ] = None,
        deployment_id: Optional[str] = None,
        deployment_variant_id: Optional[str] = None,
        extra_params: Optional[Dict[str, Any]] = None,
        invoke_options: Optional[
            Union[
                models.DeploymentGetConfigInvokeOptions,
                models.DeploymentGetConfigInvokeOptionsTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
    ) -> Optional[models.DeploymentGetConfigResponseBody]:
        r"""Get config

        Retrieve the deployment configuration

        :param key: The deployment id to invoke
        :param inputs: Key-value pairs variables to replace in your prompts. If a variable is not provided that is defined in the prompt, the default variables are used.
        :param context: Key-value pairs that match your data model and fields declared in your configuration matrix. If you send multiple prompt keys, the context will be applied to the evaluation of each key.
        :param prefix_messages: A list of messages to include after the `System` message, but before the  `User` and `Assistant` pairs configured in your deployment.
        :param messages: A list of messages to send to the deployment.
        :param file_ids: A list of file IDs that are associated with the deployment request.
        :param metadata: Key-value pairs that you want to attach to the log generated by this request.
        :param chain_id: Unique ID that identifies a chaining operation. This is useful for tracking a chain of completions across multiple
        :param conversation_id: Unique ID that identifies a chat conversation. This is useful for tracking the same conversation across multiple requests
        :param user_id: Unique ID that identifies a user. This is useful for tracking the same user across multiple requests
        :param deployment_id: Unique ID that identifies a deployment entity.
        :param deployment_variant_id: Unique ID that identifies a specific variant of a deployment.
        :param extra_params: Utilized for passing additional parameters to the model provider. Exercise caution when using this feature, as the included parameters will overwrite any parameters specified in the deployment prompt configuration.
        :param invoke_options:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 600000

        if server_url is not None:
            base_url = server_url

        request = models.DeploymentGetConfigRequestBody(
            key=key,
            inputs=inputs,
            context=context,
            prefix_messages=utils.get_pydantic_model(
                prefix_messages,
                Optional[List[models.DeploymentGetConfigPrefixMessages]],
            ),
            messages=utils.get_pydantic_model(
                messages, Optional[List[models.DeploymentGetConfigMessages]]
            ),
            file_ids=file_ids,
            metadata=metadata,
            chain_id=chain_id,
            conversation_id=conversation_id,
            user_id=user_id,
            deployment_id=deployment_id,
            deployment_variant_id=deployment_variant_id,
            extra_params=extra_params,
            invoke_options=utils.get_pydantic_model(
                invoke_options, Optional[models.DeploymentGetConfigInvokeOptions]
            ),
        )

        req = self.build_request_async(
            method="POST",
            path="/v2/deployments/get_config",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.DeploymentGetConfigRequestBody
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                operation_id="DeploymentGetConfig",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, Optional[models.DeploymentGetConfigResponseBody]
            )
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(http_res, ["401", "4XX", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def invoke(
        self,
        *,
        key: str,
        stream: Optional[bool] = False,
        inputs: Optional[
            Union[Dict[str, models.Inputs], Dict[str, models.InputsTypedDict]]
        ] = None,
        context: Optional[Dict[str, Any]] = None,
        prefix_messages: Optional[
            Union[List[models.PrefixMessages], List[models.PrefixMessagesTypedDict]]
        ] = None,
        messages: Optional[
            Union[List[models.Messages], List[models.MessagesTypedDict]]
        ] = None,
        file_ids: Optional[List[str]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        chain_id: Optional[str] = None,
        conversation_id: Optional[str] = None,
        user_id: Optional[Union[models.UserID, models.UserIDTypedDict]] = None,
        deployment_id: Optional[str] = None,
        deployment_variant_id: Optional[str] = None,
        extra_params: Optional[Dict[str, Any]] = None,
        invoke_options: Optional[
            Union[models.InvokeOptions, models.InvokeOptionsTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[InvokeAcceptEnum] = None,
    ) -> Optional[models.DeploymentInvokeResponse]:
        r"""Invoke

        Invoke a deployment with a given payload

        :param key: The deployment id to invoke
        :param stream: If set, partial message content will be sent. Tokens will be sent as data-only `server-sent events` as they become available, with the stream terminated by a `data: [DONE]` message.
        :param inputs: Key-value pairs variables to replace in your prompts. If a variable is not provided that is defined in the prompt, the default variables are used.
        :param context: Key-value pairs that match your data model and fields declared in your configuration matrix. If you send multiple prompt keys, the context will be applied to the evaluation of each key.
        :param prefix_messages: A list of messages to include after the `System` message, but before the  `User` and `Assistant` pairs configured in your deployment.
        :param messages: A list of messages to send to the deployment.
        :param file_ids: A list of file IDs that are associated with the deployment request.
        :param metadata: Key-value pairs that you want to attach to the log generated by this request.
        :param chain_id: Unique ID that identifies a chaining operation. This is useful for tracking a chain of completions across multiple
        :param conversation_id: Unique ID that identifies a chat conversation. This is useful for tracking the same conversation across multiple requests
        :param user_id: Unique ID that identifies a user. This is useful for tracking the same user across multiple requests
        :param deployment_id: Unique ID that identifies a deployment entity.
        :param deployment_variant_id: Unique ID that identifies a specific variant of a deployment.
        :param extra_params: Utilized for passing additional parameters to the model provider. Exercise caution when using this feature, as the included parameters will overwrite any parameters specified in the deployment prompt configuration.
        :param invoke_options:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 600000

        if server_url is not None:
            base_url = server_url

        request = models.Deployments(
            key=key,
            stream=stream,
            inputs=inputs,
            context=context,
            prefix_messages=utils.get_pydantic_model(
                prefix_messages, Optional[List[models.PrefixMessages]]
            ),
            messages=utils.get_pydantic_model(
                messages, Optional[List[models.Messages]]
            ),
            file_ids=file_ids,
            metadata=metadata,
            chain_id=chain_id,
            conversation_id=conversation_id,
            user_id=user_id,
            deployment_id=deployment_id,
            deployment_variant_id=deployment_variant_id,
            extra_params=extra_params,
            invoke_options=utils.get_pydantic_model(
                invoke_options, Optional[models.InvokeOptions]
            ),
        )

        req = self.build_request(
            method="POST",
            path="/v2/deployments/invoke",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/event-stream;q=0",
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.Deployments
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                operation_id="DeploymentInvoke",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            http_response_text = utils.stream_to_text(http_res)
            return utils.unmarshal_json(
                http_response_text, Optional[models.DeploymentInvokeResponseBody]
            )
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.stream_events(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw, models.DeploymentInvokeDeploymentsResponseBody
                ),
                sentinel="[DONE]",
            )
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(http_res, ["4XX", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def invoke_async(
        self,
        *,
        key: str,
        stream: Optional[bool] = False,
        inputs: Optional[
            Union[Dict[str, models.Inputs], Dict[str, models.InputsTypedDict]]
        ] = None,
        context: Optional[Dict[str, Any]] = None,
        prefix_messages: Optional[
            Union[List[models.PrefixMessages], List[models.PrefixMessagesTypedDict]]
        ] = None,
        messages: Optional[
            Union[List[models.Messages], List[models.MessagesTypedDict]]
        ] = None,
        file_ids: Optional[List[str]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        chain_id: Optional[str] = None,
        conversation_id: Optional[str] = None,
        user_id: Optional[Union[models.UserID, models.UserIDTypedDict]] = None,
        deployment_id: Optional[str] = None,
        deployment_variant_id: Optional[str] = None,
        extra_params: Optional[Dict[str, Any]] = None,
        invoke_options: Optional[
            Union[models.InvokeOptions, models.InvokeOptionsTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[InvokeAcceptEnum] = None,
    ) -> Optional[models.DeploymentInvokeResponse]:
        r"""Invoke

        Invoke a deployment with a given payload

        :param key: The deployment id to invoke
        :param stream: If set, partial message content will be sent. Tokens will be sent as data-only `server-sent events` as they become available, with the stream terminated by a `data: [DONE]` message.
        :param inputs: Key-value pairs variables to replace in your prompts. If a variable is not provided that is defined in the prompt, the default variables are used.
        :param context: Key-value pairs that match your data model and fields declared in your configuration matrix. If you send multiple prompt keys, the context will be applied to the evaluation of each key.
        :param prefix_messages: A list of messages to include after the `System` message, but before the  `User` and `Assistant` pairs configured in your deployment.
        :param messages: A list of messages to send to the deployment.
        :param file_ids: A list of file IDs that are associated with the deployment request.
        :param metadata: Key-value pairs that you want to attach to the log generated by this request.
        :param chain_id: Unique ID that identifies a chaining operation. This is useful for tracking a chain of completions across multiple
        :param conversation_id: Unique ID that identifies a chat conversation. This is useful for tracking the same conversation across multiple requests
        :param user_id: Unique ID that identifies a user. This is useful for tracking the same user across multiple requests
        :param deployment_id: Unique ID that identifies a deployment entity.
        :param deployment_variant_id: Unique ID that identifies a specific variant of a deployment.
        :param extra_params: Utilized for passing additional parameters to the model provider. Exercise caution when using this feature, as the included parameters will overwrite any parameters specified in the deployment prompt configuration.
        :param invoke_options:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 600000

        if server_url is not None:
            base_url = server_url

        request = models.Deployments(
            key=key,
            stream=stream,
            inputs=inputs,
            context=context,
            prefix_messages=utils.get_pydantic_model(
                prefix_messages, Optional[List[models.PrefixMessages]]
            ),
            messages=utils.get_pydantic_model(
                messages, Optional[List[models.Messages]]
            ),
            file_ids=file_ids,
            metadata=metadata,
            chain_id=chain_id,
            conversation_id=conversation_id,
            user_id=user_id,
            deployment_id=deployment_id,
            deployment_variant_id=deployment_variant_id,
            extra_params=extra_params,
            invoke_options=utils.get_pydantic_model(
                invoke_options, Optional[models.InvokeOptions]
            ),
        )

        req = self.build_request_async(
            method="POST",
            path="/v2/deployments/invoke",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/event-stream;q=0",
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.Deployments
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                operation_id="DeploymentInvoke",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            http_response_text = await utils.stream_to_text_async(http_res)
            return utils.unmarshal_json(
                http_response_text, Optional[models.DeploymentInvokeResponseBody]
            )
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.stream_events_async(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw, models.DeploymentInvokeDeploymentsResponseBody
                ),
                sentinel="[DONE]",
            )
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(http_res, ["4XX", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
