/*
 * Decompiled with CFR 0.152.
 */
package statsmodels;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.python.PythonObject;
import org.jpmml.statsmodels.InterceptFeature;
import org.jpmml.statsmodels.StatsModelsEncoder;
import statsmodels.data.ModelData;

public abstract class Model
extends PythonObject {
    private static final Pattern TERM_INTERCEPT = Pattern.compile("Intercept");
    private static final Pattern TERM_BINARY_INDICATOR = Pattern.compile("C\\((.+)\\)\\[T\\.(.+)\\]");

    public Model(String module, String name) {
        super(module, name);
    }

    public abstract org.dmg.pmml.Model encodeModel(List<? extends Number> var1, Schema var2);

    public Schema encodeSchema(StatsModelsEncoder encoder) {
        List<String> exogNames;
        List<String> endogNames;
        ModelData data = this.getData();
        ModelData.Cache cache = data.getCache();
        if (cache.hasNames()) {
            endogNames = cache.getYNames();
            exogNames = cache.getXNames();
        } else {
            endogNames = data.getEndogNames();
            exogNames = data.getExogNames();
        }
        Label label = this.encodeLabel(endogNames, encoder);
        List<Feature> features = this.encodeFeatures(exogNames, encoder);
        return new Schema((ModelEncoder)encoder, label, features);
    }

    public Label encodeLabel(List<String> endogNames, StatsModelsEncoder encoder) {
        String endogName = (String)Iterables.getOnlyElement(endogNames);
        DataField dataField = encoder.createDataField(endogName, OpType.CONTINUOUS, DataType.DOUBLE);
        return new ContinuousLabel((Field)dataField);
    }

    public List<Feature> encodeFeatures(List<String> exogNames, StatsModelsEncoder encoder) {
        boolean expectIntercept;
        Integer kConstant = this.getKConstant();
        ArrayList<Feature> features = new ArrayList<Feature>();
        Matcher interceptMatcher = TERM_INTERCEPT.matcher("");
        Matcher binaryIndicatorMatcher = TERM_BINARY_INDICATOR.matcher("");
        if (kConstant == 0) {
            expectIntercept = false;
        } else if (kConstant == 1) {
            expectIntercept = true;
        } else {
            throw new IllegalArgumentException();
        }
        boolean isFormula = false;
        for (int i = 0; i < exogNames.size(); ++i) {
            String exogName = exogNames.get(i);
            if (i == 0 && expectIntercept && (interceptMatcher = interceptMatcher.reset(exogName)).matches()) {
                isFormula = true;
                features.add(new InterceptFeature((PMMLEncoder)encoder, exogName, DataType.DOUBLE));
                continue;
            }
            if (i < 0) continue;
            if ((binaryIndicatorMatcher = binaryIndicatorMatcher.reset(exogName)).matches()) {
                String name = binaryIndicatorMatcher.group(1);
                String value = binaryIndicatorMatcher.group(2);
                DataField dataField = encoder.getDataField(name);
                if (dataField == null) {
                    dataField = encoder.createDataField(name, OpType.CATEGORICAL, DataType.STRING);
                }
                if (!isFormula) {
                    FieldUtil.addValues((Field)dataField, Collections.singletonList(value));
                }
                features.add((Feature)new BinaryFeature((PMMLEncoder)encoder, (Field)dataField, (Object)value));
                continue;
            }
            if ("const".equals(exogName) && expectIntercept) {
                features.add(new InterceptFeature((PMMLEncoder)encoder, exogName, DataType.STRING));
                continue;
            }
            DataField dataField = encoder.createDataField(exogName, OpType.CONTINUOUS, DataType.DOUBLE);
            features.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)dataField));
        }
        return features;
    }

    public ModelData getData() {
        return (ModelData)((Object)this.get("data", ModelData.class));
    }

    public Integer getKConstant() {
        return this.getInteger("k_constant");
    }

    public Integer getKExtra() {
        return this.getInteger("k_extra");
    }

    public Integer getKVars() {
        return this.getInteger("k_vars");
    }

    protected static List<? extends Feature> dropInterceptFeature(List<? extends Feature> features, int index) {
        Feature feature = features.get(index);
        if (feature instanceof InterceptFeature) {
            InterceptFeature interceptFeature = (InterceptFeature)feature;
            features = new ArrayList<Feature>(features);
            features.remove((Object)interceptFeature);
            return features;
        }
        throw new IllegalArgumentException();
    }
}

