/*
 * Decompiled with CFR 0.152.
 */
package com.sklearn2pmml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.sun.istack.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.logging.LogManager;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Application;
import org.jpmml.converter.SAXTransformerUtil;
import org.jpmml.converter.VersionConverter;
import org.jpmml.converter.visitors.VersionStandardizer;
import org.jpmml.model.MarkupException;
import org.jpmml.model.filters.ExportFilter;
import org.jpmml.model.metro.MetroJAXBUtil;
import org.jpmml.model.visitors.VersionChecker;
import org.jpmml.python.PickleUtil;
import org.jpmml.python.Storage;
import org.jpmml.python.StorageUtil;
import org.jpmml.sklearn.Encodable;
import org.jpmml.sklearn.EncodableUtil;
import org.jpmml.sklearn.SkLearnUtil;
import org.xml.sax.XMLFilter;

public class Main
extends Application {
    @Parameter(names={"--pkl-pipeline-input", "--pkl-input"}, required=true)
    private File inputFile = null;
    @Parameter(names={"--pmml-output"}, required=true)
    private File outputFile = null;
    @Parameter(names={"--pmml-schema", "--schema"}, converter=VersionConverter.class)
    private Version version = null;
    private static final Logger logger;

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = JCommander.newBuilder().addObject((Object)main).build();
        commander.parse(args);
        try {
            Application.setInstance((Application)main);
            main.run();
        }
        finally {
            Application.setInstance(null);
        }
    }

    private void run() throws Exception {
        File absoluteOutputFile;
        File outputDir;
        Object object;
        try (Storage storage = StorageUtil.createStorage((File)this.inputFile);){
            object = PickleUtil.unpickle((Storage)storage);
        }
        Encodable encodable = EncodableUtil.toEncodable((Object)object);
        PMML pmml = encodable.encodePMML();
        if (!this.outputFile.exists() && !(outputDir = (absoluteOutputFile = this.outputFile.getAbsoluteFile()).getParentFile()).exists()) {
            outputDir.mkdirs();
        }
        if (this.version != null && this.version.compareTo((Enum)Version.PMML_4_4) < 0) {
            VersionStandardizer versionStandardizer = new VersionStandardizer();
            versionStandardizer.applyTo((Visitable)pmml);
            VersionChecker versionChecker = new VersionChecker(this.version);
            versionChecker.applyTo((Visitable)pmml);
            List exceptions = versionChecker.getExceptions();
            if (!exceptions.isEmpty()) {
                logger.severe("The PMML object has " + exceptions.size() + " incompatibilities with the requested PMML schema version:");
                LinkedHashMultiset groupedMessages = LinkedHashMultiset.create();
                for (MarkupException exception : exceptions) {
                    groupedMessages.add((Object)exception.getMessage());
                }
                Set entries = groupedMessages.entrySet();
                for (Multiset.Entry entry : entries) {
                    logger.warning((String)entry.getElement() + (entry.getCount() > 1 ? " (" + entry.getCount() + " cases)" : ""));
                }
            }
            File tempFile = File.createTempFile("sklearn2pmml-", ".pmml");
            FileOutputStream os = new FileOutputStream(tempFile);
            Object object2 = null;
            try {
                MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (os != null) {
                    if (object2 != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)os).close();
                    }
                }
            }
            SAXTransformerUtil.transform((File)tempFile, (File)this.outputFile, (XMLFilter[])new XMLFilter[]{new ExportFilter(this.version)});
            tempFile.delete();
        } else {
            try (FileOutputStream os = new FileOutputStream(this.outputFile);){
                MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            }
        }
    }

    static {
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration(Main.class.getResourceAsStream("/logging.properties"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        logger = Logger.getLogger(Main.class);
        SkLearnUtil.initOnce();
    }
}

