/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.FunctionUtil;
import org.jpmml.python.Identifiable;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.IdentifiableUtil;
import sklearn.SkLearnTransformer;

public class FunctionTransformer
extends SkLearnTransformer {
    public FunctionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Identifiable func = this.getFunc();
        if (func == null) {
            return features;
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            Apply expression = FunctionUtil.encodeFunction((Identifiable)func, Collections.singletonList(continuousFeature.ref()));
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName(func.getName(), continuousFeature), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public Identifiable getFunc() {
        return IdentifiableUtil.filter(this.getOptionalIdentifiable("func"));
    }

    public Identifiable getInverseFunc() {
        return IdentifiableUtil.filter(this.getOptionalIdentifiable("inverse_func"));
    }
}

