/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.Schema;
import org.jpmml.python.HasArray;
import org.jpmml.xgboost.ByteOrderUtil;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.GBTree;
import org.jpmml.xgboost.HasXGBoostOptions;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.ObjFunction;
import pandas.core.BlockManager;
import pandas.core.DataFrame;
import pandas.core.Index;
import sklearn.Estimator;
import xgboost.sklearn.Booster;
import xgboost.sklearn.HasBooster;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <E extends Estimator & HasXGBoostOptions> int getNumberOfFeatures(E estimator) {
        Learner learner = BoosterUtil.getLearner(estimator);
        return learner.num_feature();
    }

    public static <E extends Estimator & HasXGBoostOptions> ObjFunction getObjFunction(E estimator) {
        Learner learner = BoosterUtil.getLearner(estimator);
        return learner.obj();
    }

    public static <E extends Estimator & HasXGBoostOptions> MiningModel encodeModel(E estimator, Schema schema) {
        Booster booster = ((HasBooster)estimator).getBooster();
        Learner learner = BoosterUtil.getLearner(estimator);
        Map<String, ?> options = BoosterUtil.getOptions(booster, learner, estimator);
        Integer ntreeLimit = (Integer)options.get("ntree_limit");
        MiningModel miningModel = learner.encodeModel(ntreeLimit, schema);
        return miningModel;
    }

    public static <E extends Estimator & HasXGBoostOptions> Schema configureSchema(E estimator, Schema schema) {
        Booster booster = ((HasBooster)estimator).getBooster();
        Learner learner = BoosterUtil.getLearner(estimator);
        Map<String, ?> options = BoosterUtil.getOptions(booster, learner, estimator);
        Schema xgbSchema = learner.toXGBoostSchema(schema);
        xgbSchema = learner.configureSchema(options, xgbSchema);
        return xgbSchema;
    }

    public static <E extends Estimator & HasXGBoostOptions> MiningModel configureModel(E estimator, MiningModel miningModel) {
        Booster booster = ((HasBooster)estimator).getBooster();
        Learner learner = BoosterUtil.getLearner(estimator);
        Map<String, ?> options = BoosterUtil.getOptions(booster, learner, estimator);
        miningModel = learner.configureModel(options, miningModel);
        return miningModel;
    }

    public static PMML encodePMML(Booster booster) {
        FeatureMap featureMap = null;
        DataFrame fmap = booster.getFMap();
        if (fmap != null) {
            featureMap = BoosterUtil.parseFMap(fmap);
        }
        Learner learner = booster.getLearner(ByteOrder.nativeOrder(), null);
        Map<String, ?> options = BoosterUtil.getOptions(booster, learner);
        return learner.encodePMML(options, null, null, featureMap);
    }

    public static <E extends Estimator & HasXGBoostOptions> PMML encodePMML(E estimator) {
        Booster booster = ((HasBooster)estimator).getBooster();
        Learner learner = BoosterUtil.getLearner(estimator);
        Map<String, ?> options = BoosterUtil.getOptions(booster, learner, estimator);
        return learner.encodePMML(options, null, null, null);
    }

    private static <E extends Estimator & HasXGBoostOptions> Learner getLearner(E estimator) {
        Booster booster = ((HasBooster)estimator).getBooster();
        String byteOrder = (String)estimator.getOption("byte_order", (Object)ByteOrder.nativeOrder().toString());
        String charset = (String)estimator.getOption("charset", null);
        return booster.getLearner(ByteOrderUtil.forValue((String)byteOrder), charset);
    }

    private static Map<String, ?> getOptions(Booster booster, Learner learner) {
        Integer bestIteration;
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        Integer bestNTreeLimit = booster.getBestNTreeLimit();
        if (bestNTreeLimit == null && (bestIteration = learner.getBestIteration()) != null) {
            bestNTreeLimit = bestIteration + 1;
        }
        result.put("ntree_limit", bestNTreeLimit);
        return result;
    }

    private static <E extends Estimator & HasXGBoostOptions> Map<String, ?> getOptions(Booster booster, Learner learner, E estimator) {
        Integer bestIteration;
        GBTree gbtree = learner.gbtree();
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        Integer bestNTreeLimit = booster.getBestNTreeLimit();
        if (bestNTreeLimit == null) {
            bestNTreeLimit = (Integer)estimator.getOptionalScalar("best_ntree_limit");
        }
        if (bestNTreeLimit == null && (bestIteration = learner.getBestIteration()) != null) {
            bestNTreeLimit = bestIteration + 1;
        }
        Integer ntreeLimit = (Integer)estimator.getOption("ntree_limit", (Object)bestNTreeLimit);
        result.put("ntree_limit", ntreeLimit);
        Number missing = (Number)estimator.getOptionalScalar("missing");
        result.put("missing", missing);
        Boolean compact = (Boolean)estimator.getOption("compact", (Object)(!gbtree.hasCategoricalSplits() ? 1 : 0));
        Boolean inputFloat = (Boolean)estimator.getOption("input_float", null);
        Boolean numeric = (Boolean)estimator.getOption("numeric", (Object)Boolean.TRUE);
        Boolean prune = (Boolean)estimator.getOption("prune", (Object)Boolean.TRUE);
        result.put("compact", compact);
        result.put("input_float", inputFloat);
        result.put("numeric", numeric);
        result.put("prune", prune);
        return result;
    }

    private static FeatureMap parseFMap(DataFrame fmap) {
        BlockManager data = fmap.getData();
        Index columnAxis = data.getColumnAxis();
        Index rowAxis = data.getRowAxis();
        if (!Arrays.asList("id", "name", "type").equals(columnAxis.getValues())) {
            throw new IllegalArgumentException();
        }
        List blockValues = data.getBlockValues();
        HasArray idColumn = (HasArray)blockValues.get(0);
        HasArray nameTypeColumns = (HasArray)blockValues.get(1);
        List nameTypeContent = nameTypeColumns.getArrayContent();
        int[] nameTypeShape = nameTypeColumns.getArrayShape();
        List nameValues = CMatrixUtil.getRow((List)nameTypeContent, (int)nameTypeShape[0], (int)nameTypeShape[1], (int)0);
        List typeValues = CMatrixUtil.getRow((List)nameTypeContent, (int)nameTypeShape[0], (int)nameTypeShape[1], (int)1);
        FeatureMap result = new FeatureMap();
        for (int i = 0; i < nameTypeShape[1]; ++i) {
            String name = (String)nameValues.get(i);
            String type = (String)typeValues.get(i);
            result.addEntry(name, type);
        }
        return result;
    }
}

