/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class EnumLimitedEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap = new HashMap<String, Integer>();

    EnumLimitedEncoder(String columnName, int targetIndex, String[] domainValues, String[] newDomainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        for (int j = 0; j < newDomainValues.length; ++j) {
            this.domainMap.put(newDomainValues[j], j);
        }
        if (this.domainMap.containsKey("other")) {
            Integer otherIndex = this.domainMap.get("other");
            for (int j = 0; j < domainValues.length; ++j) {
                if (this.domainMap.containsKey(domainValues[j])) continue;
                this.domainMap.put(domainValues[j], otherIndex);
            }
            this.domainMap.remove("other");
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer levelIndex = this.domainMap.get(levelName);
        if (levelIndex == null) {
            levelIndex = this.domainMap.get(this.columnName + ".top_" + levelName + "_levels");
        }
        if (levelIndex == null) {
            return false;
        }
        rawData[this.targetIndex] = levelIndex.intValue();
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        rawData[this.targetIndex] = Double.NaN;
    }

    public String toString() {
        return "EnumLimited{columnName='" + this.columnName + '\'' + ", targetIndex=" + this.targetIndex + ", domainMap=" + this.domainMap + '}';
    }
}

