/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o;

import hex.genmodel.MojoModel;
import hex.genmodel.descriptor.ModelDescriptor;
import java.lang.reflect.Field;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.converter.Schema;
import org.jpmml.h2o.H2OEncoder;

public abstract class Converter<M extends MojoModel> {
    private M model = null;

    public Converter(M model) {
        this.setModel(model);
    }

    public abstract Model encodeModel(Schema var1);

    public Schema encodeSchema(H2OEncoder encoder) {
        M model = this.getModel();
        String[] names = model.getNames();
        int responseIdx = -1;
        if (model.isSupervised()) {
            responseIdx = model.getResponseIdx();
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String[] categories = model.getDomainValues(name);
            DataField dataField = encoder.createDataField(name, categories);
            if (i == responseIdx) {
                encoder.setLabel(dataField);
                continue;
            }
            encoder.addFeature(dataField);
        }
        return encoder.createSchema();
    }

    public Schema toMojoModelSchema(Schema schema) {
        return schema;
    }

    public PMML encodePMML() {
        String algorithmName;
        M model = this.getModel();
        ModelDescriptor modelDescriptor = ((MojoModel)model)._modelDescriptor;
        H2OEncoder encoder = new H2OEncoder();
        Schema schema = this.encodeSchema(encoder);
        schema = this.toMojoModelSchema(schema);
        Model pmmlModel = this.encodeModel(schema);
        if (modelDescriptor != null && (algorithmName = pmmlModel.getAlgorithmName()) == null) {
            String algoFullName = modelDescriptor.algoFullName();
            pmmlModel.setAlgorithmName(algoFullName);
        }
        return encoder.encodePMML(pmmlModel);
    }

    public M getModel() {
        return this.model;
    }

    private void setModel(M model) {
        this.model = (MojoModel)Objects.requireNonNull(model);
    }

    protected static Class<?> getDeclaredClass(Class<?> clazz, String name) throws ReflectiveOperationException {
        Class<?>[] declaredClazzes;
        String subclassName = clazz.getName() + "$" + name;
        for (Class<?> declaredClazz : declaredClazzes = clazz.getDeclaredClasses()) {
            if (!subclassName.equals(declaredClazz.getName())) continue;
            return declaredClazz;
        }
        throw new ClassNotFoundException(subclassName);
    }

    protected static <M extends MojoModel> Object getFieldValue(Field field, M model) {
        return Converter.getFieldValue(field, model);
    }

    protected static Object getFieldValue(Field field, Object object) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

