/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.razorvine.pickle.objects.ClassDict;
import net.razorvine.pickle.objects.ClassDictConstructor;
import org.jpmml.python.ClassDictConstructorUtil;
import org.jpmml.python.HasContent;

public class ClassDictUtil {
    private ClassDictUtil() {
    }

    public static void checkSize(Collection<?> ... collections) {
        Collection<?> prevCollection = null;
        for (Collection<?> collection : collections) {
            if (collection == null) continue;
            if (prevCollection != null && collection.size() != prevCollection.size()) {
                throw new IllegalArgumentException("Expected the same number of elements, got a different numbers of elements");
            }
            prevCollection = collection;
        }
    }

    public static void checkSize(int size, Collection<?> ... collections) {
        for (Collection<?> collection : collections) {
            if (collection == null || collection.size() == size) continue;
            throw new IllegalArgumentException("Expected " + size + " element(s), got " + collection.size() + " element(s)");
        }
    }

    public static void checkShapes(int axis, int[] ... shapes) {
        int[] prevShape = null;
        for (int[] shape : shapes) {
            if (prevShape != null && prevShape[axis] != shape[axis]) {
                throw new IllegalArgumentException("Expected the same number of elements, got a different number of elements");
            }
            prevShape = shape;
        }
    }

    public static void checkShapes(int axis, int size, int[] ... shapes) {
        for (int[] shape : shapes) {
            if (shape[axis] == size) continue;
            throw new IllegalArgumentException("Expected " + size + " element(s), got " + shape[axis] + " element(s)");
        }
    }

    public static Object[] extractArgs(Object[] args, int begin, int end) {
        Object[] result = new Object[end - begin];
        System.arraycopy(args, begin, result, 0, result.length);
        return result;
    }

    public static void clearContent(ClassDict dict) {
        if (dict instanceof HasContent) {
            HasContent hasContent = (HasContent)dict;
            hasContent.clearContent();
        }
        Collection values = dict.values();
        for (Object value : values) {
            if (!(value instanceof ClassDict)) continue;
            ClassDictUtil.clearContent((ClassDict)value);
        }
    }

    public static String formatMember(ClassDict dict, String name) {
        String clazz = dict.getClassName();
        return clazz + "." + name;
    }

    public static String formatClass(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ClassDict) {
            ClassDict dict = (ClassDict)object;
            return "Python class " + dict.getClassName();
        }
        if (object instanceof ClassDictConstructor) {
            ClassDictConstructor classDictConstructor = (ClassDictConstructor)object;
            return "Python class " + ClassDictConstructorUtil.getClassName(classDictConstructor);
        }
        Class<?> clazz = object.getClass();
        return "Java class " + clazz.getName();
    }

    public static String toString(ClassDict dict) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n{\n");
        String sep = "";
        ArrayList entries = new ArrayList(dict.entrySet());
        Comparator comparator = new Comparator<Map.Entry<String, ?>>(){

            @Override
            public int compare(Map.Entry<String, ?> left, Map.Entry<String, ?> right) {
                return left.getKey().compareToIgnoreCase(right.getKey());
            }
        };
        Collections.sort(entries, comparator);
        for (Map.Entry entry : entries) {
            sb.append(sep);
            sep = "\n";
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            sb.append("\t" + key + "=" + value + " // " + (value != null ? value.getClass().getName() : "N/A"));
        }
        sb.append("\n}\n");
        return sb.toString();
    }
}

