/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.List;
import java.util.function.Function;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.Identifiable;
import org.jpmml.python.RegExFlavour;
import org.jpmml.python.TranslationException;

public class FunctionUtil {
    private FunctionUtil() {
    }

    public static Apply encodeFunction(Identifiable identifiable, List<Expression> expressions) {
        return FunctionUtil.encodeFunction(identifiable.getModule(), identifiable.getName(), expressions);
    }

    public static Apply encodeFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("builtins")) {
            return FunctionUtil.encodePythonFunction(module, name, expressions);
        }
        if (module.equals("math")) {
            return FunctionUtil.encodeMathFunction(module, name, expressions);
        }
        if (module.equals("pcre") || module.equals("pcre2") || module.equals("re")) {
            return FunctionUtil.encodeRegExFunction(module, name, expressions);
        }
        if (module.equals("numpy") || module.startsWith("numpy.")) {
            return FunctionUtil.encodeNumpyFunction(module, name, expressions);
        }
        if (module.equals("pandas") || module.startsWith("pandas.")) {
            return FunctionUtil.encodePandasFunction(module, name, expressions);
        }
        if (module.equals("scipy") || module.startsWith("scipy.")) {
            return FunctionUtil.encodeScipyFunction(module, name, expressions);
        }
        throw new TranslationException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodePythonFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("builtins")) {
            switch (name) {
                case "len": {
                    return FunctionUtil.encodeUnaryFunction("stringLength", expressions);
                }
            }
        }
        throw new TranslationException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodeMathFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("math")) {
            switch (name) {
                case "acos": {
                    return FunctionUtil.encodeUnaryFunction("acos", expressions);
                }
                case "asin": {
                    return FunctionUtil.encodeUnaryFunction("asin", expressions);
                }
                case "atan": {
                    return FunctionUtil.encodeUnaryFunction("atan", expressions);
                }
                case "atan2": {
                    return FunctionUtil.encodeBinaryFunction("x-atan2", expressions);
                }
                case "ceil": {
                    return FunctionUtil.encodeUnaryFunction("ceil", expressions);
                }
                case "cos": {
                    return FunctionUtil.encodeUnaryFunction("cos", expressions);
                }
                case "cosh": {
                    return FunctionUtil.encodeUnaryFunction("cosh", expressions);
                }
                case "degrees": {
                    return FunctionUtil.rad2deg(expressions);
                }
                case "exp": {
                    return FunctionUtil.encodeUnaryFunction("exp", expressions);
                }
                case "expm1": {
                    return FunctionUtil.encodeUnaryFunction("expm1", expressions);
                }
                case "fabs": {
                    return FunctionUtil.encodeUnaryFunction("abs", expressions);
                }
                case "floor": {
                    return FunctionUtil.encodeUnaryFunction("floor", expressions);
                }
                case "hypot": {
                    return FunctionUtil.encodeUnaryFunction("hypot", expressions);
                }
                case "isnan": {
                    return FunctionUtil.encodeUnaryFunction("isMissing", expressions);
                }
                case "log": {
                    return FunctionUtil.encodeUnaryFunction("ln", expressions);
                }
                case "logp1": {
                    return FunctionUtil.encodeUnaryFunction("ln1p", expressions);
                }
                case "log10": {
                    return FunctionUtil.encodeUnaryFunction("log10", expressions);
                }
                case "pow": {
                    return FunctionUtil.encodeBinaryFunction("pow", expressions);
                }
                case "radians": {
                    return FunctionUtil.deg2rad(expressions);
                }
                case "sin": {
                    return FunctionUtil.encodeUnaryFunction("sin", expressions);
                }
                case "sinh": {
                    return FunctionUtil.encodeUnaryFunction("sinh", expressions);
                }
                case "sqrt": {
                    return FunctionUtil.encodeUnaryFunction("sqrt", expressions);
                }
                case "tan": {
                    return FunctionUtil.encodeUnaryFunction("tan", expressions);
                }
                case "tanh": {
                    return FunctionUtil.encodeUnaryFunction("tanh", expressions);
                }
                case "trunc": {
                    return FunctionUtil.trunc(expressions);
                }
            }
        }
        throw new TranslationException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodeRegExFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("pcre")) {
            switch (name) {
                case "search": {
                    return FunctionUtil.search(expressions, RegExFlavour.PCRE);
                }
                case "sub": {
                    return FunctionUtil.sub(expressions, RegExFlavour.PCRE);
                }
            }
        } else if (module.equals("pcre2")) {
            switch (name) {
                case "substitute": {
                    return FunctionUtil.sub(expressions, RegExFlavour.PCRE2);
                }
            }
        } else if (module.equals("re")) {
            switch (name) {
                case "search": {
                    return FunctionUtil.search(expressions, RegExFlavour.RE);
                }
                case "sub": {
                    return FunctionUtil.sub(expressions, RegExFlavour.RE);
                }
            }
        }
        throw new TranslationException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodeNumpyFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("numpy") || module.startsWith("numpy.")) {
            switch (name) {
                case "absolute": {
                    return FunctionUtil.encodeUnaryFunction("abs", expressions);
                }
                case "arccos": {
                    return FunctionUtil.encodeUnaryFunction("acos", expressions);
                }
                case "arcsin": {
                    return FunctionUtil.encodeUnaryFunction("asin", expressions);
                }
                case "arctan": {
                    return FunctionUtil.encodeUnaryFunction("atan", expressions);
                }
                case "arctan2": {
                    return FunctionUtil.encodeBinaryFunction("x-atan2", expressions);
                }
                case "ceil": {
                    return FunctionUtil.encodeUnaryFunction("ceil", expressions);
                }
                case "clip": {
                    return FunctionUtil.clip(expressions);
                }
                case "cos": {
                    return FunctionUtil.encodeUnaryFunction("cos", expressions);
                }
                case "cosh": {
                    return FunctionUtil.encodeUnaryFunction("cosh", expressions);
                }
                case "degrees": 
                case "rad2deg": {
                    return FunctionUtil.rad2deg(expressions);
                }
                case "exp": {
                    return FunctionUtil.encodeUnaryFunction("exp", expressions);
                }
                case "expm1": {
                    return FunctionUtil.encodeUnaryFunction("expm1", expressions);
                }
                case "floor": {
                    return FunctionUtil.encodeUnaryFunction("floor", expressions);
                }
                case "fmax": {
                    return FunctionUtil.encodeBinaryFunction("max", expressions);
                }
                case "fmin": {
                    return FunctionUtil.encodeBinaryFunction("min", expressions);
                }
                case "hypot": {
                    return FunctionUtil.encodeUnaryFunction("hypot", expressions);
                }
                case "isnan": {
                    return FunctionUtil.encodeUnaryFunction("isMissing", expressions);
                }
                case "log": {
                    return FunctionUtil.encodeUnaryFunction("ln", expressions);
                }
                case "logical_and": {
                    return FunctionUtil.encodeBinaryFunction("and", expressions);
                }
                case "logical_not": {
                    return FunctionUtil.encodeUnaryFunction("not", expressions);
                }
                case "logical_or": {
                    return FunctionUtil.encodeBinaryFunction("or", expressions);
                }
                case "log1p": {
                    return FunctionUtil.encodeUnaryFunction("ln1p", expressions);
                }
                case "log10": {
                    return FunctionUtil.encodeUnaryFunction("log10", expressions);
                }
                case "negative": {
                    return FunctionUtil.negative(expressions);
                }
                case "power": {
                    return FunctionUtil.encodeBinaryFunction("pow", expressions);
                }
                case "radians": 
                case "deg2rad": {
                    return FunctionUtil.deg2rad(expressions);
                }
                case "reciprocal": {
                    return FunctionUtil.reciprocal(expressions);
                }
                case "rint": {
                    return FunctionUtil.encodeUnaryFunction("rint", expressions);
                }
                case "sign": {
                    return FunctionUtil.sign(expressions);
                }
                case "sin": {
                    return FunctionUtil.encodeUnaryFunction("sin", expressions);
                }
                case "sinh": {
                    return FunctionUtil.encodeUnaryFunction("sinh", expressions);
                }
                case "sqrt": {
                    return FunctionUtil.encodeUnaryFunction("sqrt", expressions);
                }
                case "square": {
                    return FunctionUtil.square(expressions);
                }
                case "tan": {
                    return FunctionUtil.encodeUnaryFunction("tan", expressions);
                }
                case "tanh": {
                    return FunctionUtil.encodeUnaryFunction("tanh", expressions);
                }
                case "where": {
                    return FunctionUtil.where(expressions);
                }
            }
        }
        throw new TranslationException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodePandasFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("pandas")) {
            switch (name) {
                case "isna": 
                case "isnull": {
                    return FunctionUtil.encodeUnaryFunction("isMissing", expressions);
                }
                case "notna": 
                case "notnull": {
                    return FunctionUtil.encodeUnaryFunction("isNotMissing", expressions);
                }
            }
        }
        throw new TranslationException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodeScipyFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("scipy.special")) {
            switch (name) {
                case "expit": {
                    return FunctionUtil.expit(expressions);
                }
                case "logit": {
                    return FunctionUtil.logit(expressions);
                }
            }
        }
        throw new TranslationException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodeUnaryFunction(String function, List<Expression> expressions) {
        return ExpressionUtil.createApply((String)function, (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 1, 0)});
    }

    public static Apply encodeBinaryFunction(String function, List<Expression> expressions) {
        return ExpressionUtil.createApply((String)function, (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
    }

    private static Apply clip(List<Expression> expressions) {
        return ExpressionUtil.createApply((String)"min", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"max", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 3, 0), FunctionUtil.getElement(expressions, 3, 1)}), FunctionUtil.getElement(expressions, 3, 2)});
    }

    private static Apply deg2rad(List<Expression> expressions) {
        return ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), ExpressionUtil.createConstant((Number)(Math.PI / 180))});
    }

    private static Apply expit(List<Expression> expressions) {
        return ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)1), ExpressionUtil.createApply((String)"+", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)1), ExpressionUtil.createApply((String)"exp", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)-1), FunctionUtil.getOnlyElement(expressions)})})})});
    }

    private static Apply logit(List<Expression> expressions) {
        Expression expression = FunctionUtil.getOnlyElement(expressions);
        return ExpressionUtil.createApply((String)"ln", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{expression, ExpressionUtil.createApply((String)"-", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)1), expression})})});
    }

    private static Apply negative(List<Expression> expressions) {
        return ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)-1), FunctionUtil.getOnlyElement(expressions)});
    }

    private static Apply rad2deg(List<Expression> expressions) {
        return ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), ExpressionUtil.createConstant((Number)57.29577951308232)});
    }

    private static Apply reciprocal(List<Expression> expressions) {
        return ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{ExpressionUtil.createConstant((Number)1), FunctionUtil.getOnlyElement(expressions)});
    }

    private static Apply search(List<Expression> expressions, RegExFlavour reFlavour) {
        Expression[] expressionArray = new Expression[2];
        expressionArray[0] = FunctionUtil.getElement(expressions, 2, 1);
        expressionArray[1] = FunctionUtil.updateConstant(FunctionUtil.getElement(expressions, 2, 0), reFlavour::translatePattern);
        return ExpressionUtil.createApply((String)"matches", (Expression[])expressionArray).addExtensions(new Extension[]{PMMLUtil.createExtension((String)"re_flavour", (String)reFlavour.module())});
    }

    private static Apply sign(List<Expression> expressions) {
        Expression expression = FunctionUtil.getOnlyElement(expressions);
        return ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"lessThan", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)0)}), ExpressionUtil.createConstant((Number)-1), ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)0)}), ExpressionUtil.createConstant((Number)1), ExpressionUtil.createConstant((Number)0)})});
    }

    private static Apply square(List<Expression> expressions) {
        return ExpressionUtil.createApply((String)"pow", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), ExpressionUtil.createConstant((Number)2)});
    }

    private static Apply sub(List<Expression> expressions, RegExFlavour reFlavour) {
        Expression[] expressionArray = new Expression[3];
        expressionArray[0] = FunctionUtil.getElement(expressions, 3, 2);
        expressionArray[1] = FunctionUtil.updateConstant(FunctionUtil.getElement(expressions, 3, 0), reFlavour::translatePattern);
        expressionArray[2] = FunctionUtil.updateConstant(FunctionUtil.getElement(expressions, 3, 1), reFlavour::translateReplacement);
        return ExpressionUtil.createApply((String)"replace", (Expression[])expressionArray).addExtensions(new Extension[]{PMMLUtil.createExtension((String)"re_flavour", (String)reFlavour.module())});
    }

    private static Apply trunc(List<Expression> expressions) {
        Expression expression = FunctionUtil.getOnlyElement(expressions);
        return ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"lessThan", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)0)}), ExpressionUtil.createApply((String)"ceil", (Expression[])new Expression[]{expression}), ExpressionUtil.createApply((String)"floor", (Expression[])new Expression[]{expression})});
    }

    private static Apply where(List<Expression> expressions) {
        return ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 3, 0), FunctionUtil.getElement(expressions, 3, 1), FunctionUtil.getElement(expressions, 3, 2)});
    }

    private static String formatFunction(String module, String name) {
        return module + "." + name;
    }

    private static Expression updateConstant(Expression expression, Function<String, String> function) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            constant.setValue((Object)function.apply((String)constant.getValue()));
            return constant;
        }
        return expression;
    }

    private static Expression getOnlyElement(List<Expression> expressions) {
        ClassDictUtil.checkSize(1, expressions);
        return expressions.get(0);
    }

    private static Expression getElement(List<Expression> expressions, int expectedSize, int index) {
        ClassDictUtil.checkSize(expectedSize, expressions);
        return expressions.get(index);
    }
}

