/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import category_encoders.BaseEncoder;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.AttributeException;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PythonObject;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.Series;
import pandas.core.SeriesUtil;
import sklearn.Transformer;
import sklearn.preprocessing.EncoderUtil;

public class OrdinalEncoder
extends BaseEncoder {
    public static final Object CATEGORY_UNKNOWN = -1;

    public OrdinalEncoder(String module, String name) {
        super(module, name);
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Boolean dropInvariant = this.getDropInvariant();
        String handleMissing = this.getHandleMissing();
        String handleUnknown = this.getHandleUnknown();
        List<Mapping> mappings = this.getMapping();
        Integer mapMissingTo = null;
        if (Objects.equals("value", handleMissing)) {
            mapMissingTo = -1;
        }
        Integer defaultValue = null;
        if (Objects.equals("value", handleUnknown)) {
            defaultValue = -2;
        }
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, mappings});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Mapping mapping = mappings.get(i);
            Map<?, Integer> categoryMappings = mapping.getCategoryMapping();
            ArrayList categories = new ArrayList(categoryMappings.keySet());
            ArrayList<Integer> indexCategories = new ArrayList<Integer>(categoryMappings.values());
            encoder.toCategorical(feature.getName(), EncoderUtil.filterCategories(categories));
            result.add(EncoderUtil.encodeIndexFeature((Transformer)this, (Feature)feature, categories, indexCategories, (Number)mapMissingTo, (Number)defaultValue, (DataType)DataType.INTEGER, (SkLearnEncoder)encoder));
        }
        return result;
    }

    public List<Mapping> getMapping() {
        List mapping = this.getList("mapping", Map.class);
        Function function = new Function<Map<String, ?>, Mapping>(){

            public Mapping apply(Map<String, ?> map) {
                Mapping mapping = new Mapping(OrdinalEncoder.this.getClassName(), "mapping");
                mapping.update(map);
                return mapping;
            }
        };
        return Lists.transform((List)mapping, (Function)function);
    }

    public static class Mapping
    extends PythonObject {
        private Mapping(String module, String name) {
            super(module, name);
        }

        public Map<?, Integer> getCategoryMapping() {
            try {
                Series mapping = (Series)this.get("mapping", Series.class);
                return SeriesUtil.toMap((Series)mapping, (Function)Functions.identity(), ValueUtil::asInteger);
            }
            catch (AttributeException ae) {
                return this.getDict("mapping");
            }
        }
    }
}

