/*
 * Decompiled with CFR 0.152.
 */
package hpsklearn;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.converter.Schema;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.Encodable;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Composite;
import sklearn.Estimator;
import sklearn.Step;
import sklearn.StepUtil;
import sklearn.Transformer;

public class HyperoptEstimator
extends Composite
implements Encodable {
    public HyperoptEstimator(String module, String name) {
        super(module, name);
    }

    public boolean hasTransformers() {
        Object[] bestPreprocs = this.getBestPreprocs();
        return bestPreprocs.length > 0;
    }

    public boolean hasFinalEstimator() {
        return true;
    }

    public List<? extends Transformer> getTransformers() {
        Object[] bestPreprocs = this.getBestPreprocs();
        CastFunction<Transformer> castFunction = new CastFunction<Transformer>(Transformer.class){

            public String formatMessage(Object object) {
                return "The pre-processor object (" + ClassDictUtil.formatClass((Object)object) + ") is not a supported Transformer";
            }
        };
        return Arrays.stream(bestPreprocs).map(castFunction).collect(Collectors.toList());
    }

    public Estimator getFinalEstimator() {
        return this.getFinalEstimator(Estimator.class);
    }

    public <E extends Estimator> E getFinalEstimator(Class<? extends E> clazz) {
        E bestLearner = this.getBestLearner(clazz);
        return bestLearner;
    }

    public Step getHead() {
        List<? extends Transformer> transformers = this.getTransformers();
        if (!transformers.isEmpty()) {
            Transformer transformer = transformers.get(0);
            return StepUtil.getHead((Step)transformer);
        }
        Estimator estimator = this.getFinalEstimator();
        return StepUtil.getHead((Step)estimator);
    }

    public PMML encodePMML() {
        SkLearnEncoder encoder = new SkLearnEncoder();
        Estimator estimator = this.getFinalEstimator();
        this.initLabel(null, encoder);
        this.initFeatures(null, encoder);
        Schema schema = encoder.createSchema();
        Model model = estimator.encode(schema);
        encoder.setModel(model);
        return encoder.encodePMML(model);
    }

    public Estimator getBestLearner() {
        return this.getBestLearner(Estimator.class);
    }

    public <E extends Estimator> E getBestLearner(Class<? extends E> clazz) {
        return (E)((Estimator)this.get("_best_learner", clazz));
    }

    public Object[] getBestPreprocs() {
        return this.getTuple("_best_preprocs");
    }
}

