# Slack Resource Provider

The Slack Provider enables you to manage Slack resources via Pulumi.

## Installing

This package is available for several languages/platforms:

### Node.js (JavaScript/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

```bash
npm install @pulumi/slack
```

or `yarn`:

```bash
yarn add @pulumi/slack
```

### Python

To use from Python, install using `pip`:

```bash
pip install pulumi_slack
```

### Go

To use from Go, use `go get` to grab the latest version of the library:

```bash
go get github.com/pulumi/pulumi-slack/sdk/go/...
```

### .NET

To use from .NET, install using `dotnet add package`:

```bash
dotnet add package Pulumi.Slack
```

## Configuration

The following configuration points are available for the `slack` provider:

- `slack:token` (environment: `SLACK_TOKEN`) - the token for your slack workspace

## Reference

For detailed reference documentation, please visit [the Pulumi registry](https://www.pulumi.com/registry/packages/slack/api-docs/).
