# moneyx/currency.py - Generated from ISO 4217 data
from typing import Any, ClassVar, Dict, List, Optional

from moneyx.exceptions import InvalidCurrencyError


class Currency:
    _known: ClassVar[Dict[str, Dict[str, Any]]] = {
        "AED": {
            "symbol": "د.إ",
            "decimals": 2,
            "name": "UAE Dirham",
            "number": "784",
            "countries": ["UNITED ARAB EMIRATES (THE)"],
        },
        "AFN": {
            "symbol": "AFN",
            "decimals": 2,
            "name": "Afghani",
            "number": "971",
            "countries": ["AFGHANISTAN"],
        },
        "ALL": {
            "symbol": "ALL",
            "decimals": 2,
            "name": "Lek",
            "number": "008",
            "countries": ["ALBANIA"],
        },
        "AMD": {
            "symbol": "AMD",
            "decimals": 2,
            "name": "Armenian Dram",
            "number": "051",
            "countries": ["ARMENIA"],
        },
        "AOA": {
            "symbol": "AOA",
            "decimals": 2,
            "name": "Kwanza",
            "number": "973",
            "countries": ["ANGOLA"],
        },
        "ARS": {
            "symbol": "$",
            "decimals": 2,
            "name": "Argentine Peso",
            "number": "032",
            "countries": ["ARGENTINA"],
        },
        "AUD": {
            "symbol": "A$",
            "decimals": 2,
            "name": "Australian Dollar",
            "number": "036",
            "countries": [
                "AUSTRALIA",
                "CHRISTMAS ISLAND",
                "COCOS (KEELING) ISLANDS (THE)",
                "HEARD ISLAND AND McDONALD ISLANDS",
                "KIRIBATI",
                "NAURU",
                "NORFOLK ISLAND",
                "TUVALU",
            ],
        },
        "AWG": {
            "symbol": "AWG",
            "decimals": 2,
            "name": "Aruban Florin",
            "number": "533",
            "countries": ["ARUBA"],
        },
        "AZN": {
            "symbol": "AZN",
            "decimals": 2,
            "name": "Azerbaijan Manat",
            "number": "944",
            "countries": ["AZERBAIJAN"],
        },
        "BAM": {
            "symbol": "BAM",
            "decimals": 2,
            "name": "Convertible Mark",
            "number": "977",
            "countries": ["BOSNIA AND HERZEGOVINA"],
        },
        "BBD": {
            "symbol": "BBD",
            "decimals": 2,
            "name": "Barbados Dollar",
            "number": "052",
            "countries": ["BARBADOS"],
        },
        "BDT": {
            "symbol": "BDT",
            "decimals": 2,
            "name": "Taka",
            "number": "050",
            "countries": ["BANGLADESH"],
        },
        "BGN": {
            "symbol": "BGN",
            "decimals": 2,
            "name": "Bulgarian Lev",
            "number": "975",
            "countries": ["BULGARIA"],
        },
        "BHD": {
            "symbol": "د.ب",
            "decimals": 3,
            "name": "Bahraini Dinar",
            "number": "048",
            "countries": ["BAHRAIN"],
        },
        "BIF": {
            "symbol": "FBu",
            "decimals": 0,
            "name": "Burundi Franc",
            "number": "108",
            "countries": ["BURUNDI"],
        },
        "BMD": {
            "symbol": "BMD",
            "decimals": 2,
            "name": "Bermudian Dollar",
            "number": "060",
            "countries": ["BERMUDA"],
        },
        "BND": {
            "symbol": "BND",
            "decimals": 2,
            "name": "Brunei Dollar",
            "number": "096",
            "countries": ["BRUNEI DARUSSALAM"],
        },
        "BOB": {
            "symbol": "Bs.",
            "decimals": 2,
            "name": "Boliviano",
            "number": "068",
            "countries": ["BOLIVIA (PLURINATIONAL STATE OF)"],
        },
        "BOV": {
            "symbol": "BOV",
            "decimals": 2,
            "name": "Mvdol",
            "number": "984",
            "countries": ["BOLIVIA (PLURINATIONAL STATE OF)"],
        },
        "BRL": {
            "symbol": "R$",
            "decimals": 2,
            "name": "Brazilian Real",
            "number": "986",
            "countries": ["BRAZIL"],
        },
        "BSD": {
            "symbol": "BSD",
            "decimals": 2,
            "name": "Bahamian Dollar",
            "number": "044",
            "countries": ["BAHAMAS (THE)"],
        },
        "BTN": {
            "symbol": "BTN",
            "decimals": 2,
            "name": "Ngultrum",
            "number": "064",
            "countries": ["BHUTAN"],
        },
        "BWP": {
            "symbol": "BWP",
            "decimals": 2,
            "name": "Pula",
            "number": "072",
            "countries": ["BOTSWANA"],
        },
        "BYN": {
            "symbol": "BYN",
            "decimals": 2,
            "name": "Belarusian Ruble",
            "number": "933",
            "countries": ["BELARUS"],
        },
        "BZD": {
            "symbol": "BZD",
            "decimals": 2,
            "name": "Belize Dollar",
            "number": "084",
            "countries": ["BELIZE"],
        },
        "CAD": {
            "symbol": "C$",
            "decimals": 2,
            "name": "Canadian Dollar",
            "number": "124",
            "countries": ["CANADA"],
        },
        "CDF": {
            "symbol": "CDF",
            "decimals": 2,
            "name": "Congolese Franc",
            "number": "976",
            "countries": ["CONGO (THE DEMOCRATIC REPUBLIC OF THE)"],
        },
        "CHE": {
            "symbol": "CHE",
            "decimals": 2,
            "name": "WIR Euro",
            "number": "947",
            "countries": ["SWITZERLAND"],
        },
        "CHF": {
            "symbol": "Fr",
            "decimals": 2,
            "name": "Swiss Franc",
            "number": "756",
            "countries": ["LIECHTENSTEIN", "SWITZERLAND"],
        },
        "CHW": {
            "symbol": "CHW",
            "decimals": 2,
            "name": "WIR Franc",
            "number": "948",
            "countries": ["SWITZERLAND"],
        },
        "CLF": {
            "symbol": "CLF",
            "decimals": 4,
            "name": "Unidad de Fomento",
            "number": "990",
            "countries": ["CHILE"],
        },
        "CLP": {
            "symbol": "$",
            "decimals": 0,
            "name": "Chilean Peso",
            "number": "152",
            "countries": ["CHILE"],
        },
        "CNY": {
            "symbol": "¥",
            "decimals": 2,
            "name": "Yuan Renminbi",
            "number": "156",
            "countries": ["CHINA"],
        },
        "COP": {
            "symbol": "$",
            "decimals": 2,
            "name": "Colombian Peso",
            "number": "170",
            "countries": ["COLOMBIA"],
        },
        "COU": {
            "symbol": "COU",
            "decimals": 2,
            "name": "Unidad de Valor Real",
            "number": "970",
            "countries": ["COLOMBIA"],
        },
        "CRC": {
            "symbol": "CRC",
            "decimals": 2,
            "name": "Costa Rican Colon",
            "number": "188",
            "countries": ["COSTA RICA"],
        },
        "CUP": {
            "symbol": "CUP",
            "decimals": 2,
            "name": "Cuban Peso",
            "number": "192",
            "countries": ["CUBA"],
        },
        "CVE": {
            "symbol": "CVE",
            "decimals": 2,
            "name": "Cabo Verde Escudo",
            "number": "132",
            "countries": ["CABO VERDE"],
        },
        "CZK": {
            "symbol": "Kč",
            "decimals": 2,
            "name": "Czech Koruna",
            "number": "203",
            "countries": ["CZECHIA"],
        },
        "DJF": {
            "symbol": "Fdj",
            "decimals": 0,
            "name": "Djibouti Franc",
            "number": "262",
            "countries": ["DJIBOUTI"],
        },
        "DKK": {
            "symbol": "kr",
            "decimals": 2,
            "name": "Danish Krone",
            "number": "208",
            "countries": ["DENMARK", "FAROE ISLANDS (THE)", "GREENLAND"],
        },
        "DOP": {
            "symbol": "DOP",
            "decimals": 2,
            "name": "Dominican Peso",
            "number": "214",
            "countries": ["DOMINICAN REPUBLIC (THE)"],
        },
        "DZD": {
            "symbol": "DZD",
            "decimals": 2,
            "name": "Algerian Dinar",
            "number": "012",
            "countries": ["ALGERIA"],
        },
        "EGP": {
            "symbol": "E£",
            "decimals": 2,
            "name": "Egyptian Pound",
            "number": "818",
            "countries": ["EGYPT"],
        },
        "ERN": {
            "symbol": "ERN",
            "decimals": 2,
            "name": "Nakfa",
            "number": "232",
            "countries": ["ERITREA"],
        },
        "ETB": {
            "symbol": "ETB",
            "decimals": 2,
            "name": "Ethiopian Birr",
            "number": "230",
            "countries": ["ETHIOPIA"],
        },
        "EUR": {
            "symbol": "€",
            "decimals": 2,
            "name": "Euro",
            "number": "978",
            "countries": [
                "ÅLAND ISLANDS",
                "ANDORRA",
                "AUSTRIA",
                "BELGIUM",
                "CROATIA",
                "CYPRUS",
                "ESTONIA",
                "EUROPEAN UNION",
                "FINLAND",
                "FRANCE",
                "FRENCH GUIANA",
                "FRENCH SOUTHERN TERRITORIES (THE)",
                "GERMANY",
                "GREECE",
                "GUADELOUPE",
                "HOLY SEE (THE)",
                "IRELAND",
                "ITALY",
                "LATVIA",
                "LITHUANIA",
                "LUXEMBOURG",
                "MALTA",
                "MARTINIQUE",
                "MAYOTTE",
                "MONACO",
                "MONTENEGRO",
                "NETHERLANDS (THE)",
                "PORTUGAL",
                "RÉUNION",
                "SAINT BARTHÉLEMY",
                "SAINT MARTIN (FRENCH PART)",
                "SAINT PIERRE AND MIQUELON",
                "SAN MARINO",
                "SLOVAKIA",
                "SLOVENIA",
                "SPAIN",
            ],
        },
        "FJD": {
            "symbol": "FJD",
            "decimals": 2,
            "name": "Fiji Dollar",
            "number": "242",
            "countries": ["FIJI"],
        },
        "FKP": {
            "symbol": "FKP",
            "decimals": 2,
            "name": "Falkland Islands Pound",
            "number": "238",
            "countries": ["FALKLAND ISLANDS (THE) [MALVINAS]"],
        },
        "GBP": {
            "symbol": "£",
            "decimals": 2,
            "name": "Pound Sterling",
            "number": "826",
            "countries": [
                "GUERNSEY",
                "ISLE OF MAN",
                "JERSEY",
                "UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN IRELAND (THE)",
            ],
        },
        "GEL": {
            "symbol": "GEL",
            "decimals": 2,
            "name": "Lari",
            "number": "981",
            "countries": ["GEORGIA"],
        },
        "GHS": {
            "symbol": "GHS",
            "decimals": 2,
            "name": "Ghana Cedi",
            "number": "936",
            "countries": ["GHANA"],
        },
        "GIP": {
            "symbol": "GIP",
            "decimals": 2,
            "name": "Gibraltar Pound",
            "number": "292",
            "countries": ["GIBRALTAR"],
        },
        "GMD": {
            "symbol": "GMD",
            "decimals": 2,
            "name": "Dalasi",
            "number": "270",
            "countries": ["GAMBIA (THE)"],
        },
        "GNF": {
            "symbol": "FG",
            "decimals": 0,
            "name": "Guinean Franc",
            "number": "324",
            "countries": ["GUINEA"],
        },
        "GTQ": {
            "symbol": "GTQ",
            "decimals": 2,
            "name": "Quetzal",
            "number": "320",
            "countries": ["GUATEMALA"],
        },
        "GYD": {
            "symbol": "GYD",
            "decimals": 2,
            "name": "Guyana Dollar",
            "number": "328",
            "countries": ["GUYANA"],
        },
        "HKD": {
            "symbol": "HK$",
            "decimals": 2,
            "name": "Hong Kong Dollar",
            "number": "344",
            "countries": ["HONG KONG"],
        },
        "HNL": {
            "symbol": "HNL",
            "decimals": 2,
            "name": "Lempira",
            "number": "340",
            "countries": ["HONDURAS"],
        },
        "HTG": {
            "symbol": "HTG",
            "decimals": 2,
            "name": "Gourde",
            "number": "332",
            "countries": ["HAITI"],
        },
        "HUF": {
            "symbol": "Ft",
            "decimals": 2,
            "name": "Forint",
            "number": "348",
            "countries": ["HUNGARY"],
        },
        "IDR": {
            "symbol": "Rp",
            "decimals": 2,
            "name": "Rupiah",
            "number": "360",
            "countries": ["INDONESIA"],
        },
        "ILS": {
            "symbol": "₪",
            "decimals": 2,
            "name": "New Israeli Sheqel",
            "number": "376",
            "countries": ["ISRAEL"],
        },
        "INR": {
            "symbol": "₹",
            "decimals": 2,
            "name": "Indian Rupee",
            "number": "356",
            "countries": ["BHUTAN", "INDIA"],
        },
        "IQD": {
            "symbol": "IQD",
            "decimals": 3,
            "name": "Iraqi Dinar",
            "number": "368",
            "countries": ["IRAQ"],
        },
        "IRR": {
            "symbol": "IRR",
            "decimals": 2,
            "name": "Iranian Rial",
            "number": "364",
            "countries": ["IRAN (ISLAMIC REPUBLIC OF)"],
        },
        "ISK": {
            "symbol": "kr",
            "decimals": 0,
            "name": "Iceland Krona",
            "number": "352",
            "countries": ["ICELAND"],
        },
        "JMD": {
            "symbol": "JMD",
            "decimals": 2,
            "name": "Jamaican Dollar",
            "number": "388",
            "countries": ["JAMAICA"],
        },
        "JOD": {
            "symbol": "د.ا",
            "decimals": 3,
            "name": "Jordanian Dinar",
            "number": "400",
            "countries": ["JORDAN"],
        },
        "JPY": {
            "symbol": "¥",
            "decimals": 0,
            "name": "Yen",
            "number": "392",
            "countries": ["JAPAN"],
        },
        "KES": {
            "symbol": "KES",
            "decimals": 2,
            "name": "Kenyan Shilling",
            "number": "404",
            "countries": ["KENYA"],
        },
        "KGS": {
            "symbol": "KGS",
            "decimals": 2,
            "name": "Som",
            "number": "417",
            "countries": ["KYRGYZSTAN"],
        },
        "KHR": {
            "symbol": "KHR",
            "decimals": 2,
            "name": "Riel",
            "number": "116",
            "countries": ["CAMBODIA"],
        },
        "KMF": {
            "symbol": "CF",
            "decimals": 0,
            "name": "Comorian Franc ",
            "number": "174",
            "countries": ["COMOROS (THE)"],
        },
        "KPW": {
            "symbol": "KPW",
            "decimals": 2,
            "name": "North Korean Won",
            "number": "408",
            "countries": ["KOREA (THE DEMOCRATIC PEOPLE'S REPUBLIC OF)"],
        },
        "KRW": {
            "symbol": "₩",
            "decimals": 0,
            "name": "Won",
            "number": "410",
            "countries": ["KOREA (THE REPUBLIC OF)"],
        },
        "KWD": {
            "symbol": "د.ك",
            "decimals": 3,
            "name": "Kuwaiti Dinar",
            "number": "414",
            "countries": ["KUWAIT"],
        },
        "KYD": {
            "symbol": "KYD",
            "decimals": 2,
            "name": "Cayman Islands Dollar",
            "number": "136",
            "countries": ["CAYMAN ISLANDS (THE)"],
        },
        "KZT": {
            "symbol": "KZT",
            "decimals": 2,
            "name": "Tenge",
            "number": "398",
            "countries": ["KAZAKHSTAN"],
        },
        "LAK": {
            "symbol": "LAK",
            "decimals": 2,
            "name": "Lao Kip",
            "number": "418",
            "countries": ["LAO PEOPLE'S DEMOCRATIC REPUBLIC (THE)"],
        },
        "LBP": {
            "symbol": "LBP",
            "decimals": 2,
            "name": "Lebanese Pound",
            "number": "422",
            "countries": ["LEBANON"],
        },
        "LKR": {
            "symbol": "LKR",
            "decimals": 2,
            "name": "Sri Lanka Rupee",
            "number": "144",
            "countries": ["SRI LANKA"],
        },
        "LRD": {
            "symbol": "LRD",
            "decimals": 2,
            "name": "Liberian Dollar",
            "number": "430",
            "countries": ["LIBERIA"],
        },
        "LSL": {
            "symbol": "LSL",
            "decimals": 2,
            "name": "Loti",
            "number": "426",
            "countries": ["LESOTHO"],
        },
        "LYD": {
            "symbol": "ل.د",
            "decimals": 3,
            "name": "Libyan Dinar",
            "number": "434",
            "countries": ["LIBYA"],
        },
        "MAD": {
            "symbol": "MAD",
            "decimals": 2,
            "name": "Moroccan Dirham",
            "number": "504",
            "countries": ["MOROCCO", "WESTERN SAHARA"],
        },
        "MDL": {
            "symbol": "MDL",
            "decimals": 2,
            "name": "Moldovan Leu",
            "number": "498",
            "countries": ["MOLDOVA (THE REPUBLIC OF)"],
        },
        "MGA": {
            "symbol": "MGA",
            "decimals": 2,
            "name": "Malagasy Ariary",
            "number": "969",
            "countries": ["MADAGASCAR"],
        },
        "MKD": {
            "symbol": "MKD",
            "decimals": 2,
            "name": "Denar",
            "number": "807",
            "countries": ["NORTH MACEDONIA"],
        },
        "MMK": {
            "symbol": "MMK",
            "decimals": 2,
            "name": "Kyat",
            "number": "104",
            "countries": ["MYANMAR"],
        },
        "MNT": {
            "symbol": "MNT",
            "decimals": 2,
            "name": "Tugrik",
            "number": "496",
            "countries": ["MONGOLIA"],
        },
        "MOP": {
            "symbol": "MOP",
            "decimals": 2,
            "name": "Pataca",
            "number": "446",
            "countries": ["MACAO"],
        },
        "MRU": {
            "symbol": "MRU",
            "decimals": 2,
            "name": "Ouguiya",
            "number": "929",
            "countries": ["MAURITANIA"],
        },
        "MUR": {
            "symbol": "MUR",
            "decimals": 2,
            "name": "Mauritius Rupee",
            "number": "480",
            "countries": ["MAURITIUS"],
        },
        "MVR": {
            "symbol": "MVR",
            "decimals": 2,
            "name": "Rufiyaa",
            "number": "462",
            "countries": ["MALDIVES"],
        },
        "MWK": {
            "symbol": "MWK",
            "decimals": 2,
            "name": "Malawi Kwacha",
            "number": "454",
            "countries": ["MALAWI"],
        },
        "MXN": {
            "symbol": "$",
            "decimals": 2,
            "name": "Mexican Peso",
            "number": "484",
            "countries": ["MEXICO"],
        },
        "MXV": {
            "symbol": "MXV",
            "decimals": 2,
            "name": "Mexican Unidad de Inversion (UDI)",
            "number": "979",
            "countries": ["MEXICO"],
        },
        "MYR": {
            "symbol": "RM",
            "decimals": 2,
            "name": "Malaysian Ringgit",
            "number": "458",
            "countries": ["MALAYSIA"],
        },
        "MZN": {
            "symbol": "MZN",
            "decimals": 2,
            "name": "Mozambique Metical",
            "number": "943",
            "countries": ["MOZAMBIQUE"],
        },
        "NAD": {
            "symbol": "NAD",
            "decimals": 2,
            "name": "Namibia Dollar",
            "number": "516",
            "countries": ["NAMIBIA"],
        },
        "NGN": {
            "symbol": "₦",
            "decimals": 2,
            "name": "Naira",
            "number": "566",
            "countries": ["NIGERIA"],
        },
        "NIO": {
            "symbol": "NIO",
            "decimals": 2,
            "name": "Cordoba Oro",
            "number": "558",
            "countries": ["NICARAGUA"],
        },
        "NOK": {
            "symbol": "kr",
            "decimals": 2,
            "name": "Norwegian Krone",
            "number": "578",
            "countries": ["BOUVET ISLAND", "NORWAY", "SVALBARD AND JAN MAYEN"],
        },
        "NPR": {
            "symbol": "NPR",
            "decimals": 2,
            "name": "Nepalese Rupee",
            "number": "524",
            "countries": ["NEPAL"],
        },
        "NZD": {
            "symbol": "NZ$",
            "decimals": 2,
            "name": "New Zealand Dollar",
            "number": "554",
            "countries": [
                "COOK ISLANDS (THE)",
                "NEW ZEALAND",
                "NIUE",
                "PITCAIRN",
                "TOKELAU",
            ],
        },
        "OMR": {
            "symbol": "ر.ع.",
            "decimals": 3,
            "name": "Rial Omani",
            "number": "512",
            "countries": ["OMAN"],
        },
        "PAB": {
            "symbol": "PAB",
            "decimals": 2,
            "name": "Balboa",
            "number": "590",
            "countries": ["PANAMA"],
        },
        "PEN": {
            "symbol": "S/",
            "decimals": 2,
            "name": "Sol",
            "number": "604",
            "countries": ["PERU"],
        },
        "PGK": {
            "symbol": "PGK",
            "decimals": 2,
            "name": "Kina",
            "number": "598",
            "countries": ["PAPUA NEW GUINEA"],
        },
        "PHP": {
            "symbol": "₱",
            "decimals": 2,
            "name": "Philippine Peso",
            "number": "608",
            "countries": ["PHILIPPINES (THE)"],
        },
        "PKR": {
            "symbol": "₨",
            "decimals": 2,
            "name": "Pakistan Rupee",
            "number": "586",
            "countries": ["PAKISTAN"],
        },
        "PLN": {
            "symbol": "zł",
            "decimals": 2,
            "name": "Zloty",
            "number": "985",
            "countries": ["POLAND"],
        },
        "PYG": {
            "symbol": "₲",
            "decimals": 0,
            "name": "Guarani",
            "number": "600",
            "countries": ["PARAGUAY"],
        },
        "QAR": {
            "symbol": "﷼",
            "decimals": 2,
            "name": "Qatari Rial",
            "number": "634",
            "countries": ["QATAR"],
        },
        "RON": {
            "symbol": "lei",
            "decimals": 2,
            "name": "Romanian Leu",
            "number": "946",
            "countries": ["ROMANIA"],
        },
        "RSD": {
            "symbol": "RSD",
            "decimals": 2,
            "name": "Serbian Dinar",
            "number": "941",
            "countries": ["SERBIA"],
        },
        "RUB": {
            "symbol": "₽",
            "decimals": 2,
            "name": "Russian Ruble",
            "number": "643",
            "countries": ["RUSSIAN FEDERATION (THE)"],
        },
        "RWF": {
            "symbol": "RF",
            "decimals": 0,
            "name": "Rwanda Franc",
            "number": "646",
            "countries": ["RWANDA"],
        },
        "SAR": {
            "symbol": "﷼",
            "decimals": 2,
            "name": "Saudi Riyal",
            "number": "682",
            "countries": ["SAUDI ARABIA"],
        },
        "SBD": {
            "symbol": "SBD",
            "decimals": 2,
            "name": "Solomon Islands Dollar",
            "number": "090",
            "countries": ["SOLOMON ISLANDS"],
        },
        "SCR": {
            "symbol": "SCR",
            "decimals": 2,
            "name": "Seychelles Rupee",
            "number": "690",
            "countries": ["SEYCHELLES"],
        },
        "SDG": {
            "symbol": "SDG",
            "decimals": 2,
            "name": "Sudanese Pound",
            "number": "938",
            "countries": ["SUDAN (THE)"],
        },
        "SEK": {
            "symbol": "kr",
            "decimals": 2,
            "name": "Swedish Krona",
            "number": "752",
            "countries": ["SWEDEN"],
        },
        "SGD": {
            "symbol": "S$",
            "decimals": 2,
            "name": "Singapore Dollar",
            "number": "702",
            "countries": ["SINGAPORE"],
        },
        "SHP": {
            "symbol": "SHP",
            "decimals": 2,
            "name": "Saint Helena Pound",
            "number": "654",
            "countries": ["SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA"],
        },
        "SLE": {
            "symbol": "SLE",
            "decimals": 2,
            "name": "Leone",
            "number": "925",
            "countries": ["SIERRA LEONE"],
        },
        "SOS": {
            "symbol": "SOS",
            "decimals": 2,
            "name": "Somali Shilling",
            "number": "706",
            "countries": ["SOMALIA"],
        },
        "SRD": {
            "symbol": "SRD",
            "decimals": 2,
            "name": "Surinam Dollar",
            "number": "968",
            "countries": ["SURINAME"],
        },
        "SSP": {
            "symbol": "SSP",
            "decimals": 2,
            "name": "South Sudanese Pound",
            "number": "728",
            "countries": ["SOUTH SUDAN"],
        },
        "STN": {
            "symbol": "STN",
            "decimals": 2,
            "name": "Dobra",
            "number": "930",
            "countries": ["SAO TOME AND PRINCIPE"],
        },
        "SVC": {
            "symbol": "SVC",
            "decimals": 2,
            "name": "El Salvador Colon",
            "number": "222",
            "countries": ["EL SALVADOR"],
        },
        "SYP": {
            "symbol": "SYP",
            "decimals": 2,
            "name": "Syrian Pound",
            "number": "760",
            "countries": ["SYRIAN ARAB REPUBLIC"],
        },
        "SZL": {
            "symbol": "SZL",
            "decimals": 2,
            "name": "Lilangeni",
            "number": "748",
            "countries": ["ESWATINI"],
        },
        "THB": {
            "symbol": "฿",
            "decimals": 2,
            "name": "Baht",
            "number": "764",
            "countries": ["THAILAND"],
        },
        "TJS": {
            "symbol": "TJS",
            "decimals": 2,
            "name": "Somoni",
            "number": "972",
            "countries": ["TAJIKISTAN"],
        },
        "TMT": {
            "symbol": "TMT",
            "decimals": 2,
            "name": "Turkmenistan New Manat",
            "number": "934",
            "countries": ["TURKMENISTAN"],
        },
        "TND": {
            "symbol": "د.ت",
            "decimals": 3,
            "name": "Tunisian Dinar",
            "number": "788",
            "countries": ["TUNISIA"],
        },
        "TOP": {
            "symbol": "TOP",
            "decimals": 2,
            "name": "Pa'anga",
            "number": "776",
            "countries": ["TONGA"],
        },
        "TRY": {
            "symbol": "₺",
            "decimals": 2,
            "name": "Turkish Lira",
            "number": "949",
            "countries": ["TÜRKİYE"],
        },
        "TTD": {
            "symbol": "TTD",
            "decimals": 2,
            "name": "Trinidad and Tobago Dollar",
            "number": "780",
            "countries": ["TRINIDAD AND TOBAGO"],
        },
        "TWD": {
            "symbol": "NT$",
            "decimals": 2,
            "name": "New Taiwan Dollar",
            "number": "901",
            "countries": ["TAIWAN (PROVINCE OF CHINA)"],
        },
        "TZS": {
            "symbol": "TZS",
            "decimals": 2,
            "name": "Tanzanian Shilling",
            "number": "834",
            "countries": ["TANZANIA, UNITED REPUBLIC OF"],
        },
        "UAH": {
            "symbol": "₴",
            "decimals": 2,
            "name": "Hryvnia",
            "number": "980",
            "countries": ["UKRAINE"],
        },
        "UGX": {
            "symbol": "USh",
            "decimals": 0,
            "name": "Uganda Shilling",
            "number": "800",
            "countries": ["UGANDA"],
        },
        "USD": {
            "symbol": "$",
            "decimals": 2,
            "name": "US Dollar",
            "number": "840",
            "countries": [
                "AMERICAN SAMOA",
                "BONAIRE, SINT EUSTATIUS AND SABA",
                "BRITISH INDIAN OCEAN TERRITORY (THE)",
                "ECUADOR",
                "EL SALVADOR",
                "GUAM",
                "HAITI",
                "MARSHALL ISLANDS (THE)",
                "MICRONESIA (FEDERATED STATES OF)",
                "NORTHERN MARIANA ISLANDS (THE)",
                "PALAU",
                "PANAMA",
                "PUERTO RICO",
                "TIMOR-LESTE",
                "TURKS AND CAICOS ISLANDS (THE)",
                "UNITED STATES MINOR OUTLYING ISLANDS (THE)",
                "UNITED STATES OF AMERICA (THE)",
                "VIRGIN ISLANDS (BRITISH)",
                "VIRGIN ISLANDS (U.S.)",
            ],
        },
        "USN": {
            "symbol": "USN",
            "decimals": 2,
            "name": "US Dollar (Next day)",
            "number": "997",
            "countries": ["UNITED STATES OF AMERICA (THE)"],
        },
        "UYI": {
            "symbol": "UYI",
            "decimals": 0,
            "name": "Uruguay Peso en Unidades Indexadas (UI)",
            "number": "940",
            "countries": ["URUGUAY"],
        },
        "UYU": {
            "symbol": "UYU",
            "decimals": 2,
            "name": "Peso Uruguayo",
            "number": "858",
            "countries": ["URUGUAY"],
        },
        "UYW": {
            "symbol": "UYW",
            "decimals": 4,
            "name": "Unidad Previsional",
            "number": "927",
            "countries": ["URUGUAY"],
        },
        "UZS": {
            "symbol": "UZS",
            "decimals": 2,
            "name": "Uzbekistan Sum",
            "number": "860",
            "countries": ["UZBEKISTAN"],
        },
        "VED": {
            "symbol": "VED",
            "decimals": 2,
            "name": "Bolívar Soberano",
            "number": "926",
            "countries": ["VENEZUELA (BOLIVARIAN REPUBLIC OF)"],
        },
        "VES": {
            "symbol": "Bs.",
            "decimals": 2,
            "name": "Bolívar Soberano",
            "number": "928",
            "countries": ["VENEZUELA (BOLIVARIAN REPUBLIC OF)"],
        },
        "VND": {
            "symbol": "₫",
            "decimals": 0,
            "name": "Dong",
            "number": "704",
            "countries": ["VIET NAM"],
        },
        "VUV": {
            "symbol": "VT",
            "decimals": 0,
            "name": "Vatu",
            "number": "548",
            "countries": ["VANUATU"],
        },
        "WST": {
            "symbol": "WST",
            "decimals": 2,
            "name": "Tala",
            "number": "882",
            "countries": ["SAMOA"],
        },
        "XAD": {
            "symbol": "XAD",
            "decimals": 2,
            "name": "Arab Accounting Dinar",
            "number": "396",
            "countries": ["ARAB MONETARY FUND"],
        },
        "XAF": {
            "symbol": "FCFA",
            "decimals": 0,
            "name": "CFA Franc BEAC",
            "number": "950",
            "countries": [
                "CAMEROON",
                "CENTRAL AFRICAN REPUBLIC (THE)",
                "CHAD",
                "CONGO (THE)",
                "EQUATORIAL GUINEA",
                "GABON",
            ],
        },
        "XAG": {
            "symbol": "XAG",
            "decimals": 2,
            "name": "Silver",
            "number": "961",
            "countries": ["ZZ11_Silver"],
        },
        "XAU": {
            "symbol": "XAU",
            "decimals": 2,
            "name": "Gold",
            "number": "959",
            "countries": ["ZZ08_Gold"],
        },
        "XBA": {
            "symbol": "XBA",
            "decimals": 2,
            "name": "Bond Markets Unit European Composite Unit (EURCO)",
            "number": "955",
            "countries": ["ZZ01_Bond Markets Unit European_EURCO"],
        },
        "XBB": {
            "symbol": "XBB",
            "decimals": 2,
            "name": "Bond Markets Unit European Monetary Unit (E.M.U.-6)",
            "number": "956",
            "countries": ["ZZ02_Bond Markets Unit European_EMU-6"],
        },
        "XBC": {
            "symbol": "XBC",
            "decimals": 2,
            "name": "Bond Markets Unit European Unit of Account 9 (E.U.A.-9)",
            "number": "957",
            "countries": ["ZZ03_Bond Markets Unit European_EUA-9"],
        },
        "XBD": {
            "symbol": "XBD",
            "decimals": 2,
            "name": "Bond Markets Unit European Unit of Account 17 (E.U.A.-17)",
            "number": "958",
            "countries": ["ZZ04_Bond Markets Unit European_EUA-17"],
        },
        "XCD": {
            "symbol": "XCD",
            "decimals": 2,
            "name": "East Caribbean Dollar",
            "number": "951",
            "countries": [
                "ANGUILLA",
                "ANTIGUA AND BARBUDA",
                "DOMINICA",
                "GRENADA",
                "MONTSERRAT",
                "SAINT KITTS AND NEVIS",
                "SAINT LUCIA",
                "SAINT VINCENT AND THE GRENADINES",
            ],
        },
        "XCG": {
            "symbol": "XCG",
            "decimals": 2,
            "name": "Caribbean Guilder",
            "number": "532",
            "countries": ["CURAÇAO", "SINT MAARTEN (DUTCH PART)"],
        },
        "XDR": {
            "symbol": "XDR",
            "decimals": 2,
            "name": "SDR (Special Drawing Right)",
            "number": "960",
            "countries": ["INTERNATIONAL MONETARY FUND (IMF)\xa0"],
        },
        "XOF": {
            "symbol": "CFA",
            "decimals": 0,
            "name": "CFA Franc BCEAO",
            "number": "952",
            "countries": [
                "BENIN",
                "BURKINA FASO",
                "CÔTE D'IVOIRE",
                "GUINEA-BISSAU",
                "MALI",
                "NIGER (THE)",
                "SENEGAL",
                "TOGO",
            ],
        },
        "XPD": {
            "symbol": "XPD",
            "decimals": 2,
            "name": "Palladium",
            "number": "964",
            "countries": ["ZZ09_Palladium"],
        },
        "XPF": {
            "symbol": "₣",
            "decimals": 0,
            "name": "CFP Franc",
            "number": "953",
            "countries": ["FRENCH POLYNESIA", "NEW CALEDONIA", "WALLIS AND FUTUNA"],
        },
        "XPT": {
            "symbol": "XPT",
            "decimals": 2,
            "name": "Platinum",
            "number": "962",
            "countries": ["ZZ10_Platinum"],
        },
        "XSU": {
            "symbol": "XSU",
            "decimals": 2,
            "name": "Sucre",
            "number": "994",
            "countries": ['SISTEMA UNITARIO DE COMPENSACION REGIONAL DE PAGOS "SUCRE"'],
        },
        "XTS": {
            "symbol": "XTS",
            "decimals": 2,
            "name": "Codes specifically reserved for testing purposes",
            "number": "963",
            "countries": ["ZZ06_Testing_Code"],
        },
        "XUA": {
            "symbol": "XUA",
            "decimals": 2,
            "name": "ADB Unit of Account",
            "number": "965",
            "countries": ["MEMBER COUNTRIES OF THE AFRICAN DEVELOPMENT BANK GROUP"],
        },
        "XXX": {
            "symbol": "XXX",
            "decimals": 2,
            "name": "The codes assigned for transactions where no currency is involved",
            "number": "999",
            "countries": ["ZZ07_No_Currency"],
        },
        "YER": {
            "symbol": "YER",
            "decimals": 2,
            "name": "Yemeni Rial",
            "number": "886",
            "countries": ["YEMEN"],
        },
        "ZAR": {
            "symbol": "R",
            "decimals": 2,
            "name": "Rand",
            "number": "710",
            "countries": ["LESOTHO", "NAMIBIA", "SOUTH AFRICA"],
        },
        "ZMW": {
            "symbol": "ZMW",
            "decimals": 2,
            "name": "Zambian Kwacha",
            "number": "967",
            "countries": ["ZAMBIA"],
        },
        "ZWG": {
            "symbol": "ZWG",
            "decimals": 2,
            "name": "Zimbabwe Gold",
            "number": "924",
            "countries": ["ZIMBABWE"],
        },
    }

    def __init__(
        self,
        code: str,
        symbol: str,
        decimals: int,
        name: Optional[str] = None,
        number: Optional[str] = None,
        countries: Optional[List[str]] = None,
    ) -> None:
        self.code = code
        self.symbol = symbol
        self.decimals = decimals
        self.name = name or code
        self.number = number
        self.countries = countries or []

    @classmethod
    def get(cls, code: str) -> "Currency":
        data = cls._known.get(code.upper())
        if not data:
            raise InvalidCurrencyError(f"Unknown currency: {code}")
        return Currency(
            code.upper(),
            data["symbol"],
            data["decimals"],
            data.get("name"),
            data.get("number"),
            data.get("countries"),
        )

    @classmethod
    def get_by_country(cls, country_name: str) -> List["Currency"]:
        """Get all currencies used in a specific country."""
        result = []
        for code, data in cls._known.items():
            if country_name.upper() in [c.upper() for c in data.get("countries", [])]:
                result.append(cls.get(code))
        return result

    @classmethod
    def get_by_number(cls, number: str) -> "Currency":
        """Get a currency by its numeric code."""
        for code, data in cls._known.items():
            if data.get("number") == number:
                return cls.get(code)
        raise InvalidCurrencyError(f"Unknown currency numeric code: {number}")
