import sys
import typing
import bpy.types

GenericType = typing.TypeVar("GenericType")


def autodesk_3ds(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        filepath: typing.Union[str, typing.Any] = "",
        axis_forward: typing.Optional[typing.Any] = 'Y',
        axis_up: typing.Optional[typing.Any] = 'Z',
        filter_glob: typing.Union[str, typing.Any] = "*.3ds",
        constrain_size: typing.Optional[typing.Any] = 10.0,
        use_image_search: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = True,
        use_apply_transform: typing.Optional[typing.Union[bool, typing.
                                                          Any]] = True):
    ''' Import from 3DS file format (.3ds)

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param filepath: File Path, Filepath used for importing the file
    :type filepath: typing.Union[str, typing.Any]
    :param axis_forward: Forward
    :type axis_forward: typing.Optional[typing.Any]
    :param axis_up: Up
    :type axis_up: typing.Optional[typing.Any]
    :param filter_glob: filter_glob
    :type filter_glob: typing.Union[str, typing.Any]
    :param constrain_size: Size Constraint, Scale the model by 10 until it reaches the size constraint (0 to disable)
    :type constrain_size: typing.Optional[typing.Any]
    :param use_image_search: Image Search, Search subdirectories for any associated images (Warning, may be slow)
    :type use_image_search: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_apply_transform: Apply Transform, Workaround for object transformations importing incorrectly
    :type use_apply_transform: typing.Optional[typing.Union[bool, typing.Any]]
    '''

    pass


def fbx(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        filepath: typing.Union[str, typing.Any] = "",
        axis_forward: typing.Optional[typing.Any] = '-Z',
        axis_up: typing.Optional[typing.Any] = 'Y',
        directory: typing.Union[str, typing.Any] = "",
        filter_glob: typing.Union[str, typing.Any] = "*.fbx",
        ui_tab: typing.Optional[typing.Any] = 'MAIN',
        use_manual_orientation: typing.Optional[typing.Union[bool, typing.
                                                             Any]] = False,
        global_scale: typing.Optional[typing.Any] = 1.0,
        bake_space_transform: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = False,
        use_custom_normals: typing.Optional[typing.Union[bool, typing.
                                                         Any]] = True,
        use_image_search: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = True,
        use_alpha_decals: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = False,
        decal_offset: typing.Optional[typing.Any] = 0.0,
        use_anim: typing.Optional[typing.Union[bool, typing.Any]] = True,
        anim_offset: typing.Optional[typing.Any] = 1.0,
        use_custom_props: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = True,
        use_custom_props_enum_as_string: typing.Optional[
            typing.Union[bool, typing.Any]] = True,
        ignore_leaf_bones: typing.Optional[typing.Union[bool, typing.
                                                        Any]] = False,
        force_connect_children: typing.Optional[typing.Union[bool, typing.
                                                             Any]] = False,
        automatic_bone_orientation: typing.Optional[typing.Union[bool, typing.
                                                                 Any]] = False,
        primary_bone_axis: typing.Optional[typing.Any] = 'Y',
        secondary_bone_axis: typing.Optional[typing.Any] = 'X',
        use_prepost_rot: typing.Optional[typing.Union[bool, typing.Any]] = True
        ):
    ''' Load a FBX file

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param filepath: File Path, Filepath used for importing the file
    :type filepath: typing.Union[str, typing.Any]
    :param axis_forward: Forward
    :type axis_forward: typing.Optional[typing.Any]
    :param axis_up: Up
    :type axis_up: typing.Optional[typing.Any]
    :param directory: directory
    :type directory: typing.Union[str, typing.Any]
    :param filter_glob: filter_glob
    :type filter_glob: typing.Union[str, typing.Any]
    :param ui_tab: ui_tab, Import options categories * ``MAIN`` Main, Main basic settings. * ``ARMATURE`` Armatures, Armature-related settings.
    :type ui_tab: typing.Optional[typing.Any]
    :param use_manual_orientation: Manual Orientation, Specify orientation and scale, instead of using embedded data in FBX file
    :type use_manual_orientation: typing.Optional[typing.Union[bool, typing.Any]]
    :param global_scale: Scale
    :type global_scale: typing.Optional[typing.Any]
    :param bake_space_transform: !EXPERIMENTAL! Apply Transform, Bake space transform into object data, avoids getting unwanted rotations to objects when target space is not aligned with Blender's space (WARNING! experimental option, use at own risks, known broken with armatures/animations)
    :type bake_space_transform: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_custom_normals: Import Normals, Import custom normals, if available (otherwise Blender will recompute them)
    :type use_custom_normals: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_image_search: Image Search, Search subdirs for any associated images (WARNING: may be slow)
    :type use_image_search: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_alpha_decals: Alpha Decals, Treat materials with alpha as decals (no shadow casting)
    :type use_alpha_decals: typing.Optional[typing.Union[bool, typing.Any]]
    :param decal_offset: Decal Offset, Displace geometry of alpha meshes
    :type decal_offset: typing.Optional[typing.Any]
    :param use_anim: Import Animation, Import FBX animation
    :type use_anim: typing.Optional[typing.Union[bool, typing.Any]]
    :param anim_offset: Animation Offset, Offset to apply to animation during import, in frames
    :type anim_offset: typing.Optional[typing.Any]
    :param use_custom_props: Import User Properties, Import user properties as custom properties
    :type use_custom_props: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_custom_props_enum_as_string: Import Enums As Strings, Store enumeration values as strings
    :type use_custom_props_enum_as_string: typing.Optional[typing.Union[bool, typing.Any]]
    :param ignore_leaf_bones: Ignore Leaf Bones, Ignore the last bone at the end of each chain (used to mark the length of the previous bone)
    :type ignore_leaf_bones: typing.Optional[typing.Union[bool, typing.Any]]
    :param force_connect_children: Force Connect Children, Force connection of children bones to their parent, even if their computed head/tail positions do not match (can be useful with pure-joints-type armatures)
    :type force_connect_children: typing.Optional[typing.Union[bool, typing.Any]]
    :param automatic_bone_orientation: Automatic Bone Orientation, Try to align the major bone axis with the bone children
    :type automatic_bone_orientation: typing.Optional[typing.Union[bool, typing.Any]]
    :param primary_bone_axis: Primary Bone Axis
    :type primary_bone_axis: typing.Optional[typing.Any]
    :param secondary_bone_axis: Secondary Bone Axis
    :type secondary_bone_axis: typing.Optional[typing.Any]
    :param use_prepost_rot: Use Pre/Post Rotation, Use pre/post rotation from FBX transform (you may have to disable that in some cases)
    :type use_prepost_rot: typing.Optional[typing.Union[bool, typing.Any]]
    '''

    pass


def obj(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        filepath: typing.Union[str, typing.Any] = "",
        axis_forward: typing.Optional[typing.Any] = '-Z',
        axis_up: typing.Optional[typing.Any] = 'Y',
        filter_glob: typing.Union[str, typing.Any] = "*.obj;*.mtl",
        use_edges: typing.Optional[typing.Union[bool, typing.Any]] = True,
        use_smooth_groups: typing.Optional[typing.Union[bool, typing.
                                                        Any]] = True,
        use_split_objects: typing.Optional[typing.Union[bool, typing.
                                                        Any]] = True,
        use_split_groups: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = True,
        use_groups_as_vgroups: typing.Optional[typing.Union[bool, typing.
                                                            Any]] = False,
        use_image_search: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = True,
        split_mode: typing.Optional[typing.Any] = 'ON',
        global_clamp_size: typing.Optional[typing.Any] = 0.0):
    ''' Load a Wavefront OBJ File

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param filepath: File Path, Filepath used for importing the file
    :type filepath: typing.Union[str, typing.Any]
    :param axis_forward: Forward
    :type axis_forward: typing.Optional[typing.Any]
    :param axis_up: Up
    :type axis_up: typing.Optional[typing.Any]
    :param filter_glob: filter_glob
    :type filter_glob: typing.Union[str, typing.Any]
    :param use_edges: Lines, Import lines and faces with 2 verts as edge
    :type use_edges: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_smooth_groups: Smooth Groups, Surround smooth groups by sharp edges
    :type use_smooth_groups: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_split_objects: Object, Import OBJ Objects into Blender Objects
    :type use_split_objects: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_split_groups: Group, Import OBJ Groups into Blender Objects
    :type use_split_groups: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_groups_as_vgroups: Poly Groups, Import OBJ groups as vertex groups
    :type use_groups_as_vgroups: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_image_search: Image Search, Search subdirs for any associated images (Warning, may be slow)
    :type use_image_search: typing.Optional[typing.Union[bool, typing.Any]]
    :param split_mode: Split * ``ON`` Split, Split geometry, omits unused verts. * ``OFF`` Keep Vert Order, Keep vertex order from file.
    :type split_mode: typing.Optional[typing.Any]
    :param global_clamp_size: Clamp Size, Clamp bounds under this value (zero to disable)
    :type global_clamp_size: typing.Optional[typing.Any]
    '''

    pass


def x3d(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        filepath: typing.Union[str, typing.Any] = "",
        axis_forward: typing.Optional[typing.Any] = 'Z',
        axis_up: typing.Optional[typing.Any] = 'Y',
        filter_glob: typing.Union[str, typing.Any] = "*.x3d;*.wrl"):
    ''' Import an X3D or VRML2 file

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param filepath: File Path, Filepath used for importing the file
    :type filepath: typing.Union[str, typing.Any]
    :param axis_forward: Forward
    :type axis_forward: typing.Optional[typing.Any]
    :param axis_up: Up
    :type axis_up: typing.Optional[typing.Any]
    :param filter_glob: filter_glob
    :type filter_glob: typing.Union[str, typing.Any]
    '''

    pass
