import sys
import typing
import bpy.types

GenericType = typing.TypeVar("GenericType")


def primitive_nurbs_surface_circle_add(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        radius: typing.Optional[typing.Any] = 1.0,
        view_align: typing.Optional[typing.Union[bool, typing.Any]] = False,
        enter_editmode: typing.Optional[typing.Union[bool, typing.
                                                     Any]] = False,
        location: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        rotation: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        layers: typing.Optional[typing.Union[typing.List[bool], typing.
                                             Any]] = (False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False)):
    ''' Construct a Nurbs surface Circle

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param radius: Radius
    :type radius: typing.Optional[typing.Any]
    :param view_align: Align to View, Align the new object to the view
    :type view_align: typing.Optional[typing.Union[bool, typing.Any]]
    :param enter_editmode: Enter Editmode, Enter editmode when adding this object
    :type enter_editmode: typing.Optional[typing.Union[bool, typing.Any]]
    :param location: Location, Location for the newly added object
    :type location: typing.Optional[typing.Any]
    :param rotation: Rotation, Rotation for the newly added object
    :type rotation: typing.Optional[typing.Any]
    :param layers: Layer
    :type layers: typing.Optional[typing.Union[typing.List[bool], typing.Any]]
    '''

    pass


def primitive_nurbs_surface_curve_add(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        radius: typing.Optional[typing.Any] = 1.0,
        view_align: typing.Optional[typing.Union[bool, typing.Any]] = False,
        enter_editmode: typing.Optional[typing.Union[bool, typing.
                                                     Any]] = False,
        location: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        rotation: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        layers: typing.Optional[typing.Union[typing.List[bool], typing.
                                             Any]] = (False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False)):
    ''' Construct a Nurbs surface Curve

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param radius: Radius
    :type radius: typing.Optional[typing.Any]
    :param view_align: Align to View, Align the new object to the view
    :type view_align: typing.Optional[typing.Union[bool, typing.Any]]
    :param enter_editmode: Enter Editmode, Enter editmode when adding this object
    :type enter_editmode: typing.Optional[typing.Union[bool, typing.Any]]
    :param location: Location, Location for the newly added object
    :type location: typing.Optional[typing.Any]
    :param rotation: Rotation, Rotation for the newly added object
    :type rotation: typing.Optional[typing.Any]
    :param layers: Layer
    :type layers: typing.Optional[typing.Union[typing.List[bool], typing.Any]]
    '''

    pass


def primitive_nurbs_surface_cylinder_add(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        radius: typing.Optional[typing.Any] = 1.0,
        view_align: typing.Optional[typing.Union[bool, typing.Any]] = False,
        enter_editmode: typing.Optional[typing.Union[bool, typing.
                                                     Any]] = False,
        location: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        rotation: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        layers: typing.Optional[typing.Union[typing.List[bool], typing.
                                             Any]] = (False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False)):
    ''' Construct a Nurbs surface Cylinder

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param radius: Radius
    :type radius: typing.Optional[typing.Any]
    :param view_align: Align to View, Align the new object to the view
    :type view_align: typing.Optional[typing.Union[bool, typing.Any]]
    :param enter_editmode: Enter Editmode, Enter editmode when adding this object
    :type enter_editmode: typing.Optional[typing.Union[bool, typing.Any]]
    :param location: Location, Location for the newly added object
    :type location: typing.Optional[typing.Any]
    :param rotation: Rotation, Rotation for the newly added object
    :type rotation: typing.Optional[typing.Any]
    :param layers: Layer
    :type layers: typing.Optional[typing.Union[typing.List[bool], typing.Any]]
    '''

    pass


def primitive_nurbs_surface_sphere_add(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        radius: typing.Optional[typing.Any] = 1.0,
        view_align: typing.Optional[typing.Union[bool, typing.Any]] = False,
        enter_editmode: typing.Optional[typing.Union[bool, typing.
                                                     Any]] = False,
        location: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        rotation: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        layers: typing.Optional[typing.Union[typing.List[bool], typing.
                                             Any]] = (False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False)):
    ''' Construct a Nurbs surface Sphere

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param radius: Radius
    :type radius: typing.Optional[typing.Any]
    :param view_align: Align to View, Align the new object to the view
    :type view_align: typing.Optional[typing.Union[bool, typing.Any]]
    :param enter_editmode: Enter Editmode, Enter editmode when adding this object
    :type enter_editmode: typing.Optional[typing.Union[bool, typing.Any]]
    :param location: Location, Location for the newly added object
    :type location: typing.Optional[typing.Any]
    :param rotation: Rotation, Rotation for the newly added object
    :type rotation: typing.Optional[typing.Any]
    :param layers: Layer
    :type layers: typing.Optional[typing.Union[typing.List[bool], typing.Any]]
    '''

    pass


def primitive_nurbs_surface_surface_add(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        radius: typing.Optional[typing.Any] = 1.0,
        view_align: typing.Optional[typing.Union[bool, typing.Any]] = False,
        enter_editmode: typing.Optional[typing.Union[bool, typing.
                                                     Any]] = False,
        location: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        rotation: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        layers: typing.Optional[typing.Union[typing.List[bool], typing.
                                             Any]] = (False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False)):
    ''' Construct a Nurbs surface Patch

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param radius: Radius
    :type radius: typing.Optional[typing.Any]
    :param view_align: Align to View, Align the new object to the view
    :type view_align: typing.Optional[typing.Union[bool, typing.Any]]
    :param enter_editmode: Enter Editmode, Enter editmode when adding this object
    :type enter_editmode: typing.Optional[typing.Union[bool, typing.Any]]
    :param location: Location, Location for the newly added object
    :type location: typing.Optional[typing.Any]
    :param rotation: Rotation, Rotation for the newly added object
    :type rotation: typing.Optional[typing.Any]
    :param layers: Layer
    :type layers: typing.Optional[typing.Union[typing.List[bool], typing.Any]]
    '''

    pass


def primitive_nurbs_surface_torus_add(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        radius: typing.Optional[typing.Any] = 1.0,
        view_align: typing.Optional[typing.Union[bool, typing.Any]] = False,
        enter_editmode: typing.Optional[typing.Union[bool, typing.
                                                     Any]] = False,
        location: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        rotation: typing.Optional[typing.Any] = (0.0, 0.0, 0.0),
        layers: typing.Optional[typing.Union[typing.List[bool], typing.
                                             Any]] = (False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False, False,
                                                      False, False)):
    ''' Construct a Nurbs surface Torus

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param radius: Radius
    :type radius: typing.Optional[typing.Any]
    :param view_align: Align to View, Align the new object to the view
    :type view_align: typing.Optional[typing.Union[bool, typing.Any]]
    :param enter_editmode: Enter Editmode, Enter editmode when adding this object
    :type enter_editmode: typing.Optional[typing.Union[bool, typing.Any]]
    :param location: Location, Location for the newly added object
    :type location: typing.Optional[typing.Any]
    :param rotation: Rotation, Rotation for the newly added object
    :type rotation: typing.Optional[typing.Any]
    :param layers: Layer
    :type layers: typing.Optional[typing.Union[typing.List[bool], typing.Any]]
    '''

    pass
