import sys
import typing
import bpy.types

GenericType = typing.TypeVar("GenericType")


def ndof(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
         execution_context: typing.Optional[typing.Union[str, int]] = None,
         undo: typing.Optional[bool] = None):
    ''' Use a 3D mouse device to pan/zoom the view

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    '''

    pass


def pan(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        deltax: typing.Optional[typing.Any] = 0,
        deltay: typing.Optional[typing.Any] = 0):
    ''' Pan the view

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param deltax: Delta X
    :type deltax: typing.Optional[typing.Any]
    :param deltay: Delta Y
    :type deltay: typing.Optional[typing.Any]
    '''

    pass


def reset(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
          execution_context: typing.Optional[typing.Union[str, int]] = None,
          undo: typing.Optional[bool] = None):
    ''' Reset the view

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    '''

    pass


def scroll_down(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        deltax: typing.Optional[typing.Any] = 0,
        deltay: typing.Optional[typing.Any] = 0,
        page: typing.Optional[typing.Union[bool, typing.Any]] = False):
    ''' Scroll the view down

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param deltax: Delta X
    :type deltax: typing.Optional[typing.Any]
    :param deltay: Delta Y
    :type deltay: typing.Optional[typing.Any]
    :param page: Page, Scroll down one page
    :type page: typing.Optional[typing.Union[bool, typing.Any]]
    '''

    pass


def scroll_left(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        deltax: typing.Optional[typing.Any] = 0,
        deltay: typing.Optional[typing.Any] = 0):
    ''' Scroll the view left

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param deltax: Delta X
    :type deltax: typing.Optional[typing.Any]
    :param deltay: Delta Y
    :type deltay: typing.Optional[typing.Any]
    '''

    pass


def scroll_right(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        deltax: typing.Optional[typing.Any] = 0,
        deltay: typing.Optional[typing.Any] = 0):
    ''' Scroll the view right

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param deltax: Delta X
    :type deltax: typing.Optional[typing.Any]
    :param deltay: Delta Y
    :type deltay: typing.Optional[typing.Any]
    '''

    pass


def scroll_up(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        deltax: typing.Optional[typing.Any] = 0,
        deltay: typing.Optional[typing.Any] = 0,
        page: typing.Optional[typing.Union[bool, typing.Any]] = False):
    ''' Scroll the view up

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param deltax: Delta X
    :type deltax: typing.Optional[typing.Any]
    :param deltay: Delta Y
    :type deltay: typing.Optional[typing.Any]
    :param page: Page, Scroll up one page
    :type page: typing.Optional[typing.Union[bool, typing.Any]]
    '''

    pass


def scroller_activate(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None):
    ''' Scroll view by mouse click and drag

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    '''

    pass


def smoothview(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        gesture_mode: typing.Optional[typing.Any] = 0,
        xmin: typing.Optional[typing.Any] = 0,
        xmax: typing.Optional[typing.Any] = 0,
        ymin: typing.Optional[typing.Any] = 0,
        ymax: typing.Optional[typing.Any] = 0):
    ''' Undocumented

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param gesture_mode: Gesture Mode
    :type gesture_mode: typing.Optional[typing.Any]
    :param xmin: X Min
    :type xmin: typing.Optional[typing.Any]
    :param xmax: X Max
    :type xmax: typing.Optional[typing.Any]
    :param ymin: Y Min
    :type ymin: typing.Optional[typing.Any]
    :param ymax: Y Max
    :type ymax: typing.Optional[typing.Any]
    '''

    pass


def zoom(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
         execution_context: typing.Optional[typing.Union[str, int]] = None,
         undo: typing.Optional[bool] = None,
         *,
         deltax: typing.Optional[typing.Any] = 0.0,
         deltay: typing.Optional[typing.Any] = 0.0):
    ''' Zoom in/out the view

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param deltax: Delta X
    :type deltax: typing.Optional[typing.Any]
    :param deltay: Delta Y
    :type deltay: typing.Optional[typing.Any]
    '''

    pass


def zoom_border(
        override_context: typing.Optional[
            typing.Union[typing.Dict, 'bpy.types.Context']] = None,
        execution_context: typing.Optional[typing.Union[str, int]] = None,
        undo: typing.Optional[bool] = None,
        *,
        gesture_mode: typing.Optional[typing.Any] = 0,
        xmin: typing.Optional[typing.Any] = 0,
        xmax: typing.Optional[typing.Any] = 0,
        ymin: typing.Optional[typing.Any] = 0,
        ymax: typing.Optional[typing.Any] = 0):
    ''' Zoom in the view to the nearest item contained in the border

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param gesture_mode: Gesture Mode
    :type gesture_mode: typing.Optional[typing.Any]
    :param xmin: X Min
    :type xmin: typing.Optional[typing.Any]
    :param xmax: X Max
    :type xmax: typing.Optional[typing.Any]
    :param ymin: Y Min
    :type ymin: typing.Optional[typing.Any]
    :param ymax: Y Max
    :type ymax: typing.Optional[typing.Any]
    '''

    pass


def zoom_in(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
            execution_context: typing.Optional[typing.Union[str, int]] = None,
            undo: typing.Optional[bool] = None,
            *,
            zoomfacx: typing.Optional[typing.Any] = 0.0,
            zoomfacy: typing.Optional[typing.Any] = 0.0):
    ''' Zoom in the view

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param zoomfacx: Zoom Factor X
    :type zoomfacx: typing.Optional[typing.Any]
    :param zoomfacy: Zoom Factor Y
    :type zoomfacy: typing.Optional[typing.Any]
    '''

    pass


def zoom_out(override_context: typing.Optional[
        typing.Union[typing.Dict, 'bpy.types.Context']] = None,
             execution_context: typing.Optional[typing.Union[str, int]] = None,
             undo: typing.Optional[bool] = None,
             *,
             zoomfacx: typing.Optional[typing.Any] = 0.0,
             zoomfacy: typing.Optional[typing.Any] = 0.0):
    ''' Zoom out the view

    :type override_context: typing.Optional[typing.Union[typing.Dict, 'bpy.types.Context']]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param zoomfacx: Zoom Factor X
    :type zoomfacx: typing.Optional[typing.Any]
    :param zoomfacy: Zoom Factor Y
    :type zoomfacy: typing.Optional[typing.Any]
    '''

    pass
