import sys
import typing
import mathutils
import bl_ui.space_sequencer
import bl_ui.properties_data_lattice
import bl_ui.properties_data_metaball
import bl_ui
import bl_ui.properties_data_curve
import bl_ui.properties_render
import bl_ui.properties_render_layer
import bl_ui.space_logic
import bl_ui.properties_physics_rigidbody_constraint
import bl_operators.anim
import bl_ui.properties_physics_softbody
import bl_ui.properties_physics_smoke
import bl_ui.properties_material
import bl_ui.properties_freestyle
import bl_ui.properties_data_bone
import bl_operators.view3d
import bl_ui.space_text
import bl_operators.freestyle
import bl_ui.properties_grease_pencil_common
import bl_ui.space_graph
import bl_ui.space_view3d
import bl_operators.node
import bl_operators.wm
import bl_ui.properties_object
import bl_ui.space_filebrowser
import bl_ui.space_image
import bl_ui.properties_physics_rigidbody
import bl_operators.file
import bl_ui.space_dopesheet
import bl_ui.properties_physics_field
import bl_ui.properties_data_mesh
import bl_ui.space_userpref
import bl_ui.properties_data_speaker
import bl_ui.properties_game
import bl_ui.properties_texture
import bl_ui.space_time
import bl_ui.properties_data_lamp
import bl_ui.properties_constraint
import bl_operators.mask
import bl_ui.properties_physics_fluid
import bl_ui.properties_mask_common
import bl_operators.clip
import bl_ui.space_node
import bl_ui.properties_scene
import bl_ui.space_console
import bl_ui.properties_data_empty
import bl_ui.properties_particle
import bl_ui.properties_paint_common
import bl_ui.properties_data_modifier
import bl_ui.space_outliner
import bl_ui.space_nla
import keyingsets_builtins
import bl_ui.properties_data_armature
import bl_ui.space_info
import bl_ui.properties_physics_dynamicpaint
import bl_ui.properties_physics_common
import bl_ui.properties_data_camera
import bl_ui.space_properties
import bl_ui.space_clip
import bl_ui.properties_physics_cloth
import bl_ui.space_view3d_toolbar
import bl_ui.properties_world
import bl_operators.presets

GenericType = typing.TypeVar("GenericType")


class bpy_prop_collection(typing.Generic[GenericType]):
    ''' built-in class used for all collections.
    '''

    def find(self, key: typing.Optional[str]) -> int:
        ''' Returns the index of a key in a collection or -1 when not found (matches pythons string find function of the same name).

        :param key: The identifier for the collection member.
        :type key: typing.Optional[str]
        :rtype: int
        :return: index of the key.
        '''
        pass

    def foreach_get(self, attr, seq):
        ''' This is a function to give fast access to attributes within a collection. Only works for 'basic type' properties (bool, int and float)! Multi-dimensional arrays (like array of vectors) will be flattened into seq.

        '''
        pass

    def foreach_set(self, attr, seq):
        ''' This is a function to give fast access to attributes within a collection. Only works for 'basic type' properties (bool, int and float)! seq must be uni-dimensional, multi-dimensional arrays (like array of vectors) will be re-created from it.

        '''
        pass

    def get(self,
            key: typing.Optional[str],
            default: typing.Optional[typing.Any] = None):
        ''' Returns the value of the item assigned to key or default when not found (matches pythons dictionary function of the same name).

        :param key: The identifier for the collection member.
        :type key: typing.Optional[str]
        :param default: Optional argument for the value to return if *key* is not found.
        :type default: typing.Optional[typing.Any]
        '''
        pass

    def items(self) -> typing.List:
        ''' Return the identifiers of collection members (matching pythons dict.items() functionality).

        :rtype: typing.List
        :return: (key, value) pairs for each member of this collection.
        '''
        pass

    def keys(self) -> typing.List[str]:
        ''' Return the identifiers of collection members (matching pythons dict.keys() functionality).

        :rtype: typing.List[str]
        :return: the identifiers for each member of this collection.
        '''
        pass

    def values(self) -> typing.List:
        ''' Return the values of collection (matching pythons dict.values() functionality).

        :rtype: typing.List
        :return: the members of this collection.
        '''
        pass

    def __getitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'GenericType':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        '''
        pass

    def __setitem__(self, key: typing.Optional[typing.Union[int, str]],
                    value: 'GenericType'):
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :param value: 
        :type value: 'GenericType'
        '''
        pass

    def __delitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'GenericType':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        '''
        pass

    def __iter__(self) -> typing.Iterator['GenericType']:
        ''' 

        :rtype: typing.Iterator['GenericType']
        '''
        pass

    def __next__(self) -> 'GenericType':
        ''' 

        :rtype: 'GenericType'
        '''
        pass

    def __len__(self) -> int:
        ''' 

        :rtype: int
        '''
        pass


class bpy_struct:
    ''' built-in base class for all classes in bpy.types.
    '''

    id_data = None
    ''' The `bpy.types.ID` object this datablock is from or None, (not available for all data types)'''

    def as_pointer(self) -> int:
        ''' Returns the memory address which holds a pointer to blenders internal data

        :rtype: int
        :return: int (memory address).
        '''
        pass

    def driver_add(self,
                   path: typing.Optional[str],
                   index: typing.Optional[int] = -1) -> 'FCurve':
        ''' Adds driver(s) to the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: typing.Optional[str]
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :rtype: 'FCurve'
        :return: The driver(s) added.
        '''
        pass

    def driver_remove(self,
                      path: typing.Optional[str],
                      index: typing.Optional[int] = -1) -> bool:
        ''' Remove driver(s) from the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: typing.Optional[str]
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :rtype: bool
        :return: Success of driver removal.
        '''
        pass

    def get(self,
            key: typing.Optional[str],
            default: typing.Optional[typing.Any] = None):
        ''' Returns the value of the custom property assigned to key or default when not found (matches pythons dictionary function of the same name).

        :param key: The key associated with the custom property.
        :type key: typing.Optional[str]
        :param default: Optional argument for the value to return if *key* is not found.
        :type default: typing.Optional[typing.Any]
        '''
        pass

    def is_property_hidden(self, property) -> bool:
        ''' Check if a property is hidden.

        :rtype: bool
        :return: True when the property is hidden.
        '''
        pass

    def is_property_readonly(self, property) -> bool:
        ''' Check if a property is readonly.

        :rtype: bool
        :return: True when the property is readonly (not writable).
        '''
        pass

    def is_property_set(self, property) -> bool:
        ''' Check if a property is set, use for testing operator properties.

        :rtype: bool
        :return: True when the property has been set.
        '''
        pass

    def items(self) -> typing.List:
        ''' Returns the items of this objects custom properties (matches pythons dictionary function of the same name).

        :rtype: typing.List
        :return: custom property key, value pairs.
        '''
        pass

    def keyframe_delete(
            self,
            data_path: typing.Optional[str],
            index: typing.Optional[int] = -1,
            frame: typing.Optional[float] = 'bpy.context.scene.frame_current',
            group: typing.Optional[str] = "") -> bool:
        ''' Remove a keyframe from this properties fcurve.

        :param data_path: path to the property to remove a key, analogous to the fcurve's data path.
        :type data_path: typing.Optional[str]
        :param index: array index of the property to remove a key. Defaults to -1 removing all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :param frame: The frame on which the keyframe is deleted, defaulting to the current frame.
        :type frame: typing.Optional[float]
        :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
        :type group: typing.Optional[str]
        :rtype: bool
        :return: Success of keyframe deleation.
        '''
        pass

    def keyframe_insert(
            self,
            data_path: typing.Optional[str],
            index: typing.Optional[int] = -1,
            frame: typing.Optional[float] = 'bpy.context.scene.frame_current',
            group: typing.Optional[str] = "") -> bool:
        ''' Insert a keyframe on the property given, adding fcurves and animation data when necessary. This is the most simple example of inserting a keyframe from python. Note that when keying data paths which contain nested properties this must be done from the `ID` subclass, in this case the `Armature` rather than the bone.

        :param data_path: path to the property to key, analogous to the fcurve's data path.
        :type data_path: typing.Optional[str]
        :param index: array index of the property to key. Defaults to -1 which will key all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :param frame: The frame on which the keyframe is inserted, defaulting to the current frame.
        :type frame: typing.Optional[float]
        :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
        :type group: typing.Optional[str]
        :param flag: 
        :type flag: typing.Optional[typing.Set]
        :param options:  - ``INSERTKEY_NEEDED`` Only insert keyframes where they're needed in the relevant F-Curves. - ``INSERTKEY_VISUAL`` Insert keyframes based on 'visual transforms'. - ``INSERTKEY_XYZ_TO_RGB`` Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis.
        :type options: typing.Optional[typing.Any]
        :rtype: bool
        :return: Success of keyframe insertion.
        '''
        pass

    def keys(self) -> typing.List[str]:
        ''' Returns the keys of this objects custom properties (matches pythons dictionary function of the same name).

        :rtype: typing.List[str]
        :return: custom property keys.
        '''
        pass

    def path_from_id(self, property: typing.Optional[str] = "") -> str:
        ''' Returns the data path from the ID to this object (string).

        :param property: Optional property name which can be used if the path is to a property of this object.
        :type property: typing.Optional[str]
        :rtype: str
        :return: `bpy.types.bpy_struct.id_data` to this struct and property (when given).
        '''
        pass

    def path_resolve(self,
                     path: typing.Optional[str],
                     coerce: typing.Optional[bool] = True):
        ''' Returns the property from the path, raise an exception when not found.

        :param path: path which this property resolves.
        :type path: typing.Optional[str]
        :param coerce: optional argument, when True, the property will be converted into its python representation.
        :type coerce: typing.Optional[bool]
        '''
        pass

    def property_unset(self, property):
        ''' Unset a property, will use default value afterward.

        '''
        pass

    def type_recast(self) -> 'bpy_struct':
        ''' Return a new instance, this is needed because types such as textures can be changed at runtime.

        :rtype: 'bpy_struct'
        :return: a new instance of this object with the type initialized again.
        '''
        pass

    def values(self) -> typing.List:
        ''' Returns the values of this objects custom properties (matches pythons dictionary function of the same name).

        :rtype: typing.List
        :return: custom property values.
        '''
        pass

    def __getitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'typing.Any':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'typing.Any'
        '''
        pass

    def __setitem__(self, key: typing.Optional[typing.Union[int, str]],
                    value: 'typing.Any'):
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :param value: 
        :type value: 'typing.Any'
        '''
        pass

    def __delitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'typing.Any':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'typing.Any'
        '''
        pass


class bpy_prop_array(typing.Generic[GenericType]):
    def foreach_get(self, attr, seq):
        ''' 

        '''
        pass

    def foreach_set(self, attr, seq):
        ''' 

        '''
        pass

    def __getitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'GenericType':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        '''
        pass

    def __setitem__(self, key: typing.Optional[typing.Union[int, str]],
                    value: 'GenericType'):
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :param value: 
        :type value: 'GenericType'
        '''
        pass

    def __delitem__(self, key: typing.Optional[typing.Union[int, str]]
                    ) -> 'GenericType':
        ''' 

        :param key: 
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        '''
        pass

    def __iter__(self) -> typing.Iterator['GenericType']:
        ''' 

        :rtype: typing.Iterator['GenericType']
        '''
        pass

    def __next__(self) -> 'GenericType':
        ''' 

        :rtype: 'GenericType'
        '''
        pass

    def __len__(self) -> int:
        ''' 

        :rtype: int
        '''
        pass


class ActionGroup(bpy_struct):
    ''' Groups of F-Curves
    '''

    channels: bpy_prop_collection['FCurve'] = None
    ''' F-Curves in this group

    :type: bpy_prop_collection['FCurve']
    '''

    color_set: typing.Union[str, int] = None
    ''' Custom color set to use

    :type: typing.Union[str, int]
    '''

    colors: 'ThemeBoneColorSet' = None
    ''' Copy of the colors associated with the group's color set

    :type: 'ThemeBoneColorSet'
    '''

    is_custom_color_set: typing.Union[bool, typing.Any] = None
    ''' Color set is user-defined instead of a fixed theme color set

    :type: typing.Union[bool, typing.Any]
    '''

    lock: bool = None
    ''' Action group is locked

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' Action group is selected

    :type: bool
    '''

    show_expanded: bool = None
    ''' Action group is expanded

    :type: bool
    '''


class Actuator(bpy_struct):
    ''' Actuator to apply actions in the game engine
    '''

    active: bool = None
    ''' Set the active state of the actuator

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    pin: bool = None
    ''' Display when not linked to a visible states controller

    :type: bool
    '''

    show_expanded: bool = None
    ''' Set actuator expanded in the user interface

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    def link(self, controller: typing.Optional['Controller']):
        ''' Link the actuator to a controller

        :param controller: Controller to link to
        :type controller: typing.Optional['Controller']
        '''
        pass

    def unlink(self, controller: typing.Optional['Controller']):
        ''' Unlink the actuator from a controller

        :param controller: Controller to unlink from
        :type controller: typing.Optional['Controller']
        '''
        pass


class Addon(bpy_struct):
    ''' Python add-ons to be loaded automatically
    '''

    module: typing.Union[str, typing.Any] = None
    ''' Module name

    :type: typing.Union[str, typing.Any]
    '''

    preferences: 'AddonPreferences' = None
    ''' 

    :type: 'AddonPreferences'
    '''


class AddonPreferences(bpy_struct):
    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    layout: 'UILayout' = None
    ''' 

    :type: 'UILayout'
    '''


class AlembicObjectPath(bpy_struct):
    ''' Path of an object inside of an Alembic archive
    '''

    path: typing.Union[str, typing.Any] = None
    ''' Object path

    :type: typing.Union[str, typing.Any]
    '''


class AnimData(bpy_struct):
    ''' Animation data for data-block
    '''

    action: 'Action' = None
    ''' Active Action for this data-block

    :type: 'Action'
    '''

    action_blend_type: typing.Union[str, int] = None
    ''' Method used for combining Active Action's result with result of NLA stack * ``REPLACE`` Replace, Result strip replaces the accumulated results by amount specified by influence. * ``ADD`` Add, Weighted result of strip is added to the accumulated results. * ``SUBTRACT`` Subtract, Weighted result of strip is removed from the accumulated results. * ``MULTIPLY`` Multiply, Weighted result of strip is multiplied with the accumulated results.

    :type: typing.Union[str, int]
    '''

    action_extrapolation: typing.Union[str, int] = None
    ''' Action to take for gaps past the Active Action's range (when evaluating with NLA) * ``NOTHING`` Nothing, Strip has no influence past its extents. * ``HOLD`` Hold, Hold the first frame if no previous strips in track, and always hold last frame. * ``HOLD_FORWARD`` Hold Forward, Only hold last frame.

    :type: typing.Union[str, int]
    '''

    action_influence: float = None
    ''' Amount the Active Action contributes to the result of the NLA stack

    :type: float
    '''

    drivers: 'AnimDataDrivers' = None
    ''' The Drivers/Expressions for this data-block

    :type: 'AnimDataDrivers'
    '''

    nla_tracks: 'NlaTracks' = None
    ''' NLA Tracks (i.e. Animation Layers)

    :type: 'NlaTracks'
    '''

    use_nla: bool = None
    ''' NLA stack is evaluated when evaluating this block

    :type: bool
    '''

    use_tweak_mode: bool = None
    ''' Whether to enable or disable tweak mode in NLA

    :type: bool
    '''


class AnimViz(bpy_struct):
    ''' Settings for the visualization of motion
    '''

    motion_path: 'AnimVizMotionPaths' = None
    ''' Motion Path settings for visualization

    :type: 'AnimVizMotionPaths'
    '''

    onion_skin_frames: 'AnimVizOnionSkinning' = None
    ''' Onion Skinning (ghosting) settings for visualization

    :type: 'AnimVizOnionSkinning'
    '''


class AnimVizMotionPaths(bpy_struct):
    ''' Motion Path settings for animation visualization
    '''

    bake_location: typing.Union[str, int] = None
    ''' When calculating Bone Paths, use Head or Tips * ``HEADS`` Heads, Calculate bone paths from heads. * ``TAILS`` Tails, Calculate bone paths from tails.

    :type: typing.Union[str, int]
    '''

    frame_after: int = None
    ''' Number of frames to show after the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_before: int = None
    ''' Number of frames to show before the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_end: int = None
    ''' End frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_start: int = None
    ''' Starting frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between paths shown (not for 'On Keyframes' Onion-skinning method)

    :type: int
    '''

    show_frame_numbers: bool = None
    ''' Show frame numbers on Motion Paths

    :type: bool
    '''

    show_keyframe_action_all: bool = None
    ''' For bone motion paths, search whole Action for keyframes instead of in group with matching name only (is slower)

    :type: bool
    '''

    show_keyframe_highlight: bool = None
    ''' Emphasize position of keyframes on Motion Paths

    :type: bool
    '''

    show_keyframe_numbers: bool = None
    ''' Show frame numbers of Keyframes on Motion Paths

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of range to show for Motion Paths * ``CURRENT_FRAME`` Around Frame, Display Paths of poses within a fixed number of frames around the current frame. * ``RANGE`` In Range, Display Paths of poses within specified range.

    :type: typing.Union[str, int]
    '''


class AnimVizOnionSkinning(bpy_struct):
    ''' Onion Skinning settings for animation visualization
    '''

    frame_after: int = None
    ''' Number of frames to show after the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_before: int = None
    ''' Number of frames to show before the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_end: int = None
    ''' End frame of range of Ghosts to display (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_start: int = None
    ''' Starting frame of range of Ghosts to display (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between ghosts shown (not for 'On Keyframes' Onion-skinning method)

    :type: int
    '''

    show_only_selected: bool = None
    ''' For Pose-Mode drawing, only draw ghosts for selected bones

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Method used for determining what ghosts get drawn * ``NONE`` No Ghosts, Do not show any ghosts. * ``CURRENT_FRAME`` Around Current Frame, Show ghosts from around the current frame. * ``RANGE`` In Range, Show ghosts for the specified frame range. * ``KEYS`` On Keyframes, Show ghosts on keyframes.

    :type: typing.Union[str, int]
    '''


class AnyType(bpy_struct):
    ''' RNA type used for pointers to any possible data
    '''

    pass


class Area(bpy_struct):
    ''' Area in a subdivided screen, containing an editor
    '''

    height: int = None
    ''' Area height

    :type: int
    '''

    regions: bpy_prop_collection['Region'] = None
    ''' Regions this area is subdivided in

    :type: bpy_prop_collection['Region']
    '''

    show_menus: bool = None
    ''' Show menus in the header

    :type: bool
    '''

    spaces: 'AreaSpaces' = None
    ''' Spaces contained in this area, the first being the active space (NOTE: Useful for example to restore a previously used 3D view space in a certain area to get the old view orientation)

    :type: 'AreaSpaces'
    '''

    type: typing.Union[str, int] = None
    ''' Current editor type for this area * ``EMPTY`` Empty. * ``VIEW_3D`` 3D View, 3D viewport. * ``TIMELINE`` Timeline, Timeline and playback controls. * ``GRAPH_EDITOR`` Graph Editor, Edit drivers and keyframe interpolation. * ``DOPESHEET_EDITOR`` Dope Sheet, Adjust timing of keyframes. * ``NLA_EDITOR`` NLA Editor, Combine and layer Actions. * ``IMAGE_EDITOR`` UV/Image Editor, View and edit images and UV Maps. * ``SEQUENCE_EDITOR`` Video Sequence Editor, Video editing tools. * ``CLIP_EDITOR`` Movie Clip Editor, Motion tracking tools. * ``TEXT_EDITOR`` Text Editor, Edit scripts and in-file documentation. * ``NODE_EDITOR`` Node Editor, Editor for node-based shading and compositing tools. * ``LOGIC_EDITOR`` Logic Editor, Game logic editing. * ``PROPERTIES`` Properties, Edit properties of active object and related data-blocks. * ``OUTLINER`` Outliner, Overview of scene graph and all available data-blocks. * ``USER_PREFERENCES`` User Preferences, Edit persistent configuration settings. * ``INFO`` Info, Main menu bar and list of error messages (drag down to expand and display). * ``FILE_BROWSER`` File Browser, Browse for files and assets. * ``CONSOLE`` Python Console, Interactive programmatic console for advanced editing and script development.

    :type: typing.Union[str, int]
    '''

    width: int = None
    ''' Area width

    :type: int
    '''

    x: int = None
    ''' The window relative vertical location of the area

    :type: int
    '''

    y: int = None
    ''' The window relative horizontal location of the area

    :type: int
    '''

    def tag_redraw(self):
        ''' tag_redraw

        '''
        pass

    def header_text_set(self, text: typing.Union[str, typing.Any] = ""):
        ''' Set the header text

        :param text: Text, New string for the header, no argument clears the text
        :type text: typing.Union[str, typing.Any]
        '''
        pass


class BackgroundImage(bpy_struct):
    ''' Image and settings for display in the 3D View background
    '''

    clip: 'MovieClip' = None
    ''' Movie clip displayed and edited in this space

    :type: 'MovieClip'
    '''

    clip_user: 'MovieClipUser' = None
    ''' Parameters defining which frame of the movie clip is displayed

    :type: 'MovieClipUser'
    '''

    draw_depth: typing.Union[str, int] = None
    ''' Draw under or over everything

    :type: typing.Union[str, int]
    '''

    frame_method: typing.Union[str, int] = None
    ''' How the image fits in the camera frame

    :type: typing.Union[str, int]
    '''

    image: 'Image' = None
    ''' Image displayed and edited in this space

    :type: 'Image'
    '''

    image_user: 'ImageUser' = None
    ''' Parameters defining which layer, pass and frame of the image is displayed

    :type: 'ImageUser'
    '''

    offset_x: float = None
    ''' Offset image horizontally from the world origin

    :type: float
    '''

    offset_y: float = None
    ''' Offset image vertically from the world origin

    :type: float
    '''

    opacity: float = None
    ''' Image opacity to blend the image against the background color

    :type: float
    '''

    rotation: float = None
    ''' Rotation for the background image (ortho view only)

    :type: float
    '''

    show_background_image: bool = None
    ''' Show this image as background

    :type: bool
    '''

    show_expanded: bool = None
    ''' Show the expanded in the user interface

    :type: bool
    '''

    show_on_foreground: bool = None
    ''' Show this image in front of objects in viewport

    :type: bool
    '''

    size: float = None
    ''' Size of the background image (ortho view only)

    :type: float
    '''

    source: typing.Union[str, int] = None
    ''' Data source used for background

    :type: typing.Union[str, int]
    '''

    use_camera_clip: bool = None
    ''' Use movie clip from active scene camera

    :type: bool
    '''

    use_flip_x: bool = None
    ''' Flip the background image horizontally

    :type: bool
    '''

    use_flip_y: bool = None
    ''' Flip the background image vertically

    :type: bool
    '''

    view_axis: typing.Union[str, int] = None
    ''' The axis to display the image on * ``LEFT`` Left, Show background image while looking to the left. * ``RIGHT`` Right, Show background image while looking to the right. * ``BACK`` Back, Show background image in back view. * ``FRONT`` Front, Show background image in front view. * ``BOTTOM`` Bottom, Show background image in bottom view. * ``TOP`` Top, Show background image in top view. * ``ALL`` All Views, Show background image in all views. * ``CAMERA`` Camera, Show background image in camera view.

    :type: typing.Union[str, int]
    '''


class BakePixel(bpy_struct):
    du_dx: float = None
    ''' 

    :type: float
    '''

    du_dy: float = None
    ''' 

    :type: float
    '''

    dv_dx: float = None
    ''' 

    :type: float
    '''

    dv_dy: float = None
    ''' 

    :type: float
    '''

    next: 'BakePixel' = None
    ''' 

    :type: 'BakePixel'
    '''

    object_id: int = None
    ''' 

    :type: int
    '''

    primitive_id: int = None
    ''' 

    :type: int
    '''

    uv: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class BakeSettings(bpy_struct):
    ''' Bake data for a Scene data-block
    '''

    cage_extrusion: float = None
    ''' Distance to use for the inward ray cast when using selected to active

    :type: float
    '''

    cage_object: typing.Union[str, typing.Any] = None
    ''' Object to use as cage instead of calculating the cage from the active object with cage extrusion

    :type: typing.Union[str, typing.Any]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Image filepath to use when saving externally

    :type: typing.Union[str, typing.Any]
    '''

    height: int = None
    ''' Vertical dimension of the baking map

    :type: int
    '''

    image_settings: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    margin: int = None
    ''' Extends the baked result as a post process filter

    :type: int
    '''

    normal_b: typing.Union[str, int] = None
    ''' Axis to bake in blue channel

    :type: typing.Union[str, int]
    '''

    normal_g: typing.Union[str, int] = None
    ''' Axis to bake in green channel

    :type: typing.Union[str, int]
    '''

    normal_r: typing.Union[str, int] = None
    ''' Axis to bake in red channel

    :type: typing.Union[str, int]
    '''

    normal_space: typing.Union[str, int] = None
    ''' Choose normal space for baking * ``OBJECT`` Object, Bake the normals in object space. * ``TANGENT`` Tangent, Bake the normals in tangent space.

    :type: typing.Union[str, int]
    '''

    pass_filter: typing.Any = None
    ''' Passes to include in the active baking pass

    :type: typing.Any
    '''

    save_mode: typing.Union[str, int] = None
    ''' Choose how to save the baking map * ``INTERNAL`` Internal, Save the baking map in an internal image data-block. * ``EXTERNAL`` External, Save the baking map in an external file.

    :type: typing.Union[str, int]
    '''

    use_automatic_name: bool = None
    ''' Automatically name the output file with the pass type (external only)

    :type: bool
    '''

    use_cage: bool = None
    ''' Cast rays to active object from a cage

    :type: bool
    '''

    use_clear: bool = None
    ''' Clear Images before baking (internal only)

    :type: bool
    '''

    use_pass_ambient_occlusion: bool = None
    ''' Add ambient occlusion contribution

    :type: bool
    '''

    use_pass_color: bool = None
    ''' Color the pass

    :type: bool
    '''

    use_pass_diffuse: bool = None
    ''' Add diffuse contribution

    :type: bool
    '''

    use_pass_direct: bool = None
    ''' Add direct lighting contribution

    :type: bool
    '''

    use_pass_emit: bool = None
    ''' Add emission contribution

    :type: bool
    '''

    use_pass_glossy: bool = None
    ''' Add glossy contribution

    :type: bool
    '''

    use_pass_indirect: bool = None
    ''' Add indirect lighting contribution

    :type: bool
    '''

    use_pass_subsurface: bool = None
    ''' Add subsurface contribution

    :type: bool
    '''

    use_pass_transmission: bool = None
    ''' Add transmission contribution

    :type: bool
    '''

    use_selected_to_active: bool = None
    ''' Bake shading on the surface of selected objects to the active object

    :type: bool
    '''

    use_split_materials: bool = None
    ''' Split external images per material (external only)

    :type: bool
    '''

    width: int = None
    ''' Horizontal dimension of the baking map

    :type: int
    '''


class BezierSplinePoint(bpy_struct):
    ''' Bezier curve point with two handles
    '''

    co: bpy_prop_array[float] = None
    ''' Coordinates of the control point

    :type: bpy_prop_array[float]
    '''

    handle_left: bpy_prop_array[float] = None
    ''' Coordinates of the first handle

    :type: bpy_prop_array[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle types

    :type: typing.Union[str, int]
    '''

    handle_right: bpy_prop_array[float] = None
    ''' Coordinates of the second handle

    :type: bpy_prop_array[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle types

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    ''' Visibility status

    :type: bool
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    select_control_point: bool = None
    ''' Control point selection status

    :type: bool
    '''

    select_left_handle: bool = None
    ''' Handle 1 selection status

    :type: bool
    '''

    select_right_handle: bool = None
    ''' Handle 2 selection status

    :type: bool
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''


class BlendData(bpy_struct):
    ''' Main data structure representing a .blend file and all its datablocks
    '''

    actions: 'BlendDataActions' = None
    ''' Action datablocks

    :type: 'BlendDataActions'
    '''

    armatures: 'BlendDataArmatures' = None
    ''' Armature datablocks

    :type: 'BlendDataArmatures'
    '''

    brushes: 'BlendDataBrushes' = None
    ''' Brush datablocks

    :type: 'BlendDataBrushes'
    '''

    cache_files: 'BlendDataCacheFiles' = None
    ''' Cache Files datablocks

    :type: 'BlendDataCacheFiles'
    '''

    cameras: 'BlendDataCameras' = None
    ''' Camera datablocks

    :type: 'BlendDataCameras'
    '''

    curves: 'BlendDataCurves' = None
    ''' Curve datablocks

    :type: 'BlendDataCurves'
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Path to the .blend file

    :type: typing.Union[str, typing.Any]
    '''

    fonts: 'BlendDataFonts' = None
    ''' Vector font datablocks

    :type: 'BlendDataFonts'
    '''

    grease_pencil: 'BlendDataGreasePencils' = None
    ''' Grease Pencil datablocks

    :type: 'BlendDataGreasePencils'
    '''

    groups: 'BlendDataGroups' = None
    ''' Group datablocks

    :type: 'BlendDataGroups'
    '''

    images: 'BlendDataImages' = None
    ''' Image datablocks

    :type: 'BlendDataImages'
    '''

    is_dirty: typing.Union[bool, typing.Any] = None
    ''' Have recent edits been saved to disk

    :type: typing.Union[bool, typing.Any]
    '''

    is_saved: typing.Union[bool, typing.Any] = None
    ''' Has the current session been saved to disk as a .blend file

    :type: typing.Union[bool, typing.Any]
    '''

    lamps: 'BlendDataLamps' = None
    ''' Lamp datablocks

    :type: 'BlendDataLamps'
    '''

    lattices: 'BlendDataLattices' = None
    ''' Lattice datablocks

    :type: 'BlendDataLattices'
    '''

    libraries: 'BlendDataLibraries' = None
    ''' Library datablocks

    :type: 'BlendDataLibraries'
    '''

    linestyles: 'BlendDataLineStyles' = None
    ''' Line Style datablocks

    :type: 'BlendDataLineStyles'
    '''

    masks: 'BlendDataMasks' = None
    ''' Masks datablocks

    :type: 'BlendDataMasks'
    '''

    materials: 'BlendDataMaterials' = None
    ''' Material datablocks

    :type: 'BlendDataMaterials'
    '''

    meshes: 'BlendDataMeshes' = None
    ''' Mesh datablocks

    :type: 'BlendDataMeshes'
    '''

    metaballs: 'BlendDataMetaBalls' = None
    ''' Metaball datablocks

    :type: 'BlendDataMetaBalls'
    '''

    movieclips: 'BlendDataMovieClips' = None
    ''' Movie Clip datablocks

    :type: 'BlendDataMovieClips'
    '''

    node_groups: 'BlendDataNodeTrees' = None
    ''' Node group datablocks

    :type: 'BlendDataNodeTrees'
    '''

    objects: 'BlendDataObjects' = None
    ''' Object datablocks

    :type: 'BlendDataObjects'
    '''

    paint_curves: 'BlendDataPaintCurves' = None
    ''' Paint Curves datablocks

    :type: 'BlendDataPaintCurves'
    '''

    palettes: 'BlendDataPalettes' = None
    ''' Palette datablocks

    :type: 'BlendDataPalettes'
    '''

    particles: 'BlendDataParticles' = None
    ''' Particle datablocks

    :type: 'BlendDataParticles'
    '''

    scenes: 'BlendDataScenes' = None
    ''' Scene datablocks

    :type: 'BlendDataScenes'
    '''

    screens: 'BlendDataScreens' = None
    ''' Screen datablocks

    :type: 'BlendDataScreens'
    '''

    shape_keys: bpy_prop_collection['Key'] = None
    ''' Shape Key datablocks

    :type: bpy_prop_collection['Key']
    '''

    sounds: 'BlendDataSounds' = None
    ''' Sound datablocks

    :type: 'BlendDataSounds'
    '''

    speakers: 'BlendDataSpeakers' = None
    ''' Speaker datablocks

    :type: 'BlendDataSpeakers'
    '''

    texts: 'BlendDataTexts' = None
    ''' Text datablocks

    :type: 'BlendDataTexts'
    '''

    textures: 'BlendDataTextures' = None
    ''' Texture datablocks

    :type: 'BlendDataTextures'
    '''

    use_autopack: bool = None
    ''' Automatically pack all external data into .blend file

    :type: bool
    '''

    version: bpy_prop_array[int] = None
    ''' Version of Blender the .blend was saved with

    :type: bpy_prop_array[int]
    '''

    window_managers: 'BlendDataWindowManagers' = None
    ''' Window manager datablocks

    :type: 'BlendDataWindowManagers'
    '''

    worlds: 'BlendDataWorlds' = None
    ''' World datablocks

    :type: 'BlendDataWorlds'
    '''

    def user_map(self, subset: typing.Optional[typing.Sequence],
                 key_types: typing.Optional[typing.Set[str]],
                 value_types: typing.Optional[typing.Set[str]]) -> typing.Dict:
        ''' Returns a mapping of all ID datablocks in current ``bpy.data`` to a set of all datablocks using them. For list of valid set members for key_types & value_types, see: `bpy.types.KeyingSetPath.id_type`.

        :param subset: When passed, only these data-blocks and their users will be included as keys/values in the map.
        :type subset: typing.Optional[typing.Sequence]
        :param key_types: Filter the keys mapped by ID types.
        :type key_types: typing.Optional[typing.Set[str]]
        :param value_types: Filter the values in the set by ID types.
        :type value_types: typing.Optional[typing.Set[str]]
        :rtype: typing.Dict
        :return: `bpy.types.ID` instances, with sets of ID's as their values.
        '''
        pass


class BlenderRNA(bpy_struct):
    ''' Blender RNA structure definitions
    '''

    structs: bpy_prop_collection['Struct'] = None
    ''' 

    :type: bpy_prop_collection['Struct']
    '''


class BoidRule(bpy_struct):
    name: typing.Union[str, typing.Any] = None
    ''' Boid rule name

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' * ``GOAL`` Goal, Go to assigned object or loudest assigned signal source. * ``AVOID`` Avoid, Get away from assigned object or loudest assigned signal source. * ``AVOID_COLLISION`` Avoid Collision, Maneuver to avoid collisions with other boids and deflector objects in near future. * ``SEPARATE`` Separate, Keep from going through other boids. * ``FLOCK`` Flock, Move to center of neighbors and match their velocity. * ``FOLLOW_LEADER`` Follow Leader, Follow a boid or assigned object. * ``AVERAGE_SPEED`` Average Speed, Maintain speed, flight level or wander. * ``FIGHT`` Fight, Go to closest enemy and attack when in range.

    :type: typing.Union[str, int]
    '''

    use_in_air: bool = None
    ''' Use rule when boid is flying

    :type: bool
    '''

    use_on_land: bool = None
    ''' Use rule when boid is on land

    :type: bool
    '''


class BoidSettings(bpy_struct):
    ''' Settings for boid physics
    '''

    accuracy: float = None
    ''' Accuracy of attack

    :type: float
    '''

    active_boid_state: 'BoidRule' = None
    ''' 

    :type: 'BoidRule'
    '''

    active_boid_state_index: int = None
    ''' 

    :type: int
    '''

    aggression: float = None
    ''' Boid will fight this times stronger enemy

    :type: float
    '''

    air_acc_max: float = None
    ''' Maximum acceleration in air (relative to maximum speed)

    :type: float
    '''

    air_ave_max: float = None
    ''' Maximum angular velocity in air (relative to 180 degrees)

    :type: float
    '''

    air_personal_space: float = None
    ''' Radius of boids personal space in air (% of particle size)

    :type: float
    '''

    air_speed_max: float = None
    ''' Maximum speed in air

    :type: float
    '''

    air_speed_min: float = None
    ''' Minimum speed in air (relative to maximum speed)

    :type: float
    '''

    bank: float = None
    ''' Amount of rotation around velocity vector on turns

    :type: float
    '''

    health: float = None
    ''' Initial boid health when born

    :type: float
    '''

    height: float = None
    ''' Boid height relative to particle size

    :type: float
    '''

    land_acc_max: float = None
    ''' Maximum acceleration on land (relative to maximum speed)

    :type: float
    '''

    land_ave_max: float = None
    ''' Maximum angular velocity on land (relative to 180 degrees)

    :type: float
    '''

    land_jump_speed: float = None
    ''' Maximum speed for jumping

    :type: float
    '''

    land_personal_space: float = None
    ''' Radius of boids personal space on land (% of particle size)

    :type: float
    '''

    land_smooth: float = None
    ''' How smoothly the boids land

    :type: float
    '''

    land_speed_max: float = None
    ''' Maximum speed on land

    :type: float
    '''

    land_stick_force: float = None
    ''' How strong a force must be to start effecting a boid on land

    :type: float
    '''

    pitch: float = None
    ''' Amount of rotation around side vector

    :type: float
    '''

    range: float = None
    ''' Maximum distance from which a boid can attack

    :type: float
    '''

    states: bpy_prop_collection['BoidState'] = None
    ''' 

    :type: bpy_prop_collection['BoidState']
    '''

    strength: float = None
    ''' Maximum caused damage on attack per second

    :type: float
    '''

    use_climb: bool = None
    ''' Allow boids to climb goal objects

    :type: bool
    '''

    use_flight: bool = None
    ''' Allow boids to move in air

    :type: bool
    '''

    use_land: bool = None
    ''' Allow boids to move on land

    :type: bool
    '''


class BoidState(bpy_struct):
    ''' Boid state for boid physics
    '''

    active_boid_rule: 'BoidRule' = None
    ''' 

    :type: 'BoidRule'
    '''

    active_boid_rule_index: int = None
    ''' 

    :type: int
    '''

    falloff: float = None
    ''' 

    :type: float
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Boid state name

    :type: typing.Union[str, typing.Any]
    '''

    rule_fuzzy: float = None
    ''' 

    :type: float
    '''

    rules: bpy_prop_collection['BoidRule'] = None
    ''' 

    :type: bpy_prop_collection['BoidRule']
    '''

    ruleset_type: typing.Union[str, int] = None
    ''' How the rules in the list are evaluated * ``FUZZY`` Fuzzy, Rules are gone through top to bottom (only the first rule which effect is above fuzziness threshold is evaluated). * ``RANDOM`` Random, A random rule is selected for each boid. * ``AVERAGE`` Average, All rules are averaged.

    :type: typing.Union[str, int]
    '''

    volume: float = None
    ''' 

    :type: float
    '''


class Bone(bpy_struct):
    ''' Bone in an Armature data-block
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveiny: float = None
    ''' Y-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveouty: float = None
    ''' Y-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_in: float = None
    ''' Length of first Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_out: float = None
    ''' Length of second Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scalein: float = None
    ''' Scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleout: float = None
    ''' Scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_segments: int = None
    ''' Number of subdivisions of bone (for B-Bones only)

    :type: int
    '''

    bbone_x: float = None
    ''' B-Bone X size

    :type: float
    '''

    bbone_z: float = None
    ''' B-Bone Z size

    :type: float
    '''

    children: bpy_prop_collection['Bone'] = None
    ''' Bones which are children of this bone

    :type: bpy_prop_collection['Bone']
    '''

    envelope_distance: float = None
    ''' Bone deformation distance (for Envelope deform only)

    :type: float
    '''

    envelope_weight: float = None
    ''' Bone deformation weight (for Envelope deform only)

    :type: float
    '''

    head: bpy_prop_array[float] = None
    ''' Location of head end of the bone relative to its parent

    :type: bpy_prop_array[float]
    '''

    head_local: bpy_prop_array[float] = None
    ''' Location of head end of the bone relative to armature

    :type: bpy_prop_array[float]
    '''

    head_radius: float = None
    ''' Radius of head of bone (for Envelope deform only)

    :type: float
    '''

    hide: bool = None
    ''' Bone is not visible when it is not in Edit Mode (i.e. in Object or Pose Modes)

    :type: bool
    '''

    hide_select: bool = None
    ''' Bone is able to be selected

    :type: bool
    '''

    layers: typing.List[bool] = None
    ''' Layers bone exists in

    :type: typing.List[bool]
    '''

    matrix: bpy_prop_array[float] = None
    ''' 3x3 bone matrix

    :type: bpy_prop_array[float]
    '''

    matrix_local: bpy_prop_array[float] = None
    ''' 4x4 bone matrix relative to armature

    :type: bpy_prop_array[float]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    parent: 'Bone' = None
    ''' Parent bone (in same Armature)

    :type: 'Bone'
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_head: bool = None
    ''' 

    :type: bool
    '''

    select_tail: bool = None
    ''' 

    :type: bool
    '''

    show_wire: bool = None
    ''' Bone is always drawn as Wireframe regardless of viewport draw mode (useful for non-obstructive custom bone shapes)

    :type: bool
    '''

    tail: bpy_prop_array[float] = None
    ''' Location of tail end of the bone

    :type: bpy_prop_array[float]
    '''

    tail_local: bpy_prop_array[float] = None
    ''' Location of tail end of the bone relative to armature

    :type: bpy_prop_array[float]
    '''

    tail_radius: float = None
    ''' Radius of tail of bone (for Envelope deform only)

    :type: float
    '''

    use_connect: typing.Union[bool, typing.Any] = None
    ''' When bone has a parent, bone's head is stuck to the parent's tail

    :type: typing.Union[bool, typing.Any]
    '''

    use_cyclic_offset: bool = None
    ''' When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    '''

    use_deform: bool = None
    ''' Enable Bone to deform geometry

    :type: bool
    '''

    use_endroll_as_inroll: bool = None
    ''' Use Roll Out of parent bone as Roll In of its children

    :type: bool
    '''

    use_envelope_multiply: bool = None
    ''' When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    '''

    use_inherit_rotation: bool = None
    ''' Bone inherits rotation or scale from parent bone

    :type: bool
    '''

    use_inherit_scale: bool = None
    ''' Bone inherits scaling from parent bone

    :type: bool
    '''

    use_local_location: bool = None
    ''' Bone location is set in local space

    :type: bool
    '''

    use_relative_parent: bool = None
    ''' Object children will use relative transform, like deform

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    length = None
    ''' The distance from head to tail, when set the head is moved to fit the length.'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def evaluate_envelope(
            self, point: typing.Optional[typing.Iterable[float]]) -> float:
        ''' Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Optional[typing.Iterable[float]]
        :rtype: float
        :return: Factor, Envelope factor
        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass


class BoneGroup(bpy_struct):
    ''' Groups of Pose Channels (Bones)
    '''

    color_set: typing.Union[str, int] = None
    ''' Custom color set to use

    :type: typing.Union[str, int]
    '''

    colors: 'ThemeBoneColorSet' = None
    ''' Copy of the colors associated with the group's color set

    :type: 'ThemeBoneColorSet'
    '''

    is_custom_color_set: typing.Union[bool, typing.Any] = None
    ''' Color set is user-defined instead of a fixed theme color set

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class BrushCapabilities(bpy_struct):
    ''' Read-only indications of which brush operations are supported by the current brush
    '''

    has_overlay: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_random_texture_angle: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_smooth_stroke: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_spacing: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''


class CameraStereoData(bpy_struct):
    ''' Stereoscopy settings for a Camera data-block
    '''

    convergence_distance: float = None
    ''' The converge point for the stereo cameras (often the distance between a projector and the projection screen)

    :type: float
    '''

    convergence_mode: typing.Union[str, int] = None
    ''' * ``OFFAXIS`` Off-Axis, Off-axis frustums converging in a plane. * ``PARALLEL`` Parallel, Parallel cameras with no convergence. * ``TOE`` Toe-in, Rotated cameras, looking at the convergence distance.

    :type: typing.Union[str, int]
    '''

    interocular_distance: float = None
    ''' Set the distance between the eyes - the stereo plane distance / 30 should be fine

    :type: float
    '''

    pivot: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    pole_merge_angle_from: float = None
    ''' Angle at which interocular distance starts to fade to 0

    :type: float
    '''

    pole_merge_angle_to: float = None
    ''' Angle at which interocular distance is 0

    :type: float
    '''

    use_pole_merge: bool = None
    ''' Fade interocular distance to 0 after the given cutoff angle

    :type: bool
    '''

    use_spherical_stereo: bool = None
    ''' Render every pixel rotating the camera around the middle of the interocular distance

    :type: bool
    '''


class ChildParticle(bpy_struct):
    ''' Child particle interpolated from simulated or edited particles
    '''

    pass


class ClothCollisionSettings(bpy_struct):
    ''' Cloth simulation settings for self collision and collision with other objects
    '''

    collision_quality: int = None
    ''' How many collision iterations should be done. (higher is better quality but slower)

    :type: int
    '''

    damping: float = None
    ''' Amount of velocity lost on collision

    :type: float
    '''

    distance_min: float = None
    ''' Minimum distance between collision objects before collision response takes in

    :type: float
    '''

    distance_repel: float = None
    ''' Maximum distance to apply repulsion force, must be greater than minimum distance

    :type: float
    '''

    friction: float = None
    ''' Friction force if a collision happened (higher = less movement)

    :type: float
    '''

    group: 'Group' = None
    ''' Limit colliders to this Group

    :type: 'Group'
    '''

    repel_force: float = None
    ''' Repulsion force to apply on cloth when close to colliding

    :type: float
    '''

    self_collision_quality: int = None
    ''' How many self collision iterations should be done (higher is better quality but slower)

    :type: int
    '''

    self_distance_min: float = None
    ''' 0.5 means no distance at all, 1.0 is maximum distance

    :type: float
    '''

    self_friction: float = None
    ''' Friction/damping with self contact

    :type: float
    '''

    use_collision: bool = None
    ''' Enable collisions with other objects

    :type: bool
    '''

    use_self_collision: bool = None
    ''' Enable self collisions

    :type: bool
    '''

    vertex_group_self_collisions: typing.Union[str, typing.Any] = None
    ''' Vertex group to define vertices which are not used during self collisions

    :type: typing.Union[str, typing.Any]
    '''


class ClothSettings(bpy_struct):
    ''' Cloth simulation settings for an object
    '''

    air_damping: float = None
    ''' Air has normally some thickness which slows falling things down

    :type: float
    '''

    bending_damping: float = None
    ''' Damping of bending motion

    :type: float
    '''

    bending_stiffness: float = None
    ''' Wrinkle coefficient (higher = less smaller but more big wrinkles)

    :type: float
    '''

    bending_stiffness_max: float = None
    ''' Maximum bending stiffness value

    :type: float
    '''

    collider_friction: float = None
    ''' 

    :type: float
    '''

    density_strength: float = None
    ''' Influence of target density on the simulation

    :type: float
    '''

    density_target: float = None
    ''' Maximum density of hair

    :type: float
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    goal_default: float = None
    ''' Default Goal (vertex target position) value, when no Vertex Group used

    :type: float
    '''

    goal_friction: float = None
    ''' Goal (vertex target position) friction

    :type: float
    '''

    goal_max: float = None
    ''' Goal maximum, vertex group weights are scaled to match this range

    :type: float
    '''

    goal_min: float = None
    ''' Goal minimum, vertex group weights are scaled to match this range

    :type: float
    '''

    goal_spring: float = None
    ''' Goal (vertex target position) spring stiffness

    :type: float
    '''

    gravity: bpy_prop_array[float] = None
    ''' Gravity or external force vector

    :type: bpy_prop_array[float]
    '''

    internal_friction: float = None
    ''' 

    :type: float
    '''

    mass: float = None
    ''' Mass of cloth material

    :type: float
    '''

    pin_stiffness: float = None
    ''' Pin (vertex target position) spring stiffness

    :type: float
    '''

    quality: int = None
    ''' Quality of the simulation in steps per frame (higher is better quality but slower)

    :type: int
    '''

    rest_shape_key: 'ShapeKey' = None
    ''' Shape key to use the rest spring lengths from

    :type: 'ShapeKey'
    '''

    sewing_force_max: float = None
    ''' Maximum sewing force

    :type: float
    '''

    shrink_max: float = None
    ''' Max amount to shrink cloth by

    :type: float
    '''

    shrink_min: float = None
    ''' Min amount to shrink cloth by

    :type: float
    '''

    spring_damping: float = None
    ''' Damping of cloth velocity (higher = more smooth, less jiggling)

    :type: float
    '''

    structural_stiffness: float = None
    ''' Overall stiffness of structure

    :type: float
    '''

    structural_stiffness_max: float = None
    ''' Maximum structural stiffness value

    :type: float
    '''

    time_scale: float = None
    ''' Cloth speed is multiplied by this value

    :type: float
    '''

    use_dynamic_mesh: bool = None
    ''' Make simulation respect deformations in the base mesh

    :type: bool
    '''

    use_pin_cloth: bool = None
    ''' Enable pinning of cloth vertices to other objects/positions

    :type: bool
    '''

    use_sewing_springs: bool = None
    ''' Pulls loose edges together

    :type: bool
    '''

    use_stiffness_scale: bool = None
    ''' If enabled, stiffness can be scaled along a weight painted vertex group

    :type: bool
    '''

    vel_damping: float = None
    ''' Damp velocity to help cloth reach the resting position faster (1.0 = no damping, 0.0 = fully dampened)

    :type: float
    '''

    vertex_group_bending: typing.Union[str, typing.Any] = None
    ''' Vertex group for fine control over bending stiffness

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_mass: typing.Union[str, typing.Any] = None
    ''' Vertex Group for pinning of vertices

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_shrink: typing.Union[str, typing.Any] = None
    ''' Vertex Group for shrinking cloth

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_structural_stiffness: typing.Union[str, typing.Any] = None
    ''' Vertex group for fine control over structural stiffness

    :type: typing.Union[str, typing.Any]
    '''

    voxel_cell_size: float = None
    ''' Size of the voxel grid cells for interaction effects

    :type: float
    '''


class ClothSolverResult(bpy_struct):
    ''' Result of cloth solver iteration
    '''

    avg_error: float = None
    ''' Average error during substeps

    :type: float
    '''

    avg_iterations: float = None
    ''' Average iterations during substeps

    :type: float
    '''

    max_error: float = None
    ''' Maximum error during substeps

    :type: float
    '''

    max_iterations: int = None
    ''' Maximum iterations during substeps

    :type: int
    '''

    min_error: float = None
    ''' Minimum error during substeps

    :type: float
    '''

    min_iterations: int = None
    ''' Minimum iterations during substeps

    :type: int
    '''

    status: typing.Any = None
    ''' Status of the solver iteration * ``SUCCESS`` Success, Computation was successful. * ``NUMERICAL_ISSUE`` Numerical Issue, The provided data did not satisfy the prerequisites. * ``NO_CONVERGENCE`` No Convergence, Iterative procedure did not converge. * ``INVALID_INPUT`` Invalid Input, The inputs are invalid, or the algorithm has been improperly called.

    :type: typing.Any
    '''


class CollisionSettings(bpy_struct):
    ''' Collision settings for object in physics simulation
    '''

    absorption: float = None
    ''' How much of effector force gets lost during collision with this object (in percent)

    :type: float
    '''

    damping: float = None
    ''' Amount of damping during collision

    :type: float
    '''

    damping_factor: float = None
    ''' Amount of damping during particle collision

    :type: float
    '''

    damping_random: float = None
    ''' Random variation of damping

    :type: float
    '''

    friction_factor: float = None
    ''' Amount of friction during particle collision

    :type: float
    '''

    friction_random: float = None
    ''' Random variation of friction

    :type: float
    '''

    permeability: float = None
    ''' Chance that the particle will pass through the mesh

    :type: float
    '''

    stickiness: float = None
    ''' Amount of stickiness to surface collision

    :type: float
    '''

    thickness_inner: float = None
    ''' Inner face thickness (only used by softbodies)

    :type: float
    '''

    thickness_outer: float = None
    ''' Outer face thickness

    :type: float
    '''

    use: bool = None
    ''' Enable this objects as a collider for physics systems

    :type: bool
    '''

    use_particle_kill: bool = None
    ''' Kill collided particles

    :type: bool
    '''


class ColorManagedDisplaySettings(bpy_struct):
    ''' Color management specific to display device
    '''

    display_device: typing.Union[str, int] = None
    ''' Display device name

    :type: typing.Union[str, int]
    '''


class ColorManagedInputColorspaceSettings(bpy_struct):
    ''' Input color space settings
    '''

    name: typing.Union[str, int] = None
    ''' Color space of the image or movie on disk * ``Linear`` Linear, Rec. 709 (Full Range), Blender native linear space. * ``Linear ACES`` Linear ACES, ACES linear space. * ``Non-Color`` Non-Color, Color space used for images which contains non-color data (i,e, normal maps). * ``Raw`` Raw. * ``sRGB`` sRGB, Standard RGB Display Space. * ``VD16`` VD16, The simple video conversion from a gamma 2.2 sRGB space. * ``XYZ`` XYZ.

    :type: typing.Union[str, int]
    '''


class ColorManagedSequencerColorspaceSettings(bpy_struct):
    ''' Input color space settings
    '''

    name: typing.Union[str, int] = None
    ''' Color space that the sequencer operates in * ``Linear`` Linear, Rec. 709 (Full Range), Blender native linear space. * ``Linear ACES`` Linear ACES, ACES linear space. * ``Non-Color`` Non-Color, Color space used for images which contains non-color data (i,e, normal maps). * ``Raw`` Raw. * ``sRGB`` sRGB, Standard RGB Display Space. * ``VD16`` VD16, The simple video conversion from a gamma 2.2 sRGB space. * ``XYZ`` XYZ.

    :type: typing.Union[str, int]
    '''


class ColorManagedViewSettings(bpy_struct):
    ''' Color management settings used for displaying images on the display
    '''

    curve_mapping: 'CurveMapping' = None
    ''' Color curve mapping applied before display transform

    :type: 'CurveMapping'
    '''

    exposure: float = None
    ''' Exposure (stops) applied before display transform

    :type: float
    '''

    gamma: float = None
    ''' Amount of gamma modification applied after display transform

    :type: float
    '''

    look: typing.Union[str, int] = None
    ''' Additional transform applied before view transform for an artistic needs * ``NONE`` None, Do not modify image in an artistic manner.

    :type: typing.Union[str, int]
    '''

    use_curve_mapping: bool = None
    ''' Use RGB curved for pre-display transformation

    :type: bool
    '''

    view_transform: typing.Union[str, int] = None
    ''' View used when converting image to a display space * ``NONE`` None, Do not perform any color transform on display, use old non-color managed technique for display.

    :type: typing.Union[str, int]
    '''


class ColorMapping(bpy_struct):
    ''' Color mapping settings
    '''

    blend_color: bpy_prop_array[float] = None
    ''' Blend color to mix with texture output color

    :type: bpy_prop_array[float]
    '''

    blend_factor: float = None
    ''' 

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' Mode used to mix with texture output color

    :type: typing.Union[str, int]
    '''

    brightness: float = None
    ''' Adjust the brightness of the texture

    :type: float
    '''

    color_ramp: 'ColorRamp' = None
    ''' 

    :type: 'ColorRamp'
    '''

    contrast: float = None
    ''' Adjust the contrast of the texture

    :type: float
    '''

    saturation: float = None
    ''' Adjust the saturation of colors in the texture

    :type: float
    '''

    use_color_ramp: bool = None
    ''' Toggle color ramp operations

    :type: bool
    '''


class ColorRamp(bpy_struct):
    ''' Color ramp mapping a scalar value to a color
    '''

    color_mode: typing.Union[str, int] = None
    ''' Set color mode to use for interpolation

    :type: typing.Union[str, int]
    '''

    elements: 'ColorRampElements' = None
    ''' 

    :type: 'ColorRampElements'
    '''

    hue_interpolation: typing.Union[str, int] = None
    ''' Set color interpolation

    :type: typing.Union[str, int]
    '''

    interpolation: typing.Union[str, int] = None
    ''' Set interpolation between color stops

    :type: typing.Union[str, int]
    '''

    def evaluate(self,
                 position: typing.Optional[float]) -> bpy_prop_array[float]:
        ''' Evaluate ColorRamp

        :param position: Position, Evaluate ColorRamp at position
        :type position: typing.Optional[float]
        :rtype: bpy_prop_array[float]
        :return: Color, Color at given position
        '''
        pass


class ColorRampElement(bpy_struct):
    ''' Element defining a color at a position in the color ramp
    '''

    alpha: float = None
    ''' Set alpha of selected color stop

    :type: float
    '''

    color: bpy_prop_array[float] = None
    ''' Set color of selected color stop

    :type: bpy_prop_array[float]
    '''

    position: float = None
    ''' Set position of selected color stop

    :type: float
    '''


class ConsoleLine(bpy_struct):
    ''' Input line for the interactive console
    '''

    body: typing.Union[str, typing.Any] = None
    ''' Text in the line

    :type: typing.Union[str, typing.Any]
    '''

    current_character: int = None
    ''' 

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Console line type when used in scrollback

    :type: typing.Union[str, int]
    '''


class Constraint(bpy_struct):
    ''' Constraint modifying the transformation of objects and bones
    '''

    active: bool = None
    ''' Constraint is the one being edited

    :type: bool
    '''

    error_location: float = None
    ''' Amount of residual error in Blender space unit for constraints that work on position

    :type: float
    '''

    error_rotation: float = None
    ''' Amount of residual error in radians for constraints that work on orientation

    :type: float
    '''

    influence: float = None
    ''' Amount of influence constraint will have on the final solution

    :type: float
    '''

    is_proxy_local: bool = None
    ''' Constraint was added in this proxy instance (i.e. did not belong to source Armature)

    :type: bool
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' Constraint has valid settings and can be evaluated

    :type: typing.Union[bool, typing.Any]
    '''

    mute: bool = None
    ''' Enable/Disable Constraint

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Constraint name

    :type: typing.Union[str, typing.Any]
    '''

    owner_space: typing.Union[str, int] = None
    ''' Space that owner is evaluated in * ``WORLD`` World Space, The constraint is applied relative to the world coordinate system. * ``POSE`` Pose Space, The constraint is applied in Pose Space, the object transformation is ignored. * ``LOCAL_WITH_PARENT`` Local With Parent, The constraint is applied relative to the local coordinate system of the object, with the parent transformation added. * ``LOCAL`` Local Space, The constraint is applied relative to the local coordinate system of the object.

    :type: typing.Union[str, int]
    '''

    show_expanded: bool = None
    ''' Constraint's panel is expanded in UI

    :type: bool
    '''

    target_space: typing.Union[str, int] = None
    ''' Space that target is evaluated in * ``WORLD`` World Space, The transformation of the target is evaluated relative to the world coordinate system. * ``POSE`` Pose Space, The transformation of the target is only evaluated in the Pose Space, the target armature object transformation is ignored. * ``LOCAL_WITH_PARENT`` Local With Parent, The transformation of the target bone is evaluated relative its local coordinate system, with the parent transformation added. * ``LOCAL`` Local Space, The transformation of the target is evaluated relative to its local coordinate system.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' * ``CAMERA_SOLVER`` Camera Solver. * ``FOLLOW_TRACK`` Follow Track. * ``OBJECT_SOLVER`` Object Solver. * ``COPY_LOCATION`` Copy Location, Copy the location of a target (with an optional offset), so that they move together. * ``COPY_ROTATION`` Copy Rotation, Copy the rotation of a target (with an optional offset), so that they rotate together. * ``COPY_SCALE`` Copy Scale, Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount. * ``COPY_TRANSFORMS`` Copy Transforms, Copy all the transformations of a target, so that they move together. * ``LIMIT_DISTANCE`` Limit Distance, Restrict movements to within a certain distance of a target (at the time of constraint evaluation only). * ``LIMIT_LOCATION`` Limit Location, Restrict movement along each axis within given ranges. * ``LIMIT_ROTATION`` Limit Rotation, Restrict rotation along each axis within given ranges. * ``LIMIT_SCALE`` Limit Scale, Restrict scaling along each axis with given ranges. * ``MAINTAIN_VOLUME`` Maintain Volume, Compensate for scaling one axis by applying suitable scaling to the other two axes. * ``TRANSFORM`` Transformation, Use one transform property from target to control another (or same) property on owner. * ``TRANSFORM_CACHE`` Transform Cache, Look up the transformation matrix from an external file. * ``CLAMP_TO`` Clamp To, Restrict movements to lie along a curve by remapping location along curve's longest axis. * ``DAMPED_TRACK`` Damped Track, Point towards a target by performing the smallest rotation necessary. * ``IK`` Inverse Kinematics, Control a chain of bones by specifying the endpoint target (Bones only). * ``LOCKED_TRACK`` Locked Track, Rotate around the specified ('locked') axis to point towards a target. * ``SPLINE_IK`` Spline IK, Align chain of bones along a curve (Bones only). * ``STRETCH_TO`` Stretch To, Stretch along Y-Axis to point towards a target. * ``TRACK_TO`` Track To, Legacy tracking constraint prone to twisting artifacts. * ``ACTION`` Action, Use transform property of target to look up pose for owner from an Action. * ``CHILD_OF`` Child Of, Make target the 'detachable' parent of owner. * ``FLOOR`` Floor, Use position (and optionally rotation) of target to define a 'wall' or 'floor' that the owner can not cross. * ``FOLLOW_PATH`` Follow Path, Use to animate an object/bone following a path. * ``PIVOT`` Pivot, Change pivot point for transforms (buggy). * ``RIGID_BODY_JOINT`` Rigid Body Joint, Use to define a Rigid Body Constraint (for Game Engine use only). * ``SHRINKWRAP`` Shrinkwrap, Restrict movements to surface of target mesh.

    :type: typing.Union[str, int]
    '''


class ConstraintTarget(bpy_struct):
    ''' Target object for multi-target constraints
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''


class Context(bpy_struct):
    ''' Current windowmanager and data context
    '''

    area: 'Area' = None
    ''' 

    :type: 'Area'
    '''

    blend_data: 'BlendData' = None
    ''' 

    :type: 'BlendData'
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    region: 'Region' = None
    ''' 

    :type: 'Region'
    '''

    region_data: 'RegionView3D' = None
    ''' 

    :type: 'RegionView3D'
    '''

    scene: 'Scene' = None
    ''' 

    :type: 'Scene'
    '''

    screen: 'Screen' = None
    ''' 

    :type: 'Screen'
    '''

    space_data: 'Space' = None
    ''' 

    :type: 'Space'
    '''

    tool_settings: 'ToolSettings' = None
    ''' 

    :type: 'ToolSettings'
    '''

    user_preferences: 'UserPreferences' = None
    ''' 

    :type: 'UserPreferences'
    '''

    window: 'Window' = None
    ''' 

    :type: 'Window'
    '''

    window_manager: 'WindowManager' = None
    ''' 

    :type: 'WindowManager'
    '''

    visible_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    visible_bases: typing.Iterable['ObjectBase'] = None
    ''' 

    :type: typing.Iterable['ObjectBase']
    '''

    selectable_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    selectable_bases: typing.Iterable['ObjectBase'] = None
    ''' 

    :type: typing.Iterable['ObjectBase']
    '''

    selected_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    selected_bases: typing.Iterable['ObjectBase'] = None
    ''' 

    :type: typing.Iterable['ObjectBase']
    '''

    editable_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    editable_bases: typing.Iterable['ObjectBase'] = None
    ''' 

    :type: typing.Iterable['ObjectBase']
    '''

    selected_editable_objects: typing.Iterable['Object'] = None
    ''' 

    :type: typing.Iterable['Object']
    '''

    selected_editable_bases: typing.Iterable['ObjectBase'] = None
    ''' 

    :type: typing.Iterable['ObjectBase']
    '''

    visible_bones: typing.Iterable['EditBone'] = None
    ''' 

    :type: typing.Iterable['EditBone']
    '''

    editable_bones: typing.Iterable['EditBone'] = None
    ''' 

    :type: typing.Iterable['EditBone']
    '''

    selected_bones: typing.Iterable['EditBone'] = None
    ''' 

    :type: typing.Iterable['EditBone']
    '''

    selected_editable_bones: typing.Iterable['EditBone'] = None
    ''' 

    :type: typing.Iterable['EditBone']
    '''

    visible_pose_bones: typing.Iterable['PoseBone'] = None
    ''' 

    :type: typing.Iterable['PoseBone']
    '''

    selected_pose_bones: typing.Iterable['PoseBone'] = None
    ''' 

    :type: typing.Iterable['PoseBone']
    '''

    active_bone: 'EditBone' = None
    ''' 

    :type: 'EditBone'
    '''

    active_pose_bone: 'PoseBone' = None
    ''' 

    :type: 'PoseBone'
    '''

    active_base: 'ObjectBase' = None
    ''' 

    :type: 'ObjectBase'
    '''

    active_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    edit_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    sculpt_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    vertex_paint_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    weight_paint_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    image_paint_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    particle_edit_object: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    sequences: typing.Iterable['Sequence'] = None
    ''' 

    :type: typing.Iterable['Sequence']
    '''

    selected_sequences: typing.Iterable['Sequence'] = None
    ''' 

    :type: typing.Iterable['Sequence']
    '''

    selected_editable_sequences: typing.Iterable['Sequence'] = None
    ''' 

    :type: typing.Iterable['Sequence']
    '''

    gpencil_data: typing.Any = None
    ''' 

    :type: typing.Any
    '''

    gpencil_data_owner: 'ID' = None
    ''' 

    :type: 'ID'
    '''

    visible_gpencil_layers: typing.Iterable['GPencilLayer'] = None
    ''' 

    :type: typing.Iterable['GPencilLayer']
    '''

    editable_gpencil_layers: typing.Iterable['GPencilLayer'] = None
    ''' 

    :type: typing.Iterable['GPencilLayer']
    '''

    editable_gpencil_strokes: typing.Iterable['GPencilStroke'] = None
    ''' 

    :type: typing.Iterable['GPencilStroke']
    '''

    active_gpencil_layer: typing.Iterable['GPencilLayer'] = None
    ''' 

    :type: typing.Iterable['GPencilLayer']
    '''

    active_gpencil_frame: typing.List = None
    ''' 

    :type: typing.List
    '''

    active_gpencil_palette: typing.Iterable['GPencilPalette'] = None
    ''' 

    :type: typing.Iterable['GPencilPalette']
    '''

    active_gpencil_palettecolor: typing.Iterable['GPencilPaletteColor'] = None
    ''' 

    :type: typing.Iterable['GPencilPaletteColor']
    '''

    active_gpencil_brush: 'GPencilSculptBrush' = None
    ''' 

    :type: 'GPencilSculptBrush'
    '''

    active_operator: 'Operator' = None
    ''' 

    :type: 'Operator'
    '''

    texture_slot: 'MaterialTextureSlot' = None
    ''' 

    :type: 'MaterialTextureSlot'
    '''

    world: 'World' = None
    ''' 

    :type: 'World'
    '''

    mesh: 'Mesh' = None
    ''' 

    :type: 'Mesh'
    '''

    armature: 'Armature' = None
    ''' 

    :type: 'Armature'
    '''

    lattice: 'Lattice' = None
    ''' 

    :type: 'Lattice'
    '''

    curve: 'Curve' = None
    ''' 

    :type: 'Curve'
    '''

    meta_ball: 'MetaBall' = None
    ''' 

    :type: 'MetaBall'
    '''

    lamp: 'Lamp' = None
    ''' 

    :type: 'Lamp'
    '''

    speaker: 'Speaker' = None
    ''' 

    :type: 'Speaker'
    '''

    camera: 'Camera' = None
    ''' 

    :type: 'Camera'
    '''

    material: 'Material' = None
    ''' 

    :type: 'Material'
    '''

    material_slot: 'MaterialSlot' = None
    ''' 

    :type: 'MaterialSlot'
    '''

    texture: 'Texture' = None
    ''' 

    :type: 'Texture'
    '''

    texture_user: 'ID' = None
    ''' 

    :type: 'ID'
    '''

    texture_user_property: 'Property' = None
    ''' 

    :type: 'Property'
    '''

    bone: 'Bone' = None
    ''' 

    :type: 'Bone'
    '''

    edit_bone: 'EditBone' = None
    ''' 

    :type: 'EditBone'
    '''

    pose_bone: 'PoseBone' = None
    ''' 

    :type: 'PoseBone'
    '''

    particle_system: 'ParticleSystem' = None
    ''' 

    :type: 'ParticleSystem'
    '''

    particle_system_editable: 'ParticleSystem' = None
    ''' 

    :type: 'ParticleSystem'
    '''

    particle_settings: 'ParticleSettings' = None
    ''' 

    :type: 'ParticleSettings'
    '''

    cloth: 'ClothModifier' = None
    ''' 

    :type: 'ClothModifier'
    '''

    soft_body: 'SoftBodyModifier' = None
    ''' 

    :type: 'SoftBodyModifier'
    '''

    fluid: 'FluidSimulationModifier' = None
    ''' 

    :type: 'FluidSimulationModifier'
    '''

    smoke: 'SmokeModifier' = None
    ''' 

    :type: 'SmokeModifier'
    '''

    collision: 'CollisionModifier' = None
    ''' 

    :type: 'CollisionModifier'
    '''

    brush: 'Brush' = None
    ''' 

    :type: 'Brush'
    '''

    dynamic_paint: 'DynamicPaintModifier' = None
    ''' 

    :type: 'DynamicPaintModifier'
    '''

    line_style: 'FreestyleLineStyle' = None
    ''' 

    :type: 'FreestyleLineStyle'
    '''

    edit_image: 'Image' = None
    ''' 

    :type: 'Image'
    '''

    edit_mask: 'Mask' = None
    ''' 

    :type: 'Mask'
    '''

    selected_nodes: typing.Iterable['Node'] = None
    ''' 

    :type: typing.Iterable['Node']
    '''

    active_node: 'Node' = None
    ''' 

    :type: 'Node'
    '''

    edit_text: 'Text' = None
    ''' 

    :type: 'Text'
    '''

    edit_movieclip: 'MovieClip' = None
    ''' 

    :type: 'MovieClip'
    '''

    def copy(self):
        ''' 

        '''
        pass


class Controller(bpy_struct):
    ''' Game engine logic brick to process events, connecting sensors to actuators
    '''

    active: bool = None
    ''' Set the active state of the controller

    :type: bool
    '''

    actuators: bpy_prop_collection['Actuator'] = None
    ''' The list containing the actuators connected to the controller

    :type: bpy_prop_collection['Actuator']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    show_expanded: bool = None
    ''' Set controller expanded in the user interface

    :type: bool
    '''

    states: int = None
    ''' Set Controller state index (1 to 30)

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' * ``LOGIC_AND`` And, Logic And. * ``LOGIC_OR`` Or, Logic Or. * ``LOGIC_NAND`` Nand, Logic Nand. * ``LOGIC_NOR`` Nor, Logic Nor. * ``LOGIC_XOR`` Xor, Logic Xor. * ``LOGIC_XNOR`` Xnor, Logic Xnor. * ``EXPRESSION`` Expression. * ``PYTHON`` Python.

    :type: typing.Union[str, int]
    '''

    use_priority: bool = None
    ''' Mark controller for execution before all non-marked controllers (good for startup scripts)

    :type: bool
    '''

    def link(self,
             sensor: typing.Optional['Sensor'] = None,
             actuator: typing.Optional['Actuator'] = None):
        ''' Link the controller with a sensor/actuator

        :param sensor: Sensor to link the controller to
        :type sensor: typing.Optional['Sensor']
        :param actuator: Actuator to link the controller to
        :type actuator: typing.Optional['Actuator']
        '''
        pass

    def unlink(self,
               sensor: typing.Optional['Sensor'] = None,
               actuator: typing.Optional['Actuator'] = None):
        ''' Unlink the controller from a sensor/actuator

        :param sensor: Sensor to unlink the controller from
        :type sensor: typing.Optional['Sensor']
        :param actuator: Actuator to unlink the controller from
        :type actuator: typing.Optional['Actuator']
        '''
        pass


class CurveMap(bpy_struct):
    ''' Curve in a curve mapping
    '''

    extend: typing.Union[str, int] = None
    ''' Extrapolate the curve or extend it horizontally

    :type: typing.Union[str, int]
    '''

    points: 'CurveMapPoints' = None
    ''' 

    :type: 'CurveMapPoints'
    '''

    def evaluate(self, position: typing.Optional[float]) -> float:
        ''' Evaluate curve at given location

        :param position: Position, Position to evaluate curve at
        :type position: typing.Optional[float]
        :rtype: float
        :return: Value, Value of curve at given location
        '''
        pass


class CurveMapPoint(bpy_struct):
    ''' Point of a curve used for a curve mapping
    '''

    handle_type: typing.Union[str, int] = None
    ''' Curve interpolation at this point: Bezier or vector

    :type: typing.Union[str, int]
    '''

    location: bpy_prop_array[float] = None
    ''' X/Y coordinates of the curve point

    :type: bpy_prop_array[float]
    '''

    select: bool = None
    ''' Selection state of the curve point

    :type: bool
    '''


class CurveMapping(bpy_struct):
    ''' Curve mapping to map color, vector and scalar values to other values using a user defined curve
    '''

    black_level: bpy_prop_array[float] = None
    ''' For RGB curves, the color that black is mapped to

    :type: bpy_prop_array[float]
    '''

    clip_max_x: float = None
    ''' 

    :type: float
    '''

    clip_max_y: float = None
    ''' 

    :type: float
    '''

    clip_min_x: float = None
    ''' 

    :type: float
    '''

    clip_min_y: float = None
    ''' 

    :type: float
    '''

    curves: bpy_prop_collection['CurveMap'] = None
    ''' 

    :type: bpy_prop_collection['CurveMap']
    '''

    use_clip: bool = None
    ''' Force the curve view to fit a defined boundary

    :type: bool
    '''

    white_level: bpy_prop_array[float] = None
    ''' For RGB curves, the color that white is mapped to

    :type: bpy_prop_array[float]
    '''

    def update(self):
        ''' Update curve mapping after making changes

        '''
        pass

    def initialize(self):
        ''' Initialize curve

        '''
        pass


class CurvePaintSettings(bpy_struct):
    corner_angle: float = None
    ''' Angles above this are considered corners

    :type: float
    '''

    curve_type: typing.Union[str, int] = None
    ''' Type of curve to use for new strokes

    :type: typing.Union[str, int]
    '''

    depth_mode: typing.Union[str, int] = None
    ''' Method of projecting depth

    :type: typing.Union[str, int]
    '''

    error_threshold: int = None
    ''' Allow deviation for a smoother, less precise line

    :type: int
    '''

    fit_method: typing.Union[str, int] = None
    ''' Curve fitting method * ``REFIT`` Refit, Incrementally re-fit the curve (high quality). * ``SPLIT`` Split, Split the curve until the tolerance is met (fast).

    :type: typing.Union[str, int]
    '''

    radius_max: float = None
    ''' Radius to use when the maximum pressure is applied (or when a tablet isn't used)

    :type: float
    '''

    radius_min: float = None
    ''' Minimum radius when the minimum pressure is applied (also the minimum when tapering)

    :type: float
    '''

    radius_taper_end: float = None
    ''' Taper factor for the radius of each point along the curve

    :type: float
    '''

    radius_taper_start: float = None
    ''' Taper factor for the radius of each point along the curve

    :type: float
    '''

    surface_offset: float = None
    ''' Offset the stroke from the surface

    :type: float
    '''

    surface_plane: typing.Union[str, int] = None
    ''' Plane for projected stroke * ``NORMAL_VIEW`` Normal/View, Draw perpendicular to the surface. * ``NORMAL_SURFACE`` Normal/Surface, Draw aligned to the surface. * ``VIEW`` View, Draw aligned to the viewport.

    :type: typing.Union[str, int]
    '''

    use_corners_detect: bool = None
    ''' Detect corners and use non-aligned handles

    :type: bool
    '''

    use_offset_absolute: bool = None
    ''' Apply a fixed offset (don't scale by the radius)

    :type: bool
    '''

    use_pressure_radius: bool = None
    ''' Map tablet pressure to curve radius

    :type: bool
    '''

    use_stroke_endpoints: bool = None
    ''' Use the start of the stroke for the depth

    :type: bool
    '''


class Depsgraph(bpy_struct):
    def debug_graphviz(self, filename: typing.Union[str, typing.Any]):
        ''' debug_graphviz

        :param filename: File Name, File in which to store graphviz debug output
        :type filename: typing.Union[str, typing.Any]
        '''
        pass

    def debug_rebuild(self):
        ''' debug_rebuild

        '''
        pass

    def debug_stats(self):
        ''' Report the number of elements in the Dependency Graph

        '''
        pass


class DisplaySafeAreas(bpy_struct):
    ''' Safe Areas used in 3D view and the VSE
    '''

    action: bpy_prop_array[float] = None
    ''' Safe area for general elements

    :type: bpy_prop_array[float]
    '''

    action_center: bpy_prop_array[float] = None
    ''' Safe area for general elements in a different aspect ratio

    :type: bpy_prop_array[float]
    '''

    title: bpy_prop_array[float] = None
    ''' Safe area for text and graphics

    :type: bpy_prop_array[float]
    '''

    title_center: bpy_prop_array[float] = None
    ''' Safe area for text and graphics in a different aspect ratio

    :type: bpy_prop_array[float]
    '''


class DopeSheet(bpy_struct):
    ''' Settings for filtering the channels shown in animation editors
    '''

    filter_fcurve_name: typing.Union[str, typing.Any] = None
    ''' F-Curve live filtering string

    :type: typing.Union[str, typing.Any]
    '''

    filter_group: 'Group' = None
    ''' Group that included object should be a member of

    :type: 'Group'
    '''

    filter_text: typing.Union[str, typing.Any] = None
    ''' Live filtering string

    :type: typing.Union[str, typing.Any]
    '''

    show_armatures: bool = None
    ''' Include visualization of armature related animation data

    :type: bool
    '''

    show_cameras: bool = None
    ''' Include visualization of camera related animation data

    :type: bool
    '''

    show_curves: bool = None
    ''' Include visualization of curve related animation data

    :type: bool
    '''

    show_datablock_filters: bool = None
    ''' Show options for whether channels related to certain types of data are included

    :type: bool
    '''

    show_expanded_summary: bool = None
    ''' Collapse summary when shown, so all other channels get hidden (Dope Sheet editors only)

    :type: bool
    '''

    show_gpencil: bool = None
    ''' Include visualization of Grease Pencil related animation data and frames

    :type: bool
    '''

    show_gpencil_3d_only: bool = None
    ''' Only show Grease Pencil datablocks used as part of the active scene

    :type: bool
    '''

    show_hidden: bool = None
    ''' Include channels from objects/bone that are not visible

    :type: bool
    '''

    show_lamps: bool = None
    ''' Include visualization of lamp related animation data

    :type: bool
    '''

    show_lattices: bool = None
    ''' Include visualization of lattice related animation data

    :type: bool
    '''

    show_linestyles: bool = None
    ''' Include visualization of Line Style related Animation data

    :type: bool
    '''

    show_materials: bool = None
    ''' Include visualization of material related animation data

    :type: bool
    '''

    show_meshes: bool = None
    ''' Include visualization of mesh related animation data

    :type: bool
    '''

    show_metaballs: bool = None
    ''' Include visualization of metaball related animation data

    :type: bool
    '''

    show_missing_nla: bool = None
    ''' Include animation data blocks with no NLA data (NLA editor only)

    :type: bool
    '''

    show_modifiers: bool = None
    ''' Include visualization of animation data related to data-blocks linked to modifiers

    :type: bool
    '''

    show_nodes: bool = None
    ''' Include visualization of node related animation data

    :type: bool
    '''

    show_only_errors: bool = None
    ''' Only include F-Curves and drivers that are disabled or have errors

    :type: bool
    '''

    show_only_group_objects: bool = None
    ''' Only include channels from objects in the specified group

    :type: bool
    '''

    show_only_matching_fcurves: bool = None
    ''' Only include F-Curves with names containing search text

    :type: bool
    '''

    show_only_selected: bool = None
    ''' Only include channels relating to selected objects and data

    :type: bool
    '''

    show_particles: bool = None
    ''' Include visualization of particle related animation data

    :type: bool
    '''

    show_scenes: bool = None
    ''' Include visualization of scene related animation data

    :type: bool
    '''

    show_shapekeys: bool = None
    ''' Include visualization of shape key related animation data

    :type: bool
    '''

    show_speakers: bool = None
    ''' Include visualization of speaker related animation data

    :type: bool
    '''

    show_summary: bool = None
    ''' Display an additional 'summary' line (Dope Sheet editors only)

    :type: bool
    '''

    show_textures: bool = None
    ''' Include visualization of texture related animation data

    :type: bool
    '''

    show_transforms: bool = None
    ''' Include visualization of object-level animation data (mostly transforms)

    :type: bool
    '''

    show_worlds: bool = None
    ''' Include visualization of world related animation data

    :type: bool
    '''

    source: 'ID' = None
    ''' ID-Block representing source data, usually ID_SCE (i.e. Scene)

    :type: 'ID'
    '''

    use_datablock_sort: bool = None
    ''' Alphabetically sorts datablocks - mainly objects in the scene (disable to increase viewport speed)

    :type: bool
    '''

    use_filter_text: bool = None
    ''' Only include channels with names containing search text

    :type: bool
    '''

    use_multi_word_filter: bool = None
    ''' Perform fuzzy/multi-word matching (WARNING: May be slow)

    :type: bool
    '''


class Driver(bpy_struct):
    ''' Driver for the value of a setting based on an external value
    '''

    expression: typing.Union[str, typing.Any] = None
    ''' Expression to use for Scripted Expression

    :type: typing.Union[str, typing.Any]
    '''

    is_valid: bool = None
    ''' Driver could not be evaluated in past, so should be skipped

    :type: bool
    '''

    show_debug_info: bool = None
    ''' Show intermediate values for the driver calculations to allow debugging of drivers

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Driver type

    :type: typing.Union[str, int]
    '''

    use_self: bool = None
    ''' Include a 'self' variable in the name-space, so drivers can easily reference the data being modified (object, bone, etc...)

    :type: bool
    '''

    variables: 'ChannelDriverVariables' = None
    ''' Properties acting as inputs for this driver

    :type: 'ChannelDriverVariables'
    '''


class DriverTarget(bpy_struct):
    ''' Source of input values for driver variables
    '''

    bone_target: typing.Union[str, typing.Any] = None
    ''' Name of PoseBone to use as target

    :type: typing.Union[str, typing.Any]
    '''

    data_path: typing.Union[str, typing.Any] = None
    ''' RNA Path (from ID-block) to property used

    :type: typing.Union[str, typing.Any]
    '''

    id: 'ID' = None
    ''' ID-block that the specific property used can be found from (id_type property must be set first)

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    transform_space: typing.Union[str, int] = None
    ''' Space in which transforms are used * ``WORLD_SPACE`` World Space, Transforms include effects of parenting/restpose and constraints. * ``TRANSFORM_SPACE`` Transform Space, Transforms don't include parenting/restpose or constraints. * ``LOCAL_SPACE`` Local Space, Transforms include effects of constraints but not parenting/restpose.

    :type: typing.Union[str, int]
    '''

    transform_type: typing.Union[str, int] = None
    ''' Driver variable type

    :type: typing.Union[str, int]
    '''


class DriverVariable(bpy_struct):
    ''' Variable from some source/target for driver relationship
    '''

    is_name_valid: typing.Union[bool, typing.Any] = None
    ''' Is this a valid name for a driver variable

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name to use in scripted expressions/functions (no spaces or dots are allowed, and must start with a letter)

    :type: typing.Union[str, typing.Any]
    '''

    targets: bpy_prop_collection['DriverTarget'] = None
    ''' Sources of input data for evaluating this variable

    :type: bpy_prop_collection['DriverTarget']
    '''

    type: typing.Union[str, int] = None
    ''' Driver variable type * ``SINGLE_PROP`` Single Property, Use the value from some RNA property (Default). * ``TRANSFORMS`` Transform Channel, Final transformation value of object or bone. * ``ROTATION_DIFF`` Rotational Difference, Use the angle between two bones. * ``LOC_DIFF`` Distance, Distance between two bones or objects.

    :type: typing.Union[str, int]
    '''


class DupliObject(bpy_struct):
    ''' An object duplicate
    '''

    hide: typing.Union[bool, typing.Any] = None
    ''' Don't show dupli object in viewport or render

    :type: typing.Union[bool, typing.Any]
    '''

    index: int = None
    ''' Index in the lowest-level dupli list

    :type: int
    '''

    matrix: bpy_prop_array[float] = None
    ''' Object duplicate transformation matrix

    :type: bpy_prop_array[float]
    '''

    object: 'Object' = None
    ''' Object being duplicated

    :type: 'Object'
    '''

    orco: bpy_prop_array[float] = None
    ''' Generated coordinates in parent object space

    :type: bpy_prop_array[float]
    '''

    particle_system: 'ParticleSystem' = None
    ''' Particle system that this dupli object was instanced from

    :type: 'ParticleSystem'
    '''

    persistent_id: bpy_prop_array[int] = None
    ''' Persistent identifier for inter-frame matching of objects with motion blur

    :type: bpy_prop_array[int]
    '''

    type: typing.Union[str, int] = None
    ''' Duplicator type that generated this dupli object * ``NONE`` None. * ``FRAMES`` Frames, Make copy of object for every frame. * ``VERTS`` Verts, Duplicate child objects on all vertices. * ``FACES`` Faces, Duplicate child objects on all faces. * ``GROUP`` Group, Enable group instancing.

    :type: typing.Union[str, int]
    '''

    uv: bpy_prop_array[float] = None
    ''' UV coordinates in parent object space

    :type: bpy_prop_array[float]
    '''


class DynamicPaintBrushSettings(bpy_struct):
    ''' Brush settings
    '''

    invert_proximity: bool = None
    ''' Proximity falloff is applied inside the volume

    :type: bool
    '''

    material: 'Material' = None
    ''' Material to use (if not defined, material linked to the mesh is used)

    :type: 'Material'
    '''

    paint_alpha: float = None
    ''' Paint alpha

    :type: float
    '''

    paint_color: bpy_prop_array[float] = None
    ''' Color of the paint

    :type: bpy_prop_array[float]
    '''

    paint_distance: float = None
    ''' Maximum distance from brush to mesh surface to affect paint

    :type: float
    '''

    paint_ramp: 'ColorRamp' = None
    ''' Color ramp used to define proximity falloff

    :type: 'ColorRamp'
    '''

    paint_source: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    paint_wetness: float = None
    ''' Paint wetness, visible in wetmap (some effects only affect wet paint)

    :type: float
    '''

    particle_system: 'ParticleSystem' = None
    ''' The particle system to paint with

    :type: 'ParticleSystem'
    '''

    proximity_falloff: typing.Union[str, int] = None
    ''' Proximity falloff type

    :type: typing.Union[str, int]
    '''

    ray_direction: typing.Union[str, int] = None
    ''' Ray direction to use for projection (if brush object is located in that direction it's painted)

    :type: typing.Union[str, int]
    '''

    smooth_radius: float = None
    ''' Smooth falloff added after solid radius

    :type: float
    '''

    smudge_strength: float = None
    ''' Smudge effect strength

    :type: float
    '''

    solid_radius: float = None
    ''' Radius that will be painted solid

    :type: float
    '''

    use_absolute_alpha: bool = None
    ''' Only increase alpha value if paint alpha is higher than existing

    :type: bool
    '''

    use_material: bool = None
    ''' Use object material to define color and influence

    :type: bool
    '''

    use_negative_volume: bool = None
    ''' Negate influence inside the volume

    :type: bool
    '''

    use_paint_erase: bool = None
    ''' Erase / remove paint instead of adding it

    :type: bool
    '''

    use_particle_radius: bool = None
    ''' Use radius from particle settings

    :type: bool
    '''

    use_proximity_project: bool = None
    ''' Brush is projected to canvas from defined direction within brush proximity

    :type: bool
    '''

    use_proximity_ramp_alpha: bool = None
    ''' Only read color ramp alpha

    :type: bool
    '''

    use_smudge: bool = None
    ''' Make this brush to smudge existing paint as it moves

    :type: bool
    '''

    use_velocity_alpha: bool = None
    ''' Multiply brush influence by velocity color ramp alpha

    :type: bool
    '''

    use_velocity_color: bool = None
    ''' Replace brush color by velocity color ramp

    :type: bool
    '''

    use_velocity_depth: bool = None
    ''' Multiply brush intersection depth (displace, waves) by velocity ramp alpha

    :type: bool
    '''

    velocity_max: float = None
    ''' Velocity considered as maximum influence (Blender units per frame)

    :type: float
    '''

    velocity_ramp: 'ColorRamp' = None
    ''' Color ramp used to define brush velocity effect

    :type: 'ColorRamp'
    '''

    wave_clamp: float = None
    ''' Maximum level of surface intersection used to influence waves (use 0.0 to disable)

    :type: float
    '''

    wave_factor: float = None
    ''' Multiplier for wave influence of this brush

    :type: float
    '''

    wave_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''


class DynamicPaintCanvasSettings(bpy_struct):
    ''' Dynamic Paint canvas settings
    '''

    canvas_surfaces: 'DynamicPaintSurfaces' = None
    ''' Paint surface list

    :type: 'DynamicPaintSurfaces'
    '''


class DynamicPaintSurface(bpy_struct):
    ''' A canvas surface layer
    '''

    brush_group: 'Group' = None
    ''' Only use brush objects from this group

    :type: 'Group'
    '''

    brush_influence_scale: float = None
    ''' Adjust influence brush objects have on this surface

    :type: float
    '''

    brush_radius_scale: float = None
    ''' Adjust radius of proximity brushes or particles for this surface

    :type: float
    '''

    color_dry_threshold: float = None
    ''' The wetness level when colors start to shift to the background

    :type: float
    '''

    color_spread_speed: float = None
    ''' How fast colors get mixed within wet paint

    :type: float
    '''

    depth_clamp: float = None
    ''' Maximum level of depth intersection in object space (use 0.0 to disable)

    :type: float
    '''

    displace_factor: float = None
    ''' Strength of displace when applied to the mesh

    :type: float
    '''

    displace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    dissolve_speed: int = None
    ''' Approximately in how many frames should dissolve happen

    :type: int
    '''

    drip_acceleration: float = None
    ''' How much surface acceleration affects dripping

    :type: float
    '''

    drip_velocity: float = None
    ''' How much surface velocity affects dripping

    :type: float
    '''

    dry_speed: int = None
    ''' Approximately in how many frames should drying happen

    :type: int
    '''

    effect_ui: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    frame_end: int = None
    ''' Simulation end frame

    :type: int
    '''

    frame_start: int = None
    ''' Simulation start frame

    :type: int
    '''

    frame_substeps: int = None
    ''' Do extra frames between scene frames to ensure smooth motion

    :type: int
    '''

    image_fileformat: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    image_output_path: typing.Union[str, typing.Any] = None
    ''' Directory to save the textures

    :type: typing.Union[str, typing.Any]
    '''

    image_resolution: int = None
    ''' Output image resolution

    :type: int
    '''

    init_color: bpy_prop_array[float] = None
    ''' Initial color of the surface

    :type: bpy_prop_array[float]
    '''

    init_color_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    init_layername: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    init_texture: 'Texture' = None
    ''' 

    :type: 'Texture'
    '''

    is_active: bool = None
    ''' Toggle whether surface is processed or ignored

    :type: bool
    '''

    is_cache_user: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Surface name

    :type: typing.Union[str, typing.Any]
    '''

    output_name_a: typing.Union[str, typing.Any] = None
    ''' Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    '''

    output_name_b: typing.Union[str, typing.Any] = None
    ''' Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    preview_id: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    show_preview: bool = None
    ''' Display surface preview in 3D-views

    :type: bool
    '''

    shrink_speed: float = None
    ''' How fast shrink effect moves on the canvas surface

    :type: float
    '''

    spread_speed: float = None
    ''' How fast spread effect moves on the canvas surface

    :type: float
    '''

    surface_format: typing.Union[str, int] = None
    ''' Surface Format

    :type: typing.Union[str, int]
    '''

    surface_type: typing.Union[str, int] = None
    ''' Surface Type

    :type: typing.Union[str, int]
    '''

    use_antialiasing: bool = None
    ''' Use 5x multisampling to smooth paint edges

    :type: bool
    '''

    use_color_preview: typing.Union[bool, typing.Any] = None
    ''' Whether this surface has some color preview for 3D view

    :type: typing.Union[bool, typing.Any]
    '''

    use_dissolve: bool = None
    ''' Enable to make surface changes disappear over time

    :type: bool
    '''

    use_dissolve_log: bool = None
    ''' Use logarithmic dissolve (makes high values to fade faster than low values)

    :type: bool
    '''

    use_drip: bool = None
    ''' Process drip effect (drip wet paint to gravity direction)

    :type: bool
    '''

    use_dry_log: bool = None
    ''' Use logarithmic drying (makes high values to dry faster than low values)

    :type: bool
    '''

    use_drying: bool = None
    ''' Enable to make surface wetness dry over time

    :type: bool
    '''

    use_incremental_displace: bool = None
    ''' New displace is added cumulatively on top of existing

    :type: bool
    '''

    use_output_a: bool = None
    ''' Save this output layer

    :type: bool
    '''

    use_output_b: bool = None
    ''' Save this output layer

    :type: bool
    '''

    use_premultiply: bool = None
    ''' Multiply color by alpha (recommended for Blender input)

    :type: bool
    '''

    use_shrink: bool = None
    ''' Process shrink effect (shrink paint areas)

    :type: bool
    '''

    use_spread: bool = None
    ''' Process spread effect (spread wet paint around surface)

    :type: bool
    '''

    use_wave_open_border: bool = None
    ''' Pass waves through mesh edges

    :type: bool
    '''

    uv_layer: typing.Union[str, typing.Any] = None
    ''' UV map name

    :type: typing.Union[str, typing.Any]
    '''

    wave_damping: float = None
    ''' Wave damping factor

    :type: float
    '''

    wave_smoothness: float = None
    ''' Limit maximum steepness of wave slope between simulation points (use higher values for smoother waves at expense of reduced detail)

    :type: float
    '''

    wave_speed: float = None
    ''' Wave propagation speed

    :type: float
    '''

    wave_spring: float = None
    ''' Spring force that pulls water level back to zero

    :type: float
    '''

    wave_timescale: float = None
    ''' Wave time scaling factor

    :type: float
    '''

    def output_exists(self, object: 'Object',
                      index: typing.Optional[int]) -> bool:
        ''' Checks if surface output layer of given name exists

        :param object: 
        :type object: 'Object'
        :param index: Index
        :type index: typing.Optional[int]
        :rtype: bool
        '''
        pass


class EditBone(bpy_struct):
    ''' Editmode bone in an Armature data-block
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveiny: float = None
    ''' Y-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveouty: float = None
    ''' Y-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_in: float = None
    ''' Length of first Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_out: float = None
    ''' Length of second Bezier Handle (for B-Bones only)

    :type: float
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scalein: float = None
    ''' Scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleout: float = None
    ''' Scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_segments: int = None
    ''' Number of subdivisions of bone (for B-Bones only)

    :type: int
    '''

    bbone_x: float = None
    ''' B-Bone X size

    :type: float
    '''

    bbone_z: float = None
    ''' B-Bone Z size

    :type: float
    '''

    envelope_distance: float = None
    ''' Bone deformation distance (for Envelope deform only)

    :type: float
    '''

    envelope_weight: float = None
    ''' Bone deformation weight (for Envelope deform only)

    :type: float
    '''

    head: bpy_prop_array[float] = None
    ''' Location of head end of the bone

    :type: bpy_prop_array[float]
    '''

    head_radius: float = None
    ''' Radius of head of bone (for Envelope deform only)

    :type: float
    '''

    hide: bool = None
    ''' Bone is not visible when in Edit Mode

    :type: bool
    '''

    hide_select: bool = None
    ''' Bone is able to be selected

    :type: bool
    '''

    layers: typing.List[bool] = None
    ''' Layers bone exists in

    :type: typing.List[bool]
    '''

    lock: bool = None
    ''' Bone is not able to be transformed when in Edit Mode

    :type: bool
    '''

    matrix: bpy_prop_array[float] = None
    ''' Matrix combining loc/rot of the bone (head position, direction and roll), in armature space (WARNING: does not include/support bone's length/size)

    :type: bpy_prop_array[float]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    parent: 'EditBone' = None
    ''' Parent edit bone (in same Armature)

    :type: 'EditBone'
    '''

    roll: float = None
    ''' Bone rotation around head-tail axis

    :type: float
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_head: bool = None
    ''' 

    :type: bool
    '''

    select_tail: bool = None
    ''' 

    :type: bool
    '''

    show_wire: bool = None
    ''' Bone is always drawn as Wireframe regardless of viewport draw mode (useful for non-obstructive custom bone shapes)

    :type: bool
    '''

    tail: bpy_prop_array[float] = None
    ''' Location of tail end of the bone

    :type: bpy_prop_array[float]
    '''

    tail_radius: float = None
    ''' Radius of tail of bone (for Envelope deform only)

    :type: float
    '''

    use_connect: bool = None
    ''' When bone has a parent, bone's head is stuck to the parent's tail

    :type: bool
    '''

    use_cyclic_offset: bool = None
    ''' When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    '''

    use_deform: bool = None
    ''' Enable Bone to deform geometry

    :type: bool
    '''

    use_endroll_as_inroll: bool = None
    ''' Use Roll Out of parent bone as Roll In of its children

    :type: bool
    '''

    use_envelope_multiply: bool = None
    ''' When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    '''

    use_inherit_rotation: bool = None
    ''' Bone inherits rotation or scale from parent bone

    :type: bool
    '''

    use_inherit_scale: bool = None
    ''' Bone inherits scaling from parent bone

    :type: bool
    '''

    use_local_location: bool = None
    ''' Bone location is set in local space

    :type: bool
    '''

    use_relative_parent: bool = None
    ''' Object children will use relative transform, like deform

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children = None
    ''' A list of all the bones children. (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    length = None
    ''' The distance from head to tail, when set the head is moved to fit the length.'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def align_roll(self, vector: typing.Optional[typing.Iterable[float]]):
        ''' Align the bone to a localspace roll so the Z axis points in the direction of the vector given

        :param vector: Vector
        :type vector: typing.Optional[typing.Iterable[float]]
        '''
        pass

    def align_orientation(self, other):
        ''' Align this bone to another by moving its tail and settings its roll the length of the other bone is not used.

        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def transform(
            self,
            matrix: typing.Optional[
                typing.Union[typing.Sequence[float], 'mathutils.Matrix']],
            scale: typing.Optional[bool] = True,
            roll: typing.Optional[bool] = True):
        ''' Transform the the bones head, tail, roll and envelope (when the matrix has a scale component).

        :param matrix: 3x3 or 4x4 transformation matrix.
        :type matrix: typing.Optional[typing.Union[typing.Sequence[float], 'mathutils.Matrix']]
        :param scale: Scale the bone envelope by the matrix.
        :type scale: typing.Optional[bool]
        :param roll: Correct the roll to point in the same relative direction to the head and tail.
        :type roll: typing.Optional[bool]
        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass


class EffectorWeights(bpy_struct):
    ''' Effector weights for physics simulation
    '''

    all: float = None
    ''' All effector's weight

    :type: float
    '''

    apply_to_hair_growing: bool = None
    ''' Use force fields when growing hair

    :type: bool
    '''

    boid: float = None
    ''' Boid effector weight

    :type: float
    '''

    charge: float = None
    ''' Charge effector weight

    :type: float
    '''

    curve_guide: float = None
    ''' Curve guide effector weight

    :type: float
    '''

    drag: float = None
    ''' Drag effector weight

    :type: float
    '''

    force: float = None
    ''' Force effector weight

    :type: float
    '''

    gravity: float = None
    ''' Global gravity weight

    :type: float
    '''

    group: 'Group' = None
    ''' Limit effectors to this Group

    :type: 'Group'
    '''

    harmonic: float = None
    ''' Harmonic effector weight

    :type: float
    '''

    lennardjones: float = None
    ''' Lennard-Jones effector weight

    :type: float
    '''

    magnetic: float = None
    ''' Magnetic effector weight

    :type: float
    '''

    smokeflow: float = None
    ''' Smoke Flow effector weight

    :type: float
    '''

    texture: float = None
    ''' Texture effector weight

    :type: float
    '''

    turbulence: float = None
    ''' Turbulence effector weight

    :type: float
    '''

    vortex: float = None
    ''' Vortex effector weight

    :type: float
    '''

    wind: float = None
    ''' Wind effector weight

    :type: float
    '''


class EnumPropertyItem(bpy_struct):
    ''' Definition of a choice in an RNA enum property
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Description of the item's purpose

    :type: typing.Union[str, typing.Any]
    '''

    icon: typing.Union[str, int] = None
    ''' Icon of the item

    :type: typing.Union[str, int]
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Human readable name

    :type: typing.Union[str, typing.Any]
    '''

    value: int = None
    ''' Value of the item

    :type: int
    '''


class EnvironmentMap(bpy_struct):
    ''' Environment map created by the renderer and cached for subsequent renders
    '''

    clip_end: float = None
    ''' Objects further than this are not visible to map

    :type: float
    '''

    clip_start: float = None
    ''' Objects nearer than this are not visible to map

    :type: float
    '''

    depth: int = None
    ''' Number of times a map will be rendered recursively (mirror effects)

    :type: int
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' True if this map is ready for use, False if it needs rendering

    :type: typing.Union[bool, typing.Any]
    '''

    layers_ignore: typing.List[bool] = None
    ''' Hide objects on these layers when generating the Environment Map

    :type: typing.List[bool]
    '''

    mapping: typing.Union[str, int] = None
    ''' * ``CUBE`` Cube, Use environment map with six cube sides. * ``PLANE`` Plane, Only one side is rendered, with Z axis pointing in direction of image.

    :type: typing.Union[str, int]
    '''

    resolution: int = None
    ''' Pixel resolution of the rendered environment map

    :type: int
    '''

    source: typing.Union[str, int] = None
    ''' * ``STATIC`` Static, Calculate environment map only once. * ``ANIMATED`` Animated, Calculate environment map at each rendering. * ``IMAGE_FILE`` Image File, Load a saved environment map image from disk.

    :type: typing.Union[str, int]
    '''

    viewpoint_object: 'Object' = None
    ''' Object to use as the environment map's viewpoint location

    :type: 'Object'
    '''

    zoom: float = None
    ''' 

    :type: float
    '''

    def clear(self):
        ''' Discard the environment map and free it from memory

        '''
        pass

    def save(self,
             filepath: typing.Union[str, typing.Any],
             scene: typing.Optional['Scene'] = None,
             layout: typing.Optional[typing.Any] = (0.0, 0.0, 1.0, 0.0, 2.0,
                                                    0.0, 0.0, 1.0, 1.0, 1.0,
                                                    2.0, 1.0)):
        ''' Save the environment map to disc using the scene render settings

        :param filepath: File path, Location of the output file
        :type filepath: typing.Union[str, typing.Any]
        :param scene: Overrides the scene from which image parameters are taken
        :type scene: typing.Optional['Scene']
        :param layout: File layout, Flat array describing the X,Y position of each cube face in the output image, where 1 is the size of a face - order is [+Z -Z +Y -X -Y +X] (use -1 to skip a face)
        :type layout: typing.Optional[typing.Any]
        '''
        pass


class Event(bpy_struct):
    ''' Window Manager Event
    '''

    alt: typing.Union[bool, typing.Any] = None
    ''' True when the Alt/Option key is held

    :type: typing.Union[bool, typing.Any]
    '''

    ascii: typing.Union[str, typing.Any] = None
    ''' Single ASCII character for this event

    :type: typing.Union[str, typing.Any]
    '''

    ctrl: typing.Union[bool, typing.Any] = None
    ''' True when the Ctrl key is held

    :type: typing.Union[bool, typing.Any]
    '''

    is_tablet: typing.Union[bool, typing.Any] = None
    ''' The pressure of the tablet or 1.0 if no tablet present

    :type: typing.Union[bool, typing.Any]
    '''

    mouse_prev_x: int = None
    ''' The window relative horizontal location of the mouse

    :type: int
    '''

    mouse_prev_y: int = None
    ''' The window relative vertical location of the mouse

    :type: int
    '''

    mouse_region_x: int = None
    ''' The region relative horizontal location of the mouse

    :type: int
    '''

    mouse_region_y: int = None
    ''' The region relative vertical location of the mouse

    :type: int
    '''

    mouse_x: int = None
    ''' The window relative horizontal location of the mouse

    :type: int
    '''

    mouse_y: int = None
    ''' The window relative vertical location of the mouse

    :type: int
    '''

    oskey: typing.Union[bool, typing.Any] = None
    ''' True when the Cmd key is held

    :type: typing.Union[bool, typing.Any]
    '''

    pressure: float = None
    ''' The pressure of the tablet or 1.0 if no tablet present

    :type: float
    '''

    shift: typing.Union[bool, typing.Any] = None
    ''' True when the Shift key is held

    :type: typing.Union[bool, typing.Any]
    '''

    tilt: bpy_prop_array[float] = None
    ''' The pressure of the tablet or zeroes if no tablet present

    :type: bpy_prop_array[float]
    '''

    type: typing.Union[str, int] = None
    ''' * ``NONE`` . * ``LEFTMOUSE`` Left Mouse, LMB. * ``MIDDLEMOUSE`` Middle Mouse, MMB. * ``RIGHTMOUSE`` Right Mouse, RMB. * ``BUTTON4MOUSE`` Button4 Mouse, MB4. * ``BUTTON5MOUSE`` Button5 Mouse, MB5. * ``BUTTON6MOUSE`` Button6 Mouse, MB6. * ``BUTTON7MOUSE`` Button7 Mouse, MB7. * ``ACTIONMOUSE`` Action Mouse, MBA. * ``SELECTMOUSE`` Select Mouse, MBS. * ``PEN`` Pen. * ``ERASER`` Eraser. * ``MOUSEMOVE`` Mouse Move, MsMov. * ``INBETWEEN_MOUSEMOVE`` In-between Move, MsSubMov. * ``TRACKPADPAN`` Mouse/Trackpad Pan, MsPan. * ``TRACKPADZOOM`` Mouse/Trackpad Zoom, MsZoom. * ``MOUSEROTATE`` Mouse/Trackpad Rotate, MsRot. * ``WHEELUPMOUSE`` Wheel Up, WhUp. * ``WHEELDOWNMOUSE`` Wheel Down, WhDown. * ``WHEELINMOUSE`` Wheel In, WhIn. * ``WHEELOUTMOUSE`` Wheel Out, WhOut. * ``EVT_TWEAK_L`` Tweak Left, TwkL. * ``EVT_TWEAK_M`` Tweak Middle, TwkM. * ``EVT_TWEAK_R`` Tweak Right, TwkR. * ``EVT_TWEAK_A`` Tweak Action, TwkA. * ``EVT_TWEAK_S`` Tweak Select, TwkS. * ``A`` A. * ``B`` B. * ``C`` C. * ``D`` D. * ``E`` E. * ``F`` F. * ``G`` G. * ``H`` H. * ``I`` I. * ``J`` J. * ``K`` K. * ``L`` L. * ``M`` M. * ``N`` N. * ``O`` O. * ``P`` P. * ``Q`` Q. * ``R`` R. * ``S`` S. * ``T`` T. * ``U`` U. * ``V`` V. * ``W`` W. * ``X`` X. * ``Y`` Y. * ``Z`` Z. * ``ZERO`` 0. * ``ONE`` 1. * ``TWO`` 2. * ``THREE`` 3. * ``FOUR`` 4. * ``FIVE`` 5. * ``SIX`` 6. * ``SEVEN`` 7. * ``EIGHT`` 8. * ``NINE`` 9. * ``LEFT_CTRL`` Left Ctrl, CtrlL. * ``LEFT_ALT`` Left Alt, AltL. * ``LEFT_SHIFT`` Left Shift, ShiftL. * ``RIGHT_ALT`` Right Alt, AltR. * ``RIGHT_CTRL`` Right Ctrl, CtrlR. * ``RIGHT_SHIFT`` Right Shift, ShiftR. * ``OSKEY`` OS Key, Cmd. * ``GRLESS`` Grless. * ``ESC`` Esc. * ``TAB`` Tab. * ``RET`` Return, Enter. * ``SPACE`` Spacebar, Space. * ``LINE_FEED`` Line Feed. * ``BACK_SPACE`` Back Space, BkSpace. * ``DEL`` Delete, Del. * ``SEMI_COLON`` ;. * ``PERIOD`` .. * ``COMMA`` ,. * ``QUOTE`` ". * ``ACCENT_GRAVE`` \`. * ``MINUS`` -. * ``PLUS`` +. * ``SLASH`` /. * ``BACK_SLASH`` \\. * ``EQUAL`` =. * ``LEFT_BRACKET`` [. * ``RIGHT_BRACKET`` ]. * ``LEFT_ARROW`` Left Arrow, ←. * ``DOWN_ARROW`` Down Arrow, ↓. * ``RIGHT_ARROW`` Right Arrow, →. * ``UP_ARROW`` Up Arrow, ↑. * ``NUMPAD_2`` Numpad 2, Pad2. * ``NUMPAD_4`` Numpad 4, Pad4. * ``NUMPAD_6`` Numpad 6, Pad6. * ``NUMPAD_8`` Numpad 8, Pad8. * ``NUMPAD_1`` Numpad 1, Pad1. * ``NUMPAD_3`` Numpad 3, Pad3. * ``NUMPAD_5`` Numpad 5, Pad5. * ``NUMPAD_7`` Numpad 7, Pad7. * ``NUMPAD_9`` Numpad 9, Pad9. * ``NUMPAD_PERIOD`` Numpad ., Pad.. * ``NUMPAD_SLASH`` Numpad /, Pad/. * ``NUMPAD_ASTERIX`` Numpad \*, Pad\*. * ``NUMPAD_0`` Numpad 0, Pad0. * ``NUMPAD_MINUS`` Numpad -, Pad-. * ``NUMPAD_ENTER`` Numpad Enter, PadEnter. * ``NUMPAD_PLUS`` Numpad +, Pad+. * ``F1`` F1. * ``F2`` F2. * ``F3`` F3. * ``F4`` F4. * ``F5`` F5. * ``F6`` F6. * ``F7`` F7. * ``F8`` F8. * ``F9`` F9. * ``F10`` F10. * ``F11`` F11. * ``F12`` F12. * ``F13`` F13. * ``F14`` F14. * ``F15`` F15. * ``F16`` F16. * ``F17`` F17. * ``F18`` F18. * ``F19`` F19. * ``PAUSE`` Pause. * ``INSERT`` Insert, Ins. * ``HOME`` Home. * ``PAGE_UP`` Page Up, PgUp. * ``PAGE_DOWN`` Page Down, PgDown. * ``END`` End. * ``MEDIA_PLAY`` Media Play/Pause, >/\|\|. * ``MEDIA_STOP`` Media Stop, Stop. * ``MEDIA_FIRST`` Media First, \|<<. * ``MEDIA_LAST`` Media Last, >>\|. * ``TEXTINPUT`` Text Input, TxtIn. * ``WINDOW_DEACTIVATE`` Window Deactivate. * ``TIMER`` Timer, Tmr. * ``TIMER0`` Timer 0, Tmr0. * ``TIMER1`` Timer 1, Tmr1. * ``TIMER2`` Timer 2, Tmr2. * ``TIMER_JOBS`` Timer Jobs, TmrJob. * ``TIMER_AUTOSAVE`` Timer Autosave, TmrSave. * ``TIMER_REPORT`` Timer Report, TmrReport. * ``TIMERREGION`` Timer Region, TmrReg. * ``NDOF_MOTION`` NDOF Motion, NdofMov. * ``NDOF_BUTTON_MENU`` NDOF Menu, NdofMenu. * ``NDOF_BUTTON_FIT`` NDOF Fit, NdofFit. * ``NDOF_BUTTON_TOP`` NDOF Top, Ndof↑. * ``NDOF_BUTTON_BOTTOM`` NDOF Bottom, Ndof↓. * ``NDOF_BUTTON_LEFT`` NDOF Left, Ndof←. * ``NDOF_BUTTON_RIGHT`` NDOF Right, Ndof→. * ``NDOF_BUTTON_FRONT`` NDOF Front, NdofFront. * ``NDOF_BUTTON_BACK`` NDOF Back, NdofBack. * ``NDOF_BUTTON_ISO1`` NDOF Isometric 1, NdofIso1. * ``NDOF_BUTTON_ISO2`` NDOF Isometric 2, NdofIso2. * ``NDOF_BUTTON_ROLL_CW`` NDOF Roll CW, NdofRCW. * ``NDOF_BUTTON_ROLL_CCW`` NDOF Roll CCW, NdofRCCW. * ``NDOF_BUTTON_SPIN_CW`` NDOF Spin CW, NdofSCW. * ``NDOF_BUTTON_SPIN_CCW`` NDOF Spin CCW, NdofSCCW. * ``NDOF_BUTTON_TILT_CW`` NDOF Tilt CW, NdofTCW. * ``NDOF_BUTTON_TILT_CCW`` NDOF Tilt CCW, NdofTCCW. * ``NDOF_BUTTON_ROTATE`` NDOF Rotate, NdofRot. * ``NDOF_BUTTON_PANZOOM`` NDOF Pan/Zoom, NdofPanZoom. * ``NDOF_BUTTON_DOMINANT`` NDOF Dominant, NdofDom. * ``NDOF_BUTTON_PLUS`` NDOF Plus, Ndof+. * ``NDOF_BUTTON_MINUS`` NDOF Minus, Ndof-. * ``NDOF_BUTTON_ESC`` NDOF Esc, NdofEsc. * ``NDOF_BUTTON_ALT`` NDOF Alt, NdofAlt. * ``NDOF_BUTTON_SHIFT`` NDOF Shift, NdofShift. * ``NDOF_BUTTON_CTRL`` NDOF Ctrl, NdofCtrl. * ``NDOF_BUTTON_1`` NDOF Button 1, NdofB1. * ``NDOF_BUTTON_2`` NDOF Button 2, NdofB2. * ``NDOF_BUTTON_3`` NDOF Button 3, NdofB3. * ``NDOF_BUTTON_4`` NDOF Button 4, NdofB4. * ``NDOF_BUTTON_5`` NDOF Button 5, NdofB5. * ``NDOF_BUTTON_6`` NDOF Button 6, NdofB6. * ``NDOF_BUTTON_7`` NDOF Button 7, NdofB7. * ``NDOF_BUTTON_8`` NDOF Button 8, NdofB8. * ``NDOF_BUTTON_9`` NDOF Button 9, NdofB9. * ``NDOF_BUTTON_10`` NDOF Button 10, NdofB10. * ``NDOF_BUTTON_A`` NDOF Button A, NdofBA. * ``NDOF_BUTTON_B`` NDOF Button B, NdofBB. * ``NDOF_BUTTON_C`` NDOF Button C, NdofBC.

    :type: typing.Union[str, int]
    '''

    unicode: typing.Union[str, typing.Any] = None
    ''' Single unicode character for this event

    :type: typing.Union[str, typing.Any]
    '''

    value: typing.Union[str, int] = None
    ''' The type of event, only applies to some

    :type: typing.Union[str, int]
    '''


class FCurve(bpy_struct):
    ''' F-Curve defining values of a period of time
    '''

    array_index: int = None
    ''' Index to the specific property affected by F-Curve if applicable

    :type: int
    '''

    color: bpy_prop_array[float] = None
    ''' Color of the F-Curve in the Graph Editor

    :type: bpy_prop_array[float]
    '''

    color_mode: typing.Union[str, int] = None
    ''' Method used to determine color of F-Curve in Graph Editor * ``AUTO_RAINBOW`` Auto Rainbow, Cycle through the rainbow, trying to give each curve a unique color. * ``AUTO_RGB`` Auto XYZ to RGB, Use axis colors for transform and color properties, and auto-rainbow for the rest. * ``AUTO_YRGB`` Auto WXYZ to YRGB, Use axis colors for XYZ parts of transform, and yellow for the 'W' channel. * ``CUSTOM`` User Defined, Use custom hand-picked color for F-Curve.

    :type: typing.Union[str, int]
    '''

    data_path: typing.Union[str, typing.Any] = None
    ''' RNA Path to property affected by F-Curve

    :type: typing.Union[str, typing.Any]
    '''

    driver: 'Driver' = None
    ''' Channel Driver (only set for Driver F-Curves)

    :type: 'Driver'
    '''

    extrapolation: typing.Union[str, int] = None
    ''' Method used for evaluating value of F-Curve outside first and last keyframes * ``CONSTANT`` Constant, Hold values of endpoint keyframes. * ``LINEAR`` Linear, Use slope of curve leading in/out of endpoint keyframes.

    :type: typing.Union[str, int]
    '''

    group: 'ActionGroup' = None
    ''' Action Group that this F-Curve belongs to

    :type: 'ActionGroup'
    '''

    hide: bool = None
    ''' F-Curve and its keyframes are hidden in the Graph Editor graphs

    :type: bool
    '''

    is_valid: bool = None
    ''' False when F-Curve could not be evaluated in past, so should be skipped when evaluating

    :type: bool
    '''

    keyframe_points: 'FCurveKeyframePoints' = None
    ''' User-editable keyframes

    :type: 'FCurveKeyframePoints'
    '''

    lock: bool = None
    ''' F-Curve's settings cannot be edited

    :type: bool
    '''

    modifiers: 'FCurveModifiers' = None
    ''' Modifiers affecting the shape of the F-Curve

    :type: 'FCurveModifiers'
    '''

    mute: bool = None
    ''' F-Curve is not evaluated

    :type: bool
    '''

    sampled_points: bpy_prop_collection['FCurveSample'] = None
    ''' Sampled animation data

    :type: bpy_prop_collection['FCurveSample']
    '''

    select: bool = None
    ''' F-Curve is selected for editing

    :type: bool
    '''

    def evaluate(self, frame: typing.Optional[float]) -> float:
        ''' Evaluate F-Curve

        :param frame: Frame, Evaluate F-Curve at given frame
        :type frame: typing.Optional[float]
        :rtype: float
        :return: Value, Value of F-Curve specific frame
        '''
        pass

    def update(self):
        ''' Ensure keyframes are sorted in chronological order and handles are set correctly

        '''
        pass

    def range(self) -> bpy_prop_array[float]:
        ''' Get the time extents for F-Curve

        :rtype: bpy_prop_array[float]
        :return: Range, Min/Max values
        '''
        pass

    def update_autoflags(self, data: typing.Any):
        ''' Update FCurve flags set automatically from affected property (currently, integer/discrete flags set when the property is not a float)

        :param data: Data, Data containing the property controlled by given FCurve
        :type data: typing.Any
        '''
        pass

    def convert_to_samples(self, start: typing.Optional[int],
                           end: typing.Optional[int]):
        ''' Convert current FCurve from keyframes to sample points, if necessary

        :param start: Start Frame
        :type start: typing.Optional[int]
        :param end: End Frame
        :type end: typing.Optional[int]
        '''
        pass

    def convert_to_keyframes(self, start: typing.Optional[int],
                             end: typing.Optional[int]):
        ''' Convert current FCurve from sample points to keyframes (linear interpolation), if necessary

        :param start: Start Frame
        :type start: typing.Optional[int]
        :param end: End Frame
        :type end: typing.Optional[int]
        '''
        pass


class FCurveSample(bpy_struct):
    ''' Sample point for F-Curve
    '''

    co: bpy_prop_array[float] = None
    ''' Point coordinates

    :type: bpy_prop_array[float]
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''


class FFmpegSettings(bpy_struct):
    ''' FFmpeg related settings for the scene
    '''

    audio_bitrate: int = None
    ''' Audio bitrate (kb/s)

    :type: int
    '''

    audio_channels: typing.Union[str, int] = None
    ''' Audio channel count * ``MONO`` Mono, Set audio channels to mono. * ``STEREO`` Stereo, Set audio channels to stereo. * ``SURROUND4`` 4 Channels, Set audio channels to 4 channels. * ``SURROUND51`` 5.1 Surround, Set audio channels to 5.1 surround sound. * ``SURROUND71`` 7.1 Surround, Set audio channels to 7.1 surround sound.

    :type: typing.Union[str, int]
    '''

    audio_codec: typing.Union[str, int] = None
    ''' FFmpeg audio codec to use

    :type: typing.Union[str, int]
    '''

    audio_mixrate: int = None
    ''' Audio samplerate(samples/s)

    :type: int
    '''

    audio_volume: float = None
    ''' Audio volume

    :type: float
    '''

    buffersize: int = None
    ''' Rate control: buffer size (kb)

    :type: int
    '''

    codec: typing.Union[str, int] = None
    ''' FFmpeg codec to use

    :type: typing.Union[str, int]
    '''

    format: typing.Union[str, int] = None
    ''' Output file format

    :type: typing.Union[str, int]
    '''

    gopsize: int = None
    ''' Distance between key frames

    :type: int
    '''

    maxrate: int = None
    ''' Rate control: max rate (kb/s)

    :type: int
    '''

    minrate: int = None
    ''' Rate control: min rate (kb/s)

    :type: int
    '''

    muxrate: int = None
    ''' Mux rate (bits/s(!))

    :type: int
    '''

    packetsize: int = None
    ''' Mux packet size (byte)

    :type: int
    '''

    use_autosplit: bool = None
    ''' Autosplit output at 2GB boundary

    :type: bool
    '''

    use_lossless_output: bool = None
    ''' Use lossless output for video streams

    :type: bool
    '''

    video_bitrate: int = None
    ''' Video bitrate (kb/s)

    :type: int
    '''


class FModifier(bpy_struct):
    ''' Modifier for values of F-Curve
    '''

    active: bool = None
    ''' F-Curve Modifier is the one being edited

    :type: bool
    '''

    blend_in: float = None
    ''' Number of frames from start frame for influence to take effect

    :type: float
    '''

    blend_out: float = None
    ''' Number of frames from end frame for influence to fade out

    :type: float
    '''

    frame_end: float = None
    ''' Frame that modifier's influence ends (if Restrict Frame Range is in use)

    :type: float
    '''

    frame_start: float = None
    ''' Frame that modifier's influence starts (if Restrict Frame Range is in use)

    :type: float
    '''

    influence: float = None
    ''' Amount of influence F-Curve Modifier will have when not fading in/out

    :type: float
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' F-Curve Modifier has invalid settings and will not be evaluated

    :type: typing.Union[bool, typing.Any]
    '''

    mute: bool = None
    ''' F-Curve Modifier will not be evaluated

    :type: bool
    '''

    show_expanded: bool = None
    ''' F-Curve Modifier's panel is expanded in UI

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' F-Curve Modifier Type * ``NULL`` Invalid. * ``GENERATOR`` Generator, Generate a curve using a factorized or expanded polynomial. * ``FNGENERATOR`` Built-In Function, Generate a curve using standard math functions such as sin and cos. * ``ENVELOPE`` Envelope, Reshape F-Curve values - e.g. change amplitude of movements. * ``CYCLES`` Cycles, Cyclic extend/repeat keyframe sequence. * ``NOISE`` Noise, Add pseudo-random noise on top of F-Curves. * ``LIMITS`` Limits, Restrict maximum and minimum values of F-Curve. * ``STEPPED`` Stepped Interpolation, Snap values to nearest grid-step - e.g. for a stop-motion look.

    :type: typing.Union[str, int]
    '''

    use_influence: bool = None
    ''' F-Curve Modifier's effects will be tempered by a default factor

    :type: bool
    '''

    use_restricted_range: bool = None
    ''' F-Curve Modifier is only applied for the specified frame range to help mask off effects in order to chain them

    :type: bool
    '''


class FModifierEnvelopeControlPoint(bpy_struct):
    ''' Control point for envelope F-Modifier
    '''

    frame: float = None
    ''' Frame this control-point occurs on

    :type: float
    '''

    max: float = None
    ''' Upper bound of envelope at this control-point

    :type: float
    '''

    min: float = None
    ''' Lower bound of envelope at this control-point

    :type: float
    '''


class FieldSettings(bpy_struct):
    ''' Field settings for an object in physics simulation
    '''

    apply_to_location: bool = None
    ''' Effect particles' location

    :type: bool
    '''

    apply_to_rotation: bool = None
    ''' Effect particles' dynamic rotation

    :type: bool
    '''

    distance_max: float = None
    ''' Maximum distance for the field to work

    :type: float
    '''

    distance_min: float = None
    ''' Minimum distance for the field's fall-off

    :type: float
    '''

    falloff_power: float = None
    ''' Falloff power (real gravitational falloff = 2)

    :type: float
    '''

    falloff_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    flow: float = None
    ''' Convert effector force into air flow velocity

    :type: float
    '''

    guide_clump_amount: float = None
    ''' Amount of clumping

    :type: float
    '''

    guide_clump_shape: float = None
    ''' Shape of clumping

    :type: float
    '''

    guide_free: float = None
    ''' Guide-free time from particle life's end

    :type: float
    '''

    guide_kink_amplitude: float = None
    ''' The amplitude of the offset

    :type: float
    '''

    guide_kink_axis: typing.Union[str, int] = None
    ''' Which axis to use for offset

    :type: typing.Union[str, int]
    '''

    guide_kink_frequency: float = None
    ''' The frequency of the offset (1/total length)

    :type: float
    '''

    guide_kink_shape: float = None
    ''' Adjust the offset to the beginning/end

    :type: float
    '''

    guide_kink_type: typing.Union[str, int] = None
    ''' Type of periodic offset on the curve

    :type: typing.Union[str, int]
    '''

    guide_minimum: float = None
    ''' The distance from which particles are affected fully

    :type: float
    '''

    harmonic_damping: float = None
    ''' Damping of the harmonic force

    :type: float
    '''

    inflow: float = None
    ''' Inwards component of the vortex force

    :type: float
    '''

    linear_drag: float = None
    ''' Drag component proportional to velocity

    :type: float
    '''

    noise: float = None
    ''' Amount of noise for the force strength

    :type: float
    '''

    quadratic_drag: float = None
    ''' Drag component proportional to the square of velocity

    :type: float
    '''

    radial_falloff: float = None
    ''' Radial falloff power (real gravitational falloff = 2)

    :type: float
    '''

    radial_max: float = None
    ''' Maximum radial distance for the field to work

    :type: float
    '''

    radial_min: float = None
    ''' Minimum radial distance for the field's fall-off

    :type: float
    '''

    rest_length: float = None
    ''' Rest length of the harmonic force

    :type: float
    '''

    seed: int = None
    ''' Seed of the noise

    :type: int
    '''

    shape: typing.Union[str, int] = None
    ''' Which direction is used to calculate the effector force

    :type: typing.Union[str, int]
    '''

    size: float = None
    ''' Size of the turbulence

    :type: float
    '''

    source_object: 'Object' = None
    ''' Select domain object of the smoke simulation

    :type: 'Object'
    '''

    strength: float = None
    ''' Strength of force field

    :type: float
    '''

    texture: 'Texture' = None
    ''' Texture to use as force

    :type: 'Texture'
    '''

    texture_mode: typing.Union[str, int] = None
    ''' How the texture effect is calculated (RGB & Curl need a RGB texture, else Gradient will be used instead)

    :type: typing.Union[str, int]
    '''

    texture_nabla: float = None
    ''' Defines size of derivative offset used for calculating gradient and curl

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Type of field * ``NONE`` None. * ``FORCE`` Force, Radial field toward the center of object. * ``WIND`` Wind, Constant force along the force object's local Z axis. * ``VORTEX`` Vortex, Spiraling force that twists the force object's local Z axis. * ``MAGNET`` Magnetic, Forcefield depends on the speed of the particles. * ``HARMONIC`` Harmonic, The source of this force field is the zero point of a harmonic oscillator. * ``CHARGE`` Charge, Spherical forcefield based on the charge of particles, only influences other charge force fields. * ``LENNARDJ`` Lennard-Jones, Forcefield based on the Lennard-Jones potential. * ``TEXTURE`` Texture, Forcefield based on a texture. * ``GUIDE`` Curve Guide, Create a force along a curve object. * ``BOID`` Boid. * ``TURBULENCE`` Turbulence, Create turbulence with a noise field. * ``DRAG`` Drag, Create a force that dampens motion. * ``SMOKE_FLOW`` Smoke Flow, Create a force based on smoke simulation air flow.

    :type: typing.Union[str, int]
    '''

    use_2d_force: bool = None
    ''' Apply force only in 2D

    :type: bool
    '''

    use_absorption: bool = None
    ''' Force gets absorbed by collision objects

    :type: bool
    '''

    use_global_coords: bool = None
    ''' Use effector/global coordinates for turbulence

    :type: bool
    '''

    use_guide_path_add: bool = None
    ''' Based on distance/falloff it adds a portion of the entire path

    :type: bool
    '''

    use_guide_path_weight: bool = None
    ''' Use curve weights to influence the particle influence along the curve

    :type: bool
    '''

    use_max_distance: bool = None
    ''' Use a maximum distance for the field to work

    :type: bool
    '''

    use_min_distance: bool = None
    ''' Use a minimum distance for the field's fall-off

    :type: bool
    '''

    use_multiple_springs: bool = None
    ''' Every point is effected by multiple springs

    :type: bool
    '''

    use_object_coords: bool = None
    ''' Use object/global coordinates for texture

    :type: bool
    '''

    use_radial_max: bool = None
    ''' Use a maximum radial distance for the field to work

    :type: bool
    '''

    use_radial_min: bool = None
    ''' Use a minimum radial distance for the field's fall-off

    :type: bool
    '''

    use_root_coords: bool = None
    ''' Texture coordinates from root particle locations

    :type: bool
    '''

    use_smoke_density: bool = None
    ''' Adjust force strength based on smoke density

    :type: bool
    '''

    z_direction: typing.Union[str, int] = None
    ''' Effect in full or only positive/negative Z direction

    :type: typing.Union[str, int]
    '''


class FileBrowserFSMenuEntry(bpy_struct):
    ''' File Select Parameters
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' Whether this path is currently reachable

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    path: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    use_save: typing.Union[bool, typing.Any] = None
    ''' Whether this path is saved in bookmarks, or generated from OS

    :type: typing.Union[bool, typing.Any]
    '''


class FileSelectParams(bpy_struct):
    ''' File Select Parameters
    '''

    directory: typing.Union[str, typing.Any] = None
    ''' Directory displayed in the file browser

    :type: typing.Union[str, typing.Any]
    '''

    display_size: typing.Union[str, int] = None
    ''' Change the size of the display (width of columns or thumbnails size)

    :type: typing.Union[str, int]
    '''

    display_type: typing.Union[str, int] = None
    ''' Display mode for the file list * ``LIST_SHORT`` Short List, Display files as short list. * ``LIST_LONG`` Long List, Display files as a detailed list. * ``THUMBNAIL`` Thumbnails, Display files as thumbnails.

    :type: typing.Union[str, int]
    '''

    filename: typing.Union[str, typing.Any] = None
    ''' Active file in the file browser

    :type: typing.Union[str, typing.Any]
    '''

    filter_glob: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    filter_id: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Which ID types to show/hide, when browsing a library * ``ACTION`` Actions, Show/hide Action data-blocks. * ``ARMATURE`` Armatures, Show/hide Armature data-blocks. * ``BRUSH`` Brushes, Show/hide Brushes data-blocks. * ``CAMERA`` Cameras, Show/hide Camera data-blocks. * ``CACHEFILE`` Cache Files, Show/hide Cache File data-blocks. * ``CURVE`` Curves, Show/hide Curve data-blocks. * ``GREASE_PENCIL`` Grease Pencil, Show/hide Grease pencil data-blocks. * ``GROUP`` Groups, Show/hide Group data-blocks. * ``IMAGE`` Images, Show/hide Image data-blocks. * ``LAMP`` Lamps, Show/hide Lamp data-blocks. * ``LINESTYLE`` Freestyle Linestyles, Show/hide Freestyle's Line Style data-blocks. * ``LATTICE`` Lattices, Show/hide Lattice data-blocks. * ``MATERIAL`` Materials, Show/hide Material data-blocks. * ``METABALL`` Metaballs, Show/hide Metaball data-blocks. * ``MOVIE_CLIP`` Movie Clips, Show/hide Movie Clip data-blocks. * ``MESH`` Meshes, Show/hide Mesh data-blocks. * ``MASK`` Masks, Show/hide Mask data-blocks. * ``NODE_TREE`` Node Trees, Show/hide Node Tree data-blocks. * ``OBJECT`` Objects, Show/hide Object data-blocks. * ``PARTICLE_SETTINGS`` Particles Settings, Show/hide Particle Settings data-blocks. * ``PALETTE`` Palettes, Show/hide Palette data-blocks. * ``PAINT_CURVE`` Paint Curves, Show/hide Paint Curve data-blocks. * ``SCENE`` Scenes, Show/hide Scene data-blocks. * ``SPEAKER`` Speakers, Show/hide Speaker data-blocks. * ``SOUND`` Sounds, Show/hide Sound data-blocks. * ``TEXTURE`` Textures, Show/hide Texture data-blocks. * ``TEXT`` Texts, Show/hide Text data-blocks. * ``FONT`` Fonts, Show/hide Font data-blocks. * ``WORLD`` Worlds, Show/hide World data-blocks.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    filter_id_category: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Which ID categories to show/hide, when browsing a library * ``SCENE`` Scenes, Show/hide scenes. * ``ANIMATION`` Animations, Show/hide animation data. * ``OBJECT`` Objects & Groups, Show/hide objects and groups. * ``GEOMETRY`` Geometry, Show/hide meshes, curves, lattice, armatures and metaballs data. * ``SHADING`` Shading, Show/hide materials, nodetrees, textures and Freestyle's linestyles. * ``IMAGE`` Images & Sounds, Show/hide images, movie clips, sounds and masks. * ``ENVIRONMENT`` Environment, Show/hide worlds, lamps, cameras and speakers. * ``MISC`` Miscellaneous, Show/hide other data types.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    filter_search: typing.Union[str, typing.Any] = None
    ''' Filter by name, supports '*' wildcard

    :type: typing.Union[str, typing.Any]
    '''

    recursion_level: typing.Union[str, int] = None
    ''' Numbers of dirtree levels to show simultaneously * ``NONE`` None, Only list current directory's content, with no recursion. * ``BLEND`` Blend File, List .blend files' content. * ``ALL_1`` One Level, List all sub-directories' content, one level of recursion. * ``ALL_2`` Two Levels, List all sub-directories' content, two levels of recursion. * ``ALL_3`` Three Levels, List all sub-directories' content, three levels of recursion.

    :type: typing.Union[str, int]
    '''

    show_hidden: bool = None
    ''' Show hidden dot files

    :type: bool
    '''

    sort_method: typing.Union[str, int] = None
    ''' * ``FILE_SORT_ALPHA`` Sort alphabetically, Sort the file list alphabetically. * ``FILE_SORT_EXTENSION`` Sort by extension, Sort the file list by extension/type. * ``FILE_SORT_TIME`` Sort by time, Sort files by modification time. * ``FILE_SORT_SIZE`` Sort by size, Sort files by size.

    :type: typing.Union[str, int]
    '''

    title: typing.Union[str, typing.Any] = None
    ''' Title for the file browser

    :type: typing.Union[str, typing.Any]
    '''

    use_filter: bool = None
    ''' Enable filtering of files

    :type: bool
    '''

    use_filter_backup: bool = None
    ''' Show .blend1, .blend2, etc. files

    :type: bool
    '''

    use_filter_blender: bool = None
    ''' Show .blend files

    :type: bool
    '''

    use_filter_blendid: bool = None
    ''' Show .blend files items (objects, materials, etc.)

    :type: bool
    '''

    use_filter_folder: bool = None
    ''' Show folders

    :type: bool
    '''

    use_filter_font: bool = None
    ''' Show font files

    :type: bool
    '''

    use_filter_image: bool = None
    ''' Show image files

    :type: bool
    '''

    use_filter_movie: bool = None
    ''' Show movie files

    :type: bool
    '''

    use_filter_script: bool = None
    ''' Show script files

    :type: bool
    '''

    use_filter_sound: bool = None
    ''' Show sound files

    :type: bool
    '''

    use_filter_text: bool = None
    ''' Show text files

    :type: bool
    '''

    use_library_browsing: typing.Union[bool, typing.Any] = None
    ''' Whether we may browse blender files' content or not

    :type: typing.Union[bool, typing.Any]
    '''


class FluidSettings(bpy_struct):
    ''' Fluid simulation settings for an object taking part in the simulation
    '''

    type: typing.Union[str, int] = None
    ''' Type of participation in the fluid simulation * ``NONE`` None. * ``DOMAIN`` Domain, Bounding box of this object represents the computational domain of the fluid simulation. * ``FLUID`` Fluid, Object represents a volume of fluid in the simulation. * ``OBSTACLE`` Obstacle, Object is a fixed obstacle. * ``INFLOW`` Inflow, Object adds fluid to the simulation. * ``OUTFLOW`` Outflow, Object removes fluid from the simulation. * ``PARTICLE`` Particle, Object is made a particle system to display particles generated by a fluidsim domain object. * ``CONTROL`` Control, Object is made a fluid control mesh, which influences the fluid.

    :type: typing.Union[str, int]
    '''


class FluidVertexVelocity(bpy_struct):
    ''' Velocity of a simulated fluid mesh
    '''

    velocity: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class FreestyleLineSet(bpy_struct):
    ''' Line set for associating lines and style parameters
    '''

    edge_type_combination: typing.Union[str, int] = None
    ''' Specify a logical combination of selection conditions on feature edge types * ``OR`` Logical OR, Select feature edges satisfying at least one of edge type conditions. * ``AND`` Logical AND, Select feature edges satisfying all edge type conditions.

    :type: typing.Union[str, int]
    '''

    edge_type_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges selected by edge types * ``INCLUSIVE`` Inclusive, Select feature edges satisfying the given edge type conditions. * ``EXCLUSIVE`` Exclusive, Select feature edges not satisfying the given edge type conditions.

    :type: typing.Union[str, int]
    '''

    exclude_border: bool = None
    ''' Exclude border edges

    :type: bool
    '''

    exclude_contour: bool = None
    ''' Exclude contours

    :type: bool
    '''

    exclude_crease: bool = None
    ''' Exclude crease edges

    :type: bool
    '''

    exclude_edge_mark: bool = None
    ''' Exclude edge marks

    :type: bool
    '''

    exclude_external_contour: bool = None
    ''' Exclude external contours

    :type: bool
    '''

    exclude_material_boundary: bool = None
    ''' Exclude edges at material boundaries

    :type: bool
    '''

    exclude_ridge_valley: bool = None
    ''' Exclude ridges and valleys

    :type: bool
    '''

    exclude_silhouette: bool = None
    ''' Exclude silhouette edges

    :type: bool
    '''

    exclude_suggestive_contour: bool = None
    ''' Exclude suggestive contours

    :type: bool
    '''

    face_mark_condition: typing.Union[str, int] = None
    ''' Specify a feature edge selection condition based on face marks * ``ONE`` One Face, Select a feature edge if either of its adjacent faces is marked. * ``BOTH`` Both Faces, Select a feature edge if both of its adjacent faces are marked.

    :type: typing.Union[str, int]
    '''

    face_mark_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges selected by face marks * ``INCLUSIVE`` Inclusive, Select feature edges satisfying the given face mark conditions. * ``EXCLUSIVE`` Exclusive, Select feature edges not satisfying the given face mark conditions.

    :type: typing.Union[str, int]
    '''

    group: 'Group' = None
    ''' A group of objects based on which feature edges are selected

    :type: 'Group'
    '''

    group_negation: typing.Union[str, int] = None
    ''' Specify either inclusion or exclusion of feature edges belonging to a group of objects * ``INCLUSIVE`` Inclusive, Select feature edges belonging to some object in the group. * ``EXCLUSIVE`` Exclusive, Select feature edges not belonging to any object in the group.

    :type: typing.Union[str, int]
    '''

    linestyle: 'FreestyleLineStyle' = None
    ''' Line style settings

    :type: 'FreestyleLineStyle'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Line set name

    :type: typing.Union[str, typing.Any]
    '''

    qi_end: int = None
    ''' Last QI value of the QI range

    :type: int
    '''

    qi_start: int = None
    ''' First QI value of the QI range

    :type: int
    '''

    select_border: bool = None
    ''' Select border edges (open mesh edges)

    :type: bool
    '''

    select_by_edge_types: bool = None
    ''' Select feature edges based on edge types

    :type: bool
    '''

    select_by_face_marks: bool = None
    ''' Select feature edges by face marks

    :type: bool
    '''

    select_by_group: bool = None
    ''' Select feature edges based on a group of objects

    :type: bool
    '''

    select_by_image_border: bool = None
    ''' Select feature edges by image border (less memory consumption)

    :type: bool
    '''

    select_by_visibility: bool = None
    ''' Select feature edges based on visibility

    :type: bool
    '''

    select_contour: bool = None
    ''' Select contours (outer silhouettes of each object)

    :type: bool
    '''

    select_crease: bool = None
    ''' Select crease edges (those between two faces making an angle smaller than the Crease Angle)

    :type: bool
    '''

    select_edge_mark: bool = None
    ''' Select edge marks (edges annotated by Freestyle edge marks)

    :type: bool
    '''

    select_external_contour: bool = None
    ''' Select external contours (outer silhouettes of occluding and occluded objects)

    :type: bool
    '''

    select_material_boundary: bool = None
    ''' Select edges at material boundaries

    :type: bool
    '''

    select_ridge_valley: bool = None
    ''' Select ridges and valleys (boundary lines between convex and concave areas of surface)

    :type: bool
    '''

    select_silhouette: bool = None
    ''' Select silhouettes (edges at the boundary of visible and hidden faces)

    :type: bool
    '''

    select_suggestive_contour: bool = None
    ''' Select suggestive contours (almost silhouette/contour edges)

    :type: bool
    '''

    show_render: bool = None
    ''' Enable or disable this line set during stroke rendering

    :type: bool
    '''

    visibility: typing.Union[str, int] = None
    ''' Determine how to use visibility for feature edge selection * ``VISIBLE`` Visible, Select visible feature edges. * ``HIDDEN`` Hidden, Select hidden feature edges. * ``RANGE`` QI Range, Select feature edges within a range of quantitative invisibility (QI) values.

    :type: typing.Union[str, int]
    '''


class FreestyleModuleSettings(bpy_struct):
    ''' Style module configuration for specifying a style module
    '''

    script: 'Text' = None
    ''' Python script to define a style module

    :type: 'Text'
    '''

    use: bool = None
    ''' Enable or disable this style module during stroke rendering

    :type: bool
    '''


class FreestyleSettings(bpy_struct):
    ''' Freestyle settings for a SceneRenderLayer data-block
    '''

    crease_angle: float = None
    ''' Angular threshold for detecting crease edges

    :type: float
    '''

    kr_derivative_epsilon: float = None
    ''' Kr derivative epsilon for computing suggestive contours

    :type: float
    '''

    linesets: 'Linesets' = None
    ''' 

    :type: 'Linesets'
    '''

    mode: typing.Union[str, int] = None
    ''' Select the Freestyle control mode * ``SCRIPT`` Python Scripting Mode, Advanced mode for using style modules written in Python. * ``EDITOR`` Parameter Editor Mode, Basic mode for interactive style parameter editing.

    :type: typing.Union[str, int]
    '''

    modules: 'FreestyleModules' = None
    ''' A list of style modules (to be applied from top to bottom)

    :type: 'FreestyleModules'
    '''

    sphere_radius: float = None
    ''' Sphere radius for computing curvatures

    :type: float
    '''

    use_advanced_options: bool = None
    ''' Enable advanced edge detection options (sphere radius and Kr derivative epsilon)

    :type: bool
    '''

    use_culling: bool = None
    ''' If enabled, out-of-view edges are ignored

    :type: bool
    '''

    use_material_boundaries: bool = None
    ''' Enable material boundaries

    :type: bool
    '''

    use_ridges_and_valleys: bool = None
    ''' Enable ridges and valleys

    :type: bool
    '''

    use_smoothness: bool = None
    ''' Take face smoothness into account in view map calculation

    :type: bool
    '''

    use_suggestive_contours: bool = None
    ''' Enable suggestive contours

    :type: bool
    '''

    use_view_map_cache: bool = None
    ''' Keep the computed view map and avoid re-calculating it if mesh geometry is unchanged

    :type: bool
    '''


class Function(bpy_struct):
    ''' RNA function definition
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Description of the Function's purpose

    :type: typing.Union[str, typing.Any]
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    is_registered: typing.Union[bool, typing.Any] = None
    ''' Function is registered as callback as part of type registration

    :type: typing.Union[bool, typing.Any]
    '''

    is_registered_optional: typing.Union[bool, typing.Any] = None
    ''' Function is optionally registered as callback part of type registration

    :type: typing.Union[bool, typing.Any]
    '''

    parameters: bpy_prop_collection['Property'] = None
    ''' Parameters for the function

    :type: bpy_prop_collection['Property']
    '''

    use_self: typing.Union[bool, typing.Any] = None
    ''' Function does not pass its self as an argument (becomes a static method in python)

    :type: typing.Union[bool, typing.Any]
    '''

    use_self_type: typing.Union[bool, typing.Any] = None
    ''' Function passes its self type as an argument (becomes a class method in python if use_self is false)

    :type: typing.Union[bool, typing.Any]
    '''


class GPUDOFSettings(bpy_struct):
    ''' Settings for GPU based depth of field
    '''

    blades: int = None
    ''' Blades for dof effect

    :type: int
    '''

    focal_length: float = None
    ''' Focal length for dof effect

    :type: float
    '''

    focus_distance: float = None
    ''' Viewport depth of field focus distance

    :type: float
    '''

    fstop: float = None
    ''' F-stop for dof effect

    :type: float
    '''

    is_hq_supported: typing.Union[bool, typing.Any] = None
    ''' Use high quality depth of field

    :type: typing.Union[bool, typing.Any]
    '''

    sensor: float = None
    ''' Size of sensor

    :type: float
    '''

    use_high_quality: bool = None
    ''' Use high quality depth of field

    :type: bool
    '''


class GPUFXSettings(bpy_struct):
    ''' Settings for GPU based compositing
    '''

    dof: 'GPUDOFSettings' = None
    ''' 

    :type: 'GPUDOFSettings'
    '''

    ssao: 'GPUSSAOSettings' = None
    ''' 

    :type: 'GPUSSAOSettings'
    '''

    use_dof: bool = None
    ''' Use depth of field on viewport using the values from active camera

    :type: bool
    '''

    use_ssao: bool = None
    ''' Use screen space ambient occlusion of field on viewport

    :type: bool
    '''


class GPUSSAOSettings(bpy_struct):
    ''' Settings for GPU based screen space ambient occlusion
    '''

    attenuation: float = None
    ''' Attenuation constant

    :type: float
    '''

    color: bpy_prop_array[float] = None
    ''' Color for screen space ambient occlusion effect

    :type: bpy_prop_array[float]
    '''

    distance_max: float = None
    ''' Distance of object that contribute to the SSAO effect

    :type: float
    '''

    factor: float = None
    ''' Strength of the SSAO effect

    :type: float
    '''

    samples: int = None
    ''' Number of samples

    :type: int
    '''


class GPencilBrush(bpy_struct):
    ''' Collection of brushes being used to control the line style of new strokes
    '''

    angle: float = None
    ''' Direction of the stroke at which brush gives maximal thickness (0° for horizontal)

    :type: float
    '''

    angle_factor: float = None
    ''' Reduce brush thickness by this factor when stroke is perpendicular to 'Angle' direction

    :type: float
    '''

    curve_jitter: 'CurveMapping' = None
    ''' Curve used for the jitter effect

    :type: 'CurveMapping'
    '''

    curve_sensitivity: 'CurveMapping' = None
    ''' Curve used for the sensitivity

    :type: 'CurveMapping'
    '''

    curve_strength: 'CurveMapping' = None
    ''' Curve used for the strength

    :type: 'CurveMapping'
    '''

    jitter: float = None
    ''' Jitter factor for new strokes

    :type: float
    '''

    line_width: int = None
    ''' Thickness of strokes (in pixels)

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Brush name

    :type: typing.Union[str, typing.Any]
    '''

    pen_sensitivity_factor: float = None
    ''' Pressure sensitivity factor for new strokes

    :type: float
    '''

    pen_smooth_factor: float = None
    ''' Amount of smoothing to apply to newly created strokes, to reduce jitter/noise

    :type: float
    '''

    pen_smooth_steps: int = None
    ''' Number of times to smooth newly created strokes

    :type: int
    '''

    pen_subdivision_steps: int = None
    ''' Number of times to subdivide newly created strokes, for less jagged strokes

    :type: int
    '''

    random_press: float = None
    ''' Randomness factor for pressure and strength in new strokes

    :type: float
    '''

    random_subdiv: float = None
    ''' Randomness factor for new strokes after subdivision

    :type: float
    '''

    strength: float = None
    ''' Color strength for new strokes (affect alpha factor of color)

    :type: float
    '''

    use_jitter_pressure: bool = None
    ''' Use tablet pressure for jitter

    :type: bool
    '''

    use_pressure: bool = None
    ''' Use tablet pressure

    :type: bool
    '''

    use_random_pressure: bool = None
    ''' Use random value for pressure

    :type: bool
    '''

    use_random_strength: bool = None
    ''' Use random value for strength

    :type: bool
    '''

    use_strength_pressure: bool = None
    ''' Use tablet pressure for color strength

    :type: bool
    '''


class GPencilFrame(bpy_struct):
    ''' Collection of related sketches on a particular frame
    '''

    frame_number: int = None
    ''' The frame on which this sketch appears

    :type: int
    '''

    is_edited: bool = None
    ''' Frame is being edited (painted on)

    :type: bool
    '''

    select: bool = None
    ''' Frame is selected for editing in the Dope Sheet

    :type: bool
    '''

    strokes: 'GPencilStrokes' = None
    ''' Freehand curves defining the sketch on this frame

    :type: 'GPencilStrokes'
    '''

    def clear(self):
        ''' Remove all the grease pencil frame data

        '''
        pass


class GPencilLayer(bpy_struct):
    ''' Collection of related sketches
    '''

    active_frame: 'GPencilFrame' = None
    ''' Frame currently being displayed for this layer

    :type: 'GPencilFrame'
    '''

    after_color: bpy_prop_array[float] = None
    ''' Base color for ghosts after the active frame

    :type: bpy_prop_array[float]
    '''

    before_color: bpy_prop_array[float] = None
    ''' Base color for ghosts before the active frame

    :type: bpy_prop_array[float]
    '''

    frames: 'GPencilFrames' = None
    ''' Sketches for this layer on different frames

    :type: 'GPencilFrames'
    '''

    ghost_after_range: int = None
    ''' Maximum number of frames to show after current frame (0 = show only the next sketch, -1 = don't show any frames after current)

    :type: int
    '''

    ghost_before_range: int = None
    ''' Maximum number of frames to show before current frame (0 = show only the previous sketch, -1 = don't show any frames before current)

    :type: int
    '''

    hide: bool = None
    ''' Set layer Visibility

    :type: bool
    '''

    info: typing.Union[str, typing.Any] = None
    ''' Layer name

    :type: typing.Union[str, typing.Any]
    '''

    is_parented: typing.Union[bool, typing.Any] = None
    ''' True when the layer parent object is set

    :type: typing.Union[bool, typing.Any]
    '''

    line_change: int = None
    ''' Thickness change to apply to current strokes (in pixels)

    :type: int
    '''

    lock: bool = None
    ''' Protect layer from further editing and/or frame changes

    :type: bool
    '''

    lock_frame: bool = None
    ''' Lock current frame displayed by layer

    :type: bool
    '''

    matrix_inverse: bpy_prop_array[float] = None
    ''' Parent inverse transformation matrix

    :type: bpy_prop_array[float]
    '''

    opacity: float = None
    ''' Layer Opacity

    :type: float
    '''

    parent: 'Object' = None
    ''' Parent Object

    :type: 'Object'
    '''

    parent_bone: typing.Union[str, typing.Any] = None
    ''' Name of parent bone in case of a bone parenting relation

    :type: typing.Union[str, typing.Any]
    '''

    parent_type: typing.Union[str, int] = None
    ''' Type of parent relation * ``OBJECT`` Object, The layer is parented to an object. * ``ARMATURE`` Armature. * ``BONE`` Bone, The layer is parented to a bone.

    :type: typing.Union[str, int]
    '''

    select: bool = None
    ''' Layer is selected for editing in the Dope Sheet

    :type: bool
    '''

    show_points: bool = None
    ''' Draw the points which make up the strokes (for debugging purposes)

    :type: bool
    '''

    show_x_ray: bool = None
    ''' Make the layer draw in front of objects

    :type: bool
    '''

    tint_color: bpy_prop_array[float] = None
    ''' Color for tinting stroke colors

    :type: bpy_prop_array[float]
    '''

    tint_factor: float = None
    ''' Factor of tinting color

    :type: float
    '''

    unlock_color: bool = None
    ''' Unprotect selected colors from further editing and/or frame changes

    :type: bool
    '''

    use_ghost_custom_colors: bool = None
    ''' Use custom colors for ghost frames

    :type: bool
    '''

    use_onion_skinning: bool = None
    ''' Ghost frames on either side of frame

    :type: bool
    '''

    use_volumetric_strokes: bool = None
    ''' Draw strokes as a series of circular blobs, resulting in a volumetric effect

    :type: bool
    '''

    def clear(self):
        ''' Remove all the grease pencil layer data

        '''
        pass


class GPencilPalette(bpy_struct):
    ''' Collection of related palettes
    '''

    colors: 'GPencilPaletteColors' = None
    ''' Colors of the palette

    :type: 'GPencilPaletteColors'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Palette name

    :type: typing.Union[str, typing.Any]
    '''


class GPencilPaletteColor(bpy_struct):
    ''' Collection of related colors
    '''

    alpha: float = None
    ''' Color Opacity

    :type: float
    '''

    color: bpy_prop_array[float] = None
    ''' Color for strokes

    :type: bpy_prop_array[float]
    '''

    fill_alpha: float = None
    ''' Opacity for filling region bounded by each stroke

    :type: float
    '''

    fill_color: bpy_prop_array[float] = None
    ''' Color for filling region bounded by each stroke

    :type: bpy_prop_array[float]
    '''

    ghost: bool = None
    ''' Display the color in onion skinning

    :type: bool
    '''

    hide: bool = None
    ''' Set color Visibility

    :type: bool
    '''

    is_fill_visible: typing.Union[bool, typing.Any] = None
    ''' True when opacity of fill is set high enough to be visible

    :type: typing.Union[bool, typing.Any]
    '''

    is_stroke_visible: typing.Union[bool, typing.Any] = None
    ''' True when opacity of stroke is set high enough to be visible

    :type: typing.Union[bool, typing.Any]
    '''

    lock: bool = None
    ''' Protect color from further editing and/or frame changes

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Color name

    :type: typing.Union[str, typing.Any]
    '''

    use_hq_fill: bool = None
    ''' Fill strokes using high quality to avoid glitches (slower fps during animation play)

    :type: bool
    '''

    use_volumetric_strokes: bool = None
    ''' Draw strokes as a series of circular blobs, resulting in a volumetric effect

    :type: bool
    '''


class GPencilSculptBrush(bpy_struct):
    ''' Stroke editing brush
    '''

    affect_pressure: bool = None
    ''' Affect pressure values as well when smoothing strokes

    :type: bool
    '''

    direction: typing.Union[str, int] = None
    ''' * ``ADD`` Add, Add effect of brush. * ``SUBTRACT`` Subtract, Subtract effect of brush.

    :type: typing.Union[str, int]
    '''

    size: int = None
    ''' Radius of the brush in pixels

    :type: int
    '''

    strength: float = None
    ''' Brush strength

    :type: float
    '''

    use_falloff: bool = None
    ''' Strength of brush decays with distance from cursor

    :type: bool
    '''

    use_pressure_strength: bool = None
    ''' Enable tablet pressure sensitivity for strength

    :type: bool
    '''


class GPencilSculptSettings(bpy_struct):
    ''' Properties for Grease Pencil stroke sculpting tool
    '''

    affect_position: bool = None
    ''' The brush affects the position of the point

    :type: bool
    '''

    affect_strength: bool = None
    ''' The brush affects the color strength of the point

    :type: bool
    '''

    affect_thickness: bool = None
    ''' The brush affects the thickness of the point

    :type: bool
    '''

    brush: 'GPencilSculptBrush' = None
    ''' 

    :type: 'GPencilSculptBrush'
    '''

    selection_alpha: float = None
    ''' Alpha value for selected vertices

    :type: float
    '''

    tool: typing.Union[str, int] = None
    ''' * ``SMOOTH`` Smooth, Smooth stroke points. * ``THICKNESS`` Thickness, Adjust thickness of strokes. * ``STRENGTH`` Strength, Adjust color strength of strokes. * ``GRAB`` Grab, Translate the set of points initially within the brush circle. * ``PUSH`` Push, Move points out of the way, as if combing them. * ``TWIST`` Twist, Rotate points around the midpoint of the brush. * ``PINCH`` Pinch, Pull points towards the midpoint of the brush. * ``RANDOMIZE`` Randomize, Introduce jitter/randomness into strokes. * ``CLONE`` Clone, Paste copies of the strokes stored on the clipboard.

    :type: typing.Union[str, int]
    '''

    use_select_mask: bool = None
    ''' Only sculpt selected stroke points

    :type: bool
    '''


class GPencilStroke(bpy_struct):
    ''' Freehand curve defining part of a sketch
    '''

    color: 'GPencilPaletteColor' = None
    ''' Color from palette used in Stroke

    :type: 'GPencilPaletteColor'
    '''

    colorname: typing.Union[str, typing.Any] = None
    ''' Palette color name

    :type: typing.Union[str, typing.Any]
    '''

    draw_cyclic: bool = None
    ''' Enable cyclic drawing, closing the stroke

    :type: bool
    '''

    draw_mode: typing.Union[str, int] = None
    ''' * ``SCREEN`` Screen, Stroke is in screen-space. * ``3DSPACE`` 3D Space, Stroke is in 3D-space. * ``2DSPACE`` 2D Space, Stroke is in 2D-space. * ``2DIMAGE`` 2D Image, Stroke is in 2D-space (but with special 'image' scaling).

    :type: typing.Union[str, int]
    '''

    line_width: int = None
    ''' Thickness of stroke (in pixels)

    :type: int
    '''

    points: 'GPencilStrokePoints' = None
    ''' Stroke data points

    :type: 'GPencilStrokePoints'
    '''

    select: bool = None
    ''' Stroke is selected for viewport editing

    :type: bool
    '''

    triangles: bpy_prop_collection['GPencilTriangle'] = None
    ''' Triangulation data for HQ fill

    :type: bpy_prop_collection['GPencilTriangle']
    '''


class GPencilStrokePoint(bpy_struct):
    ''' Data point for freehand stroke curve
    '''

    co: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    pressure: float = None
    ''' Pressure of tablet at point when drawing it

    :type: float
    '''

    select: bool = None
    ''' Point is selected for viewport editing

    :type: bool
    '''

    strength: float = None
    ''' Color intensity (alpha factor)

    :type: float
    '''


class GPencilTriangle(bpy_struct):
    ''' Triangulation data for HQ fill
    '''

    v1: int = None
    ''' First triangle vertex index

    :type: int
    '''

    v2: int = None
    ''' Second triangle vertex index

    :type: int
    '''

    v3: int = None
    ''' Third triangle vertex index

    :type: int
    '''


class GameObjectSettings(bpy_struct):
    ''' Game engine related settings for the object
    '''

    actuators: bpy_prop_collection['Actuator'] = None
    ''' Game engine actuators to act on events

    :type: bpy_prop_collection['Actuator']
    '''

    angular_velocity_max: float = None
    ''' Clamp angular velocity to this maximum speed, in angle per second

    :type: float
    '''

    angular_velocity_min: float = None
    ''' Clamp angular velocity to this minimum speed (except when totally still), in angle per second

    :type: float
    '''

    collision_bounds_type: typing.Union[str, int] = None
    ''' Select the collision shape that better fits the object

    :type: typing.Union[str, int]
    '''

    collision_group: typing.List[bool] = None
    ''' The collision group of the object

    :type: typing.List[bool]
    '''

    collision_margin: float = None
    ''' Extra margin around object for collision detection, small amount required for stability

    :type: float
    '''

    collision_mask: typing.List[bool] = None
    ''' The groups this object can collide with

    :type: typing.List[bool]
    '''

    controllers: bpy_prop_collection['Controller'] = None
    ''' Game engine controllers to process events, connecting sensors to actuators

    :type: bpy_prop_collection['Controller']
    '''

    damping: float = None
    ''' General movement damping

    :type: float
    '''

    fall_speed: float = None
    ''' Maximum speed at which the character will fall

    :type: float
    '''

    form_factor: float = None
    ''' Form factor scales the inertia tensor

    :type: float
    '''

    friction_coefficients: bpy_prop_array[float] = None
    ''' Relative friction coefficients in the in the X, Y and Z directions, when anisotropic friction is enabled

    :type: bpy_prop_array[float]
    '''

    jump_max: int = None
    ''' The maximum number of jumps the character can make before it hits the ground

    :type: int
    '''

    jump_speed: float = None
    ''' Upward velocity applied to the character when jumping

    :type: float
    '''

    lock_location_x: bool = None
    ''' Disable simulation of linear motion along the X axis

    :type: bool
    '''

    lock_location_y: bool = None
    ''' Disable simulation of linear motion along the Y axis

    :type: bool
    '''

    lock_location_z: bool = None
    ''' Disable simulation of linear motion along the Z axis

    :type: bool
    '''

    lock_rotation_x: bool = None
    ''' Disable simulation of angular motion along the X axis

    :type: bool
    '''

    lock_rotation_y: bool = None
    ''' Disable simulation of angular motion along the Y axis

    :type: bool
    '''

    lock_rotation_z: bool = None
    ''' Disable simulation of angular motion along the Z axis

    :type: bool
    '''

    mass: float = None
    ''' Mass of the object

    :type: float
    '''

    obstacle_radius: float = None
    ''' Radius of object representation in obstacle simulation

    :type: float
    '''

    physics_type: typing.Union[str, int] = None
    ''' Select the type of physical representation * ``NO_COLLISION`` No Collision, Disable collision for this object. * ``STATIC`` Static, Stationary object. * ``DYNAMIC`` Dynamic, Linear physics. * ``RIGID_BODY`` Rigid Body, Linear and angular physics. * ``SOFT_BODY`` Soft Body, Soft body. * ``OCCLUDER`` Occluder, Occluder for optimizing scene rendering. * ``SENSOR`` Sensor, Collision Sensor, detects static and dynamic objects but not the other collision sensor objects. * ``NAVMESH`` Navigation Mesh, Navigation mesh. * ``CHARACTER`` Character, Simple kinematic physics appropriate for game characters.

    :type: typing.Union[str, int]
    '''

    properties: bpy_prop_collection['GameProperty'] = None
    ''' Game engine properties

    :type: bpy_prop_collection['GameProperty']
    '''

    radius: float = None
    ''' Radius of bounding sphere and material physics

    :type: float
    '''

    rotation_damping: float = None
    ''' General rotation damping

    :type: float
    '''

    sensors: bpy_prop_collection['Sensor'] = None
    ''' Game engine sensor to detect events

    :type: bpy_prop_collection['Sensor']
    '''

    show_actuators: bool = None
    ''' Shows actuators for this object in the user interface

    :type: bool
    '''

    show_controllers: bool = None
    ''' Shows controllers for this object in the user interface

    :type: bool
    '''

    show_debug_state: bool = None
    ''' Print state debug info in the game engine

    :type: bool
    '''

    show_sensors: bool = None
    ''' Shows sensors for this object in the user interface

    :type: bool
    '''

    show_state_panel: bool = None
    ''' Show state panel

    :type: bool
    '''

    soft_body: 'GameSoftBodySettings' = None
    ''' Settings for Bullet soft body simulation

    :type: 'GameSoftBodySettings'
    '''

    states_initial: typing.List[bool] = None
    ''' Initial state when the game starts

    :type: typing.List[bool]
    '''

    states_visible: typing.List[bool] = None
    ''' State determining which controllers are displayed

    :type: typing.List[bool]
    '''

    step_height: float = None
    ''' Maximum height of steps the character can run over

    :type: float
    '''

    use_activity_culling: bool = None
    ''' Disable simulation of angular motion along the Z axis

    :type: bool
    '''

    use_actor: bool = None
    ''' Object is detected by the Near and Radar sensor

    :type: bool
    '''

    use_all_states: bool = None
    ''' Set all state bits

    :type: bool
    '''

    use_anisotropic_friction: bool = None
    ''' Enable anisotropic friction

    :type: bool
    '''

    use_collision_bounds: bool = None
    ''' Specify a collision bounds type other than the default

    :type: bool
    '''

    use_collision_compound: bool = None
    ''' Add children to form a compound collision object

    :type: bool
    '''

    use_ghost: bool = None
    ''' Object does not react to collisions, like a ghost

    :type: bool
    '''

    use_material_physics_fh: bool = None
    ''' React to force field physics settings in materials

    :type: bool
    '''

    use_obstacle_create: bool = None
    ''' Create representation for obstacle simulation

    :type: bool
    '''

    use_record_animation: bool = None
    ''' Record animation objects without physics

    :type: bool
    '''

    use_rotate_from_normal: bool = None
    ''' Use face normal to rotate object, so that it points away from the surface

    :type: bool
    '''

    use_sleep: bool = None
    ''' Disable auto (de)activation in physics simulation

    :type: bool
    '''

    used_states: typing.List[bool] = None
    ''' States which are being used by controllers

    :type: typing.List[bool]
    '''

    velocity_max: float = None
    ''' Clamp velocity to this maximum speed, in distance per second

    :type: float
    '''

    velocity_min: float = None
    ''' Clamp velocity to this minimum speed (except when totally still), in distance per second

    :type: float
    '''


class GameProperty(bpy_struct):
    ''' Game engine user defined object property
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Available as GameObject attributes in the game engine's python API

    :type: typing.Union[str, typing.Any]
    '''

    show_debug: bool = None
    ''' Print debug information for this property

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' * ``BOOL`` Boolean, Boolean Property. * ``INT`` Integer, Integer Property. * ``FLOAT`` Float, Floating-Point Property. * ``STRING`` String, String Property. * ``TIMER`` Timer, Timer Property.

    :type: typing.Union[str, int]
    '''


class GameSoftBodySettings(bpy_struct):
    ''' Soft body simulation settings for an object in the game engine
    '''

    cluster_iterations: int = None
    ''' Number of cluster iterations

    :type: int
    '''

    collision_margin: float = None
    ''' Collision margin for soft body. Small value makes the algorithm unstable

    :type: float
    '''

    dynamic_friction: float = None
    ''' Dynamic Friction

    :type: float
    '''

    linear_stiffness: float = None
    ''' Linear stiffness of the soft body links

    :type: float
    '''

    location_iterations: int = None
    ''' Position solver iterations

    :type: int
    '''

    shape_threshold: float = None
    ''' Shape matching threshold

    :type: float
    '''

    use_bending_constraints: bool = None
    ''' Enable bending constraints

    :type: bool
    '''

    use_cluster_rigid_to_softbody: bool = None
    ''' Enable cluster collision between soft and rigid body

    :type: bool
    '''

    use_cluster_soft_to_softbody: bool = None
    ''' Enable cluster collision between soft and soft body

    :type: bool
    '''

    use_shape_match: bool = None
    ''' Enable soft body shape matching goal

    :type: bool
    '''

    weld_threshold: float = None
    ''' Welding threshold: distance between nearby vertices to be considered equal => set to 0.0 to disable welding test and speed up scene loading (ok if the mesh has no duplicates)

    :type: float
    '''


class Header(bpy_struct):
    ''' Editor header containing UI elements
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the header gets a custom ID, otherwise it takes the name of the class used to define the panel; for example, if the class name is "OBJECT_HT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_HT_hello"

    :type: typing.Union[str, typing.Any]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the header is going to be used in * ``EMPTY`` Empty. * ``VIEW_3D`` 3D View, 3D viewport. * ``TIMELINE`` Timeline, Timeline and playback controls. * ``GRAPH_EDITOR`` Graph Editor, Edit drivers and keyframe interpolation. * ``DOPESHEET_EDITOR`` Dope Sheet, Adjust timing of keyframes. * ``NLA_EDITOR`` NLA Editor, Combine and layer Actions. * ``IMAGE_EDITOR`` UV/Image Editor, View and edit images and UV Maps. * ``SEQUENCE_EDITOR`` Video Sequence Editor, Video editing tools. * ``CLIP_EDITOR`` Movie Clip Editor, Motion tracking tools. * ``TEXT_EDITOR`` Text Editor, Edit scripts and in-file documentation. * ``NODE_EDITOR`` Node Editor, Editor for node-based shading and compositing tools. * ``LOGIC_EDITOR`` Logic Editor, Game logic editing. * ``PROPERTIES`` Properties, Edit properties of active object and related data-blocks. * ``OUTLINER`` Outliner, Overview of scene graph and all available data-blocks. * ``USER_PREFERENCES`` User Preferences, Edit persistent configuration settings. * ``INFO`` Info, Main menu bar and list of error messages (drag down to expand and display). * ``FILE_BROWSER`` File Browser, Browse for files and assets. * ``CONSOLE`` Python Console, Interactive programmatic console for advanced editing and script development.

    :type: typing.Union[str, int]
    '''

    layout: 'UILayout' = None
    ''' Structure of the header in the UI

    :type: 'UILayout'
    '''

    def draw(self, context: typing.Optional['Context']):
        ''' Draw UI elements into the header UI layout

        :param context: 
        :type context: typing.Optional['Context']
        '''
        pass


class Histogram(bpy_struct):
    ''' Statistical view of the levels of color in an image
    '''

    mode: typing.Union[str, int] = None
    ''' Channels to display when drawing the histogram * ``LUMA`` Luma, Luma. * ``RGB`` RGB, Red Green Blue. * ``R`` R, Red. * ``G`` G, Green. * ``B`` B, Blue. * ``A`` A, Alpha.

    :type: typing.Union[str, int]
    '''

    show_line: bool = None
    ''' Display lines rather than filled shapes

    :type: bool
    '''


class ID(bpy_struct):
    ''' Base type for data-blocks, defining a unique name, linking from other libraries and garbage collection
    '''

    is_library_indirect: typing.Union[bool, typing.Any] = None
    ''' Is this ID block linked indirectly

    :type: typing.Union[bool, typing.Any]
    '''

    is_updated: typing.Union[bool, typing.Any] = None
    ''' Datablock is tagged for recalculation

    :type: typing.Union[bool, typing.Any]
    '''

    is_updated_data: typing.Union[bool, typing.Any] = None
    ''' Datablock data is tagged for recalculation

    :type: typing.Union[bool, typing.Any]
    '''

    library: 'Library' = None
    ''' Library file the data-block is linked from

    :type: 'Library'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique data-block ID name

    :type: typing.Union[str, typing.Any]
    '''

    preview: 'ImagePreview' = None
    ''' Preview image and icon of this data-block (None if not supported for this type of data)

    :type: 'ImagePreview'
    '''

    tag: bool = None
    ''' Tools can use this to tag data for their own purposes (initial state is undefined)

    :type: bool
    '''

    use_fake_user: bool = None
    ''' Save this data-block even if it has no users

    :type: bool
    '''

    users: int = None
    ''' Number of times this data-block is referenced

    :type: int
    '''

    def copy(self) -> 'ID':
        ''' Create a copy of this data-block (not supported for all data-blocks)

        :rtype: 'ID'
        :return: New copy of the ID
        '''
        pass

    def user_clear(self):
        ''' Clear the user count of a data-block so its not saved, on reload the data will be removed This function is for advanced use only, misuse can crash blender since the user count is used to prevent data being removed when it is used.

        '''
        pass

    def user_remap(self, new_id: 'ID'):
        ''' Replace all usage in the .blend file of this ID by new given one

        :param new_id: New ID to use
        :type new_id: 'ID'
        '''
        pass

    def user_of_id(self, id: 'ID') -> int:
        ''' Count the number of times that ID uses/references given one

        :param id: ID to count usages
        :type id: 'ID'
        :rtype: int
        :return: Number of usages/references of given id by current datablock
        '''
        pass

    def animation_data_create(self) -> 'AnimData':
        ''' Create animation data to this ID, note that not all ID types support this

        :rtype: 'AnimData'
        :return: New animation data or NULL
        '''
        pass

    def animation_data_clear(self):
        ''' Clear animation on this this ID

        '''
        pass

    def update_tag(self, refresh: typing.Optional[typing.Any] = {}):
        ''' Tag the ID to update its display data, e.g. when calling `bpy.types.Scene.update`

        :param refresh: Type of updates to perform
        :type refresh: typing.Optional[typing.Any]
        '''
        pass


class IKParam(bpy_struct):
    ''' Base type for IK solver parameters
    '''

    ik_solver: typing.Union[str, int] = None
    ''' IK solver for which these parameters are defined * ``LEGACY`` Standard, Original IK solver. * ``ITASC`` iTaSC, Multi constraint, stateful IK solver.

    :type: typing.Union[str, int]
    '''


class ImageFormatSettings(bpy_struct):
    ''' Settings for image formats
    '''

    cineon_black: int = None
    ''' Log conversion reference blackpoint

    :type: int
    '''

    cineon_gamma: float = None
    ''' Log conversion gamma

    :type: float
    '''

    cineon_white: int = None
    ''' Log conversion reference whitepoint

    :type: int
    '''

    color_depth: typing.Union[str, int] = None
    ''' Bit depth per channel * ``8`` 8, 8 bit color channels. * ``10`` 10, 10 bit color channels. * ``12`` 12, 12 bit color channels. * ``16`` 16, 16 bit color channels. * ``32`` 32, 32 bit color channels.

    :type: typing.Union[str, int]
    '''

    color_mode: typing.Union[str, int] = None
    ''' Choose BW for saving grayscale images, RGB for saving red, green and blue channels, and RGBA for saving red, green, blue and alpha channels * ``BW`` BW, Images get saved in 8 bits grayscale (only PNG, JPEG, TGA, TIF). * ``RGB`` RGB, Images are saved with RGB (color) data. * ``RGBA`` RGBA, Images are saved with RGB and Alpha data (if supported).

    :type: typing.Union[str, int]
    '''

    compression: int = None
    ''' Amount of time to determine best compression: 0 = no compression with fast file output, 100 = maximum lossless compression with slow file output

    :type: int
    '''

    display_settings: 'ColorManagedDisplaySettings' = None
    ''' Settings of device saved image would be displayed on

    :type: 'ColorManagedDisplaySettings'
    '''

    exr_codec: typing.Union[str, int] = None
    ''' Codec settings for OpenEXR

    :type: typing.Union[str, int]
    '''

    file_format: typing.Union[str, int] = None
    ''' File format to save the rendered images as * ``BMP`` BMP, Output image in bitmap format. * ``IRIS`` Iris, Output image in (old!) SGI IRIS format. * ``PNG`` PNG, Output image in PNG format. * ``JPEG`` JPEG, Output image in JPEG format. * ``JPEG2000`` JPEG 2000, Output image in JPEG 2000 format. * ``TARGA`` Targa, Output image in Targa format. * ``TARGA_RAW`` Targa Raw, Output image in uncompressed Targa format. * ``CINEON`` Cineon, Output image in Cineon format. * ``DPX`` DPX, Output image in DPX format. * ``OPEN_EXR_MULTILAYER`` OpenEXR MultiLayer, Output image in multilayer OpenEXR format. * ``OPEN_EXR`` OpenEXR, Output image in OpenEXR format. * ``HDR`` Radiance HDR, Output image in Radiance HDR format. * ``TIFF`` TIFF, Output image in TIFF format. * ``AVI_JPEG`` AVI JPEG, Output video in AVI JPEG format. * ``AVI_RAW`` AVI Raw, Output video in AVI Raw format. * ``FRAMESERVER`` Frame Server, Output image to a frameserver. * ``H264`` H.264, Output video in H.264 format. * ``FFMPEG`` MPEG, Output video in MPEG format. * ``THEORA`` Ogg Theora, Output video in Ogg format. * ``XVID`` Xvid, Output video in Xvid format.

    :type: typing.Union[str, int]
    '''

    jpeg2k_codec: typing.Union[str, int] = None
    ''' Codec settings for Jpek2000

    :type: typing.Union[str, int]
    '''

    quality: int = None
    ''' Quality for image formats that support lossy compression

    :type: int
    '''

    stereo_3d_format: 'Stereo3dFormat' = None
    ''' Settings for stereo 3d

    :type: 'Stereo3dFormat'
    '''

    tiff_codec: typing.Union[str, int] = None
    ''' Compression mode for TIFF

    :type: typing.Union[str, int]
    '''

    use_cineon_log: bool = None
    ''' Convert to logarithmic color space

    :type: bool
    '''

    use_jpeg2k_cinema_48: bool = None
    ''' Use Openjpeg Cinema Preset (48fps)

    :type: bool
    '''

    use_jpeg2k_cinema_preset: bool = None
    ''' Use Openjpeg Cinema Preset

    :type: bool
    '''

    use_jpeg2k_ycc: bool = None
    ''' Save luminance-chrominance-chrominance channels instead of RGB colors

    :type: bool
    '''

    use_preview: bool = None
    ''' When rendering animations, save JPG preview images in same directory

    :type: bool
    '''

    use_zbuffer: bool = None
    ''' Save the z-depth per pixel (32 bit unsigned int z-buffer)

    :type: bool
    '''

    view_settings: 'ColorManagedViewSettings' = None
    ''' Color management settings applied on image before saving

    :type: 'ColorManagedViewSettings'
    '''

    views_format: typing.Union[str, int] = None
    ''' Format of multiview media * ``INDIVIDUAL`` Individual, Individual files for each view with the prefix as defined by the scene views. * ``STEREO_3D`` Stereo 3D, Single file with an encoded stereo pair.

    :type: typing.Union[str, int]
    '''


class ImagePackedFile(bpy_struct):
    filepath: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    packed_file: 'PackedFile' = None
    ''' 

    :type: 'PackedFile'
    '''

    def save(self):
        ''' Save the packed file to its filepath

        '''
        pass


class ImagePreview(bpy_struct):
    ''' Preview image and icon
    '''

    icon_id: int = None
    ''' Unique integer identifying this preview as an icon (zero means invalid)

    :type: int
    '''

    icon_pixels: int = None
    ''' Icon pixels, as bytes (always RGBA 32bits)

    :type: int
    '''

    icon_pixels_float: float = None
    ''' Icon pixels components, as floats (RGBA concatenated values)

    :type: float
    '''

    icon_size: bpy_prop_array[int] = None
    ''' Width and height in pixels

    :type: bpy_prop_array[int]
    '''

    image_pixels: int = None
    ''' Image pixels, as bytes (always RGBA 32bits)

    :type: int
    '''

    image_pixels_float: float = None
    ''' Image pixels components, as floats (RGBA concatenated values)

    :type: float
    '''

    image_size: bpy_prop_array[int] = None
    ''' Width and height in pixels

    :type: bpy_prop_array[int]
    '''

    is_icon_custom: bool = None
    ''' True if this preview icon has been modified by py script,and is no more auto-generated by Blender

    :type: bool
    '''

    is_image_custom: bool = None
    ''' True if this preview image has been modified by py script,and is no more auto-generated by Blender

    :type: bool
    '''

    def reload(self):
        ''' Reload the preview from its source path

        '''
        pass


class ImageUser(bpy_struct):
    ''' Parameters defining how an Image data-block is used by another data-block
    '''

    fields_per_frame: int = None
    ''' Number of fields per rendered frame (2 fields is 1 image)

    :type: int
    '''

    frame_current: int = None
    ''' Current frame number in image sequence or movie

    :type: int
    '''

    frame_duration: int = None
    ''' Number of images of a movie to use

    :type: int
    '''

    frame_offset: int = None
    ''' Offset the number of the frame to use in the animation

    :type: int
    '''

    frame_start: int = None
    ''' Global starting frame of the movie/sequence, assuming first picture has a #1

    :type: int
    '''

    multilayer_layer: int = None
    ''' Layer in multilayer image

    :type: int
    '''

    multilayer_pass: int = None
    ''' Pass in multilayer image

    :type: int
    '''

    multilayer_view: int = None
    ''' View in multilayer image

    :type: int
    '''

    use_auto_refresh: bool = None
    ''' Always refresh image on frame changes

    :type: bool
    '''

    use_cyclic: bool = None
    ''' Cycle the images in the movie

    :type: bool
    '''


class ImapaintToolCapabilities(bpy_struct):
    ''' Read-only indications of which brush operations are supported by the current image paint brush
    '''

    has_accumulate: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_radius: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_space_attenuation: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''


class KeyConfig(bpy_struct):
    ''' Input configuration, including keymaps
    '''

    is_user_defined: typing.Union[bool, typing.Any] = None
    ''' Indicates that a keyconfig was defined by the user

    :type: typing.Union[bool, typing.Any]
    '''

    keymaps: 'KeyMaps' = None
    ''' Key maps configured as part of this configuration

    :type: 'KeyMaps'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the key configuration

    :type: typing.Union[str, typing.Any]
    '''


class KeyMap(bpy_struct):
    ''' Input configuration, including keymaps
    '''

    is_modal: typing.Union[bool, typing.Any] = None
    ''' Indicates that a keymap is used for translate modal events for an operator

    :type: typing.Union[bool, typing.Any]
    '''

    is_user_modified: bool = None
    ''' Keymap is defined by the user

    :type: bool
    '''

    keymap_items: 'KeyMapItems' = None
    ''' Items in the keymap, linking an operator to an input event

    :type: 'KeyMapItems'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the key map

    :type: typing.Union[str, typing.Any]
    '''

    region_type: typing.Union[str, int] = None
    ''' Optional region type keymap is associated with

    :type: typing.Union[str, int]
    '''

    show_expanded_children: bool = None
    ''' Children expanded in the user interface

    :type: bool
    '''

    show_expanded_items: bool = None
    ''' Expanded in the user interface

    :type: bool
    '''

    space_type: typing.Union[str, int] = None
    ''' Optional space type keymap is associated with * ``EMPTY`` Empty. * ``VIEW_3D`` 3D View, 3D viewport. * ``TIMELINE`` Timeline, Timeline and playback controls. * ``GRAPH_EDITOR`` Graph Editor, Edit drivers and keyframe interpolation. * ``DOPESHEET_EDITOR`` Dope Sheet, Adjust timing of keyframes. * ``NLA_EDITOR`` NLA Editor, Combine and layer Actions. * ``IMAGE_EDITOR`` UV/Image Editor, View and edit images and UV Maps. * ``SEQUENCE_EDITOR`` Video Sequence Editor, Video editing tools. * ``CLIP_EDITOR`` Movie Clip Editor, Motion tracking tools. * ``TEXT_EDITOR`` Text Editor, Edit scripts and in-file documentation. * ``NODE_EDITOR`` Node Editor, Editor for node-based shading and compositing tools. * ``LOGIC_EDITOR`` Logic Editor, Game logic editing. * ``PROPERTIES`` Properties, Edit properties of active object and related data-blocks. * ``OUTLINER`` Outliner, Overview of scene graph and all available data-blocks. * ``USER_PREFERENCES`` User Preferences, Edit persistent configuration settings. * ``INFO`` Info, Main menu bar and list of error messages (drag down to expand and display). * ``FILE_BROWSER`` File Browser, Browse for files and assets. * ``CONSOLE`` Python Console, Interactive programmatic console for advanced editing and script development.

    :type: typing.Union[str, int]
    '''

    def active(self) -> 'KeyMap':
        ''' active

        :rtype: 'KeyMap'
        :return: Key Map, Active key map
        '''
        pass

    def restore_to_default(self):
        ''' restore_to_default

        '''
        pass

    def restore_item_to_default(self, item: 'KeyMapItem'):
        ''' restore_item_to_default

        :param item: Item
        :type item: 'KeyMapItem'
        '''
        pass


class KeyMapItem(bpy_struct):
    ''' Item in a Key Map
    '''

    active: bool = None
    ''' Activate or deactivate item

    :type: bool
    '''

    alt: bool = None
    ''' Alt key pressed

    :type: bool
    '''

    any: bool = None
    ''' Any modifier keys pressed

    :type: bool
    '''

    ctrl: bool = None
    ''' Control key pressed

    :type: bool
    '''

    id: int = None
    ''' ID of the item

    :type: int
    '''

    idname: typing.Union[str, typing.Any] = None
    ''' Identifier of operator to call on input event

    :type: typing.Union[str, typing.Any]
    '''

    is_user_defined: typing.Union[bool, typing.Any] = None
    ''' Is this keymap item user defined (doesn't just replace a builtin item)

    :type: typing.Union[bool, typing.Any]
    '''

    is_user_modified: typing.Union[bool, typing.Any] = None
    ''' Is this keymap item modified by the user

    :type: typing.Union[bool, typing.Any]
    '''

    key_modifier: typing.Union[str, int] = None
    ''' Regular key pressed as a modifier * ``NONE`` . * ``LEFTMOUSE`` Left Mouse, LMB. * ``MIDDLEMOUSE`` Middle Mouse, MMB. * ``RIGHTMOUSE`` Right Mouse, RMB. * ``BUTTON4MOUSE`` Button4 Mouse, MB4. * ``BUTTON5MOUSE`` Button5 Mouse, MB5. * ``BUTTON6MOUSE`` Button6 Mouse, MB6. * ``BUTTON7MOUSE`` Button7 Mouse, MB7. * ``ACTIONMOUSE`` Action Mouse, MBA. * ``SELECTMOUSE`` Select Mouse, MBS. * ``PEN`` Pen. * ``ERASER`` Eraser. * ``MOUSEMOVE`` Mouse Move, MsMov. * ``INBETWEEN_MOUSEMOVE`` In-between Move, MsSubMov. * ``TRACKPADPAN`` Mouse/Trackpad Pan, MsPan. * ``TRACKPADZOOM`` Mouse/Trackpad Zoom, MsZoom. * ``MOUSEROTATE`` Mouse/Trackpad Rotate, MsRot. * ``WHEELUPMOUSE`` Wheel Up, WhUp. * ``WHEELDOWNMOUSE`` Wheel Down, WhDown. * ``WHEELINMOUSE`` Wheel In, WhIn. * ``WHEELOUTMOUSE`` Wheel Out, WhOut. * ``EVT_TWEAK_L`` Tweak Left, TwkL. * ``EVT_TWEAK_M`` Tweak Middle, TwkM. * ``EVT_TWEAK_R`` Tweak Right, TwkR. * ``EVT_TWEAK_A`` Tweak Action, TwkA. * ``EVT_TWEAK_S`` Tweak Select, TwkS. * ``A`` A. * ``B`` B. * ``C`` C. * ``D`` D. * ``E`` E. * ``F`` F. * ``G`` G. * ``H`` H. * ``I`` I. * ``J`` J. * ``K`` K. * ``L`` L. * ``M`` M. * ``N`` N. * ``O`` O. * ``P`` P. * ``Q`` Q. * ``R`` R. * ``S`` S. * ``T`` T. * ``U`` U. * ``V`` V. * ``W`` W. * ``X`` X. * ``Y`` Y. * ``Z`` Z. * ``ZERO`` 0. * ``ONE`` 1. * ``TWO`` 2. * ``THREE`` 3. * ``FOUR`` 4. * ``FIVE`` 5. * ``SIX`` 6. * ``SEVEN`` 7. * ``EIGHT`` 8. * ``NINE`` 9. * ``LEFT_CTRL`` Left Ctrl, CtrlL. * ``LEFT_ALT`` Left Alt, AltL. * ``LEFT_SHIFT`` Left Shift, ShiftL. * ``RIGHT_ALT`` Right Alt, AltR. * ``RIGHT_CTRL`` Right Ctrl, CtrlR. * ``RIGHT_SHIFT`` Right Shift, ShiftR. * ``OSKEY`` OS Key, Cmd. * ``GRLESS`` Grless. * ``ESC`` Esc. * ``TAB`` Tab. * ``RET`` Return, Enter. * ``SPACE`` Spacebar, Space. * ``LINE_FEED`` Line Feed. * ``BACK_SPACE`` Back Space, BkSpace. * ``DEL`` Delete, Del. * ``SEMI_COLON`` ;. * ``PERIOD`` .. * ``COMMA`` ,. * ``QUOTE`` ". * ``ACCENT_GRAVE`` \`. * ``MINUS`` -. * ``PLUS`` +. * ``SLASH`` /. * ``BACK_SLASH`` \\. * ``EQUAL`` =. * ``LEFT_BRACKET`` [. * ``RIGHT_BRACKET`` ]. * ``LEFT_ARROW`` Left Arrow, ←. * ``DOWN_ARROW`` Down Arrow, ↓. * ``RIGHT_ARROW`` Right Arrow, →. * ``UP_ARROW`` Up Arrow, ↑. * ``NUMPAD_2`` Numpad 2, Pad2. * ``NUMPAD_4`` Numpad 4, Pad4. * ``NUMPAD_6`` Numpad 6, Pad6. * ``NUMPAD_8`` Numpad 8, Pad8. * ``NUMPAD_1`` Numpad 1, Pad1. * ``NUMPAD_3`` Numpad 3, Pad3. * ``NUMPAD_5`` Numpad 5, Pad5. * ``NUMPAD_7`` Numpad 7, Pad7. * ``NUMPAD_9`` Numpad 9, Pad9. * ``NUMPAD_PERIOD`` Numpad ., Pad.. * ``NUMPAD_SLASH`` Numpad /, Pad/. * ``NUMPAD_ASTERIX`` Numpad \*, Pad\*. * ``NUMPAD_0`` Numpad 0, Pad0. * ``NUMPAD_MINUS`` Numpad -, Pad-. * ``NUMPAD_ENTER`` Numpad Enter, PadEnter. * ``NUMPAD_PLUS`` Numpad +, Pad+. * ``F1`` F1. * ``F2`` F2. * ``F3`` F3. * ``F4`` F4. * ``F5`` F5. * ``F6`` F6. * ``F7`` F7. * ``F8`` F8. * ``F9`` F9. * ``F10`` F10. * ``F11`` F11. * ``F12`` F12. * ``F13`` F13. * ``F14`` F14. * ``F15`` F15. * ``F16`` F16. * ``F17`` F17. * ``F18`` F18. * ``F19`` F19. * ``PAUSE`` Pause. * ``INSERT`` Insert, Ins. * ``HOME`` Home. * ``PAGE_UP`` Page Up, PgUp. * ``PAGE_DOWN`` Page Down, PgDown. * ``END`` End. * ``MEDIA_PLAY`` Media Play/Pause, >/\|\|. * ``MEDIA_STOP`` Media Stop, Stop. * ``MEDIA_FIRST`` Media First, \|<<. * ``MEDIA_LAST`` Media Last, >>\|. * ``TEXTINPUT`` Text Input, TxtIn. * ``WINDOW_DEACTIVATE`` Window Deactivate. * ``TIMER`` Timer, Tmr. * ``TIMER0`` Timer 0, Tmr0. * ``TIMER1`` Timer 1, Tmr1. * ``TIMER2`` Timer 2, Tmr2. * ``TIMER_JOBS`` Timer Jobs, TmrJob. * ``TIMER_AUTOSAVE`` Timer Autosave, TmrSave. * ``TIMER_REPORT`` Timer Report, TmrReport. * ``TIMERREGION`` Timer Region, TmrReg. * ``NDOF_MOTION`` NDOF Motion, NdofMov. * ``NDOF_BUTTON_MENU`` NDOF Menu, NdofMenu. * ``NDOF_BUTTON_FIT`` NDOF Fit, NdofFit. * ``NDOF_BUTTON_TOP`` NDOF Top, Ndof↑. * ``NDOF_BUTTON_BOTTOM`` NDOF Bottom, Ndof↓. * ``NDOF_BUTTON_LEFT`` NDOF Left, Ndof←. * ``NDOF_BUTTON_RIGHT`` NDOF Right, Ndof→. * ``NDOF_BUTTON_FRONT`` NDOF Front, NdofFront. * ``NDOF_BUTTON_BACK`` NDOF Back, NdofBack. * ``NDOF_BUTTON_ISO1`` NDOF Isometric 1, NdofIso1. * ``NDOF_BUTTON_ISO2`` NDOF Isometric 2, NdofIso2. * ``NDOF_BUTTON_ROLL_CW`` NDOF Roll CW, NdofRCW. * ``NDOF_BUTTON_ROLL_CCW`` NDOF Roll CCW, NdofRCCW. * ``NDOF_BUTTON_SPIN_CW`` NDOF Spin CW, NdofSCW. * ``NDOF_BUTTON_SPIN_CCW`` NDOF Spin CCW, NdofSCCW. * ``NDOF_BUTTON_TILT_CW`` NDOF Tilt CW, NdofTCW. * ``NDOF_BUTTON_TILT_CCW`` NDOF Tilt CCW, NdofTCCW. * ``NDOF_BUTTON_ROTATE`` NDOF Rotate, NdofRot. * ``NDOF_BUTTON_PANZOOM`` NDOF Pan/Zoom, NdofPanZoom. * ``NDOF_BUTTON_DOMINANT`` NDOF Dominant, NdofDom. * ``NDOF_BUTTON_PLUS`` NDOF Plus, Ndof+. * ``NDOF_BUTTON_MINUS`` NDOF Minus, Ndof-. * ``NDOF_BUTTON_ESC`` NDOF Esc, NdofEsc. * ``NDOF_BUTTON_ALT`` NDOF Alt, NdofAlt. * ``NDOF_BUTTON_SHIFT`` NDOF Shift, NdofShift. * ``NDOF_BUTTON_CTRL`` NDOF Ctrl, NdofCtrl. * ``NDOF_BUTTON_1`` NDOF Button 1, NdofB1. * ``NDOF_BUTTON_2`` NDOF Button 2, NdofB2. * ``NDOF_BUTTON_3`` NDOF Button 3, NdofB3. * ``NDOF_BUTTON_4`` NDOF Button 4, NdofB4. * ``NDOF_BUTTON_5`` NDOF Button 5, NdofB5. * ``NDOF_BUTTON_6`` NDOF Button 6, NdofB6. * ``NDOF_BUTTON_7`` NDOF Button 7, NdofB7. * ``NDOF_BUTTON_8`` NDOF Button 8, NdofB8. * ``NDOF_BUTTON_9`` NDOF Button 9, NdofB9. * ``NDOF_BUTTON_10`` NDOF Button 10, NdofB10. * ``NDOF_BUTTON_A`` NDOF Button A, NdofBA. * ``NDOF_BUTTON_B`` NDOF Button B, NdofBB. * ``NDOF_BUTTON_C`` NDOF Button C, NdofBC.

    :type: typing.Union[str, int]
    '''

    map_type: typing.Union[str, int] = None
    ''' Type of event mapping

    :type: typing.Union[str, int]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of operator (translated) to call on input event

    :type: typing.Union[str, typing.Any]
    '''

    oskey: bool = None
    ''' Operating system key pressed

    :type: bool
    '''

    properties: 'OperatorProperties' = None
    ''' Properties to set when the operator is called

    :type: 'OperatorProperties'
    '''

    propvalue: typing.Union[str, int] = None
    ''' The value this event translates to in a modal keymap

    :type: typing.Union[str, int]
    '''

    shift: bool = None
    ''' Shift key pressed

    :type: bool
    '''

    show_expanded: bool = None
    ''' Show key map event and property details in the user interface

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of event * ``NONE`` . * ``LEFTMOUSE`` Left Mouse, LMB. * ``MIDDLEMOUSE`` Middle Mouse, MMB. * ``RIGHTMOUSE`` Right Mouse, RMB. * ``BUTTON4MOUSE`` Button4 Mouse, MB4. * ``BUTTON5MOUSE`` Button5 Mouse, MB5. * ``BUTTON6MOUSE`` Button6 Mouse, MB6. * ``BUTTON7MOUSE`` Button7 Mouse, MB7. * ``ACTIONMOUSE`` Action Mouse, MBA. * ``SELECTMOUSE`` Select Mouse, MBS. * ``PEN`` Pen. * ``ERASER`` Eraser. * ``MOUSEMOVE`` Mouse Move, MsMov. * ``INBETWEEN_MOUSEMOVE`` In-between Move, MsSubMov. * ``TRACKPADPAN`` Mouse/Trackpad Pan, MsPan. * ``TRACKPADZOOM`` Mouse/Trackpad Zoom, MsZoom. * ``MOUSEROTATE`` Mouse/Trackpad Rotate, MsRot. * ``WHEELUPMOUSE`` Wheel Up, WhUp. * ``WHEELDOWNMOUSE`` Wheel Down, WhDown. * ``WHEELINMOUSE`` Wheel In, WhIn. * ``WHEELOUTMOUSE`` Wheel Out, WhOut. * ``EVT_TWEAK_L`` Tweak Left, TwkL. * ``EVT_TWEAK_M`` Tweak Middle, TwkM. * ``EVT_TWEAK_R`` Tweak Right, TwkR. * ``EVT_TWEAK_A`` Tweak Action, TwkA. * ``EVT_TWEAK_S`` Tweak Select, TwkS. * ``A`` A. * ``B`` B. * ``C`` C. * ``D`` D. * ``E`` E. * ``F`` F. * ``G`` G. * ``H`` H. * ``I`` I. * ``J`` J. * ``K`` K. * ``L`` L. * ``M`` M. * ``N`` N. * ``O`` O. * ``P`` P. * ``Q`` Q. * ``R`` R. * ``S`` S. * ``T`` T. * ``U`` U. * ``V`` V. * ``W`` W. * ``X`` X. * ``Y`` Y. * ``Z`` Z. * ``ZERO`` 0. * ``ONE`` 1. * ``TWO`` 2. * ``THREE`` 3. * ``FOUR`` 4. * ``FIVE`` 5. * ``SIX`` 6. * ``SEVEN`` 7. * ``EIGHT`` 8. * ``NINE`` 9. * ``LEFT_CTRL`` Left Ctrl, CtrlL. * ``LEFT_ALT`` Left Alt, AltL. * ``LEFT_SHIFT`` Left Shift, ShiftL. * ``RIGHT_ALT`` Right Alt, AltR. * ``RIGHT_CTRL`` Right Ctrl, CtrlR. * ``RIGHT_SHIFT`` Right Shift, ShiftR. * ``OSKEY`` OS Key, Cmd. * ``GRLESS`` Grless. * ``ESC`` Esc. * ``TAB`` Tab. * ``RET`` Return, Enter. * ``SPACE`` Spacebar, Space. * ``LINE_FEED`` Line Feed. * ``BACK_SPACE`` Back Space, BkSpace. * ``DEL`` Delete, Del. * ``SEMI_COLON`` ;. * ``PERIOD`` .. * ``COMMA`` ,. * ``QUOTE`` ". * ``ACCENT_GRAVE`` \`. * ``MINUS`` -. * ``PLUS`` +. * ``SLASH`` /. * ``BACK_SLASH`` \\. * ``EQUAL`` =. * ``LEFT_BRACKET`` [. * ``RIGHT_BRACKET`` ]. * ``LEFT_ARROW`` Left Arrow, ←. * ``DOWN_ARROW`` Down Arrow, ↓. * ``RIGHT_ARROW`` Right Arrow, →. * ``UP_ARROW`` Up Arrow, ↑. * ``NUMPAD_2`` Numpad 2, Pad2. * ``NUMPAD_4`` Numpad 4, Pad4. * ``NUMPAD_6`` Numpad 6, Pad6. * ``NUMPAD_8`` Numpad 8, Pad8. * ``NUMPAD_1`` Numpad 1, Pad1. * ``NUMPAD_3`` Numpad 3, Pad3. * ``NUMPAD_5`` Numpad 5, Pad5. * ``NUMPAD_7`` Numpad 7, Pad7. * ``NUMPAD_9`` Numpad 9, Pad9. * ``NUMPAD_PERIOD`` Numpad ., Pad.. * ``NUMPAD_SLASH`` Numpad /, Pad/. * ``NUMPAD_ASTERIX`` Numpad \*, Pad\*. * ``NUMPAD_0`` Numpad 0, Pad0. * ``NUMPAD_MINUS`` Numpad -, Pad-. * ``NUMPAD_ENTER`` Numpad Enter, PadEnter. * ``NUMPAD_PLUS`` Numpad +, Pad+. * ``F1`` F1. * ``F2`` F2. * ``F3`` F3. * ``F4`` F4. * ``F5`` F5. * ``F6`` F6. * ``F7`` F7. * ``F8`` F8. * ``F9`` F9. * ``F10`` F10. * ``F11`` F11. * ``F12`` F12. * ``F13`` F13. * ``F14`` F14. * ``F15`` F15. * ``F16`` F16. * ``F17`` F17. * ``F18`` F18. * ``F19`` F19. * ``PAUSE`` Pause. * ``INSERT`` Insert, Ins. * ``HOME`` Home. * ``PAGE_UP`` Page Up, PgUp. * ``PAGE_DOWN`` Page Down, PgDown. * ``END`` End. * ``MEDIA_PLAY`` Media Play/Pause, >/\|\|. * ``MEDIA_STOP`` Media Stop, Stop. * ``MEDIA_FIRST`` Media First, \|<<. * ``MEDIA_LAST`` Media Last, >>\|. * ``TEXTINPUT`` Text Input, TxtIn. * ``WINDOW_DEACTIVATE`` Window Deactivate. * ``TIMER`` Timer, Tmr. * ``TIMER0`` Timer 0, Tmr0. * ``TIMER1`` Timer 1, Tmr1. * ``TIMER2`` Timer 2, Tmr2. * ``TIMER_JOBS`` Timer Jobs, TmrJob. * ``TIMER_AUTOSAVE`` Timer Autosave, TmrSave. * ``TIMER_REPORT`` Timer Report, TmrReport. * ``TIMERREGION`` Timer Region, TmrReg. * ``NDOF_MOTION`` NDOF Motion, NdofMov. * ``NDOF_BUTTON_MENU`` NDOF Menu, NdofMenu. * ``NDOF_BUTTON_FIT`` NDOF Fit, NdofFit. * ``NDOF_BUTTON_TOP`` NDOF Top, Ndof↑. * ``NDOF_BUTTON_BOTTOM`` NDOF Bottom, Ndof↓. * ``NDOF_BUTTON_LEFT`` NDOF Left, Ndof←. * ``NDOF_BUTTON_RIGHT`` NDOF Right, Ndof→. * ``NDOF_BUTTON_FRONT`` NDOF Front, NdofFront. * ``NDOF_BUTTON_BACK`` NDOF Back, NdofBack. * ``NDOF_BUTTON_ISO1`` NDOF Isometric 1, NdofIso1. * ``NDOF_BUTTON_ISO2`` NDOF Isometric 2, NdofIso2. * ``NDOF_BUTTON_ROLL_CW`` NDOF Roll CW, NdofRCW. * ``NDOF_BUTTON_ROLL_CCW`` NDOF Roll CCW, NdofRCCW. * ``NDOF_BUTTON_SPIN_CW`` NDOF Spin CW, NdofSCW. * ``NDOF_BUTTON_SPIN_CCW`` NDOF Spin CCW, NdofSCCW. * ``NDOF_BUTTON_TILT_CW`` NDOF Tilt CW, NdofTCW. * ``NDOF_BUTTON_TILT_CCW`` NDOF Tilt CCW, NdofTCCW. * ``NDOF_BUTTON_ROTATE`` NDOF Rotate, NdofRot. * ``NDOF_BUTTON_PANZOOM`` NDOF Pan/Zoom, NdofPanZoom. * ``NDOF_BUTTON_DOMINANT`` NDOF Dominant, NdofDom. * ``NDOF_BUTTON_PLUS`` NDOF Plus, Ndof+. * ``NDOF_BUTTON_MINUS`` NDOF Minus, Ndof-. * ``NDOF_BUTTON_ESC`` NDOF Esc, NdofEsc. * ``NDOF_BUTTON_ALT`` NDOF Alt, NdofAlt. * ``NDOF_BUTTON_SHIFT`` NDOF Shift, NdofShift. * ``NDOF_BUTTON_CTRL`` NDOF Ctrl, NdofCtrl. * ``NDOF_BUTTON_1`` NDOF Button 1, NdofB1. * ``NDOF_BUTTON_2`` NDOF Button 2, NdofB2. * ``NDOF_BUTTON_3`` NDOF Button 3, NdofB3. * ``NDOF_BUTTON_4`` NDOF Button 4, NdofB4. * ``NDOF_BUTTON_5`` NDOF Button 5, NdofB5. * ``NDOF_BUTTON_6`` NDOF Button 6, NdofB6. * ``NDOF_BUTTON_7`` NDOF Button 7, NdofB7. * ``NDOF_BUTTON_8`` NDOF Button 8, NdofB8. * ``NDOF_BUTTON_9`` NDOF Button 9, NdofB9. * ``NDOF_BUTTON_10`` NDOF Button 10, NdofB10. * ``NDOF_BUTTON_A`` NDOF Button A, NdofBA. * ``NDOF_BUTTON_B`` NDOF Button B, NdofBB. * ``NDOF_BUTTON_C`` NDOF Button C, NdofBC.

    :type: typing.Union[str, int]
    '''

    value: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    def compare(self, item: typing.Optional['KeyMapItem']) -> bool:
        ''' compare

        :param item: Item
        :type item: typing.Optional['KeyMapItem']
        :rtype: bool
        :return: Comparison result
        '''
        pass


class Keyframe(bpy_struct):
    ''' Bezier curve point with two handles defining a Keyframe on an F-Curve
    '''

    amplitude: float = None
    ''' Amount to boost elastic bounces for 'elastic' easing

    :type: float
    '''

    back: float = None
    ''' Amount of overshoot for 'back' easing

    :type: float
    '''

    co: bpy_prop_array[float] = None
    ''' Coordinates of the control point

    :type: bpy_prop_array[float]
    '''

    easing: typing.Union[str, int] = None
    ''' Which ends of the segment between this and the next keyframe easing interpolation is applied to * ``AUTO`` Automatic Easing, Easing type is chosen automatically based on what the type of interpolation used (e.g. 'Ease In' for transitional types, and 'Ease Out' for dynamic effects). * ``EASE_IN`` Ease In, Only on the end closest to the next keyframe. * ``EASE_OUT`` Ease Out, Only on the end closest to the first keyframe. * ``EASE_IN_OUT`` Ease In and Out, Segment between both keyframes.

    :type: typing.Union[str, int]
    '''

    handle_left: bpy_prop_array[float] = None
    ''' Coordinates of the left handle (before the control point)

    :type: bpy_prop_array[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle types * ``FREE`` Free. * ``VECTOR`` Vector. * ``ALIGNED`` Aligned. * ``AUTO`` Automatic. * ``AUTO_CLAMPED`` Auto Clamped, Auto handles clamped to not overshoot.

    :type: typing.Union[str, int]
    '''

    handle_right: bpy_prop_array[float] = None
    ''' Coordinates of the right handle (after the control point)

    :type: bpy_prop_array[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle types * ``FREE`` Free. * ``VECTOR`` Vector. * ``ALIGNED`` Aligned. * ``AUTO`` Automatic. * ``AUTO_CLAMPED`` Auto Clamped, Auto handles clamped to not overshoot.

    :type: typing.Union[str, int]
    '''

    interpolation: typing.Union[str, int] = None
    ''' Interpolation method to use for segment of the F-Curve from this Keyframe until the next Keyframe * ``CONSTANT`` Constant, No interpolation, value of A gets held until B is encountered. * ``LINEAR`` Linear, Straight-line interpolation between A and B (i.e. no ease in/out). * ``BEZIER`` Bezier, Smooth interpolation between A and B, with some control over curve shape. * ``SINE`` Sinusoidal, Sinusoidal easing (weakest, almost linear but with a slight curvature). * ``QUAD`` Quadratic, Quadratic easing. * ``CUBIC`` Cubic, Cubic easing. * ``QUART`` Quartic, Quartic easing. * ``QUINT`` Quintic, Quintic easing. * ``EXPO`` Exponential, Exponential easing (dramatic). * ``CIRC`` Circular, Circular easing (strongest and most dynamic). * ``BACK`` Back, Cubic easing with overshoot and settle. * ``BOUNCE`` Bounce, Exponentially decaying parabolic bounce, like when objects collide. * ``ELASTIC`` Elastic, Exponentially decaying sine wave, like an elastic band.

    :type: typing.Union[str, int]
    '''

    period: float = None
    ''' Time between bounces for elastic easing

    :type: float
    '''

    select_control_point: bool = None
    ''' Control point selection status

    :type: bool
    '''

    select_left_handle: bool = None
    ''' Left handle selection status

    :type: bool
    '''

    select_right_handle: bool = None
    ''' Right handle selection status

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Type of keyframe (for visual purposes only) * ``KEYFRAME`` Keyframe, Normal keyframe - e.g. for key poses. * ``BREAKDOWN`` Breakdown, A breakdown pose - e.g. for transitions between key poses. * ``MOVING_HOLD`` Moving Hold, A keyframe that is part of a moving hold. * ``EXTREME`` Extreme, An 'extreme' pose, or some other purpose as needed. * ``JITTER`` Jitter, A filler or baked keyframe for keying on ones, or some other purpose as needed.

    :type: typing.Union[str, int]
    '''


class KeyingSet(bpy_struct):
    ''' Settings that should be keyframed together
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' A short description of the keying set

    :type: typing.Union[str, typing.Any]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    is_path_absolute: typing.Union[bool, typing.Any] = None
    ''' Keying Set defines specific paths/settings to be keyframed (i.e. is not reliant on context info)

    :type: typing.Union[bool, typing.Any]
    '''

    paths: 'KeyingSetPaths' = None
    ''' Keying Set Paths to define settings that get keyframed together

    :type: 'KeyingSetPaths'
    '''

    type_info: 'KeyingSetInfo' = None
    ''' Callback function defines for built-in Keying Sets

    :type: 'KeyingSetInfo'
    '''

    use_insertkey_needed: bool = None
    ''' Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_needed: bool = None
    ''' Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_visual: bool = None
    ''' Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_override_xyz_to_rgb: bool = None
    ''' Override default setting to set color for newly added transformation F-Curves (Location, Rotation, Scale) to be based on the transform axis

    :type: bool
    '''

    use_insertkey_visual: bool = None
    ''' Insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis

    :type: bool
    '''

    def refresh(self):
        ''' Refresh Keying Set to ensure that it is valid for the current context (call before each use of one)

        '''
        pass


class KeyingSetInfo(bpy_struct):
    ''' Callback function defines for builtin Keying Sets
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' A short description of the keying set

    :type: typing.Union[str, typing.Any]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Keying Set options to use when inserting keyframes * ``INSERTKEY_NEEDED`` Only Needed, Only insert keyframes where they're needed in the relevant F-Curves. * ``INSERTKEY_VISUAL`` Visual Keying, Insert keyframes based on 'visual transforms'. * ``INSERTKEY_XYZ_TO_RGB`` XYZ=RGB Colors, Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    def poll(self, context: typing.Optional['Context']) -> bool:
        ''' Test if Keying Set can be used or not

        :param context: 
        :type context: typing.Optional['Context']
        :rtype: bool
        '''
        pass

    def iterator(self, context: typing.Optional['Context'],
                 ks: typing.Optional['KeyingSet']):
        ''' Call generate() on the structs which have properties to be keyframed

        :param context: 
        :type context: typing.Optional['Context']
        :param ks: 
        :type ks: typing.Optional['KeyingSet']
        '''
        pass

    def generate(self, context: typing.Optional['Context'],
                 ks: typing.Optional['KeyingSet'], data: typing.Any):
        ''' Add Paths to the Keying Set to keyframe the properties of the given data

        :param context: 
        :type context: typing.Optional['Context']
        :param ks: 
        :type ks: typing.Optional['KeyingSet']
        :param data: 
        :type data: typing.Any
        '''
        pass


class KeyingSetPath(bpy_struct):
    ''' Path to a setting for use in a Keying Set
    '''

    array_index: int = None
    ''' Index to the specific setting if applicable

    :type: int
    '''

    data_path: typing.Union[str, typing.Any] = None
    ''' Path to property setting

    :type: typing.Union[str, typing.Any]
    '''

    group: typing.Union[str, typing.Any] = None
    ''' Name of Action Group to assign setting(s) for this path to

    :type: typing.Union[str, typing.Any]
    '''

    group_method: typing.Union[str, int] = None
    ''' Method used to define which Group-name to use

    :type: typing.Union[str, int]
    '''

    id: 'ID' = None
    ''' ID-Block that keyframes for Keying Set should be added to (for Absolute Keying Sets only)

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    use_entire_array: bool = None
    ''' When an 'array/vector' type is chosen (Location, Rotation, Color, etc.), entire array is to be used

    :type: bool
    '''

    use_insertkey_needed: bool = None
    ''' Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_needed: bool = None
    ''' Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    '''

    use_insertkey_override_visual: bool = None
    ''' Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_override_xyz_to_rgb: bool = None
    ''' Override default setting to set color for newly added transformation F-Curves (Location, Rotation, Scale) to be based on the transform axis

    :type: bool
    '''

    use_insertkey_visual: bool = None
    ''' Insert keyframes based on 'visual transforms'

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis

    :type: bool
    '''


class LampSkySettings(bpy_struct):
    ''' Sky related settings for a sun lamp
    '''

    atmosphere_distance_factor: float = None
    ''' Multiplier to convert blender units to physical distance

    :type: float
    '''

    atmosphere_extinction: float = None
    ''' Extinction scattering contribution factor

    :type: float
    '''

    atmosphere_inscattering: float = None
    ''' Scatter contribution factor

    :type: float
    '''

    atmosphere_turbidity: float = None
    ''' Sky turbidity

    :type: float
    '''

    backscattered_light: float = None
    ''' Backscattered light

    :type: float
    '''

    horizon_brightness: float = None
    ''' Horizon brightness

    :type: float
    '''

    sky_blend: float = None
    ''' Blend factor with sky

    :type: float
    '''

    sky_blend_type: typing.Union[str, int] = None
    ''' Blend mode for combining sun sky with world sky

    :type: typing.Union[str, int]
    '''

    sky_color_space: typing.Union[str, int] = None
    ''' Color space to use for internal XYZ->RGB color conversion

    :type: typing.Union[str, int]
    '''

    sky_exposure: float = None
    ''' Strength of sky shading exponential exposure correction

    :type: float
    '''

    spread: float = None
    ''' Horizon Spread

    :type: float
    '''

    sun_brightness: float = None
    ''' Sun brightness

    :type: float
    '''

    sun_intensity: float = None
    ''' Sun intensity

    :type: float
    '''

    sun_size: float = None
    ''' Sun size

    :type: float
    '''

    use_atmosphere: bool = None
    ''' Apply sun effect on atmosphere

    :type: bool
    '''

    use_sky: bool = None
    ''' Apply sun effect on sky

    :type: bool
    '''


class LatticePoint(bpy_struct):
    ''' Point in the lattice grid
    '''

    co: bpy_prop_array[float] = None
    ''' Original undeformed location used to calculate the strength of the deform effect (edit/animate the Deformed Location instead)

    :type: bpy_prop_array[float]
    '''

    co_deform: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    groups: bpy_prop_collection['VertexGroupElement'] = None
    ''' Weights for the vertex groups this point is member of

    :type: bpy_prop_collection['VertexGroupElement']
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''


class LineStyleModifier(bpy_struct):
    ''' Base type to define modifiers
    '''

    pass


class LodLevel(bpy_struct):
    distance: float = None
    ''' Distance to begin using this level of detail

    :type: float
    '''

    object: 'Object' = None
    ''' Object to use for this level of detail

    :type: 'Object'
    '''

    object_hysteresis_percentage: int = None
    ''' Minimum distance change required to transition to the previous level of detail

    :type: int
    '''

    use_material: bool = None
    ''' Use the material from this object at this level of detail

    :type: bool
    '''

    use_mesh: bool = None
    ''' Use the mesh from this object at this level of detail

    :type: bool
    '''

    use_object_hysteresis: bool = None
    ''' Override LoD Hysteresis scene setting for this LoD level

    :type: bool
    '''


class Macro(bpy_struct):
    ''' Storage of a macro operator being executed, or registered after execution
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this operator type * ``REGISTER`` Register, Display in the info window and support the redo toolbar panel. * ``UNDO`` Undo, Push an undo event (needed for operator redo). * ``BLOCKING`` Blocking, Block anything else from using the cursor. * ``MACRO`` Macro, Use to check if an operator is a macro. * ``GRAB_CURSOR`` Grab Pointer, Use so the operator grabs the mouse focus, enables wrapping when continuous grab is enabled. * ``PRESET`` Preset, Display a preset button with the operators settings. * ``INTERNAL`` Internal, Removes the operator from search results.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_translation_context: str = None
    ''' 

    :type: str
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''

    def report(self, type: typing.Optional[
            typing.Union[typing.Set[str], typing.Set[int]]],
               message: typing.Union[str, typing.Any]):
        ''' report

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[str], typing.Set[int]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        '''
        pass

    @classmethod
    def poll(cls, context: 'Context') -> bool:
        ''' Test if the operator can be called or not

        :param context: 
        :type context: 'Context'
        :rtype: bool
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw function for the operator

        :param context: 
        :type context: 'Context'
        '''
        pass


class MaskLayer(bpy_struct):
    ''' Single layer used for masking pixels
    '''

    alpha: float = None
    ''' Render Opacity

    :type: float
    '''

    blend: typing.Union[str, int] = None
    ''' Method of blending mask layers

    :type: typing.Union[str, int]
    '''

    falloff: typing.Union[str, int] = None
    ''' Falloff type the feather * ``SMOOTH`` Smooth, Smooth falloff. * ``SPHERE`` Sphere, Spherical falloff. * ``ROOT`` Root, Root falloff. * ``INVERSE_SQUARE`` Inverse Square, Inverse Square falloff. * ``SHARP`` Sharp, Sharp falloff. * ``LINEAR`` Linear, Linear falloff.

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    ''' Restrict visibility in the viewport

    :type: bool
    '''

    hide_render: bool = None
    ''' Restrict renderability

    :type: bool
    '''

    hide_select: bool = None
    ''' Restrict selection in the viewport

    :type: bool
    '''

    invert: bool = None
    ''' Invert the mask black/white

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name of layer

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' Layer is selected for editing in the Dope Sheet

    :type: bool
    '''

    splines: 'MaskSplines' = None
    ''' Collection of splines which defines this layer

    :type: 'MaskSplines'
    '''

    use_fill_holes: bool = None
    ''' Calculate holes when filling overlapping curves

    :type: bool
    '''

    use_fill_overlap: bool = None
    ''' Calculate self intersections and overlap before filling

    :type: bool
    '''


class MaskParent(bpy_struct):
    ''' Parenting settings for masking element
    '''

    id: 'ID' = None
    ''' ID-block to which masking element would be parented to or to it's property

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    ''' Type of ID-block that can be used

    :type: typing.Union[str, int]
    '''

    parent: typing.Union[str, typing.Any] = None
    ''' Name of parent object in specified data block to which parenting happens

    :type: typing.Union[str, typing.Any]
    '''

    sub_parent: typing.Union[str, typing.Any] = None
    ''' Name of parent sub-object in specified data block to which parenting happens

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' Parent Type

    :type: typing.Union[str, int]
    '''


class MaskSpline(bpy_struct):
    ''' Single spline used for defining mask shape
    '''

    offset_mode: typing.Union[str, int] = None
    ''' The method used for calculating the feather offset * ``EVEN`` Even, Calculate even feather offset. * ``SMOOTH`` Smooth, Calculate feather offset as a second curve.

    :type: typing.Union[str, int]
    '''

    points: 'MaskSplinePoints' = None
    ''' Collection of points

    :type: 'MaskSplinePoints'
    '''

    use_cyclic: bool = None
    ''' Make this spline a closed loop

    :type: bool
    '''

    use_fill: bool = None
    ''' Make this spline filled

    :type: bool
    '''

    use_self_intersection_check: bool = None
    ''' Prevent feather from self-intersections

    :type: bool
    '''

    weight_interpolation: typing.Union[str, int] = None
    ''' The type of weight interpolation for spline

    :type: typing.Union[str, int]
    '''


class MaskSplinePoint(bpy_struct):
    ''' Single point in spline used for defining mask
    '''

    co: bpy_prop_array[float] = None
    ''' Coordinates of the control point

    :type: bpy_prop_array[float]
    '''

    feather_points: bpy_prop_collection['MaskSplinePointUW'] = None
    ''' Points defining feather

    :type: bpy_prop_collection['MaskSplinePointUW']
    '''

    handle_left: bpy_prop_array[float] = None
    ''' Coordinates of the first handle

    :type: bpy_prop_array[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    handle_right: bpy_prop_array[float] = None
    ''' Coordinates of the second handle

    :type: bpy_prop_array[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    handle_type: typing.Union[str, int] = None
    ''' Handle type

    :type: typing.Union[str, int]
    '''

    parent: 'MaskParent' = None
    ''' 

    :type: 'MaskParent'
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    weight: float = None
    ''' Weight of the point

    :type: float
    '''


class MaskSplinePointUW(bpy_struct):
    ''' Single point in spline segment defining feather
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    u: float = None
    ''' U coordinate of point along spline segment

    :type: float
    '''

    weight: float = None
    ''' Weight of feather point

    :type: float
    '''


class MaterialGameSettings(bpy_struct):
    ''' Game Engine settings for a Material data-block
    '''

    alpha_blend: typing.Union[str, int] = None
    ''' Blend Mode for Transparent Faces * ``OPAQUE`` Opaque, Render color of textured face as color. * ``ADD`` Add, Render face transparent and add color of face. * ``CLIP`` Alpha Clip, Use the image alpha values clipped with no blending (binary alpha). * ``ALPHA`` Alpha Blend, Render polygon transparent, depending on alpha channel of the texture. * ``ALPHA_SORT`` Alpha Sort, Sort faces for correct alpha drawing (slow, use Alpha Clip instead when possible). * ``ALPHA_ANTIALIASING`` Alpha Anti-Aliasing, Use textures alpha as anti-aliasing mask, requires multi-sample OpenGL display.

    :type: typing.Union[str, int]
    '''

    face_orientation: typing.Union[str, int] = None
    ''' Especial face orientation options * ``NORMAL`` Normal, No transformation. * ``HALO`` Halo, Screen aligned billboard. * ``BILLBOARD`` Billboard, Billboard with Z-axis constraint. * ``SHADOW`` Shadow, Faces are used for shadow.

    :type: typing.Union[str, int]
    '''

    invisible: bool = None
    ''' Make face invisible

    :type: bool
    '''

    physics: bool = None
    ''' Use physics properties of materials

    :type: bool
    '''

    text: bool = None
    ''' Use material as text in Game Engine

    :type: bool
    '''

    use_backface_culling: bool = None
    ''' Hide Back of the face in Game Engine

    :type: bool
    '''


class MaterialHalo(bpy_struct):
    ''' Halo particle effect settings for a Material data-block
    '''

    add: float = None
    ''' Strength of the add effect

    :type: float
    '''

    flare_boost: float = None
    ''' Give the flare extra strength

    :type: float
    '''

    flare_seed: int = None
    ''' Offset in the flare seed table

    :type: int
    '''

    flare_size: float = None
    ''' Factor by which the flare is larger than the halo

    :type: float
    '''

    flare_subflare_count: int = None
    ''' Number of sub-flares

    :type: int
    '''

    flare_subflare_size: float = None
    ''' Dimension of the sub-flares, dots and circles

    :type: float
    '''

    hardness: int = None
    ''' Hardness of the halo

    :type: int
    '''

    line_count: int = None
    ''' Number of star shaped lines rendered over the halo

    :type: int
    '''

    ring_count: int = None
    ''' Number of rings rendered over the halo

    :type: int
    '''

    seed: int = None
    ''' Randomize ring dimension and line location

    :type: int
    '''

    size: float = None
    ''' Dimension of the halo

    :type: float
    '''

    star_tip_count: int = None
    ''' Number of points on the star shaped halo

    :type: int
    '''

    use_extreme_alpha: bool = None
    ''' Use extreme alpha

    :type: bool
    '''

    use_flare_mode: bool = None
    ''' Render halo as a lens flare

    :type: bool
    '''

    use_lines: bool = None
    ''' Render star shaped lines over halo

    :type: bool
    '''

    use_ring: bool = None
    ''' Render rings over halo

    :type: bool
    '''

    use_shaded: bool = None
    ''' Let halo receive light and shadows from external objects

    :type: bool
    '''

    use_soft: bool = None
    ''' Soften the edges of halos at intersections with other geometry

    :type: bool
    '''

    use_star: bool = None
    ''' Render halo as a star

    :type: bool
    '''

    use_texture: bool = None
    ''' Give halo a texture

    :type: bool
    '''

    use_vertex_normal: bool = None
    ''' Use the vertex normal to specify the dimension of the halo

    :type: bool
    '''


class MaterialPhysics(bpy_struct):
    ''' Physics settings for a Material data-block
    '''

    elasticity: float = None
    ''' Elasticity of collisions

    :type: float
    '''

    fh_damping: float = None
    ''' Damping of the spring force, when inside the physics distance area

    :type: float
    '''

    fh_distance: float = None
    ''' Distance of the physics area

    :type: float
    '''

    fh_force: float = None
    ''' Upward spring force, when inside the physics distance area

    :type: float
    '''

    friction: float = None
    ''' Coulomb friction coefficient, when inside the physics distance area

    :type: float
    '''

    use_fh_normal: bool = None
    ''' Align dynamic game objects along the surface normal, when inside the physics distance area

    :type: bool
    '''


class MaterialRaytraceMirror(bpy_struct):
    ''' Raytraced reflection settings for a Material data-block
    '''

    depth: int = None
    ''' Maximum allowed number of light inter-reflections

    :type: int
    '''

    distance: float = None
    ''' Maximum distance of reflected rays (reflections further than this range fade to sky color or material color)

    :type: float
    '''

    fade_to: typing.Union[str, int] = None
    ''' The color that rays with no intersection within the Max Distance take (material color can be best for indoor scenes, sky color for outdoor)

    :type: typing.Union[str, int]
    '''

    fresnel: float = None
    ''' Power of Fresnel for mirror reflection

    :type: float
    '''

    fresnel_factor: float = None
    ''' Blending factor for Fresnel

    :type: float
    '''

    gloss_anisotropic: float = None
    ''' The shape of the reflection, from 0.0 (circular) to 1.0 (fully stretched along the tangent

    :type: float
    '''

    gloss_factor: float = None
    ''' The shininess of the reflection (values < 1.0 give diffuse, blurry reflections)

    :type: float
    '''

    gloss_samples: int = None
    ''' Number of cone samples averaged for blurry reflections

    :type: int
    '''

    gloss_threshold: float = None
    ''' Threshold for adaptive sampling (if a sample contributes less than this amount [as a percentage], sampling is stopped)

    :type: float
    '''

    reflect_factor: float = None
    ''' Amount of mirror reflection for raytrace

    :type: float
    '''

    use: bool = None
    ''' Enable raytraced reflections

    :type: bool
    '''


class MaterialRaytraceTransparency(bpy_struct):
    ''' Raytraced refraction settings for a Material data-block
    '''

    depth: int = None
    ''' Maximum allowed number of light inter-refractions

    :type: int
    '''

    depth_max: float = None
    ''' Maximum depth for light to travel through the transparent material before becoming fully filtered (0.0 is disabled)

    :type: float
    '''

    falloff: float = None
    ''' Falloff power for transmissivity filter effect (1.0 is linear)

    :type: float
    '''

    filter: float = None
    ''' Amount to blend in the material's diffuse color in raytraced transparency (simulating absorption)

    :type: float
    '''

    fresnel: float = None
    ''' Power of Fresnel for transparency (Ray or ZTransp)

    :type: float
    '''

    fresnel_factor: float = None
    ''' Blending factor for Fresnel

    :type: float
    '''

    gloss_factor: float = None
    ''' The clarity of the refraction. Values < 1.0 give diffuse, blurry refractions

    :type: float
    '''

    gloss_samples: int = None
    ''' Number of cone samples averaged for blurry refractions

    :type: int
    '''

    gloss_threshold: float = None
    ''' Threshold for adaptive sampling. If a sample contributes less than this amount (as a percentage), sampling is stopped

    :type: float
    '''

    ior: float = None
    ''' Angular index of refraction for raytraced refraction

    :type: float
    '''


class MaterialSlot(bpy_struct):
    ''' Material slot in an object
    '''

    link: typing.Union[str, int] = None
    ''' Link material to object or the object's data

    :type: typing.Union[str, int]
    '''

    material: 'Material' = None
    ''' Material data-block used by this material slot

    :type: 'Material'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Material slot name

    :type: typing.Union[str, typing.Any]
    '''


class MaterialStrand(bpy_struct):
    ''' Strand settings for a Material data-block
    '''

    blend_distance: float = None
    ''' Worldspace distance over which to blend in the surface normal

    :type: float
    '''

    root_size: float = None
    ''' Start size of strands in pixels or Blender units

    :type: float
    '''

    shape: float = None
    ''' Positive values make strands rounder, negative ones make strands spiky

    :type: float
    '''

    size_min: float = None
    ''' Minimum size of strands in pixels

    :type: float
    '''

    tip_size: float = None
    ''' End size of strands in pixels or Blender units

    :type: float
    '''

    use_blender_units: bool = None
    ''' Use Blender units for widths instead of pixels

    :type: bool
    '''

    use_surface_diffuse: typing.Union[bool, typing.Any] = None
    ''' Make diffuse shading more similar to shading the surface

    :type: typing.Union[bool, typing.Any]
    '''

    use_tangent_shading: bool = None
    ''' Use direction of strands as normal for tangent-shading

    :type: bool
    '''

    uv_layer: typing.Union[str, typing.Any] = None
    ''' Name of UV map to override

    :type: typing.Union[str, typing.Any]
    '''

    width_fade: float = None
    ''' Transparency along the width of the strand

    :type: float
    '''


class MaterialSubsurfaceScattering(bpy_struct):
    ''' Diffuse subsurface scattering settings for a Material data-block
    '''

    back: float = None
    ''' Back scattering weight

    :type: float
    '''

    color: bpy_prop_array[float] = None
    ''' Scattering color

    :type: bpy_prop_array[float]
    '''

    color_factor: float = None
    ''' Blend factor for SSS colors

    :type: float
    '''

    error_threshold: float = None
    ''' Error tolerance (low values are slower and higher quality)

    :type: float
    '''

    front: float = None
    ''' Front scattering weight

    :type: float
    '''

    ior: float = None
    ''' Index of refraction (higher values are denser)

    :type: float
    '''

    radius: bpy_prop_array[float] = None
    ''' Mean red/green/blue scattering path length

    :type: bpy_prop_array[float]
    '''

    scale: float = None
    ''' Object scale factor

    :type: float
    '''

    texture_factor: float = None
    ''' Texture scattering blend factor

    :type: float
    '''

    use: bool = None
    ''' Enable diffuse subsurface scattering effects in a material

    :type: bool
    '''


class MaterialVolume(bpy_struct):
    ''' Volume rendering settings for a Material data-block
    '''

    asymmetry: float = None
    ''' Back scattering (-1.0) to Forward scattering (1.0) and the range in between

    :type: float
    '''

    cache_resolution: int = None
    ''' Resolution of the voxel grid, low resolutions are faster, high resolutions use more memory

    :type: int
    '''

    density: float = None
    ''' The base density of the volume

    :type: float
    '''

    density_scale: float = None
    ''' Multiplier for the material's density

    :type: float
    '''

    depth_threshold: float = None
    ''' Stop ray marching early if transmission drops below this luminance - higher values give speedups in dense volumes at the expense of accuracy

    :type: float
    '''

    emission: float = None
    ''' Amount of light that gets emitted by the volume

    :type: float
    '''

    emission_color: bpy_prop_array[float] = None
    ''' Color of emitted light

    :type: bpy_prop_array[float]
    '''

    light_method: typing.Union[str, int] = None
    ''' Method of shading, attenuating, and scattering light through the volume * ``SHADELESS`` Shadeless, Do not calculate lighting and shadows. * ``SHADOWED`` Shadowed. * ``SHADED`` Shaded. * ``MULTIPLE_SCATTERING`` Multiple Scattering. * ``SHADED_PLUS_MULTIPLE_SCATTERING`` Shaded + Multiple Scattering.

    :type: typing.Union[str, int]
    '''

    ms_diffusion: float = None
    ''' Diffusion factor, the strength of the blurring effect

    :type: float
    '''

    ms_intensity: float = None
    ''' Multiplier for multiple scattered light energy

    :type: float
    '''

    ms_spread: float = None
    ''' Proportional distance over which the light is diffused

    :type: float
    '''

    reflection: float = None
    ''' Multiplier to make out-scattered light brighter or darker (non-physically correct)

    :type: float
    '''

    reflection_color: bpy_prop_array[float] = None
    ''' Color of light scattered out of the volume (does not affect transmission)

    :type: bpy_prop_array[float]
    '''

    scattering: float = None
    ''' Amount of light that gets scattered out by the volume - the more out-scattering, the shallower the light will penetrate

    :type: float
    '''

    step_method: typing.Union[str, int] = None
    ''' Method of calculating the steps through the volume

    :type: typing.Union[str, int]
    '''

    step_size: float = None
    ''' Distance between subsequent volume depth samples

    :type: float
    '''

    transmission_color: bpy_prop_array[float] = None
    ''' Result color of the volume, after other light has been scattered/absorbed

    :type: bpy_prop_array[float]
    '''

    use_external_shadows: bool = None
    ''' Receive shadows from sources outside the volume (temporary)

    :type: bool
    '''

    use_light_cache: bool = None
    ''' Pre-calculate the shading information into a voxel grid, speeds up shading at slightly less accuracy

    :type: bool
    '''


class Menu(bpy_struct):
    ''' Editor menu containing buttons
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the menu gets a custom ID, otherwise it takes the name of the class used to define the menu (for example, if the class name is "OBJECT_MT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_MT_hello")

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' The menu label

    :type: typing.Union[str, typing.Any]
    '''

    bl_translation_context: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    layout: 'UILayout' = None
    ''' Defines the structure of the menu in the UI

    :type: 'UILayout'
    '''

    @classmethod
    def poll(cls, context: typing.Optional['Context']) -> bool:
        ''' If this method returns a non-null output, then the menu can be drawn

        :param context: 
        :type context: typing.Optional['Context']
        :rtype: bool
        '''
        pass

    def draw(self, context: typing.Optional['Context']):
        ''' Draw UI elements into the menu UI layout

        :param context: 
        :type context: typing.Optional['Context']
        '''
        pass

    def draw_preset(self, context):
        ''' Define these on the subclass: - preset_operator (string) - preset_subdir (string) Optionally: - preset_extensions (set of strings) - preset_operator_defaults (dict of keyword args)

        '''
        pass

    def path_menu(self,
                  searchpaths,
                  operator,
                  props_default=None,
                  filter_ext=None):
        ''' 

        '''
        pass

    @classmethod
    def append(cls, draw_func):
        ''' 

        '''
        pass

    @classmethod
    def prepend(cls, draw_func):
        ''' 

        '''
        pass

    @classmethod
    def remove(cls, draw_func):
        ''' 

        '''
        pass


class MeshColor(bpy_struct):
    ''' Vertex colors for a face in a Mesh
    '''

    color1: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    color2: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    color3: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    color4: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class MeshColorLayer(bpy_struct):
    ''' Layer of vertex colors in a Mesh data-block
    '''

    active: bool = None
    ''' Sets the layer as active for display and editing

    :type: bool
    '''

    active_render: bool = None
    ''' Sets the layer as active for rendering

    :type: bool
    '''

    data: bpy_prop_collection['MeshColor'] = None
    ''' 

    :type: bpy_prop_collection['MeshColor']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of Vertex color layer

    :type: typing.Union[str, typing.Any]
    '''


class MeshEdge(bpy_struct):
    ''' Edge in a Mesh data-block
    '''

    bevel_weight: float = None
    ''' Weight used by the Bevel modifier

    :type: float
    '''

    crease: float = None
    ''' Weight used by the Subsurf modifier for creasing

    :type: float
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this edge

    :type: int
    '''

    is_loose: bool = None
    ''' Loose edge

    :type: bool
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    use_edge_sharp: bool = None
    ''' Sharp edge for the EdgeSplit modifier

    :type: bool
    '''

    use_freestyle_mark: bool = None
    ''' Edge mark for Freestyle line rendering

    :type: bool
    '''

    use_seam: bool = None
    ''' Seam edge for UV unwrapping

    :type: bool
    '''

    vertices: bpy_prop_array[int] = None
    ''' Vertex indices

    :type: bpy_prop_array[int]
    '''

    key = None
    ''' (readonly)'''


class MeshLoop(bpy_struct):
    ''' Loop in a Mesh data-block
    '''

    bitangent: bpy_prop_array[float] = None
    ''' Bitangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents, *use it only if really needed*, slower access than bitangent_sign)

    :type: bpy_prop_array[float]
    '''

    bitangent_sign: float = None
    ''' Sign of the bitangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents, bitangent = bitangent_sign * cross(normal, tangent))

    :type: float
    '''

    edge_index: int = None
    ''' Edge index

    :type: int
    '''

    index: int = None
    ''' Index of this loop

    :type: int
    '''

    normal: bpy_prop_array[float] = None
    ''' Local space unit length split normal vector of this vertex for this polygon (must be computed beforehand using calc_normals_split or calc_tangents)

    :type: bpy_prop_array[float]
    '''

    tangent: bpy_prop_array[float] = None
    ''' Local space unit length tangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents)

    :type: bpy_prop_array[float]
    '''

    vertex_index: int = None
    ''' Vertex index

    :type: int
    '''


class MeshLoopColor(bpy_struct):
    ''' Vertex loop colors in a Mesh
    '''

    color: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class MeshLoopColorLayer(bpy_struct):
    ''' Layer of vertex colors in a Mesh data-block
    '''

    active: bool = None
    ''' Sets the layer as active for display and editing

    :type: bool
    '''

    active_render: bool = None
    ''' Sets the layer as active for rendering

    :type: bool
    '''

    data: bpy_prop_collection['MeshLoopColor'] = None
    ''' 

    :type: bpy_prop_collection['MeshLoopColor']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of Vertex color layer

    :type: typing.Union[str, typing.Any]
    '''


class MeshPaintMaskLayer(bpy_struct):
    ''' Per-vertex paint mask data
    '''

    data: bpy_prop_collection['MeshPaintMaskProperty'] = None
    ''' 

    :type: bpy_prop_collection['MeshPaintMaskProperty']
    '''


class MeshPaintMaskProperty(bpy_struct):
    ''' Floating point paint mask value
    '''

    value: float = None
    ''' 

    :type: float
    '''


class MeshPolygon(bpy_struct):
    ''' Polygon in a Mesh data-block
    '''

    area: float = None
    ''' Read only area of this polygon

    :type: float
    '''

    center: bpy_prop_array[float] = None
    ''' Center of this polygon

    :type: bpy_prop_array[float]
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this polygon

    :type: int
    '''

    loop_start: int = None
    ''' Index of the first loop of this polygon

    :type: int
    '''

    loop_total: int = None
    ''' Number of loops used by this polygon

    :type: int
    '''

    material_index: int = None
    ''' 

    :type: int
    '''

    normal: bpy_prop_array[float] = None
    ''' Local space unit length normal vector for this polygon

    :type: bpy_prop_array[float]
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    use_freestyle_mark: bool = None
    ''' Face mark for Freestyle line rendering

    :type: bool
    '''

    use_smooth: bool = None
    ''' 

    :type: bool
    '''

    vertices: bpy_prop_array[int] = None
    ''' Vertex indices

    :type: bpy_prop_array[int]
    '''

    edge_keys = None
    ''' (readonly)'''

    loop_indices = None
    ''' (readonly)'''

    def flip(self):
        ''' Invert winding of this polygon (flip its normal)

        '''
        pass


class MeshPolygonFloatProperty(bpy_struct):
    ''' User defined floating point number value in a float properties layer
    '''

    value: float = None
    ''' 

    :type: float
    '''


class MeshPolygonFloatPropertyLayer(bpy_struct):
    ''' User defined layer of floating point number values
    '''

    data: bpy_prop_collection['MeshPolygonFloatProperty'] = None
    ''' 

    :type: bpy_prop_collection['MeshPolygonFloatProperty']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class MeshPolygonIntProperty(bpy_struct):
    ''' User defined integer number value in an integer properties layer
    '''

    value: int = None
    ''' 

    :type: int
    '''


class MeshPolygonIntPropertyLayer(bpy_struct):
    ''' User defined layer of integer number values
    '''

    data: bpy_prop_collection['MeshPolygonIntProperty'] = None
    ''' 

    :type: bpy_prop_collection['MeshPolygonIntProperty']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class MeshPolygonStringProperty(bpy_struct):
    ''' User defined string text value in a string properties layer
    '''

    value: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class MeshPolygonStringPropertyLayer(bpy_struct):
    ''' User defined layer of string text values
    '''

    data: bpy_prop_collection['MeshPolygonStringProperty'] = None
    ''' 

    :type: bpy_prop_collection['MeshPolygonStringProperty']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class MeshSkinVertex(bpy_struct):
    ''' Per-vertex skin data for use with the Skin modifier
    '''

    radius: bpy_prop_array[float] = None
    ''' Radius of the skin

    :type: bpy_prop_array[float]
    '''

    use_loose: bool = None
    ''' If vertex has multiple adjacent edges, it is hulled to them directly

    :type: bool
    '''

    use_root: bool = None
    ''' Vertex is a root for rotation calculations and armature generation

    :type: bool
    '''


class MeshSkinVertexLayer(bpy_struct):
    ''' Per-vertex skin data for use with the Skin modifier
    '''

    data: bpy_prop_collection['MeshSkinVertex'] = None
    ''' 

    :type: bpy_prop_collection['MeshSkinVertex']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of skin layer

    :type: typing.Union[str, typing.Any]
    '''


class MeshStatVis(bpy_struct):
    distort_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    distort_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    overhang_axis: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    overhang_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    overhang_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    sharp_max: float = None
    ''' Maximum angle to display

    :type: float
    '''

    sharp_min: float = None
    ''' Minimum angle to display

    :type: float
    '''

    thickness_max: float = None
    ''' Maximum for measuring thickness

    :type: float
    '''

    thickness_min: float = None
    ''' Minimum for measuring thickness

    :type: float
    '''

    thickness_samples: int = None
    ''' Number of samples to test per face

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Type of data to visualize/check

    :type: typing.Union[str, int]
    '''


class MeshTessFace(bpy_struct):
    ''' TessFace in a Mesh data-block
    '''

    area: float = None
    ''' Read only area of this face

    :type: float
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this face

    :type: int
    '''

    material_index: int = None
    ''' 

    :type: int
    '''

    normal: bpy_prop_array[float] = None
    ''' Local space unit length normal vector for this face

    :type: bpy_prop_array[float]
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    split_normals: bpy_prop_array[float] = None
    ''' Local space unit length split normals vectors of the vertices of this face (must be computed beforehand using calc_normals_split or calc_tangents, and then calc_tessface)

    :type: bpy_prop_array[float]
    '''

    use_smooth: bool = None
    ''' 

    :type: bool
    '''

    vertices: bpy_prop_array[int] = None
    ''' Vertex indices

    :type: bpy_prop_array[int]
    '''

    vertices_raw: bpy_prop_array[int] = None
    ''' Fixed size vertex indices array

    :type: bpy_prop_array[int]
    '''

    center = None
    ''' The midpoint of the face. (readonly)'''

    edge_keys = None
    ''' (readonly)'''


class MeshTextureFace(bpy_struct):
    ''' UV map and image texture for a face
    '''

    image: 'Image' = None
    ''' 

    :type: 'Image'
    '''

    uv: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    uv1: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    uv2: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    uv3: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    uv4: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    uv_raw: bpy_prop_array[float] = None
    ''' Fixed size UV coordinates array

    :type: bpy_prop_array[float]
    '''


class MeshTextureFaceLayer(bpy_struct):
    ''' UV map with assigned image textures in a Mesh data-block
    '''

    active: bool = None
    ''' Set the map as active for display and editing

    :type: bool
    '''

    active_clone: bool = None
    ''' Set the map as active for cloning

    :type: bool
    '''

    active_render: bool = None
    ''' Set the map as active for rendering

    :type: bool
    '''

    data: bpy_prop_collection['MeshTextureFace'] = None
    ''' 

    :type: bpy_prop_collection['MeshTextureFace']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of UV map

    :type: typing.Union[str, typing.Any]
    '''


class MeshTexturePoly(bpy_struct):
    ''' UV map and image texture for a face
    '''

    image: 'Image' = None
    ''' 

    :type: 'Image'
    '''


class MeshTexturePolyLayer(bpy_struct):
    ''' UV map with assigned image textures in a Mesh data-block
    '''

    active: bool = None
    ''' Set the map as active for display and editing

    :type: bool
    '''

    active_clone: bool = None
    ''' Set the map as active for cloning

    :type: bool
    '''

    active_render: bool = None
    ''' Set the map as active for rendering

    :type: bool
    '''

    data: bpy_prop_collection['MeshTexturePoly'] = None
    ''' 

    :type: bpy_prop_collection['MeshTexturePoly']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of UV map

    :type: typing.Union[str, typing.Any]
    '''


class MeshUVLoop(bpy_struct):
    pin_uv: bool = None
    ''' 

    :type: bool
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_edge: bool = None
    ''' 

    :type: bool
    '''

    uv: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class MeshUVLoopLayer(bpy_struct):
    data: bpy_prop_collection['MeshUVLoop'] = None
    ''' 

    :type: bpy_prop_collection['MeshUVLoop']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of UV map

    :type: typing.Union[str, typing.Any]
    '''


class MeshVertex(bpy_struct):
    ''' Vertex in a Mesh data-block
    '''

    bevel_weight: float = None
    ''' Weight used by the Bevel modifier 'Only Vertices' option

    :type: float
    '''

    co: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    groups: bpy_prop_collection['VertexGroupElement'] = None
    ''' Weights for the vertex groups this vertex is member of

    :type: bpy_prop_collection['VertexGroupElement']
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    index: int = None
    ''' Index of this vertex

    :type: int
    '''

    normal: bpy_prop_array[float] = None
    ''' Vertex Normal

    :type: bpy_prop_array[float]
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    undeformed_co: bpy_prop_array[float] = None
    ''' For meshes with modifiers applied, the coordinate of the vertex with no deforming modifiers applied, as used for generated texture coordinates

    :type: bpy_prop_array[float]
    '''


class MeshVertexFloatProperty(bpy_struct):
    ''' User defined floating point number value in a float properties layer
    '''

    value: float = None
    ''' 

    :type: float
    '''


class MeshVertexFloatPropertyLayer(bpy_struct):
    ''' User defined layer of floating point number values
    '''

    data: bpy_prop_collection['MeshVertexFloatProperty'] = None
    ''' 

    :type: bpy_prop_collection['MeshVertexFloatProperty']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class MeshVertexIntProperty(bpy_struct):
    ''' User defined integer number value in an integer properties layer
    '''

    value: int = None
    ''' 

    :type: int
    '''


class MeshVertexIntPropertyLayer(bpy_struct):
    ''' User defined layer of integer number values
    '''

    data: bpy_prop_collection['MeshVertexIntProperty'] = None
    ''' 

    :type: bpy_prop_collection['MeshVertexIntProperty']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class MeshVertexStringProperty(bpy_struct):
    ''' User defined string text value in a string properties layer
    '''

    value: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class MeshVertexStringPropertyLayer(bpy_struct):
    ''' User defined layer of string text values
    '''

    data: bpy_prop_collection['MeshVertexStringProperty'] = None
    ''' 

    :type: bpy_prop_collection['MeshVertexStringProperty']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class MetaElement(bpy_struct):
    ''' Blobby element in a Metaball data-block
    '''

    co: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    hide: bool = None
    ''' Hide element

    :type: bool
    '''

    radius: float = None
    ''' 

    :type: float
    '''

    rotation: bpy_prop_array[float] = None
    ''' Normalized quaternion rotation

    :type: bpy_prop_array[float]
    '''

    size_x: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    size_y: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    size_z: float = None
    ''' Size of element, use of components depends on element type

    :type: float
    '''

    stiffness: float = None
    ''' Stiffness defines how much of the element to fill

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Metaball types

    :type: typing.Union[str, int]
    '''

    use_negative: bool = None
    ''' Set metaball as negative one

    :type: bool
    '''


class Modifier(bpy_struct):
    ''' Modifier affecting the geometry data of an object
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Modifier name

    :type: typing.Union[str, typing.Any]
    '''

    show_expanded: bool = None
    ''' Set modifier expanded in the user interface

    :type: bool
    '''

    show_in_editmode: bool = None
    ''' Display modifier in Edit mode

    :type: bool
    '''

    show_on_cage: bool = None
    ''' Adjust edit cage to modifier result

    :type: bool
    '''

    show_render: bool = None
    ''' Use modifier during render

    :type: bool
    '''

    show_viewport: bool = None
    ''' Display modifier in viewport

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' * ``DATA_TRANSFER`` Data Transfer. * ``MESH_CACHE`` Mesh Cache. * ``MESH_SEQUENCE_CACHE`` Mesh Sequence Cache. * ``NORMAL_EDIT`` Normal Edit. * ``UV_PROJECT`` UV Project. * ``UV_WARP`` UV Warp. * ``VERTEX_WEIGHT_EDIT`` Vertex Weight Edit. * ``VERTEX_WEIGHT_MIX`` Vertex Weight Mix. * ``VERTEX_WEIGHT_PROXIMITY`` Vertex Weight Proximity. * ``ARRAY`` Array. * ``BEVEL`` Bevel. * ``BOOLEAN`` Boolean. * ``BUILD`` Build. * ``DECIMATE`` Decimate. * ``EDGE_SPLIT`` Edge Split. * ``MASK`` Mask. * ``MIRROR`` Mirror. * ``MULTIRES`` Multiresolution. * ``REMESH`` Remesh. * ``SCREW`` Screw. * ``SKIN`` Skin. * ``SOLIDIFY`` Solidify. * ``SUBSURF`` Subdivision Surface. * ``TRIANGULATE`` Triangulate. * ``WIREFRAME`` Wireframe, Generate a wireframe on the edges of a mesh. * ``ARMATURE`` Armature. * ``CAST`` Cast. * ``CORRECTIVE_SMOOTH`` Corrective Smooth. * ``CURVE`` Curve. * ``DISPLACE`` Displace. * ``HOOK`` Hook. * ``LAPLACIANSMOOTH`` Laplacian Smooth. * ``LAPLACIANDEFORM`` Laplacian Deform. * ``LATTICE`` Lattice. * ``MESH_DEFORM`` Mesh Deform. * ``SHRINKWRAP`` Shrinkwrap. * ``SIMPLE_DEFORM`` Simple Deform. * ``SMOOTH`` Smooth. * ``WARP`` Warp. * ``WAVE`` Wave. * ``CLOTH`` Cloth. * ``COLLISION`` Collision. * ``DYNAMIC_PAINT`` Dynamic Paint. * ``EXPLODE`` Explode. * ``FLUID_SIMULATION`` Fluid Simulation. * ``OCEAN`` Ocean. * ``PARTICLE_INSTANCE`` Particle Instance. * ``PARTICLE_SYSTEM`` Particle System. * ``SMOKE`` Smoke. * ``SOFT_BODY`` Soft Body. * ``SURFACE`` Surface.

    :type: typing.Union[str, int]
    '''

    use_apply_on_spline: bool = None
    ''' Apply this and all preceding deformation modifiers on splines' points rather than on filled curve/surface

    :type: bool
    '''


class MotionPath(bpy_struct):
    ''' Cache of the worldspace positions of an element over a frame range
    '''

    frame_end: int = None
    ''' End frame of the stored range

    :type: int
    '''

    frame_start: int = None
    ''' Starting frame of the stored range

    :type: int
    '''

    is_modified: bool = None
    ''' Path is being edited

    :type: bool
    '''

    length: int = None
    ''' Number of frames cached

    :type: int
    '''

    points: bpy_prop_collection['MotionPathVert'] = None
    ''' Cached positions per frame

    :type: bpy_prop_collection['MotionPathVert']
    '''

    use_bone_head: typing.Union[bool, typing.Any] = None
    ''' For PoseBone paths, use the bone head location when calculating this path

    :type: typing.Union[bool, typing.Any]
    '''


class MotionPathVert(bpy_struct):
    ''' Cached location on path
    '''

    co: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    select: bool = None
    ''' Path point is selected for editing

    :type: bool
    '''


class MovieClipProxy(bpy_struct):
    ''' Proxy parameters for a movie clip
    '''

    build_100: bool = None
    ''' Build proxy resolution 100% of the original footage dimension

    :type: bool
    '''

    build_25: bool = None
    ''' Build proxy resolution 25% of the original footage dimension

    :type: bool
    '''

    build_50: bool = None
    ''' Build proxy resolution 50% of the original footage dimension

    :type: bool
    '''

    build_75: bool = None
    ''' Build proxy resolution 75% of the original footage dimension

    :type: bool
    '''

    build_free_run: bool = None
    ''' Build free run time code index

    :type: bool
    '''

    build_free_run_rec_date: bool = None
    ''' Build free run time code index using Record Date/Time

    :type: bool
    '''

    build_record_run: bool = None
    ''' Build record run time code index

    :type: bool
    '''

    build_undistorted_100: bool = None
    ''' Build proxy resolution 100% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_25: bool = None
    ''' Build proxy resolution 25% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_50: bool = None
    ''' Build proxy resolution 50% of the original undistorted footage dimension

    :type: bool
    '''

    build_undistorted_75: bool = None
    ''' Build proxy resolution 75% of the original undistorted footage dimension

    :type: bool
    '''

    directory: typing.Union[str, typing.Any] = None
    ''' Location to store the proxy files

    :type: typing.Union[str, typing.Any]
    '''

    quality: int = None
    ''' JPEG quality of proxy images

    :type: int
    '''

    timecode: typing.Union[str, int] = None
    ''' * ``NONE`` No TC in use. * ``RECORD_RUN`` Record Run, Use images in the order they are recorded. * ``FREE_RUN`` Free Run, Use global timestamp written by recording device. * ``FREE_RUN_REC_DATE`` Free Run (rec date), Interpolate a global timestamp using the record date and time written by recording device. * ``FREE_RUN_NO_GAPS`` Free Run No Gaps, Record run, but ignore timecode, changes in framerate or dropouts.

    :type: typing.Union[str, int]
    '''


class MovieClipScopes(bpy_struct):
    ''' Scopes for statistical view of a movie clip
    '''

    pass


class MovieClipUser(bpy_struct):
    ''' Parameters defining how a MovieClip data-block is used by another data-block
    '''

    frame_current: int = None
    ''' Current frame number in movie or image sequence

    :type: int
    '''

    proxy_render_size: typing.Union[str, int] = None
    ''' Draw preview using full resolution or different proxy resolutions

    :type: typing.Union[str, int]
    '''

    use_render_undistorted: bool = None
    ''' Render preview using undistorted proxy

    :type: bool
    '''


class MovieReconstructedCamera(bpy_struct):
    ''' Match-moving reconstructed camera data from tracker
    '''

    average_error: float = None
    ''' Average error of reconstruction

    :type: float
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    matrix: bpy_prop_array[float] = None
    ''' Worldspace transformation matrix

    :type: bpy_prop_array[float]
    '''


class MovieTracking(bpy_struct):
    ''' Match-moving data for tracking
    '''

    active_object_index: int = None
    ''' Index of active object

    :type: int
    '''

    camera: 'MovieTrackingCamera' = None
    ''' 

    :type: 'MovieTrackingCamera'
    '''

    dopesheet: 'MovieTrackingDopesheet' = None
    ''' 

    :type: 'MovieTrackingDopesheet'
    '''

    objects: 'MovieTrackingObjects' = None
    ''' Collection of objects in this tracking data object

    :type: 'MovieTrackingObjects'
    '''

    plane_tracks: 'MovieTrackingPlaneTracks' = None
    ''' Collection of plane tracks in this tracking data object

    :type: 'MovieTrackingPlaneTracks'
    '''

    reconstruction: 'MovieTrackingReconstruction' = None
    ''' 

    :type: 'MovieTrackingReconstruction'
    '''

    settings: 'MovieTrackingSettings' = None
    ''' 

    :type: 'MovieTrackingSettings'
    '''

    stabilization: 'MovieTrackingStabilization' = None
    ''' 

    :type: 'MovieTrackingStabilization'
    '''

    tracks: 'MovieTrackingTracks' = None
    ''' Collection of tracks in this tracking data object

    :type: 'MovieTrackingTracks'
    '''


class MovieTrackingCamera(bpy_struct):
    ''' Match-moving camera data for tracking
    '''

    distortion_model: typing.Union[str, int] = None
    ''' Distortion model used for camera lenses * ``POLYNOMIAL`` Polynomial, Radial distortion model which fits common cameras. * ``DIVISION`` Divisions, Division distortion model which better represents wide-angle cameras.

    :type: typing.Union[str, int]
    '''

    division_k1: float = None
    ''' First coefficient of second order division distortion

    :type: float
    '''

    division_k2: float = None
    ''' First coefficient of second order division distortion

    :type: float
    '''

    focal_length: float = None
    ''' Camera's focal length

    :type: float
    '''

    focal_length_pixels: float = None
    ''' Camera's focal length

    :type: float
    '''

    k1: float = None
    ''' First coefficient of third order polynomial radial distortion

    :type: float
    '''

    k2: float = None
    ''' Second coefficient of third order polynomial radial distortion

    :type: float
    '''

    k3: float = None
    ''' Third coefficient of third order polynomial radial distortion

    :type: float
    '''

    pixel_aspect: float = None
    ''' Pixel aspect ratio

    :type: float
    '''

    principal: bpy_prop_array[float] = None
    ''' Optical center of lens

    :type: bpy_prop_array[float]
    '''

    sensor_width: float = None
    ''' Width of CCD sensor in millimeters

    :type: float
    '''

    units: typing.Union[str, int] = None
    ''' Units used for camera focal length * ``PIXELS`` px, Use pixels for units of focal length. * ``MILLIMETERS`` mm, Use millimeters for units of focal length.

    :type: typing.Union[str, int]
    '''


class MovieTrackingDopesheet(bpy_struct):
    ''' Match-moving dopesheet data
    '''

    show_hidden: bool = None
    ''' Include channels from objects/bone that aren't visible

    :type: bool
    '''

    show_only_selected: bool = None
    ''' Only include channels relating to selected objects and data

    :type: bool
    '''

    sort_method: typing.Union[str, int] = None
    ''' Method to be used to sort channels in dopesheet view * ``NAME`` Name, Sort channels by their names. * ``LONGEST`` Longest, Sort channels by longest tracked segment. * ``TOTAL`` Total, Sort channels by overall amount of tracked segments. * ``AVERAGE_ERROR`` Average Error, Sort channels by average reprojection error of tracks after solve.

    :type: typing.Union[str, int]
    '''

    use_invert_sort: bool = None
    ''' Invert sort order of dopesheet channels

    :type: bool
    '''


class MovieTrackingMarker(bpy_struct):
    ''' Match-moving marker data for tracking
    '''

    co: bpy_prop_array[float] = None
    ''' Marker position at frame in normalized coordinates

    :type: bpy_prop_array[float]
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    is_keyed: bool = None
    ''' Whether the position of the marker is keyframed or tracked

    :type: bool
    '''

    mute: bool = None
    ''' Is marker muted for current frame

    :type: bool
    '''

    pattern_bound_box: bpy_prop_array[float] = None
    ''' Pattern area bounding box in normalized coordinates

    :type: bpy_prop_array[float]
    '''

    pattern_corners: bpy_prop_array[float] = None
    ''' Array of coordinates which represents pattern's corners in normalized coordinates relative to marker position

    :type: bpy_prop_array[float]
    '''

    search_max: bpy_prop_array[float] = None
    ''' Right-bottom corner of search area in normalized coordinates relative to marker position

    :type: bpy_prop_array[float]
    '''

    search_min: bpy_prop_array[float] = None
    ''' Left-bottom corner of search area in normalized coordinates relative to marker position

    :type: bpy_prop_array[float]
    '''


class MovieTrackingObject(bpy_struct):
    ''' Match-moving object tracking and reconstruction data
    '''

    is_camera: typing.Union[bool, typing.Any] = None
    ''' Object is used for camera tracking

    :type: typing.Union[bool, typing.Any]
    '''

    keyframe_a: int = None
    ''' First keyframe used for reconstruction initialization

    :type: int
    '''

    keyframe_b: int = None
    ''' Second keyframe used for reconstruction initialization

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name of object

    :type: typing.Union[str, typing.Any]
    '''

    plane_tracks: 'MovieTrackingObjectPlaneTracks' = None
    ''' Collection of plane tracks in this tracking data object

    :type: 'MovieTrackingObjectPlaneTracks'
    '''

    reconstruction: 'MovieTrackingReconstruction' = None
    ''' 

    :type: 'MovieTrackingReconstruction'
    '''

    scale: float = None
    ''' Scale of object solution in camera space

    :type: float
    '''

    tracks: 'MovieTrackingObjectTracks' = None
    ''' Collection of tracks in this tracking data object

    :type: 'MovieTrackingObjectTracks'
    '''


class MovieTrackingPlaneMarker(bpy_struct):
    ''' Match-moving plane marker data for tracking
    '''

    corners: bpy_prop_array[float] = None
    ''' Array of coordinates which represents UI rectangle corners in frame normalized coordinates

    :type: bpy_prop_array[float]
    '''

    frame: int = None
    ''' Frame number marker is keyframed on

    :type: int
    '''

    mute: bool = None
    ''' Is marker muted for current frame

    :type: bool
    '''


class MovieTrackingPlaneTrack(bpy_struct):
    ''' Match-moving plane track data for tracking
    '''

    image: 'Image' = None
    ''' Image displayed in the track during editing in clip editor

    :type: 'Image'
    '''

    image_opacity: float = None
    ''' Opacity of the image

    :type: float
    '''

    markers: 'MovieTrackingPlaneMarkers' = None
    ''' Collection of markers in track

    :type: 'MovieTrackingPlaneMarkers'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name of track

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' Plane track is selected

    :type: bool
    '''

    use_auto_keying: bool = None
    ''' Automatic keyframe insertion when moving plane corners

    :type: bool
    '''


class MovieTrackingReconstruction(bpy_struct):
    ''' Match-moving reconstruction data from tracker
    '''

    average_error: float = None
    ''' Average error of reconstruction

    :type: float
    '''

    cameras: 'MovieTrackingReconstructedCameras' = None
    ''' Collection of solved cameras

    :type: 'MovieTrackingReconstructedCameras'
    '''

    is_valid: typing.Union[bool, typing.Any] = None
    ''' Is tracking data contains valid reconstruction information

    :type: typing.Union[bool, typing.Any]
    '''


class MovieTrackingSettings(bpy_struct):
    ''' Match moving settings
    '''

    clean_action: typing.Union[str, int] = None
    ''' Cleanup action to execute * ``SELECT`` Select, Select unclean tracks. * ``DELETE_TRACK`` Delete Track, Delete unclean tracks. * ``DELETE_SEGMENTS`` Delete Segments, Delete unclean segments of tracks.

    :type: typing.Union[str, int]
    '''

    clean_error: float = None
    ''' Effect on tracks which have a larger re-projection error

    :type: float
    '''

    clean_frames: int = None
    ''' Effect on tracks which are tracked less than the specified amount of frames

    :type: int
    '''

    default_correlation_min: float = None
    ''' Default minimum value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    '''

    default_frames_limit: int = None
    ''' Every tracking cycle, this number of frames are tracked

    :type: int
    '''

    default_margin: int = None
    ''' Default distance from image boundary at which marker stops tracking

    :type: int
    '''

    default_motion_model: typing.Union[str, int] = None
    ''' Default motion model to use for tracking * ``Perspective`` Perspective, Search for markers that are perspectively deformed (homography) between frames. * ``Affine`` Affine, Search for markers that are affine-deformed (t, r, k, and skew) between frames. * ``LocRotScale`` LocRotScale, Search for markers that are translated, rotated, and scaled between frames. * ``LocScale`` LocScale, Search for markers that are translated and scaled between frames. * ``LocRot`` LocRot, Search for markers that are translated and rotated between frames. * ``Loc`` Loc, Search for markers that are translated between frames.

    :type: typing.Union[str, int]
    '''

    default_pattern_match: typing.Union[str, int] = None
    ''' Track pattern from given frame when tracking marker to next frame * ``KEYFRAME`` Keyframe, Track pattern from keyframe to next frame. * ``PREV_FRAME`` Previous frame, Track pattern from current frame to next frame.

    :type: typing.Union[str, int]
    '''

    default_pattern_size: int = None
    ''' Size of pattern area for newly created tracks

    :type: int
    '''

    default_search_size: int = None
    ''' Size of search area for newly created tracks

    :type: int
    '''

    default_weight: float = None
    ''' Influence of newly created track on a final solution

    :type: float
    '''

    distance: float = None
    ''' Distance between two bundles used for scene scaling

    :type: float
    '''

    object_distance: float = None
    ''' Distance between two bundles used for object scaling

    :type: float
    '''

    refine_intrinsics: typing.Union[str, int] = None
    ''' Refine intrinsics during camera solving * ``NONE`` Nothing, Do not refine camera intrinsics. * ``FOCAL_LENGTH`` Focal Length, Refine focal length. * ``FOCAL_LENGTH_RADIAL_K1`` Focal length, K1, Refine focal length and radial distortion K1. * ``FOCAL_LENGTH_RADIAL_K1_K2`` Focal length, K1, K2, Refine focal length and radial distortion K1 and K2. * ``FOCAL_LENGTH_PRINCIPAL_POINT_RADIAL_K1_K2`` Focal Length, Optical Center, K1, K2, Refine focal length, optical center and radial distortion K1 and K2. * ``FOCAL_LENGTH_PRINCIPAL_POINT`` Focal Length, Optical Center, Refine focal length and optical center. * ``RADIAL_K1_K2`` K1, K2, Refine radial distortion K1 and K2.

    :type: typing.Union[str, int]
    '''

    show_default_expanded: bool = None
    ''' Show default options expanded in the user interface

    :type: bool
    '''

    show_extra_expanded: bool = None
    ''' Show extra options expanded in the user interface

    :type: bool
    '''

    speed: typing.Union[str, int] = None
    ''' Limit speed of tracking to make visual feedback easier (this does not affect the tracking quality) * ``FASTEST`` Fastest, Track as fast as it's possible. * ``DOUBLE`` Double, Track with double speed. * ``REALTIME`` Realtime, Track with realtime speed. * ``HALF`` Half, Track with half of realtime speed. * ``QUARTER`` Quarter, Track with quarter of realtime speed.

    :type: typing.Union[str, int]
    '''

    use_default_blue_channel: bool = None
    ''' Use blue channel from footage for tracking

    :type: bool
    '''

    use_default_brute: bool = None
    ''' Use a brute-force translation-only initialization when tracking

    :type: bool
    '''

    use_default_green_channel: bool = None
    ''' Use green channel from footage for tracking

    :type: bool
    '''

    use_default_mask: bool = None
    ''' Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    '''

    use_default_normalization: bool = None
    ''' Normalize light intensities while tracking (slower)

    :type: bool
    '''

    use_default_red_channel: bool = None
    ''' Use red channel from footage for tracking

    :type: bool
    '''

    use_keyframe_selection: bool = None
    ''' Automatically select keyframes when solving camera/object motion

    :type: bool
    '''

    use_tripod_solver: bool = None
    ''' Use special solver to track a stable camera position, such as a tripod

    :type: bool
    '''


class MovieTrackingStabilization(bpy_struct):
    ''' 2D stabilization based on tracking markers
    '''

    active_rotation_track_index: int = None
    ''' Index of active track in rotation stabilization tracks list

    :type: int
    '''

    active_track_index: int = None
    ''' Index of active track in translation stabilization tracks list

    :type: int
    '''

    anchor_frame: int = None
    ''' Reference point to anchor stabilization (other frames will be adjusted relative to this frame's position)

    :type: int
    '''

    filter_type: typing.Union[str, int] = None
    ''' Interpolation to use for sub-pixel shifts and rotations due to stabilization * ``NEAREST`` Nearest, No interpolation, use nearest neighbor pixel. * ``BILINEAR`` Bilinear, Simple interpolation between adjacent pixels. * ``BICUBIC`` Bicubic, High quality pixel interpolation.

    :type: typing.Union[str, int]
    '''

    influence_location: float = None
    ''' Influence of stabilization algorithm on footage location

    :type: float
    '''

    influence_rotation: float = None
    ''' Influence of stabilization algorithm on footage rotation

    :type: float
    '''

    influence_scale: float = None
    ''' Influence of stabilization algorithm on footage scale

    :type: float
    '''

    rotation_tracks: bpy_prop_collection['MovieTrackingTrack'] = None
    ''' Collection of tracks used for 2D stabilization (translation)

    :type: bpy_prop_collection['MovieTrackingTrack']
    '''

    scale_max: float = None
    ''' Limit the amount of automatic scaling

    :type: float
    '''

    show_tracks_expanded: bool = None
    ''' Show UI list of tracks participating in stabilization

    :type: bool
    '''

    target_position: bpy_prop_array[float] = None
    ''' Known relative offset of original shot, will be subtracted (e.g. for panning shot, can be animated)

    :type: bpy_prop_array[float]
    '''

    target_rotation: float = None
    ''' Rotation present on original shot, will be compensated (e.g. for deliberate tilting)

    :type: float
    '''

    target_scale: float = None
    ''' Explicitly scale resulting frame to compensate zoom of original shot

    :type: float
    '''

    tracks: bpy_prop_collection['MovieTrackingTrack'] = None
    ''' Collection of tracks used for 2D stabilization (translation)

    :type: bpy_prop_collection['MovieTrackingTrack']
    '''

    use_2d_stabilization: bool = None
    ''' Use 2D stabilization for footage

    :type: bool
    '''

    use_autoscale: bool = None
    ''' Automatically scale footage to cover unfilled areas when stabilizing

    :type: bool
    '''

    use_stabilize_rotation: bool = None
    ''' Stabilize detected rotation around center of frame

    :type: bool
    '''

    use_stabilize_scale: bool = None
    ''' Compensate any scale changes relative to center of rotation

    :type: bool
    '''


class MovieTrackingTrack(bpy_struct):
    ''' Match-moving track data for tracking
    '''

    average_error: float = None
    ''' Average error of re-projection

    :type: float
    '''

    bundle: bpy_prop_array[float] = None
    ''' Position of bundle reconstructed from this track

    :type: bpy_prop_array[float]
    '''

    color: bpy_prop_array[float] = None
    ''' Color of the track in the Movie Clip Editor and the 3D viewport after a solve

    :type: bpy_prop_array[float]
    '''

    correlation_min: float = None
    ''' Minimal value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    '''

    frames_limit: int = None
    ''' Every tracking cycle, this number of frames are tracked

    :type: int
    '''

    grease_pencil: 'GreasePencil' = None
    ''' Grease pencil data for this track

    :type: 'GreasePencil'
    '''

    has_bundle: typing.Union[bool, typing.Any] = None
    ''' True if track has a valid bundle

    :type: typing.Union[bool, typing.Any]
    '''

    hide: bool = None
    ''' Track is hidden

    :type: bool
    '''

    lock: bool = None
    ''' Track is locked and all changes to it are disabled

    :type: bool
    '''

    margin: int = None
    ''' Distance from image boundary at which marker stops tracking

    :type: int
    '''

    markers: 'MovieTrackingMarkers' = None
    ''' Collection of markers in track

    :type: 'MovieTrackingMarkers'
    '''

    motion_model: typing.Union[str, int] = None
    ''' Default motion model to use for tracking * ``Perspective`` Perspective, Search for markers that are perspectively deformed (homography) between frames. * ``Affine`` Affine, Search for markers that are affine-deformed (t, r, k, and skew) between frames. * ``LocRotScale`` LocRotScale, Search for markers that are translated, rotated, and scaled between frames. * ``LocScale`` LocScale, Search for markers that are translated and scaled between frames. * ``LocRot`` LocRot, Search for markers that are translated and rotated between frames. * ``Loc`` Loc, Search for markers that are translated between frames.

    :type: typing.Union[str, int]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name of track

    :type: typing.Union[str, typing.Any]
    '''

    offset: bpy_prop_array[float] = None
    ''' Offset of track from the parenting point

    :type: bpy_prop_array[float]
    '''

    pattern_match: typing.Union[str, int] = None
    ''' Track pattern from given frame when tracking marker to next frame * ``KEYFRAME`` Keyframe, Track pattern from keyframe to next frame. * ``PREV_FRAME`` Previous frame, Track pattern from current frame to next frame.

    :type: typing.Union[str, int]
    '''

    select: bool = None
    ''' Track is selected

    :type: bool
    '''

    select_anchor: bool = None
    ''' Track's anchor point is selected

    :type: bool
    '''

    select_pattern: bool = None
    ''' Track's pattern area is selected

    :type: bool
    '''

    select_search: bool = None
    ''' Track's search area is selected

    :type: bool
    '''

    use_alpha_preview: bool = None
    ''' Apply track's mask on displaying preview

    :type: bool
    '''

    use_blue_channel: bool = None
    ''' Use blue channel from footage for tracking

    :type: bool
    '''

    use_brute: bool = None
    ''' Use a brute-force translation only pre-track before refinement

    :type: bool
    '''

    use_custom_color: bool = None
    ''' Use custom color instead of theme-defined

    :type: bool
    '''

    use_grayscale_preview: bool = None
    ''' Display what the tracking algorithm sees in the preview

    :type: bool
    '''

    use_green_channel: bool = None
    ''' Use green channel from footage for tracking

    :type: bool
    '''

    use_mask: bool = None
    ''' Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    '''

    use_normalization: bool = None
    ''' Normalize light intensities while tracking. Slower

    :type: bool
    '''

    use_red_channel: bool = None
    ''' Use red channel from footage for tracking

    :type: bool
    '''

    weight: float = None
    ''' Influence of this track on a final solution

    :type: float
    '''

    weight_stab: float = None
    ''' Influence of this track on 2D stabilization

    :type: float
    '''


class NlaStrip(bpy_struct):
    ''' A container referencing an existing Action
    '''

    action: 'Action' = None
    ''' Action referenced by this strip

    :type: 'Action'
    '''

    action_frame_end: float = None
    ''' Last frame from action to use

    :type: float
    '''

    action_frame_start: float = None
    ''' First frame from action to use

    :type: float
    '''

    active: typing.Union[bool, typing.Any] = None
    ''' NLA Strip is active

    :type: typing.Union[bool, typing.Any]
    '''

    blend_in: float = None
    ''' Number of frames at start of strip to fade in influence

    :type: float
    '''

    blend_out: float = None
    ''' 

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' Method used for combining strip's result with accumulated result * ``REPLACE`` Replace, Result strip replaces the accumulated results by amount specified by influence. * ``ADD`` Add, Weighted result of strip is added to the accumulated results. * ``SUBTRACT`` Subtract, Weighted result of strip is removed from the accumulated results. * ``MULTIPLY`` Multiply, Weighted result of strip is multiplied with the accumulated results.

    :type: typing.Union[str, int]
    '''

    extrapolation: typing.Union[str, int] = None
    ''' Action to take for gaps past the strip extents * ``NOTHING`` Nothing, Strip has no influence past its extents. * ``HOLD`` Hold, Hold the first frame if no previous strips in track, and always hold last frame. * ``HOLD_FORWARD`` Hold Forward, Only hold last frame.

    :type: typing.Union[str, int]
    '''

    fcurves: 'NlaStripFCurves' = None
    ''' F-Curves for controlling the strip's influence and timing

    :type: 'NlaStripFCurves'
    '''

    frame_end: float = None
    ''' 

    :type: float
    '''

    frame_start: float = None
    ''' 

    :type: float
    '''

    influence: float = None
    ''' Amount the strip contributes to the current result

    :type: float
    '''

    modifiers: bpy_prop_collection['FModifier'] = None
    ''' Modifiers affecting all the F-Curves in the referenced Action

    :type: bpy_prop_collection['FModifier']
    '''

    mute: bool = None
    ''' NLA Strip is not evaluated

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    repeat: float = None
    ''' Number of times to repeat the action range

    :type: float
    '''

    scale: float = None
    ''' Scaling factor for action

    :type: float
    '''

    select: bool = None
    ''' NLA Strip is selected

    :type: bool
    '''

    strip_time: float = None
    ''' Frame of referenced Action to evaluate

    :type: float
    '''

    strips: bpy_prop_collection['NlaStrip'] = None
    ''' NLA Strips that this strip acts as a container for (if it is of type Meta)

    :type: bpy_prop_collection['NlaStrip']
    '''

    type: typing.Union[str, int] = None
    ''' Type of NLA Strip * ``CLIP`` Action Clip, NLA Strip references some Action. * ``TRANSITION`` Transition, NLA Strip 'transitions' between adjacent strips. * ``META`` Meta, NLA Strip acts as a container for adjacent strips. * ``SOUND`` Sound Clip, NLA Strip representing a sound event for speakers.

    :type: typing.Union[str, int]
    '''

    use_animated_influence: bool = None
    ''' Influence setting is controlled by an F-Curve rather than automatically determined

    :type: bool
    '''

    use_animated_time: bool = None
    ''' Strip time is controlled by an F-Curve rather than automatically determined

    :type: bool
    '''

    use_animated_time_cyclic: bool = None
    ''' Cycle the animated time within the action start & end

    :type: bool
    '''

    use_auto_blend: bool = None
    ''' Number of frames for Blending In/Out is automatically determined from overlapping strips

    :type: bool
    '''

    use_reverse: bool = None
    ''' NLA Strip is played back in reverse order (only when timing is automatically determined)

    :type: bool
    '''

    use_sync_length: bool = None
    ''' Update range of frames referenced from action after tweaking strip and its keyframes

    :type: bool
    '''


class NlaTrack(bpy_struct):
    ''' A animation layer containing Actions referenced as NLA strips
    '''

    active: typing.Union[bool, typing.Any] = None
    ''' NLA Track is active

    :type: typing.Union[bool, typing.Any]
    '''

    is_solo: bool = None
    ''' NLA Track is evaluated itself (i.e. active Action and all other NLA Tracks in the same AnimData block are disabled)

    :type: bool
    '''

    lock: bool = None
    ''' NLA Track is locked

    :type: bool
    '''

    mute: bool = None
    ''' NLA Track is not evaluated

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' NLA Track is selected

    :type: bool
    '''

    strips: 'NlaStrips' = None
    ''' NLA Strips on this NLA-track

    :type: 'NlaStrips'
    '''


class Node(bpy_struct):
    ''' Node in a node tree
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_height_default: float = None
    ''' 

    :type: float
    '''

    bl_height_max: float = None
    ''' 

    :type: float
    '''

    bl_height_min: float = None
    ''' 

    :type: float
    '''

    bl_icon: typing.Union[str, int] = None
    ''' The node icon

    :type: typing.Union[str, int]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' The node label

    :type: typing.Union[str, typing.Any]
    '''

    bl_static_type: typing.Union[str, int] = None
    ''' Node type (deprecated, use with care) * ``CUSTOM`` Custom, Custom Node.

    :type: typing.Union[str, int]
    '''

    bl_width_default: float = None
    ''' 

    :type: float
    '''

    bl_width_max: float = None
    ''' 

    :type: float
    '''

    bl_width_min: float = None
    ''' 

    :type: float
    '''

    color: bpy_prop_array[float] = None
    ''' Custom color of the node body

    :type: bpy_prop_array[float]
    '''

    dimensions: bpy_prop_array[float] = None
    ''' Absolute bounding box dimensions of the node

    :type: bpy_prop_array[float]
    '''

    height: float = None
    ''' Height of the node

    :type: float
    '''

    hide: bool = None
    ''' 

    :type: bool
    '''

    inputs: 'NodeInputs' = None
    ''' 

    :type: 'NodeInputs'
    '''

    internal_links: bpy_prop_collection['NodeLink'] = None
    ''' Internal input-to-output connections for muting

    :type: bpy_prop_collection['NodeLink']
    '''

    label: typing.Union[str, typing.Any] = None
    ''' Optional custom node label

    :type: typing.Union[str, typing.Any]
    '''

    location: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    mute: bool = None
    ''' 

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique node identifier

    :type: typing.Union[str, typing.Any]
    '''

    outputs: 'NodeOutputs' = None
    ''' 

    :type: 'NodeOutputs'
    '''

    parent: 'Node' = None
    ''' Parent this node is attached to

    :type: 'Node'
    '''

    select: bool = None
    ''' Node selection state

    :type: bool
    '''

    shading_compatibility: typing.Any = None
    ''' * ``OLD_SHADING`` Old Shading, Old shading system compatibility. * ``NEW_SHADING`` New Shading, New shading system compatibility.

    :type: typing.Any
    '''

    show_options: bool = None
    ''' 

    :type: bool
    '''

    show_preview: bool = None
    ''' 

    :type: bool
    '''

    show_texture: bool = None
    ''' Draw node in viewport textured draw mode

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Node type (deprecated, use bl_static_type or bl_idname for the actual identifier string) * ``CUSTOM`` Custom, Custom Node.

    :type: typing.Union[str, int]
    '''

    use_custom_color: bool = None
    ''' Use custom color for the node

    :type: bool
    '''

    width: float = None
    ''' Width of the node

    :type: float
    '''

    width_hidden: float = None
    ''' Width of the node in hidden state

    :type: float
    '''

    def socket_value_update(self, context: 'Context'):
        ''' Update after property changes

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def is_registered_node_type(cls) -> bool:
        ''' True if a registered node type

        :rtype: bool
        :return: Result
        '''
        pass

    @classmethod
    def poll(cls, node_tree: typing.Optional['NodeTree']) -> bool:
        ''' If non-null output is returned, the node type can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: typing.Optional['NodeTree']
        :rtype: bool
        '''
        pass

    def poll_instance(self, node_tree: typing.Optional['NodeTree']) -> bool:
        ''' If non-null output is returned, the node can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: typing.Optional['NodeTree']
        :rtype: bool
        '''
        pass

    def update(self):
        ''' Update on editor changes

        '''
        pass

    def insert_link(self, link: 'NodeLink'):
        ''' Handle creation of a link to or from the node

        :param link: Link, Node link that will be inserted
        :type link: 'NodeLink'
        '''
        pass

    def init(self, context: 'Context'):
        ''' Initialize a new instance of this node

        :param context: 
        :type context: 'Context'
        '''
        pass

    def copy(self, node: 'Node'):
        ''' Initialize a new instance of this node from an existing node

        :param node: Node, Existing node to copy
        :type node: 'Node'
        '''
        pass

    def free(self):
        ''' Clean up node on removal

        '''
        pass

    def draw_buttons(self, context: 'Context', layout: 'UILayout'):
        ''' Draw node buttons

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        '''
        pass

    def draw_buttons_ext(self, context: 'Context', layout: 'UILayout'):
        ''' Draw node buttons in the sidebar

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        '''
        pass

    def draw_label(self) -> typing.Union[str, typing.Any]:
        ''' Returns a dynamic label string

        :rtype: typing.Union[str, typing.Any]
        :return: Label
        '''
        pass


class NodeInstanceHash(bpy_struct):
    ''' Hash table containing node instance data
    '''

    pass


class NodeInternalSocketTemplate(bpy_struct):
    ''' Type and default value of a node socket
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Identifier of the socket

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the socket

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' Data type of the socket

    :type: typing.Union[str, int]
    '''


class NodeLink(bpy_struct):
    ''' Link is valid
    '''

    from_node: 'Node' = None
    ''' 

    :type: 'Node'
    '''

    from_socket: 'NodeSocket' = None
    ''' 

    :type: 'NodeSocket'
    '''

    is_hidden: typing.Union[bool, typing.Any] = None
    ''' Link is hidden due to invisible sockets

    :type: typing.Union[bool, typing.Any]
    '''

    is_valid: bool = None
    ''' 

    :type: bool
    '''

    to_node: 'Node' = None
    ''' 

    :type: 'Node'
    '''

    to_socket: 'NodeSocket' = None
    ''' 

    :type: 'NodeSocket'
    '''


class NodeOutputFileSlotFile(bpy_struct):
    ''' Single layer file slot of the file output node
    '''

    format: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    path: typing.Union[str, typing.Any] = None
    ''' Subpath used for this slot

    :type: typing.Union[str, typing.Any]
    '''

    use_node_format: bool = None
    ''' 

    :type: bool
    '''


class NodeOutputFileSlotLayer(bpy_struct):
    ''' Multilayer slot of the file output node
    '''

    name: typing.Union[str, typing.Any] = None
    ''' OpenEXR layer name used for this slot

    :type: typing.Union[str, typing.Any]
    '''


class NodeSocket(bpy_struct):
    ''' Input or output socket of a node
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    enabled: bool = None
    ''' Enable the socket

    :type: bool
    '''

    hide: bool = None
    ''' Hide the socket

    :type: bool
    '''

    hide_value: bool = None
    ''' Hide the socket input value

    :type: bool
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique identifier for mapping sockets

    :type: typing.Union[str, typing.Any]
    '''

    is_linked: typing.Union[bool, typing.Any] = None
    ''' True if the socket is connected

    :type: typing.Union[bool, typing.Any]
    '''

    is_output: typing.Union[bool, typing.Any] = None
    ''' True if the socket is an output, otherwise input

    :type: typing.Union[bool, typing.Any]
    '''

    link_limit: int = None
    ''' Max number of links allowed for this socket

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Socket name

    :type: typing.Union[str, typing.Any]
    '''

    node: 'Node' = None
    ''' Node owning this socket

    :type: 'Node'
    '''

    show_expanded: bool = None
    ''' Socket links are expanded in the user interface

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Data type

    :type: typing.Union[str, int]
    '''

    links = None
    ''' List of node links from or to this socket (readonly)'''

    def draw(self, context: 'Context', layout: 'UILayout', node: 'Node',
             text: typing.Union[str, typing.Any]):
        ''' Draw socket

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :param text: Text, Text label to draw alongside properties
        :type text: typing.Union[str, typing.Any]
        '''
        pass

    def draw_color(self, context: 'Context',
                   node: 'Node') -> bpy_prop_array[float]:
        ''' Color of the socket icon

        :param context: 
        :type context: 'Context'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :rtype: bpy_prop_array[float]
        :return: Color
        '''
        pass


class NodeSocketInterface(bpy_struct):
    ''' Parameters to define node sockets
    '''

    bl_socket_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique identifier for mapping sockets

    :type: typing.Union[str, typing.Any]
    '''

    is_output: typing.Union[bool, typing.Any] = None
    ''' True if the socket is an output, otherwise input

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Socket name

    :type: typing.Union[str, typing.Any]
    '''

    def draw(self, context: 'Context', layout: 'UILayout'):
        ''' Draw template settings

        :param context: 
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        '''
        pass

    def draw_color(self, context: 'Context') -> bpy_prop_array[float]:
        ''' Color of the socket icon

        :param context: 
        :type context: 'Context'
        :rtype: bpy_prop_array[float]
        :return: Color
        '''
        pass

    def register_properties(self, data_rna_type: typing.Optional['Struct']):
        ''' Define RNA properties of a socket

        :param data_rna_type: Data RNA Type, RNA type for special socket properties
        :type data_rna_type: typing.Optional['Struct']
        '''
        pass

    def init_socket(self, node: 'Node', socket: 'NodeSocket',
                    data_path: typing.Union[str, typing.Any]):
        ''' Initialize a node socket instance

        :param node: Node, Node of the socket to initialize
        :type node: 'Node'
        :param socket: Socket, Socket to initialize
        :type socket: 'NodeSocket'
        :param data_path: Data Path, Path to specialized socket data
        :type data_path: typing.Union[str, typing.Any]
        '''
        pass

    def from_socket(self, node: 'Node', socket: 'NodeSocket'):
        ''' Setup template parameters from an existing socket

        :param node: Node, Node of the original socket
        :type node: 'Node'
        :param socket: Socket, Original socket
        :type socket: 'NodeSocket'
        '''
        pass


class NodeTreePath(bpy_struct):
    ''' Element of the node space tree path
    '''

    node_tree: 'NodeTree' = None
    ''' Base node tree from context

    :type: 'NodeTree'
    '''


class ObjectBase(bpy_struct):
    ''' An object instance in a scene
    '''

    layers: typing.List[bool] = None
    ''' Layers the object base is on

    :type: typing.List[bool]
    '''

    layers_local_view: typing.List[bool] = None
    ''' 3D local view layers the object base is on

    :type: typing.List[bool]
    '''

    object: 'Object' = None
    ''' Object this base links to

    :type: 'Object'
    '''

    select: bool = None
    ''' Object base selection state

    :type: bool
    '''

    def layers_from_view(self, view: 'SpaceView3D'):
        ''' Sets the object layers from a 3D View (use when adding an object in local view)

        :param view: 
        :type view: 'SpaceView3D'
        '''
        pass


class OceanTexData(bpy_struct):
    ''' Ocean Texture settings
    '''

    ocean_object: 'Object' = None
    ''' Object containing the ocean modifier

    :type: 'Object'
    '''

    output: typing.Union[str, int] = None
    ''' The data that is output by the texture * ``DISPLACEMENT`` Displacement, Output XYZ displacement in RGB channels. * ``FOAM`` Foam, Output Foam (wave overlap) amount in single channel. * ``JPLUS`` Eigenvalues, Positive Eigenvalues. * ``EMINUS`` Eigenvectors (-), Negative Eigenvectors. * ``EPLUS`` Eigenvectors (+), Positive Eigenvectors.

    :type: typing.Union[str, int]
    '''


class Operator(bpy_struct):
    ''' Storage of an operator being executed, or registered after execution
    '''

    bl_description: str = None
    ''' 

    :type: str
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this operator type * ``REGISTER`` Register, Display in the info window and support the redo toolbar panel. * ``UNDO`` Undo, Push an undo event (needed for operator redo). * ``BLOCKING`` Blocking, Block anything else from using the cursor. * ``MACRO`` Macro, Use to check if an operator is a macro. * ``GRAB_CURSOR`` Grab Pointer, Use so the operator grabs the mouse focus, enables wrapping when continuous grab is enabled. * ``PRESET`` Preset, Display a preset button with the operators settings. * ``INTERNAL`` Internal, Removes the operator from search results.

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_translation_context: str = None
    ''' 

    :type: str
    '''

    has_reports: typing.Union[bool, typing.Any] = None
    ''' Operator has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    '''

    layout: 'UILayout' = None
    ''' 

    :type: 'UILayout'
    '''

    macros: bpy_prop_collection['Macro'] = None
    ''' 

    :type: bpy_prop_collection['Macro']
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    options: 'OperatorOptions' = None
    ''' Runtime options

    :type: 'OperatorOptions'
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''

    bl_property: str = None
    ''' The name of a property to use as this operators primary property. Currently this is only used to select the default property when expanding an operator into a menu.

    :type: str
    '''

    def report(self, type: typing.Optional[
            typing.Union[typing.Set[str], typing.Set[int]]],
               message: typing.Union[str, typing.Any]):
        ''' report

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[str], typing.Set[int]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        '''
        pass

    @classmethod
    def poll(cls, context: 'Context') -> bool:
        ''' Test if the operator can be called or not

        :param context: 
        :type context: 'Context'
        :rtype: bool
        '''
        pass

    def execute(self, context: 'Context'
                ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Execute the operator

        :param context: 
        :type context: 'Context'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * ``RUNNING_MODAL`` Running Modal, Keep the operator running with blender. * ``CANCELLED`` Cancelled, When no action has been taken, operator exits. * ``FINISHED`` Finished, When the operator is complete, operator exits. * ``PASS_THROUGH`` Pass Through, Do nothing and pass the event on. * ``INTERFACE`` Interface, Handled but not executed (popup menus).
        '''
        pass

    def check(self, context: 'Context') -> bool:
        ''' Check the operator settings, return True to signal a change to redraw

        :param context: 
        :type context: 'Context'
        :rtype: bool
        :return: result
        '''
        pass

    def invoke(self, context: 'Context', event: 'Event'
               ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Invoke the operator

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * ``RUNNING_MODAL`` Running Modal, Keep the operator running with blender. * ``CANCELLED`` Cancelled, When no action has been taken, operator exits. * ``FINISHED`` Finished, When the operator is complete, operator exits. * ``PASS_THROUGH`` Pass Through, Do nothing and pass the event on. * ``INTERFACE`` Interface, Handled but not executed (popup menus).
        '''
        pass

    def modal(self, context: 'Context', event: 'Event'
              ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Modal operator function

        :param context: 
        :type context: 'Context'
        :param event: 
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * ``RUNNING_MODAL`` Running Modal, Keep the operator running with blender. * ``CANCELLED`` Cancelled, When no action has been taken, operator exits. * ``FINISHED`` Finished, When the operator is complete, operator exits. * ``PASS_THROUGH`` Pass Through, Do nothing and pass the event on. * ``INTERFACE`` Interface, Handled but not executed (popup menus).
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw function for the operator

        :param context: 
        :type context: 'Context'
        '''
        pass

    def cancel(self, context: 'Context'):
        ''' Called when the operator is canceled

        :param context: 
        :type context: 'Context'
        '''
        pass

    def as_keywords(self, ignore=()):
        ''' Return a copy of the properties as a dictionary

        '''
        pass


class OperatorMacro(bpy_struct):
    ''' Storage of a sub operator in a macro after it has been added
    '''

    properties: 'OperatorProperties' = None
    ''' 

    :type: 'OperatorProperties'
    '''


class OperatorOptions(bpy_struct):
    ''' Runtime options
    '''

    is_grab_cursor: typing.Union[bool, typing.Any] = None
    ''' True when the cursor is grabbed

    :type: typing.Union[bool, typing.Any]
    '''

    is_invoke: typing.Union[bool, typing.Any] = None
    ''' True when invoked (even if only the execute callbacks available)

    :type: typing.Union[bool, typing.Any]
    '''

    use_cursor_region: bool = None
    ''' Enable to use the region under the cursor for modal execution

    :type: bool
    '''


class OperatorProperties(bpy_struct):
    ''' Input properties of an Operator
    '''

    pass


class PackedFile(bpy_struct):
    ''' External file packed into the .blend file
    '''

    data: typing.Union[str, typing.Any] = None
    ''' Raw data (bytes, exact content of the embedded file)

    :type: typing.Union[str, typing.Any]
    '''

    size: int = None
    ''' Size of packed file in bytes

    :type: int
    '''


class Paint(bpy_struct):
    brush: 'Brush' = None
    ''' Active Brush

    :type: 'Brush'
    '''

    cavity_curve: 'CurveMapping' = None
    ''' Editable cavity curve

    :type: 'CurveMapping'
    '''

    input_samples: int = None
    ''' Average multiple input samples together to smooth the brush stroke

    :type: int
    '''

    palette: 'Palette' = None
    ''' Active Palette

    :type: 'Palette'
    '''

    show_brush: bool = None
    ''' 

    :type: bool
    '''

    show_brush_on_surface: bool = None
    ''' 

    :type: bool
    '''

    show_low_resolution: bool = None
    ''' For multires, show low resolution while navigating the view

    :type: bool
    '''

    tile_offset: bpy_prop_array[float] = None
    ''' Stride at which tiled strokes are copied

    :type: bpy_prop_array[float]
    '''

    tile_x: bool = None
    ''' Tile along X axis

    :type: bool
    '''

    tile_y: bool = None
    ''' Tile along Y axis

    :type: bool
    '''

    tile_z: bool = None
    ''' Tile along Z axis

    :type: bool
    '''

    use_cavity: bool = None
    ''' Mask painting according to mesh geometry cavity

    :type: bool
    '''

    use_symmetry_feather: bool = None
    ''' Reduce the strength of the brush where it overlaps symmetrical daubs

    :type: bool
    '''

    use_symmetry_x: bool = None
    ''' Mirror brush across the X axis

    :type: bool
    '''

    use_symmetry_y: bool = None
    ''' Mirror brush across the Y axis

    :type: bool
    '''

    use_symmetry_z: bool = None
    ''' Mirror brush across the Z axis

    :type: bool
    '''


class PaletteColor(bpy_struct):
    color: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    strength: float = None
    ''' 

    :type: float
    '''

    weight: float = None
    ''' 

    :type: float
    '''


class Panel(bpy_struct):
    ''' Panel containing UI elements
    '''

    bl_category: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_context: typing.Union[str, typing.Any] = None
    ''' The context in which the panel belongs to. (TODO: explain the possible combinations bl_context/bl_region_type/bl_space_type)

    :type: typing.Union[str, typing.Any]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the panel gets a custom ID, otherwise it takes the name of the class used to define the panel. For example, if the class name is "OBJECT_PT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_PT_hello"

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' The panel label, shows up in the panel header at the right of the triangle used to collapse the panel

    :type: typing.Union[str, typing.Any]
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Options for this panel type * ``DEFAULT_CLOSED`` Default Closed, Defines if the panel has to be open or collapsed at the time of its creation. * ``HIDE_HEADER`` Hide Header, If set to False, the panel shows a header, which contains a clickable arrow to collapse the panel and the label (see bl_label).

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_region_type: typing.Union[str, int] = None
    ''' The region where the panel is going to be used in

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    ''' The space where the panel is going to be used in * ``EMPTY`` Empty. * ``VIEW_3D`` 3D View, 3D viewport. * ``TIMELINE`` Timeline, Timeline and playback controls. * ``GRAPH_EDITOR`` Graph Editor, Edit drivers and keyframe interpolation. * ``DOPESHEET_EDITOR`` Dope Sheet, Adjust timing of keyframes. * ``NLA_EDITOR`` NLA Editor, Combine and layer Actions. * ``IMAGE_EDITOR`` UV/Image Editor, View and edit images and UV Maps. * ``SEQUENCE_EDITOR`` Video Sequence Editor, Video editing tools. * ``CLIP_EDITOR`` Movie Clip Editor, Motion tracking tools. * ``TEXT_EDITOR`` Text Editor, Edit scripts and in-file documentation. * ``NODE_EDITOR`` Node Editor, Editor for node-based shading and compositing tools. * ``LOGIC_EDITOR`` Logic Editor, Game logic editing. * ``PROPERTIES`` Properties, Edit properties of active object and related data-blocks. * ``OUTLINER`` Outliner, Overview of scene graph and all available data-blocks. * ``USER_PREFERENCES`` User Preferences, Edit persistent configuration settings. * ``INFO`` Info, Main menu bar and list of error messages (drag down to expand and display). * ``FILE_BROWSER`` File Browser, Browse for files and assets. * ``CONSOLE`` Python Console, Interactive programmatic console for advanced editing and script development.

    :type: typing.Union[str, int]
    '''

    bl_translation_context: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    layout: 'UILayout' = None
    ''' Defines the structure of the panel in the UI

    :type: 'UILayout'
    '''

    text: typing.Union[str, typing.Any] = None
    ''' XXX todo

    :type: typing.Union[str, typing.Any]
    '''

    use_pin: bool = None
    ''' 

    :type: bool
    '''

    @classmethod
    def poll(cls, context: 'Context') -> bool:
        ''' If this method returns a non-null output, then the panel can be drawn

        :param context: 
        :type context: 'Context'
        :rtype: bool
        '''
        pass

    def draw(self, context: 'Context'):
        ''' Draw UI elements into the panel UI layout

        :param context: 
        :type context: 'Context'
        '''
        pass

    def draw_header(self, context: 'Context'):
        ''' Draw UI elements into the panel's header UI layout

        :param context: 
        :type context: 'Context'
        '''
        pass


class Particle(bpy_struct):
    ''' Particle in a particle system
    '''

    alive_state: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    angular_velocity: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    birth_time: float = None
    ''' 

    :type: float
    '''

    die_time: float = None
    ''' 

    :type: float
    '''

    hair_keys: bpy_prop_collection['ParticleHairKey'] = None
    ''' 

    :type: bpy_prop_collection['ParticleHairKey']
    '''

    is_exist: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    is_visible: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    lifetime: float = None
    ''' 

    :type: float
    '''

    location: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    particle_keys: bpy_prop_collection['ParticleKey'] = None
    ''' 

    :type: bpy_prop_collection['ParticleKey']
    '''

    prev_angular_velocity: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    prev_location: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    prev_rotation: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    prev_velocity: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    rotation: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    size: float = None
    ''' 

    :type: float
    '''

    velocity: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    def uv_on_emitter(
            self, modifier: 'ParticleSystemModifier') -> bpy_prop_array[float]:
        ''' Obtain uv for particle on derived mesh

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :rtype: bpy_prop_array[float]
        :return: uv
        '''
        pass


class ParticleBrush(bpy_struct):
    ''' Particle editing brush
    '''

    count: int = None
    ''' Particle count

    :type: int
    '''

    curve: 'CurveMapping' = None
    ''' 

    :type: 'CurveMapping'
    '''

    length_mode: typing.Union[str, int] = None
    ''' * ``GROW`` Grow, Make hairs longer. * ``SHRINK`` Shrink, Make hairs shorter.

    :type: typing.Union[str, int]
    '''

    puff_mode: typing.Union[str, int] = None
    ''' * ``ADD`` Add, Make hairs more puffy. * ``SUB`` Sub, Make hairs less puffy.

    :type: typing.Union[str, int]
    '''

    size: int = None
    ''' Radius of the brush in pixels

    :type: int
    '''

    steps: int = None
    ''' Brush steps

    :type: int
    '''

    strength: float = None
    ''' Brush strength

    :type: float
    '''

    use_puff_volume: bool = None
    ''' Apply puff to unselected end-points (helps maintain hair volume when puffing root)

    :type: bool
    '''


class ParticleDupliWeight(bpy_struct):
    ''' Weight of a particle dupliobject in a group
    '''

    count: int = None
    ''' The number of times this object is repeated with respect to other objects

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Particle dupliobject name

    :type: typing.Union[str, typing.Any]
    '''


class ParticleEdit(bpy_struct):
    ''' Properties of particle editing mode
    '''

    brush: 'ParticleBrush' = None
    ''' 

    :type: 'ParticleBrush'
    '''

    default_key_count: int = None
    ''' How many keys to make new particles with

    :type: int
    '''

    draw_step: int = None
    ''' How many steps to draw the path with

    :type: int
    '''

    emitter_distance: float = None
    ''' Distance to keep particles away from the emitter

    :type: float
    '''

    fade_frames: int = None
    ''' How many frames to fade

    :type: int
    '''

    is_editable: typing.Union[bool, typing.Any] = None
    ''' A valid edit mode exists

    :type: typing.Union[bool, typing.Any]
    '''

    is_hair: typing.Union[bool, typing.Any] = None
    ''' Editing hair

    :type: typing.Union[bool, typing.Any]
    '''

    object: 'Object' = None
    ''' The edited object

    :type: 'Object'
    '''

    select_mode: typing.Union[str, int] = None
    ''' Particle select and display mode * ``PATH`` Path, Path edit mode. * ``POINT`` Point, Point select mode. * ``TIP`` Tip, Tip select mode.

    :type: typing.Union[str, int]
    '''

    shape_object: 'Object' = None
    ''' Outer shape to use for tools

    :type: 'Object'
    '''

    show_particles: bool = None
    ''' Draw actual particles

    :type: bool
    '''

    tool: typing.Union[str, int] = None
    ''' * ``NONE`` None, Don't use any brush. * ``COMB`` Comb, Comb hairs. * ``SMOOTH`` Smooth, Smooth hairs. * ``ADD`` Add, Add hairs. * ``LENGTH`` Length, Make hairs longer or shorter. * ``PUFF`` Puff, Make hairs stand up. * ``CUT`` Cut, Cut hairs. * ``WEIGHT`` Weight, Weight hair particles.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_auto_velocity: bool = None
    ''' Calculate point velocities automatically

    :type: bool
    '''

    use_default_interpolate: bool = None
    ''' Interpolate new particles from the existing ones

    :type: bool
    '''

    use_emitter_deflect: bool = None
    ''' Keep paths from intersecting the emitter

    :type: bool
    '''

    use_fade_time: bool = None
    ''' Fade paths and keys further away from current frame

    :type: bool
    '''

    use_preserve_length: bool = None
    ''' Keep path lengths constant

    :type: bool
    '''

    use_preserve_root: bool = None
    ''' Keep root keys unmodified

    :type: bool
    '''


class ParticleHairKey(bpy_struct):
    ''' Particle key for hair particle system
    '''

    co: bpy_prop_array[float] = None
    ''' Location of the hair key in object space

    :type: bpy_prop_array[float]
    '''

    co_local: bpy_prop_array[float] = None
    ''' Location of the hair key in its local coordinate system, relative to the emitting face

    :type: bpy_prop_array[float]
    '''

    time: float = None
    ''' Relative time of key over hair length

    :type: float
    '''

    weight: float = None
    ''' Weight for cloth simulation

    :type: float
    '''

    def co_object(self, object: 'Object', modifier: 'ParticleSystemModifier',
                  particle: 'Particle') -> bpy_prop_array[float]:
        ''' Obtain hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :rtype: bpy_prop_array[float]
        :return: Co, Exported hairkey location
        '''
        pass


class ParticleKey(bpy_struct):
    ''' Key location for a particle over time
    '''

    angular_velocity: bpy_prop_array[float] = None
    ''' Key angular velocity

    :type: bpy_prop_array[float]
    '''

    location: bpy_prop_array[float] = None
    ''' Key location

    :type: bpy_prop_array[float]
    '''

    rotation: bpy_prop_array[float] = None
    ''' Key rotation quaternion

    :type: bpy_prop_array[float]
    '''

    time: float = None
    ''' Time of key over the simulation

    :type: float
    '''

    velocity: bpy_prop_array[float] = None
    ''' Key velocity

    :type: bpy_prop_array[float]
    '''


class ParticleSystem(bpy_struct):
    ''' Particle system in an object
    '''

    active_particle_target: 'ParticleTarget' = None
    ''' 

    :type: 'ParticleTarget'
    '''

    active_particle_target_index: int = None
    ''' 

    :type: int
    '''

    billboard_normal_uv: typing.Union[str, typing.Any] = None
    ''' UV map to control billboard normals

    :type: typing.Union[str, typing.Any]
    '''

    billboard_split_uv: typing.Union[str, typing.Any] = None
    ''' UV map to control billboard splitting

    :type: typing.Union[str, typing.Any]
    '''

    billboard_time_index_uv: typing.Union[str, typing.Any] = None
    ''' UV map to control billboard time index (X-Y)

    :type: typing.Union[str, typing.Any]
    '''

    child_particles: bpy_prop_collection['ChildParticle'] = None
    ''' Child particles generated by the particle system

    :type: bpy_prop_collection['ChildParticle']
    '''

    child_seed: int = None
    ''' Offset in the random number table for child particles, to get a different randomized result

    :type: int
    '''

    cloth: 'ClothModifier' = None
    ''' Cloth dynamics for hair

    :type: 'ClothModifier'
    '''

    dt_frac: float = None
    ''' The current simulation time step size, as a fraction of a frame

    :type: float
    '''

    has_multiple_caches: typing.Union[bool, typing.Any] = None
    ''' Particle system has multiple point caches

    :type: typing.Union[bool, typing.Any]
    '''

    invert_vertex_group_clump: bool = None
    ''' Negate the effect of the clump vertex group

    :type: bool
    '''

    invert_vertex_group_density: bool = None
    ''' Negate the effect of the density vertex group

    :type: bool
    '''

    invert_vertex_group_field: bool = None
    ''' Negate the effect of the field vertex group

    :type: bool
    '''

    invert_vertex_group_kink: bool = None
    ''' Negate the effect of the kink vertex group

    :type: bool
    '''

    invert_vertex_group_length: bool = None
    ''' Negate the effect of the length vertex group

    :type: bool
    '''

    invert_vertex_group_rotation: bool = None
    ''' Negate the effect of the rotation vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_1: bool = None
    ''' Negate the effect of the roughness 1 vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_2: bool = None
    ''' Negate the effect of the roughness 2 vertex group

    :type: bool
    '''

    invert_vertex_group_roughness_end: bool = None
    ''' Negate the effect of the roughness end vertex group

    :type: bool
    '''

    invert_vertex_group_size: bool = None
    ''' Negate the effect of the size vertex group

    :type: bool
    '''

    invert_vertex_group_tangent: bool = None
    ''' Negate the effect of the tangent vertex group

    :type: bool
    '''

    invert_vertex_group_velocity: bool = None
    ''' Negate the effect of the velocity vertex group

    :type: bool
    '''

    is_editable: typing.Union[bool, typing.Any] = None
    ''' Particle system can be edited in particle mode

    :type: typing.Union[bool, typing.Any]
    '''

    is_edited: typing.Union[bool, typing.Any] = None
    ''' Particle system has been edited in particle mode

    :type: typing.Union[bool, typing.Any]
    '''

    is_global_hair: typing.Union[bool, typing.Any] = None
    ''' Hair keys are in global coordinate space

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Particle system name

    :type: typing.Union[str, typing.Any]
    '''

    parent: 'Object' = None
    ''' Use this object's coordinate system instead of global coordinate system

    :type: 'Object'
    '''

    particles: bpy_prop_collection['Particle'] = None
    ''' Particles generated by the particle system

    :type: bpy_prop_collection['Particle']
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    reactor_target_object: 'Object' = None
    ''' For reactor systems, the object that has the target particle system (empty if same object)

    :type: 'Object'
    '''

    reactor_target_particle_system: int = None
    ''' For reactor systems, index of particle system on the target object

    :type: int
    '''

    seed: int = None
    ''' Offset in the random number table, to get a different randomized result

    :type: int
    '''

    settings: 'ParticleSettings' = None
    ''' Particle system settings

    :type: 'ParticleSettings'
    '''

    targets: bpy_prop_collection['ParticleTarget'] = None
    ''' Target particle systems

    :type: bpy_prop_collection['ParticleTarget']
    '''

    use_hair_dynamics: bool = None
    ''' Enable hair dynamics using cloth simulation

    :type: bool
    '''

    use_keyed_timing: bool = None
    ''' Use key times

    :type: bool
    '''

    vertex_group_clump: typing.Union[str, typing.Any] = None
    ''' Vertex group to control clump

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_density: typing.Union[str, typing.Any] = None
    ''' Vertex group to control density

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_field: typing.Union[str, typing.Any] = None
    ''' Vertex group to control field

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_kink: typing.Union[str, typing.Any] = None
    ''' Vertex group to control kink

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_length: typing.Union[str, typing.Any] = None
    ''' Vertex group to control length

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_rotation: typing.Union[str, typing.Any] = None
    ''' Vertex group to control rotation

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_roughness_1: typing.Union[str, typing.Any] = None
    ''' Vertex group to control roughness 1

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_roughness_2: typing.Union[str, typing.Any] = None
    ''' Vertex group to control roughness 2

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_roughness_end: typing.Union[str, typing.Any] = None
    ''' Vertex group to control roughness end

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_size: typing.Union[str, typing.Any] = None
    ''' Vertex group to control size

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_tangent: typing.Union[str, typing.Any] = None
    ''' Vertex group to control tangent

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_velocity: typing.Union[str, typing.Any] = None
    ''' Vertex group to control velocity

    :type: typing.Union[str, typing.Any]
    '''

    def set_resolution(self,
                       scene: typing.Optional['Scene'] = None,
                       object: typing.Optional['Object'] = None,
                       resolution: typing.Optional[typing.Any] = 'PREVIEW'):
        ''' Set the resolution to use for the number of particles

        :param scene: Scene
        :type scene: typing.Optional['Scene']
        :param object: Object
        :type object: typing.Optional['Object']
        :param resolution: Resolution settings to apply * ``PREVIEW`` Preview, Apply modifier preview settings. * ``RENDER`` Render, Apply modifier render settings.
        :type resolution: typing.Optional[typing.Any]
        '''
        pass

    def co_hair(
            self,
            object: 'Object',
            particle_no: typing.Optional[typing.Any] = 0,
            step: typing.Optional[typing.Any] = 0) -> bpy_prop_array[float]:
        ''' Obtain cache hair data

        :param object: Object
        :type object: 'Object'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param step: step no
        :type step: typing.Optional[typing.Any]
        :rtype: bpy_prop_array[float]
        :return: Co, Exported hairkey location
        '''
        pass

    def uv_on_emitter(
            self,
            modifier: 'ParticleSystemModifier',
            particle: 'Particle',
            particle_no: typing.Optional[typing.Any] = 0,
            uv_no: typing.Optional[typing.Any] = 0) -> bpy_prop_array[float]:
        ''' Obtain uv for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param uv_no: UV no
        :type uv_no: typing.Optional[typing.Any]
        :rtype: bpy_prop_array[float]
        :return: uv
        '''
        pass

    def mcol_on_emitter(
            self,
            modifier: 'ParticleSystemModifier',
            particle: 'Particle',
            particle_no: typing.Optional[typing.Any] = 0,
            vcol_no: typing.Optional[typing.Any] = 0) -> bpy_prop_array[float]:
        ''' Obtain mcol for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param vcol_no: vcol no
        :type vcol_no: typing.Optional[typing.Any]
        :rtype: bpy_prop_array[float]
        :return: mcol
        '''
        pass


class ParticleTarget(bpy_struct):
    ''' Target particle system
    '''

    alliance: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    duration: float = None
    ''' 

    :type: float
    '''

    is_valid: bool = None
    ''' Keyed particles target is valid

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Particle target name

    :type: typing.Union[str, typing.Any]
    '''

    object: 'Object' = None
    ''' The object that has the target particle system (empty if same object)

    :type: 'Object'
    '''

    system: int = None
    ''' The index of particle system on the target object

    :type: int
    '''

    time: float = None
    ''' 

    :type: float
    '''


class PathCompare(bpy_struct):
    ''' Match paths against this value
    '''

    path: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    use_glob: bool = None
    ''' Enable wildcard globbing

    :type: bool
    '''


class PointCache(bpy_struct):
    ''' Point cache for physics simulations
    '''

    compression: typing.Union[str, int] = None
    ''' Compression method to be used * ``NO`` No, No compression. * ``LIGHT`` Light, Fast but not so effective compression. * ``HEAVY`` Heavy, Effective but slow compression.

    :type: typing.Union[str, int]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Cache file path

    :type: typing.Union[str, typing.Any]
    '''

    frame_end: int = None
    ''' Frame on which the simulation stops

    :type: int
    '''

    frame_start: int = None
    ''' Frame on which the simulation starts

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames between cached frames

    :type: int
    '''

    index: int = None
    ''' Index number of cache files

    :type: int
    '''

    info: typing.Union[str, typing.Any] = None
    ''' Info on current cache status

    :type: typing.Union[str, typing.Any]
    '''

    is_baked: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    is_baking: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    is_frame_skip: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    is_outdated: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Cache name

    :type: typing.Union[str, typing.Any]
    '''

    point_caches: 'PointCaches' = None
    ''' Point cache list

    :type: 'PointCaches'
    '''

    use_disk_cache: bool = None
    ''' Save cache files to disk (.blend file must be saved first)

    :type: bool
    '''

    use_external: bool = None
    ''' Read cache from an external location

    :type: bool
    '''

    use_library_path: bool = None
    ''' Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    '''


class PointDensity(bpy_struct):
    ''' Point density settings
    '''

    color_ramp: 'ColorRamp' = None
    ''' 

    :type: 'ColorRamp'
    '''

    falloff: typing.Union[str, int] = None
    ''' Method of attenuating density by distance from the point * ``STANDARD`` Standard. * ``SMOOTH`` Smooth. * ``SOFT`` Soft. * ``CONSTANT`` Constant, Density is constant within lookup radius. * ``ROOT`` Root. * ``PARTICLE_AGE`` Particle Age. * ``PARTICLE_VELOCITY`` Particle Velocity.

    :type: typing.Union[str, int]
    '''

    falloff_curve: 'CurveMapping' = None
    ''' 

    :type: 'CurveMapping'
    '''

    falloff_soft: float = None
    ''' Softness of the 'soft' falloff option

    :type: float
    '''

    falloff_speed_scale: float = None
    ''' Multiplier to bring particle speed within an acceptable range

    :type: float
    '''

    noise_basis: typing.Union[str, int] = None
    ''' Noise formula used for turbulence * ``BLENDER_ORIGINAL`` Blender Original, Noise algorithm - Blender original: Smooth interpolated noise. * ``ORIGINAL_PERLIN`` Original Perlin, Noise algorithm - Original Perlin: Smooth interpolated noise. * ``IMPROVED_PERLIN`` Improved Perlin, Noise algorithm - Improved Perlin: Smooth interpolated noise. * ``VORONOI_F1`` Voronoi F1, Noise algorithm - Voronoi F1: Returns distance to the closest feature point. * ``VORONOI_F2`` Voronoi F2, Noise algorithm - Voronoi F2: Returns distance to the 2nd closest feature point. * ``VORONOI_F3`` Voronoi F3, Noise algorithm - Voronoi F3: Returns distance to the 3rd closest feature point. * ``VORONOI_F4`` Voronoi F4, Noise algorithm - Voronoi F4: Returns distance to the 4th closest feature point. * ``VORONOI_F2_F1`` Voronoi F2-F1, Noise algorithm - Voronoi F1-F2. * ``VORONOI_CRACKLE`` Voronoi Crackle, Noise algorithm - Voronoi Crackle: Voronoi tessellation with sharp edges. * ``CELL_NOISE`` Cell Noise, Noise algorithm - Cell Noise: Square cell tessellation.

    :type: typing.Union[str, int]
    '''

    object: 'Object' = None
    ''' Object to take point data from

    :type: 'Object'
    '''

    particle_cache_space: typing.Union[str, int] = None
    ''' Coordinate system to cache particles in

    :type: typing.Union[str, int]
    '''

    particle_color_source: typing.Union[str, int] = None
    ''' Data to derive color results from * ``CONSTANT`` Constant. * ``PARTICLE_AGE`` Particle Age, Lifetime mapped as 0.0 - 1.0 intensity. * ``PARTICLE_SPEED`` Particle Speed, Particle speed (absolute magnitude of velocity) mapped as 0.0-1.0 intensity. * ``PARTICLE_VELOCITY`` Particle Velocity, XYZ velocity mapped to RGB colors.

    :type: typing.Union[str, int]
    '''

    particle_system: 'ParticleSystem' = None
    ''' Particle System to render as points

    :type: 'ParticleSystem'
    '''

    point_source: typing.Union[str, int] = None
    ''' Point data to use as renderable point density * ``PARTICLE_SYSTEM`` Particle System, Generate point density from a particle system. * ``OBJECT`` Object Vertices, Generate point density from an object's vertices.

    :type: typing.Union[str, int]
    '''

    radius: float = None
    ''' Radius from the shaded sample to look for points within

    :type: float
    '''

    speed_scale: float = None
    ''' Multiplier to bring particle speed within an acceptable range

    :type: float
    '''

    turbulence_depth: int = None
    ''' Level of detail in the added turbulent noise

    :type: int
    '''

    turbulence_influence: typing.Union[str, int] = None
    ''' Method for driving added turbulent noise * ``STATIC`` Static, Noise patterns will remain unchanged, faster and suitable for stills. * ``PARTICLE_VELOCITY`` Particle Velocity, Turbulent noise driven by particle velocity. * ``PARTICLE_AGE`` Particle Age, Turbulent noise driven by the particle's age between birth and death. * ``GLOBAL_TIME`` Global Time, Turbulent noise driven by the global current frame.

    :type: typing.Union[str, int]
    '''

    turbulence_scale: float = None
    ''' Scale of the added turbulent noise

    :type: float
    '''

    turbulence_strength: float = None
    ''' Strength of the added turbulent noise

    :type: float
    '''

    use_falloff_curve: bool = None
    ''' Use a custom falloff curve

    :type: bool
    '''

    use_turbulence: bool = None
    ''' Add directed noise to the density at render-time

    :type: bool
    '''

    vertex_attribute_name: typing.Union[str, typing.Any] = None
    ''' Vertex attribute to use for color

    :type: typing.Union[str, typing.Any]
    '''

    vertex_cache_space: typing.Union[str, int] = None
    ''' Coordinate system to cache vertices in

    :type: typing.Union[str, int]
    '''

    vertex_color_source: typing.Union[str, int] = None
    ''' Data to derive color results from * ``CONSTANT`` Constant. * ``VERTEX_COLOR`` Vertex Color, Vertex color layer. * ``VERTEX_WEIGHT`` Vertex Weight, Vertex group weight. * ``VERTEX_NORMAL`` Vertex Normal, XYZ normal vector mapped to RGB colors.

    :type: typing.Union[str, int]
    '''


class Pose(bpy_struct):
    ''' A collection of pose channels, including settings for animating bones
    '''

    animation_visualization: 'AnimViz' = None
    ''' Animation data for this data-block

    :type: 'AnimViz'
    '''

    bone_groups: 'BoneGroups' = None
    ''' Groups of the bones

    :type: 'BoneGroups'
    '''

    bones: bpy_prop_collection['PoseBone'] = None
    ''' Individual pose bones for the armature

    :type: bpy_prop_collection['PoseBone']
    '''

    ik_param: 'IKParam' = None
    ''' Parameters for IK solver

    :type: 'IKParam'
    '''

    ik_solver: typing.Union[str, int] = None
    ''' Selection of IK solver for IK chain * ``LEGACY`` Standard, Original IK solver. * ``ITASC`` iTaSC, Multi constraint, stateful IK solver.

    :type: typing.Union[str, int]
    '''


class PoseBone(bpy_struct):
    ''' Channel defining pose data for a bone in a Pose
    '''

    bbone_curveinx: float = None
    ''' X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveiny: float = None
    ''' Y-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveoutx: float = None
    ''' X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_curveouty: float = None
    ''' Y-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    '''

    bbone_custom_handle_end: 'PoseBone' = None
    ''' Bone that serves as the end handle for the B-Bone curve

    :type: 'PoseBone'
    '''

    bbone_custom_handle_start: 'PoseBone' = None
    ''' Bone that serves as the start handle for the B-Bone curve

    :type: 'PoseBone'
    '''

    bbone_rollin: float = None
    ''' Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_rollout: float = None
    ''' Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    '''

    bbone_scalein: float = None
    ''' Scale factor for start of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bbone_scaleout: float = None
    ''' Scale factor for end of the B-Bone, adjusts thickness (for tapering effects)

    :type: float
    '''

    bone: 'Bone' = None
    ''' Bone associated with this PoseBone

    :type: 'Bone'
    '''

    bone_group: 'BoneGroup' = None
    ''' Bone Group this pose channel belongs to

    :type: 'BoneGroup'
    '''

    bone_group_index: int = None
    ''' Bone Group this pose channel belongs to (0=no group)

    :type: int
    '''

    child: 'PoseBone' = None
    ''' Child of this pose bone

    :type: 'PoseBone'
    '''

    constraints: 'PoseBoneConstraints' = None
    ''' Constraints that act on this PoseChannel

    :type: 'PoseBoneConstraints'
    '''

    custom_shape: 'Object' = None
    ''' Object that defines custom draw type for this bone

    :type: 'Object'
    '''

    custom_shape_scale: float = None
    ''' Adjust the size of the custom shape

    :type: float
    '''

    custom_shape_transform: 'PoseBone' = None
    ''' Bone that defines the display transform of this custom shape

    :type: 'PoseBone'
    '''

    head: bpy_prop_array[float] = None
    ''' Location of head of the channel's bone

    :type: bpy_prop_array[float]
    '''

    ik_linear_weight: float = None
    ''' Weight of scale constraint for IK

    :type: float
    '''

    ik_max_x: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_max_y: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_max_z: float = None
    ''' Maximum angles for IK Limit

    :type: float
    '''

    ik_min_x: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_min_y: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_min_z: float = None
    ''' Minimum angles for IK Limit

    :type: float
    '''

    ik_rotation_weight: float = None
    ''' Weight of rotation constraint for IK

    :type: float
    '''

    ik_stiffness_x: float = None
    ''' IK stiffness around the X axis

    :type: float
    '''

    ik_stiffness_y: float = None
    ''' IK stiffness around the Y axis

    :type: float
    '''

    ik_stiffness_z: float = None
    ''' IK stiffness around the Z axis

    :type: float
    '''

    ik_stretch: float = None
    ''' Allow scaling of the bone for IK

    :type: float
    '''

    is_in_ik_chain: typing.Union[bool, typing.Any] = None
    ''' Is part of an IK chain

    :type: typing.Union[bool, typing.Any]
    '''

    location: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    lock_ik_x: bool = None
    ''' Disallow movement around the X axis

    :type: bool
    '''

    lock_ik_y: bool = None
    ''' Disallow movement around the Y axis

    :type: bool
    '''

    lock_ik_z: bool = None
    ''' Disallow movement around the Z axis

    :type: bool
    '''

    lock_location: typing.List[bool] = None
    ''' Lock editing of location in the interface

    :type: typing.List[bool]
    '''

    lock_rotation: typing.List[bool] = None
    ''' Lock editing of rotation in the interface

    :type: typing.List[bool]
    '''

    lock_rotation_w: bool = None
    ''' Lock editing of 'angle' component of four-component rotations in the interface

    :type: bool
    '''

    lock_rotations_4d: bool = None
    ''' Lock editing of four component rotations by components (instead of as Eulers)

    :type: bool
    '''

    lock_scale: typing.List[bool] = None
    ''' Lock editing of scale in the interface

    :type: typing.List[bool]
    '''

    matrix: bpy_prop_array[float] = None
    ''' Final 4x4 matrix after constraints and drivers are applied (object space)

    :type: bpy_prop_array[float]
    '''

    matrix_basis: bpy_prop_array[float] = None
    ''' Alternative access to location/scale/rotation relative to the parent and own rest bone

    :type: bpy_prop_array[float]
    '''

    matrix_channel: bpy_prop_array[float] = None
    ''' 4x4 matrix, before constraints

    :type: bpy_prop_array[float]
    '''

    motion_path: 'MotionPath' = None
    ''' Motion Path for this element

    :type: 'MotionPath'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    parent: 'PoseBone' = None
    ''' Parent of this pose bone

    :type: 'PoseBone'
    '''

    rotation_axis_angle: bpy_prop_array[float] = None
    ''' Angle of Rotation for Axis-Angle rotation representation

    :type: bpy_prop_array[float]
    '''

    rotation_euler: bpy_prop_array[float] = None
    ''' Rotation in Eulers

    :type: bpy_prop_array[float]
    '''

    rotation_mode: typing.Union[str, int] = None
    ''' * ``QUATERNION`` Quaternion (WXYZ), No Gimbal Lock (default). * ``XYZ`` XYZ Euler, XYZ Rotation Order (prone to Gimbal Lock). * ``XZY`` XZY Euler, XZY Rotation Order (prone to Gimbal Lock). * ``YXZ`` YXZ Euler, YXZ Rotation Order (prone to Gimbal Lock). * ``YZX`` YZX Euler, YZX Rotation Order (prone to Gimbal Lock). * ``ZXY`` ZXY Euler, ZXY Rotation Order (prone to Gimbal Lock). * ``ZYX`` ZYX Euler, ZYX Rotation Order (prone to Gimbal Lock). * ``AXIS_ANGLE`` Axis Angle, Axis Angle (W+XYZ), defines a rotation around some axis defined by 3D-Vector.

    :type: typing.Union[str, int]
    '''

    rotation_quaternion: bpy_prop_array[float] = None
    ''' Rotation in Quaternions

    :type: bpy_prop_array[float]
    '''

    scale: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tail: bpy_prop_array[float] = None
    ''' Location of tail of the channel's bone

    :type: bpy_prop_array[float]
    '''

    use_bbone_custom_handles: bool = None
    ''' Use custom reference bones as handles for B-Bones instead of next/previous bones, leave these blank to use only B-Bone offset properties to control the shape

    :type: bool
    '''

    use_bbone_relative_end_handle: bool = None
    ''' Treat custom end handle position as a relative value

    :type: bool
    '''

    use_bbone_relative_start_handle: bool = None
    ''' Treat custom start handle position as a relative value

    :type: bool
    '''

    use_custom_shape_bone_size: bool = None
    ''' Scale the custom object by the bone length

    :type: bool
    '''

    use_ik_limit_x: bool = None
    ''' Limit movement around the X axis

    :type: bool
    '''

    use_ik_limit_y: bool = None
    ''' Limit movement around the Y axis

    :type: bool
    '''

    use_ik_limit_z: bool = None
    ''' Limit movement around the Z axis

    :type: bool
    '''

    use_ik_linear_control: bool = None
    ''' Apply channel size as IK constraint if stretching is enabled

    :type: bool
    '''

    use_ik_rotation_control: bool = None
    ''' Apply channel rotation as IK constraint

    :type: bool
    '''

    basename = None
    ''' The name of this bone before any '.' character (readonly)'''

    center = None
    ''' The midpoint between the head and the tail. (readonly)'''

    children = None
    ''' (readonly)'''

    children_recursive = None
    ''' A list of all children from this bone. (readonly)'''

    children_recursive_basename = None
    ''' Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. (readonly)'''

    length = None
    ''' The distance from head to tail, when set the head is moved to fit the length.'''

    parent_recursive = None
    ''' A list of parents, starting with the immediate parent (readonly)'''

    vector = None
    ''' The direction this bone is pointing. Utility function for (tail - head) (readonly)'''

    x_axis = None
    ''' Vector pointing down the x-axis of the bone. (readonly)'''

    y_axis = None
    ''' Vector pointing down the y-axis of the bone. (readonly)'''

    z_axis = None
    ''' Vector pointing down the z-axis of the bone. (readonly)'''

    def evaluate_envelope(
            self, point: typing.Optional[typing.Iterable[float]]) -> float:
        ''' Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Optional[typing.Iterable[float]]
        :rtype: float
        :return: Factor, Envelope factor
        '''
        pass

    def parent_index(self, parent_test):
        ''' The same as 'bone in other_bone.parent_recursive' but saved generating a list.

        '''
        pass

    def translate(self, vec):
        ''' Utility function to add *vec* to the head and tail of this bone

        '''
        pass


class Property(bpy_struct):
    ''' RNA property definition
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Description of the property for tooltips

    :type: typing.Union[str, typing.Any]
    '''

    icon: typing.Union[str, int] = None
    ''' Icon of the item

    :type: typing.Union[str, int]
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    is_animatable: typing.Union[bool, typing.Any] = None
    ''' Property is animatable through RNA

    :type: typing.Union[bool, typing.Any]
    '''

    is_argument_optional: typing.Union[bool, typing.Any] = None
    ''' True when the property is optional in a Python function implementing an RNA function

    :type: typing.Union[bool, typing.Any]
    '''

    is_enum_flag: typing.Union[bool, typing.Any] = None
    ''' True when multiple enums

    :type: typing.Union[bool, typing.Any]
    '''

    is_hidden: typing.Union[bool, typing.Any] = None
    ''' True when the property is hidden

    :type: typing.Union[bool, typing.Any]
    '''

    is_library_editable: typing.Union[bool, typing.Any] = None
    ''' Property is editable from linked instances (changes not saved)

    :type: typing.Union[bool, typing.Any]
    '''

    is_never_none: typing.Union[bool, typing.Any] = None
    ''' True when this value can't be set to None

    :type: typing.Union[bool, typing.Any]
    '''

    is_output: typing.Union[bool, typing.Any] = None
    ''' True when this property is an output value from an RNA function

    :type: typing.Union[bool, typing.Any]
    '''

    is_readonly: typing.Union[bool, typing.Any] = None
    ''' Property is editable through RNA

    :type: typing.Union[bool, typing.Any]
    '''

    is_registered: typing.Union[bool, typing.Any] = None
    ''' Property is registered as part of type registration

    :type: typing.Union[bool, typing.Any]
    '''

    is_registered_optional: typing.Union[bool, typing.Any] = None
    ''' Property is optionally registered as part of type registration

    :type: typing.Union[bool, typing.Any]
    '''

    is_required: typing.Union[bool, typing.Any] = None
    ''' False when this property is an optional argument in an RNA function

    :type: typing.Union[bool, typing.Any]
    '''

    is_runtime: typing.Union[bool, typing.Any] = None
    ''' Property has been dynamically created at runtime

    :type: typing.Union[bool, typing.Any]
    '''

    is_skip_save: typing.Union[bool, typing.Any] = None
    ''' True when the property is not saved in presets

    :type: typing.Union[bool, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Human readable name

    :type: typing.Union[str, typing.Any]
    '''

    srna: 'Struct' = None
    ''' Struct definition used for properties assigned to this item

    :type: 'Struct'
    '''

    subtype: typing.Union[str, int] = None
    ''' Semantic interpretation of the property

    :type: typing.Union[str, int]
    '''

    translation_context: typing.Union[str, typing.Any] = None
    ''' Translation context of the property's name

    :type: typing.Union[str, typing.Any]
    '''

    type: typing.Union[str, int] = None
    ''' Data type of the property

    :type: typing.Union[str, int]
    '''

    unit: typing.Union[str, int] = None
    ''' Type of units for this property

    :type: typing.Union[str, int]
    '''


class PropertyGroup(bpy_struct):
    ''' Group of ID properties
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''


class PropertyGroupItem(bpy_struct):
    ''' Property that stores arbitrary, user defined properties
    '''

    collection: bpy_prop_collection['PropertyGroup'] = None
    ''' 

    :type: bpy_prop_collection['PropertyGroup']
    '''

    double: float = None
    ''' 

    :type: float
    '''

    double_array: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    float: float = None
    ''' 

    :type: float
    '''

    float_array: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    group: 'PropertyGroup' = None
    ''' 

    :type: 'PropertyGroup'
    '''

    idp_array: bpy_prop_collection['PropertyGroup'] = None
    ''' 

    :type: bpy_prop_collection['PropertyGroup']
    '''

    int: int = None
    ''' 

    :type: int
    '''

    int_array: bpy_prop_array[int] = None
    ''' 

    :type: bpy_prop_array[int]
    '''

    string: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class Region(bpy_struct):
    ''' Region in a subdivided screen area
    '''

    height: int = None
    ''' Region height

    :type: int
    '''

    id: int = None
    ''' Unique ID for this region

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Type of this region

    :type: typing.Union[str, int]
    '''

    view2d: 'View2D' = None
    ''' 2D view of the region

    :type: 'View2D'
    '''

    width: int = None
    ''' Region width

    :type: int
    '''

    x: int = None
    ''' The window relative vertical location of the region

    :type: int
    '''

    y: int = None
    ''' The window relative horizontal location of the region

    :type: int
    '''

    def tag_redraw(self):
        ''' tag_redraw

        '''
        pass


class RegionView3D(bpy_struct):
    ''' 3D View region data
    '''

    is_perspective: bool = None
    ''' 

    :type: bool
    '''

    lock_rotation: bool = None
    ''' Lock view rotation in side views

    :type: bool
    '''

    perspective_matrix: bpy_prop_array[float] = None
    ''' Current perspective matrix (``window_matrix * view_matrix``)

    :type: bpy_prop_array[float]
    '''

    show_sync_view: bool = None
    ''' Sync view position between side views

    :type: bool
    '''

    use_box_clip: bool = None
    ''' Clip objects based on what's visible in other side views

    :type: bool
    '''

    view_camera_offset: bpy_prop_array[float] = None
    ''' View shift in camera view

    :type: bpy_prop_array[float]
    '''

    view_camera_zoom: float = None
    ''' Zoom factor in camera view

    :type: float
    '''

    view_distance: float = None
    ''' Distance to the view location

    :type: float
    '''

    view_location: bpy_prop_array[float] = None
    ''' View pivot location

    :type: bpy_prop_array[float]
    '''

    view_matrix: bpy_prop_array[float] = None
    ''' Current view matrix

    :type: bpy_prop_array[float]
    '''

    view_perspective: typing.Union[str, int] = None
    ''' View Perspective

    :type: typing.Union[str, int]
    '''

    view_rotation: bpy_prop_array[float] = None
    ''' Rotation in quaternions (keep normalized)

    :type: bpy_prop_array[float]
    '''

    window_matrix: bpy_prop_array[float] = None
    ''' Current window matrix

    :type: bpy_prop_array[float]
    '''

    def update(self):
        ''' Recalculate the view matrices

        '''
        pass


class RenderEngine(bpy_struct):
    ''' Render engine
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_use_exclude_layers: bool = None
    ''' 

    :type: bool
    '''

    bl_use_postprocess: bool = None
    ''' 

    :type: bool
    '''

    bl_use_preview: bool = None
    ''' 

    :type: bool
    '''

    bl_use_save_buffers: bool = None
    ''' 

    :type: bool
    '''

    bl_use_shading_nodes: bool = None
    ''' 

    :type: bool
    '''

    bl_use_shading_nodes_custom: bool = None
    ''' 

    :type: bool
    '''

    bl_use_spherical_stereo: bool = None
    ''' 

    :type: bool
    '''

    bl_use_texture_preview: bool = None
    ''' 

    :type: bool
    '''

    camera_override: 'Object' = None
    ''' 

    :type: 'Object'
    '''

    is_animation: bool = None
    ''' 

    :type: bool
    '''

    is_preview: bool = None
    ''' 

    :type: bool
    '''

    layer_override: typing.List[bool] = None
    ''' 

    :type: typing.List[bool]
    '''

    render: 'RenderSettings' = None
    ''' 

    :type: 'RenderSettings'
    '''

    resolution_x: int = None
    ''' 

    :type: int
    '''

    resolution_y: int = None
    ''' 

    :type: int
    '''

    tile_x: int = None
    ''' 

    :type: int
    '''

    tile_y: int = None
    ''' 

    :type: int
    '''

    use_highlight_tiles: bool = None
    ''' 

    :type: bool
    '''

    def update(self,
               data: typing.Optional['BlendData'] = None,
               scene: typing.Optional['Scene'] = None):
        ''' Export scene data for render

        :param data: 
        :type data: typing.Optional['BlendData']
        :param scene: 
        :type scene: typing.Optional['Scene']
        '''
        pass

    def render(self, scene: typing.Optional['Scene'] = None):
        ''' Render scene into an image

        :param scene: 
        :type scene: typing.Optional['Scene']
        '''
        pass

    def bake(self, scene: typing.Optional['Scene'],
             object: typing.Optional['Object'],
             pass_type: typing.Optional[typing.Union[str, int]],
             pass_filter: typing.Optional[int],
             object_id: typing.Optional[int],
             pixel_array: typing.Optional['BakePixel'],
             num_pixels: typing.Optional[int], depth: typing.Optional[int],
             result: typing.Optional[typing.Any]):
        ''' Bake passes

        :param scene: 
        :type scene: typing.Optional['Scene']
        :param object: 
        :type object: typing.Optional['Object']
        :param pass_type: Pass, Pass to bake
        :type pass_type: typing.Optional[typing.Union[str, int]]
        :param pass_filter: Pass Filter, Filter to combined, diffuse, glossy, transmission and subsurface passes
        :type pass_filter: typing.Optional[int]
        :param object_id: Object Id, Id of the current object being baked in relation to the others
        :type object_id: typing.Optional[int]
        :param pixel_array: 
        :type pixel_array: typing.Optional['BakePixel']
        :param num_pixels: Number of Pixels, Size of the baking batch
        :type num_pixels: typing.Optional[int]
        :param depth: Pixels depth, Number of channels
        :type depth: typing.Optional[int]
        :param result: 
        :type result: typing.Optional[typing.Any]
        '''
        pass

    def view_update(self, context: typing.Optional['Context'] = None):
        ''' Update on data changes for viewport render

        :param context: 
        :type context: typing.Optional['Context']
        '''
        pass

    def view_draw(self, context: typing.Optional['Context'] = None):
        ''' Draw viewport render

        :param context: 
        :type context: typing.Optional['Context']
        '''
        pass

    def update_script_node(self, node: typing.Optional['Node'] = None):
        ''' Compile shader script node

        :param node: 
        :type node: typing.Optional['Node']
        '''
        pass

    def tag_redraw(self):
        ''' Request redraw for viewport rendering

        '''
        pass

    def tag_update(self):
        ''' Request update call for viewport rendering

        '''
        pass

    def begin_result(
            self,
            x: typing.Optional[int],
            y: typing.Optional[int],
            w: typing.Optional[int],
            h: typing.Optional[int],
            layer: typing.Union[str, typing.Any] = "",
            view: typing.Union[str, typing.Any] = "") -> 'RenderResult':
        ''' Create render result to write linear floating point render layers and passes

        :param x: X
        :type x: typing.Optional[int]
        :param y: Y
        :type y: typing.Optional[int]
        :param w: Width
        :type w: typing.Optional[int]
        :param h: Height
        :type h: typing.Optional[int]
        :param layer: Layer, Single layer to get render result for
        :type layer: typing.Union[str, typing.Any]
        :param view: View, Single view to get render result for
        :type view: typing.Union[str, typing.Any]
        :rtype: 'RenderResult'
        :return: Result
        '''
        pass

    def update_result(self, result: typing.Optional['RenderResult']):
        ''' Signal that pixels have been updated and can be redrawn in the user interface

        :param result: Result
        :type result: typing.Optional['RenderResult']
        '''
        pass

    def end_result(
            self,
            result: typing.Optional['RenderResult'],
            cancel: typing.Optional[typing.Union[bool, typing.Any]] = False,
            do_merge_results: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = False):
        ''' All pixels in the render result have been set and are final

        :param result: Result
        :type result: typing.Optional['RenderResult']
        :param cancel: Cancel, Don't mark tile as done, don't merge results unless forced
        :type cancel: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_merge_results: Merge Results, Merge results even if cancel=true
        :type do_merge_results: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def test_break(self) -> bool:
        ''' Test if the render operation should been canceled, this is a fast call that should be used regularly for responsiveness

        :rtype: bool
        :return: Break
        '''
        pass

    def active_view_get(self) -> typing.Union[str, typing.Any]:
        ''' active_view_get

        :rtype: typing.Union[str, typing.Any]
        :return: View, Single view active
        '''
        pass

    def active_view_set(self, view: typing.Union[str, typing.Any] = ""):
        ''' active_view_set

        :param view: View, Single view to set as active
        :type view: typing.Union[str, typing.Any]
        '''
        pass

    def camera_shift_x(self,
                       camera: typing.Optional['Object'],
                       use_spherical_stereo: typing.Optional[
                           typing.Union[bool, typing.Any]] = False) -> float:
        ''' camera_shift_x

        :param camera: 
        :type camera: typing.Optional['Object']
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: float
        :return: Shift X
        '''
        pass

    def camera_model_matrix(
            self,
            camera: typing.Optional['Object'],
            use_spherical_stereo: typing.Optional[typing.Union[bool, typing.
                                                               Any]] = False,
            *,
            r_model_matrix: typing.Optional[typing.Iterable[float]]):
        ''' camera_model_matrix

        :param camera: 
        :type camera: typing.Optional['Object']
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]]
        :param r_model_matrix: Model Matrix, Normalized camera model matrix
        :type r_model_matrix: typing.Optional[typing.Iterable[float]]
        '''
        pass

    def use_spherical_stereo(self, camera: typing.Optional['Object']) -> bool:
        ''' use_spherical_stereo

        :param camera: 
        :type camera: typing.Optional['Object']
        :rtype: bool
        :return: Spherical Stereo
        '''
        pass

    def update_stats(self, stats: typing.Union[str, typing.Any],
                     info: typing.Union[str, typing.Any]):
        ''' Update and signal to redraw render status text

        :param stats: Stats
        :type stats: typing.Union[str, typing.Any]
        :param info: Info
        :type info: typing.Union[str, typing.Any]
        '''
        pass

    def frame_set(self, frame: typing.Optional[int],
                  subframe: typing.Optional[float]):
        ''' Evaluate scene at a different frame (for motion blur)

        :param frame: Frame
        :type frame: typing.Optional[int]
        :param subframe: Subframe
        :type subframe: typing.Optional[float]
        '''
        pass

    def update_progress(self, progress: typing.Optional[float]):
        ''' Update progress percentage of render

        :param progress: Percentage of render that's done
        :type progress: typing.Optional[float]
        '''
        pass

    def update_memory_stats(self,
                            memory_used: typing.Optional[typing.Any] = 0.0,
                            memory_peak: typing.Optional[typing.Any] = 0.0):
        ''' Update memory usage statistics

        :param memory_used: Current memory usage in megabytes
        :type memory_used: typing.Optional[typing.Any]
        :param memory_peak: Peak memory usage in megabytes
        :type memory_peak: typing.Optional[typing.Any]
        '''
        pass

    def report(self, type: typing.Optional[
            typing.Union[typing.Set[str], typing.Set[int]]],
               message: typing.Union[str, typing.Any]):
        ''' Report info, warning or error messages

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[str], typing.Set[int]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        '''
        pass

    def error_set(self, message: typing.Union[str, typing.Any]):
        ''' Set error message displaying after the render is finished

        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        '''
        pass

    def bind_display_space_shader(self, scene: typing.Optional['Scene']):
        ''' Bind GLSL fragment shader that converts linear colors to display space colors using scene color management settings

        :param scene: 
        :type scene: typing.Optional['Scene']
        '''
        pass

    def unbind_display_space_shader(self):
        ''' Unbind GLSL display space shader, must always be called after binding the shader

        '''
        pass

    def support_display_space_shader(self,
                                     scene: typing.Optional['Scene']) -> bool:
        ''' Test if GLSL display space shader is supported for the combination of graphics card and scene settings

        :param scene: 
        :type scene: typing.Optional['Scene']
        :rtype: bool
        :return: Supported
        '''
        pass


class RenderLayer(bpy_struct):
    exclude_ambient_occlusion: typing.Union[bool, typing.Any] = None
    ''' Exclude AO pass from combined

    :type: typing.Union[bool, typing.Any]
    '''

    exclude_emit: typing.Union[bool, typing.Any] = None
    ''' Exclude emission pass from combined

    :type: typing.Union[bool, typing.Any]
    '''

    exclude_environment: typing.Union[bool, typing.Any] = None
    ''' Exclude environment pass from combined

    :type: typing.Union[bool, typing.Any]
    '''

    exclude_indirect: typing.Union[bool, typing.Any] = None
    ''' Exclude indirect pass from combined

    :type: typing.Union[bool, typing.Any]
    '''

    exclude_reflection: typing.Union[bool, typing.Any] = None
    ''' Exclude raytraced reflection pass from combined

    :type: typing.Union[bool, typing.Any]
    '''

    exclude_refraction: typing.Union[bool, typing.Any] = None
    ''' Exclude raytraced refraction pass from combined

    :type: typing.Union[bool, typing.Any]
    '''

    exclude_shadow: typing.Union[bool, typing.Any] = None
    ''' Exclude shadow pass from combined

    :type: typing.Union[bool, typing.Any]
    '''

    exclude_specular: typing.Union[bool, typing.Any] = None
    ''' Exclude specular pass from combined

    :type: typing.Union[bool, typing.Any]
    '''

    invert_zmask: typing.Union[bool, typing.Any] = None
    ''' For Zmask, only render what is behind solid z values instead of in front

    :type: typing.Union[bool, typing.Any]
    '''

    layers: typing.List[bool] = None
    ''' Scene layers included in this render layer

    :type: typing.List[bool]
    '''

    layers_exclude: typing.List[bool] = None
    ''' Exclude scene layers from having any influence

    :type: typing.List[bool]
    '''

    layers_zmask: typing.List[bool] = None
    ''' Zmask scene layers for solid faces

    :type: typing.List[bool]
    '''

    light_override: 'Group' = None
    ''' Group to override all other lights in this render layer

    :type: 'Group'
    '''

    material_override: 'Material' = None
    ''' Material to override all other materials in this render layer

    :type: 'Material'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Render layer name

    :type: typing.Union[str, typing.Any]
    '''

    passes: 'RenderPasses' = None
    ''' 

    :type: 'RenderPasses'
    '''

    use: typing.Union[bool, typing.Any] = None
    ''' Disable or enable the render layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_all_z: typing.Union[bool, typing.Any] = None
    ''' Fill in Z values for solid faces in invisible layers, for masking

    :type: typing.Union[bool, typing.Any]
    '''

    use_ao: typing.Union[bool, typing.Any] = None
    ''' Render AO in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_edge_enhance: typing.Union[bool, typing.Any] = None
    ''' Render Edge-enhance in this Layer (only works for Solid faces)

    :type: typing.Union[bool, typing.Any]
    '''

    use_freestyle: typing.Union[bool, typing.Any] = None
    ''' Render stylized strokes in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_halo: typing.Union[bool, typing.Any] = None
    ''' Render Halos in this Layer (on top of Solid)

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_ambient_occlusion: typing.Union[bool, typing.Any] = None
    ''' Deliver AO pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_color: typing.Union[bool, typing.Any] = None
    ''' Deliver shade-less color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_combined: typing.Union[bool, typing.Any] = None
    ''' Deliver full combined RGBA buffer

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_diffuse: typing.Union[bool, typing.Any] = None
    ''' Deliver diffuse pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_diffuse_color: typing.Union[bool, typing.Any] = None
    ''' Deliver diffuse color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_diffuse_direct: typing.Union[bool, typing.Any] = None
    ''' Deliver diffuse direct pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_diffuse_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver diffuse indirect pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_emit: typing.Union[bool, typing.Any] = None
    ''' Deliver emission pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_environment: typing.Union[bool, typing.Any] = None
    ''' Deliver environment lighting pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_glossy_color: typing.Union[bool, typing.Any] = None
    ''' Deliver glossy color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_glossy_direct: typing.Union[bool, typing.Any] = None
    ''' Deliver glossy direct pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_glossy_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver glossy indirect pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver indirect lighting pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_material_index: typing.Union[bool, typing.Any] = None
    ''' Deliver material index pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_mist: typing.Union[bool, typing.Any] = None
    ''' Deliver mist factor pass (0.0-1.0)

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_normal: typing.Union[bool, typing.Any] = None
    ''' Deliver normal pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_object_index: typing.Union[bool, typing.Any] = None
    ''' Deliver object index pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_reflection: typing.Union[bool, typing.Any] = None
    ''' Deliver raytraced reflection pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_refraction: typing.Union[bool, typing.Any] = None
    ''' Deliver raytraced refraction pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_shadow: typing.Union[bool, typing.Any] = None
    ''' Deliver shadow pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_specular: typing.Union[bool, typing.Any] = None
    ''' Deliver specular pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_subsurface_color: typing.Union[bool, typing.Any] = None
    ''' Deliver subsurface color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_subsurface_direct: typing.Union[bool, typing.Any] = None
    ''' Deliver subsurface direct pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_subsurface_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver subsurface indirect pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_transmission_color: typing.Union[bool, typing.Any] = None
    ''' Deliver transmission color pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_transmission_direct: typing.Union[bool, typing.Any] = None
    ''' Deliver transmission direct pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_transmission_indirect: typing.Union[bool, typing.Any] = None
    ''' Deliver transmission indirect pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_uv: typing.Union[bool, typing.Any] = None
    ''' Deliver texture UV pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_vector: typing.Union[bool, typing.Any] = None
    ''' Deliver speed vector pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_pass_z: typing.Union[bool, typing.Any] = None
    ''' Deliver Z values pass

    :type: typing.Union[bool, typing.Any]
    '''

    use_sky: typing.Union[bool, typing.Any] = None
    ''' Render Sky in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_solid: typing.Union[bool, typing.Any] = None
    ''' Render Solid faces in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_strand: typing.Union[bool, typing.Any] = None
    ''' Render Strands in this Layer

    :type: typing.Union[bool, typing.Any]
    '''

    use_zmask: typing.Union[bool, typing.Any] = None
    ''' Only render what's in front of the solid z values

    :type: typing.Union[bool, typing.Any]
    '''

    use_ztransp: typing.Union[bool, typing.Any] = None
    ''' Render Z-Transparent faces in this Layer (on top of Solid and Halos)

    :type: typing.Union[bool, typing.Any]
    '''

    def load_from_file(self,
                       filename: typing.Union[str, typing.Any],
                       x: typing.Optional[typing.Any] = 0,
                       y: typing.Optional[typing.Any] = 0):
        ''' Copies the pixels of this renderlayer from an image file

        :param filename: Filename, Filename to load into this render tile, must be no smaller than the renderlayer
        :type filename: typing.Union[str, typing.Any]
        :param x: Offset X, Offset the position to copy from if the image is larger than the render layer
        :type x: typing.Optional[typing.Any]
        :param y: Offset Y, Offset the position to copy from if the image is larger than the render layer
        :type y: typing.Optional[typing.Any]
        '''
        pass


class RenderPass(bpy_struct):
    channel_id: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    channels: int = None
    ''' 

    :type: int
    '''

    debug_type: typing.Union[str, int] = None
    ''' * ``BVH_TRAVERSED_NODES`` BVH Traversed Nodes, Number of nodes traversed in BVH for the camera rays. * ``BVH_TRAVERSED_INSTANCES`` BVH Traversed Instances, Number of BVH instances traversed by camera rays. * ``BVH_INTERSECTIONS`` BVH Intersections, Number of primitive intersections performed by the camera rays. * ``RAY_BOUNCES`` Ray Steps, Number of bounces done by the main integration loop.

    :type: typing.Union[str, int]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    rect: float = None
    ''' 

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    view_id: int = None
    ''' 

    :type: int
    '''


class RenderResult(bpy_struct):
    ''' Result of rendering, including all layers and passes
    '''

    layers: bpy_prop_collection['RenderLayer'] = None
    ''' 

    :type: bpy_prop_collection['RenderLayer']
    '''

    resolution_x: int = None
    ''' 

    :type: int
    '''

    resolution_y: int = None
    ''' 

    :type: int
    '''

    views: bpy_prop_collection['RenderView'] = None
    ''' 

    :type: bpy_prop_collection['RenderView']
    '''

    def load_from_file(self, filename: typing.Union[str, typing.Any]):
        ''' Copies the pixels of this render result from an image file

        :param filename: File Name, Filename to load into this render tile, must be no smaller than the render result
        :type filename: typing.Union[str, typing.Any]
        '''
        pass


class RenderSettings(bpy_struct):
    ''' Rendering settings for a Scene data-block
    '''

    alpha_mode: typing.Union[str, int] = None
    ''' Representation of alpha information in the RGBA pixels * ``SKY`` Sky, Transparent pixels are filled with sky color. * ``TRANSPARENT`` Transparent, World background is transparent with premultiplied alpha.

    :type: typing.Union[str, int]
    '''

    antialiasing_samples: typing.Union[str, int] = None
    ''' Amount of anti-aliasing samples per pixel

    :type: typing.Union[str, int]
    '''

    bake: 'BakeSettings' = None
    ''' 

    :type: 'BakeSettings'
    '''

    bake_aa_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    bake_bias: float = None
    ''' Bias towards faces further away from the object (in blender units)

    :type: float
    '''

    bake_distance: float = None
    ''' Maximum distance from active object to other object (in blender units)

    :type: float
    '''

    bake_margin: int = None
    ''' Extends the baked result as a post process filter

    :type: int
    '''

    bake_normal_space: typing.Union[str, int] = None
    ''' Choose normal space for baking * ``CAMERA`` Camera, Bake the normals in camera space. * ``WORLD`` World, Bake the normals in world space. * ``OBJECT`` Object, Bake the normals in object space. * ``TANGENT`` Tangent, Bake the normals in tangent space.

    :type: typing.Union[str, int]
    '''

    bake_quad_split: typing.Union[str, int] = None
    ''' Choose the method used to split a quad into 2 triangles for baking * ``AUTO`` Automatic, Split quads to give the least distortion while baking. * ``FIXED`` Fixed, Split quads predictably (0,1,2) (0,2,3). * ``FIXED_ALT`` Fixed Alternate, Split quads predictably (1,2,3) (1,3,0).

    :type: typing.Union[str, int]
    '''

    bake_samples: int = None
    ''' Number of samples used for ambient occlusion baking from multires

    :type: int
    '''

    bake_type: typing.Union[str, int] = None
    ''' Choose shading information to bake into the image * ``FULL`` Full Render, Bake everything. * ``AO`` Ambient Occlusion, Bake ambient occlusion. * ``SHADOW`` Shadow, Bake shadows. * ``NORMALS`` Normals, Bake normals. * ``TEXTURE`` Textures, Bake textures. * ``DISPLACEMENT`` Displacement, Bake displacement. * ``DERIVATIVE`` Derivative, Bake derivative map. * ``VERTEX_COLORS`` Vertex Colors, Bake vertex colors. * ``EMIT`` Emission, Bake Emit values (glow). * ``ALPHA`` Alpha, Bake Alpha values (transparency). * ``MIRROR_INTENSITY`` Mirror Intensity, Bake Mirror values. * ``MIRROR_COLOR`` Mirror Colors, Bake Mirror colors. * ``SPEC_INTENSITY`` Specular Intensity, Bake Specular values. * ``SPEC_COLOR`` Specular Colors, Bake Specular colors.

    :type: typing.Union[str, int]
    '''

    bake_user_scale: float = None
    ''' Instead of automatically normalizing to 0..1, apply a user scale to the derivative map

    :type: float
    '''

    border_max_x: float = None
    ''' Maximum X value for the render border

    :type: float
    '''

    border_max_y: float = None
    ''' Maximum Y value for the render border

    :type: float
    '''

    border_min_x: float = None
    ''' Minimum X value for the render border

    :type: float
    '''

    border_min_y: float = None
    ''' Minimum Y value for the render border

    :type: float
    '''

    display_mode: typing.Union[str, int] = None
    ''' Select where rendered images will be displayed * ``SCREEN`` Full Screen, Images are rendered in full Screen. * ``AREA`` Image Editor, Images are rendered in Image Editor. * ``WINDOW`` New Window, Images are rendered in new Window. * ``NONE`` Keep UI, Images are rendered without forcing UI changes.

    :type: typing.Union[str, int]
    '''

    dither_intensity: float = None
    ''' Amount of dithering noise added to the rendered image to break up banding

    :type: float
    '''

    edge_color: bpy_prop_array[float] = None
    ''' Edge color

    :type: bpy_prop_array[float]
    '''

    edge_threshold: int = None
    ''' Threshold for drawing outlines on geometry edges

    :type: int
    '''

    engine: typing.Union[str, int] = None
    ''' Engine to use for rendering * ``BLENDER_RENDER`` Blender Render, Use the Blender internal rendering engine for rendering.

    :type: typing.Union[str, int]
    '''

    ffmpeg: 'FFmpegSettings' = None
    ''' FFmpeg related settings for the scene

    :type: 'FFmpegSettings'
    '''

    field_order: typing.Union[str, int] = None
    ''' Order of video fields (select which lines get rendered first, to create smooth motion for TV output) * ``EVEN_FIRST`` Upper First, Upper field first. * ``ODD_FIRST`` Lower First, Lower field first.

    :type: typing.Union[str, int]
    '''

    file_extension: typing.Union[str, typing.Any] = None
    ''' The file extension used for saving renders

    :type: typing.Union[str, typing.Any]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Directory/name to save animations, # characters defines the position and length of frame numbers

    :type: typing.Union[str, typing.Any]
    '''

    filter_size: float = None
    ''' Width over which the reconstruction filter combines samples

    :type: float
    '''

    fps: int = None
    ''' Framerate, expressed in frames per second

    :type: int
    '''

    fps_base: float = None
    ''' Framerate base

    :type: float
    '''

    frame_map_new: int = None
    ''' How many frames the Map Old will last

    :type: int
    '''

    frame_map_old: int = None
    ''' Old mapping value in frames

    :type: int
    '''

    has_multiple_engines: typing.Union[bool, typing.Any] = None
    ''' More than one rendering engine is available

    :type: typing.Union[bool, typing.Any]
    '''

    image_settings: 'ImageFormatSettings' = None
    ''' 

    :type: 'ImageFormatSettings'
    '''

    is_movie_format: typing.Union[bool, typing.Any] = None
    ''' When true the format is a movie

    :type: typing.Union[bool, typing.Any]
    '''

    layers: 'RenderLayers' = None
    ''' 

    :type: 'RenderLayers'
    '''

    line_thickness: float = None
    ''' Line thickness in pixels

    :type: float
    '''

    line_thickness_mode: typing.Union[str, int] = None
    ''' Line thickness mode for Freestyle line drawing * ``ABSOLUTE`` Absolute, Specify unit line thickness in pixels. * ``RELATIVE`` Relative, Unit line thickness is scaled by the proportion of the present vertical image resolution to 480 pixels.

    :type: typing.Union[str, int]
    '''

    motion_blur_samples: int = None
    ''' Number of scene samples to take with motion blur

    :type: int
    '''

    motion_blur_shutter: float = None
    ''' Time taken in frames between shutter open and close

    :type: float
    '''

    motion_blur_shutter_curve: 'CurveMapping' = None
    ''' Curve defining the shutter's openness over time

    :type: 'CurveMapping'
    '''

    octree_resolution: typing.Union[str, int] = None
    ''' Resolution of raytrace accelerator, use higher resolutions for larger scenes

    :type: typing.Union[str, int]
    '''

    pixel_aspect_x: float = None
    ''' Horizontal aspect ratio - for anamorphic or non-square pixel output

    :type: float
    '''

    pixel_aspect_y: float = None
    ''' Vertical aspect ratio - for anamorphic or non-square pixel output

    :type: float
    '''

    pixel_filter_type: typing.Union[str, int] = None
    ''' Reconstruction filter used for combining anti-aliasing samples * ``BOX`` Box, Use a box filter for anti-aliasing. * ``TENT`` Tent, Use a tent filter for anti-aliasing. * ``QUADRATIC`` Quadratic, Use a quadratic filter for anti-aliasing. * ``CUBIC`` Cubic, Use a cubic filter for anti-aliasing. * ``CATMULLROM`` Catmull-Rom, Use a Catmull-Rom filter for anti-aliasing. * ``GAUSSIAN`` Gaussian, Use a Gaussian filter for anti-aliasing. * ``MITCHELL`` Mitchell-Netravali, Use a Mitchell-Netravali filter for anti-aliasing.

    :type: typing.Union[str, int]
    '''

    preview_start_resolution: int = None
    ''' Resolution to start rendering preview at, progressively increasing it to the full viewport size

    :type: int
    '''

    raytrace_method: typing.Union[str, int] = None
    ''' Type of raytrace accelerator structure * ``AUTO`` Auto, Automatically select acceleration structure. * ``OCTREE`` Octree, Use old Octree structure. * ``VBVH`` vBVH, Use vBVH. * ``SIMD_SVBVH`` SIMD SVBVH, Use SIMD SVBVH. * ``SIMD_QBVH`` SIMD QBVH, Use SIMD QBVH.

    :type: typing.Union[str, int]
    '''

    resolution_percentage: int = None
    ''' Percentage scale for render resolution

    :type: int
    '''

    resolution_x: int = None
    ''' Number of horizontal pixels in the rendered image

    :type: int
    '''

    resolution_y: int = None
    ''' Number of vertical pixels in the rendered image

    :type: int
    '''

    sequencer_gl_preview: typing.Union[str, int] = None
    ''' Method to draw in the sequencer view * ``BOUNDBOX`` Bounding Box, Display the object's local bounding boxes only. * ``WIREFRAME`` Wireframe, Display the object as wire edges. * ``SOLID`` Solid, Display the object solid, lit with default OpenGL lights. * ``TEXTURED`` Texture, Display the object solid, with a texture. * ``MATERIAL`` Material, Display objects solid, with GLSL material. * ``RENDERED`` Rendered, Display render preview.

    :type: typing.Union[str, int]
    '''

    sequencer_gl_render: typing.Union[str, int] = None
    ''' Method to draw in the sequencer view * ``BOUNDBOX`` Bounding Box, Display the object's local bounding boxes only. * ``WIREFRAME`` Wireframe, Display the object as wire edges. * ``SOLID`` Solid, Display the object solid, lit with default OpenGL lights. * ``TEXTURED`` Texture, Display the object solid, with a texture. * ``MATERIAL`` Material, Display objects solid, with GLSL material. * ``RENDERED`` Rendered, Display render preview.

    :type: typing.Union[str, int]
    '''

    simplify_ao_sss: float = None
    ''' Global approximate AO and SSS quality factor

    :type: float
    '''

    simplify_child_particles: float = None
    ''' Global child particles percentage

    :type: float
    '''

    simplify_child_particles_render: float = None
    ''' Global child particles percentage during rendering

    :type: float
    '''

    simplify_shadow_samples: int = None
    ''' Global maximum shadow samples

    :type: int
    '''

    simplify_subdivision: int = None
    ''' Global maximum subdivision level

    :type: int
    '''

    simplify_subdivision_render: int = None
    ''' Global maximum subdivision level during rendering

    :type: int
    '''

    stamp_background: bpy_prop_array[float] = None
    ''' Color to use behind stamp text

    :type: bpy_prop_array[float]
    '''

    stamp_font_size: int = None
    ''' Size of the font used when rendering stamp text

    :type: int
    '''

    stamp_foreground: bpy_prop_array[float] = None
    ''' Color to use for stamp text

    :type: bpy_prop_array[float]
    '''

    stamp_note_text: typing.Union[str, typing.Any] = None
    ''' Custom text to appear in the stamp note

    :type: typing.Union[str, typing.Any]
    '''

    stereo_views: bpy_prop_collection['SceneRenderView'] = None
    ''' 

    :type: bpy_prop_collection['SceneRenderView']
    '''

    threads: int = None
    ''' Number of CPU threads to use simultaneously while rendering (for multi-core/CPU systems)

    :type: int
    '''

    threads_mode: typing.Union[str, int] = None
    ''' Determine the amount of render threads used * ``AUTO`` Auto-detect, Automatically determine the number of threads, based on CPUs. * ``FIXED`` Fixed, Manually determine the number of threads.

    :type: typing.Union[str, int]
    '''

    tile_x: int = None
    ''' Horizontal tile size to use while rendering

    :type: int
    '''

    tile_y: int = None
    ''' Vertical tile size to use while rendering

    :type: int
    '''

    use_antialiasing: bool = None
    ''' Render and combine multiple samples per pixel to prevent jagged edges

    :type: bool
    '''

    use_bake_antialiasing: bool = None
    ''' Enables Anti-aliasing

    :type: bool
    '''

    use_bake_clear: bool = None
    ''' Clear Images before baking

    :type: bool
    '''

    use_bake_lores_mesh: bool = None
    ''' Calculate heights against unsubdivided low resolution mesh

    :type: bool
    '''

    use_bake_multires: bool = None
    ''' Bake directly from multires object

    :type: bool
    '''

    use_bake_normalize: bool = None
    ''' With displacement normalize to the distance, with ambient occlusion normalize without using material settings

    :type: bool
    '''

    use_bake_selected_to_active: bool = None
    ''' Bake shading on the surface of selected objects to the active object

    :type: bool
    '''

    use_bake_to_vertex_color: bool = None
    ''' Bake to vertex colors instead of to a UV-mapped image

    :type: bool
    '''

    use_bake_user_scale: bool = None
    ''' Use a user scale for the derivative map

    :type: bool
    '''

    use_border: bool = None
    ''' Render a user-defined border region, within the frame size (note that this disables save_buffers and full_sample)

    :type: bool
    '''

    use_compositing: bool = None
    ''' Process the render result through the compositing pipeline, if compositing nodes are enabled

    :type: bool
    '''

    use_crop_to_border: bool = None
    ''' Crop the rendered frame to the defined border size

    :type: bool
    '''

    use_edge_enhance: bool = None
    ''' Create a toon outline around the edges of geometry

    :type: bool
    '''

    use_envmaps: bool = None
    ''' Calculate environment maps while rendering

    :type: bool
    '''

    use_fields: bool = None
    ''' Render image to two fields per frame, for interlaced TV output

    :type: bool
    '''

    use_fields_still: bool = None
    ''' Disable the time difference between fields

    :type: bool
    '''

    use_file_extension: bool = None
    ''' Add the file format extensions to the rendered file name (eg: filename + .jpg)

    :type: bool
    '''

    use_free_image_textures: bool = None
    ''' Free all image textures from memory after render, to save memory before compositing

    :type: bool
    '''

    use_freestyle: bool = None
    ''' Draw stylized strokes using Freestyle

    :type: bool
    '''

    use_full_sample: bool = None
    ''' Save for every anti-aliasing sample the entire RenderLayer results (this solves anti-aliasing issues with compositing)

    :type: bool
    '''

    use_game_engine: typing.Union[bool, typing.Any] = None
    ''' Current rendering engine is a game engine

    :type: typing.Union[bool, typing.Any]
    '''

    use_instances: bool = None
    ''' Instance support leads to effective memory reduction when using duplicates

    :type: bool
    '''

    use_local_coords: bool = None
    ''' Vertex coordinates are stored locally on each primitive (increases memory usage, but may have impact on speed)

    :type: bool
    '''

    use_lock_interface: bool = None
    ''' Lock interface during rendering in favor of giving more memory to the renderer

    :type: bool
    '''

    use_motion_blur: bool = None
    ''' Use multi-sampled 3D scene motion blur

    :type: bool
    '''

    use_multiview: bool = None
    ''' Use multiple views in the scene

    :type: bool
    '''

    use_overwrite: bool = None
    ''' Overwrite existing files while rendering

    :type: bool
    '''

    use_persistent_data: bool = None
    ''' Keep render data around for faster re-renders

    :type: bool
    '''

    use_placeholder: bool = None
    ''' Create empty placeholder files while rendering frames (similar to Unix 'touch')

    :type: bool
    '''

    use_raytrace: bool = None
    ''' Pre-calculate the raytrace accelerator and render raytracing effects

    :type: bool
    '''

    use_render_cache: bool = None
    ''' Save render cache to EXR files (useful for heavy compositing, Note: affects indirectly rendered scenes)

    :type: bool
    '''

    use_save_buffers: bool = None
    ''' Save tiles for all RenderLayers and SceneNodes to files in the temp directory (saves memory, required for Full Sample)

    :type: bool
    '''

    use_sequencer: bool = None
    ''' Process the render (and composited) result through the video sequence editor pipeline, if sequencer strips exist

    :type: bool
    '''

    use_sequencer_gl_preview: bool = None
    ''' 

    :type: bool
    '''

    use_sequencer_gl_textured_solid: bool = None
    ''' Draw face-assigned textures in solid draw method

    :type: bool
    '''

    use_shading_nodes: typing.Union[bool, typing.Any] = None
    ''' Active render engine uses new shading nodes system

    :type: typing.Union[bool, typing.Any]
    '''

    use_shadows: bool = None
    ''' Calculate shadows while rendering

    :type: bool
    '''

    use_simplify: bool = None
    ''' Enable simplification of scene for quicker preview renders

    :type: bool
    '''

    use_simplify_triangulate: bool = None
    ''' Disable non-planar quads being triangulated

    :type: bool
    '''

    use_single_layer: bool = None
    ''' Only render the active layer

    :type: bool
    '''

    use_spherical_stereo: typing.Union[bool, typing.Any] = None
    ''' Active render engine supports spherical stereo rendering

    :type: typing.Union[bool, typing.Any]
    '''

    use_sss: bool = None
    ''' Calculate sub-surface scattering in materials rendering

    :type: bool
    '''

    use_stamp: bool = None
    ''' Render the stamp info text in the rendered image

    :type: bool
    '''

    use_stamp_camera: bool = None
    ''' Include the name of the active camera in image metadata

    :type: bool
    '''

    use_stamp_date: bool = None
    ''' Include the current date in image metadata

    :type: bool
    '''

    use_stamp_filename: bool = None
    ''' Include the .blend filename in image metadata

    :type: bool
    '''

    use_stamp_frame: bool = None
    ''' Include the frame number in image metadata

    :type: bool
    '''

    use_stamp_labels: bool = None
    ''' Draw stamp labels ("Camera" in front of camera name, etc.)

    :type: bool
    '''

    use_stamp_lens: bool = None
    ''' Include the active camera's lens in image metadata

    :type: bool
    '''

    use_stamp_marker: bool = None
    ''' Include the name of the last marker in image metadata

    :type: bool
    '''

    use_stamp_memory: bool = None
    ''' Include the peak memory usage in image metadata

    :type: bool
    '''

    use_stamp_note: bool = None
    ''' Include a custom note in image metadata

    :type: bool
    '''

    use_stamp_render_time: bool = None
    ''' Include the render time in image metadata

    :type: bool
    '''

    use_stamp_scene: bool = None
    ''' Include the name of the active scene in image metadata

    :type: bool
    '''

    use_stamp_sequencer_strip: bool = None
    ''' Include the name of the foreground sequence strip in image metadata

    :type: bool
    '''

    use_stamp_strip_meta: bool = None
    ''' Use metadata from the strips in the sequencer

    :type: bool
    '''

    use_stamp_time: bool = None
    ''' Include the rendered frame timecode as HH:MM:SS.FF in image metadata

    :type: bool
    '''

    use_textures: bool = None
    ''' Use textures to affect material properties

    :type: bool
    '''

    use_world_space_shading: bool = None
    ''' Use world space interpretation of lighting data for node materials

    :type: bool
    '''

    views: 'RenderViews' = None
    ''' 

    :type: 'RenderViews'
    '''

    views_format: typing.Union[str, int] = None
    ''' * ``STEREO_3D`` Stereo 3D, Single stereo camera system, adjust the stereo settings in the camera panel. * ``MULTIVIEW`` Multi-View, Multi camera system, adjust the cameras individually.

    :type: typing.Union[str, int]
    '''

    def frame_path(
            self,
            frame: typing.Optional[typing.Any] = -2147483648,
            preview: typing.Optional[typing.Union[bool, typing.Any]] = False,
            view: typing.Union[str, typing.Any] = ""
    ) -> typing.Union[str, typing.Any]:
        ''' Return the absolute path to the filename to be written for a given frame

        :param frame: Frame number to use, if unset the current frame will be used
        :type frame: typing.Optional[typing.Any]
        :param preview: Preview, Use preview range
        :type preview: typing.Optional[typing.Union[bool, typing.Any]]
        :param view: View, The name of the view to use to replace the "%" chars
        :type view: typing.Union[str, typing.Any]
        :rtype: typing.Union[str, typing.Any]
        :return: File Path, The resulting filepath from the scenes render settings
        '''
        pass


class RenderSlot(bpy_struct):
    ''' Parameters defining the render slot
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Render slot name

    :type: typing.Union[str, typing.Any]
    '''


class RenderView(bpy_struct):
    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class RigidBodyConstraint(bpy_struct):
    ''' Constraint influencing Objects inside Rigid Body Simulation
    '''

    breaking_threshold: float = None
    ''' Impulse threshold that must be reached for the constraint to break

    :type: float
    '''

    disable_collisions: bool = None
    ''' Disable collisions between constrained rigid bodies

    :type: bool
    '''

    enabled: bool = None
    ''' Enable this constraint

    :type: bool
    '''

    limit_ang_x_lower: float = None
    ''' Lower limit of X axis rotation

    :type: float
    '''

    limit_ang_x_upper: float = None
    ''' Upper limit of X axis rotation

    :type: float
    '''

    limit_ang_y_lower: float = None
    ''' Lower limit of Y axis rotation

    :type: float
    '''

    limit_ang_y_upper: float = None
    ''' Upper limit of Y axis rotation

    :type: float
    '''

    limit_ang_z_lower: float = None
    ''' Lower limit of Z axis rotation

    :type: float
    '''

    limit_ang_z_upper: float = None
    ''' Upper limit of Z axis rotation

    :type: float
    '''

    limit_lin_x_lower: float = None
    ''' Lower limit of X axis translation

    :type: float
    '''

    limit_lin_x_upper: float = None
    ''' Upper limit of X axis translation

    :type: float
    '''

    limit_lin_y_lower: float = None
    ''' Lower limit of Y axis translation

    :type: float
    '''

    limit_lin_y_upper: float = None
    ''' Upper limit of Y axis translation

    :type: float
    '''

    limit_lin_z_lower: float = None
    ''' Lower limit of Z axis translation

    :type: float
    '''

    limit_lin_z_upper: float = None
    ''' Upper limit of Z axis translation

    :type: float
    '''

    motor_ang_max_impulse: float = None
    ''' Maximum angular motor impulse

    :type: float
    '''

    motor_ang_target_velocity: float = None
    ''' Target angular motor velocity

    :type: float
    '''

    motor_lin_max_impulse: float = None
    ''' Maximum linear motor impulse

    :type: float
    '''

    motor_lin_target_velocity: float = None
    ''' Target linear motor velocity

    :type: float
    '''

    object1: 'Object' = None
    ''' First Rigid Body Object to be constrained

    :type: 'Object'
    '''

    object2: 'Object' = None
    ''' Second Rigid Body Object to be constrained

    :type: 'Object'
    '''

    solver_iterations: int = None
    ''' Number of constraint solver iterations made per simulation step (higher values are more accurate but slower)

    :type: int
    '''

    spring_damping_x: float = None
    ''' Damping on the X axis

    :type: float
    '''

    spring_damping_y: float = None
    ''' Damping on the Y axis

    :type: float
    '''

    spring_damping_z: float = None
    ''' Damping on the Z axis

    :type: float
    '''

    spring_stiffness_x: float = None
    ''' Stiffness on the X axis

    :type: float
    '''

    spring_stiffness_y: float = None
    ''' Stiffness on the Y axis

    :type: float
    '''

    spring_stiffness_z: float = None
    ''' Stiffness on the Z axis

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Type of Rigid Body Constraint * ``FIXED`` Fixed, Glue rigid bodies together. * ``POINT`` Point, Constrain rigid bodies to move around common pivot point. * ``HINGE`` Hinge, Restrict rigid body rotation to one axis. * ``SLIDER`` Slider, Restrict rigid body translation to one axis. * ``PISTON`` Piston, Restrict rigid body translation and rotation to one axis. * ``GENERIC`` Generic, Restrict translation and rotation to specified axes. * ``GENERIC_SPRING`` Generic Spring, Restrict translation and rotation to specified axes with springs. * ``MOTOR`` Motor, Drive rigid body around or along an axis.

    :type: typing.Union[str, int]
    '''

    use_breaking: bool = None
    ''' Constraint can be broken if it receives an impulse above the threshold

    :type: bool
    '''

    use_limit_ang_x: bool = None
    ''' Limit rotation around X axis

    :type: bool
    '''

    use_limit_ang_y: bool = None
    ''' Limit rotation around Y axis

    :type: bool
    '''

    use_limit_ang_z: bool = None
    ''' Limit rotation around Z axis

    :type: bool
    '''

    use_limit_lin_x: bool = None
    ''' Limit translation on X axis

    :type: bool
    '''

    use_limit_lin_y: bool = None
    ''' Limit translation on Y axis

    :type: bool
    '''

    use_limit_lin_z: bool = None
    ''' Limit translation on Z axis

    :type: bool
    '''

    use_motor_ang: bool = None
    ''' Enable angular motor

    :type: bool
    '''

    use_motor_lin: bool = None
    ''' Enable linear motor

    :type: bool
    '''

    use_override_solver_iterations: bool = None
    ''' Override the number of solver iterations for this constraint

    :type: bool
    '''

    use_spring_x: bool = None
    ''' Enable spring on X axis

    :type: bool
    '''

    use_spring_y: bool = None
    ''' Enable spring on Y axis

    :type: bool
    '''

    use_spring_z: bool = None
    ''' Enable spring on Z axis

    :type: bool
    '''


class RigidBodyObject(bpy_struct):
    ''' Settings for object participating in Rigid Body Simulation
    '''

    angular_damping: float = None
    ''' Amount of angular velocity that is lost over time

    :type: float
    '''

    collision_groups: typing.List[bool] = None
    ''' Collision Groups Rigid Body belongs to

    :type: typing.List[bool]
    '''

    collision_margin: float = None
    ''' Threshold of distance near surface where collisions are still considered (best results when non-zero)

    :type: float
    '''

    collision_shape: typing.Union[str, int] = None
    ''' Collision Shape of object in Rigid Body Simulations * ``BOX`` Box, Box-like shapes (i.e. cubes), including planes (i.e. ground planes). * ``SPHERE`` Sphere. * ``CAPSULE`` Capsule. * ``CYLINDER`` Cylinder. * ``CONE`` Cone. * ``CONVEX_HULL`` Convex Hull, A mesh-like surface encompassing (i.e. shrinkwrap over) all vertices (best results with fewer vertices). * ``MESH`` Mesh, Mesh consisting of triangles only, allowing for more detailed interactions than convex hulls.

    :type: typing.Union[str, int]
    '''

    deactivate_angular_velocity: float = None
    ''' Angular Velocity below which simulation stops simulating object

    :type: float
    '''

    deactivate_linear_velocity: float = None
    ''' Linear Velocity below which simulation stops simulating object

    :type: float
    '''

    enabled: bool = None
    ''' Rigid Body actively participates to the simulation

    :type: bool
    '''

    friction: float = None
    ''' Resistance of object to movement

    :type: float
    '''

    kinematic: bool = None
    ''' Allow rigid body to be controlled by the animation system

    :type: bool
    '''

    linear_damping: float = None
    ''' Amount of linear velocity that is lost over time

    :type: float
    '''

    mass: float = None
    ''' How much the object 'weighs' irrespective of gravity

    :type: float
    '''

    mesh_source: typing.Union[str, int] = None
    ''' Source of the mesh used to create collision shape * ``BASE`` Base, Base mesh. * ``DEFORM`` Deform, Deformations (shape keys, deform modifiers). * ``FINAL`` Final, All modifiers.

    :type: typing.Union[str, int]
    '''

    restitution: float = None
    ''' Tendency of object to bounce after colliding with another (0 = stays still, 1 = perfectly elastic)

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' Role of object in Rigid Body Simulations * ``ACTIVE`` Active, Object is directly controlled by simulation results. * ``PASSIVE`` Passive, Object is directly controlled by animation system.

    :type: typing.Union[str, int]
    '''

    use_deactivation: bool = None
    ''' Enable deactivation of resting rigid bodies (increases performance and stability but can cause glitches)

    :type: bool
    '''

    use_deform: bool = None
    ''' Rigid body deforms during simulation

    :type: bool
    '''

    use_margin: bool = None
    ''' Use custom collision margin (some shapes will have a visible gap around them)

    :type: bool
    '''

    use_start_deactivated: bool = None
    ''' Deactivate rigid body at the start of the simulation

    :type: bool
    '''


class RigidBodyWorld(bpy_struct):
    ''' Self-contained rigid body simulation environment and settings
    '''

    constraints: 'Group' = None
    ''' Group containing rigid body constraint objects

    :type: 'Group'
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    enabled: bool = None
    ''' Simulation will be evaluated

    :type: bool
    '''

    group: 'Group' = None
    ''' Group containing objects participating in this simulation

    :type: 'Group'
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    solver_iterations: int = None
    ''' Number of constraint solver iterations made per simulation step (higher values are more accurate but slower)

    :type: int
    '''

    steps_per_second: int = None
    ''' Number of simulation steps taken per second (higher values are more accurate but slower)

    :type: int
    '''

    time_scale: float = None
    ''' Change the speed of the simulation

    :type: float
    '''

    use_split_impulse: bool = None
    ''' Reduce extra velocity that can build up when objects collide (lowers simulation stability a little so use only when necessary)

    :type: bool
    '''

    def convex_sweep_test(self, object: 'Object',
                          start: typing.Optional[typing.Iterable[float]],
                          end: typing.Optional[typing.Iterable[float]]):
        ''' Sweep test convex rigidbody against the current rigidbody world

        :param object: Rigidbody object with a convex collision shape
        :type object: 'Object'
        :param start: 
        :type start: typing.Optional[typing.Iterable[float]]
        :param end: 
        :type end: typing.Optional[typing.Iterable[float]]
        '''
        pass


class SPHFluidSettings(bpy_struct):
    ''' Settings for particle fluids physics
    '''

    buoyancy: float = None
    ''' Artificial buoyancy force in negative gravity direction based on pressure differences inside the fluid

    :type: float
    '''

    factor_radius: bool = None
    ''' Interaction radius is a factor of 4 * particle size

    :type: bool
    '''

    factor_repulsion: bool = None
    ''' Repulsion is a factor of stiffness

    :type: bool
    '''

    factor_rest_length: bool = None
    ''' Spring rest length is a factor of 2 * particle size

    :type: bool
    '''

    factor_stiff_viscosity: bool = None
    ''' Stiff viscosity is a factor of normal viscosity

    :type: bool
    '''

    fluid_radius: float = None
    ''' Fluid interaction radius

    :type: float
    '''

    linear_viscosity: float = None
    ''' Linear viscosity

    :type: float
    '''

    plasticity: float = None
    ''' How much the spring rest length can change after the elastic limit is crossed

    :type: float
    '''

    repulsion: float = None
    ''' How strongly the fluid tries to keep from clustering (factor of stiffness)

    :type: float
    '''

    rest_density: float = None
    ''' Fluid rest density

    :type: float
    '''

    rest_length: float = None
    ''' Spring rest length (factor of particle radius)

    :type: float
    '''

    solver: typing.Union[str, int] = None
    ''' The code used to calculate internal forces on particles * ``DDR`` Double-Density, An artistic solver with strong surface tension effects (original). * ``CLASSICAL`` Classical, A more physically-accurate solver.

    :type: typing.Union[str, int]
    '''

    spring_force: float = None
    ''' Spring force

    :type: float
    '''

    spring_frames: int = None
    ''' Create springs for this number of frames since particles birth (0 is always)

    :type: int
    '''

    stiff_viscosity: float = None
    ''' Creates viscosity for expanding fluid

    :type: float
    '''

    stiffness: float = None
    ''' How incompressible the fluid is (speed of sound)

    :type: float
    '''

    use_factor_density: bool = None
    ''' Density is calculated as a factor of default density (depends on particle size)

    :type: bool
    '''

    use_initial_rest_length: bool = None
    ''' Use the initial length as spring rest length instead of 2 * particle size

    :type: bool
    '''

    use_viscoelastic_springs: bool = None
    ''' Use viscoelastic springs instead of Hooke's springs

    :type: bool
    '''

    yield_ratio: float = None
    ''' How much the spring has to be stretched/compressed in order to change it's rest length

    :type: float
    '''


class SceneGameData(bpy_struct):
    ''' Game data for a Scene data-block
    '''

    activity_culling_box_radius: float = None
    ''' Radius of the activity bubble, in Manhattan length (objects outside the box are activity-culled)

    :type: float
    '''

    deactivation_angular_threshold: float = None
    ''' Angular velocity that an object must be below before the deactivation timer can start

    :type: float
    '''

    deactivation_linear_threshold: float = None
    ''' Linear velocity that an object must be below before the deactivation timer can start

    :type: float
    '''

    deactivation_time: float = None
    ''' Amount of time (in seconds) after which objects with a velocity less than the given threshold will deactivate (0.0 means no deactivation)

    :type: float
    '''

    depth: int = None
    ''' Display bit depth of full screen display

    :type: int
    '''

    dome_angle: int = None
    ''' Field of View of the Dome - it only works in mode Fisheye and Truncated

    :type: int
    '''

    dome_buffer_resolution: float = None
    ''' Buffer Resolution - decrease it to increase speed

    :type: float
    '''

    dome_mode: typing.Union[str, int] = None
    ''' Dome physical configurations

    :type: typing.Union[str, int]
    '''

    dome_tessellation: int = None
    ''' Tessellation level - check the generated mesh in wireframe mode

    :type: int
    '''

    dome_text: 'Text' = None
    ''' Custom Warp Mesh data file

    :type: 'Text'
    '''

    dome_tilt: int = None
    ''' Camera rotation in horizontal axis

    :type: int
    '''

    exit_key: typing.Union[str, int] = None
    ''' The key that exits the Game Engine * ``NONE`` . * ``LEFTMOUSE`` Left Mouse, LMB. * ``MIDDLEMOUSE`` Middle Mouse, MMB. * ``RIGHTMOUSE`` Right Mouse, RMB. * ``BUTTON4MOUSE`` Button4 Mouse, MB4. * ``BUTTON5MOUSE`` Button5 Mouse, MB5. * ``BUTTON6MOUSE`` Button6 Mouse, MB6. * ``BUTTON7MOUSE`` Button7 Mouse, MB7. * ``ACTIONMOUSE`` Action Mouse, MBA. * ``SELECTMOUSE`` Select Mouse, MBS. * ``PEN`` Pen. * ``ERASER`` Eraser. * ``MOUSEMOVE`` Mouse Move, MsMov. * ``INBETWEEN_MOUSEMOVE`` In-between Move, MsSubMov. * ``TRACKPADPAN`` Mouse/Trackpad Pan, MsPan. * ``TRACKPADZOOM`` Mouse/Trackpad Zoom, MsZoom. * ``MOUSEROTATE`` Mouse/Trackpad Rotate, MsRot. * ``WHEELUPMOUSE`` Wheel Up, WhUp. * ``WHEELDOWNMOUSE`` Wheel Down, WhDown. * ``WHEELINMOUSE`` Wheel In, WhIn. * ``WHEELOUTMOUSE`` Wheel Out, WhOut. * ``EVT_TWEAK_L`` Tweak Left, TwkL. * ``EVT_TWEAK_M`` Tweak Middle, TwkM. * ``EVT_TWEAK_R`` Tweak Right, TwkR. * ``EVT_TWEAK_A`` Tweak Action, TwkA. * ``EVT_TWEAK_S`` Tweak Select, TwkS. * ``A`` A. * ``B`` B. * ``C`` C. * ``D`` D. * ``E`` E. * ``F`` F. * ``G`` G. * ``H`` H. * ``I`` I. * ``J`` J. * ``K`` K. * ``L`` L. * ``M`` M. * ``N`` N. * ``O`` O. * ``P`` P. * ``Q`` Q. * ``R`` R. * ``S`` S. * ``T`` T. * ``U`` U. * ``V`` V. * ``W`` W. * ``X`` X. * ``Y`` Y. * ``Z`` Z. * ``ZERO`` 0. * ``ONE`` 1. * ``TWO`` 2. * ``THREE`` 3. * ``FOUR`` 4. * ``FIVE`` 5. * ``SIX`` 6. * ``SEVEN`` 7. * ``EIGHT`` 8. * ``NINE`` 9. * ``LEFT_CTRL`` Left Ctrl, CtrlL. * ``LEFT_ALT`` Left Alt, AltL. * ``LEFT_SHIFT`` Left Shift, ShiftL. * ``RIGHT_ALT`` Right Alt, AltR. * ``RIGHT_CTRL`` Right Ctrl, CtrlR. * ``RIGHT_SHIFT`` Right Shift, ShiftR. * ``OSKEY`` OS Key, Cmd. * ``GRLESS`` Grless. * ``ESC`` Esc. * ``TAB`` Tab. * ``RET`` Return, Enter. * ``SPACE`` Spacebar, Space. * ``LINE_FEED`` Line Feed. * ``BACK_SPACE`` Back Space, BkSpace. * ``DEL`` Delete, Del. * ``SEMI_COLON`` ;. * ``PERIOD`` .. * ``COMMA`` ,. * ``QUOTE`` ". * ``ACCENT_GRAVE`` \`. * ``MINUS`` -. * ``PLUS`` +. * ``SLASH`` /. * ``BACK_SLASH`` \\. * ``EQUAL`` =. * ``LEFT_BRACKET`` [. * ``RIGHT_BRACKET`` ]. * ``LEFT_ARROW`` Left Arrow, ←. * ``DOWN_ARROW`` Down Arrow, ↓. * ``RIGHT_ARROW`` Right Arrow, →. * ``UP_ARROW`` Up Arrow, ↑. * ``NUMPAD_2`` Numpad 2, Pad2. * ``NUMPAD_4`` Numpad 4, Pad4. * ``NUMPAD_6`` Numpad 6, Pad6. * ``NUMPAD_8`` Numpad 8, Pad8. * ``NUMPAD_1`` Numpad 1, Pad1. * ``NUMPAD_3`` Numpad 3, Pad3. * ``NUMPAD_5`` Numpad 5, Pad5. * ``NUMPAD_7`` Numpad 7, Pad7. * ``NUMPAD_9`` Numpad 9, Pad9. * ``NUMPAD_PERIOD`` Numpad ., Pad.. * ``NUMPAD_SLASH`` Numpad /, Pad/. * ``NUMPAD_ASTERIX`` Numpad \*, Pad\*. * ``NUMPAD_0`` Numpad 0, Pad0. * ``NUMPAD_MINUS`` Numpad -, Pad-. * ``NUMPAD_ENTER`` Numpad Enter, PadEnter. * ``NUMPAD_PLUS`` Numpad +, Pad+. * ``F1`` F1. * ``F2`` F2. * ``F3`` F3. * ``F4`` F4. * ``F5`` F5. * ``F6`` F6. * ``F7`` F7. * ``F8`` F8. * ``F9`` F9. * ``F10`` F10. * ``F11`` F11. * ``F12`` F12. * ``F13`` F13. * ``F14`` F14. * ``F15`` F15. * ``F16`` F16. * ``F17`` F17. * ``F18`` F18. * ``F19`` F19. * ``PAUSE`` Pause. * ``INSERT`` Insert, Ins. * ``HOME`` Home. * ``PAGE_UP`` Page Up, PgUp. * ``PAGE_DOWN`` Page Down, PgDown. * ``END`` End. * ``MEDIA_PLAY`` Media Play/Pause, >/\|\|. * ``MEDIA_STOP`` Media Stop, Stop. * ``MEDIA_FIRST`` Media First, \|<<. * ``MEDIA_LAST`` Media Last, >>\|. * ``TEXTINPUT`` Text Input, TxtIn. * ``WINDOW_DEACTIVATE`` Window Deactivate. * ``TIMER`` Timer, Tmr. * ``TIMER0`` Timer 0, Tmr0. * ``TIMER1`` Timer 1, Tmr1. * ``TIMER2`` Timer 2, Tmr2. * ``TIMER_JOBS`` Timer Jobs, TmrJob. * ``TIMER_AUTOSAVE`` Timer Autosave, TmrSave. * ``TIMER_REPORT`` Timer Report, TmrReport. * ``TIMERREGION`` Timer Region, TmrReg. * ``NDOF_MOTION`` NDOF Motion, NdofMov. * ``NDOF_BUTTON_MENU`` NDOF Menu, NdofMenu. * ``NDOF_BUTTON_FIT`` NDOF Fit, NdofFit. * ``NDOF_BUTTON_TOP`` NDOF Top, Ndof↑. * ``NDOF_BUTTON_BOTTOM`` NDOF Bottom, Ndof↓. * ``NDOF_BUTTON_LEFT`` NDOF Left, Ndof←. * ``NDOF_BUTTON_RIGHT`` NDOF Right, Ndof→. * ``NDOF_BUTTON_FRONT`` NDOF Front, NdofFront. * ``NDOF_BUTTON_BACK`` NDOF Back, NdofBack. * ``NDOF_BUTTON_ISO1`` NDOF Isometric 1, NdofIso1. * ``NDOF_BUTTON_ISO2`` NDOF Isometric 2, NdofIso2. * ``NDOF_BUTTON_ROLL_CW`` NDOF Roll CW, NdofRCW. * ``NDOF_BUTTON_ROLL_CCW`` NDOF Roll CCW, NdofRCCW. * ``NDOF_BUTTON_SPIN_CW`` NDOF Spin CW, NdofSCW. * ``NDOF_BUTTON_SPIN_CCW`` NDOF Spin CCW, NdofSCCW. * ``NDOF_BUTTON_TILT_CW`` NDOF Tilt CW, NdofTCW. * ``NDOF_BUTTON_TILT_CCW`` NDOF Tilt CCW, NdofTCCW. * ``NDOF_BUTTON_ROTATE`` NDOF Rotate, NdofRot. * ``NDOF_BUTTON_PANZOOM`` NDOF Pan/Zoom, NdofPanZoom. * ``NDOF_BUTTON_DOMINANT`` NDOF Dominant, NdofDom. * ``NDOF_BUTTON_PLUS`` NDOF Plus, Ndof+. * ``NDOF_BUTTON_MINUS`` NDOF Minus, Ndof-. * ``NDOF_BUTTON_ESC`` NDOF Esc, NdofEsc. * ``NDOF_BUTTON_ALT`` NDOF Alt, NdofAlt. * ``NDOF_BUTTON_SHIFT`` NDOF Shift, NdofShift. * ``NDOF_BUTTON_CTRL`` NDOF Ctrl, NdofCtrl. * ``NDOF_BUTTON_1`` NDOF Button 1, NdofB1. * ``NDOF_BUTTON_2`` NDOF Button 2, NdofB2. * ``NDOF_BUTTON_3`` NDOF Button 3, NdofB3. * ``NDOF_BUTTON_4`` NDOF Button 4, NdofB4. * ``NDOF_BUTTON_5`` NDOF Button 5, NdofB5. * ``NDOF_BUTTON_6`` NDOF Button 6, NdofB6. * ``NDOF_BUTTON_7`` NDOF Button 7, NdofB7. * ``NDOF_BUTTON_8`` NDOF Button 8, NdofB8. * ``NDOF_BUTTON_9`` NDOF Button 9, NdofB9. * ``NDOF_BUTTON_10`` NDOF Button 10, NdofB10. * ``NDOF_BUTTON_A`` NDOF Button A, NdofBA. * ``NDOF_BUTTON_B`` NDOF Button B, NdofBB. * ``NDOF_BUTTON_C`` NDOF Button C, NdofBC.

    :type: typing.Union[str, int]
    '''

    fps: int = None
    ''' Nominal number of game frames per second (physics fixed timestep = 1/fps, independently of actual frame rate)

    :type: int
    '''

    frame_color: bpy_prop_array[float] = None
    ''' Set color of the bars

    :type: bpy_prop_array[float]
    '''

    frame_type: typing.Union[str, int] = None
    ''' Select the type of Framing you want * ``LETTERBOX`` Letterbox, Show the entire viewport in the display window, using bar horizontally or vertically. * ``EXTEND`` Extend, Show the entire viewport in the display window, viewing more horizontally or vertically. * ``SCALE`` Scale, Stretch or squeeze the viewport to fill the display window.

    :type: typing.Union[str, int]
    '''

    frequency: int = None
    ''' Display clock frequency of fullscreen display

    :type: int
    '''

    level_height: float = None
    ''' Max difference in heights of obstacles to enable their interaction

    :type: float
    '''

    logic_step_max: int = None
    ''' Maximum number of logic frame per game frame if graphics slows down the game, higher value allows better synchronization with physics

    :type: int
    '''

    material_mode: typing.Union[str, int] = None
    ''' Material mode to use for rendering * ``MULTITEXTURE`` Multitexture, Multitexture materials. * ``GLSL`` GLSL, OpenGL shading language shaders.

    :type: typing.Union[str, int]
    '''

    obstacle_simulation: typing.Union[str, int] = None
    ''' Simulation used for obstacle avoidance in the game engine

    :type: typing.Union[str, int]
    '''

    occlusion_culling_resolution: int = None
    ''' Size of the occlusion buffer, use higher value for better precision (slower)

    :type: int
    '''

    physics_engine: typing.Union[str, int] = None
    ''' Physics engine used for physics simulation in the game engine * ``NONE`` None, Don't use a physics engine. * ``BULLET`` Bullet, Use the Bullet physics engine.

    :type: typing.Union[str, int]
    '''

    physics_gravity: float = None
    ''' Gravitational constant used for physics simulation in the game engine

    :type: float
    '''

    physics_step_max: int = None
    ''' Maximum number of physics step per game frame if graphics slows down the game, higher value allows physics to keep up with realtime

    :type: int
    '''

    physics_step_sub: int = None
    ''' Number of simulation substep per physic timestep, higher value give better physics precision

    :type: int
    '''

    raster_storage: typing.Union[str, int] = None
    ''' Set the storage mode used by the rasterizer * ``AUTO`` Auto Select, Choose the best supported mode. * ``VERTEX_ARRAY`` Vertex Arrays, Usually the best choice (good performance with display lists). * ``VERTEX_BUFFER_OBJECT`` Vertex Buffer Objects, Typically slower than vertex arrays with display lists, requires at least OpenGL 1.4.

    :type: typing.Union[str, int]
    '''

    recast_data: 'SceneGameRecastData' = None
    ''' 

    :type: 'SceneGameRecastData'
    '''

    resolution_x: int = None
    ''' Number of horizontal pixels in the screen

    :type: int
    '''

    resolution_y: int = None
    ''' Number of vertical pixels in the screen

    :type: int
    '''

    samples: typing.Union[str, int] = None
    ''' The number of AA Samples to use for MSAA

    :type: typing.Union[str, int]
    '''

    scene_hysteresis_percentage: int = None
    ''' Minimum distance change required to transition to the previous level of detail

    :type: int
    '''

    show_debug_properties: bool = None
    ''' Show properties marked for debugging while the game runs

    :type: bool
    '''

    show_framerate_profile: bool = None
    ''' Show framerate and profiling information while the game runs

    :type: bool
    '''

    show_fullscreen: bool = None
    ''' Start player in a new fullscreen display

    :type: bool
    '''

    show_mouse: bool = None
    ''' Start player with a visible mouse cursor

    :type: bool
    '''

    show_obstacle_simulation: bool = None
    ''' Enable debug visualization for obstacle simulation

    :type: bool
    '''

    show_physics_visualization: bool = None
    ''' Show a visualization of physics bounds and interactions

    :type: bool
    '''

    stereo: typing.Union[str, int] = None
    ''' * ``NONE`` None, Disable Stereo and Dome environments. * ``STEREO`` Stereo, Enable Stereo environment. * ``DOME`` Dome, Enable Dome environment.

    :type: typing.Union[str, int]
    '''

    stereo_eye_separation: float = None
    ''' Set the distance between the eyes - the camera focal distance/30 should be fine

    :type: float
    '''

    stereo_mode: typing.Union[str, int] = None
    ''' Stereographic techniques

    :type: typing.Union[str, int]
    '''

    use_activity_culling: bool = None
    ''' Activity culling is enabled

    :type: bool
    '''

    use_animation_record: bool = None
    ''' Record animation to F-Curves

    :type: bool
    '''

    use_auto_start: bool = None
    ''' Automatically start game at load time

    :type: bool
    '''

    use_deprecation_warnings: bool = None
    ''' Print warnings when using deprecated features in the python API

    :type: bool
    '''

    use_desktop: bool = None
    ''' Use the current desktop resolution in fullscreen mode

    :type: bool
    '''

    use_display_lists: bool = None
    ''' Use display lists to speed up rendering by keeping geometry on the GPU

    :type: bool
    '''

    use_frame_rate: bool = None
    ''' Respect the frame rate from the Physics panel in the world properties rather than rendering as many frames as possible

    :type: bool
    '''

    use_glsl_color_management: bool = None
    ''' Use color management for GLSL rendering

    :type: bool
    '''

    use_glsl_environment_lighting: bool = None
    ''' Use environment lighting for GLSL rendering

    :type: bool
    '''

    use_glsl_extra_textures: bool = None
    ''' Use extra textures like normal or specular maps for GLSL rendering

    :type: bool
    '''

    use_glsl_lights: bool = None
    ''' Use lights for GLSL rendering

    :type: bool
    '''

    use_glsl_nodes: bool = None
    ''' Use nodes for GLSL rendering

    :type: bool
    '''

    use_glsl_ramps: bool = None
    ''' Use ramps for GLSL rendering

    :type: bool
    '''

    use_glsl_shaders: bool = None
    ''' Use shaders for GLSL rendering

    :type: bool
    '''

    use_glsl_shadows: bool = None
    ''' Use shadows for GLSL rendering

    :type: bool
    '''

    use_material_caching: bool = None
    ''' Cache materials in the converter (this is faster, but can cause problems with older Singletexture and Multitexture games)

    :type: bool
    '''

    use_occlusion_culling: bool = None
    ''' Use optimized Bullet DBVT tree for view frustum and occlusion culling (more efficient, but it can waste unnecessary CPU if the scene doesn't have occluder objects)

    :type: bool
    '''

    use_restrict_animation_updates: bool = None
    ''' Restrict the number of animation updates to the animation FPS (this is better for performance, but can cause issues with smooth playback)

    :type: bool
    '''

    use_scene_hysteresis: bool = None
    ''' Use LoD Hysteresis setting for the scene

    :type: bool
    '''

    vsync: typing.Union[str, int] = None
    ''' Change vsync settings * ``OFF`` Off, Disable vsync. * ``ON`` On, Enable vsync. * ``ADAPTIVE`` Adaptive, Enable adaptive vsync (if supported).

    :type: typing.Union[str, int]
    '''


class SceneGameRecastData(bpy_struct):
    ''' Recast data for a Game data-block
    '''

    agent_height: float = None
    ''' Minimum height where the agent can still walk

    :type: float
    '''

    agent_radius: float = None
    ''' Radius of the agent

    :type: float
    '''

    cell_height: float = None
    ''' Rasterized cell height

    :type: float
    '''

    cell_size: float = None
    ''' Rasterized cell size

    :type: float
    '''

    climb_max: float = None
    ''' Maximum height between grid cells the agent can climb

    :type: float
    '''

    edge_max_error: float = None
    ''' Maximum distance error from contour to cells

    :type: float
    '''

    edge_max_len: float = None
    ''' Maximum contour edge length

    :type: float
    '''

    partitioning: typing.Union[str, int] = None
    ''' Choose partitioning method * ``WATERSHED`` Watershed, Classic Recast partitioning method generating the nicest tessellation. * ``MONOTONE`` Monotone, Fastest navmesh generation method, may create long thin polygons. * ``LAYERS`` Layers, Reasonably fast method that produces better triangles than monotone partitioning.

    :type: typing.Union[str, int]
    '''

    region_merge_size: float = None
    ''' Minimum regions size (smaller regions will be merged)

    :type: float
    '''

    region_min_size: float = None
    ''' Minimum regions size (smaller regions will be deleted)

    :type: float
    '''

    sample_dist: float = None
    ''' Detail mesh sample spacing

    :type: float
    '''

    sample_max_error: float = None
    ''' Detail mesh simplification max sample error

    :type: float
    '''

    slope_max: float = None
    ''' Maximum walkable slope angle

    :type: float
    '''

    verts_per_poly: int = None
    ''' Max number of vertices per polygon

    :type: int
    '''


class SceneRenderLayer(bpy_struct):
    ''' Render layer
    '''

    exclude_ambient_occlusion: bool = None
    ''' Exclude AO pass from combined

    :type: bool
    '''

    exclude_emit: bool = None
    ''' Exclude emission pass from combined

    :type: bool
    '''

    exclude_environment: bool = None
    ''' Exclude environment pass from combined

    :type: bool
    '''

    exclude_indirect: bool = None
    ''' Exclude indirect pass from combined

    :type: bool
    '''

    exclude_reflection: bool = None
    ''' Exclude raytraced reflection pass from combined

    :type: bool
    '''

    exclude_refraction: bool = None
    ''' Exclude raytraced refraction pass from combined

    :type: bool
    '''

    exclude_shadow: bool = None
    ''' Exclude shadow pass from combined

    :type: bool
    '''

    exclude_specular: bool = None
    ''' Exclude specular pass from combined

    :type: bool
    '''

    freestyle_settings: 'FreestyleSettings' = None
    ''' 

    :type: 'FreestyleSettings'
    '''

    invert_zmask: bool = None
    ''' For Zmask, only render what is behind solid z values instead of in front

    :type: bool
    '''

    layers: typing.List[bool] = None
    ''' Scene layers included in this render layer

    :type: typing.List[bool]
    '''

    layers_exclude: typing.List[bool] = None
    ''' Exclude scene layers from having any influence

    :type: typing.List[bool]
    '''

    layers_zmask: typing.List[bool] = None
    ''' Zmask scene layers for solid faces

    :type: typing.List[bool]
    '''

    light_override: 'Group' = None
    ''' Group to override all other lights in this render layer

    :type: 'Group'
    '''

    material_override: 'Material' = None
    ''' Material to override all other materials in this render layer

    :type: 'Material'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Render layer name

    :type: typing.Union[str, typing.Any]
    '''

    pass_alpha_threshold: float = None
    ''' Z, Index, normal, UV and vector passes are only affected by surfaces with alpha transparency equal to or higher than this threshold

    :type: float
    '''

    samples: int = None
    ''' Override number of render samples for this render layer, 0 will use the scene setting

    :type: int
    '''

    use: bool = None
    ''' Disable or enable the render layer

    :type: bool
    '''

    use_all_z: bool = None
    ''' Fill in Z values for solid faces in invisible layers, for masking

    :type: bool
    '''

    use_ao: bool = None
    ''' Render AO in this Layer

    :type: bool
    '''

    use_edge_enhance: bool = None
    ''' Render Edge-enhance in this Layer (only works for Solid faces)

    :type: bool
    '''

    use_freestyle: bool = None
    ''' Render stylized strokes in this Layer

    :type: bool
    '''

    use_halo: bool = None
    ''' Render Halos in this Layer (on top of Solid)

    :type: bool
    '''

    use_pass_ambient_occlusion: bool = None
    ''' Deliver AO pass

    :type: bool
    '''

    use_pass_color: bool = None
    ''' Deliver shade-less color pass

    :type: bool
    '''

    use_pass_combined: bool = None
    ''' Deliver full combined RGBA buffer

    :type: bool
    '''

    use_pass_diffuse: bool = None
    ''' Deliver diffuse pass

    :type: bool
    '''

    use_pass_diffuse_color: bool = None
    ''' Deliver diffuse color pass

    :type: bool
    '''

    use_pass_diffuse_direct: bool = None
    ''' Deliver diffuse direct pass

    :type: bool
    '''

    use_pass_diffuse_indirect: bool = None
    ''' Deliver diffuse indirect pass

    :type: bool
    '''

    use_pass_emit: bool = None
    ''' Deliver emission pass

    :type: bool
    '''

    use_pass_environment: bool = None
    ''' Deliver environment lighting pass

    :type: bool
    '''

    use_pass_glossy_color: bool = None
    ''' Deliver glossy color pass

    :type: bool
    '''

    use_pass_glossy_direct: bool = None
    ''' Deliver glossy direct pass

    :type: bool
    '''

    use_pass_glossy_indirect: bool = None
    ''' Deliver glossy indirect pass

    :type: bool
    '''

    use_pass_indirect: bool = None
    ''' Deliver indirect lighting pass

    :type: bool
    '''

    use_pass_material_index: bool = None
    ''' Deliver material index pass

    :type: bool
    '''

    use_pass_mist: bool = None
    ''' Deliver mist factor pass (0.0-1.0)

    :type: bool
    '''

    use_pass_normal: bool = None
    ''' Deliver normal pass

    :type: bool
    '''

    use_pass_object_index: bool = None
    ''' Deliver object index pass

    :type: bool
    '''

    use_pass_reflection: bool = None
    ''' Deliver raytraced reflection pass

    :type: bool
    '''

    use_pass_refraction: bool = None
    ''' Deliver raytraced refraction pass

    :type: bool
    '''

    use_pass_shadow: bool = None
    ''' Deliver shadow pass

    :type: bool
    '''

    use_pass_specular: bool = None
    ''' Deliver specular pass

    :type: bool
    '''

    use_pass_subsurface_color: bool = None
    ''' Deliver subsurface color pass

    :type: bool
    '''

    use_pass_subsurface_direct: bool = None
    ''' Deliver subsurface direct pass

    :type: bool
    '''

    use_pass_subsurface_indirect: bool = None
    ''' Deliver subsurface indirect pass

    :type: bool
    '''

    use_pass_transmission_color: bool = None
    ''' Deliver transmission color pass

    :type: bool
    '''

    use_pass_transmission_direct: bool = None
    ''' Deliver transmission direct pass

    :type: bool
    '''

    use_pass_transmission_indirect: bool = None
    ''' Deliver transmission indirect pass

    :type: bool
    '''

    use_pass_uv: bool = None
    ''' Deliver texture UV pass

    :type: bool
    '''

    use_pass_vector: bool = None
    ''' Deliver speed vector pass

    :type: bool
    '''

    use_pass_z: bool = None
    ''' Deliver Z values pass

    :type: bool
    '''

    use_sky: bool = None
    ''' Render Sky in this Layer

    :type: bool
    '''

    use_solid: bool = None
    ''' Render Solid faces in this Layer

    :type: bool
    '''

    use_strand: bool = None
    ''' Render Strands in this Layer

    :type: bool
    '''

    use_zmask: bool = None
    ''' Only render what's in front of the solid z values

    :type: bool
    '''

    use_ztransp: bool = None
    ''' Render Z-Transparent faces in this Layer (on top of Solid and Halos)

    :type: bool
    '''


class SceneRenderView(bpy_struct):
    ''' Render viewpoint for 3D stereo and multiview rendering
    '''

    camera_suffix: typing.Union[str, typing.Any] = None
    ''' Suffix to identify the cameras to use, and added to the render images for this view

    :type: typing.Union[str, typing.Any]
    '''

    file_suffix: typing.Union[str, typing.Any] = None
    ''' Suffix added to the render images for this view

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Render view name

    :type: typing.Union[str, typing.Any]
    '''

    use: bool = None
    ''' Disable or enable the render view

    :type: bool
    '''


class Scopes(bpy_struct):
    ''' Scopes for statistical view of an image
    '''

    accuracy: float = None
    ''' Proportion of original image source pixel lines to sample

    :type: float
    '''

    histogram: 'Histogram' = None
    ''' Histogram for viewing image statistics

    :type: 'Histogram'
    '''

    use_full_resolution: bool = None
    ''' Sample every pixel of the image

    :type: bool
    '''

    vectorscope_alpha: float = None
    ''' Opacity of the points

    :type: float
    '''

    waveform_alpha: float = None
    ''' Opacity of the points

    :type: float
    '''

    waveform_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''


class SculptToolCapabilities(bpy_struct):
    ''' Read-only indications of which brush operations are supported by the current sculpt tool
    '''

    has_accumulate: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_auto_smooth: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_gravity: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_height: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_jitter: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_normal_weight: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_persistence: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_pinch_factor: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_plane_offset: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_rake_factor: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_random_texture_angle: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_sculpt_plane: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_secondary_color: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_smooth_stroke: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_space_attenuation: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    has_strength_pressure: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''


class Sensor(bpy_struct):
    ''' Game engine logic brick to detect events
    '''

    active: bool = None
    ''' Set active state of the sensor

    :type: bool
    '''

    controllers: bpy_prop_collection['Controller'] = None
    ''' The list containing the controllers connected to the sensor

    :type: bpy_prop_collection['Controller']
    '''

    invert: bool = None
    ''' Invert the level(output) of this sensor

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Sensor name

    :type: typing.Union[str, typing.Any]
    '''

    pin: bool = None
    ''' Display when not linked to a visible states controller

    :type: bool
    '''

    show_expanded: bool = None
    ''' Set sensor expanded in the user interface

    :type: bool
    '''

    tick_skip: int = None
    ''' Number of logic ticks skipped between 2 active pulses (0 = pulse every logic tick, 1 = skip 1 logic tick between pulses, etc.)

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_level: bool = None
    ''' Level detector, trigger controllers of new states (only applicable upon logic state transition)

    :type: bool
    '''

    use_pulse_false_level: bool = None
    ''' Activate FALSE level triggering (pulse mode)

    :type: bool
    '''

    use_pulse_true_level: bool = None
    ''' Activate TRUE level triggering (pulse mode)

    :type: bool
    '''

    use_tap: bool = None
    ''' Trigger controllers only for an instant, even while the sensor remains true

    :type: bool
    '''

    def link(self, controller: typing.Optional['Controller']):
        ''' Link the sensor to a controller

        :param controller: Controller to link to
        :type controller: typing.Optional['Controller']
        '''
        pass

    def unlink(self, controller: typing.Optional['Controller']):
        ''' Unlink the sensor from a controller

        :param controller: Controller to unlink from
        :type controller: typing.Optional['Controller']
        '''
        pass


class Sequence(bpy_struct):
    ''' Sequence strip in the sequence editor
    '''

    blend_alpha: float = None
    ''' 

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    channel: int = None
    ''' Y position of the sequence strip

    :type: int
    '''

    effect_fader: float = None
    ''' 

    :type: float
    '''

    frame_duration: int = None
    ''' The length of the contents of this strip before the handles are applied

    :type: int
    '''

    frame_final_duration: int = None
    ''' The length of the contents of this strip after the handles are applied

    :type: int
    '''

    frame_final_end: int = None
    ''' End frame displayed in the sequence editor after offsets are applied

    :type: int
    '''

    frame_final_start: int = None
    ''' Start frame displayed in the sequence editor after offsets are applied, setting this is equivalent to moving the handle, not the actual start frame

    :type: int
    '''

    frame_offset_end: int = None
    ''' 

    :type: int
    '''

    frame_offset_start: int = None
    ''' 

    :type: int
    '''

    frame_start: int = None
    ''' 

    :type: int
    '''

    frame_still_end: int = None
    ''' 

    :type: int
    '''

    frame_still_start: int = None
    ''' 

    :type: int
    '''

    lock: bool = None
    ''' Lock strip so that it can't be transformed

    :type: bool
    '''

    modifiers: 'SequenceModifiers' = None
    ''' Modifiers affecting this strip

    :type: 'SequenceModifiers'
    '''

    mute: bool = None
    ''' 

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' 

    :type: bool
    '''

    select_left_handle: bool = None
    ''' 

    :type: bool
    '''

    select_right_handle: bool = None
    ''' 

    :type: bool
    '''

    speed_factor: float = None
    ''' Multiply the current speed of the sequence with this number or remap current frame to this frame

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_default_fade: bool = None
    ''' Fade effect using the built-in default (usually make transition as long as effect strip)

    :type: bool
    '''

    use_linear_modifiers: bool = None
    ''' Calculate modifiers in linear space instead of sequencer's space

    :type: bool
    '''

    def update(self,
               data: typing.Optional[typing.Union[bool, typing.Any]] = False):
        ''' Update the strip dimensions

        :param data: Data, Update strip data
        :type data: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def strip_elem_from_frame(
            self, frame: typing.Optional[int]) -> 'SequenceElement':
        ''' Return the strip element from a given frame or None

        :param frame: Frame, The frame to get the strip element from
        :type frame: typing.Optional[int]
        :rtype: 'SequenceElement'
        :return: strip element of the current frame
        '''
        pass

    def swap(self, other: 'Sequence'):
        ''' swap

        :param other: Other
        :type other: 'Sequence'
        '''
        pass


class SequenceColorBalanceData(bpy_struct):
    ''' Color balance parameters for a sequence strip and it's modifiers
    '''

    gain: bpy_prop_array[float] = None
    ''' Color balance gain (highlights)

    :type: bpy_prop_array[float]
    '''

    gamma: bpy_prop_array[float] = None
    ''' Color balance gamma (midtones)

    :type: bpy_prop_array[float]
    '''

    invert_gain: bool = None
    ''' 

    :type: bool
    '''

    invert_gamma: bool = None
    ''' 

    :type: bool
    '''

    invert_lift: bool = None
    ''' 

    :type: bool
    '''

    lift: bpy_prop_array[float] = None
    ''' Color balance lift (shadows)

    :type: bpy_prop_array[float]
    '''


class SequenceCrop(bpy_struct):
    ''' Cropping parameters for a sequence strip
    '''

    max_x: int = None
    ''' 

    :type: int
    '''

    max_y: int = None
    ''' 

    :type: int
    '''

    min_x: int = None
    ''' 

    :type: int
    '''

    min_y: int = None
    ''' 

    :type: int
    '''


class SequenceEditor(bpy_struct):
    ''' Sequence editing data for a Scene data-block
    '''

    active_strip: 'Sequence' = None
    ''' Sequencer's active strip

    :type: 'Sequence'
    '''

    meta_stack: bpy_prop_collection['Sequence'] = None
    ''' Meta strip stack, last is currently edited meta strip

    :type: bpy_prop_collection['Sequence']
    '''

    overlay_frame: int = None
    ''' 

    :type: int
    '''

    proxy_dir: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    proxy_storage: typing.Union[str, int] = None
    ''' How to store proxies for this project * ``PER_STRIP`` Per Strip, Store proxies using per strip settings. * ``PROJECT`` Project, Store proxies using project directory.

    :type: typing.Union[str, int]
    '''

    sequences: 'Sequences' = None
    ''' Top-level strips only

    :type: 'Sequences'
    '''

    sequences_all: bpy_prop_collection['Sequence'] = None
    ''' All strips, recursively including those inside metastrips

    :type: bpy_prop_collection['Sequence']
    '''

    show_overlay: bool = None
    ''' Partial overlay on top of the sequencer

    :type: bool
    '''

    use_overlay_lock: bool = None
    ''' 

    :type: bool
    '''


class SequenceElement(bpy_struct):
    ''' Sequence strip data for a single frame
    '''

    filename: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    orig_height: int = None
    ''' Original image height

    :type: int
    '''

    orig_width: int = None
    ''' Original image width

    :type: int
    '''


class SequenceModifier(bpy_struct):
    ''' Modifier for sequence strip
    '''

    input_mask_id: 'Mask' = None
    ''' Mask ID used as mask input for the modifier

    :type: 'Mask'
    '''

    input_mask_strip: 'Sequence' = None
    ''' Strip used as mask input for the modifier

    :type: 'Sequence'
    '''

    input_mask_type: typing.Union[str, int] = None
    ''' Type of input data used for mask * ``STRIP`` Strip, Use sequencer strip as mask input. * ``ID`` Mask, Use mask ID as mask input.

    :type: typing.Union[str, int]
    '''

    mask_time: typing.Union[str, int] = None
    ''' Time to use for the Mask animation * ``RELATIVE`` Relative, Mask animation is offset to start of strip. * ``ABSOLUTE`` Absolute, Mask animation is in sync with scene frame.

    :type: typing.Union[str, int]
    '''

    mute: bool = None
    ''' Mute this modifier

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    show_expanded: bool = None
    ''' Mute expanded settings for the modifier

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''


class SequenceProxy(bpy_struct):
    ''' Proxy parameters for a sequence strip
    '''

    build_100: bool = None
    ''' Build 100% proxy resolution

    :type: bool
    '''

    build_25: bool = None
    ''' Build 25% proxy resolution

    :type: bool
    '''

    build_50: bool = None
    ''' Build 50% proxy resolution

    :type: bool
    '''

    build_75: bool = None
    ''' Build 75% proxy resolution

    :type: bool
    '''

    build_free_run: bool = None
    ''' Build free run time code index

    :type: bool
    '''

    build_free_run_rec_date: bool = None
    ''' Build free run time code index using Record Date/Time

    :type: bool
    '''

    build_record_run: bool = None
    ''' Build record run time code index

    :type: bool
    '''

    directory: typing.Union[str, typing.Any] = None
    ''' Location to store the proxy files

    :type: typing.Union[str, typing.Any]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Location of custom proxy file

    :type: typing.Union[str, typing.Any]
    '''

    quality: int = None
    ''' JPEG Quality of proxies to build

    :type: int
    '''

    timecode: typing.Union[str, int] = None
    ''' * ``NONE`` No TC in use. * ``RECORD_RUN`` Record Run, Use images in the order as they are recorded. * ``FREE_RUN`` Free Run, Use global timestamp written by recording device. * ``FREE_RUN_REC_DATE`` Free Run (rec date), Interpolate a global timestamp using the record date and time written by recording device. * ``RECORD_RUN_NO_GAPS`` Record Run No Gaps, Like record run, but ignore timecode, changes in framerate or dropouts.

    :type: typing.Union[str, int]
    '''

    use_overwrite: bool = None
    ''' Overwrite existing proxy files when building

    :type: bool
    '''

    use_proxy_custom_directory: bool = None
    ''' Use a custom directory to store data

    :type: bool
    '''

    use_proxy_custom_file: bool = None
    ''' Use a custom file to read proxy data from

    :type: bool
    '''


class SequenceTransform(bpy_struct):
    ''' Transform parameters for a sequence strip
    '''

    offset_x: int = None
    ''' 

    :type: int
    '''

    offset_y: int = None
    ''' 

    :type: int
    '''


class ShapeKey(bpy_struct):
    ''' Shape key in a shape keys data-block
    '''

    data: bpy_prop_collection['UnknownType'] = None
    ''' 

    :type: bpy_prop_collection['UnknownType']
    '''

    frame: float = None
    ''' Frame for absolute keys

    :type: float
    '''

    interpolation: typing.Union[str, int] = None
    ''' Interpolation type for absolute shape keys

    :type: typing.Union[str, int]
    '''

    mute: bool = None
    ''' Mute this shape key

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of Shape Key

    :type: typing.Union[str, typing.Any]
    '''

    relative_key: 'ShapeKey' = None
    ''' Shape used as a relative key

    :type: 'ShapeKey'
    '''

    slider_max: float = None
    ''' Maximum for slider

    :type: float
    '''

    slider_min: float = None
    ''' Minimum for slider

    :type: float
    '''

    value: float = None
    ''' Value of shape key at the current frame

    :type: float
    '''

    vertex_group: typing.Union[str, typing.Any] = None
    ''' Vertex weight group, to blend with basis shape

    :type: typing.Union[str, typing.Any]
    '''

    def normals_vertex_get(self) -> float:
        ''' Compute local space vertices' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass

    def normals_polygon_get(self) -> float:
        ''' Compute local space faces' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass

    def normals_split_get(self) -> float:
        ''' Compute local space face corners' normals for this shape key

        :rtype: float
        :return: normals
        '''
        pass


class ShapeKeyBezierPoint(bpy_struct):
    ''' Point in a shape key for Bezier curves
    '''

    co: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_left: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_right: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ShapeKeyCurvePoint(bpy_struct):
    ''' Point in a shape key for curves
    '''

    co: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tilt: float = None
    ''' 

    :type: float
    '''


class ShapeKeyPoint(bpy_struct):
    ''' Point in a shape key
    '''

    co: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class SmokeCollSettings(bpy_struct):
    ''' Smoke collision settings
    '''

    collision_type: typing.Union[str, int] = None
    ''' Collision type * ``COLLSTATIC`` Static, Non moving obstacle. * ``COLLRIGID`` Rigid, Rigid obstacle. * ``COLLANIMATED`` Animated, Animated obstacle.

    :type: typing.Union[str, int]
    '''


class SmokeDomainSettings(bpy_struct):
    ''' Smoke domain settings
    '''

    adapt_margin: int = None
    ''' Margin added around fluid to minimize boundary interference

    :type: int
    '''

    adapt_threshold: float = None
    ''' Maximum amount of fluid cell can contain before it is considered empty

    :type: float
    '''

    additional_res: int = None
    ''' Maximum number of additional cells

    :type: int
    '''

    alpha: float = None
    ''' How much density affects smoke motion (higher value results in faster rising smoke)

    :type: float
    '''

    amplify: int = None
    ''' Enhance the resolution of smoke by this factor using noise

    :type: int
    '''

    beta: float = None
    ''' How much heat affects smoke motion (higher value results in faster rising smoke)

    :type: float
    '''

    burning_rate: float = None
    ''' Speed of the burning reaction (use larger values for smaller flame)

    :type: float
    '''

    cache_file_format: typing.Union[str, int] = None
    ''' Select the file format to be used for caching * ``POINTCACHE`` Point Cache, Blender specific point cache file format. * ``OPENVDB`` OpenVDB, OpenVDB file format.

    :type: typing.Union[str, int]
    '''

    cell_size: bpy_prop_array[float] = None
    ''' Cell Size

    :type: bpy_prop_array[float]
    '''

    collision_extents: typing.Union[str, int] = None
    ''' Select which domain border will be treated as collision object * ``BORDEROPEN`` Open, Smoke doesn't collide with any border. * ``BORDERVERTICAL`` Vertically Open, Smoke doesn't collide with top and bottom sides. * ``BORDERCLOSED`` Collide All, Smoke collides with every side.

    :type: typing.Union[str, int]
    '''

    collision_group: 'Group' = None
    ''' Limit collisions to this group

    :type: 'Group'
    '''

    color_grid: bpy_prop_array[float] = None
    ''' Smoke color grid

    :type: bpy_prop_array[float]
    '''

    data_depth: typing.Union[str, int] = None
    ''' Bit depth for writing all scalar (including vector) lower values reduce file size * ``16`` Float (Half), Half float (16 bit data). * ``32`` Float (Full), Full float (32 bit data).

    :type: typing.Union[str, int]
    '''

    density_grid: bpy_prop_array[float] = None
    ''' Smoke density grid

    :type: bpy_prop_array[float]
    '''

    dissolve_speed: int = None
    ''' Dissolve Speed

    :type: int
    '''

    domain_resolution: bpy_prop_array[int] = None
    ''' Smoke Grid Resolution

    :type: bpy_prop_array[int]
    '''

    effector_group: 'Group' = None
    ''' Limit effectors to this group

    :type: 'Group'
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    flame_grid: bpy_prop_array[float] = None
    ''' Smoke flame grid

    :type: bpy_prop_array[float]
    '''

    flame_ignition: float = None
    ''' Minimum temperature of flames

    :type: float
    '''

    flame_max_temp: float = None
    ''' Maximum temperature of flames

    :type: float
    '''

    flame_smoke: float = None
    ''' Amount of smoke created by burning fuel

    :type: float
    '''

    flame_smoke_color: bpy_prop_array[float] = None
    ''' Color of smoke emitted from burning fuel

    :type: bpy_prop_array[float]
    '''

    flame_vorticity: float = None
    ''' Additional vorticity for the flames

    :type: float
    '''

    fluid_group: 'Group' = None
    ''' Limit fluid objects to this group

    :type: 'Group'
    '''

    heat_grid: bpy_prop_array[float] = None
    ''' Smoke heat grid

    :type: bpy_prop_array[float]
    '''

    highres_sampling: typing.Union[str, int] = None
    ''' Method for sampling the high resolution flow

    :type: typing.Union[str, int]
    '''

    noise_type: typing.Union[str, int] = None
    ''' Noise method which is used for creating the high resolution

    :type: typing.Union[str, int]
    '''

    openvdb_cache_compress_type: typing.Union[str, int] = None
    ''' Compression method to be used * ``ZIP`` Zip, Effective but slow compression. * ``BLOSC`` Blosc, Multithreaded compression, similar in size and quality as 'Zip'. * ``NONE`` None, Do not use any compression.

    :type: typing.Union[str, int]
    '''

    point_cache: 'PointCache' = None
    ''' 

    :type: 'PointCache'
    '''

    point_cache_compress_type: typing.Union[str, int] = None
    ''' Compression method to be used * ``CACHELIGHT`` Light, Fast but not so effective compression. * ``CACHEHEAVY`` Heavy, Effective but slow compression.

    :type: typing.Union[str, int]
    '''

    resolution_max: int = None
    ''' Maximal resolution used in the fluid domain

    :type: int
    '''

    show_high_resolution: bool = None
    ''' Show high resolution (using amplification)

    :type: bool
    '''

    start_point: bpy_prop_array[float] = None
    ''' Start point

    :type: bpy_prop_array[float]
    '''

    strength: float = None
    ''' Strength of noise

    :type: float
    '''

    time_scale: float = None
    ''' Adjust simulation speed

    :type: float
    '''

    use_adaptive_domain: bool = None
    ''' Adapt simulation resolution and size to fluid

    :type: bool
    '''

    use_dissolve_smoke: bool = None
    ''' Enable smoke to disappear over time

    :type: bool
    '''

    use_dissolve_smoke_log: bool = None
    ''' Using 1/x

    :type: bool
    '''

    use_high_resolution: bool = None
    ''' Enable high resolution (using amplification)

    :type: bool
    '''

    velocity_grid: bpy_prop_array[float] = None
    ''' Smoke velocity grid

    :type: bpy_prop_array[float]
    '''

    vorticity: float = None
    ''' Amount of turbulence/rotation in fluid

    :type: float
    '''


class SmokeFlowSettings(bpy_struct):
    ''' Smoke flow settings
    '''

    density: float = None
    ''' 

    :type: float
    '''

    density_vertex_group: typing.Union[str, typing.Any] = None
    ''' Name of vertex group which determines surface emission rate

    :type: typing.Union[str, typing.Any]
    '''

    fuel_amount: float = None
    ''' 

    :type: float
    '''

    noise_texture: 'Texture' = None
    ''' Texture that controls emission strength

    :type: 'Texture'
    '''

    particle_size: float = None
    ''' Particle size in simulation cells

    :type: float
    '''

    particle_system: 'ParticleSystem' = None
    ''' Particle systems emitted from the object

    :type: 'ParticleSystem'
    '''

    smoke_color: bpy_prop_array[float] = None
    ''' Color of smoke

    :type: bpy_prop_array[float]
    '''

    smoke_flow_source: typing.Union[str, int] = None
    ''' Change how smoke is emitted * ``PARTICLES`` Particle System, Emit smoke from particles. * ``MESH`` Mesh, Emit smoke from mesh surface or volume.

    :type: typing.Union[str, int]
    '''

    smoke_flow_type: typing.Union[str, int] = None
    ''' Change how flow affects the simulation * ``OUTFLOW`` Outflow, Delete smoke from simulation. * ``SMOKE`` Smoke, Add smoke. * ``BOTH`` Fire + Smoke, Add fire and smoke. * ``FIRE`` Fire, Add fire.

    :type: typing.Union[str, int]
    '''

    subframes: int = None
    ''' Number of additional samples to take between frames to improve quality of fast moving flows

    :type: int
    '''

    surface_distance: float = None
    ''' Maximum distance from mesh surface to emit smoke

    :type: float
    '''

    temperature: float = None
    ''' Temperature difference to ambient temperature

    :type: float
    '''

    texture_map_type: typing.Union[str, int] = None
    ''' Texture mapping type * ``AUTO`` Generated, Generated coordinates centered to flow object. * ``UV`` UV, Use UV layer for texture coordinates.

    :type: typing.Union[str, int]
    '''

    texture_offset: float = None
    ''' Z-offset of texture mapping

    :type: float
    '''

    texture_size: float = None
    ''' Size of texture mapping

    :type: float
    '''

    use_absolute: bool = None
    ''' Only allow given density value in emitter area

    :type: bool
    '''

    use_initial_velocity: bool = None
    ''' Smoke has some initial velocity when it is emitted

    :type: bool
    '''

    use_particle_size: bool = None
    ''' Set particle size in simulation cells or use nearest cell

    :type: bool
    '''

    use_texture: bool = None
    ''' Use a texture to control emission strength

    :type: bool
    '''

    uv_layer: typing.Union[str, typing.Any] = None
    ''' UV map name

    :type: typing.Union[str, typing.Any]
    '''

    velocity_factor: float = None
    ''' Multiplier of source velocity passed to smoke

    :type: float
    '''

    velocity_normal: float = None
    ''' Amount of normal directional velocity

    :type: float
    '''

    velocity_random: float = None
    ''' Amount of random velocity

    :type: float
    '''

    volume_density: float = None
    ''' Factor for smoke emitted from inside the mesh volume

    :type: float
    '''


class SoftBodySettings(bpy_struct):
    ''' Soft body simulation settings for an object
    '''

    aero: int = None
    ''' Make edges 'sail'

    :type: int
    '''

    aerodynamics_type: typing.Union[str, int] = None
    ''' Method of calculating aerodynamic interaction * ``SIMPLE`` Simple, Edges receive a drag force from surrounding media. * ``LIFT_FORCE`` Lift Force, Edges receive a lift force when passing through surrounding media.

    :type: typing.Union[str, int]
    '''

    ball_damp: float = None
    ''' Blending to inelastic collision

    :type: float
    '''

    ball_size: float = None
    ''' Absolute ball size or factor if not manually adjusted

    :type: float
    '''

    ball_stiff: float = None
    ''' Ball inflating pressure

    :type: float
    '''

    bend: float = None
    ''' Bending Stiffness

    :type: float
    '''

    choke: int = None
    ''' 'Viscosity' inside collision target

    :type: int
    '''

    collision_group: 'Group' = None
    ''' Limit colliders to this Group

    :type: 'Group'
    '''

    collision_type: typing.Union[str, int] = None
    ''' Choose Collision Type * ``MANUAL`` Manual, Manual adjust. * ``AVERAGE`` Average, Average Spring length \* Ball Size. * ``MINIMAL`` Minimal, Minimal Spring length \* Ball Size. * ``MAXIMAL`` Maximal, Maximal Spring length \* Ball Size. * ``MINMAX`` AvMinMax, (Min+Max)/2 \* Ball Size.

    :type: typing.Union[str, int]
    '''

    damping: float = None
    ''' Edge spring friction

    :type: float
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    error_threshold: float = None
    ''' The Runge-Kutta ODE solver error limit, low value gives more precision, high values speed

    :type: float
    '''

    friction: float = None
    ''' General media friction for point movements

    :type: float
    '''

    fuzzy: int = None
    ''' Fuzziness while on collision, high values make collision handling faster but less stable

    :type: int
    '''

    goal_default: float = None
    ''' Default Goal (vertex target position) value

    :type: float
    '''

    goal_friction: float = None
    ''' Goal (vertex target position) friction

    :type: float
    '''

    goal_max: float = None
    ''' Goal maximum, vertex weights are scaled to match this range

    :type: float
    '''

    goal_min: float = None
    ''' Goal minimum, vertex weights are scaled to match this range

    :type: float
    '''

    goal_spring: float = None
    ''' Goal (vertex target position) spring stiffness

    :type: float
    '''

    gravity: float = None
    ''' Apply gravitation to point movement

    :type: float
    '''

    location_mass_center: bpy_prop_array[float] = None
    ''' Location of Center of mass

    :type: bpy_prop_array[float]
    '''

    mass: float = None
    ''' General Mass value

    :type: float
    '''

    plastic: int = None
    ''' Permanent deform

    :type: int
    '''

    pull: float = None
    ''' Edge spring stiffness when longer than rest length

    :type: float
    '''

    push: float = None
    ''' Edge spring stiffness when shorter than rest length

    :type: float
    '''

    rotation_estimate: bpy_prop_array[float] = None
    ''' Estimated rotation matrix

    :type: bpy_prop_array[float]
    '''

    scale_estimate: bpy_prop_array[float] = None
    ''' Estimated scale matrix

    :type: bpy_prop_array[float]
    '''

    shear: float = None
    ''' Shear Stiffness

    :type: float
    '''

    speed: float = None
    ''' Tweak timing for physics to control frequency and speed

    :type: float
    '''

    spring_length: int = None
    ''' Alter spring length to shrink/blow up (unit %) 0 to disable

    :type: int
    '''

    step_max: int = None
    ''' Maximal # solver steps/frame

    :type: int
    '''

    step_min: int = None
    ''' Minimal # solver steps/frame

    :type: int
    '''

    use_auto_step: bool = None
    ''' Use velocities for automagic step sizes

    :type: bool
    '''

    use_diagnose: bool = None
    ''' Turn on SB diagnose console prints

    :type: bool
    '''

    use_edge_collision: bool = None
    ''' Edges collide too

    :type: bool
    '''

    use_edges: bool = None
    ''' Use Edges as springs

    :type: bool
    '''

    use_estimate_matrix: bool = None
    ''' Estimate matrix... split to COM, ROT, SCALE

    :type: bool
    '''

    use_face_collision: bool = None
    ''' Faces collide too, can be very slow

    :type: bool
    '''

    use_goal: bool = None
    ''' Define forces for vertices to stick to animated position

    :type: bool
    '''

    use_self_collision: bool = None
    ''' Enable naive vertex ball self collision

    :type: bool
    '''

    use_stiff_quads: bool = None
    ''' Add diagonal springs on 4-gons

    :type: bool
    '''

    vertex_group_goal: typing.Union[str, typing.Any] = None
    ''' Control point weight values

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_mass: typing.Union[str, typing.Any] = None
    ''' Control point mass values

    :type: typing.Union[str, typing.Any]
    '''

    vertex_group_spring: typing.Union[str, typing.Any] = None
    ''' Control point spring strength values

    :type: typing.Union[str, typing.Any]
    '''


class Space(bpy_struct):
    ''' Space data for a screen area
    '''

    show_locked_time: bool = None
    ''' 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    ''' Space data type * ``EMPTY`` Empty. * ``VIEW_3D`` 3D View, 3D viewport. * ``TIMELINE`` Timeline, Timeline and playback controls. * ``GRAPH_EDITOR`` Graph Editor, Edit drivers and keyframe interpolation. * ``DOPESHEET_EDITOR`` Dope Sheet, Adjust timing of keyframes. * ``NLA_EDITOR`` NLA Editor, Combine and layer Actions. * ``IMAGE_EDITOR`` UV/Image Editor, View and edit images and UV Maps. * ``SEQUENCE_EDITOR`` Video Sequence Editor, Video editing tools. * ``CLIP_EDITOR`` Movie Clip Editor, Motion tracking tools. * ``TEXT_EDITOR`` Text Editor, Edit scripts and in-file documentation. * ``NODE_EDITOR`` Node Editor, Editor for node-based shading and compositing tools. * ``LOGIC_EDITOR`` Logic Editor, Game logic editing. * ``PROPERTIES`` Properties, Edit properties of active object and related data-blocks. * ``OUTLINER`` Outliner, Overview of scene graph and all available data-blocks. * ``USER_PREFERENCES`` User Preferences, Edit persistent configuration settings. * ``INFO`` Info, Main menu bar and list of error messages (drag down to expand and display). * ``FILE_BROWSER`` File Browser, Browse for files and assets. * ``CONSOLE`` Python Console, Interactive programmatic console for advanced editing and script development.

    :type: typing.Union[str, int]
    '''

    @staticmethod
    def draw_handler_add():
        ''' Undocumented

        '''
        pass

    @staticmethod
    def draw_handler_remove():
        ''' Undocumented

        '''
        pass


class SpaceUVEditor(bpy_struct):
    ''' UV editor data for the image editor space
    '''

    draw_stretch_type: typing.Union[str, int] = None
    ''' Type of stretch to draw * ``ANGLE`` Angle, Angular distortion between UV and 3D angles. * ``AREA`` Area, Area distortion between UV and 3D faces.

    :type: typing.Union[str, int]
    '''

    edge_draw_type: typing.Union[str, int] = None
    ''' Draw type for drawing UV edges * ``OUTLINE`` Outline, Draw white edges with black outline. * ``DASH`` Dash, Draw dashed black-white edges. * ``BLACK`` Black, Draw black edges. * ``WHITE`` White, Draw white edges.

    :type: typing.Union[str, int]
    '''

    lock_bounds: bool = None
    ''' Constraint to stay within the image bounds while editing

    :type: bool
    '''

    show_faces: bool = None
    ''' Draw faces over the image

    :type: bool
    '''

    show_metadata: bool = None
    ''' Draw metadata properties of the image

    :type: bool
    '''

    show_modified_edges: bool = None
    ''' Draw edges after modifiers are applied

    :type: bool
    '''

    show_normalized_coords: bool = None
    ''' Display UV coordinates from 0.0 to 1.0 rather than in pixels

    :type: bool
    '''

    show_other_objects: bool = None
    ''' Draw other selected objects that share the same image

    :type: bool
    '''

    show_smooth_edges: bool = None
    ''' Draw UV edges anti-aliased

    :type: bool
    '''

    show_stretch: bool = None
    ''' Draw faces colored according to the difference in shape between UVs and their 3D coordinates (blue for low distortion, red for high distortion)

    :type: bool
    '''

    show_texpaint: bool = None
    ''' Draw overlay of texture paint uv layer

    :type: bool
    '''

    sticky_select_mode: typing.Union[str, int] = None
    ''' Automatically select also UVs sharing the same vertex as the ones being selected * ``DISABLED`` Disabled, Sticky vertex selection disabled. * ``SHARED_LOCATION`` Shared Location, Select UVs that are at the same location and share a mesh vertex. * ``SHARED_VERTEX`` Shared Vertex, Select UVs that share mesh vertex, irrespective if they are in the same location.

    :type: typing.Union[str, int]
    '''

    use_live_unwrap: bool = None
    ''' Continuously unwrap the selected UV island while transforming pinned vertices

    :type: bool
    '''

    use_snap_to_pixels: bool = None
    ''' Snap UVs to pixel locations while editing

    :type: bool
    '''


class Spline(bpy_struct):
    ''' Element of a curve, either NURBS, Bezier or Polyline or a character with text objects
    '''

    bezier_points: 'SplineBezierPoints' = None
    ''' Collection of points for Bezier curves only

    :type: 'SplineBezierPoints'
    '''

    character_index: int = None
    ''' Location of this character in the text data (only for text curves)

    :type: int
    '''

    hide: bool = None
    ''' Hide this curve in Edit mode

    :type: bool
    '''

    material_index: int = None
    ''' 

    :type: int
    '''

    order_u: int = None
    ''' NURBS order in the U direction (for splines and surfaces, higher values let points influence a greater area)

    :type: int
    '''

    order_v: int = None
    ''' NURBS order in the V direction (for surfaces only, higher values let points influence a greater area)

    :type: int
    '''

    point_count_u: int = None
    ''' Total number points for the curve or surface in the U direction

    :type: int
    '''

    point_count_v: int = None
    ''' Total number points for the surface on the V direction

    :type: int
    '''

    points: 'SplinePoints' = None
    ''' Collection of points that make up this poly or nurbs spline

    :type: 'SplinePoints'
    '''

    radius_interpolation: typing.Union[str, int] = None
    ''' The type of radius interpolation for Bezier curves

    :type: typing.Union[str, int]
    '''

    resolution_u: int = None
    ''' Curve or Surface subdivisions per segment

    :type: int
    '''

    resolution_v: int = None
    ''' Surface subdivisions per segment

    :type: int
    '''

    tilt_interpolation: typing.Union[str, int] = None
    ''' The type of tilt interpolation for 3D, Bezier curves

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' The interpolation type for this curve element

    :type: typing.Union[str, int]
    '''

    use_bezier_u: bool = None
    ''' Make this nurbs curve or surface act like a Bezier spline in the U direction (Order U must be 3 or 4, Cyclic U must be disabled)

    :type: bool
    '''

    use_bezier_v: bool = None
    ''' Make this nurbs surface act like a Bezier spline in the V direction (Order V must be 3 or 4, Cyclic V must be disabled)

    :type: bool
    '''

    use_cyclic_u: bool = None
    ''' Make this curve or surface a closed loop in the U direction

    :type: bool
    '''

    use_cyclic_v: bool = None
    ''' Make this surface a closed loop in the V direction

    :type: bool
    '''

    use_endpoint_u: bool = None
    ''' Make this nurbs curve or surface meet the endpoints in the U direction (Cyclic U must be disabled)

    :type: bool
    '''

    use_endpoint_v: bool = None
    ''' Make this nurbs surface meet the endpoints in the V direction (Cyclic V must be disabled)

    :type: bool
    '''

    use_smooth: bool = None
    ''' Smooth the normals of the surface or beveled curve

    :type: bool
    '''


class SplinePoint(bpy_struct):
    ''' Spline point without handles
    '''

    co: bpy_prop_array[float] = None
    ''' Point coordinates

    :type: bpy_prop_array[float]
    '''

    hide: bool = None
    ''' Visibility status

    :type: bool
    '''

    radius: float = None
    ''' Radius for beveling

    :type: float
    '''

    select: bool = None
    ''' Selection status

    :type: bool
    '''

    tilt: float = None
    ''' Tilt in 3D View

    :type: float
    '''

    weight: float = None
    ''' NURBS weight

    :type: float
    '''

    weight_softbody: float = None
    ''' Softbody goal weight

    :type: float
    '''


class Stereo3dDisplay(bpy_struct):
    ''' Settings for stereo 3D display
    '''

    anaglyph_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    display_mode: typing.Union[str, int] = None
    ''' * ``ANAGLYPH`` Anaglyph, Render views for left and right eyes as two differently filtered colors in a single image (anaglyph glasses are required). * ``INTERLACE`` Interlace, Render views for left and right eyes interlaced in a single image (3D-ready monitor is required). * ``TIMESEQUENTIAL`` Time Sequential, Render alternate eyes (also known as page flip, quad buffer support in the graphic card is required). * ``SIDEBYSIDE`` Side-by-Side, Render views for left and right eyes side-by-side. * ``TOPBOTTOM`` Top-Bottom, Render views for left and right eyes one above another.

    :type: typing.Union[str, int]
    '''

    interlace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_interlace_swap: bool = None
    ''' Swap left and right stereo channels

    :type: bool
    '''

    use_sidebyside_crosseyed: bool = None
    ''' Right eye should see left image and vice-versa

    :type: bool
    '''


class Stereo3dFormat(bpy_struct):
    ''' Settings for stereo output
    '''

    anaglyph_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    display_mode: typing.Union[str, int] = None
    ''' * ``ANAGLYPH`` Anaglyph, Render views for left and right eyes as two differently filtered colors in a single image (anaglyph glasses are required). * ``INTERLACE`` Interlace, Render views for left and right eyes interlaced in a single image (3D-ready monitor is required). * ``SIDEBYSIDE`` Side-by-Side, Render views for left and right eyes side-by-side. * ``TOPBOTTOM`` Top-Bottom, Render views for left and right eyes one above another.

    :type: typing.Union[str, int]
    '''

    interlace_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    use_interlace_swap: bool = None
    ''' Swap left and right stereo channels

    :type: bool
    '''

    use_sidebyside_crosseyed: bool = None
    ''' Right eye should see left image and vice-versa

    :type: bool
    '''

    use_squeezed_frame: bool = None
    ''' Combine both views in a squeezed image

    :type: bool
    '''


class Struct(bpy_struct):
    ''' RNA structure definition
    '''

    base: 'Struct' = None
    ''' Struct definition this is derived from

    :type: 'Struct'
    '''

    description: typing.Union[str, typing.Any] = None
    ''' Description of the Struct's purpose

    :type: typing.Union[str, typing.Any]
    '''

    functions: bpy_prop_collection['Function'] = None
    ''' 

    :type: bpy_prop_collection['Function']
    '''

    identifier: typing.Union[str, typing.Any] = None
    ''' Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Human readable name

    :type: typing.Union[str, typing.Any]
    '''

    name_property: 'StringProperty' = None
    ''' Property that gives the name of the struct

    :type: 'StringProperty'
    '''

    nested: 'Struct' = None
    ''' Struct in which this struct is always nested, and to which it logically belongs

    :type: 'Struct'
    '''

    properties: bpy_prop_collection['Property'] = None
    ''' Properties in the struct

    :type: bpy_prop_collection['Property']
    '''

    translation_context: typing.Union[str, typing.Any] = None
    ''' Translation context of the struct's name

    :type: typing.Union[str, typing.Any]
    '''


class TexMapping(bpy_struct):
    ''' Texture coordinate mapping settings
    '''

    mapping: typing.Union[str, int] = None
    ''' * ``FLAT`` Flat, Map X and Y coordinates directly. * ``CUBE`` Cube, Map using the normal vector. * ``TUBE`` Tube, Map with Z as central axis. * ``SPHERE`` Sphere, Map with Z as central axis.

    :type: typing.Union[str, int]
    '''

    mapping_x: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    mapping_y: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    mapping_z: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    max: bpy_prop_array[float] = None
    ''' Maximum value for clipping

    :type: bpy_prop_array[float]
    '''

    min: bpy_prop_array[float] = None
    ''' Minimum value for clipping

    :type: bpy_prop_array[float]
    '''

    rotation: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    scale: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    translation: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    use_max: bool = None
    ''' Whether to use maximum clipping value

    :type: bool
    '''

    use_min: bool = None
    ''' Whether to use minimum clipping value

    :type: bool
    '''

    vector_type: typing.Union[str, int] = None
    ''' Type of vector that the mapping transforms * ``TEXTURE`` Texture, Transform a texture by inverse mapping the texture coordinate. * ``POINT`` Point, Transform a point. * ``VECTOR`` Vector, Transform a direction vector. * ``NORMAL`` Normal, Transform a normal vector with unit length.

    :type: typing.Union[str, int]
    '''


class TexPaintSlot(bpy_struct):
    ''' Slot that contains information about texture painting
    '''

    index: int = None
    ''' Index of MTex slot in the material

    :type: int
    '''

    uv_layer: typing.Union[str, typing.Any] = None
    ''' Name of UV map

    :type: typing.Union[str, typing.Any]
    '''


class TextBox(bpy_struct):
    ''' Text bounding box for layout
    '''

    height: float = None
    ''' 

    :type: float
    '''

    width: float = None
    ''' 

    :type: float
    '''

    x: float = None
    ''' 

    :type: float
    '''

    y: float = None
    ''' 

    :type: float
    '''


class TextCharacterFormat(bpy_struct):
    ''' Text character formatting settings
    '''

    material_index: int = None
    ''' 

    :type: int
    '''

    use_bold: bool = None
    ''' 

    :type: bool
    '''

    use_italic: bool = None
    ''' 

    :type: bool
    '''

    use_small_caps: bool = None
    ''' 

    :type: bool
    '''

    use_underline: bool = None
    ''' 

    :type: bool
    '''


class TextLine(bpy_struct):
    ''' Line of text in a Text data-block
    '''

    body: typing.Union[str, typing.Any] = None
    ''' Text in the line

    :type: typing.Union[str, typing.Any]
    '''


class TextureSlot(bpy_struct):
    ''' Texture slot defining the mapping and influence of a texture
    '''

    blend_type: typing.Union[str, int] = None
    ''' Mode used to apply the texture

    :type: typing.Union[str, int]
    '''

    color: bpy_prop_array[float] = None
    ''' Default color for textures that don't return RGB or when RGB to intensity is enabled

    :type: bpy_prop_array[float]
    '''

    default_value: float = None
    ''' Value to use for Ref, Spec, Amb, Emit, Alpha, RayMir, TransLu and Hard

    :type: float
    '''

    invert: bool = None
    ''' Invert the values of the texture to reverse its effect

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Texture slot name

    :type: typing.Union[str, typing.Any]
    '''

    offset: bpy_prop_array[float] = None
    ''' Fine tune of the texture mapping X, Y and Z locations

    :type: bpy_prop_array[float]
    '''

    output_node: typing.Union[str, int] = None
    ''' Which output node to use, for node-based textures

    :type: typing.Union[str, int]
    '''

    scale: bpy_prop_array[float] = None
    ''' Set scaling for the texture's X, Y and Z sizes

    :type: bpy_prop_array[float]
    '''

    texture: 'Texture' = None
    ''' Texture data-block used by this texture slot

    :type: 'Texture'
    '''

    use_rgb_to_intensity: bool = None
    ''' Convert texture RGB values to intensity (gray) values

    :type: bool
    '''

    use_stencil: bool = None
    ''' Use this texture as a blending value on the next texture

    :type: bool
    '''


class Theme(bpy_struct):
    ''' Theme settings defining draw style and colors in the user interface
    '''

    bone_color_sets: bpy_prop_collection['ThemeBoneColorSet'] = None
    ''' 

    :type: bpy_prop_collection['ThemeBoneColorSet']
    '''

    clip_editor: 'ThemeClipEditor' = None
    ''' 

    :type: 'ThemeClipEditor'
    '''

    console: 'ThemeConsole' = None
    ''' 

    :type: 'ThemeConsole'
    '''

    dopesheet_editor: 'ThemeDopeSheet' = None
    ''' 

    :type: 'ThemeDopeSheet'
    '''

    file_browser: 'ThemeFileBrowser' = None
    ''' 

    :type: 'ThemeFileBrowser'
    '''

    graph_editor: 'ThemeGraphEditor' = None
    ''' 

    :type: 'ThemeGraphEditor'
    '''

    image_editor: 'ThemeImageEditor' = None
    ''' 

    :type: 'ThemeImageEditor'
    '''

    info: 'ThemeInfo' = None
    ''' 

    :type: 'ThemeInfo'
    '''

    logic_editor: 'ThemeLogicEditor' = None
    ''' 

    :type: 'ThemeLogicEditor'
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the theme

    :type: typing.Union[str, typing.Any]
    '''

    nla_editor: 'ThemeNLAEditor' = None
    ''' 

    :type: 'ThemeNLAEditor'
    '''

    node_editor: 'ThemeNodeEditor' = None
    ''' 

    :type: 'ThemeNodeEditor'
    '''

    outliner: 'ThemeOutliner' = None
    ''' 

    :type: 'ThemeOutliner'
    '''

    properties: 'ThemeProperties' = None
    ''' 

    :type: 'ThemeProperties'
    '''

    sequence_editor: 'ThemeSequenceEditor' = None
    ''' 

    :type: 'ThemeSequenceEditor'
    '''

    text_editor: 'ThemeTextEditor' = None
    ''' 

    :type: 'ThemeTextEditor'
    '''

    theme_area: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    timeline: 'ThemeTimeline' = None
    ''' 

    :type: 'ThemeTimeline'
    '''

    user_interface: 'ThemeUserInterface' = None
    ''' 

    :type: 'ThemeUserInterface'
    '''

    user_preferences: 'ThemeUserPreferences' = None
    ''' 

    :type: 'ThemeUserPreferences'
    '''

    view_3d: 'ThemeView3D' = None
    ''' 

    :type: 'ThemeView3D'
    '''


class ThemeBoneColorSet(bpy_struct):
    ''' Theme settings for bone color sets
    '''

    active: bpy_prop_array[float] = None
    ''' Color used for active bones

    :type: bpy_prop_array[float]
    '''

    normal: bpy_prop_array[float] = None
    ''' Color used for the surface of bones

    :type: bpy_prop_array[float]
    '''

    select: bpy_prop_array[float] = None
    ''' Color used for selected bones

    :type: bpy_prop_array[float]
    '''

    show_colored_constraints: bool = None
    ''' Allow the use of colors indicating constraints/keyed status

    :type: bool
    '''


class ThemeClipEditor(bpy_struct):
    ''' Theme settings for the Movie Clip Editor
    '''

    active_marker: bpy_prop_array[float] = None
    ''' Color of active marker

    :type: bpy_prop_array[float]
    '''

    disabled_marker: bpy_prop_array[float] = None
    ''' Color of disabled marker

    :type: bpy_prop_array[float]
    '''

    frame_current: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_size: int = None
    ''' 

    :type: int
    '''

    handle_align: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_auto: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_auto_clamped: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_free: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_align: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_auto: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_auto_clamped: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_free: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex_size: int = None
    ''' 

    :type: int
    '''

    locked_marker: bpy_prop_array[float] = None
    ''' Color of locked marker

    :type: bpy_prop_array[float]
    '''

    marker: bpy_prop_array[float] = None
    ''' Color of marker

    :type: bpy_prop_array[float]
    '''

    marker_outline: bpy_prop_array[float] = None
    ''' Color of marker's outline

    :type: bpy_prop_array[float]
    '''

    path_after: bpy_prop_array[float] = None
    ''' Color of path after current frame

    :type: bpy_prop_array[float]
    '''

    path_before: bpy_prop_array[float] = None
    ''' Color of path before current frame

    :type: bpy_prop_array[float]
    '''

    selected_marker: bpy_prop_array[float] = None
    ''' Color of selected marker

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    strips: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    strips_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeConsole(bpy_struct):
    ''' Theme settings for the Console
    '''

    cursor: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    line_error: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    line_info: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    line_input: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    line_output: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeDopeSheet(bpy_struct):
    ''' Theme settings for the Dope Sheet
    '''

    active_channels_group: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    channel_group: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    channels: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    channels_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    dopesheet_channel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    dopesheet_subchannel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    frame_current: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    grid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    keyframe: bpy_prop_array[float] = None
    ''' Color of Keyframe

    :type: bpy_prop_array[float]
    '''

    keyframe_border: bpy_prop_array[float] = None
    ''' Color of keyframe border

    :type: bpy_prop_array[float]
    '''

    keyframe_border_selected: bpy_prop_array[float] = None
    ''' Color of selected keyframe border

    :type: bpy_prop_array[float]
    '''

    keyframe_breakdown: bpy_prop_array[float] = None
    ''' Color of breakdown keyframe

    :type: bpy_prop_array[float]
    '''

    keyframe_breakdown_selected: bpy_prop_array[float] = None
    ''' Color of selected breakdown keyframe

    :type: bpy_prop_array[float]
    '''

    keyframe_extreme: bpy_prop_array[float] = None
    ''' Color of extreme keyframe

    :type: bpy_prop_array[float]
    '''

    keyframe_extreme_selected: bpy_prop_array[float] = None
    ''' Color of selected extreme keyframe

    :type: bpy_prop_array[float]
    '''

    keyframe_jitter: bpy_prop_array[float] = None
    ''' Color of jitter keyframe

    :type: bpy_prop_array[float]
    '''

    keyframe_jitter_selected: bpy_prop_array[float] = None
    ''' Color of selected jitter keyframe

    :type: bpy_prop_array[float]
    '''

    keyframe_scale_factor: float = None
    ''' Scale factor for adjusting the height of keyframes

    :type: float
    '''

    keyframe_selected: bpy_prop_array[float] = None
    ''' Color of selected keyframe

    :type: bpy_prop_array[float]
    '''

    long_key: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    long_key_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    summary: bpy_prop_array[float] = None
    ''' Color of summary channel

    :type: bpy_prop_array[float]
    '''

    value_sliders: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    view_sliders: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeFileBrowser(bpy_struct):
    ''' Theme settings for the File Browser
    '''

    selected_file: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeFontStyle(bpy_struct):
    ''' Theme settings for Font
    '''

    font_kerning_style: typing.Union[str, int] = None
    ''' Which style to use for font kerning * ``UNFITTED`` Unfitted, Use scaled but un-grid-fitted kerning distances. * ``FITTED`` Fitted, Use scaled and grid-fitted kerning distances.

    :type: typing.Union[str, int]
    '''

    points: int = None
    ''' 

    :type: int
    '''

    shadow: int = None
    ''' Shadow size (0, 3 and 5 supported)

    :type: int
    '''

    shadow_alpha: float = None
    ''' 

    :type: float
    '''

    shadow_offset_x: int = None
    ''' Shadow offset in pixels

    :type: int
    '''

    shadow_offset_y: int = None
    ''' Shadow offset in pixels

    :type: int
    '''

    shadow_value: float = None
    ''' Shadow color in gray value

    :type: float
    '''


class ThemeGradientColors(bpy_struct):
    ''' Theme settings for background colors and gradient
    '''

    gradient: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    high_gradient: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    show_grad: bool = None
    ''' Do a gradient for the background of the viewport working area

    :type: bool
    '''


class ThemeGraphEditor(bpy_struct):
    ''' Theme settings for the graph editor
    '''

    active_channels_group: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    channel_group: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    channels_region: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    dopesheet_channel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    dopesheet_subchannel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    frame_current: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    grid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_align: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_auto: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_auto_clamped: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_free: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_align: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_auto: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_auto_clamped: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_free: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_vect: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vect: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex_size: int = None
    ''' 

    :type: int
    '''

    lastsel_point: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex_size: int = None
    ''' 

    :type: int
    '''

    vertex_unreferenced: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    window_sliders: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeImageEditor(bpy_struct):
    ''' Theme settings for the Image Editor
    '''

    edge_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    editmesh_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face_dot: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    facedot_size: int = None
    ''' 

    :type: int
    '''

    frame_current: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    freestyle_face_mark: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_size: int = None
    ''' 

    :type: int
    '''

    handle_align: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_auto: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_auto_clamped: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_free: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_align: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_auto: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_auto_clamped: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_free: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vertex_size: int = None
    ''' 

    :type: int
    '''

    metadatabg: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    metadatatext: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    paint_curve_handle: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    paint_curve_pivot: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_edge: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_face: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_stitchable: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_unstitchable: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_stitch_vert: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    scope_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    uv_others: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    uv_shadow: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex_size: int = None
    ''' 

    :type: int
    '''

    vertex_unreferenced: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    wire_edit: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeInfo(bpy_struct):
    ''' Theme settings for Info
    '''

    info_debug: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_debug_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_error: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_error_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_info: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_info_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_selected_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_warning: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    info_warning_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeLogicEditor(bpy_struct):
    ''' Theme settings for the Logic Editor
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeNLAEditor(bpy_struct):
    ''' Theme settings for the NLA Editor
    '''

    active_action: bpy_prop_array[float] = None
    ''' Animation data block has active action

    :type: bpy_prop_array[float]
    '''

    active_action_unset: bpy_prop_array[float] = None
    ''' Animation data block doesn't have active action

    :type: bpy_prop_array[float]
    '''

    frame_current: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    grid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    keyframe_border: bpy_prop_array[float] = None
    ''' Color of keyframe border

    :type: bpy_prop_array[float]
    '''

    keyframe_border_selected: bpy_prop_array[float] = None
    ''' Color of selected keyframe border

    :type: bpy_prop_array[float]
    '''

    meta_strips: bpy_prop_array[float] = None
    ''' Meta Strip - Unselected (for grouping related strips)

    :type: bpy_prop_array[float]
    '''

    meta_strips_selected: bpy_prop_array[float] = None
    ''' Meta Strip - Selected (for grouping related strips)

    :type: bpy_prop_array[float]
    '''

    sound_strips: bpy_prop_array[float] = None
    ''' Sound Strip - Unselected (for timing speaker sounds)

    :type: bpy_prop_array[float]
    '''

    sound_strips_selected: bpy_prop_array[float] = None
    ''' Sound Strip - Selected (for timing speaker sounds)

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    strips: bpy_prop_array[float] = None
    ''' Action-Clip Strip - Unselected

    :type: bpy_prop_array[float]
    '''

    strips_selected: bpy_prop_array[float] = None
    ''' Action-Clip Strip - Selected

    :type: bpy_prop_array[float]
    '''

    transition_strips: bpy_prop_array[float] = None
    ''' Transition Strip - Unselected

    :type: bpy_prop_array[float]
    '''

    transition_strips_selected: bpy_prop_array[float] = None
    ''' Transition Strip - Selected

    :type: bpy_prop_array[float]
    '''

    tweak: bpy_prop_array[float] = None
    ''' Color for strip/action being 'tweaked' or edited

    :type: bpy_prop_array[float]
    '''

    tweak_duplicate: bpy_prop_array[float] = None
    ''' Warning/error indicator color for strips referencing the strip being tweaked

    :type: bpy_prop_array[float]
    '''

    view_sliders: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeNodeEditor(bpy_struct):
    ''' Theme settings for the Node Editor
    '''

    color_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    converter_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    distor_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    filter_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    frame_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_size: int = None
    ''' 

    :type: int
    '''

    group_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    group_socket_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    input_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    layout_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    matte_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    node_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    node_backdrop: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    node_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    noodle_curving: int = None
    ''' Curving of the noodle

    :type: int
    '''

    output_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    pattern_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    script_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    selected_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    shader_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    ''' Settings for space list

    :type: 'ThemeSpaceListGeneric'
    '''

    texture_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vector_node: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    wire: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    wire_inner: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    wire_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeOutliner(bpy_struct):
    ''' Theme settings for the Outliner
    '''

    match: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    selected_highlight: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''


class ThemePanelColors(bpy_struct):
    ''' Theme settings for panel colors
    '''

    back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    show_back: bool = None
    ''' 

    :type: bool
    '''

    show_header: bool = None
    ''' 

    :type: bool
    '''


class ThemeProperties(bpy_struct):
    ''' Theme settings for the Properties
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeSequenceEditor(bpy_struct):
    ''' Theme settings for the Sequence Editor
    '''

    audio_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    draw_action: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    effect_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    frame_current: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_size: int = None
    ''' 

    :type: int
    '''

    grid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    image_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    keyframe: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    meta_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    metadatabg: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    metadatatext: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    movie_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    movieclip_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    preview_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    scene_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    text_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    transition_strip: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    window_sliders: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeSpaceGeneric(bpy_struct):
    back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button_text_hi: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button_title: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header_text_hi: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    panelcolors: 'ThemePanelColors' = None
    ''' 

    :type: 'ThemePanelColors'
    '''

    tab_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tab_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tab_inactive: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tab_outline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    text_hi: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    title: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeSpaceGradient(bpy_struct):
    button: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button_text_hi: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    button_title: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gradients: 'ThemeGradientColors' = None
    ''' 

    :type: 'ThemeGradientColors'
    '''

    header: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    header_text_hi: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    panelcolors: 'ThemePanelColors' = None
    ''' 

    :type: 'ThemePanelColors'
    '''

    tab_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tab_back: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tab_inactive: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    tab_outline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    text_hi: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    title: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeSpaceListGeneric(bpy_struct):
    list: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    list_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    list_text_hi: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    list_title: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeStyle(bpy_struct):
    ''' Theme settings for style sets
    '''

    panel_title: 'ThemeFontStyle' = None
    ''' 

    :type: 'ThemeFontStyle'
    '''

    widget: 'ThemeFontStyle' = None
    ''' 

    :type: 'ThemeFontStyle'
    '''

    widget_label: 'ThemeFontStyle' = None
    ''' 

    :type: 'ThemeFontStyle'
    '''


class ThemeTextEditor(bpy_struct):
    ''' Theme settings for the Text Editor
    '''

    cursor: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    line_numbers_background: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    selected_text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    syntax_builtin: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    syntax_comment: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    syntax_numbers: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    syntax_preprocessor: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    syntax_reserved: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    syntax_special: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    syntax_string: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    syntax_symbols: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeTimeline(bpy_struct):
    ''' Theme settings for the Timeline
    '''

    frame_current: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    grid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''

    time_grease_pencil: bpy_prop_array[float] = None
    ''' Color of Grease Pencil keyframes

    :type: bpy_prop_array[float]
    '''

    time_keyframe: bpy_prop_array[float] = None
    ''' Base color for keyframe indicator lines

    :type: bpy_prop_array[float]
    '''


class ThemeUserInterface(bpy_struct):
    ''' Theme settings for user interface elements
    '''

    axis_x: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    axis_y: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    axis_z: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    icon_alpha: float = None
    ''' Transparency of icons in the interface, to reduce contrast

    :type: float
    '''

    icon_file: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    menu_shadow_fac: float = None
    ''' Blending factor for menu shadows

    :type: float
    '''

    menu_shadow_width: int = None
    ''' Width of menu shadows, set to zero to disable

    :type: int
    '''

    wcol_box: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_list_item: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_menu: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_menu_back: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_menu_item: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_num: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_numslider: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_option: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_pie_menu: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_progress: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_pulldown: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_radio: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_regular: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_scroll: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_state: 'ThemeWidgetStateColors' = None
    ''' 

    :type: 'ThemeWidgetStateColors'
    '''

    wcol_text: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_toggle: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_tool: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    wcol_tooltip: 'ThemeWidgetColors' = None
    ''' 

    :type: 'ThemeWidgetColors'
    '''

    widget_emboss: bpy_prop_array[float] = None
    ''' Color of the 1px shadow line underlying widgets

    :type: bpy_prop_array[float]
    '''


class ThemeUserPreferences(bpy_struct):
    ''' Theme settings for the User Preferences
    '''

    space: 'ThemeSpaceGeneric' = None
    ''' Settings for space

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeView3D(bpy_struct):
    ''' Theme settings for the 3D View
    '''

    act_spline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    bone_pose: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    bone_pose_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    bone_solid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    bundle_solid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    camera: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    camera_path: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    clipping_border_3d: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    edge_crease: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    edge_facesel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    edge_seam: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    edge_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    edge_sharp: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    editmesh_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    empty: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    extra_edge_angle: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    extra_edge_len: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    extra_face_angle: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    extra_face_area: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face_dot: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    face_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    facedot_size: int = None
    ''' 

    :type: int
    '''

    frame_current: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    freestyle_edge_mark: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    freestyle_face_mark: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    gp_vertex_size: int = None
    ''' 

    :type: int
    '''

    grid: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_align: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_auto: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_free: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_align: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_auto: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_free: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_sel_vect: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    handle_vect: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    lamp: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    lastsel_point: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    normal: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    nurb_sel_uline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    nurb_sel_vline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    nurb_uline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    nurb_vline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    object_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    object_grouped: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    object_grouped_active: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    object_selected: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    outline_width: int = None
    ''' 

    :type: int
    '''

    paint_curve_handle: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    paint_curve_pivot: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    skin_root: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    space: 'ThemeSpaceGradient' = None
    ''' Settings for space

    :type: 'ThemeSpaceGradient'
    '''

    speaker: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    split_normal: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    text_grease_pencil: bpy_prop_array[float] = None
    ''' Color for indicating Grease Pencil keyframes

    :type: bpy_prop_array[float]
    '''

    text_keyframe: bpy_prop_array[float] = None
    ''' Color for indicating Object keyframes

    :type: bpy_prop_array[float]
    '''

    transform: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex_normal: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex_select: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    vertex_size: int = None
    ''' 

    :type: int
    '''

    vertex_unreferenced: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    view_overlay: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    wire: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    wire_edit: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeWidgetColors(bpy_struct):
    ''' Theme settings for widget color sets
    '''

    inner: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    inner_sel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    item: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    outline: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    shadedown: int = None
    ''' 

    :type: int
    '''

    shadetop: int = None
    ''' 

    :type: int
    '''

    show_shaded: bool = None
    ''' 

    :type: bool
    '''

    text: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    text_sel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class ThemeWidgetStateColors(bpy_struct):
    ''' Theme settings for widget state colors
    '''

    blend: float = None
    ''' 

    :type: float
    '''

    inner_anim: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    inner_anim_sel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    inner_driven: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    inner_driven_sel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    inner_key: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    inner_key_sel: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''


class TimelineMarker(bpy_struct):
    ''' Marker for noting points in the timeline
    '''

    camera: 'Object' = None
    ''' Camera this timeline sets to active

    :type: 'Object'
    '''

    frame: int = None
    ''' The frame on which the timeline marker appears

    :type: int
    '''

    name: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    select: bool = None
    ''' Marker selection state

    :type: bool
    '''


class Timer(bpy_struct):
    ''' Window event timer
    '''

    time_delta: float = None
    ''' Time since last step in seconds

    :type: float
    '''

    time_duration: float = None
    ''' Time since last step in seconds

    :type: float
    '''

    time_step: float = None
    ''' 

    :type: float
    '''


class ToolSettings(bpy_struct):
    auto_keying_mode: typing.Union[str, int] = None
    ''' Mode of automatic keyframe insertion for Objects and Bones

    :type: typing.Union[str, int]
    '''

    curve_paint_settings: 'CurvePaintSettings' = None
    ''' 

    :type: 'CurvePaintSettings'
    '''

    double_threshold: float = None
    ''' Limit for removing duplicates and 'Auto Merge'

    :type: float
    '''

    edge_path_live_unwrap: bool = None
    ''' Changing edges seam re-calculates UV unwrap

    :type: bool
    '''

    edge_path_mode: typing.Union[str, int] = None
    ''' The edge flag to tag when selecting the shortest path

    :type: typing.Union[str, int]
    '''

    etch_adaptive_limit: float = None
    ''' Correlation threshold for number of bones in the subdivided stroke

    :type: float
    '''

    etch_convert_mode: typing.Union[str, int] = None
    ''' Method used to convert stroke to bones * ``FIXED`` Fixed, Subdivide stroke in fixed number of bones. * ``LENGTH`` Length, Subdivide stroke in bones of specific length. * ``ADAPTIVE`` Adaptive, Subdivide stroke adaptively, with more subdivision in curvier parts. * ``RETARGET`` Retarget, Retarget template bone chain to stroke.

    :type: typing.Union[str, int]
    '''

    etch_length_limit: float = None
    ''' Maximum length of the subdivided bones

    :type: float
    '''

    etch_number: typing.Union[str, typing.Any] = None
    ''' Text to replace &N with (e.g. 'Finger.&N' -> 'Finger.1' or 'Finger.One')

    :type: typing.Union[str, typing.Any]
    '''

    etch_roll_mode: typing.Union[str, int] = None
    ''' Method used to adjust the roll of bones when retargeting * ``NONE`` None, Don't adjust roll. * ``VIEW`` View, Roll bones to face the view. * ``JOINT`` Joint, Roll bone to original joint plane offset.

    :type: typing.Union[str, int]
    '''

    etch_side: typing.Union[str, typing.Any] = None
    ''' Text to replace &S with (e.g. 'Arm.&S' -> 'Arm.R' or 'Arm.Right')

    :type: typing.Union[str, typing.Any]
    '''

    etch_subdivision_number: int = None
    ''' Number of bones in the subdivided stroke

    :type: int
    '''

    etch_template: 'Object' = None
    ''' Template armature that will be retargeted to the stroke

    :type: 'Object'
    '''

    gpencil_brushes: 'GreasePencilBrushes' = None
    ''' Grease Pencil drawing brushes

    :type: 'GreasePencilBrushes'
    '''

    gpencil_sculpt: 'GPencilSculptSettings' = None
    ''' 

    :type: 'GPencilSculptSettings'
    '''

    gpencil_stroke_placement_image_editor: typing.Union[str, int] = None
    ''' * ``CURSOR`` Cursor, Draw stroke at the 3D cursor. * ``VIEW`` View, Stick stroke to the view . * ``SURFACE`` Surface, Stick stroke to surfaces. * ``STROKE`` Stroke, Stick stroke to other strokes.

    :type: typing.Union[str, int]
    '''

    gpencil_stroke_placement_sequencer_preview: typing.Union[str, int] = None
    ''' * ``CURSOR`` Cursor, Draw stroke at the 3D cursor. * ``VIEW`` View, Stick stroke to the view . * ``SURFACE`` Surface, Stick stroke to surfaces. * ``STROKE`` Stroke, Stick stroke to other strokes.

    :type: typing.Union[str, int]
    '''

    gpencil_stroke_placement_view2d: typing.Union[str, int] = None
    ''' * ``CURSOR`` Cursor, Draw stroke at the 3D cursor. * ``VIEW`` View, Stick stroke to the view . * ``SURFACE`` Surface, Stick stroke to surfaces. * ``STROKE`` Stroke, Stick stroke to other strokes.

    :type: typing.Union[str, int]
    '''

    gpencil_stroke_placement_view3d: typing.Union[str, int] = None
    ''' * ``CURSOR`` Cursor, Draw stroke at the 3D cursor. * ``VIEW`` View, Stick stroke to the view . * ``SURFACE`` Surface, Stick stroke to surfaces. * ``STROKE`` Stroke, Stick stroke to other strokes.

    :type: typing.Union[str, int]
    '''

    grease_pencil_source: typing.Union[str, int] = None
    ''' Datablock where active Grease Pencil data is found from * ``SCENE`` Scene, Grease Pencil data attached to the current scene is used, unless the active object already has Grease Pencil data (i.e. for old files). * ``OBJECT`` Object, Grease Pencil data-blocks attached to the active object are used (required when using pre 2.73 add-ons, e.g. BSurfaces).

    :type: typing.Union[str, int]
    '''

    image_paint: 'ImagePaint' = None
    ''' 

    :type: 'ImagePaint'
    '''

    keyframe_type: typing.Union[str, int] = None
    ''' Type of keyframes to create when inserting keyframes * ``KEYFRAME`` Keyframe, Normal keyframe - e.g. for key poses. * ``BREAKDOWN`` Breakdown, A breakdown pose - e.g. for transitions between key poses. * ``MOVING_HOLD`` Moving Hold, A keyframe that is part of a moving hold. * ``EXTREME`` Extreme, An 'extreme' pose, or some other purpose as needed. * ``JITTER`` Jitter, A filler or baked keyframe for keying on ones, or some other purpose as needed.

    :type: typing.Union[str, int]
    '''

    lock_markers: bool = None
    ''' Prevent marker editing

    :type: bool
    '''

    mesh_select_mode: typing.List[bool] = None
    ''' Which mesh elements selection works on

    :type: typing.List[bool]
    '''

    normal_size: float = None
    ''' Display size for normals in the 3D view

    :type: float
    '''

    particle_edit: 'ParticleEdit' = None
    ''' 

    :type: 'ParticleEdit'
    '''

    proportional_edit: typing.Union[str, int] = None
    ''' Proportional Editing mode, allows transforms with distance fall-off * ``DISABLED`` Disable, Proportional Editing disabled. * ``ENABLED`` Enable, Proportional Editing enabled. * ``PROJECTED`` Projected (2D), Proportional Editing using screen space locations. * ``CONNECTED`` Connected, Proportional Editing using connected geometry only.

    :type: typing.Union[str, int]
    '''

    proportional_edit_falloff: typing.Union[str, int] = None
    ''' Falloff type for proportional editing mode * ``SMOOTH`` Smooth, Smooth falloff. * ``SPHERE`` Sphere, Spherical falloff. * ``ROOT`` Root, Root falloff. * ``INVERSE_SQUARE`` Inverse Square, Inverse Square falloff. * ``SHARP`` Sharp, Sharp falloff. * ``LINEAR`` Linear, Linear falloff. * ``CONSTANT`` Constant, Constant falloff. * ``RANDOM`` Random, Random falloff.

    :type: typing.Union[str, int]
    '''

    proportional_size: float = None
    ''' Display size for proportional editing circle

    :type: float
    '''

    sculpt: 'Sculpt' = None
    ''' 

    :type: 'Sculpt'
    '''

    show_uv_local_view: bool = None
    ''' Draw only faces with the currently displayed image assigned

    :type: bool
    '''

    snap_element: typing.Union[str, int] = None
    ''' Type of element to snap to * ``INCREMENT`` Increment, Snap to increments of grid. * ``VERTEX`` Vertex, Snap to vertices. * ``EDGE`` Edge, Snap to edges. * ``FACE`` Face, Snap to faces. * ``VOLUME`` Volume, Snap to volume.

    :type: typing.Union[str, int]
    '''

    snap_node_element: typing.Union[str, int] = None
    ''' Type of element to snap to * ``GRID`` Grid, Snap to grid. * ``NODE_X`` Node X, Snap to left/right node border. * ``NODE_Y`` Node Y, Snap to top/bottom node border. * ``NODE_XY`` Node X / Y, Snap to any node border.

    :type: typing.Union[str, int]
    '''

    snap_target: typing.Union[str, int] = None
    ''' Which part to snap onto the target * ``CLOSEST`` Closest, Snap closest point onto target. * ``CENTER`` Center, Snap center onto target. * ``MEDIAN`` Median, Snap median onto target. * ``ACTIVE`` Active, Snap active onto target.

    :type: typing.Union[str, int]
    '''

    snap_uv_element: typing.Union[str, int] = None
    ''' Type of element to snap to * ``INCREMENT`` Increment, Snap to increments of grid. * ``VERTEX`` Vertex, Snap to vertices.

    :type: typing.Union[str, int]
    '''

    statvis: 'MeshStatVis' = None
    ''' 

    :type: 'MeshStatVis'
    '''

    unified_paint_settings: 'UnifiedPaintSettings' = None
    ''' 

    :type: 'UnifiedPaintSettings'
    '''

    use_auto_normalize: bool = None
    ''' Ensure all bone-deforming vertex groups add up to 1.0 while weight painting

    :type: bool
    '''

    use_bone_sketching: bool = None
    ''' Use sketching to create and edit bones

    :type: bool
    '''

    use_etch_autoname: bool = None
    ''' Automatically generate values to replace &N and &S suffix placeholders in template names

    :type: bool
    '''

    use_etch_overdraw: bool = None
    ''' Adjust strokes by drawing near them

    :type: bool
    '''

    use_etch_quick: bool = None
    ''' Automatically convert and delete on stroke end

    :type: bool
    '''

    use_gpencil_additive_drawing: bool = None
    ''' When creating new frames, the strokes from the previous/active frame are included as the basis for the new one

    :type: bool
    '''

    use_gpencil_continuous_drawing: bool = None
    ''' Allow drawing multiple strokes at a time with Grease Pencil

    :type: bool
    '''

    use_gpencil_draw_onback: bool = None
    ''' When draw new strokes, the new stroke is drawn below of all strokes in the layer

    :type: bool
    '''

    use_gpencil_stroke_endpoints: bool = None
    ''' Only use the first and last parts of the stroke for snapping

    :type: bool
    '''

    use_keyframe_insert_auto: bool = None
    ''' Automatic keyframe insertion for Objects and Bones

    :type: bool
    '''

    use_keyframe_insert_keyingset: bool = None
    ''' Automatic keyframe insertion using active Keying Set only

    :type: bool
    '''

    use_mesh_automerge: bool = None
    ''' Automatically merge vertices moved to the same location

    :type: bool
    '''

    use_multipaint: bool = None
    ''' Paint across the weights of all selected bones, maintaining their relative influence

    :type: bool
    '''

    use_proportional_action: bool = None
    ''' Proportional editing in action editor

    :type: bool
    '''

    use_proportional_edit_mask: bool = None
    ''' Proportional editing mask mode

    :type: bool
    '''

    use_proportional_edit_objects: bool = None
    ''' Proportional editing object mode

    :type: bool
    '''

    use_proportional_fcurve: bool = None
    ''' Proportional editing in FCurve editor

    :type: bool
    '''

    use_record_with_nla: bool = None
    ''' Add a new NLA Track + Strip for every loop/pass made over the animation to allow non-destructive tweaking

    :type: bool
    '''

    use_snap: bool = None
    ''' Snap during transform

    :type: bool
    '''

    use_snap_align_rotation: bool = None
    ''' Align rotation with the snapping target

    :type: bool
    '''

    use_snap_grid_absolute: bool = None
    ''' Absolute grid alignment while translating (based on the pivot center)

    :type: bool
    '''

    use_snap_peel_object: bool = None
    ''' Consider objects as whole when finding volume center

    :type: bool
    '''

    use_snap_project: bool = None
    ''' Project individual elements on the surface of other objects

    :type: bool
    '''

    use_snap_self: bool = None
    ''' Snap onto itself (editmode)

    :type: bool
    '''

    use_uv_sculpt: bool = None
    ''' Enable brush for UV sculpting

    :type: bool
    '''

    use_uv_select_sync: bool = None
    ''' Keep UV and edit mode mesh selection in sync

    :type: bool
    '''

    uv_relax_method: typing.Union[str, int] = None
    ''' Algorithm used for UV relaxation * ``LAPLACIAN`` Laplacian, Use Laplacian method for relaxation. * ``HC`` HC, Use HC method for relaxation.

    :type: typing.Union[str, int]
    '''

    uv_sculpt: 'UvSculpt' = None
    ''' 

    :type: 'UvSculpt'
    '''

    uv_sculpt_all_islands: bool = None
    ''' Brush operates on all islands

    :type: bool
    '''

    uv_sculpt_lock_borders: bool = None
    ''' Disable editing of boundary edges

    :type: bool
    '''

    uv_sculpt_tool: typing.Union[str, int] = None
    ''' Select Tools for the UV sculpt brushes * ``PINCH`` Pinch, Pinch UVs. * ``RELAX`` Relax, Relax UVs. * ``GRAB`` Grab, Grab UVs.

    :type: typing.Union[str, int]
    '''

    uv_select_mode: typing.Union[str, int] = None
    ''' UV selection and display mode * ``VERTEX`` Vertex, Vertex selection mode. * ``EDGE`` Edge, Edge selection mode. * ``FACE`` Face, Face selection mode. * ``ISLAND`` Island, Island selection mode.

    :type: typing.Union[str, int]
    '''

    vertex_group_subset: typing.Union[str, int] = None
    ''' Filter Vertex groups for Display * ``ALL`` All, All Vertex Groups. * ``BONE_DEFORM`` Deform, Vertex Groups assigned to Deform Bones. * ``OTHER_DEFORM`` Other, Vertex Groups assigned to non Deform Bones.

    :type: typing.Union[str, int]
    '''

    vertex_group_user: typing.Union[str, int] = None
    ''' Display unweighted vertices * ``NONE`` None. * ``ACTIVE`` Active, Show vertices with no weights in the active group. * ``ALL`` All, Show vertices with no weights in any group.

    :type: typing.Union[str, int]
    '''

    vertex_group_weight: float = None
    ''' Weight to assign in vertex groups

    :type: float
    '''

    vertex_paint: 'VertexPaint' = None
    ''' 

    :type: 'VertexPaint'
    '''

    weight_paint: 'VertexPaint' = None
    ''' 

    :type: 'VertexPaint'
    '''


class TransformOrientation(bpy_struct):
    matrix: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Name of the custom transform orientation

    :type: typing.Union[str, typing.Any]
    '''


class UILayout(bpy_struct):
    ''' User interface layout in a panel or header
    '''

    active: bool = None
    ''' 

    :type: bool
    '''

    alert: bool = None
    ''' 

    :type: bool
    '''

    alignment: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    enabled: bool = None
    ''' When false, this (sub)layout is grayed out

    :type: bool
    '''

    operator_context: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    scale_x: float = None
    ''' Scale factor along the X for items in this (sub)layout

    :type: float
    '''

    scale_y: float = None
    ''' Scale factor along the Y for items in this (sub)layout

    :type: float
    '''

    def row(self,
            align: typing.Optional[typing.Union[bool, typing.Any]] = False
            ) -> 'UILayout':
        ''' Sub-layout. Items placed in this sublayout are placed next to each other in a row

        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        '''
        pass

    def column(self,
               align: typing.Optional[typing.Union[bool, typing.Any]] = False
               ) -> 'UILayout':
        ''' Sub-layout. Items placed in this sublayout are placed under each other in a column

        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        '''
        pass

    def column_flow(
            self,
            columns: typing.Optional[typing.Any] = 0,
            align: typing.Optional[typing.Union[bool, typing.Any]] = False
    ) -> 'UILayout':
        ''' column_flow

        :param columns: Number of columns, 0 is automatic
        :type columns: typing.Optional[typing.Any]
        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        '''
        pass

    def box(self) -> 'UILayout':
        ''' Sublayout (items placed in this sublayout are placed under each other in a column and are surrounded by a box)

        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        '''
        pass

    def split(self,
              percentage: typing.Optional[typing.Any] = 0.0,
              align: typing.Optional[typing.Union[bool, typing.Any]] = False
              ) -> 'UILayout':
        ''' split

        :param percentage: Percentage, Percentage of width to split at
        :type percentage: typing.Optional[typing.Any]
        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        '''
        pass

    def menu_pie(self) -> 'UILayout':
        ''' Sublayout. Items placed in this sublayout are placed in a radial fashion around the menu center)

        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        '''
        pass

    @classmethod
    def icon(cls, data: typing.Any) -> int:
        ''' Return the custom icon for this data, use it e.g. to get materials or texture icons

        :param data: Data from which to take the icon
        :type data: typing.Any
        :rtype: int
        :return: Icon identifier
        '''
        pass

    @classmethod
    def enum_item_name(cls, data: typing.Any,
                       property: typing.Union[str, typing.Any],
                       identifier: typing.Union[str, typing.Any]
                       ) -> typing.Union[str, typing.Any]:
        ''' Return the UI name for this enum item

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param identifier: Identifier of the enum item
        :type identifier: typing.Union[str, typing.Any]
        :rtype: typing.Union[str, typing.Any]
        :return: UI name of the enum item
        '''
        pass

    @classmethod
    def enum_item_description(cls, data: typing.Any,
                              property: typing.Union[str, typing.Any],
                              identifier: typing.Union[str, typing.Any]
                              ) -> typing.Union[str, typing.Any]:
        ''' Return the UI description for this enum item

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param identifier: Identifier of the enum item
        :type identifier: typing.Union[str, typing.Any]
        :rtype: typing.Union[str, typing.Any]
        :return: UI description of the enum item
        '''
        pass

    @classmethod
    def enum_item_icon(cls, data: typing.Any,
                       property: typing.Union[str, typing.Any],
                       identifier: typing.Union[str, typing.Any]) -> int:
        ''' Return the icon for this enum item

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param identifier: Identifier of the enum item
        :type identifier: typing.Union[str, typing.Any]
        :rtype: int
        :return: Icon identifier
        '''
        pass

    def prop(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
            icon: typing.Optional[typing.Any] = 'NONE',
            expand: typing.Optional[typing.Union[bool, typing.Any]] = False,
            slider: typing.Optional[typing.Union[bool, typing.Any]] = False,
            toggle: typing.Optional[typing.Union[bool, typing.Any]] = False,
            icon_only: typing.Optional[typing.Union[bool, typing.Any]] = False,
            event: typing.Optional[typing.Union[bool, typing.Any]] = False,
            full_event: typing.Optional[typing.Union[bool, typing.
                                                     Any]] = False,
            emboss: typing.Optional[typing.Union[bool, typing.Any]] = True,
            index: typing.Optional[typing.Any] = -1,
            icon_value: typing.Optional[typing.Any] = 0):
        ''' Item. Exposes an RNA item and places it into the layout

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon: Icon, Override automatic icon of the item
        :type icon: typing.Optional[typing.Any]
        :param expand: Expand button to show more detail
        :type expand: typing.Optional[typing.Union[bool, typing.Any]]
        :param slider: Use slider widget for numeric values
        :type slider: typing.Optional[typing.Union[bool, typing.Any]]
        :param toggle: Use toggle widget for boolean values
        :type toggle: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon_only: Draw only icons in buttons, no text
        :type icon_only: typing.Optional[typing.Union[bool, typing.Any]]
        :param event: Use button to input key events
        :type event: typing.Optional[typing.Union[bool, typing.Any]]
        :param full_event: Use button to input full events including modifiers
        :type full_event: typing.Optional[typing.Union[bool, typing.Any]]
        :param emboss: Draw the button itself, just the icon/text
        :type emboss: typing.Optional[typing.Union[bool, typing.Any]]
        :param index: The index of this button, when set a single member of an array can be accessed, when set to -1 all array members are used
        :type index: typing.Optional[typing.Any]
        :param icon_value: Icon Value, Override automatic icon of the item
        :type icon_value: typing.Optional[typing.Any]
        '''
        pass

    def props_enum(self, data: typing.Any,
                   property: typing.Union[str, typing.Any]):
        ''' props_enum

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        '''
        pass

    def prop_menu_enum(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
            icon: typing.Optional[typing.Any] = 'NONE'):
        ''' prop_menu_enum

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon: Icon, Override automatic icon of the item
        :type icon: typing.Optional[typing.Any]
        '''
        pass

    def prop_enum(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            value: typing.Union[str, typing.Any],
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
            icon: typing.Optional[typing.Any] = 'NONE'):
        ''' prop_enum

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param value: Enum property value
        :type value: typing.Union[str, typing.Any]
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon: Icon, Override automatic icon of the item
        :type icon: typing.Optional[typing.Any]
        '''
        pass

    def prop_search(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            search_data: typing.Any,
            search_property: typing.Union[str, typing.Any],
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
            icon: typing.Optional[typing.Any] = 'NONE'):
        ''' prop_search

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param search_data: Data from which to take collection to search in
        :type search_data: typing.Any
        :param search_property: Identifier of search collection property
        :type search_property: typing.Union[str, typing.Any]
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon: Icon, Override automatic icon of the item
        :type icon: typing.Optional[typing.Any]
        '''
        pass

    def operator(
            self,
            operator: typing.Union[str, typing.Any],
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
            icon: typing.Optional[typing.Any] = 'NONE',
            emboss: typing.Optional[typing.Union[bool, typing.Any]] = True,
            icon_value: typing.Optional[typing.Any] = 0
    ) -> 'OperatorProperties':
        ''' Item. Places a button into the layout to call an Operator

        :param operator: Identifier of the operator
        :type operator: typing.Union[str, typing.Any]
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon: Icon, Override automatic icon of the item
        :type icon: typing.Optional[typing.Any]
        :param emboss: Draw the button itself, just the icon/text
        :type emboss: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon_value: Icon Value, Override automatic icon of the item
        :type icon_value: typing.Optional[typing.Any]
        :rtype: 'OperatorProperties'
        :return: Operator properties to fill in, return when 'properties' is set to true
        '''
        pass

    def operator_enum(self, operator: typing.Union[str, typing.Any],
                      property: typing.Union[str, typing.Any]):
        ''' operator_enum

        :param operator: Identifier of the operator
        :type operator: typing.Union[str, typing.Any]
        :param property: Identifier of property in operator
        :type property: typing.Union[str, typing.Any]
        '''
        pass

    def operator_menu_enum(
            self,
            operator: typing.Union[str, typing.Any],
            property: typing.Union[str, typing.Any],
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
            icon: typing.Optional[typing.Any] = 'NONE'):
        ''' operator_menu_enum

        :param operator: Identifier of the operator
        :type operator: typing.Union[str, typing.Any]
        :param property: Identifier of property in operator
        :type property: typing.Union[str, typing.Any]
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon: Icon, Override automatic icon of the item
        :type icon: typing.Optional[typing.Any]
        '''
        pass

    def label(
            self,
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
            icon: typing.Optional[typing.Any] = 'NONE',
            icon_value: typing.Optional[typing.Any] = 0):
        ''' Item. Displays text and/or icon in the layout

        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon: Icon, Override automatic icon of the item
        :type icon: typing.Optional[typing.Any]
        :param icon_value: Icon Value, Override automatic icon of the item
        :type icon_value: typing.Optional[typing.Any]
        '''
        pass

    def menu(self,
             menu: typing.Union[str, typing.Any],
             text: typing.Union[str, typing.Any] = "",
             text_ctxt: typing.Union[str, typing.Any] = "",
             translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
             icon: typing.Optional[typing.Any] = 'NONE',
             icon_value: typing.Optional[typing.Any] = 0):
        ''' menu

        :param menu: Identifier of the menu
        :type menu: typing.Union[str, typing.Any]
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :param icon: Icon, Override automatic icon of the item
        :type icon: typing.Optional[typing.Any]
        :param icon_value: Icon Value, Override automatic icon of the item
        :type icon_value: typing.Optional[typing.Any]
        '''
        pass

    def separator(self):
        ''' Item. Inserts empty space into the layout between items

        '''
        pass

    def context_pointer_set(self, name: typing.Union[str, typing.Any],
                            data: typing.Optional[typing.Any]):
        ''' context_pointer_set

        :param name: Name, Name of entry in the context
        :type name: typing.Union[str, typing.Any]
        :param data: Pointer to put in context
        :type data: typing.Optional[typing.Any]
        '''
        pass

    def template_header(self):
        ''' Inserts common Space header UI (editor type selector)

        '''
        pass

    def template_ID(self,
                    data: typing.Any,
                    property: typing.Union[str, typing.Any],
                    new: typing.Union[str, typing.Any] = "",
                    open: typing.Union[str, typing.Any] = "",
                    unlink: typing.Union[str, typing.Any] = ""):
        ''' template_ID

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param new: Operator identifier to create a new ID block
        :type new: typing.Union[str, typing.Any]
        :param open: Operator identifier to open a file for creating a new ID block
        :type open: typing.Union[str, typing.Any]
        :param unlink: Operator identifier to unlink the ID block
        :type unlink: typing.Union[str, typing.Any]
        '''
        pass

    def template_ID_preview(self,
                            data: typing.Any,
                            property: typing.Union[str, typing.Any],
                            new: typing.Union[str, typing.Any] = "",
                            open: typing.Union[str, typing.Any] = "",
                            unlink: typing.Union[str, typing.Any] = "",
                            rows: typing.Optional[typing.Any] = 0,
                            cols: typing.Optional[typing.Any] = 0):
        ''' template_ID_preview

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param new: Operator identifier to create a new ID block
        :type new: typing.Union[str, typing.Any]
        :param open: Operator identifier to open a file for creating a new ID block
        :type open: typing.Union[str, typing.Any]
        :param unlink: Operator identifier to unlink the ID block
        :type unlink: typing.Union[str, typing.Any]
        :param rows: Number of thumbnail preview rows to display
        :type rows: typing.Optional[typing.Any]
        :param cols: Number of thumbnail preview columns to display
        :type cols: typing.Optional[typing.Any]
        '''
        pass

    def template_any_ID(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            type_property: typing.Union[str, typing.Any],
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True):
        ''' template_any_ID

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param type_property: Identifier of property in data giving the type of the ID-blocks to use
        :type type_property: typing.Union[str, typing.Any]
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_path_builder(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            root: typing.Optional['ID'],
            text: typing.Union[str, typing.Any] = "",
            text_ctxt: typing.Union[str, typing.Any] = "",
            translate: typing.Optional[typing.Union[bool, typing.Any]] = True):
        ''' template_path_builder

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param root: ID-block from which path is evaluated from
        :type root: typing.Optional['ID']
        :param text: Override automatic text of the item
        :type text: typing.Union[str, typing.Any]
        :param text_ctxt: Override automatic translation context of the given text
        :type text_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given text, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_modifier(self, data: 'Modifier') -> 'UILayout':
        ''' Generates the UI layout for modifiers

        :param data: Modifier data
        :type data: 'Modifier'
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        '''
        pass

    def template_constraint(self, data: 'Constraint') -> 'UILayout':
        ''' Generates the UI layout for constraints

        :param data: Constraint data
        :type data: 'Constraint'
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        '''
        pass

    def template_preview(self,
                         id: typing.Optional['ID'],
                         show_buttons: typing.Optional[
                             typing.Union[bool, typing.Any]] = True,
                         parent: typing.Optional['ID'] = None,
                         slot: typing.Optional['TextureSlot'] = None,
                         preview_id: typing.Union[str, typing.Any] = ""):
        ''' Item. A preview window for materials, textures, lamps or worlds

        :param id: ID data-block
        :type id: typing.Optional['ID']
        :param show_buttons: Show preview buttons?
        :type show_buttons: typing.Optional[typing.Union[bool, typing.Any]]
        :param parent: ID data-block
        :type parent: typing.Optional['ID']
        :param slot: Texture slot
        :type slot: typing.Optional['TextureSlot']
        :param preview_id: Identifier of this preview widget, if not set the ID type will be used (i.e. all previews of materials without explicit ID will have the same size...)
        :type preview_id: typing.Union[str, typing.Any]
        '''
        pass

    def template_curve_mapping(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            type: typing.Optional[typing.Any] = 'NONE',
            levels: typing.Optional[typing.Union[bool, typing.Any]] = False,
            brush: typing.Optional[typing.Union[bool, typing.Any]] = False,
            use_negative_slope: typing.Optional[typing.Union[bool, typing.
                                                             Any]] = False):
        ''' Item. A curve mapping widget used for e.g falloff curves for lamps

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param type: Type, Type of curves to display
        :type type: typing.Optional[typing.Any]
        :param levels: Show black/white levels
        :type levels: typing.Optional[typing.Union[bool, typing.Any]]
        :param brush: Show brush options
        :type brush: typing.Optional[typing.Union[bool, typing.Any]]
        :param use_negative_slope: Use a negative slope by default
        :type use_negative_slope: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_color_ramp(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            expand: typing.Optional[typing.Union[bool, typing.Any]] = False):
        ''' Item. A color ramp widget

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param expand: Expand button to show more detail
        :type expand: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_icon_view(self,
                           data: typing.Any,
                           property: typing.Union[str, typing.Any],
                           show_labels: typing.Optional[
                               typing.Union[bool, typing.Any]] = False,
                           scale: typing.Optional[typing.Any] = 5.0):
        ''' Enum. Large widget showing Icon previews

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param show_labels: Show enum label in preview buttons
        :type show_labels: typing.Optional[typing.Union[bool, typing.Any]]
        :param scale: Scale, Scale the icon size (by the button size)
        :type scale: typing.Optional[typing.Any]
        '''
        pass

    def template_histogram(self, data: typing.Any,
                           property: typing.Union[str, typing.Any]):
        ''' Item. A histogramm widget to analyze imaga data

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        '''
        pass

    def template_waveform(self, data: typing.Any,
                          property: typing.Union[str, typing.Any]):
        ''' Item. A waveform widget to analyze imaga data

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        '''
        pass

    def template_vectorscope(self, data: typing.Any,
                             property: typing.Union[str, typing.Any]):
        ''' Item. A vectorscope widget to analyze imaga data

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        '''
        pass

    def template_layers(self, data: typing.Any,
                        property: typing.Union[str, typing.Any],
                        used_layers_data: typing.Optional[typing.Any],
                        used_layers_property: typing.Union[str, typing.Any],
                        active_layer: typing.Optional[int]):
        ''' template_layers

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param used_layers_data: Data from which to take property
        :type used_layers_data: typing.Optional[typing.Any]
        :param used_layers_property: Identifier of property in data
        :type used_layers_property: typing.Union[str, typing.Any]
        :param active_layer: Active Layer
        :type active_layer: typing.Optional[int]
        '''
        pass

    def template_color_picker(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            value_slider: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = False,
            lock: typing.Optional[typing.Union[bool, typing.Any]] = False,
            lock_luminosity: typing.Optional[typing.Union[bool, typing.
                                                          Any]] = False,
            cubic: typing.Optional[typing.Union[bool, typing.Any]] = False):
        ''' Item. A color wheel widget to pick colors

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param value_slider: Display the value slider to the right of the color wheel
        :type value_slider: typing.Optional[typing.Union[bool, typing.Any]]
        :param lock: Lock the color wheel display to value 1.0 regardless of actual color
        :type lock: typing.Optional[typing.Union[bool, typing.Any]]
        :param lock_luminosity: Keep the color at its original vector length
        :type lock_luminosity: typing.Optional[typing.Union[bool, typing.Any]]
        :param cubic: Cubic saturation for picking values close to white
        :type cubic: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_palette(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            color: typing.Optional[typing.Union[bool, typing.Any]] = False):
        ''' Item. A palette used to pick colors

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param color: Display the colors as colors or values
        :type color: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_image_layers(self, image: typing.Optional['Image'],
                              image_user: typing.Optional['ImageUser']):
        ''' template_image_layers

        :param image: 
        :type image: typing.Optional['Image']
        :param image_user: 
        :type image_user: typing.Optional['ImageUser']
        '''
        pass

    def template_image(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            image_user: 'ImageUser',
            compact: typing.Optional[typing.Union[bool, typing.Any]] = False,
            multiview: typing.Optional[typing.Union[bool, typing.
                                                    Any]] = False):
        ''' Item(s). User interface for selecting images and their source paths

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param image_user: 
        :type image_user: 'ImageUser'
        :param compact: Use more compact layout
        :type compact: typing.Optional[typing.Union[bool, typing.Any]]
        :param multiview: Expose Multi-View options
        :type multiview: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_image_settings(self,
                                image_settings: 'ImageFormatSettings',
                                color_management: typing.Optional[
                                    typing.Union[bool, typing.Any]] = False):
        ''' User interface for setting image format options

        :param image_settings: 
        :type image_settings: 'ImageFormatSettings'
        :param color_management: Show color management settings
        :type color_management: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_image_stereo_3d(self, stereo_3d_format: 'Stereo3dFormat'):
        ''' User interface for setting image stereo 3d options

        :param stereo_3d_format: 
        :type stereo_3d_format: 'Stereo3dFormat'
        '''
        pass

    def template_image_views(self, image_settings: 'ImageFormatSettings'):
        ''' User interface for setting image views output options

        :param image_settings: 
        :type image_settings: 'ImageFormatSettings'
        '''
        pass

    def template_movieclip(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            compact: typing.Optional[typing.Union[bool, typing.Any]] = False):
        ''' Item(s). User interface for selecting movie clips and their source paths

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param compact: Use more compact layout
        :type compact: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_track(self, data: typing.Any,
                       property: typing.Union[str, typing.Any]):
        ''' Item. A movie-track widget to preview tracking image.

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        '''
        pass

    def template_marker(
            self,
            data: typing.Any,
            property: typing.Union[str, typing.Any],
            clip_user: 'MovieClipUser',
            track: 'MovieTrackingTrack',
            compact: typing.Optional[typing.Union[bool, typing.Any]] = False):
        ''' Item. A widget to control single marker settings.

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param clip_user: 
        :type clip_user: 'MovieClipUser'
        :param track: 
        :type track: 'MovieTrackingTrack'
        :param compact: Use more compact layout
        :type compact: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def template_movieclip_information(self, data: typing.Any,
                                       property: typing.Union[str, typing.Any],
                                       clip_user: 'MovieClipUser'):
        ''' Item. Movie clip information data.

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param clip_user: 
        :type clip_user: 'MovieClipUser'
        '''
        pass

    def template_list(self,
                      listtype_name: typing.Union[str, typing.Any],
                      list_id: typing.Union[str, typing.Any] = "",
                      *,
                      dataptr: typing.Optional[typing.Any],
                      propname: typing.Union[str, typing.Any],
                      active_dataptr: typing.Any,
                      active_propname: typing.Union[str, typing.Any],
                      item_dyntip_propname: typing.Union[str, typing.Any] = "",
                      rows: typing.Optional[typing.Any] = 5,
                      maxrows: typing.Optional[typing.Any] = 5,
                      type: typing.Optional[typing.Any] = 'DEFAULT',
                      columns: typing.Optional[typing.Any] = 9):
        ''' Item. A list widget to display data, e.g. vertexgroups.

        :param listtype_name: Identifier of the list type to use
        :type listtype_name: typing.Union[str, typing.Any]
        :param list_id: Identifier of this list widget (mandatory when using default "UI_UL_list" class). If this is set, the uilist gets a custom ID, otherwise it takes the name of the class used to define the uilist (for example, if the class name is "OBJECT_UL_vgroups", and list_id is not set by the script, then bl_idname = "OBJECT_UL_vgroups")
        :type list_id: typing.Union[str, typing.Any]
        :param dataptr: Data from which to take the Collection property
        :type dataptr: typing.Optional[typing.Any]
        :param propname: Identifier of the Collection property in data
        :type propname: typing.Union[str, typing.Any]
        :param active_dataptr: Data from which to take the integer property, index of the active item
        :type active_dataptr: typing.Any
        :param active_propname: Identifier of the integer property in active_data, index of the active item
        :type active_propname: typing.Union[str, typing.Any]
        :param item_dyntip_propname: Identifier of a string property in items, to use as tooltip content
        :type item_dyntip_propname: typing.Union[str, typing.Any]
        :param rows: Default and minimum number of rows to display
        :type rows: typing.Optional[typing.Any]
        :param maxrows: Default maximum number of rows to display
        :type maxrows: typing.Optional[typing.Any]
        :param type: Type, Type of layout to use * ``DEFAULT`` Default Layout, Use the default, multi-rows layout. * ``COMPACT`` Compact Layout, Use the compact, single-row layout. * ``GRID`` Grid Layout, Use the grid-based layout.
        :type type: typing.Optional[typing.Any]
        :param columns: Number of items to display per row, for GRID layout
        :type columns: typing.Optional[typing.Any]
        '''
        pass

    def template_running_jobs(self):
        ''' template_running_jobs

        '''
        pass

    def template_operator_search(self):
        ''' template_operator_search

        '''
        pass

    def template_header_3D(self):
        ''' Inserts common 3DView header UI (selectors for context mode, shading, etc.)

        '''
        pass

    def template_edit_mode_selection(self):
        ''' Inserts common 3DView Edit modes header UI (selector for selection mode)

        '''
        pass

    def template_reports_banner(self):
        ''' template_reports_banner

        '''
        pass

    def template_node_link(self, ntree: typing.Optional['NodeTree'],
                           node: typing.Optional['Node'],
                           socket: typing.Optional['NodeSocket']):
        ''' template_node_link

        :param ntree: 
        :type ntree: typing.Optional['NodeTree']
        :param node: 
        :type node: typing.Optional['Node']
        :param socket: 
        :type socket: typing.Optional['NodeSocket']
        '''
        pass

    def template_node_view(self, ntree: typing.Optional['NodeTree'],
                           node: typing.Optional['Node'],
                           socket: typing.Optional['NodeSocket']):
        ''' template_node_view

        :param ntree: 
        :type ntree: typing.Optional['NodeTree']
        :param node: 
        :type node: typing.Optional['Node']
        :param socket: 
        :type socket: typing.Optional['NodeSocket']
        '''
        pass

    def template_texture_user(self):
        ''' template_texture_user

        '''
        pass

    def template_keymap_item_properties(self, item: 'KeyMapItem'):
        ''' template_keymap_item_properties

        :param item: 
        :type item: 'KeyMapItem'
        '''
        pass

    def template_component_menu(self,
                                data: typing.Optional[typing.Any],
                                property: typing.Union[str, typing.Any],
                                name: typing.Union[str, typing.Any] = ""):
        ''' Item. Display expanded property in a popup menu

        :param data: Data from which to take property
        :type data: typing.Optional[typing.Any]
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param name: 
        :type name: typing.Union[str, typing.Any]
        '''
        pass

    def introspect(self) -> typing.Union[str, typing.Any]:
        ''' introspect

        :rtype: typing.Union[str, typing.Any]
        :return: Descr, DESCR
        '''
        pass

    def template_colorspace_settings(self, data: typing.Any,
                                     property: typing.Union[str, typing.Any]):
        ''' Item. A widget to control input color space settings.

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        '''
        pass

    def template_colormanaged_view_settings(
            self, data: typing.Any, property: typing.Union[str, typing.Any]):
        ''' Item. A widget to control color managed view settings settings.

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        '''
        pass

    def template_node_socket(self,
                             color: typing.Optional[typing.Any] = (0.0, 0.0,
                                                                   0.0, 1.0)):
        ''' Node Socket Icon

        :param color: Color
        :type color: typing.Optional[typing.Any]
        '''
        pass

    def template_cache_file(self, data: typing.Any,
                            property: typing.Union[str, typing.Any]):
        ''' Item(s). User interface for selecting cache files and their source paths

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        '''
        pass


class UIList(bpy_struct):
    ''' UI list containing the elements of a collection
    '''

    bitflag_filter_item: int = None
    ''' The value of the reserved bitflag 'FILTER_ITEM' (in filter_flags values)

    :type: int
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' If this is set, the uilist gets a custom ID, otherwise it takes the name of the class used to define the uilist (for example, if the class name is "OBJECT_UL_vgroups", and bl_idname is not set by the script, then bl_idname = "OBJECT_UL_vgroups")

    :type: typing.Union[str, typing.Any]
    '''

    filter_name: typing.Union[str, typing.Any] = None
    ''' Only show items matching this name (use '*' as wildcard)

    :type: typing.Union[str, typing.Any]
    '''

    layout_type: typing.Union[str, int] = None
    ''' * ``DEFAULT`` Default Layout, Use the default, multi-rows layout. * ``COMPACT`` Compact Layout, Use the compact, single-row layout. * ``GRID`` Grid Layout, Use the grid-based layout.

    :type: typing.Union[str, int]
    '''

    use_filter_invert: bool = None
    ''' Invert filtering (show hidden items, and vice-versa)

    :type: bool
    '''

    use_filter_show: bool = None
    ''' Show filtering options

    :type: bool
    '''

    use_filter_sort_alpha: bool = None
    ''' Sort items by their name

    :type: bool
    '''

    use_filter_sort_reverse: bool = None
    ''' Invert the order of shown items

    :type: bool
    '''

    def draw_item(self,
                  context: typing.Optional['Context'],
                  layout: 'UILayout',
                  data: typing.Optional[typing.Any],
                  item: typing.Optional[typing.Any],
                  icon: typing.Optional[int],
                  active_data: typing.Any,
                  active_property: str,
                  index: typing.Optional[typing.Any] = 0,
                  flt_flag: typing.Optional[typing.Any] = 0):
        ''' Draw an item in the list (NOTE: when you define your own draw_item function, you may want to check given 'item' is of the right type...)

        :param context: 
        :type context: typing.Optional['Context']
        :param layout: Layout to draw the item
        :type layout: 'UILayout'
        :param data: Data from which to take Collection property
        :type data: typing.Optional[typing.Any]
        :param item: Item of the collection property
        :type item: typing.Optional[typing.Any]
        :param icon: Icon of the item in the collection
        :type icon: typing.Optional[int]
        :param active_data: Data from which to take property for the active element
        :type active_data: typing.Any
        :param active_property: Identifier of property in active_data, for the active element
        :type active_property: str
        :param index: Index of the item in the collection
        :type index: typing.Optional[typing.Any]
        :param flt_flag: The filter-flag result for this item
        :type flt_flag: typing.Optional[typing.Any]
        '''
        pass

    def draw_filter(self, context: typing.Optional['Context'],
                    layout: 'UILayout'):
        ''' Draw filtering options

        :param context: 
        :type context: typing.Optional['Context']
        :param layout: Layout to draw the item
        :type layout: 'UILayout'
        '''
        pass

    def filter_items(self, context: typing.Optional['Context'],
                     data: typing.Optional[typing.Any],
                     property: typing.Union[str, typing.Any]):
        ''' Filter and/or re-order items of the collection (output filter results in filter_flags, and reorder results in filter_neworder arrays)

        :param context: 
        :type context: typing.Optional['Context']
        :param data: Data from which to take Collection property
        :type data: typing.Optional[typing.Any]
        :param property: Identifier of property in data, for the collection
        :type property: typing.Union[str, typing.Any]
        '''
        pass


class UIPieMenu(bpy_struct):
    layout: 'UILayout' = None
    ''' 

    :type: 'UILayout'
    '''


class UIPopupMenu(bpy_struct):
    layout: 'UILayout' = None
    ''' 

    :type: 'UILayout'
    '''


class UVProjector(bpy_struct):
    ''' UV projector used by the UV project modifier
    '''

    object: 'Object' = None
    ''' Object to use as projector transform

    :type: 'Object'
    '''


class UnifiedPaintSettings(bpy_struct):
    ''' Overrides for some of the active brush's settings
    '''

    color: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    secondary_color: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    size: int = None
    ''' Radius of the brush

    :type: int
    '''

    strength: float = None
    ''' How powerful the effect of the brush is when applied

    :type: float
    '''

    unprojected_radius: float = None
    ''' Radius of brush in Blender units

    :type: float
    '''

    use_locked_size: bool = None
    ''' When locked brush stays same size relative to object; when unlocked brush size is given in pixels

    :type: bool
    '''

    use_pressure_size: bool = None
    ''' Enable tablet pressure sensitivity for size

    :type: bool
    '''

    use_pressure_strength: bool = None
    ''' Enable tablet pressure sensitivity for strength

    :type: bool
    '''

    use_unified_color: bool = None
    ''' Instead of per-brush color, the color is shared across brushes

    :type: bool
    '''

    use_unified_size: bool = None
    ''' Instead of per-brush radius, the radius is shared across brushes

    :type: bool
    '''

    use_unified_strength: bool = None
    ''' Instead of per-brush strength, the strength is shared across brushes

    :type: bool
    '''

    use_unified_weight: bool = None
    ''' Instead of per-brush weight, the weight is shared across brushes

    :type: bool
    '''

    weight: float = None
    ''' Weight to assign in vertex groups

    :type: float
    '''


class UnitSettings(bpy_struct):
    scale_length: float = None
    ''' Scale to use when converting between blender units and dimensions

    :type: float
    '''

    system: typing.Union[str, int] = None
    ''' The unit system to use for button display

    :type: typing.Union[str, int]
    '''

    system_rotation: typing.Union[str, int] = None
    ''' Unit to use for displaying/editing rotation values * ``DEGREES`` Degrees, Use degrees for measuring angles and rotations. * ``RADIANS`` Radians.

    :type: typing.Union[str, int]
    '''

    use_separate: bool = None
    ''' Display units in pairs (e.g. 1m 0cm)

    :type: bool
    '''


class UnknownType(bpy_struct):
    ''' Stub RNA type used for pointers to unknown or internal data
    '''

    pass


class UserPreferences(bpy_struct):
    ''' Global user preferences
    '''

    active_section: typing.Union[str, int] = None
    ''' Active section of the user preferences shown in the user interface

    :type: typing.Union[str, int]
    '''

    addons: 'Addons' = None
    ''' 

    :type: 'Addons'
    '''

    autoexec_paths: 'PathCompareCollection' = None
    ''' 

    :type: 'PathCompareCollection'
    '''

    edit: 'UserPreferencesEdit' = None
    ''' Settings for interacting with Blender data

    :type: 'UserPreferencesEdit'
    '''

    filepaths: 'UserPreferencesFilePaths' = None
    ''' Default paths for external files

    :type: 'UserPreferencesFilePaths'
    '''

    inputs: 'UserPreferencesInput' = None
    ''' Settings for input devices

    :type: 'UserPreferencesInput'
    '''

    system: 'UserPreferencesSystem' = None
    ''' Graphics driver and operating system settings

    :type: 'UserPreferencesSystem'
    '''

    themes: bpy_prop_collection['Theme'] = None
    ''' 

    :type: bpy_prop_collection['Theme']
    '''

    ui_styles: bpy_prop_collection['ThemeStyle'] = None
    ''' 

    :type: bpy_prop_collection['ThemeStyle']
    '''

    version: bpy_prop_array[int] = None
    ''' Version of Blender the userpref.blend was saved with

    :type: bpy_prop_array[int]
    '''

    view: 'UserPreferencesView' = None
    ''' Preferences related to viewing data

    :type: 'UserPreferencesView'
    '''


class UserPreferencesEdit(bpy_struct):
    ''' Settings for interacting with Blender data
    '''

    auto_keying_mode: typing.Union[str, int] = None
    ''' Mode of automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: typing.Union[str, int]
    '''

    fcurve_unselected_alpha: float = None
    ''' Amount that unselected F-Curves stand out from the background (Graph Editor)

    :type: float
    '''

    grease_pencil_default_color: bpy_prop_array[float] = None
    ''' Color of new Grease Pencil layers

    :type: bpy_prop_array[float]
    '''

    grease_pencil_eraser_radius: int = None
    ''' Radius of eraser 'brush'

    :type: int
    '''

    grease_pencil_euclidean_distance: int = None
    ''' Distance moved by mouse when drawing stroke to include

    :type: int
    '''

    grease_pencil_manhattan_distance: int = None
    ''' Pixels moved by mouse per axis when drawing stroke

    :type: int
    '''

    keyframe_new_handle_type: typing.Union[str, int] = None
    ''' Handle type for handles of new keyframes * ``FREE`` Free. * ``VECTOR`` Vector. * ``ALIGNED`` Aligned. * ``AUTO`` Automatic. * ``AUTO_CLAMPED`` Auto Clamped, Auto handles clamped to not overshoot.

    :type: typing.Union[str, int]
    '''

    keyframe_new_interpolation_type: typing.Union[str, int] = None
    ''' Interpolation mode used for first keyframe on newly added F-Curves (subsequent keyframes take interpolation from preceding keyframe) * ``CONSTANT`` Constant, No interpolation, value of A gets held until B is encountered. * ``LINEAR`` Linear, Straight-line interpolation between A and B (i.e. no ease in/out). * ``BEZIER`` Bezier, Smooth interpolation between A and B, with some control over curve shape. * ``SINE`` Sinusoidal, Sinusoidal easing (weakest, almost linear but with a slight curvature). * ``QUAD`` Quadratic, Quadratic easing. * ``CUBIC`` Cubic, Cubic easing. * ``QUART`` Quartic, Quartic easing. * ``QUINT`` Quintic, Quintic easing. * ``EXPO`` Exponential, Exponential easing (dramatic). * ``CIRC`` Circular, Circular easing (strongest and most dynamic). * ``BACK`` Back, Cubic easing with overshoot and settle. * ``BOUNCE`` Bounce, Exponentially decaying parabolic bounce, like when objects collide. * ``ELASTIC`` Elastic, Exponentially decaying sine wave, like an elastic band.

    :type: typing.Union[str, int]
    '''

    material_link: typing.Union[str, int] = None
    ''' Toggle whether the material is linked to object data or the object block * ``OBDATA`` ObData, Toggle whether the material is linked to object data or the object block. * ``OBJECT`` Object, Toggle whether the material is linked to object data or the object block.

    :type: typing.Union[str, int]
    '''

    node_margin: int = None
    ''' Minimum distance between nodes for Auto-offsetting nodes

    :type: int
    '''

    object_align: typing.Union[str, int] = None
    ''' When adding objects from a 3D View menu, either align them with that view or with the world * ``WORLD`` World, Align newly added objects to the world coordinate system. * ``VIEW`` View, Align newly added objects facing the active 3D View direction.

    :type: typing.Union[str, int]
    '''

    sculpt_paint_overlay_color: bpy_prop_array[float] = None
    ''' Color of texture overlay

    :type: bpy_prop_array[float]
    '''

    undo_memory_limit: int = None
    ''' Maximum memory usage in megabytes (0 means unlimited)

    :type: int
    '''

    undo_steps: int = None
    ''' Number of undo steps available (smaller values conserve memory)

    :type: int
    '''

    use_auto_keying: bool = None
    ''' Automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: bool
    '''

    use_auto_keying_warning: bool = None
    ''' Show warning indicators when transforming objects and bones if auto keying is enabled

    :type: bool
    '''

    use_drag_immediately: bool = None
    ''' Moving things with a mouse drag confirms when releasing the button

    :type: bool
    '''

    use_duplicate_action: bool = None
    ''' Causes actions to be duplicated with the object

    :type: bool
    '''

    use_duplicate_armature: bool = None
    ''' Causes armature data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_curve: bool = None
    ''' Causes curve data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_fcurve: bool = None
    ''' Causes F-curve data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_lamp: bool = None
    ''' Causes lamp data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_material: bool = None
    ''' Causes material data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_mesh: bool = None
    ''' Causes mesh data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_metaball: bool = None
    ''' Causes metaball data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_particle: bool = None
    ''' Causes particle systems to be duplicated with the object

    :type: bool
    '''

    use_duplicate_surface: bool = None
    ''' Causes surface data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_text: bool = None
    ''' Causes text data to be duplicated with the object

    :type: bool
    '''

    use_duplicate_texture: bool = None
    ''' Causes texture data to be duplicated with the object

    :type: bool
    '''

    use_enter_edit_mode: bool = None
    ''' Enter Edit Mode automatically after adding a new object

    :type: bool
    '''

    use_global_undo: bool = None
    ''' Global undo works by keeping a full copy of the file itself in memory, so takes extra memory

    :type: bool
    '''

    use_grease_pencil_simplify_stroke: bool = None
    ''' Simplify the final stroke

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    ''' Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis

    :type: bool
    '''

    use_keyframe_insert_available: bool = None
    ''' Automatic keyframe insertion in available F-Curves

    :type: bool
    '''

    use_keyframe_insert_needed: bool = None
    ''' Keyframe insertion only when keyframe needed

    :type: bool
    '''

    use_negative_frames: bool = None
    ''' Current frame number can be manually set to a negative value

    :type: bool
    '''

    use_visual_keying: bool = None
    ''' Use Visual keying automatically for constrained objects

    :type: bool
    '''


class UserPreferencesFilePaths(bpy_struct):
    ''' Default paths for external files
    '''

    animation_player: typing.Union[str, typing.Any] = None
    ''' Path to a custom animation/frame sequence player

    :type: typing.Union[str, typing.Any]
    '''

    animation_player_preset: typing.Union[str, int] = None
    ''' Preset configs for external animation players * ``INTERNAL`` Internal, Built-in animation player. * ``DJV`` Djv, Open source frame player: http://djv.sourceforge.net. * ``FRAMECYCLER`` FrameCycler, Frame player from IRIDAS. * ``RV`` rv, Frame player from Tweak Software. * ``MPLAYER`` MPlayer, Media player for video & png/jpeg/sgi image sequences. * ``CUSTOM`` Custom, Custom animation player executable path.

    :type: typing.Union[str, int]
    '''

    auto_save_time: int = None
    ''' The time (in minutes) to wait between automatic temporary saves

    :type: int
    '''

    font_directory: typing.Union[str, typing.Any] = None
    ''' The default directory to search for loading fonts

    :type: typing.Union[str, typing.Any]
    '''

    hide_recent_locations: bool = None
    ''' Hide recent locations in the file selector

    :type: bool
    '''

    hide_system_bookmarks: bool = None
    ''' Hide system bookmarks in the file selector

    :type: bool
    '''

    i18n_branches_directory: typing.Union[str, typing.Any] = None
    ''' The path to the '/branches' directory of your local svn-translation copy, to allow translating from the UI

    :type: typing.Union[str, typing.Any]
    '''

    image_editor: typing.Union[str, typing.Any] = None
    ''' Path to an image editor

    :type: typing.Union[str, typing.Any]
    '''

    recent_files: int = None
    ''' Maximum number of recently opened files to remember

    :type: int
    '''

    render_cache_directory: typing.Union[str, typing.Any] = None
    ''' Where to cache raw render results

    :type: typing.Union[str, typing.Any]
    '''

    render_output_directory: typing.Union[str, typing.Any] = None
    ''' The default directory for rendering output, for new scenes

    :type: typing.Union[str, typing.Any]
    '''

    save_version: int = None
    ''' The number of old versions to maintain in the current directory, when manually saving

    :type: int
    '''

    script_directory: typing.Union[str, typing.Any] = None
    ''' Alternate script path, matching the default layout with subdirs: startup, add-ons & modules (requires restart)

    :type: typing.Union[str, typing.Any]
    '''

    show_hidden_files_datablocks: bool = None
    ''' Hide files/data-blocks that start with a dot (.*)

    :type: bool
    '''

    show_thumbnails: bool = None
    ''' Open in thumbnail view for images and movies

    :type: bool
    '''

    sound_directory: typing.Union[str, typing.Any] = None
    ''' The default directory to search for sounds

    :type: typing.Union[str, typing.Any]
    '''

    temporary_directory: typing.Union[str, typing.Any] = None
    ''' The directory for storing temporary save files

    :type: typing.Union[str, typing.Any]
    '''

    texture_directory: typing.Union[str, typing.Any] = None
    ''' The default directory to search for textures

    :type: typing.Union[str, typing.Any]
    '''

    use_auto_save_temporary_files: bool = None
    ''' Automatic saving of temporary files in temp directory, uses process ID (Sculpt or edit mode data won't be saved!')

    :type: bool
    '''

    use_file_compression: bool = None
    ''' Enable file compression when saving .blend files

    :type: bool
    '''

    use_filter_files: bool = None
    ''' Display only files with extensions in the image select window

    :type: bool
    '''

    use_keep_session: bool = None
    ''' Always load session recovery and save it after quitting Blender

    :type: bool
    '''

    use_load_ui: bool = None
    ''' Load user interface setup when loading .blend files

    :type: bool
    '''

    use_relative_paths: bool = None
    ''' Default relative path option for the file selector

    :type: bool
    '''

    use_save_preview_images: bool = None
    ''' Enables automatic saving of preview images in the .blend file

    :type: bool
    '''


class UserPreferencesInput(bpy_struct):
    ''' Settings for input devices
    '''

    active_keyconfig: typing.Union[str, typing.Any] = None
    ''' The name of the active key configuration

    :type: typing.Union[str, typing.Any]
    '''

    drag_threshold: int = None
    ''' Amount of pixels you have to drag before dragging UI items happens

    :type: int
    '''

    invert_mouse_zoom: bool = None
    ''' Invert the axis of mouse movement for zooming

    :type: bool
    '''

    invert_zoom_wheel: bool = None
    ''' Swap the Mouse Wheel zoom direction

    :type: bool
    '''

    mouse_double_click_time: int = None
    ''' Time/delay (in ms) for a double click

    :type: int
    '''

    navigation_mode: typing.Union[str, int] = None
    ''' Which method to use for viewport navigation * ``WALK`` Walk, Interactively walk or free navigate around the scene. * ``FLY`` Fly, Use fly dynamics to navigate the scene.

    :type: typing.Union[str, int]
    '''

    ndof_deadzone: float = None
    ''' Deadzone of the 3D Mouse

    :type: float
    '''

    ndof_fly_helicopter: bool = None
    ''' Device up/down directly controls your Z position

    :type: bool
    '''

    ndof_lock_horizon: bool = None
    ''' Keep horizon level while flying with 3D Mouse

    :type: bool
    '''

    ndof_orbit_sensitivity: float = None
    ''' Overall sensitivity of the 3D Mouse for orbiting

    :type: float
    '''

    ndof_pan_yz_swap_axis: bool = None
    ''' Pan using up/down on the device (otherwise forward/backward)

    :type: bool
    '''

    ndof_panx_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_pany_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_panz_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_rotx_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_roty_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_rotz_invert_axis: bool = None
    ''' 

    :type: bool
    '''

    ndof_sensitivity: float = None
    ''' Overall sensitivity of the 3D Mouse for panning

    :type: float
    '''

    ndof_show_guide: bool = None
    ''' Display the center and axis during rotation

    :type: bool
    '''

    ndof_view_navigate_method: typing.Union[str, int] = None
    ''' Navigation style in the viewport * ``FREE`` Free, Use full 6 degrees of freedom by default. * ``ORBIT`` Orbit, Orbit about the view center by default.

    :type: typing.Union[str, int]
    '''

    ndof_view_rotate_method: typing.Union[str, int] = None
    ''' Rotation style in the viewport * ``TURNTABLE`` Turntable, Use turntable style rotation in the viewport. * ``TRACKBALL`` Trackball, Use trackball style rotation in the viewport.

    :type: typing.Union[str, int]
    '''

    ndof_zoom_invert: bool = None
    ''' Zoom using opposite direction

    :type: bool
    '''

    select_mouse: typing.Union[str, int] = None
    ''' Mouse button used for selection * ``LEFT`` Left, Use left Mouse Button for selection. * ``RIGHT`` Right, Use Right Mouse Button for selection.

    :type: typing.Union[str, int]
    '''

    tweak_threshold: int = None
    ''' Number of pixels you have to drag before tweak event is triggered

    :type: int
    '''

    use_emulate_numpad: bool = None
    ''' Main 1 to 0 keys act as the numpad ones (useful for laptops)

    :type: bool
    '''

    use_mouse_continuous: bool = None
    ''' Allow moving the mouse outside the view on some manipulations (transform, ui control drag)

    :type: bool
    '''

    use_mouse_emulate_3_button: bool = None
    ''' Emulate Middle Mouse with Alt+Left Mouse (doesn't work with Left Mouse Select option)

    :type: bool
    '''

    use_mouse_mmb_paste: bool = None
    ''' In text window, paste with middle mouse button instead of panning

    :type: bool
    '''

    use_ndof: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    use_trackpad_natural: bool = None
    ''' If your system uses 'natural' scrolling, this option keeps consistent trackpad usage throughout the UI

    :type: bool
    '''

    view_rotate_method: typing.Union[str, int] = None
    ''' Rotation style in the viewport * ``TURNTABLE`` Turntable, Use turntable style rotation in the viewport. * ``TRACKBALL`` Trackball, Use trackball style rotation in the viewport.

    :type: typing.Union[str, int]
    '''

    view_zoom_axis: typing.Union[str, int] = None
    ''' Axis of mouse movement to zoom in or out on * ``VERTICAL`` Vertical, Zoom in and out based on vertical mouse movement. * ``HORIZONTAL`` Horizontal, Zoom in and out based on horizontal mouse movement.

    :type: typing.Union[str, int]
    '''

    view_zoom_method: typing.Union[str, int] = None
    ''' Which style to use for viewport scaling * ``CONTINUE`` Continue, Old style zoom, continues while moving mouse up or down. * ``DOLLY`` Dolly, Zoom in and out based on vertical mouse movement. * ``SCALE`` Scale, Zoom in and out like scaling the view, mouse movements relative to center.

    :type: typing.Union[str, int]
    '''

    walk_navigation: 'WalkNavigation' = None
    ''' Settings for walk navigation mode

    :type: 'WalkNavigation'
    '''

    wheel_scroll_lines: int = None
    ''' Number of lines scrolled at a time with the mouse wheel

    :type: int
    '''


class UserPreferencesSystem(bpy_struct):
    ''' Graphics driver and operating system settings
    '''

    anisotropic_filter: typing.Union[str, int] = None
    ''' Quality of the anisotropic filtering (values greater than 1.0 enable anisotropic filtering)

    :type: typing.Union[str, int]
    '''

    audio_channels: typing.Union[str, int] = None
    ''' Audio channel count * ``MONO`` Mono, Set audio channels to mono. * ``STEREO`` Stereo, Set audio channels to stereo. * ``SURROUND4`` 4 Channels, Set audio channels to 4 channels. * ``SURROUND51`` 5.1 Surround, Set audio channels to 5.1 surround sound. * ``SURROUND71`` 7.1 Surround, Set audio channels to 7.1 surround sound.

    :type: typing.Union[str, int]
    '''

    audio_device: typing.Union[str, int] = None
    ''' Audio output device * ``NONE`` None, Null device - there will be no audio output. * ``SDL`` SDL, SDL device - simple direct media layer, recommended for sequencer usage. * ``OPENAL`` OpenAL, OpenAL device - supports 3D audio, recommended for game engine usage. * ``JACK`` Jack, JACK - Audio Connection Kit, recommended for pro audio users.

    :type: typing.Union[str, int]
    '''

    audio_mixing_buffer: typing.Union[str, int] = None
    ''' Number of samples used by the audio mixing buffer * ``SAMPLES_256`` 256, Set audio mixing buffer size to 256 samples. * ``SAMPLES_512`` 512, Set audio mixing buffer size to 512 samples. * ``SAMPLES_1024`` 1024, Set audio mixing buffer size to 1024 samples. * ``SAMPLES_2048`` 2048, Set audio mixing buffer size to 2048 samples. * ``SAMPLES_4096`` 4096, Set audio mixing buffer size to 4096 samples. * ``SAMPLES_8192`` 8192, Set audio mixing buffer size to 8192 samples. * ``SAMPLES_16384`` 16384, Set audio mixing buffer size to 16384 samples. * ``SAMPLES_32768`` 32768, Set audio mixing buffer size to 32768 samples.

    :type: typing.Union[str, int]
    '''

    audio_sample_format: typing.Union[str, int] = None
    ''' Audio sample format * ``U8`` 8-bit Unsigned, Set audio sample format to 8 bit unsigned integer. * ``S16`` 16-bit Signed, Set audio sample format to 16 bit signed integer. * ``S24`` 24-bit Signed, Set audio sample format to 24 bit signed integer. * ``S32`` 32-bit Signed, Set audio sample format to 32 bit signed integer. * ``FLOAT`` 32-bit Float, Set audio sample format to 32 bit float. * ``DOUBLE`` 64-bit Float, Set audio sample format to 64 bit float.

    :type: typing.Union[str, int]
    '''

    audio_sample_rate: typing.Union[str, int] = None
    ''' Audio sample rate * ``RATE_44100`` 44.1 kHz, Set audio sampling rate to 44100 samples per second. * ``RATE_48000`` 48 kHz, Set audio sampling rate to 48000 samples per second. * ``RATE_96000`` 96 kHz, Set audio sampling rate to 96000 samples per second. * ``RATE_192000`` 192 kHz, Set audio sampling rate to 192000 samples per second.

    :type: typing.Union[str, int]
    '''

    author: typing.Union[str, typing.Any] = None
    ''' Name that will be used in exported files when format supports such feature

    :type: typing.Union[str, typing.Any]
    '''

    color_picker_type: typing.Union[str, int] = None
    ''' Different styles of displaying the color picker widget * ``CIRCLE_HSV`` Circle (HSV), A circular Hue/Saturation color wheel, with Value slider. * ``CIRCLE_HSL`` Circle (HSL), A circular Hue/Saturation color wheel, with Lightness slider. * ``SQUARE_SV`` Square (SV + H), A square showing Saturation/Value, with Hue slider. * ``SQUARE_HS`` Square (HS + V), A square showing Hue/Saturation, with Value slider. * ``SQUARE_HV`` Square (HV + S), A square showing Hue/Value, with Saturation slider.

    :type: typing.Union[str, int]
    '''

    dpi: int = None
    ''' Font size and resolution for display

    :type: int
    '''

    font_path_ui: typing.Union[str, typing.Any] = None
    ''' Path to interface font

    :type: typing.Union[str, typing.Any]
    '''

    font_path_ui_mono: typing.Union[str, typing.Any] = None
    ''' Path to interface mono-space Font

    :type: typing.Union[str, typing.Any]
    '''

    frame_server_port: int = None
    ''' Frameserver Port for Frameserver Rendering

    :type: int
    '''

    gl_clip_alpha: float = None
    ''' Clip alpha below this threshold in the 3D textured view

    :type: float
    '''

    gl_texture_limit: typing.Union[str, int] = None
    ''' Limit the texture size to save graphics memory

    :type: typing.Union[str, int]
    '''

    image_draw_method: typing.Union[str, int] = None
    ''' Method used for displaying images on the screen * ``2DTEXTURE`` 2D Texture, Use CPU for display transform and draw image with 2D texture. * ``GLSL`` GLSL, Use GLSL shaders for display transform and draw image with 2D texture. * ``DRAWPIXELS`` DrawPixels, Use CPU for display transform and draw image using DrawPixels.

    :type: typing.Union[str, int]
    '''

    legacy_compute_device_type: int = None
    ''' For backwards compatibility only

    :type: int
    '''

    memory_cache_limit: int = None
    ''' Memory cache limit (in megabytes)

    :type: int
    '''

    multi_sample: typing.Union[str, int] = None
    ''' Enable OpenGL multi-sampling, only for systems that support it, requires restart * ``NONE`` No MultiSample, Do not use OpenGL MultiSample. * ``2`` MultiSample: 2, Use 2x OpenGL MultiSample (requires restart). * ``4`` MultiSample: 4, Use 4x OpenGL MultiSample (requires restart). * ``8`` MultiSample: 8, Use 8x OpenGL MultiSample (requires restart). * ``16`` MultiSample: 16, Use 16x OpenGL MultiSample (requires restart).

    :type: typing.Union[str, int]
    '''

    opensubdiv_compute_type: typing.Union[str, int] = None
    ''' Type of computer back-end used with OpenSubdiv

    :type: typing.Union[str, int]
    '''

    pixel_size: float = None
    ''' 

    :type: float
    '''

    prefetch_frames: int = None
    ''' Number of frames to render ahead during playback (sequencer only)

    :type: int
    '''

    screencast_fps: int = None
    ''' Frame rate for the screencast to be played back

    :type: int
    '''

    screencast_wait_time: int = None
    ''' Time in milliseconds between each frame recorded for screencast

    :type: int
    '''

    scrollback: int = None
    ''' Maximum number of lines to store for the console buffer

    :type: int
    '''

    select_method: typing.Union[str, int] = None
    ''' Use OpenGL occlusion queries or selection render mode to accelerate selection

    :type: typing.Union[str, int]
    '''

    solid_lights: bpy_prop_collection['UserSolidLight'] = None
    ''' Lights user to display objects in solid draw mode

    :type: bpy_prop_collection['UserSolidLight']
    '''

    texture_collection_rate: int = None
    ''' Number of seconds between each run of the GL texture garbage collector

    :type: int
    '''

    texture_time_out: int = None
    ''' Time since last access of a GL texture in seconds after which it is freed (set to 0 to keep textures allocated)

    :type: int
    '''

    use_16bit_textures: bool = None
    ''' Use 16 bit per component texture for float images

    :type: bool
    '''

    use_gpu_mipmap: bool = None
    ''' Generate Image Mipmaps on the GPU

    :type: bool
    '''

    use_international_fonts: bool = None
    ''' Use international fonts

    :type: bool
    '''

    use_mipmaps: bool = None
    ''' Scale textures for the 3D View (looks nicer but uses more memory and slows image reloading)

    :type: bool
    '''

    use_preview_images: bool = None
    ''' Allow user to choose any codec (Windows only, might generate instability)

    :type: bool
    '''

    use_region_overlap: bool = None
    ''' Draw tool/property regions over the main region, when using Triple Buffer

    :type: bool
    '''

    use_scripts_auto_execute: bool = None
    ''' Allow any .blend file to run scripts automatically (unsafe with blend files from an untrusted source)

    :type: bool
    '''

    use_tabs_as_spaces: bool = None
    ''' Automatically convert all new tabs into spaces for new and loaded text files

    :type: bool
    '''

    use_text_antialiasing: bool = None
    ''' Draw user interface text anti-aliased

    :type: bool
    '''

    use_textured_fonts: bool = None
    ''' Use textures for drawing international fonts

    :type: bool
    '''

    use_translate_interface: bool = None
    ''' Translate interface

    :type: bool
    '''

    use_translate_new_dataname: bool = None
    ''' Translate new data names (when adding/creating some)

    :type: bool
    '''

    use_translate_tooltips: bool = None
    ''' Translate tooltips

    :type: bool
    '''

    use_weight_color_range: bool = None
    ''' Enable color range used for weight visualization in weight painting mode

    :type: bool
    '''

    virtual_pixel_mode: typing.Union[str, int] = None
    ''' Modify the pixel size for hi-res devices * ``NATIVE`` Native, Use native pixel size of the display. * ``DOUBLE`` Double, Use double the native pixel size of the display.

    :type: typing.Union[str, int]
    '''

    weight_color_range: 'ColorRamp' = None
    ''' Color range used for weight visualization in weight painting mode

    :type: 'ColorRamp'
    '''

    window_draw_method: typing.Union[str, int] = None
    ''' Drawing method used by the window manager * ``AUTOMATIC`` Automatic, Automatically set based on graphics card and driver. * ``TRIPLE_BUFFER`` Triple Buffer, Use a third buffer for minimal redraws at the cost of more memory. * ``OVERLAP`` Overlap, Redraw all overlapping regions, minimal memory usage but more redraws. * ``OVERLAP_FLIP`` Overlap Flip, Redraw all overlapping regions, minimal memory usage but more redraws (for graphics drivers that do flipping). * ``FULL`` Full, Do a full redraw each time, slow, only use for reference or when everything else fails.

    :type: typing.Union[str, int]
    '''


class UserPreferencesView(bpy_struct):
    ''' Preferences related to viewing data
    '''

    manipulator_handle_size: int = None
    ''' Size of manipulator handles as percentage of the radius

    :type: int
    '''

    manipulator_hotspot: int = None
    ''' Distance around the handles to accept mouse clicks

    :type: int
    '''

    manipulator_size: int = None
    ''' Diameter of the manipulator

    :type: int
    '''

    mini_axis_brightness: int = None
    ''' Brightness of the icon

    :type: int
    '''

    mini_axis_size: int = None
    ''' The axes icon's size

    :type: int
    '''

    object_origin_size: int = None
    ''' Diameter in Pixels for Object/Lamp origin display

    :type: int
    '''

    open_left_mouse_delay: int = None
    ''' Time in 1/10 seconds to hold the Left Mouse Button before opening the toolbox

    :type: int
    '''

    open_right_mouse_delay: int = None
    ''' Time in 1/10 seconds to hold the Right Mouse Button before opening the toolbox

    :type: int
    '''

    open_sublevel_delay: int = None
    ''' Time delay in 1/10 seconds before automatically opening sub level menus

    :type: int
    '''

    open_toplevel_delay: int = None
    ''' Time delay in 1/10 seconds before automatically opening top level menus

    :type: int
    '''

    pie_animation_timeout: int = None
    ''' Time needed to fully animate the pie to unfolded state (in 1/100ths of sec)

    :type: int
    '''

    pie_initial_timeout: int = None
    ''' Pie menus will use the initial mouse position as center for this amount of time (in 1/100ths of sec)

    :type: int
    '''

    pie_menu_confirm: int = None
    ''' Distance threshold after which selection is made (zero to disable)

    :type: int
    '''

    pie_menu_radius: int = None
    ''' Pie menu size in pixels

    :type: int
    '''

    pie_menu_threshold: int = None
    ''' Distance from center needed before a selection can be made

    :type: int
    '''

    rotation_angle: float = None
    ''' Rotation step for numerical pad keys (2 4 6 8)

    :type: float
    '''

    show_column_layout: bool = None
    ''' Use a column layout for toolbox

    :type: bool
    '''

    show_large_cursors: bool = None
    ''' Use large mouse cursors when available

    :type: bool
    '''

    show_manipulator: bool = None
    ''' Use 3D transform manipulator

    :type: bool
    '''

    show_mini_axis: bool = None
    ''' Show a small rotating 3D axes in the bottom left corner of the 3D View

    :type: bool
    '''

    show_object_info: bool = None
    ''' Display objects name and frame number in 3D view

    :type: bool
    '''

    show_playback_fps: bool = None
    ''' Show the frames per second screen refresh rate, while animation is played back

    :type: bool
    '''

    show_splash: bool = None
    ''' Display splash screen on startup

    :type: bool
    '''

    show_tooltips: bool = None
    ''' Display tooltips (when off hold Alt to force display)

    :type: bool
    '''

    show_tooltips_python: bool = None
    ''' Show Python references in tooltips

    :type: bool
    '''

    show_view_name: bool = None
    ''' Show the name of the view's direction in each 3D View

    :type: bool
    '''

    smooth_view: int = None
    ''' Time to animate the view in milliseconds, zero to disable

    :type: int
    '''

    timecode_style: typing.Union[str, int] = None
    ''' Format of Time Codes displayed when not displaying timing in terms of frames * ``MINIMAL`` Minimal Info, Most compact representation, uses '+' as separator for sub-second frame numbers, with left and right truncation of the timecode as necessary. * ``SMPTE`` SMPTE (Full), Full SMPTE timecode (format is HH:MM:SS:FF). * ``SMPTE_COMPACT`` SMPTE (Compact), SMPTE timecode showing minutes, seconds, and frames only - hours are also shown if necessary, but not by default. * ``MILLISECONDS`` Compact with Milliseconds, Similar to SMPTE (Compact), except that instead of frames, milliseconds are shown instead. * ``SECONDS_ONLY`` Only Seconds, Direct conversion of frame numbers to seconds.

    :type: typing.Union[str, int]
    '''

    use_auto_perspective: bool = None
    ''' Automatically switch between orthographic and perspective when changing from top/front/side views

    :type: bool
    '''

    use_camera_lock_parent: bool = None
    ''' When the camera is locked to the view and in fly mode, transform the parent rather than the camera

    :type: bool
    '''

    use_directional_menus: bool = None
    ''' Otherwise menus, etc will always be top to bottom, left to right, no matter opening direction

    :type: bool
    '''

    use_global_pivot: bool = None
    ''' Lock the same rotation/scaling pivot in all 3D Views

    :type: bool
    '''

    use_global_scene: bool = None
    ''' Force the current Scene to be displayed in all Screens

    :type: bool
    '''

    use_mouse_depth_cursor: bool = None
    ''' Use the depth under the mouse when placing the cursor

    :type: bool
    '''

    use_mouse_depth_navigate: bool = None
    ''' Use the depth under the mouse to improve view pan/rotate/zoom functionality

    :type: bool
    '''

    use_mouse_over_open: bool = None
    ''' Open menu buttons and pulldowns automatically when the mouse is hovering

    :type: bool
    '''

    use_quit_dialog: bool = None
    ''' Ask for confirmation when quitting through the window close button

    :type: bool
    '''

    use_rotate_around_active: bool = None
    ''' Use selection as the pivot point

    :type: bool
    '''

    use_zoom_to_mouse: bool = None
    ''' Zoom in towards the mouse pointer's position in the 3D view, rather than the 2D window center

    :type: bool
    '''

    view2d_grid_spacing_min: int = None
    ''' Minimum number of pixels between each gridline in 2D Viewports

    :type: int
    '''

    view_frame_keyframes: int = None
    ''' Keyframes around cursor that we zoom around

    :type: int
    '''

    view_frame_seconds: float = None
    ''' Seconds around cursor that we zoom around

    :type: float
    '''

    view_frame_type: typing.Union[str, int] = None
    ''' How zooming to frame focuses around current frame

    :type: typing.Union[str, int]
    '''


class UserSolidLight(bpy_struct):
    ''' Light used for OpenGL lighting in solid draw mode
    '''

    diffuse_color: bpy_prop_array[float] = None
    ''' Diffuse color of the OpenGL light

    :type: bpy_prop_array[float]
    '''

    direction: bpy_prop_array[float] = None
    ''' Direction that the OpenGL light is shining

    :type: bpy_prop_array[float]
    '''

    specular_color: bpy_prop_array[float] = None
    ''' Color of the light's specular highlight

    :type: bpy_prop_array[float]
    '''

    use: bool = None
    ''' Enable this OpenGL light in solid draw mode

    :type: bool
    '''


class VertexGroup(bpy_struct):
    ''' Group of vertices, used for armature deform and other purposes
    '''

    index: int = None
    ''' Index number of the vertex group

    :type: int
    '''

    lock_weight: bool = None
    ''' Maintain the relative weights for the group

    :type: bool
    '''

    name: typing.Union[str, typing.Any] = None
    ''' Vertex group name

    :type: typing.Union[str, typing.Any]
    '''

    def add(self, index: typing.Optional[typing.Iterable[int]],
            weight: typing.Optional[float],
            type: typing.Optional[typing.Union[str, int]]):
        ''' Add vertices to the group

        :param index: Index List
        :type index: typing.Optional[typing.Iterable[int]]
        :param weight: Vertex weight
        :type weight: typing.Optional[float]
        :param type: Vertex assign mode * ``REPLACE`` Replace, Replace. * ``ADD`` Add, Add. * ``SUBTRACT`` Subtract, Subtract.
        :type type: typing.Optional[typing.Union[str, int]]
        '''
        pass

    def remove(self, index: typing.Optional[typing.Iterable[int]]):
        ''' Remove a vertex from the group

        :param index: Index List
        :type index: typing.Optional[typing.Iterable[int]]
        '''
        pass

    def weight(self, index: typing.Optional[int]) -> float:
        ''' Get a vertex weight from the group

        :param index: Index, The index of the vertex
        :type index: typing.Optional[int]
        :rtype: float
        :return: Vertex weight
        '''
        pass


class VertexGroupElement(bpy_struct):
    ''' Weight value of a vertex in a vertex group
    '''

    group: int = None
    ''' 

    :type: int
    '''

    weight: float = None
    ''' Vertex Weight

    :type: float
    '''


class View2D(bpy_struct):
    ''' Scroll and zoom for a 2D region
    '''

    def region_to_view(self, x: typing.Optional[int],
                       y: typing.Optional[int]) -> bpy_prop_array[float]:
        ''' Transform region coordinates to 2D view

        :param x: x, Region x coordinate
        :type x: typing.Optional[int]
        :param y: y, Region y coordinate
        :type y: typing.Optional[int]
        :rtype: bpy_prop_array[float]
        :return: Result, View coordinates
        '''
        pass

    def view_to_region(
            self,
            x: typing.Optional[float],
            y: typing.Optional[float],
            clip: typing.Optional[typing.Union[bool, typing.Any]] = True
    ) -> bpy_prop_array[int]:
        ''' Transform 2D view coordinates to region

        :param x: x, 2D View x coordinate
        :type x: typing.Optional[float]
        :param y: y, 2D View y coordinate
        :type y: typing.Optional[float]
        :param clip: Clip, Clip coordinates to the visible region
        :type clip: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: bpy_prop_array[int]
        :return: Result, Region coordinates
        '''
        pass


class VoxelData(bpy_struct):
    ''' Voxel data settings
    '''

    domain_object: 'Object' = None
    ''' Object used as the smoke simulation domain

    :type: 'Object'
    '''

    extension: typing.Union[str, int] = None
    ''' How the texture is extrapolated past its original bounds * ``EXTEND`` Extend, Extend by repeating edge pixels of the image. * ``CLIP`` Clip, Clip to image size and set exterior pixels as transparent. * ``REPEAT`` Repeat, Cause the image to repeat horizontally and vertically.

    :type: typing.Union[str, int]
    '''

    file_format: typing.Union[str, int] = None
    ''' Format of the source data set to render * ``BLENDER_VOXEL`` Blender Voxel, Default binary voxel file format. * ``RAW_8BIT`` 8 bit RAW, 8 bit grayscale binary data. * ``IMAGE_SEQUENCE`` Image Sequence, Generate voxels from a sequence of image slices. * ``SMOKE`` Smoke, Render voxels from a Blender smoke simulation. * ``HAIR`` Hair, Render voxels from a Blender hair simulation.

    :type: typing.Union[str, int]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' The external source data file to use

    :type: typing.Union[str, typing.Any]
    '''

    hair_data_type: typing.Union[str, int] = None
    ''' Simulation value to be used as a texture * ``HAIRDENSITY`` Density, Use hair density as texture data. * ``HAIRRESTDENSITY`` Rest Density, Use hair rest density as texture data. * ``HAIRVELOCITY`` Velocity, Use hair velocity as texture data. * ``HAIRENERGY`` Energy, Use potential hair energy as texture data.

    :type: typing.Union[str, int]
    '''

    intensity: float = None
    ''' Multiplier for intensity values

    :type: float
    '''

    interpolation: typing.Union[str, int] = None
    ''' Method to interpolate/smooth values between voxel cells * ``NEREASTNEIGHBOR`` Nearest Neighbor, No interpolation, fast but blocky and low quality. * ``TRILINEAR`` Linear, Good smoothness and speed. * ``QUADRATIC`` Quadratic, Mid-range quality and speed. * ``TRICUBIC_CATROM`` Cubic Catmull-Rom, High quality interpolation, but slower. * ``TRICUBIC_BSPLINE`` Cubic B-Spline, Smoothed high quality interpolation, but slower.

    :type: typing.Union[str, int]
    '''

    resolution: bpy_prop_array[int] = None
    ''' Resolution of the voxel grid

    :type: bpy_prop_array[int]
    '''

    smoke_data_type: typing.Union[str, int] = None
    ''' Simulation value to be used as a texture * ``SMOKEDENSITY`` Smoke, Use smoke density and color as texture data. * ``SMOKEFLAME`` Flame, Use flame temperature as texture data. * ``SMOKEHEAT`` Heat, Use smoke heat as texture data. Values from -2.0 to 2.0 are used. * ``SMOKEVEL`` Velocity, Use smoke velocity as texture data.

    :type: typing.Union[str, int]
    '''

    still_frame: int = None
    ''' The frame number to always use

    :type: int
    '''

    use_still_frame: bool = None
    ''' Always render a still frame from the voxel data sequence

    :type: bool
    '''


class WalkNavigation(bpy_struct):
    ''' Walk navigation settings
    '''

    jump_height: float = None
    ''' Maximum height of a jump

    :type: float
    '''

    mouse_speed: float = None
    ''' Speed factor for when looking around, high values mean faster mouse movement

    :type: float
    '''

    teleport_time: float = None
    ''' Interval of time warp when teleporting in navigation mode

    :type: float
    '''

    use_gravity: bool = None
    ''' Walk with gravity, or free navigate

    :type: bool
    '''

    use_mouse_reverse: bool = None
    ''' Reverse the mouse look

    :type: bool
    '''

    view_height: float = None
    ''' View distance from the floor when walking

    :type: float
    '''

    walk_speed: float = None
    ''' Base speed for walking and flying

    :type: float
    '''

    walk_speed_factor: float = None
    ''' Multiplication factor when using the fast or slow modifiers

    :type: float
    '''


class Window(bpy_struct):
    ''' Open window
    '''

    height: int = None
    ''' Window height

    :type: int
    '''

    screen: 'Screen' = None
    ''' Active screen showing in the window

    :type: 'Screen'
    '''

    stereo_3d_display: 'Stereo3dDisplay' = None
    ''' Settings for stereo 3d display

    :type: 'Stereo3dDisplay'
    '''

    width: int = None
    ''' Window width

    :type: int
    '''

    x: int = None
    ''' Horizontal location of the window

    :type: int
    '''

    y: int = None
    ''' Vertical location of the window

    :type: int
    '''

    def cursor_warp(self, x: typing.Optional[int], y: typing.Optional[int]):
        ''' Set the cursor position

        :param x: 
        :type x: typing.Optional[int]
        :param y: 
        :type y: typing.Optional[int]
        '''
        pass

    def cursor_set(self, cursor: typing.Optional[typing.Union[str, int]]):
        ''' Set the cursor

        :param cursor: cursor
        :type cursor: typing.Optional[typing.Union[str, int]]
        '''
        pass

    def cursor_modal_set(self,
                         cursor: typing.Optional[typing.Union[str, int]]):
        ''' Restore the previous cursor after calling ``cursor_modal_set``

        :param cursor: cursor
        :type cursor: typing.Optional[typing.Union[str, int]]
        '''
        pass

    def cursor_modal_restore(self):
        ''' cursor_modal_restore

        '''
        pass


class WorldLighting(bpy_struct):
    ''' Lighting for a World data-block
    '''

    adapt_to_speed: float = None
    ''' Use the speed vector pass to reduce AO samples in fast moving pixels - higher values result in more aggressive sample reduction (requires Vec pass enabled, for Raytrace Adaptive QMC)

    :type: float
    '''

    ao_blend_type: typing.Union[str, int] = None
    ''' Defines how AO mixes with material shading * ``MULTIPLY`` Multiply, Multiply direct lighting with ambient occlusion, darkening the result. * ``ADD`` Add, Add light and shadow.

    :type: typing.Union[str, int]
    '''

    ao_factor: float = None
    ''' Factor for ambient occlusion blending

    :type: float
    '''

    bias: float = None
    ''' Bias (in radians) to prevent smoothed faces from showing banding (for Raytrace Constant Jittered)

    :type: float
    '''

    correction: float = None
    ''' Ad-hoc correction for over-occlusion due to the approximation

    :type: float
    '''

    distance: float = None
    ''' Length of rays, defines how far away other faces give occlusion effect

    :type: float
    '''

    environment_color: typing.Union[str, int] = None
    ''' Defines where the color of the environment light comes from * ``PLAIN`` White, Plain diffuse energy (white.). * ``SKY_COLOR`` Sky Color, Use horizon and zenith color for diffuse energy. * ``SKY_TEXTURE`` Sky Texture, Does full Sky texture render for diffuse energy.

    :type: typing.Union[str, int]
    '''

    environment_energy: float = None
    ''' Defines the strength of environment light

    :type: float
    '''

    error_threshold: float = None
    ''' Low values are slower and higher quality

    :type: float
    '''

    falloff_strength: float = None
    ''' Attenuation falloff strength, the higher, the less influence distant objects have

    :type: float
    '''

    gather_method: typing.Union[str, int] = None
    ''' * ``RAYTRACE`` Raytrace, Accurate, but slow when noise-free results are required. * ``APPROXIMATE`` Approximate, Inaccurate, but faster and without noise.

    :type: typing.Union[str, int]
    '''

    indirect_bounces: int = None
    ''' Number of indirect diffuse light bounces

    :type: int
    '''

    indirect_factor: float = None
    ''' Factor for how much surrounding objects contribute to light

    :type: float
    '''

    passes: int = None
    ''' Number of preprocessing passes to reduce over-occlusion

    :type: int
    '''

    sample_method: typing.Union[str, int] = None
    ''' Method for generating shadow samples (for Raytrace) * ``CONSTANT_JITTERED`` Constant Jittered, Fastest and gives the most noise. * ``ADAPTIVE_QMC`` Adaptive QMC, Fast in high-contrast areas. * ``CONSTANT_QMC`` Constant QMC, Best quality.

    :type: typing.Union[str, int]
    '''

    samples: int = None
    ''' Amount of ray samples. Higher values give smoother results and longer rendering times

    :type: int
    '''

    threshold: float = None
    ''' Samples below this threshold will be considered fully shadowed/unshadowed and skipped (for Raytrace Adaptive QMC)

    :type: float
    '''

    use_ambient_occlusion: bool = None
    ''' Use Ambient Occlusion to add shadowing based on distance between objects

    :type: bool
    '''

    use_cache: bool = None
    ''' Cache AO results in pixels and interpolate over neighboring pixels for speedup

    :type: bool
    '''

    use_environment_light: bool = None
    ''' Add light coming from the environment

    :type: bool
    '''

    use_falloff: bool = None
    ''' Distance will be used to attenuate shadows

    :type: bool
    '''

    use_indirect_light: bool = None
    ''' Add indirect light bouncing of surrounding objects

    :type: bool
    '''


class WorldMistSettings(bpy_struct):
    ''' Mist settings for a World data-block
    '''

    depth: float = None
    ''' Distance over which the mist effect fades in

    :type: float
    '''

    falloff: typing.Union[str, int] = None
    ''' Type of transition used to fade mist * ``QUADRATIC`` Quadratic, Use quadratic progression. * ``LINEAR`` Linear, Use linear progression. * ``INVERSE_QUADRATIC`` Inverse Quadratic, Use inverse quadratic progression.

    :type: typing.Union[str, int]
    '''

    height: float = None
    ''' Control how much mist density decreases with height

    :type: float
    '''

    intensity: float = None
    ''' Overall minimum intensity of the mist effect

    :type: float
    '''

    start: float = None
    ''' Starting distance of the mist, measured from the camera

    :type: float
    '''

    use_mist: bool = None
    ''' Occlude objects with the environment color as they are further away

    :type: bool
    '''


class ActionGroups(bpy_prop_collection[ActionGroup], bpy_struct):
    ''' Collection of action groups
    '''

    def new(self, name: typing.Union[str, typing.Any]) -> 'ActionGroup':
        ''' Create a new action group and add it to the action

        :param name: New name for the action group
        :type name: typing.Union[str, typing.Any]
        :rtype: 'ActionGroup'
        :return: Newly created action group
        '''
        pass

    def remove(self, action_group: 'ActionGroup'):
        ''' Remove action group

        :param action_group: Action group to remove
        :type action_group: 'ActionGroup'
        '''
        pass


class ActionActuator(Actuator, bpy_struct):
    ''' Actuator to control the object movement
    '''

    action: 'Action' = None
    ''' 

    :type: 'Action'
    '''

    apply_to_children: bool = None
    ''' Update Action on all children Objects as well

    :type: bool
    '''

    blend_mode: typing.Union[str, int] = None
    ''' How this layer is blended with previous layers

    :type: typing.Union[str, int]
    '''

    frame_blend_in: int = None
    ''' Number of frames of motion blending

    :type: int
    '''

    frame_end: float = None
    ''' 

    :type: float
    '''

    frame_property: typing.Union[str, typing.Any] = None
    ''' Assign the action's current frame number to this property

    :type: typing.Union[str, typing.Any]
    '''

    frame_start: float = None
    ''' 

    :type: float
    '''

    layer: int = None
    ''' The animation layer to play the action on

    :type: int
    '''

    layer_weight: float = None
    ''' How much of the previous layer to blend into this one

    :type: float
    '''

    play_mode: typing.Union[str, int] = None
    ''' Action playback type

    :type: typing.Union[str, int]
    '''

    priority: int = None
    ''' Execution priority - lower numbers will override actions with higher numbers (with 2 or more actions at once, the overriding channels must be lower in the stack)

    :type: int
    '''

    property: typing.Union[str, typing.Any] = None
    ''' Use this property to define the Action position

    :type: typing.Union[str, typing.Any]
    '''

    use_additive: bool = None
    ''' Action is added to the current loc/rot/scale in global or local coordinate according to Local flag

    :type: bool
    '''

    use_continue_last_frame: bool = None
    ''' Restore last frame when switching on/off, otherwise play from the start each time

    :type: bool
    '''

    use_force: bool = None
    ''' Apply Action as a global or local force depending on the local option (dynamic objects only)

    :type: bool
    '''

    use_local: bool = None
    ''' Let the Action act in local coordinates, used in Force and Add mode

    :type: bool
    '''


class ArmatureActuator(Actuator, bpy_struct):
    bone: typing.Union[str, typing.Any] = None
    ''' Bone on which the constraint is defined

    :type: typing.Union[str, typing.Any]
    '''

    constraint: typing.Union[str, typing.Any] = None
    ''' Name of the constraint to control

    :type: typing.Union[str, typing.Any]
    '''

    influence: float = None
    ''' Influence of this constraint

    :type: float
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    secondary_target: 'Object' = None
    ''' Set this object as the secondary target of the constraint (only IK polar target at the moment)

    :type: 'Object'
    '''

    target: 'Object' = None
    ''' Set this object as the target of the constraint

    :type: 'Object'
    '''

    weight: float = None
    ''' Weight of this constraint

    :type: float
    '''


class CameraActuator(Actuator, bpy_struct):
    axis: typing.Union[str, int] = None
    ''' Axis the Camera will try to get behind * ``POS_X`` +X, Camera tries to get behind the X axis. * ``POS_Y`` +Y, Camera tries to get behind the Y axis. * ``NEG_X`` -X, Camera tries to get behind the -X axis. * ``NEG_Y`` -Y, Camera tries to get behind the -Y axis.

    :type: typing.Union[str, int]
    '''

    damping: float = None
    ''' Strength of the constraint that drives the camera behind the target

    :type: float
    '''

    height: float = None
    ''' 

    :type: float
    '''

    max: float = None
    ''' 

    :type: float
    '''

    min: float = None
    ''' 

    :type: float
    '''

    object: 'Object' = None
    ''' Look at this Object

    :type: 'Object'
    '''


class ConstraintActuator(Actuator, bpy_struct):
    ''' Actuator to handle Constraints
    '''

    angle_max: float = None
    ''' Maximum angle allowed with target direction (no correction is done if angle with target direction is between min and max)

    :type: float
    '''

    angle_min: float = None
    ''' Minimum angle to maintain with target direction (no correction is done if angle with target direction is between min and max)

    :type: float
    '''

    damping: int = None
    ''' Damping factor: time constant (in frame) of low pass filter

    :type: int
    '''

    damping_rotation: int = None
    ''' Use a different damping for orientation

    :type: int
    '''

    direction: typing.Union[str, int] = None
    ''' Direction of the ray

    :type: typing.Union[str, int]
    '''

    direction_axis: typing.Union[str, int] = None
    ''' Select the axis to be aligned along the reference direction

    :type: typing.Union[str, int]
    '''

    direction_axis_pos: typing.Union[str, int] = None
    ''' Select the axis to be aligned along the reference direction

    :type: typing.Union[str, int]
    '''

    distance: float = None
    ''' Keep this distance to target

    :type: float
    '''

    fh_damping: float = None
    ''' Damping factor of the force field spring

    :type: float
    '''

    fh_force: float = None
    ''' Spring force within the force field area

    :type: float
    '''

    fh_height: float = None
    ''' Height of the force field area

    :type: float
    '''

    limit: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    limit_max: float = None
    ''' 

    :type: float
    '''

    limit_min: float = None
    ''' 

    :type: float
    '''

    material: typing.Union[str, typing.Any] = None
    ''' Ray detects only Objects with this material

    :type: typing.Union[str, typing.Any]
    '''

    mode: typing.Union[str, int] = None
    ''' The type of the constraint

    :type: typing.Union[str, int]
    '''

    property: typing.Union[str, typing.Any] = None
    ''' Ray detects only Objects with this property

    :type: typing.Union[str, typing.Any]
    '''

    range: float = None
    ''' Maximum length of ray

    :type: float
    '''

    rotation_max: bpy_prop_array[float] = None
    ''' Reference Direction

    :type: bpy_prop_array[float]
    '''

    time: int = None
    ''' Maximum activation time in frame, 0 for unlimited

    :type: int
    '''

    use_fh_normal: bool = None
    ''' Add a horizontal spring force on slopes

    :type: bool
    '''

    use_fh_paralel_axis: bool = None
    ''' Keep object axis parallel to normal

    :type: bool
    '''

    use_force_distance: bool = None
    ''' Force distance of object to point of impact of ray

    :type: bool
    '''

    use_local: bool = None
    ''' Set ray along object's axis or global axis

    :type: bool
    '''

    use_material_detect: bool = None
    ''' Detect material instead of property

    :type: bool
    '''

    use_normal: bool = None
    ''' Set object axis along (local axis) or parallel (global axis) to the normal at hit position

    :type: bool
    '''

    use_persistent: bool = None
    ''' Persistent actuator: stays active even if ray does not reach target

    :type: bool
    '''


class EditObjectActuator(Actuator, bpy_struct):
    ''' Actuator used to edit objects
    '''

    angular_velocity: bpy_prop_array[float] = None
    ''' Angular velocity upon creation

    :type: bpy_prop_array[float]
    '''

    dynamic_operation: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    linear_velocity: bpy_prop_array[float] = None
    ''' Velocity upon creation

    :type: bpy_prop_array[float]
    '''

    mass: float = None
    ''' The mass of the object

    :type: float
    '''

    mesh: 'Mesh' = None
    ''' Replace the existing, when left blank 'Phys' will remake the existing physics mesh

    :type: 'Mesh'
    '''

    mode: typing.Union[str, int] = None
    ''' The mode of the actuator

    :type: typing.Union[str, int]
    '''

    object: 'Object' = None
    ''' Add this Object and all its children (can't be on a visible layer)

    :type: 'Object'
    '''

    time: int = None
    ''' Duration the new Object lives or the track takes

    :type: int
    '''

    track_axis: typing.Union[str, int] = None
    ''' The axis that points to the target object

    :type: typing.Union[str, int]
    '''

    track_object: 'Object' = None
    ''' Track to this Object

    :type: 'Object'
    '''

    up_axis: typing.Union[str, int] = None
    ''' The axis that points upward

    :type: typing.Union[str, int]
    '''

    use_3d_tracking: bool = None
    ''' Enable 3D tracking

    :type: bool
    '''

    use_local_angular_velocity: bool = None
    ''' Apply the rotation locally

    :type: bool
    '''

    use_local_linear_velocity: bool = None
    ''' Apply the transformation locally

    :type: bool
    '''

    use_replace_display_mesh: bool = None
    ''' Replace the display mesh

    :type: bool
    '''

    use_replace_physics_mesh: bool = None
    ''' Replace the physics mesh (triangle bounds only - compound shapes not supported)

    :type: bool
    '''


class Filter2DActuator(Actuator, bpy_struct):
    ''' Actuator to apply screen graphic effects
    '''

    filter_pass: int = None
    ''' Set filter order

    :type: int
    '''

    glsl_shader: 'Text' = None
    ''' 

    :type: 'Text'
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    motion_blur_factor: float = None
    ''' Motion blur factor

    :type: float
    '''

    use_motion_blur: bool = None
    ''' Enable/Disable Motion Blur

    :type: bool
    '''


class GameActuator(Actuator, bpy_struct):
    filename: typing.Union[str, typing.Any] = None
    ''' The file to use, depending on the mode (e.g. the blend file to load or a destination for saving a screenshot) - use the "//" prefix for a relative path

    :type: typing.Union[str, typing.Any]
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''


class MessageActuator(Actuator, bpy_struct):
    body_message: typing.Union[str, typing.Any] = None
    ''' Optional, message body Text

    :type: typing.Union[str, typing.Any]
    '''

    body_property: typing.Union[str, typing.Any] = None
    ''' The message body will be set by the Property Value

    :type: typing.Union[str, typing.Any]
    '''

    body_type: typing.Union[str, int] = None
    ''' Toggle message type: either Text or a PropertyName

    :type: typing.Union[str, int]
    '''

    subject: typing.Union[str, typing.Any] = None
    ''' Optional, message subject (this is what can be filtered on)

    :type: typing.Union[str, typing.Any]
    '''

    to_property: typing.Union[str, typing.Any] = None
    ''' Optional, send message to objects with this name only, or empty to broadcast

    :type: typing.Union[str, typing.Any]
    '''


class MouseActuator(Actuator, bpy_struct):
    local_x: bool = None
    ''' Apply rotation locally

    :type: bool
    '''

    local_y: bool = None
    ''' Apply rotation locally

    :type: bool
    '''

    max_x: float = None
    ''' Maximum positive rotation allowed by X mouse movement (0 for infinite)

    :type: float
    '''

    max_y: float = None
    ''' Maximum positive rotation allowed by Y mouse movement (0 for infinite)

    :type: float
    '''

    min_x: float = None
    ''' Maximum negative rotation allowed by X mouse movement (0 for infinite)

    :type: float
    '''

    min_y: float = None
    ''' Maximum negative rotation allowed by Y mouse movement (0 for infinite)

    :type: float
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    object_axis_x: typing.Union[str, int] = None
    ''' Local object axis mouse movement in the X direction will apply to

    :type: typing.Union[str, int]
    '''

    object_axis_y: typing.Union[str, int] = None
    ''' Local object axis mouse movement in the Y direction will apply to

    :type: typing.Union[str, int]
    '''

    reset_x: bool = None
    ''' Reset the cursor's X position to the center of the screen space after calculating

    :type: bool
    '''

    reset_y: bool = None
    ''' Reset the cursor's Y position to the center of the screen space after calculating

    :type: bool
    '''

    sensitivity_x: float = None
    ''' Sensitivity of the X axis

    :type: float
    '''

    sensitivity_y: float = None
    ''' Sensitivity of the Y axis

    :type: float
    '''

    threshold_x: float = None
    ''' Amount of X motion before mouse movement will register

    :type: float
    '''

    threshold_y: float = None
    ''' Amount of Y motion before mouse movement will register

    :type: float
    '''

    use_axis_x: bool = None
    ''' Calculate mouse movement on the X axis

    :type: bool
    '''

    use_axis_y: bool = None
    ''' Calculate mouse movement on the Y axis

    :type: bool
    '''

    visible: bool = None
    ''' Make mouse cursor visible

    :type: bool
    '''


class ObjectActuator(Actuator, bpy_struct):
    ''' Actuator to control the object movement
    '''

    angular_velocity: bpy_prop_array[float] = None
    ''' Angular velocity

    :type: bpy_prop_array[float]
    '''

    damping: int = None
    ''' Number of frames to reach the target velocity

    :type: int
    '''

    derivate_coefficient: float = None
    ''' Not required, high values can cause instability

    :type: float
    '''

    force: bpy_prop_array[float] = None
    ''' Force

    :type: bpy_prop_array[float]
    '''

    force_max_x: float = None
    ''' Upper limit for X force

    :type: float
    '''

    force_max_y: float = None
    ''' Upper limit for Y force

    :type: float
    '''

    force_max_z: float = None
    ''' Upper limit for Z force

    :type: float
    '''

    force_min_x: float = None
    ''' Lower limit for X force

    :type: float
    '''

    force_min_y: float = None
    ''' Lower limit for Y force

    :type: float
    '''

    force_min_z: float = None
    ''' Lower limit for Z force

    :type: float
    '''

    integral_coefficient: float = None
    ''' Low value (0.01) for slow response, high value (0.5) for fast response

    :type: float
    '''

    linear_velocity: bpy_prop_array[float] = None
    ''' Linear velocity (in Servo mode it sets the target relative linear velocity, it will be achieved by automatic application of force - Null velocity is a valid target)

    :type: bpy_prop_array[float]
    '''

    mode: typing.Union[str, int] = None
    ''' Specify the motion system

    :type: typing.Union[str, int]
    '''

    offset_location: bpy_prop_array[float] = None
    ''' Location

    :type: bpy_prop_array[float]
    '''

    offset_rotation: bpy_prop_array[float] = None
    ''' Rotation

    :type: bpy_prop_array[float]
    '''

    proportional_coefficient: float = None
    ''' Typical value is 60x integral coefficient

    :type: float
    '''

    reference_object: 'Object' = None
    ''' Reference object for velocity calculation, leave empty for world reference

    :type: 'Object'
    '''

    torque: bpy_prop_array[float] = None
    ''' Torque

    :type: bpy_prop_array[float]
    '''

    use_add_character_location: bool = None
    ''' Toggle between ADD and SET character location

    :type: bool
    '''

    use_add_linear_velocity: bool = None
    ''' Toggles between ADD and SET linV

    :type: bool
    '''

    use_character_jump: bool = None
    ''' Make the character jump using the settings in the physics properties

    :type: bool
    '''

    use_local_angular_velocity: bool = None
    ''' Angular velocity is defined in local coordinates

    :type: bool
    '''

    use_local_force: bool = None
    ''' Force is defined in local coordinates

    :type: bool
    '''

    use_local_linear_velocity: bool = None
    ''' Velocity is defined in local coordinates

    :type: bool
    '''

    use_local_location: bool = None
    ''' Location is defined in local coordinates

    :type: bool
    '''

    use_local_rotation: bool = None
    ''' Rotation is defined in local coordinates

    :type: bool
    '''

    use_local_torque: bool = None
    ''' Torque is defined in local coordinates

    :type: bool
    '''

    use_servo_limit_x: bool = None
    ''' Set limit to force along the X axis

    :type: bool
    '''

    use_servo_limit_y: bool = None
    ''' Set limit to force along the Y axis

    :type: bool
    '''

    use_servo_limit_z: bool = None
    ''' Set limit to force along the Z axis

    :type: bool
    '''


class ParentActuator(Actuator, bpy_struct):
    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    object: 'Object' = None
    ''' Set this object as parent

    :type: 'Object'
    '''

    use_compound: bool = None
    ''' Add this object shape to the parent shape (only if the parent shape is already compound)

    :type: bool
    '''

    use_ghost: bool = None
    ''' Make this object ghost while parented

    :type: bool
    '''


class PropertyActuator(Actuator, bpy_struct):
    ''' Actuator to handle properties
    '''

    mode: typing.Union[str, int] = None
    ''' * ``ASSIGN`` Assign. * ``ADD`` Add. * ``COPY`` Copy. * ``TOGGLE`` Toggle, For bool/int/float/timer properties only. * ``LEVEL`` Level, For bool/int/float/timer properties only.

    :type: typing.Union[str, int]
    '''

    object: 'Object' = None
    ''' Copy from this Object

    :type: 'Object'
    '''

    object_property: typing.Union[str, typing.Any] = None
    ''' Copy this property

    :type: typing.Union[str, typing.Any]
    '''

    property: typing.Union[str, typing.Any] = None
    ''' The name of the property

    :type: typing.Union[str, typing.Any]
    '''

    value: typing.Union[str, typing.Any] = None
    ''' The name of the property or the value to use (use "" around strings)

    :type: typing.Union[str, typing.Any]
    '''


class RandomActuator(Actuator, bpy_struct):
    chance: float = None
    ''' Pick a number between 0 and 1, success if it's below this value

    :type: float
    '''

    distribution: typing.Union[str, int] = None
    ''' Choose the type of distribution

    :type: typing.Union[str, int]
    '''

    float_max: float = None
    ''' Choose a number from a range: upper boundary of the range

    :type: float
    '''

    float_mean: float = None
    ''' A normal distribution: mean of the distribution

    :type: float
    '''

    float_min: float = None
    ''' Choose a number from a range: lower boundary of the range

    :type: float
    '''

    float_value: float = None
    ''' Always return this number

    :type: float
    '''

    half_life_time: float = None
    ''' Negative exponential dropoff

    :type: float
    '''

    int_max: int = None
    ''' Choose a number from a range: upper boundary of the range

    :type: int
    '''

    int_mean: float = None
    ''' Expected mean value of the distribution

    :type: float
    '''

    int_min: int = None
    ''' Choose a number from a range: lower boundary of the range

    :type: int
    '''

    int_value: int = None
    ''' Always return this number

    :type: int
    '''

    property: typing.Union[str, typing.Any] = None
    ''' Assign the random value to this property

    :type: typing.Union[str, typing.Any]
    '''

    seed: int = None
    ''' Initial seed of the random generator, use Python for more freedom (choose 0 for not random)

    :type: int
    '''

    standard_derivation: float = None
    ''' A normal distribution: standard deviation of the distribution

    :type: float
    '''

    use_always_true: bool = None
    ''' Always false or always true

    :type: bool
    '''


class SceneActuator(Actuator, bpy_struct):
    camera: 'Object' = None
    ''' Set this Camera (leave empty to refer to self object)

    :type: 'Object'
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    scene: 'Scene' = None
    ''' Scene to be added/removed/paused/resumed

    :type: 'Scene'
    '''


class SoundActuator(Actuator, bpy_struct):
    ''' Sound file
    '''

    cone_inner_angle_3d: float = None
    ''' The angle of the inner cone

    :type: float
    '''

    cone_outer_angle_3d: float = None
    ''' The angle of the outer cone

    :type: float
    '''

    cone_outer_gain_3d: float = None
    ''' The gain outside the outer cone (the gain in the outer cone will be interpolated between this value and the normal gain in the inner cone)

    :type: float
    '''

    distance_3d_max: float = None
    ''' The maximum distance at which you can hear the sound

    :type: float
    '''

    distance_3d_reference: float = None
    ''' The distance where the sound has a gain of 1.0

    :type: float
    '''

    gain_3d_max: float = None
    ''' The maximum gain of the sound, no matter how near it is

    :type: float
    '''

    gain_3d_min: float = None
    ''' The minimum gain of the sound, no matter how far it is away

    :type: float
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    pitch: float = None
    ''' Pitch of the sound

    :type: float
    '''

    rolloff_factor_3d: float = None
    ''' The influence factor on volume depending on distance

    :type: float
    '''

    sound: 'Sound' = None
    ''' 

    :type: 'Sound'
    '''

    use_sound_3d: bool = None
    ''' Enable/Disable 3D Sound

    :type: bool
    '''

    volume: float = None
    ''' Initial volume of the sound

    :type: float
    '''


class StateActuator(Actuator, bpy_struct):
    ''' Actuator to handle states
    '''

    operation: typing.Union[str, int] = None
    ''' Select the bit operation on object state mask

    :type: typing.Union[str, int]
    '''

    states: typing.List[bool] = None
    ''' 

    :type: typing.List[bool]
    '''


class SteeringActuator(Actuator, bpy_struct):
    acceleration: float = None
    ''' Max acceleration

    :type: float
    '''

    distance: float = None
    ''' Relax distance

    :type: float
    '''

    facing: bool = None
    ''' Enable automatic facing

    :type: bool
    '''

    facing_axis: typing.Union[str, int] = None
    ''' Axis for automatic facing

    :type: typing.Union[str, int]
    '''

    lock_z_velocity: bool = None
    ''' Disable simulation of linear motion along Z axis

    :type: bool
    '''

    mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    navmesh: 'Object' = None
    ''' Navigation mesh

    :type: 'Object'
    '''

    normal_up: bool = None
    ''' Use normal of the navmesh to set "UP" vector

    :type: bool
    '''

    self_terminated: bool = None
    ''' Terminate when target is reached

    :type: bool
    '''

    show_visualization: bool = None
    ''' Enable debug visualization for 'Path following'

    :type: bool
    '''

    target: 'Object' = None
    ''' Target object

    :type: 'Object'
    '''

    turn_speed: float = None
    ''' Max turn speed

    :type: float
    '''

    update_period: int = None
    ''' Path update period

    :type: int
    '''

    velocity: float = None
    ''' Velocity magnitude

    :type: float
    '''


class VisibilityActuator(Actuator, bpy_struct):
    ''' Actuator to set visibility and occlusion of the object
    '''

    apply_to_children: bool = None
    ''' Set all the children of this object to the same visibility/occlusion recursively

    :type: bool
    '''

    use_occlusion: bool = None
    ''' Set the object to occlude objects behind it (initialized from the object type in physics button)

    :type: bool
    '''

    use_visible: bool = None
    ''' Set the objects visible (initialized from the object render restriction toggle in physics button)

    :type: bool
    '''


class Addons(bpy_prop_collection[Addon], bpy_struct):
    ''' Collection of add-ons
    '''

    @classmethod
    def new(cls) -> 'Addon':
        ''' Add a new add-on

        :rtype: 'Addon'
        :return: Add-on data
        '''
        pass

    @classmethod
    def remove(cls, addon: 'Addon'):
        ''' Remove add-on

        :param addon: Add-on to remove
        :type addon: 'Addon'
        '''
        pass


class CyclesPreferences(AddonPreferences, bpy_struct):
    compute_device_type: typing.Union[str, int] = None
    ''' Device to use for computation (rendering with Cycles)

    :type: typing.Union[str, int]
    '''

    devices: bpy_prop_collection['CyclesDeviceSettings'] = None
    ''' 

    :type: bpy_prop_collection['CyclesDeviceSettings']
    '''

    def draw(self, context):
        ''' 

        '''
        pass

    def draw_impl(self, layout, context):
        ''' 

        '''
        pass

    def get_device_types(self, context):
        ''' 

        '''
        pass

    def get_devices(self):
        ''' 

        '''
        pass

    def get_num_gpu_devices(self):
        ''' 

        '''
        pass

    def has_active_device(self):
        ''' 

        '''
        pass


class AlembicObjectPaths(bpy_prop_collection[AlembicObjectPath], bpy_struct):
    ''' Collection of object paths
    '''

    pass


class BackgroundImages(bpy_prop_collection[BackgroundImage], bpy_struct):
    ''' Collection of background images
    '''

    def new(self) -> 'BackgroundImage':
        ''' Add new background image

        :rtype: 'BackgroundImage'
        :return: Image displayed as viewport background
        '''
        pass

    def remove(self, image: 'BackgroundImage'):
        ''' Remove background image

        :param image: Image displayed as viewport background
        :type image: 'BackgroundImage'
        '''
        pass

    def clear(self):
        ''' Remove all background images

        '''
        pass


class SplineBezierPoints(bpy_prop_collection[BezierSplinePoint], bpy_struct):
    ''' Collection of spline Bezier points
    '''

    def add(self, count: typing.Optional[typing.Any] = 1):
        ''' Add a number of points to this spline

        :param count: Number, Number of points to add to the spline
        :type count: typing.Optional[typing.Any]
        '''
        pass


class BoidRuleAverageSpeed(BoidRule, bpy_struct):
    level: float = None
    ''' How much velocity's z-component is kept constant

    :type: float
    '''

    speed: float = None
    ''' Percentage of maximum speed

    :type: float
    '''

    wander: float = None
    ''' How fast velocity's direction is randomized

    :type: float
    '''


class BoidRuleAvoid(BoidRule, bpy_struct):
    fear_factor: float = None
    ''' Avoid object if danger from it is above this threshold

    :type: float
    '''

    object: 'Object' = None
    ''' Object to avoid

    :type: 'Object'
    '''

    use_predict: bool = None
    ''' Predict target movement

    :type: bool
    '''


class BoidRuleAvoidCollision(BoidRule, bpy_struct):
    look_ahead: float = None
    ''' Time to look ahead in seconds

    :type: float
    '''

    use_avoid: bool = None
    ''' Avoid collision with other boids

    :type: bool
    '''

    use_avoid_collision: bool = None
    ''' Avoid collision with deflector objects

    :type: bool
    '''


class BoidRuleFight(BoidRule, bpy_struct):
    distance: float = None
    ''' Attack boids at max this distance

    :type: float
    '''

    flee_distance: float = None
    ''' Flee to this distance

    :type: float
    '''


class BoidRuleFollowLeader(BoidRule, bpy_struct):
    distance: float = None
    ''' Distance behind leader to follow

    :type: float
    '''

    object: 'Object' = None
    ''' Follow this object instead of a boid

    :type: 'Object'
    '''

    queue_count: int = None
    ''' How many boids in a line

    :type: int
    '''

    use_line: bool = None
    ''' Follow leader in a line

    :type: bool
    '''


class BoidRuleGoal(BoidRule, bpy_struct):
    object: 'Object' = None
    ''' Goal object

    :type: 'Object'
    '''

    use_predict: bool = None
    ''' Predict target movement

    :type: bool
    '''


class ArmatureBones(bpy_prop_collection[Bone], bpy_struct):
    ''' Collection of armature bones
    '''

    active: 'Bone' = None
    ''' Armature's active bone

    :type: 'Bone'
    '''


class BoneGroups(bpy_prop_collection[BoneGroup], bpy_struct):
    ''' Collection of bone groups
    '''

    active: 'BoneGroup' = None
    ''' Active bone group for this pose

    :type: 'BoneGroup'
    '''

    active_index: int = None
    ''' Active index in bone groups array

    :type: int
    '''

    def new(self,
            name: typing.Union[str, typing.Any] = "Group") -> 'BoneGroup':
        ''' Add a new bone group to the object

        :param name: Name of the new group
        :type name: typing.Union[str, typing.Any]
        :rtype: 'BoneGroup'
        :return: New bone group
        '''
        pass

    def remove(self, group: 'BoneGroup'):
        ''' Remove a bone group from this object

        :param group: Removed bone group
        :type group: 'BoneGroup'
        '''
        pass


class ColorRampElements(bpy_prop_collection[ColorRampElement], bpy_struct):
    ''' Collection of Color Ramp Elements
    '''

    def new(self, position: typing.Optional[float]) -> 'ColorRampElement':
        ''' Add element to ColorRamp

        :param position: Position, Position to add element
        :type position: typing.Optional[float]
        :rtype: 'ColorRampElement'
        :return: New element
        '''
        pass

    def remove(self, element: 'ColorRampElement'):
        ''' Delete element from ColorRamp

        :param element: Element to remove
        :type element: 'ColorRampElement'
        '''
        pass


class ActionConstraint(Constraint, bpy_struct):
    ''' Map an action to the transform axes of a bone
    '''

    action: 'Action' = None
    ''' The constraining action

    :type: 'Action'
    '''

    frame_end: int = None
    ''' Last frame of the Action to use

    :type: int
    '''

    frame_start: int = None
    ''' First frame of the Action to use

    :type: int
    '''

    max: float = None
    ''' Maximum value for target channel range

    :type: float
    '''

    min: float = None
    ''' Minimum value for target channel range

    :type: float
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    transform_channel: typing.Union[str, int] = None
    ''' Transformation channel from the target that is used to key the Action

    :type: typing.Union[str, int]
    '''

    use_bone_object_action: bool = None
    ''' Bones only: apply the object's transformation channels of the action to the constrained bone, instead of bone's channels

    :type: bool
    '''


class CameraSolverConstraint(Constraint, bpy_struct):
    ''' Lock motion to the reconstructed camera movement
    '''

    clip: 'MovieClip' = None
    ''' Movie Clip to get tracking data from

    :type: 'MovieClip'
    '''

    use_active_clip: bool = None
    ''' Use active clip defined in scene

    :type: bool
    '''


class ChildOfConstraint(Constraint, bpy_struct):
    ''' Create constraint-based parent-child relationship
    '''

    inverse_matrix: bpy_prop_array[float] = None
    ''' Transformation matrix to apply before

    :type: bpy_prop_array[float]
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_location_x: bool = None
    ''' Use X Location of Parent

    :type: bool
    '''

    use_location_y: bool = None
    ''' Use Y Location of Parent

    :type: bool
    '''

    use_location_z: bool = None
    ''' Use Z Location of Parent

    :type: bool
    '''

    use_rotation_x: bool = None
    ''' Use X Rotation of Parent

    :type: bool
    '''

    use_rotation_y: bool = None
    ''' Use Y Rotation of Parent

    :type: bool
    '''

    use_rotation_z: bool = None
    ''' Use Z Rotation of Parent

    :type: bool
    '''

    use_scale_x: bool = None
    ''' Use X Scale of Parent

    :type: bool
    '''

    use_scale_y: bool = None
    ''' Use Y Scale of Parent

    :type: bool
    '''

    use_scale_z: bool = None
    ''' Use Z Scale of Parent

    :type: bool
    '''


class ClampToConstraint(Constraint, bpy_struct):
    ''' Constrain an object's location to the nearest point along the target path
    '''

    main_axis: typing.Union[str, int] = None
    ''' Main axis of movement

    :type: typing.Union[str, int]
    '''

    target: 'Object' = None
    ''' Target Object (Curves only)

    :type: 'Object'
    '''

    use_cyclic: bool = None
    ''' Treat curve as cyclic curve (no clamping to curve bounding box)

    :type: bool
    '''


class CopyLocationConstraint(Constraint, bpy_struct):
    ''' Copy the location of the target
    '''

    head_tail: float = None
    ''' Target along length of bone: Head=0, Tail=1

    :type: float
    '''

    invert_x: bool = None
    ''' Invert the X location

    :type: bool
    '''

    invert_y: bool = None
    ''' Invert the Y location

    :type: bool
    '''

    invert_z: bool = None
    ''' Invert the Z location

    :type: bool
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    ''' Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    '''

    use_offset: bool = None
    ''' Add original location into copied location

    :type: bool
    '''

    use_x: bool = None
    ''' Copy the target's X location

    :type: bool
    '''

    use_y: bool = None
    ''' Copy the target's Y location

    :type: bool
    '''

    use_z: bool = None
    ''' Copy the target's Z location

    :type: bool
    '''


class CopyRotationConstraint(Constraint, bpy_struct):
    ''' Copy the rotation of the target
    '''

    invert_x: bool = None
    ''' Invert the X rotation

    :type: bool
    '''

    invert_y: bool = None
    ''' Invert the Y rotation

    :type: bool
    '''

    invert_z: bool = None
    ''' Invert the Z rotation

    :type: bool
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_offset: bool = None
    ''' Add original rotation into copied rotation

    :type: bool
    '''

    use_x: bool = None
    ''' Copy the target's X rotation

    :type: bool
    '''

    use_y: bool = None
    ''' Copy the target's Y rotation

    :type: bool
    '''

    use_z: bool = None
    ''' Copy the target's Z rotation

    :type: bool
    '''


class CopyScaleConstraint(Constraint, bpy_struct):
    ''' Copy the scale of the target
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_offset: bool = None
    ''' Add original scale into copied scale

    :type: bool
    '''

    use_x: bool = None
    ''' Copy the target's X scale

    :type: bool
    '''

    use_y: bool = None
    ''' Copy the target's Y scale

    :type: bool
    '''

    use_z: bool = None
    ''' Copy the target's Z scale

    :type: bool
    '''


class CopyTransformsConstraint(Constraint, bpy_struct):
    ''' Copy all the transforms of the target
    '''

    head_tail: float = None
    ''' Target along length of bone: Head=0, Tail=1

    :type: float
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    ''' Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    '''


class DampedTrackConstraint(Constraint, bpy_struct):
    ''' Point toward target by taking the shortest rotation path
    '''

    head_tail: float = None
    ''' Target along length of bone: Head=0, Tail=1

    :type: float
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    track_axis: typing.Union[str, int] = None
    ''' Axis that points to the target object

    :type: typing.Union[str, int]
    '''

    use_bbone_shape: bool = None
    ''' Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    '''


class FloorConstraint(Constraint, bpy_struct):
    ''' Use the target object for location limitation
    '''

    floor_location: typing.Union[str, int] = None
    ''' Location of target that object will not pass through

    :type: typing.Union[str, int]
    '''

    offset: float = None
    ''' Offset of floor from object origin

    :type: float
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_rotation: bool = None
    ''' Use the target's rotation to determine floor

    :type: bool
    '''

    use_sticky: bool = None
    ''' Immobilize object while constrained

    :type: bool
    '''


class FollowPathConstraint(Constraint, bpy_struct):
    ''' Lock motion to the target path
    '''

    forward_axis: typing.Union[str, int] = None
    ''' Axis that points forward along the path

    :type: typing.Union[str, int]
    '''

    offset: float = None
    ''' Offset from the position corresponding to the time frame

    :type: float
    '''

    offset_factor: float = None
    ''' Percentage value defining target position along length of curve

    :type: float
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    up_axis: typing.Union[str, int] = None
    ''' Axis that points upward

    :type: typing.Union[str, int]
    '''

    use_curve_follow: bool = None
    ''' Object will follow the heading and banking of the curve

    :type: bool
    '''

    use_curve_radius: bool = None
    ''' Object is scaled by the curve radius

    :type: bool
    '''

    use_fixed_location: bool = None
    ''' Object will stay locked to a single point somewhere along the length of the curve regardless of time

    :type: bool
    '''


class FollowTrackConstraint(Constraint, bpy_struct):
    ''' Lock motion to the target motion track
    '''

    camera: 'Object' = None
    ''' Camera to which motion is parented (if empty active scene camera is used)

    :type: 'Object'
    '''

    clip: 'MovieClip' = None
    ''' Movie Clip to get tracking data from

    :type: 'MovieClip'
    '''

    depth_object: 'Object' = None
    ''' Object used to define depth in camera space by projecting onto surface of this object

    :type: 'Object'
    '''

    frame_method: typing.Union[str, int] = None
    ''' How the footage fits in the camera frame

    :type: typing.Union[str, int]
    '''

    object: typing.Union[str, typing.Any] = None
    ''' Movie tracking object to follow (if empty, camera object is used)

    :type: typing.Union[str, typing.Any]
    '''

    track: typing.Union[str, typing.Any] = None
    ''' Movie tracking track to follow

    :type: typing.Union[str, typing.Any]
    '''

    use_3d_position: bool = None
    ''' Use 3D position of track to parent to

    :type: bool
    '''

    use_active_clip: bool = None
    ''' Use active clip defined in scene

    :type: bool
    '''

    use_undistorted_position: bool = None
    ''' Parent to undistorted position of 2D track

    :type: bool
    '''


class KinematicConstraint(Constraint, bpy_struct):
    ''' Inverse Kinematics
    '''

    chain_count: int = None
    ''' How many bones are included in the IK effect - 0 uses all bones

    :type: int
    '''

    distance: float = None
    ''' Radius of limiting sphere

    :type: float
    '''

    ik_type: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    iterations: int = None
    ''' Maximum number of solving iterations

    :type: int
    '''

    limit_mode: typing.Union[str, int] = None
    ''' Distances in relation to sphere of influence to allow * ``LIMITDIST_INSIDE`` Inside, The object is constrained inside a virtual sphere around the target object, with a radius defined by the limit distance. * ``LIMITDIST_OUTSIDE`` Outside, The object is constrained outside a virtual sphere around the target object, with a radius defined by the limit distance. * ``LIMITDIST_ONSURFACE`` On Surface, The object is constrained on the surface of a virtual sphere around the target object, with a radius defined by the limit distance.

    :type: typing.Union[str, int]
    '''

    lock_location_x: bool = None
    ''' Constraint position along X axis

    :type: bool
    '''

    lock_location_y: bool = None
    ''' Constraint position along Y axis

    :type: bool
    '''

    lock_location_z: bool = None
    ''' Constraint position along Z axis

    :type: bool
    '''

    lock_rotation_x: bool = None
    ''' Constraint rotation along X axis

    :type: bool
    '''

    lock_rotation_y: bool = None
    ''' Constraint rotation along Y axis

    :type: bool
    '''

    lock_rotation_z: bool = None
    ''' Constraint rotation along Z axis

    :type: bool
    '''

    orient_weight: float = None
    ''' For Tree-IK: Weight of orientation control for this target

    :type: float
    '''

    pole_angle: float = None
    ''' Pole rotation offset

    :type: float
    '''

    pole_subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    pole_target: 'Object' = None
    ''' Object for pole rotation

    :type: 'Object'
    '''

    reference_axis: typing.Union[str, int] = None
    ''' Constraint axis Lock options relative to Bone or Target reference

    :type: typing.Union[str, int]
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_location: bool = None
    ''' Chain follows position of target

    :type: bool
    '''

    use_rotation: bool = None
    ''' Chain follows rotation of target

    :type: bool
    '''

    use_stretch: bool = None
    ''' Enable IK Stretching

    :type: bool
    '''

    use_tail: bool = None
    ''' Include bone's tail as last element in chain

    :type: bool
    '''

    weight: float = None
    ''' For Tree-IK: Weight of position control for this target

    :type: float
    '''


class LimitDistanceConstraint(Constraint, bpy_struct):
    ''' Limit the distance from target object
    '''

    distance: float = None
    ''' Radius of limiting sphere

    :type: float
    '''

    head_tail: float = None
    ''' Target along length of bone: Head=0, Tail=1

    :type: float
    '''

    limit_mode: typing.Union[str, int] = None
    ''' Distances in relation to sphere of influence to allow * ``LIMITDIST_INSIDE`` Inside, The object is constrained inside a virtual sphere around the target object, with a radius defined by the limit distance. * ``LIMITDIST_OUTSIDE`` Outside, The object is constrained outside a virtual sphere around the target object, with a radius defined by the limit distance. * ``LIMITDIST_ONSURFACE`` On Surface, The object is constrained on the surface of a virtual sphere around the target object, with a radius defined by the limit distance.

    :type: typing.Union[str, int]
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    ''' Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    '''

    use_transform_limit: bool = None
    ''' Transforms are affected by this constraint as well

    :type: bool
    '''


class LimitLocationConstraint(Constraint, bpy_struct):
    ''' Limit the location of the constrained object
    '''

    max_x: float = None
    ''' Highest X value to allow

    :type: float
    '''

    max_y: float = None
    ''' Highest Y value to allow

    :type: float
    '''

    max_z: float = None
    ''' Highest Z value to allow

    :type: float
    '''

    min_x: float = None
    ''' Lowest X value to allow

    :type: float
    '''

    min_y: float = None
    ''' Lowest Y value to allow

    :type: float
    '''

    min_z: float = None
    ''' Lowest Z value to allow

    :type: float
    '''

    use_max_x: bool = None
    ''' Use the maximum X value

    :type: bool
    '''

    use_max_y: bool = None
    ''' Use the maximum Y value

    :type: bool
    '''

    use_max_z: bool = None
    ''' Use the maximum Z value

    :type: bool
    '''

    use_min_x: bool = None
    ''' Use the minimum X value

    :type: bool
    '''

    use_min_y: bool = None
    ''' Use the minimum Y value

    :type: bool
    '''

    use_min_z: bool = None
    ''' Use the minimum Z value

    :type: bool
    '''

    use_transform_limit: bool = None
    ''' Transforms are affected by this constraint as well

    :type: bool
    '''


class LimitRotationConstraint(Constraint, bpy_struct):
    ''' Limit the rotation of the constrained object
    '''

    max_x: float = None
    ''' Highest X value to allow

    :type: float
    '''

    max_y: float = None
    ''' Highest Y value to allow

    :type: float
    '''

    max_z: float = None
    ''' Highest Z value to allow

    :type: float
    '''

    min_x: float = None
    ''' Lowest X value to allow

    :type: float
    '''

    min_y: float = None
    ''' Lowest Y value to allow

    :type: float
    '''

    min_z: float = None
    ''' Lowest Z value to allow

    :type: float
    '''

    use_limit_x: bool = None
    ''' Use the minimum X value

    :type: bool
    '''

    use_limit_y: bool = None
    ''' Use the minimum Y value

    :type: bool
    '''

    use_limit_z: bool = None
    ''' Use the minimum Z value

    :type: bool
    '''

    use_transform_limit: bool = None
    ''' Transforms are affected by this constraint as well

    :type: bool
    '''


class LimitScaleConstraint(Constraint, bpy_struct):
    ''' Limit the scaling of the constrained object
    '''

    max_x: float = None
    ''' Highest X value to allow

    :type: float
    '''

    max_y: float = None
    ''' Highest Y value to allow

    :type: float
    '''

    max_z: float = None
    ''' Highest Z value to allow

    :type: float
    '''

    min_x: float = None
    ''' Lowest X value to allow

    :type: float
    '''

    min_y: float = None
    ''' Lowest Y value to allow

    :type: float
    '''

    min_z: float = None
    ''' Lowest Z value to allow

    :type: float
    '''

    use_max_x: bool = None
    ''' Use the maximum X value

    :type: bool
    '''

    use_max_y: bool = None
    ''' Use the maximum Y value

    :type: bool
    '''

    use_max_z: bool = None
    ''' Use the maximum Z value

    :type: bool
    '''

    use_min_x: bool = None
    ''' Use the minimum X value

    :type: bool
    '''

    use_min_y: bool = None
    ''' Use the minimum Y value

    :type: bool
    '''

    use_min_z: bool = None
    ''' Use the minimum Z value

    :type: bool
    '''

    use_transform_limit: bool = None
    ''' Transforms are affected by this constraint as well

    :type: bool
    '''


class LockedTrackConstraint(Constraint, bpy_struct):
    ''' Point toward the target along the track axis, while locking the other axis
    '''

    head_tail: float = None
    ''' Target along length of bone: Head=0, Tail=1

    :type: float
    '''

    lock_axis: typing.Union[str, int] = None
    ''' Axis that points upward

    :type: typing.Union[str, int]
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    track_axis: typing.Union[str, int] = None
    ''' Axis that points to the target object

    :type: typing.Union[str, int]
    '''

    use_bbone_shape: bool = None
    ''' Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    '''


class MaintainVolumeConstraint(Constraint, bpy_struct):
    ''' Maintain a constant volume along a single scaling axis
    '''

    free_axis: typing.Union[str, int] = None
    ''' The free scaling axis of the object

    :type: typing.Union[str, int]
    '''

    volume: float = None
    ''' Volume of the bone at rest

    :type: float
    '''


class ObjectConstraints(bpy_prop_collection[Constraint], bpy_struct):
    ''' Collection of object constraints
    '''

    active: 'Constraint' = None
    ''' Active Object constraint

    :type: 'Constraint'
    '''

    def new(self,
            type: typing.Optional[typing.Union[str, int]]) -> 'Constraint':
        ''' Add a new constraint to this object

        :param type: Constraint type to add * ``CAMERA_SOLVER`` Camera Solver. * ``FOLLOW_TRACK`` Follow Track. * ``OBJECT_SOLVER`` Object Solver. * ``COPY_LOCATION`` Copy Location, Copy the location of a target (with an optional offset), so that they move together. * ``COPY_ROTATION`` Copy Rotation, Copy the rotation of a target (with an optional offset), so that they rotate together. * ``COPY_SCALE`` Copy Scale, Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount. * ``COPY_TRANSFORMS`` Copy Transforms, Copy all the transformations of a target, so that they move together. * ``LIMIT_DISTANCE`` Limit Distance, Restrict movements to within a certain distance of a target (at the time of constraint evaluation only). * ``LIMIT_LOCATION`` Limit Location, Restrict movement along each axis within given ranges. * ``LIMIT_ROTATION`` Limit Rotation, Restrict rotation along each axis within given ranges. * ``LIMIT_SCALE`` Limit Scale, Restrict scaling along each axis with given ranges. * ``MAINTAIN_VOLUME`` Maintain Volume, Compensate for scaling one axis by applying suitable scaling to the other two axes. * ``TRANSFORM`` Transformation, Use one transform property from target to control another (or same) property on owner. * ``TRANSFORM_CACHE`` Transform Cache, Look up the transformation matrix from an external file. * ``CLAMP_TO`` Clamp To, Restrict movements to lie along a curve by remapping location along curve's longest axis. * ``DAMPED_TRACK`` Damped Track, Point towards a target by performing the smallest rotation necessary. * ``IK`` Inverse Kinematics, Control a chain of bones by specifying the endpoint target (Bones only). * ``LOCKED_TRACK`` Locked Track, Rotate around the specified ('locked') axis to point towards a target. * ``SPLINE_IK`` Spline IK, Align chain of bones along a curve (Bones only). * ``STRETCH_TO`` Stretch To, Stretch along Y-Axis to point towards a target. * ``TRACK_TO`` Track To, Legacy tracking constraint prone to twisting artifacts. * ``ACTION`` Action, Use transform property of target to look up pose for owner from an Action. * ``CHILD_OF`` Child Of, Make target the 'detachable' parent of owner. * ``FLOOR`` Floor, Use position (and optionally rotation) of target to define a 'wall' or 'floor' that the owner can not cross. * ``FOLLOW_PATH`` Follow Path, Use to animate an object/bone following a path. * ``PIVOT`` Pivot, Change pivot point for transforms (buggy). * ``RIGID_BODY_JOINT`` Rigid Body Joint, Use to define a Rigid Body Constraint (for Game Engine use only). * ``SHRINKWRAP`` Shrinkwrap, Restrict movements to surface of target mesh.
        :type type: typing.Optional[typing.Union[str, int]]
        :rtype: 'Constraint'
        :return: New constraint
        '''
        pass

    def remove(self, constraint: 'Constraint'):
        ''' Remove a constraint from this object

        :param constraint: Removed constraint
        :type constraint: 'Constraint'
        '''
        pass

    def clear(self):
        ''' Remove all constraint from this object

        '''
        pass


class ObjectSolverConstraint(Constraint, bpy_struct):
    ''' Lock motion to the reconstructed object movement
    '''

    camera: 'Object' = None
    ''' Camera to which motion is parented (if empty active scene camera is used)

    :type: 'Object'
    '''

    clip: 'MovieClip' = None
    ''' Movie Clip to get tracking data from

    :type: 'MovieClip'
    '''

    object: typing.Union[str, typing.Any] = None
    ''' Movie tracking object to follow

    :type: typing.Union[str, typing.Any]
    '''

    use_active_clip: bool = None
    ''' Use active clip defined in scene

    :type: bool
    '''


class PivotConstraint(Constraint, bpy_struct):
    ''' Rotate around a different point
    '''

    head_tail: float = None
    ''' Target along length of bone: Head=0, Tail=1

    :type: float
    '''

    offset: bpy_prop_array[float] = None
    ''' Offset of pivot from target (when set), or from owner's location (when Fixed Position is off), or the absolute pivot point

    :type: bpy_prop_array[float]
    '''

    rotation_range: typing.Union[str, int] = None
    ''' Rotation range on which pivoting should occur * ``ALWAYS_ACTIVE`` Always, Use the pivot point in every rotation. * ``NX`` -X Rot, Use the pivot point in the negative rotation range around the X-axis. * ``NY`` -Y Rot, Use the pivot point in the negative rotation range around the Y-axis. * ``NZ`` -Z Rot, Use the pivot point in the negative rotation range around the Z-axis. * ``X`` X Rot, Use the pivot point in the positive rotation range around the X-axis. * ``Y`` Y Rot, Use the pivot point in the positive rotation range around the Y-axis. * ``Z`` Z Rot, Use the pivot point in the positive rotation range around the Z-axis.

    :type: typing.Union[str, int]
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object, defining the position of the pivot when defined

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    ''' Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    '''

    use_relative_location: bool = None
    ''' Offset will be an absolute point in space instead of relative to the target

    :type: bool
    '''


class PoseBoneConstraints(bpy_prop_collection[Constraint], bpy_struct):
    ''' Collection of pose bone constraints
    '''

    active: 'Constraint' = None
    ''' Active PoseChannel constraint

    :type: 'Constraint'
    '''

    def new(self,
            type: typing.Optional[typing.Union[str, int]]) -> 'Constraint':
        ''' Add a constraint to this object

        :param type: Constraint type to add * ``CAMERA_SOLVER`` Camera Solver. * ``FOLLOW_TRACK`` Follow Track. * ``OBJECT_SOLVER`` Object Solver. * ``COPY_LOCATION`` Copy Location, Copy the location of a target (with an optional offset), so that they move together. * ``COPY_ROTATION`` Copy Rotation, Copy the rotation of a target (with an optional offset), so that they rotate together. * ``COPY_SCALE`` Copy Scale, Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount. * ``COPY_TRANSFORMS`` Copy Transforms, Copy all the transformations of a target, so that they move together. * ``LIMIT_DISTANCE`` Limit Distance, Restrict movements to within a certain distance of a target (at the time of constraint evaluation only). * ``LIMIT_LOCATION`` Limit Location, Restrict movement along each axis within given ranges. * ``LIMIT_ROTATION`` Limit Rotation, Restrict rotation along each axis within given ranges. * ``LIMIT_SCALE`` Limit Scale, Restrict scaling along each axis with given ranges. * ``MAINTAIN_VOLUME`` Maintain Volume, Compensate for scaling one axis by applying suitable scaling to the other two axes. * ``TRANSFORM`` Transformation, Use one transform property from target to control another (or same) property on owner. * ``TRANSFORM_CACHE`` Transform Cache, Look up the transformation matrix from an external file. * ``CLAMP_TO`` Clamp To, Restrict movements to lie along a curve by remapping location along curve's longest axis. * ``DAMPED_TRACK`` Damped Track, Point towards a target by performing the smallest rotation necessary. * ``IK`` Inverse Kinematics, Control a chain of bones by specifying the endpoint target (Bones only). * ``LOCKED_TRACK`` Locked Track, Rotate around the specified ('locked') axis to point towards a target. * ``SPLINE_IK`` Spline IK, Align chain of bones along a curve (Bones only). * ``STRETCH_TO`` Stretch To, Stretch along Y-Axis to point towards a target. * ``TRACK_TO`` Track To, Legacy tracking constraint prone to twisting artifacts. * ``ACTION`` Action, Use transform property of target to look up pose for owner from an Action. * ``CHILD_OF`` Child Of, Make target the 'detachable' parent of owner. * ``FLOOR`` Floor, Use position (and optionally rotation) of target to define a 'wall' or 'floor' that the owner can not cross. * ``FOLLOW_PATH`` Follow Path, Use to animate an object/bone following a path. * ``PIVOT`` Pivot, Change pivot point for transforms (buggy). * ``RIGID_BODY_JOINT`` Rigid Body Joint, Use to define a Rigid Body Constraint (for Game Engine use only). * ``SHRINKWRAP`` Shrinkwrap, Restrict movements to surface of target mesh.
        :type type: typing.Optional[typing.Union[str, int]]
        :rtype: 'Constraint'
        :return: New constraint
        '''
        pass

    def remove(self, constraint: 'Constraint'):
        ''' Remove a constraint from this object

        :param constraint: Removed constraint
        :type constraint: 'Constraint'
        '''
        pass


class PythonConstraint(Constraint, bpy_struct):
    ''' Use Python script for constraint evaluation
    '''

    has_script_error: typing.Union[bool, typing.Any] = None
    ''' The linked Python script has thrown an error

    :type: typing.Union[bool, typing.Any]
    '''

    target_count: int = None
    ''' Usually only 1-3 are needed

    :type: int
    '''

    targets: bpy_prop_collection['ConstraintTarget'] = None
    ''' Target Objects

    :type: bpy_prop_collection['ConstraintTarget']
    '''

    text: 'Text' = None
    ''' The text object that contains the Python script

    :type: 'Text'
    '''

    use_targets: bool = None
    ''' Use the targets indicated in the constraint panel

    :type: bool
    '''


class RigidBodyJointConstraint(Constraint, bpy_struct):
    ''' For use with the Game Engine
    '''

    axis_x: float = None
    ''' Rotate pivot on X axis

    :type: float
    '''

    axis_y: float = None
    ''' Rotate pivot on Y axis

    :type: float
    '''

    axis_z: float = None
    ''' Rotate pivot on Z axis

    :type: float
    '''

    child: 'Object' = None
    ''' Child object

    :type: 'Object'
    '''

    limit_angle_max_x: float = None
    ''' 

    :type: float
    '''

    limit_angle_max_y: float = None
    ''' 

    :type: float
    '''

    limit_angle_max_z: float = None
    ''' 

    :type: float
    '''

    limit_angle_min_x: float = None
    ''' 

    :type: float
    '''

    limit_angle_min_y: float = None
    ''' 

    :type: float
    '''

    limit_angle_min_z: float = None
    ''' 

    :type: float
    '''

    limit_max_x: float = None
    ''' 

    :type: float
    '''

    limit_max_y: float = None
    ''' 

    :type: float
    '''

    limit_max_z: float = None
    ''' 

    :type: float
    '''

    limit_min_x: float = None
    ''' 

    :type: float
    '''

    limit_min_y: float = None
    ''' 

    :type: float
    '''

    limit_min_z: float = None
    ''' 

    :type: float
    '''

    pivot_type: typing.Union[str, int] = None
    ''' * ``BALL`` Ball, Allow rotations around all axes. * ``HINGE`` Hinge, Work in one plane, allow rotations around one axis only. * ``CONE_TWIST`` Cone Twist, Allow rotations around all axes with limits for the cone and twist axes. * ``GENERIC_6_DOF`` Generic 6 DoF, No constraints by default, limits can be set individually.

    :type: typing.Union[str, int]
    '''

    pivot_x: float = None
    ''' Offset pivot on X

    :type: float
    '''

    pivot_y: float = None
    ''' Offset pivot on Y

    :type: float
    '''

    pivot_z: float = None
    ''' Offset pivot on Z

    :type: float
    '''

    show_pivot: bool = None
    ''' Display the pivot point and rotation in 3D view

    :type: bool
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_angular_limit_x: bool = None
    ''' Use minimum/maximum X angular limit

    :type: bool
    '''

    use_angular_limit_y: bool = None
    ''' Use minimum/maximum Y angular limit

    :type: bool
    '''

    use_angular_limit_z: bool = None
    ''' Use minimum/maximum Z angular limit

    :type: bool
    '''

    use_limit_x: bool = None
    ''' Use minimum/maximum X limit

    :type: bool
    '''

    use_limit_y: bool = None
    ''' Use minimum/maximum y limit

    :type: bool
    '''

    use_limit_z: bool = None
    ''' Use minimum/maximum z limit

    :type: bool
    '''

    use_linked_collision: bool = None
    ''' Disable collision between linked bodies

    :type: bool
    '''


class ShrinkwrapConstraint(Constraint, bpy_struct):
    ''' Create constraint-based shrinkwrap relationship
    '''

    distance: float = None
    ''' Distance to Target

    :type: float
    '''

    project_axis: typing.Union[str, int] = None
    ''' Axis constrain to

    :type: typing.Union[str, int]
    '''

    project_axis_space: typing.Union[str, int] = None
    ''' Space for the projection axis * ``WORLD`` World Space, The constraint is applied relative to the world coordinate system. * ``POSE`` Pose Space, The constraint is applied in Pose Space, the object transformation is ignored. * ``LOCAL_WITH_PARENT`` Local With Parent, The constraint is applied relative to the local coordinate system of the object, with the parent transformation added. * ``LOCAL`` Local Space, The constraint is applied relative to the local coordinate system of the object.

    :type: typing.Union[str, int]
    '''

    project_limit: float = None
    ''' Limit the distance used for projection (zero disables)

    :type: float
    '''

    shrinkwrap_type: typing.Union[str, int] = None
    ''' Select type of shrinkwrap algorithm for target position * ``NEAREST_SURFACE`` Nearest Surface Point, Shrink the location to the nearest target surface. * ``PROJECT`` Project, Shrink the location to the nearest target surface along a given axis. * ``NEAREST_VERTEX`` Nearest Vertex, Shrink the location to the nearest target vertex.

    :type: typing.Union[str, int]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''


class SplineIKConstraint(Constraint, bpy_struct):
    ''' Align 'n' bones along a curve
    '''

    bulge: float = None
    ''' Factor between volume variation and stretching

    :type: float
    '''

    bulge_max: float = None
    ''' Maximum volume stretching factor

    :type: float
    '''

    bulge_min: float = None
    ''' Minimum volume stretching factor

    :type: float
    '''

    bulge_smooth: float = None
    ''' Strength of volume stretching clamping

    :type: float
    '''

    chain_count: int = None
    ''' How many bones are included in the chain

    :type: int
    '''

    joint_bindings: bpy_prop_array[float] = None
    ''' (EXPERIENCED USERS ONLY) The relative positions of the joints along the chain, as percentages

    :type: bpy_prop_array[float]
    '''

    target: 'Object' = None
    ''' Curve that controls this relationship

    :type: 'Object'
    '''

    use_bulge_max: bool = None
    ''' Use upper limit for volume variation

    :type: bool
    '''

    use_bulge_min: bool = None
    ''' Use lower limit for volume variation

    :type: bool
    '''

    use_chain_offset: bool = None
    ''' Offset the entire chain relative to the root joint

    :type: bool
    '''

    use_curve_radius: bool = None
    ''' Average radius of the endpoints is used to tweak the X and Z Scaling of the bones, on top of XZ Scale mode

    :type: bool
    '''

    use_even_divisions: bool = None
    ''' Ignore the relative lengths of the bones when fitting to the curve

    :type: bool
    '''

    use_y_stretch: bool = None
    ''' Stretch the Y axis of the bones to fit the curve

    :type: bool
    '''

    xz_scale_mode: typing.Union[str, int] = None
    ''' Method used for determining the scaling of the X and Z axes of the bones * ``NONE`` None, Don't scale the X and Z axes (Default). * ``BONE_ORIGINAL`` Bone Original, Use the original scaling of the bones. * ``INVERSE_PRESERVE`` Inverse Scale, Scale of the X and Z axes is the inverse of the Y-Scale. * ``VOLUME_PRESERVE`` Volume Preservation, Scale of the X and Z axes are adjusted to preserve the volume of the bones.

    :type: typing.Union[str, int]
    '''


class StretchToConstraint(Constraint, bpy_struct):
    ''' Stretch to meet the target object
    '''

    bulge: float = None
    ''' Factor between volume variation and stretching

    :type: float
    '''

    bulge_max: float = None
    ''' Maximum volume stretching factor

    :type: float
    '''

    bulge_min: float = None
    ''' Minimum volume stretching factor

    :type: float
    '''

    bulge_smooth: float = None
    ''' Strength of volume stretching clamping

    :type: float
    '''

    head_tail: float = None
    ''' Target along length of bone: Head=0, Tail=1

    :type: float
    '''

    keep_axis: typing.Union[str, int] = None
    ''' Axis to maintain during stretch * ``PLANE_X`` X, Keep X Axis. * ``PLANE_Z`` Z, Keep Z Axis.

    :type: typing.Union[str, int]
    '''

    rest_length: float = None
    ''' Length at rest position

    :type: float
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    ''' Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    '''

    use_bulge_max: bool = None
    ''' Use upper limit for volume variation

    :type: bool
    '''

    use_bulge_min: bool = None
    ''' Use lower limit for volume variation

    :type: bool
    '''

    volume: typing.Union[str, int] = None
    ''' Maintain the object's volume as it stretches

    :type: typing.Union[str, int]
    '''


class TrackToConstraint(Constraint, bpy_struct):
    ''' Aim the constrained object toward the target
    '''

    head_tail: float = None
    ''' Target along length of bone: Head=0, Tail=1

    :type: float
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    track_axis: typing.Union[str, int] = None
    ''' Axis that points to the target object

    :type: typing.Union[str, int]
    '''

    up_axis: typing.Union[str, int] = None
    ''' Axis that points upward

    :type: typing.Union[str, int]
    '''

    use_bbone_shape: bool = None
    ''' Follow shape of B-Bone segments when calculating Head/Tail position

    :type: bool
    '''

    use_target_z: bool = None
    ''' Target's Z axis, not World Z axis, will constraint the Up direction

    :type: bool
    '''


class TransformCacheConstraint(Constraint, bpy_struct):
    ''' Look up transformation from an external file
    '''

    cache_file: 'CacheFile' = None
    ''' 

    :type: 'CacheFile'
    '''

    object_path: typing.Union[str, typing.Any] = None
    ''' Path to the object in the Alembic archive used to lookup the transform matrix

    :type: typing.Union[str, typing.Any]
    '''


class TransformConstraint(Constraint, bpy_struct):
    ''' Map transformations of the target to the object
    '''

    from_max_x: float = None
    ''' Top range of X axis source motion

    :type: float
    '''

    from_max_x_rot: float = None
    ''' Top range of X axis source motion

    :type: float
    '''

    from_max_x_scale: float = None
    ''' Top range of X axis source motion

    :type: float
    '''

    from_max_y: float = None
    ''' Top range of Y axis source motion

    :type: float
    '''

    from_max_y_rot: float = None
    ''' Top range of Y axis source motion

    :type: float
    '''

    from_max_y_scale: float = None
    ''' Top range of Y axis source motion

    :type: float
    '''

    from_max_z: float = None
    ''' Top range of Z axis source motion

    :type: float
    '''

    from_max_z_rot: float = None
    ''' Top range of Z axis source motion

    :type: float
    '''

    from_max_z_scale: float = None
    ''' Top range of Z axis source motion

    :type: float
    '''

    from_min_x: float = None
    ''' Bottom range of X axis source motion

    :type: float
    '''

    from_min_x_rot: float = None
    ''' Bottom range of X axis source motion

    :type: float
    '''

    from_min_x_scale: float = None
    ''' Bottom range of X axis source motion

    :type: float
    '''

    from_min_y: float = None
    ''' Bottom range of Y axis source motion

    :type: float
    '''

    from_min_y_rot: float = None
    ''' Bottom range of Y axis source motion

    :type: float
    '''

    from_min_y_scale: float = None
    ''' Bottom range of Y axis source motion

    :type: float
    '''

    from_min_z: float = None
    ''' Bottom range of Z axis source motion

    :type: float
    '''

    from_min_z_rot: float = None
    ''' Bottom range of Z axis source motion

    :type: float
    '''

    from_min_z_scale: float = None
    ''' Bottom range of Z axis source motion

    :type: float
    '''

    map_from: typing.Union[str, int] = None
    ''' The transformation type to use from the target

    :type: typing.Union[str, int]
    '''

    map_to: typing.Union[str, int] = None
    ''' The transformation type to affect of the constrained object

    :type: typing.Union[str, int]
    '''

    map_to_x_from: typing.Union[str, int] = None
    ''' The source axis constrained object's X axis uses

    :type: typing.Union[str, int]
    '''

    map_to_y_from: typing.Union[str, int] = None
    ''' The source axis constrained object's Y axis uses

    :type: typing.Union[str, int]
    '''

    map_to_z_from: typing.Union[str, int] = None
    ''' The source axis constrained object's Z axis uses

    :type: typing.Union[str, int]
    '''

    subtarget: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    target: 'Object' = None
    ''' Target Object

    :type: 'Object'
    '''

    to_max_x: float = None
    ''' Top range of X axis destination motion

    :type: float
    '''

    to_max_x_rot: float = None
    ''' Top range of X axis destination motion

    :type: float
    '''

    to_max_x_scale: float = None
    ''' Top range of X axis destination motion

    :type: float
    '''

    to_max_y: float = None
    ''' Top range of Y axis destination motion

    :type: float
    '''

    to_max_y_rot: float = None
    ''' Top range of Y axis destination motion

    :type: float
    '''

    to_max_y_scale: float = None
    ''' Top range of Y axis destination motion

    :type: float
    '''

    to_max_z: float = None
    ''' Top range of Z axis destination motion

    :type: float
    '''

    to_max_z_rot: float = None
    ''' Top range of Z axis destination motion

    :type: float
    '''

    to_max_z_scale: float = None
    ''' Top range of Z axis destination motion

    :type: float
    '''

    to_min_x: float = None
    ''' Bottom range of X axis destination motion

    :type: float
    '''

    to_min_x_rot: float = None
    ''' Bottom range of X axis destination motion

    :type: float
    '''

    to_min_x_scale: float = None
    ''' Bottom range of X axis destination motion

    :type: float
    '''

    to_min_y: float = None
    ''' Bottom range of Y axis destination motion

    :type: float
    '''

    to_min_y_rot: float = None
    ''' Bottom range of Y axis destination motion

    :type: float
    '''

    to_min_y_scale: float = None
    ''' Bottom range of Y axis destination motion

    :type: float
    '''

    to_min_z: float = None
    ''' Bottom range of Z axis destination motion

    :type: float
    '''

    to_min_z_rot: float = None
    ''' Bottom range of Z axis destination motion

    :type: float
    '''

    to_min_z_scale: float = None
    ''' Bottom range of Z axis destination motion

    :type: float
    '''

    use_motion_extrapolate: bool = None
    ''' Extrapolate ranges

    :type: bool
    '''


class AndController(Controller, bpy_struct):
    ''' Controller passing on events based on a logical AND operation
    '''

    pass


class ExpressionController(Controller, bpy_struct):
    ''' Controller passing on events based on the evaluation of an expression
    '''

    expression: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''


class NandController(Controller, bpy_struct):
    ''' Controller passing on events based on a logical NAND operation
    '''

    pass


class NorController(Controller, bpy_struct):
    ''' Controller passing on events based on a logical NOR operation
    '''

    pass


class OrController(Controller, bpy_struct):
    ''' Controller passing on events based on a logical OR operation
    '''

    pass


class PythonController(Controller, bpy_struct):
    ''' Controller executing a python script
    '''

    mode: typing.Union[str, int] = None
    ''' Python script type (textblock or module - faster)

    :type: typing.Union[str, int]
    '''

    module: typing.Union[str, typing.Any] = None
    ''' Module name and function to run, e.g. "someModule.main" (internal texts and external python files can be used)

    :type: typing.Union[str, typing.Any]
    '''

    text: 'Text' = None
    ''' Text data-block with the python script

    :type: 'Text'
    '''

    use_debug: bool = None
    ''' Continuously reload the module from disk for editing external modules without restarting

    :type: bool
    '''


class XnorController(Controller, bpy_struct):
    ''' Controller passing on events based on a logical XNOR operation
    '''

    pass


class XorController(Controller, bpy_struct):
    ''' Controller passing on events based on a logical XOR operation
    '''

    pass


class CurveMapPoints(bpy_prop_collection[CurveMapPoint], bpy_struct):
    ''' Collection of Curve Map Points
    '''

    def new(self, position: typing.Optional[float],
            value: typing.Optional[float]) -> 'CurveMapPoint':
        ''' Add point to CurveMap

        :param position: Position, Position to add point
        :type position: typing.Optional[float]
        :param value: Value, Value of point
        :type value: typing.Optional[float]
        :rtype: 'CurveMapPoint'
        :return: New point
        '''
        pass

    def remove(self, point: 'CurveMapPoint'):
        ''' Delete point from CurveMap

        :param point: PointElement to remove
        :type point: 'CurveMapPoint'
        '''
        pass


class ChannelDriverVariables(bpy_prop_collection[DriverVariable], bpy_struct):
    ''' Collection of channel driver Variables
    '''

    def new(self) -> 'DriverVariable':
        ''' Add a new variable for the driver

        :rtype: 'DriverVariable'
        :return: Newly created Driver Variable
        '''
        pass

    def remove(self, variable: 'DriverVariable'):
        ''' Remove an existing variable from the driver

        :param variable: Variable to remove from the driver
        :type variable: 'DriverVariable'
        '''
        pass


class DynamicPaintSurfaces(bpy_prop_collection[DynamicPaintSurface],
                           bpy_struct):
    ''' Collection of Dynamic Paint Canvas surfaces
    '''

    active: 'DynamicPaintSurface' = None
    ''' Active Dynamic Paint surface being displayed

    :type: 'DynamicPaintSurface'
    '''

    active_index: int = None
    ''' 

    :type: int
    '''


class ArmatureEditBones(bpy_prop_collection[EditBone], bpy_struct):
    ''' Collection of armature edit bones
    '''

    active: 'EditBone' = None
    ''' Armatures active edit bone

    :type: 'EditBone'
    '''

    def new(self, name: typing.Union[str, typing.Any]) -> 'EditBone':
        ''' Add a new bone

        :param name: New name for the bone
        :type name: typing.Union[str, typing.Any]
        :rtype: 'EditBone'
        :return: Newly created edit bone
        '''
        pass

    def remove(self, bone: 'EditBone'):
        ''' Remove an existing bone from the armature

        :param bone: EditBone to remove
        :type bone: 'EditBone'
        '''
        pass


class ActionFCurves(bpy_prop_collection[FCurve], bpy_struct):
    ''' Collection of action F-Curves
    '''

    def new(self,
            data_path: typing.Union[str, typing.Any],
            index: typing.Optional[typing.Any] = 0,
            action_group: typing.Union[str, typing.Any] = "") -> 'FCurve':
        ''' Add an F-Curve to the action

        :param data_path: Data Path, F-Curve data path to use
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :param action_group: Action Group, Acton group to add this F-Curve into
        :type action_group: typing.Union[str, typing.Any]
        :rtype: 'FCurve'
        :return: Newly created F-Curve
        '''
        pass

    def find(self,
             data_path: typing.Union[str, typing.Any],
             index: typing.Optional[typing.Any] = 0) -> 'FCurve':
        ''' Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the action.

        :param data_path: Data Path, F-Curve data path
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        '''
        pass

    def remove(self, fcurve: 'FCurve'):
        ''' Remove action group

        :param fcurve: F-Curve to remove
        :type fcurve: 'FCurve'
        '''
        pass


class AnimDataDrivers(bpy_prop_collection[FCurve], bpy_struct):
    ''' Collection of Driver F-Curves
    '''

    def from_existing(
            self, src_driver: typing.Optional['FCurve'] = None) -> 'FCurve':
        ''' Add a new driver given an existing one

        :param src_driver: Existing Driver F-Curve to use as template for a new one
        :type src_driver: typing.Optional['FCurve']
        :rtype: 'FCurve'
        :return: New Driver F-Curve
        '''
        pass

    def find(self,
             data_path: typing.Union[str, typing.Any],
             index: typing.Optional[typing.Any] = 0) -> 'FCurve':
        ''' Find a driver F-Curve. Note that this function performs a linear scan of all driver F-Curves.

        :param data_path: Data Path, F-Curve data path
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        '''
        pass


class NlaStripFCurves(bpy_prop_collection[FCurve], bpy_struct):
    ''' Collection of NLA strip F-Curves
    '''

    def find(self,
             data_path: typing.Union[str, typing.Any],
             index: typing.Optional[typing.Any] = 0) -> 'FCurve':
        ''' Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the NLA strip.

        :param data_path: Data Path, F-Curve data path
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, Array index
        :type index: typing.Optional[typing.Any]
        :rtype: 'FCurve'
        :return: The found F-Curve, or None if it doesn't exist
        '''
        pass


class FCurveModifiers(bpy_prop_collection[FModifier], bpy_struct):
    ''' Collection of F-Curve Modifiers
    '''

    active: 'FModifier' = None
    ''' Active F-Curve Modifier

    :type: 'FModifier'
    '''

    def new(self,
            type: typing.Optional[typing.Union[str, int]]) -> 'FModifier':
        ''' Add a constraint to this object

        :param type: Constraint type to add * ``NULL`` Invalid. * ``GENERATOR`` Generator, Generate a curve using a factorized or expanded polynomial. * ``FNGENERATOR`` Built-In Function, Generate a curve using standard math functions such as sin and cos. * ``ENVELOPE`` Envelope, Reshape F-Curve values - e.g. change amplitude of movements. * ``CYCLES`` Cycles, Cyclic extend/repeat keyframe sequence. * ``NOISE`` Noise, Add pseudo-random noise on top of F-Curves. * ``LIMITS`` Limits, Restrict maximum and minimum values of F-Curve. * ``STEPPED`` Stepped Interpolation, Snap values to nearest grid-step - e.g. for a stop-motion look.
        :type type: typing.Optional[typing.Union[str, int]]
        :rtype: 'FModifier'
        :return: New fmodifier
        '''
        pass

    def remove(self, modifier: 'FModifier'):
        ''' Remove a modifier from this F-Curve

        :param modifier: Removed modifier
        :type modifier: 'FModifier'
        '''
        pass


class FModifierCycles(FModifier, bpy_struct):
    ''' Repeat the values of the modified F-Curve
    '''

    cycles_after: int = None
    ''' Maximum number of cycles to allow after last keyframe (0 = infinite)

    :type: int
    '''

    cycles_before: int = None
    ''' Maximum number of cycles to allow before first keyframe (0 = infinite)

    :type: int
    '''

    mode_after: typing.Union[str, int] = None
    ''' Cycling mode to use after last keyframe * ``NONE`` No Cycles, Don't do anything. * ``REPEAT`` Repeat Motion, Repeat keyframe range as-is. * ``REPEAT_OFFSET`` Repeat with Offset, Repeat keyframe range, but with offset based on gradient between start and end values. * ``MIRROR`` Repeat Mirrored, Alternate between forward and reverse playback of keyframe range.

    :type: typing.Union[str, int]
    '''

    mode_before: typing.Union[str, int] = None
    ''' Cycling mode to use before first keyframe * ``NONE`` No Cycles, Don't do anything. * ``REPEAT`` Repeat Motion, Repeat keyframe range as-is. * ``REPEAT_OFFSET`` Repeat with Offset, Repeat keyframe range, but with offset based on gradient between start and end values. * ``MIRROR`` Repeat Mirrored, Alternate between forward and reverse playback of keyframe range.

    :type: typing.Union[str, int]
    '''


class FModifierEnvelope(FModifier, bpy_struct):
    ''' Scale the values of the modified F-Curve
    '''

    control_points: 'FModifierEnvelopeControlPoints' = None
    ''' Control points defining the shape of the envelope

    :type: 'FModifierEnvelopeControlPoints'
    '''

    default_max: float = None
    ''' Upper distance from Reference Value for 1:1 default influence

    :type: float
    '''

    default_min: float = None
    ''' Lower distance from Reference Value for 1:1 default influence

    :type: float
    '''

    reference_value: float = None
    ''' Value that envelope's influence is centered around / based on

    :type: float
    '''


class FModifierFunctionGenerator(FModifier, bpy_struct):
    ''' Generate values using a Built-In Function
    '''

    amplitude: float = None
    ''' Scale factor determining the maximum/minimum values

    :type: float
    '''

    function_type: typing.Union[str, int] = None
    ''' Type of built-in function to use * ``SIN`` Sine. * ``COS`` Cosine. * ``TAN`` Tangent. * ``SQRT`` Square Root. * ``LN`` Natural Logarithm. * ``SINC`` Normalized Sine, sin(x) / x.

    :type: typing.Union[str, int]
    '''

    phase_multiplier: float = None
    ''' Scale factor determining the 'speed' of the function

    :type: float
    '''

    phase_offset: float = None
    ''' Constant factor to offset time by for function

    :type: float
    '''

    use_additive: bool = None
    ''' Values generated by this modifier are applied on top of the existing values instead of overwriting them

    :type: bool
    '''

    value_offset: float = None
    ''' Constant factor to offset values by

    :type: float
    '''


class FModifierGenerator(FModifier, bpy_struct):
    ''' Deterministically generate values for the modified F-Curve
    '''

    coefficients: bpy_prop_array[float] = None
    ''' Coefficients for 'x' (starting from lowest power of x^0)

    :type: bpy_prop_array[float]
    '''

    mode: typing.Union[str, int] = None
    ''' Type of generator to use

    :type: typing.Union[str, int]
    '''

    poly_order: int = None
    ''' The highest power of 'x' for this polynomial (number of coefficients - 1)

    :type: int
    '''

    use_additive: bool = None
    ''' Values generated by this modifier are applied on top of the existing values instead of overwriting them

    :type: bool
    '''


class FModifierLimits(FModifier, bpy_struct):
    ''' Limit the time/value ranges of the modified F-Curve
    '''

    max_x: float = None
    ''' Highest X value to allow

    :type: float
    '''

    max_y: float = None
    ''' Highest Y value to allow

    :type: float
    '''

    min_x: float = None
    ''' Lowest X value to allow

    :type: float
    '''

    min_y: float = None
    ''' Lowest Y value to allow

    :type: float
    '''

    use_max_x: bool = None
    ''' Use the maximum X value

    :type: bool
    '''

    use_max_y: bool = None
    ''' Use the maximum Y value

    :type: bool
    '''

    use_min_x: bool = None
    ''' Use the minimum X value

    :type: bool
    '''

    use_min_y: bool = None
    ''' Use the minimum Y value

    :type: bool
    '''


class FModifierNoise(FModifier, bpy_struct):
    ''' Give randomness to the modified F-Curve
    '''

    blend_type: typing.Union[str, int] = None
    ''' Method of modifying the existing F-Curve

    :type: typing.Union[str, int]
    '''

    depth: int = None
    ''' Amount of fine level detail present in the noise

    :type: int
    '''

    offset: float = None
    ''' Time offset for the noise effect

    :type: float
    '''

    phase: float = None
    ''' A random seed for the noise effect

    :type: float
    '''

    scale: float = None
    ''' Scaling (in time) of the noise

    :type: float
    '''

    strength: float = None
    ''' Amplitude of the noise - the amount that it modifies the underlying curve

    :type: float
    '''


class FModifierPython(FModifier, bpy_struct):
    ''' Perform user-defined operation on the modified F-Curve
    '''

    pass


class FModifierStepped(FModifier, bpy_struct):
    ''' Hold each interpolated value from the F-Curve for several frames without changing the timing
    '''

    frame_end: float = None
    ''' Frame that modifier's influence ends (if applicable)

    :type: float
    '''

    frame_offset: float = None
    ''' Reference number of frames before frames get held (use to get hold for '1-3' vs '5-7' holding patterns)

    :type: float
    '''

    frame_start: float = None
    ''' Frame that modifier's influence starts (if applicable)

    :type: float
    '''

    frame_step: float = None
    ''' Number of frames to hold each value

    :type: float
    '''

    use_frame_end: bool = None
    ''' Restrict modifier to only act before its 'end' frame

    :type: bool
    '''

    use_frame_start: bool = None
    ''' Restrict modifier to only act after its 'start' frame

    :type: bool
    '''


class FModifierEnvelopeControlPoints(
        bpy_prop_collection[FModifierEnvelopeControlPoint], bpy_struct):
    ''' Control points defining the shape of the envelope
    '''

    def add(self,
            frame: typing.Optional[float]) -> 'FModifierEnvelopeControlPoint':
        ''' Add a control point to a FModifierEnvelope

        :param frame: Frame to add this control-point
        :type frame: typing.Optional[float]
        :rtype: 'FModifierEnvelopeControlPoint'
        :return: Newly created control-point
        '''
        pass

    def remove(self, point: 'FModifierEnvelopeControlPoint'):
        ''' Remove a control-point from an FModifierEnvelope

        :param point: Control-point to remove
        :type point: 'FModifierEnvelopeControlPoint'
        '''
        pass


class ControlFluidSettings(FluidSettings, bpy_struct):
    ''' Fluid simulation settings for objects controlling the motion of fluid in the simulation
    '''

    attraction_radius: float = None
    ''' Force field radius around the control object

    :type: float
    '''

    attraction_strength: float = None
    ''' Force strength for directional attraction towards the control object

    :type: float
    '''

    end_time: float = None
    ''' Time when the control particles are deactivated

    :type: float
    '''

    quality: float = None
    ''' Quality which is used for object sampling (higher = better but slower)

    :type: float
    '''

    start_time: float = None
    ''' Time when the control particles are activated

    :type: float
    '''

    use: bool = None
    ''' Object contributes to the fluid simulation

    :type: bool
    '''

    use_reverse_frames: bool = None
    ''' Reverse control object movement

    :type: bool
    '''

    velocity_radius: float = None
    ''' Force field radius around the control object

    :type: float
    '''

    velocity_strength: float = None
    ''' Force strength of how much of the control object's velocity is influencing the fluid velocity

    :type: float
    '''


class DomainFluidSettings(FluidSettings, bpy_struct):
    ''' Fluid simulation settings for the domain of a fluid simulation
    '''

    compressibility: float = None
    ''' Allowed compressibility due to gravitational force for standing fluid (directly affects simulation step size)

    :type: float
    '''

    end_time: float = None
    ''' Simulation time of the last blender frame (in seconds)

    :type: float
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Directory (and/or filename prefix) to store baked fluid simulation files in

    :type: typing.Union[str, typing.Any]
    '''

    fluid_mesh_vertices: bpy_prop_collection['FluidVertexVelocity'] = None
    ''' Vertices of the fluid mesh generated by simulation

    :type: bpy_prop_collection['FluidVertexVelocity']
    '''

    frame_offset: int = None
    ''' Offset when reading baked cache

    :type: int
    '''

    generate_particles: float = None
    ''' Amount of particles to generate (0=off, 1=normal, >1=more)

    :type: float
    '''

    gravity: bpy_prop_array[float] = None
    ''' Gravity in X, Y and Z direction

    :type: bpy_prop_array[float]
    '''

    grid_levels: int = None
    ''' Number of coarsened grids to use (-1 for automatic)

    :type: int
    '''

    memory_estimate: typing.Union[str, typing.Any] = None
    ''' Estimated amount of memory needed for baking the domain

    :type: typing.Union[str, typing.Any]
    '''

    partial_slip_factor: float = None
    ''' Amount of mixing between no- and free-slip, 0 is no slip and 1 is free slip

    :type: float
    '''

    preview_resolution: int = None
    ''' Preview resolution in X,Y and Z direction

    :type: int
    '''

    render_display_mode: typing.Union[str, int] = None
    ''' How to display the mesh for rendering * ``GEOMETRY`` Geometry, Display geometry. * ``PREVIEW`` Preview, Display preview quality results. * ``FINAL`` Final, Display final quality results.

    :type: typing.Union[str, int]
    '''

    resolution: int = None
    ''' Domain resolution in X,Y and Z direction

    :type: int
    '''

    simulation_rate: float = None
    ''' Fluid motion rate (0 = stationary, 1 = normal speed)

    :type: float
    '''

    simulation_scale: float = None
    ''' Size of the simulation domain in meters

    :type: float
    '''

    slip_type: typing.Union[str, int] = None
    ''' * ``NOSLIP`` No Slip, Obstacle causes zero normal and tangential velocity (=sticky), default for all (only option for moving objects). * ``PARTIALSLIP`` Partial Slip, Mix between no-slip and free-slip (non moving objects only!). * ``FREESLIP`` Free Slip, Obstacle only causes zero normal velocity (=not sticky, non moving objects only!).

    :type: typing.Union[str, int]
    '''

    start_time: float = None
    ''' Simulation time of the first blender frame (in seconds)

    :type: float
    '''

    surface_smooth: float = None
    ''' Amount of surface smoothing (a value of 0 is off, 1 is normal smoothing and more than 1 is extra smoothing)

    :type: float
    '''

    surface_subdivisions: int = None
    ''' Number of isosurface subdivisions (this is necessary for the inclusion of particles into the surface generation - WARNING: can lead to longer computation times !)

    :type: int
    '''

    threads: int = None
    ''' Override number of threads for the simulation, 0 is automatic

    :type: int
    '''

    tracer_particles: int = None
    ''' Number of tracer particles to generate

    :type: int
    '''

    use_reverse_frames: bool = None
    ''' Reverse fluid frames

    :type: bool
    '''

    use_speed_vectors: bool = None
    ''' Generate speed vectors for vector blur

    :type: bool
    '''

    use_surface_noobs: bool = None
    ''' Removes the air gap between fluid surface and obstacles - WARNING: Can result in a dissolving surface in other areas

    :type: bool
    '''

    use_time_override: bool = None
    ''' Use a custom start and end time (in seconds) instead of the scene's timeline

    :type: bool
    '''

    viewport_display_mode: typing.Union[str, int] = None
    ''' How to display the mesh in the viewport * ``GEOMETRY`` Geometry, Display geometry. * ``PREVIEW`` Preview, Display preview quality results. * ``FINAL`` Final, Display final quality results.

    :type: typing.Union[str, int]
    '''

    viscosity_base: float = None
    ''' Viscosity setting: value that is multiplied by 10 to the power of (exponent*-1)

    :type: float
    '''

    viscosity_exponent: int = None
    ''' Negative exponent for the viscosity value (to simplify entering small values e.g. 5*10^-6)

    :type: int
    '''


class FluidFluidSettings(FluidSettings, bpy_struct):
    ''' Fluid simulation settings for the fluid in the simulation
    '''

    initial_velocity: bpy_prop_array[float] = None
    ''' Initial velocity of fluid

    :type: bpy_prop_array[float]
    '''

    use: bool = None
    ''' Object contributes to the fluid simulation

    :type: bool
    '''

    use_animated_mesh: bool = None
    ''' Export this mesh as an animated one (slower and enforces No Slip, only use if really necessary [e.g. armatures or parented objects], animated pos/rot/scale F-Curves do not require it)

    :type: bool
    '''

    volume_initialization: typing.Union[str, int] = None
    ''' Volume initialization type (WARNING: complex volumes might require too much memory and break simulation) * ``VOLUME`` Volume, Use only the inner volume of the mesh. * ``SHELL`` Shell, Use only the outer shell of the mesh. * ``BOTH`` Both, Use both the inner volume and the outer shell of the mesh.

    :type: typing.Union[str, int]
    '''


class InflowFluidSettings(FluidSettings, bpy_struct):
    ''' Fluid simulation settings for objects adding fluids in the simulation
    '''

    inflow_velocity: bpy_prop_array[float] = None
    ''' Initial velocity of fluid

    :type: bpy_prop_array[float]
    '''

    use: bool = None
    ''' Object contributes to the fluid simulation

    :type: bool
    '''

    use_animated_mesh: bool = None
    ''' Export this mesh as an animated one (slower and enforces No Slip, only use if really necessary [e.g. armatures or parented objects], animated pos/rot/scale F-Curves do not require it)

    :type: bool
    '''

    use_local_coords: bool = None
    ''' Use local coordinates for inflow (e.g. for rotating objects)

    :type: bool
    '''

    volume_initialization: typing.Union[str, int] = None
    ''' Volume initialization type (WARNING: complex volumes might require too much memory and break simulation) * ``VOLUME`` Volume, Use only the inner volume of the mesh. * ``SHELL`` Shell, Use only the outer shell of the mesh. * ``BOTH`` Both, Use both the inner volume and the outer shell of the mesh.

    :type: typing.Union[str, int]
    '''


class ObstacleFluidSettings(FluidSettings, bpy_struct):
    ''' Fluid simulation settings for obstacles in the simulation
    '''

    impact_factor: float = None
    ''' This is an unphysical value for moving objects - it controls the impact an obstacle has on the fluid, =0 behaves a bit like outflow (deleting fluid), =1 is default, while >1 results in high forces (can be used to tweak total mass)

    :type: float
    '''

    partial_slip_factor: float = None
    ''' Amount of mixing between no- and free-slip, 0 is no slip and 1 is free slip

    :type: float
    '''

    slip_type: typing.Union[str, int] = None
    ''' * ``NOSLIP`` No Slip, Obstacle causes zero normal and tangential velocity (=sticky), default for all (only option for moving objects). * ``PARTIALSLIP`` Partial Slip, Mix between no-slip and free-slip (non moving objects only!). * ``FREESLIP`` Free Slip, Obstacle only causes zero normal velocity (=not sticky, non moving objects only!).

    :type: typing.Union[str, int]
    '''

    use: bool = None
    ''' Object contributes to the fluid simulation

    :type: bool
    '''

    use_animated_mesh: bool = None
    ''' Export this mesh as an animated one (slower and enforces No Slip, only use if really necessary [e.g. armatures or parented objects], animated pos/rot/scale F-Curves do not require it)

    :type: bool
    '''

    volume_initialization: typing.Union[str, int] = None
    ''' Volume initialization type (WARNING: complex volumes might require too much memory and break simulation) * ``VOLUME`` Volume, Use only the inner volume of the mesh. * ``SHELL`` Shell, Use only the outer shell of the mesh. * ``BOTH`` Both, Use both the inner volume and the outer shell of the mesh.

    :type: typing.Union[str, int]
    '''


class OutflowFluidSettings(FluidSettings, bpy_struct):
    ''' Fluid simulation settings for objects removing fluids from the simulation
    '''

    use: bool = None
    ''' Object contributes to the fluid simulation

    :type: bool
    '''

    use_animated_mesh: bool = None
    ''' Export this mesh as an animated one (slower and enforces No Slip, only use if really necessary [e.g. armatures or parented objects], animated pos/rot/scale F-Curves do not require it)

    :type: bool
    '''

    volume_initialization: typing.Union[str, int] = None
    ''' Volume initialization type (WARNING: complex volumes might require too much memory and break simulation) * ``VOLUME`` Volume, Use only the inner volume of the mesh. * ``SHELL`` Shell, Use only the outer shell of the mesh. * ``BOTH`` Both, Use both the inner volume and the outer shell of the mesh.

    :type: typing.Union[str, int]
    '''


class ParticleFluidSettings(FluidSettings, bpy_struct):
    ''' Fluid simulation settings for objects storing fluid particles generated by the simulation
    '''

    alpha_influence: float = None
    ''' Amount of particle alpha change, inverse of size influence: 0=off (all same alpha), 1=full (larger particles get lower alphas, smaller ones higher values)

    :type: float
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Directory (and/or filename prefix) to store and load particles from

    :type: typing.Union[str, typing.Any]
    '''

    particle_influence: float = None
    ''' Amount of particle size scaling: 0=off (all same size), 1=full (range 0.2-2.0), >1=stronger

    :type: float
    '''

    show_tracer: bool = None
    ''' Show tracer particles

    :type: bool
    '''

    use_drops: bool = None
    ''' Show drop particles

    :type: bool
    '''

    use_floats: bool = None
    ''' Show floating foam particles

    :type: bool
    '''


class Linesets(bpy_prop_collection[FreestyleLineSet], bpy_struct):
    ''' Line sets for associating lines and style parameters
    '''

    active: 'FreestyleLineSet' = None
    ''' Active line set being displayed

    :type: 'FreestyleLineSet'
    '''

    active_index: int = None
    ''' Index of active line set slot

    :type: int
    '''

    def new(self, name: typing.Union[str, typing.Any]) -> 'FreestyleLineSet':
        ''' Add a line set to scene render layer Freestyle settings

        :param name: New name for the line set (not unique)
        :type name: typing.Union[str, typing.Any]
        :rtype: 'FreestyleLineSet'
        :return: Newly created line set
        '''
        pass

    def remove(self, lineset: 'FreestyleLineSet'):
        ''' Remove a line set from scene render layer Freestyle settings

        :param lineset: Line set to remove
        :type lineset: 'FreestyleLineSet'
        '''
        pass


class FreestyleModules(bpy_prop_collection[FreestyleModuleSettings],
                       bpy_struct):
    ''' A list of style modules (to be applied from top to bottom)
    '''

    def new(self) -> 'FreestyleModuleSettings':
        ''' Add a style module to scene render layer Freestyle settings

        :rtype: 'FreestyleModuleSettings'
        :return: Newly created style module
        '''
        pass

    def remove(self, module: 'FreestyleModuleSettings'):
        ''' Remove a style module from scene render layer Freestyle settings

        :param module: Style module to remove
        :type module: 'FreestyleModuleSettings'
        '''
        pass


class GreasePencilBrushes(bpy_prop_collection[GPencilBrush], bpy_struct):
    ''' Collection of grease pencil brushes
    '''

    active: 'GPencilBrush' = None
    ''' Current active brush

    :type: 'GPencilBrush'
    '''

    active_index: int = None
    ''' Index of active brush

    :type: int
    '''

    def new(self,
            name: typing.Union[str, typing.Any],
            set_active: typing.Optional[typing.Union[bool, typing.Any]] = False
            ) -> 'GPencilBrush':
        ''' Add a new grease pencil brush

        :param name: Name, Name of the brush
        :type name: typing.Union[str, typing.Any]
        :param set_active: Set Active, Set the newly created brush to the active brush
        :type set_active: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'GPencilBrush'
        :return: The newly created brush
        '''
        pass

    def remove(self, brush: 'GPencilBrush'):
        ''' Remove a grease pencil brush

        :param brush: The brush to remove
        :type brush: 'GPencilBrush'
        '''
        pass


class GPencilFrames(bpy_prop_collection[GPencilFrame], bpy_struct):
    ''' Collection of grease pencil frames
    '''

    def new(self, frame_number: typing.Optional[int]) -> 'GPencilFrame':
        ''' Add a new grease pencil frame

        :param frame_number: Frame Number, The frame on which this sketch appears
        :type frame_number: typing.Optional[int]
        :rtype: 'GPencilFrame'
        :return: The newly created frame
        '''
        pass

    def remove(self, frame: 'GPencilFrame'):
        ''' Remove a grease pencil frame

        :param frame: Frame, The frame to remove
        :type frame: 'GPencilFrame'
        '''
        pass

    def copy(self, source: 'GPencilFrame') -> 'GPencilFrame':
        ''' Copy a grease pencil frame

        :param source: Source, The source frame
        :type source: 'GPencilFrame'
        :rtype: 'GPencilFrame'
        :return: The newly copied frame
        '''
        pass


class GreasePencilLayers(bpy_prop_collection[GPencilLayer], bpy_struct):
    ''' Collection of grease pencil layers
    '''

    active: 'GPencilLayer' = None
    ''' Active grease pencil layer

    :type: 'GPencilLayer'
    '''

    active_index: int = None
    ''' Index of active grease pencil layer

    :type: int
    '''

    def new(self,
            name: typing.Union[str, typing.Any],
            set_active: typing.Optional[typing.Union[bool, typing.Any]] = False
            ) -> 'GPencilLayer':
        ''' Add a new grease pencil layer

        :param name: Name, Name of the layer
        :type name: typing.Union[str, typing.Any]
        :param set_active: Set Active, Set the newly created layer to the active layer
        :type set_active: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'GPencilLayer'
        :return: The newly created layer
        '''
        pass

    def remove(self, layer: 'GPencilLayer'):
        ''' Remove a grease pencil layer

        :param layer: The layer to remove
        :type layer: 'GPencilLayer'
        '''
        pass


class GreasePencilPalettes(bpy_prop_collection[GPencilPalette], bpy_struct):
    ''' Collection of grease pencil palettes
    '''

    active: 'GPencilPalette' = None
    ''' Current active palette

    :type: 'GPencilPalette'
    '''

    active_index: int = None
    ''' Index of active palette

    :type: int
    '''

    def new(self,
            name: typing.Union[str, typing.Any],
            set_active: typing.Optional[typing.Union[bool, typing.Any]] = False
            ) -> 'GPencilPalette':
        ''' Add a new grease pencil palette

        :param name: Name, Name of the palette
        :type name: typing.Union[str, typing.Any]
        :param set_active: Set Active, Activate the newly created palette
        :type set_active: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'GPencilPalette'
        :return: The newly created palette
        '''
        pass

    def remove(self, palette: 'GPencilPalette'):
        ''' Remove a grease pencil palette

        :param palette: The palette to remove
        :type palette: 'GPencilPalette'
        '''
        pass


class GPencilPaletteColors(bpy_prop_collection[GPencilPaletteColor],
                           bpy_struct):
    ''' Collection of palette colors
    '''

    active: 'GPencilPaletteColor' = None
    ''' Current active color

    :type: 'GPencilPaletteColor'
    '''

    active_index: int = None
    ''' Index of active palette color

    :type: int
    '''

    def new(self) -> 'GPencilPaletteColor':
        ''' Add a new color to the palette

        :rtype: 'GPencilPaletteColor'
        :return: The newly created color
        '''
        pass

    def remove(self, color: 'GPencilPaletteColor'):
        ''' Remove a color from the palette

        :param color: The color to remove
        :type color: 'GPencilPaletteColor'
        '''
        pass


class GPencilStrokes(bpy_prop_collection[GPencilStroke], bpy_struct):
    ''' Collection of grease pencil stroke
    '''

    def new(self,
            colorname: typing.Union[str, typing.Any] = "") -> 'GPencilStroke':
        ''' Add a new grease pencil stroke

        :param colorname: Color, Name of the color
        :type colorname: typing.Union[str, typing.Any]
        :rtype: 'GPencilStroke'
        :return: The newly created stroke
        '''
        pass

    def remove(self, stroke: 'GPencilStroke'):
        ''' Remove a grease pencil stroke

        :param stroke: Stroke, The stroke to remove
        :type stroke: 'GPencilStroke'
        '''
        pass


class GPencilStrokePoints(bpy_prop_collection[GPencilStrokePoint], bpy_struct):
    ''' Collection of grease pencil stroke points
    '''

    def add(self,
            count: typing.Optional[typing.Any] = 1,
            pressure: typing.Optional[typing.Any] = 1.0,
            strength: typing.Optional[typing.Any] = 1.0):
        ''' Add a new grease pencil stroke point

        :param count: Number, Number of points to add to the stroke
        :type count: typing.Optional[typing.Any]
        :param pressure: Pressure, Pressure for newly created points
        :type pressure: typing.Optional[typing.Any]
        :param strength: Strength, Color intensity (alpha factor) for newly created points
        :type strength: typing.Optional[typing.Any]
        '''
        pass

    def pop(self, index: typing.Optional[typing.Any] = -1):
        ''' Remove a grease pencil stroke point

        :param index: Index, point index
        :type index: typing.Optional[typing.Any]
        '''
        pass


class GameBooleanProperty(GameProperty, bpy_struct):
    ''' Game engine user defined Boolean property
    '''

    value: bool = None
    ''' Property value

    :type: bool
    '''


class GameFloatProperty(GameProperty, bpy_struct):
    ''' Game engine user defined floating point number property
    '''

    value: float = None
    ''' Property value

    :type: float
    '''


class GameIntProperty(GameProperty, bpy_struct):
    ''' Game engine user defined integer number property
    '''

    value: int = None
    ''' Property value

    :type: int
    '''


class GameStringProperty(GameProperty, bpy_struct):
    ''' Game engine user defined text string property
    '''

    value: typing.Union[str, typing.Any] = None
    ''' Property value

    :type: typing.Union[str, typing.Any]
    '''


class GameTimerProperty(GameProperty, bpy_struct):
    ''' Game engine user defined timer property
    '''

    value: float = None
    ''' Property value

    :type: float
    '''


class Action(ID, bpy_struct):
    ''' A collection of F-Curves for animation
    '''

    fcurves: 'ActionFCurves' = None
    ''' The individual F-Curves that make up the action

    :type: 'ActionFCurves'
    '''

    frame_range: bpy_prop_array[float] = None
    ''' The final frame range of all F-Curves within this action

    :type: bpy_prop_array[float]
    '''

    groups: 'ActionGroups' = None
    ''' Convenient groupings of F-Curves

    :type: 'ActionGroups'
    '''

    id_root: typing.Union[str, int] = None
    ''' Type of ID block that action can be used on - DO NOT CHANGE UNLESS YOU KNOW WHAT YOU ARE DOING

    :type: typing.Union[str, int]
    '''

    pose_markers: 'ActionPoseMarkers' = None
    ''' Markers specific to this action, for labeling poses

    :type: 'ActionPoseMarkers'
    '''


class Armature(ID, bpy_struct):
    ''' Armature data-block containing a hierarchy of bones, usually used for rigging characters
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    bones: 'ArmatureBones' = None
    ''' 

    :type: 'ArmatureBones'
    '''

    deform_method: typing.Union[str, int] = None
    ''' Vertex Deformer Method (Game Engine only) * ``BLENDER`` Blender, Use Blender's armature vertex deformation. * ``BGE_CPU`` BGE, Use vertex deformation code optimized for the BGE.

    :type: typing.Union[str, int]
    '''

    draw_type: typing.Union[str, int] = None
    ''' * ``OCTAHEDRAL`` Octahedral, Display bones as octahedral shape (default). * ``STICK`` Stick, Display bones as simple 2D lines with dots. * ``BBONE`` B-Bone, Display bones as boxes, showing subdivision and B-Splines. * ``ENVELOPE`` Envelope, Display bones as extruded spheres, showing deformation influence volume. * ``WIRE`` Wire, Display bones as thin wires, showing subdivision and B-Splines.

    :type: typing.Union[str, int]
    '''

    edit_bones: 'ArmatureEditBones' = None
    ''' 

    :type: 'ArmatureEditBones'
    '''

    ghost_frame_end: int = None
    ''' End frame of range of Ghosts to display (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    ghost_frame_start: int = None
    ''' Starting frame of range of Ghosts to display (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    ghost_size: int = None
    ''' Frame step for Ghosts (not for 'On Keyframes' Onion-skinning method)

    :type: int
    '''

    ghost_step: int = None
    ''' Number of frame steps on either side of current frame to show as ghosts (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    '''

    ghost_type: typing.Union[str, int] = None
    ''' Method of Onion-skinning for active Action * ``CURRENT_FRAME`` Around Frame, Display Ghosts of poses within a fixed number of frames around the current frame. * ``RANGE`` In Range, Display Ghosts of poses within specified range. * ``KEYS`` On Keyframes, Display Ghosts of poses on Keyframes.

    :type: typing.Union[str, int]
    '''

    is_editmode: typing.Union[bool, typing.Any] = None
    ''' True when used in editmode

    :type: typing.Union[bool, typing.Any]
    '''

    layers: typing.List[bool] = None
    ''' Armature layer visibility

    :type: typing.List[bool]
    '''

    layers_protected: typing.List[bool] = None
    ''' Protected layers in Proxy Instances are restored to Proxy settings on file reload and undo

    :type: typing.List[bool]
    '''

    pose_position: typing.Union[str, int] = None
    ''' Show armature in binding pose or final posed state * ``POSE`` Pose Position, Show armature in posed state. * ``REST`` Rest Position, Show Armature in binding pose state (no posing possible).

    :type: typing.Union[str, int]
    '''

    show_axes: bool = None
    ''' Draw bone axes

    :type: bool
    '''

    show_bone_custom_shapes: bool = None
    ''' Draw bones with their custom shapes

    :type: bool
    '''

    show_group_colors: bool = None
    ''' Draw bone group colors

    :type: bool
    '''

    show_names: bool = None
    ''' Draw bone names

    :type: bool
    '''

    show_only_ghost_selected: bool = None
    ''' 

    :type: bool
    '''

    use_auto_ik: bool = None
    ''' Add temporary IK constraints while grabbing bones in Pose Mode

    :type: bool
    '''

    use_deform_delay: bool = None
    ''' Don't deform children when manipulating bones in Pose Mode

    :type: bool
    '''

    use_mirror_x: bool = None
    ''' Apply changes to matching bone on opposite side of X-Axis

    :type: bool
    '''

    def transform(self, matrix: typing.Optional[typing.Iterable[float]]):
        ''' Transform armature bones by a matrix

        :param matrix: Matrix
        :type matrix: typing.Optional[typing.Iterable[float]]
        '''
        pass


class Brush(ID, bpy_struct):
    ''' Brush data-block for storing brush settings for painting and sculpting
    '''

    auto_smooth_factor: float = None
    ''' Amount of smoothing to automatically apply to each stroke

    :type: float
    '''

    blend: typing.Union[str, int] = None
    ''' Brush blending mode * ``MIX`` Mix, Use mix blending mode while painting. * ``ADD`` Add, Use add blending mode while painting. * ``SUB`` Subtract, Use subtract blending mode while painting. * ``MUL`` Multiply, Use multiply blending mode while painting. * ``LIGHTEN`` Lighten, Use lighten blending mode while painting. * ``DARKEN`` Darken, Use darken blending mode while painting. * ``ERASE_ALPHA`` Erase Alpha, Erase alpha while painting. * ``ADD_ALPHA`` Add Alpha, Add alpha while painting. * ``OVERLAY`` Overlay, Use overlay blending mode while painting. * ``HARDLIGHT`` Hard light, Use hard light blending mode while painting. * ``COLORBURN`` Color burn, Use color burn blending mode while painting. * ``LINEARBURN`` Linear burn, Use linear burn blending mode while painting. * ``COLORDODGE`` Color dodge, Use color dodge blending mode while painting. * ``SCREEN`` Screen, Use screen blending mode while painting. * ``SOFTLIGHT`` Soft light, Use softlight blending mode while painting. * ``PINLIGHT`` Pin light, Use pinlight blending mode while painting. * ``VIVIDLIGHT`` Vivid light, Use vividlight blending mode while painting. * ``LINEARLIGHT`` Linear light, Use linearlight blending mode while painting. * ``DIFFERENCE`` Difference, Use difference blending mode while painting. * ``EXCLUSION`` Exclusion, Use exclusion blending mode while painting. * ``HUE`` Hue, Use hue blending mode while painting. * ``SATURATION`` Saturation, Use saturation blending mode while painting. * ``LUMINOSITY`` Luminosity, Use luminosity blending mode while painting. * ``COLOR`` Color, Use color blending mode while painting.

    :type: typing.Union[str, int]
    '''

    blur_kernel_radius: int = None
    ''' Radius of kernel used for soften and sharpen in pixels

    :type: int
    '''

    blur_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    brush_capabilities: 'BrushCapabilities' = None
    ''' Brush's capabilities

    :type: 'BrushCapabilities'
    '''

    clone_alpha: float = None
    ''' Opacity of clone image display

    :type: float
    '''

    clone_image: 'Image' = None
    ''' Image for clone tool

    :type: 'Image'
    '''

    clone_offset: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    color: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    crease_pinch_factor: float = None
    ''' How much the crease brush pinches

    :type: float
    '''

    cursor_color_add: bpy_prop_array[float] = None
    ''' Color of cursor when adding

    :type: bpy_prop_array[float]
    '''

    cursor_color_subtract: bpy_prop_array[float] = None
    ''' Color of cursor when subtracting

    :type: bpy_prop_array[float]
    '''

    cursor_overlay_alpha: int = None
    ''' 

    :type: int
    '''

    curve: 'CurveMapping' = None
    ''' Editable falloff curve

    :type: 'CurveMapping'
    '''

    direction: typing.Union[str, int] = None
    ''' * ``ADD`` Add, Add effect of brush. * ``SUBTRACT`` Subtract, Subtract effect of brush.

    :type: typing.Union[str, int]
    '''

    fill_threshold: float = None
    ''' Threshold above which filling is not propagated

    :type: float
    '''

    grad_spacing: int = None
    ''' Spacing before brush gradient goes full circle

    :type: int
    '''

    gradient: 'ColorRamp' = None
    ''' 

    :type: 'ColorRamp'
    '''

    gradient_fill_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    gradient_stroke_mode: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    height: float = None
    ''' Affectable height of brush (layer height for layer tool, i.e.)

    :type: float
    '''

    icon_filepath: typing.Union[str, typing.Any] = None
    ''' File path to brush icon

    :type: typing.Union[str, typing.Any]
    '''

    image_paint_capabilities: 'ImapaintToolCapabilities' = None
    ''' Brush's capabilities in image paint mode

    :type: 'ImapaintToolCapabilities'
    '''

    image_tool: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    jitter: float = None
    ''' Jitter the position of the brush while painting

    :type: float
    '''

    jitter_absolute: int = None
    ''' Jitter the position of the brush in pixels while painting

    :type: int
    '''

    mask_overlay_alpha: int = None
    ''' 

    :type: int
    '''

    mask_stencil_dimension: bpy_prop_array[float] = None
    ''' Dimensions of mask stencil in viewport

    :type: bpy_prop_array[float]
    '''

    mask_stencil_pos: bpy_prop_array[float] = None
    ''' Position of mask stencil in viewport

    :type: bpy_prop_array[float]
    '''

    mask_texture: 'Texture' = None
    ''' 

    :type: 'Texture'
    '''

    mask_texture_slot: 'BrushTextureSlot' = None
    ''' 

    :type: 'BrushTextureSlot'
    '''

    mask_tool: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    normal_weight: float = None
    ''' How much grab will pull vertexes out of surface during a grab

    :type: float
    '''

    paint_curve: 'PaintCurve' = None
    ''' Active Paint Curve

    :type: 'PaintCurve'
    '''

    plane_offset: float = None
    ''' Adjust plane on which the brush acts towards or away from the object surface

    :type: float
    '''

    plane_trim: float = None
    ''' If a vertex is further away from offset plane than this, then it is not affected

    :type: float
    '''

    rake_factor: float = None
    ''' How much grab will follow cursor rotation

    :type: float
    '''

    rate: float = None
    ''' Interval between paints for Airbrush

    :type: float
    '''

    sculpt_capabilities: 'SculptToolCapabilities' = None
    ''' Brush's capabilities in sculpt mode

    :type: 'SculptToolCapabilities'
    '''

    sculpt_plane: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    sculpt_tool: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    secondary_color: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    sharp_threshold: float = None
    ''' Threshold below which, no sharpening is done

    :type: float
    '''

    size: int = None
    ''' Radius of the brush in pixels

    :type: int
    '''

    smooth_stroke_factor: float = None
    ''' Higher values give a smoother stroke

    :type: float
    '''

    smooth_stroke_radius: int = None
    ''' Minimum distance from last point before stroke continues

    :type: int
    '''

    spacing: int = None
    ''' Spacing between brush daubs as a percentage of brush diameter

    :type: int
    '''

    stencil_dimension: bpy_prop_array[float] = None
    ''' Dimensions of stencil in viewport

    :type: bpy_prop_array[float]
    '''

    stencil_pos: bpy_prop_array[float] = None
    ''' Position of stencil in viewport

    :type: bpy_prop_array[float]
    '''

    strength: float = None
    ''' How powerful the effect of the brush is when applied

    :type: float
    '''

    stroke_method: typing.Union[str, int] = None
    ''' * ``DOTS`` Dots, Apply paint on each mouse move step. * ``DRAG_DOT`` Drag Dot, Allows a single dot to be carefully positioned. * ``SPACE`` Space, Limit brush application to the distance specified by spacing. * ``AIRBRUSH`` Airbrush, Keep applying paint effect while holding mouse (spray). * ``ANCHORED`` Anchored, Keep the brush anchored to the initial location. * ``LINE`` Line, Draw a line with dabs separated according to spacing. * ``CURVE`` Curve, Define the stroke curve with a bezier curve (dabs are separated according to spacing).

    :type: typing.Union[str, int]
    '''

    texture: 'Texture' = None
    ''' 

    :type: 'Texture'
    '''

    texture_overlay_alpha: int = None
    ''' 

    :type: int
    '''

    texture_sample_bias: float = None
    ''' Value added to texture samples

    :type: float
    '''

    texture_slot: 'BrushTextureSlot' = None
    ''' 

    :type: 'BrushTextureSlot'
    '''

    unprojected_radius: float = None
    ''' Radius of brush in Blender units

    :type: float
    '''

    use_accumulate: bool = None
    ''' Accumulate stroke daubs on top of each other

    :type: bool
    '''

    use_adaptive_space: bool = None
    ''' Space daubs according to surface orientation instead of screen space

    :type: bool
    '''

    use_airbrush: bool = None
    ''' Keep applying paint effect while holding mouse (spray)

    :type: bool
    '''

    use_alpha: bool = None
    ''' When this is disabled, lock alpha while painting

    :type: bool
    '''

    use_anchor: bool = None
    ''' Keep the brush anchored to the initial location

    :type: bool
    '''

    use_cursor_overlay: bool = None
    ''' Show cursor in viewport

    :type: bool
    '''

    use_cursor_overlay_override: bool = None
    ''' Don't show overlay during a stroke

    :type: bool
    '''

    use_curve: bool = None
    ''' Define the stroke curve with a bezier curve. Dabs are separated according to spacing

    :type: bool
    '''

    use_custom_icon: bool = None
    ''' Set the brush icon from an image file

    :type: bool
    '''

    use_edge_to_edge: bool = None
    ''' Drag anchor brush from edge-to-edge

    :type: bool
    '''

    use_frontface: bool = None
    ''' Brush only affects vertexes that face the viewer

    :type: bool
    '''

    use_gradient: bool = None
    ''' Use Gradient by utilizing a sampling method

    :type: bool
    '''

    use_inverse_smooth_pressure: bool = None
    ''' Lighter pressure causes more smoothing to be applied

    :type: bool
    '''

    use_line: bool = None
    ''' Draw a line with dabs separated according to spacing

    :type: bool
    '''

    use_locked_size: bool = None
    ''' When locked brush stays same size relative to object; when unlocked brush size is given in pixels

    :type: bool
    '''

    use_offset_pressure: bool = None
    ''' Enable tablet pressure sensitivity for offset

    :type: bool
    '''

    use_original_normal: bool = None
    ''' When locked keep using normal of surface where stroke was initiated

    :type: bool
    '''

    use_paint_image: bool = None
    ''' Use this brush in texture paint mode

    :type: bool
    '''

    use_paint_sculpt: bool = None
    ''' Use this brush in sculpt mode

    :type: bool
    '''

    use_paint_vertex: bool = None
    ''' Use this brush in vertex paint mode

    :type: bool
    '''

    use_paint_weight: bool = None
    ''' Use this brush in weight paint mode

    :type: bool
    '''

    use_persistent: bool = None
    ''' Sculpt on a persistent layer of the mesh

    :type: bool
    '''

    use_plane_trim: bool = None
    ''' Enable Plane Trim

    :type: bool
    '''

    use_pressure_jitter: bool = None
    ''' Enable tablet pressure sensitivity for jitter

    :type: bool
    '''

    use_pressure_masking: typing.Union[str, int] = None
    ''' Pen pressure makes texture influence smaller

    :type: typing.Union[str, int]
    '''

    use_pressure_size: bool = None
    ''' Enable tablet pressure sensitivity for size

    :type: bool
    '''

    use_pressure_spacing: bool = None
    ''' Enable tablet pressure sensitivity for spacing

    :type: bool
    '''

    use_pressure_strength: bool = None
    ''' Enable tablet pressure sensitivity for strength

    :type: bool
    '''

    use_primary_overlay: bool = None
    ''' Show texture in viewport

    :type: bool
    '''

    use_primary_overlay_override: bool = None
    ''' Don't show overlay during a stroke

    :type: bool
    '''

    use_relative_jitter: bool = None
    ''' Jittering happens in screen space, not relative to brush size

    :type: bool
    '''

    use_restore_mesh: bool = None
    ''' Allow a single dot to be carefully positioned

    :type: bool
    '''

    use_secondary_overlay: bool = None
    ''' Show texture in viewport

    :type: bool
    '''

    use_secondary_overlay_override: bool = None
    ''' Don't show overlay during a stroke

    :type: bool
    '''

    use_smooth_stroke: bool = None
    ''' Brush lags behind mouse and follows a smoother path

    :type: bool
    '''

    use_space: bool = None
    ''' Limit brush application to the distance specified by spacing

    :type: bool
    '''

    use_space_attenuation: bool = None
    ''' Automatically adjust strength to give consistent results for different spacings

    :type: bool
    '''

    vertex_tool: typing.Union[str, int] = None
    ''' Brush blending mode * ``MIX`` Mix, Use mix blending mode while painting. * ``ADD`` Add, Use add blending mode while painting. * ``SUB`` Subtract, Use subtract blending mode while painting. * ``MUL`` Multiply, Use multiply blending mode while painting. * ``BLUR`` Blur, Blur the color with surrounding values. * ``LIGHTEN`` Lighten, Use lighten blending mode while painting. * ``DARKEN`` Darken, Use darken blending mode while painting.

    :type: typing.Union[str, int]
    '''

    weight: float = None
    ''' Vertex weight when brush is applied

    :type: float
    '''


class CacheFile(ID, bpy_struct):
    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Path to external displacements file

    :type: typing.Union[str, typing.Any]
    '''

    forward_axis: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    frame: float = None
    ''' The time to use for looking up the data in the cache file, or to determine which file to use in a file sequence

    :type: float
    '''

    is_sequence: bool = None
    ''' Whether the cache is separated in a series of files

    :type: bool
    '''

    object_paths: 'AlembicObjectPaths' = None
    ''' Paths of the objects inside the Alembic archive

    :type: 'AlembicObjectPaths'
    '''

    override_frame: bool = None
    ''' Whether to use a custom frame for looking up data in the cache file, instead of using the current scene frame

    :type: bool
    '''

    scale: float = None
    ''' Value by which to enlarge or shrink the object with respect to the world's origin (only applicable through a Transform Cache constraint)

    :type: float
    '''

    up_axis: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''


class Camera(ID, bpy_struct):
    ''' Camera data-block for storing camera settings
    '''

    angle: float = None
    ''' Camera lens field of view

    :type: float
    '''

    angle_x: float = None
    ''' Camera lens horizontal field of view

    :type: float
    '''

    angle_y: float = None
    ''' Camera lens vertical field of view

    :type: float
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    clip_end: float = None
    ''' Camera far clipping distance

    :type: float
    '''

    clip_start: float = None
    ''' Camera near clipping distance

    :type: float
    '''

    cycles: 'CyclesCameraSettings' = None
    ''' Cycles camera settings

    :type: 'CyclesCameraSettings'
    '''

    dof_distance: float = None
    ''' Distance to the focus point for depth of field

    :type: float
    '''

    dof_object: 'Object' = None
    ''' Use this object to define the depth of field focal point

    :type: 'Object'
    '''

    draw_size: float = None
    ''' Apparent size of the Camera object in the 3D View

    :type: float
    '''

    gpu_dof: 'GPUDOFSettings' = None
    ''' 

    :type: 'GPUDOFSettings'
    '''

    lens: float = None
    ''' Perspective Camera lens value in millimeters

    :type: float
    '''

    lens_unit: typing.Union[str, int] = None
    ''' Unit to edit lens in for the user interface * ``MILLIMETERS`` Millimeters, Specify the lens in millimeters. * ``FOV`` Field of View, Specify the lens as the field of view's angle.

    :type: typing.Union[str, int]
    '''

    ortho_scale: float = None
    ''' Orthographic Camera scale (similar to zoom)

    :type: float
    '''

    passepartout_alpha: float = None
    ''' Opacity (alpha) of the darkened overlay in Camera view

    :type: float
    '''

    sensor_fit: typing.Union[str, int] = None
    ''' Method to fit image and field of view angle inside the sensor * ``AUTO`` Auto, Fit to the sensor width or height depending on image resolution. * ``HORIZONTAL`` Horizontal, Fit to the sensor width. * ``VERTICAL`` Vertical, Fit to the sensor height.

    :type: typing.Union[str, int]
    '''

    sensor_height: float = None
    ''' Vertical size of the image sensor area in millimeters

    :type: float
    '''

    sensor_width: float = None
    ''' Horizontal size of the image sensor area in millimeters

    :type: float
    '''

    shift_x: float = None
    ''' Camera horizontal shift

    :type: float
    '''

    shift_y: float = None
    ''' Camera vertical shift

    :type: float
    '''

    show_guide: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Draw overlay

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    show_limits: bool = None
    ''' Draw the clipping range and focus point on the camera

    :type: bool
    '''

    show_mist: bool = None
    ''' Draw a line from the Camera to indicate the mist area

    :type: bool
    '''

    show_name: bool = None
    ''' Show the active Camera's name in Camera view

    :type: bool
    '''

    show_passepartout: bool = None
    ''' Show a darkened overlay outside the image area in Camera view

    :type: bool
    '''

    show_safe_areas: bool = None
    ''' Show TV title safe and action safe areas in Camera view

    :type: bool
    '''

    show_safe_center: bool = None
    ''' Show safe areas to fit content in a different aspect ratio

    :type: bool
    '''

    show_sensor: bool = None
    ''' Show sensor size (film gate) in Camera view

    :type: bool
    '''

    stereo: 'CameraStereoData' = None
    ''' 

    :type: 'CameraStereoData'
    '''

    type: typing.Union[str, int] = None
    ''' Camera types

    :type: typing.Union[str, int]
    '''

    def view_frame(self, scene: typing.Optional['Scene'] = None):
        ''' Return 4 points for the cameras frame (before object transformation)

        :param scene: Scene to use for aspect calculation, when omitted 1:1 aspect is used
        :type scene: typing.Optional['Scene']
        '''
        pass


class Curve(ID, bpy_struct):
    ''' Curve data-block storing curves, splines and NURBS
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    bevel_depth: float = None
    ''' Bevel depth when not using a bevel object

    :type: float
    '''

    bevel_factor_end: float = None
    ''' Factor that defines to where beveling of spline happens (0=to the very beginning, 1=to the very end)

    :type: float
    '''

    bevel_factor_mapping_end: typing.Union[str, int] = None
    ''' Determines how the end bevel factor is mapped to a spline * ``RESOLUTION`` Resolution, Map the bevel factor to the number of subdivisions of a spline (U resolution). * ``SEGMENTS`` Segments, Map the bevel factor to the length of a segment and to the number of subdivisions of a segment. * ``SPLINE`` Spline, Map the bevel factor to the length of a spline.

    :type: typing.Union[str, int]
    '''

    bevel_factor_mapping_start: typing.Union[str, int] = None
    ''' Determines how the start bevel factor is mapped to a spline * ``RESOLUTION`` Resolution, Map the bevel factor to the number of subdivisions of a spline (U resolution). * ``SEGMENTS`` Segments, Map the bevel factor to the length of a segment and to the number of subdivisions of a segment. * ``SPLINE`` Spline, Map the bevel factor to the length of a spline.

    :type: typing.Union[str, int]
    '''

    bevel_factor_start: float = None
    ''' Factor that defines from where beveling of spline happens (0=from the very beginning, 1=from the very end)

    :type: float
    '''

    bevel_object: 'Object' = None
    ''' Curve object name that defines the bevel shape

    :type: 'Object'
    '''

    bevel_resolution: int = None
    ''' Bevel resolution when depth is non-zero and no specific bevel object has been defined

    :type: int
    '''

    cycles: 'CyclesMeshSettings' = None
    ''' Cycles mesh settings

    :type: 'CyclesMeshSettings'
    '''

    dimensions: typing.Union[str, int] = None
    ''' Select 2D or 3D curve type * ``2D`` 2D, Clamp the Z axis of the curve. * ``3D`` 3D, Allow editing on the Z axis of this curve, also allows tilt and curve radius to be used.

    :type: typing.Union[str, int]
    '''

    eval_time: float = None
    ''' Parametric position along the length of the curve that Objects 'following' it should be at (position is evaluated by dividing by the 'Path Length' value)

    :type: float
    '''

    extrude: float = None
    ''' Amount of curve extrusion when not using a bevel object

    :type: float
    '''

    fill_mode: typing.Union[str, int] = None
    ''' Mode of filling curve

    :type: typing.Union[str, int]
    '''

    is_editmode: typing.Union[bool, typing.Any] = None
    ''' True when used in editmode

    :type: typing.Union[bool, typing.Any]
    '''

    materials: 'IDMaterials' = None
    ''' 

    :type: 'IDMaterials'
    '''

    offset: float = None
    ''' Offset the curve to adjust the width of a text

    :type: float
    '''

    path_duration: int = None
    ''' The number of frames that are needed to traverse the path, defining the maximum value for the 'Evaluation Time' setting

    :type: int
    '''

    render_resolution_u: int = None
    ''' Surface resolution in U direction used while rendering (zero uses preview resolution)

    :type: int
    '''

    render_resolution_v: int = None
    ''' Surface resolution in V direction used while rendering (zero uses preview resolution)

    :type: int
    '''

    resolution_u: int = None
    ''' Surface resolution in U direction

    :type: int
    '''

    resolution_v: int = None
    ''' Surface resolution in V direction

    :type: int
    '''

    shape_keys: 'Key' = None
    ''' 

    :type: 'Key'
    '''

    show_handles: bool = None
    ''' Display Bezier handles in editmode

    :type: bool
    '''

    show_normal_face: bool = None
    ''' Display 3D curve normals in editmode

    :type: bool
    '''

    splines: 'CurveSplines' = None
    ''' Collection of splines in this curve data object

    :type: 'CurveSplines'
    '''

    taper_object: 'Object' = None
    ''' Curve object name that defines the taper (width)

    :type: 'Object'
    '''

    texspace_location: bpy_prop_array[float] = None
    ''' Texture space location

    :type: bpy_prop_array[float]
    '''

    texspace_size: bpy_prop_array[float] = None
    ''' Texture space size

    :type: bpy_prop_array[float]
    '''

    twist_mode: typing.Union[str, int] = None
    ''' The type of tilt calculation for 3D Curves * ``Z_UP`` Z-Up, Use Z-Up axis to calculate the curve twist at each point. * ``MINIMUM`` Minimum, Use the least twist over the entire curve. * ``TANGENT`` Tangent, Use the tangent to calculate twist.

    :type: typing.Union[str, int]
    '''

    twist_smooth: float = None
    ''' Smoothing iteration for tangents

    :type: float
    '''

    use_auto_texspace: bool = None
    ''' Adjust active object's texture space automatically when transforming object

    :type: bool
    '''

    use_deform_bounds: bool = None
    ''' Option for curve-deform: Use the mesh bounds to clamp the deformation

    :type: bool
    '''

    use_fill_caps: bool = None
    ''' Fill caps for beveled curves

    :type: bool
    '''

    use_fill_deform: bool = None
    ''' Fill curve after applying shape keys and all modifiers

    :type: bool
    '''

    use_map_taper: bool = None
    ''' Map effect of taper object on actually beveled curve

    :type: bool
    '''

    use_path: bool = None
    ''' Enable the curve to become a translation path

    :type: bool
    '''

    use_path_follow: bool = None
    ''' Make curve path children to rotate along the path

    :type: bool
    '''

    use_radius: bool = None
    ''' Option for paths and curve-deform: apply the curve radius with path following it and deforming

    :type: bool
    '''

    use_stretch: bool = None
    ''' Option for curve-deform: make deformed child to stretch along entire path

    :type: bool
    '''

    use_uv_as_generated: bool = None
    ''' Uses the UV values as Generated textured coordinates

    :type: bool
    '''

    def transform(self,
                  matrix: typing.Optional[typing.Iterable[float]],
                  shape_keys: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = False):
        ''' Transform curve by a matrix

        :param matrix: Matrix
        :type matrix: typing.Optional[typing.Iterable[float]]
        :param shape_keys: Transform Shape Keys
        :type shape_keys: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def validate_material_indices(self) -> bool:
        ''' Validate material indices of splines or letters, return True when the curve has had invalid indices corrected (to default 0)

        :rtype: bool
        :return: Result
        '''
        pass


class FreestyleLineStyle(ID, bpy_struct):
    ''' Freestyle line style, reusable by multiple line sets
    '''

    active_texture: 'Texture' = None
    ''' Active texture slot being displayed

    :type: 'Texture'
    '''

    active_texture_index: int = None
    ''' Index of active texture slot

    :type: int
    '''

    alpha: float = None
    ''' Base alpha transparency, possibly modified by alpha transparency modifiers

    :type: float
    '''

    alpha_modifiers: 'LineStyleAlphaModifiers' = None
    ''' List of alpha transparency modifiers

    :type: 'LineStyleAlphaModifiers'
    '''

    angle_max: float = None
    ''' Maximum 2D angle for splitting chains

    :type: float
    '''

    angle_min: float = None
    ''' Minimum 2D angle for splitting chains

    :type: float
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    caps: typing.Union[str, int] = None
    ''' Select the shape of both ends of strokes * ``BUTT`` Butt, Butt cap (flat). * ``ROUND`` Round, Round cap (half-circle). * ``SQUARE`` Square, Square cap (flat and extended).

    :type: typing.Union[str, int]
    '''

    chain_count: int = None
    ''' Chain count for the selection of first N chains

    :type: int
    '''

    chaining: typing.Union[str, int] = None
    ''' Select the way how feature edges are jointed to form chains * ``PLAIN`` Plain, Plain chaining. * ``SKETCHY`` Sketchy, Sketchy chaining with a multiple touch.

    :type: typing.Union[str, int]
    '''

    color: bpy_prop_array[float] = None
    ''' Base line color, possibly modified by line color modifiers

    :type: bpy_prop_array[float]
    '''

    color_modifiers: 'LineStyleColorModifiers' = None
    ''' List of line color modifiers

    :type: 'LineStyleColorModifiers'
    '''

    dash1: int = None
    ''' Length of the 1st dash for dashed lines

    :type: int
    '''

    dash2: int = None
    ''' Length of the 2nd dash for dashed lines

    :type: int
    '''

    dash3: int = None
    ''' Length of the 3rd dash for dashed lines

    :type: int
    '''

    gap1: int = None
    ''' Length of the 1st gap for dashed lines

    :type: int
    '''

    gap2: int = None
    ''' Length of the 2nd gap for dashed lines

    :type: int
    '''

    gap3: int = None
    ''' Length of the 3rd gap for dashed lines

    :type: int
    '''

    geometry_modifiers: 'LineStyleGeometryModifiers' = None
    ''' List of stroke geometry modifiers

    :type: 'LineStyleGeometryModifiers'
    '''

    integration_type: typing.Union[str, int] = None
    ''' Select the way how the sort key is computed for each chain * ``MEAN`` Mean, The value computed for the chain is the mean of the values obtained for chain vertices. * ``MIN`` Min, The value computed for the chain is the minimum of the values obtained for chain vertices. * ``MAX`` Max, The value computed for the chain is the maximum of the values obtained for chain vertices. * ``FIRST`` First, The value computed for the chain is the value obtained for the first chain vertex. * ``LAST`` Last, The value computed for the chain is the value obtained for the last chain vertex.

    :type: typing.Union[str, int]
    '''

    length_max: float = None
    ''' Maximum curvilinear 2D length for the selection of chains

    :type: float
    '''

    length_min: float = None
    ''' Minimum curvilinear 2D length for the selection of chains

    :type: float
    '''

    material_boundary: bool = None
    ''' If true, chains of feature edges are split at material boundaries

    :type: bool
    '''

    node_tree: 'NodeTree' = None
    ''' Node tree for node-based shaders

    :type: 'NodeTree'
    '''

    panel: typing.Union[str, int] = None
    ''' Select the property panel to be shown * ``STROKES`` Strokes, Show the panel for stroke construction. * ``COLOR`` Color, Show the panel for line color options. * ``ALPHA`` Alpha, Show the panel for alpha transparency options. * ``THICKNESS`` Thickness, Show the panel for line thickness options. * ``GEOMETRY`` Geometry, Show the panel for stroke geometry options. * ``TEXTURE`` Texture, Show the panel for stroke texture options.

    :type: typing.Union[str, int]
    '''

    rounds: int = None
    ''' Number of rounds in a sketchy multiple touch

    :type: int
    '''

    sort_key: typing.Union[str, int] = None
    ''' Select the sort key to determine the stacking order of chains * ``DISTANCE_FROM_CAMERA`` Distance from Camera, Sort by distance from camera (closer lines lie on top of further lines). * ``2D_LENGTH`` 2D Length, Sort by curvilinear 2D length (longer lines lie on top of shorter lines). * ``PROJECTED_X`` Projected X, Sort by the projected X value in the image coordinate system. * ``PROJECTED_Y`` Projected Y, Sort by the projected Y value in the image coordinate system.

    :type: typing.Union[str, int]
    '''

    sort_order: typing.Union[str, int] = None
    ''' Select the sort order * ``DEFAULT`` Default, Default order of the sort key. * ``REVERSE`` Reverse, Reverse order.

    :type: typing.Union[str, int]
    '''

    split_dash1: int = None
    ''' Length of the 1st dash for splitting

    :type: int
    '''

    split_dash2: int = None
    ''' Length of the 2nd dash for splitting

    :type: int
    '''

    split_dash3: int = None
    ''' Length of the 3rd dash for splitting

    :type: int
    '''

    split_gap1: int = None
    ''' Length of the 1st gap for splitting

    :type: int
    '''

    split_gap2: int = None
    ''' Length of the 2nd gap for splitting

    :type: int
    '''

    split_gap3: int = None
    ''' Length of the 3rd gap for splitting

    :type: int
    '''

    split_length: float = None
    ''' Curvilinear 2D length for chain splitting

    :type: float
    '''

    texture_slots: 'LineStyleTextureSlots' = None
    ''' Texture slots defining the mapping and influence of textures

    :type: 'LineStyleTextureSlots'
    '''

    texture_spacing: float = None
    ''' Spacing for textures along stroke length

    :type: float
    '''

    thickness: float = None
    ''' Base line thickness, possibly modified by line thickness modifiers

    :type: float
    '''

    thickness_modifiers: 'LineStyleThicknessModifiers' = None
    ''' List of line thickness modifiers

    :type: 'LineStyleThicknessModifiers'
    '''

    thickness_position: typing.Union[str, int] = None
    ''' Thickness position of silhouettes and border edges (applicable when plain chaining is used with the Same Object option) * ``CENTER`` Center, Silhouettes and border edges are centered along stroke geometry. * ``INSIDE`` Inside, Silhouettes and border edges are drawn inside of stroke geometry. * ``OUTSIDE`` Outside, Silhouettes and border edges are drawn outside of stroke geometry. * ``RELATIVE`` Relative, Silhouettes and border edges are shifted by a user-defined ratio.

    :type: typing.Union[str, int]
    '''

    thickness_ratio: float = None
    ''' A number between 0 (inside) and 1 (outside) specifying the relative position of stroke thickness

    :type: float
    '''

    use_angle_max: bool = None
    ''' Split chains at points with angles larger than the maximum 2D angle

    :type: bool
    '''

    use_angle_min: bool = None
    ''' Split chains at points with angles smaller than the minimum 2D angle

    :type: bool
    '''

    use_chain_count: bool = None
    ''' Enable the selection of first N chains

    :type: bool
    '''

    use_chaining: bool = None
    ''' Enable chaining of feature edges

    :type: bool
    '''

    use_dashed_line: bool = None
    ''' Enable or disable dashed line

    :type: bool
    '''

    use_length_max: bool = None
    ''' Enable the selection of chains by a maximum 2D length

    :type: bool
    '''

    use_length_min: bool = None
    ''' Enable the selection of chains by a minimum 2D length

    :type: bool
    '''

    use_nodes: bool = None
    ''' Use shader nodes for the line style

    :type: bool
    '''

    use_same_object: bool = None
    ''' If true, only feature edges of the same object are joined

    :type: bool
    '''

    use_sorting: bool = None
    ''' Arrange the stacking order of strokes

    :type: bool
    '''

    use_split_length: bool = None
    ''' Enable chain splitting by curvilinear 2D length

    :type: bool
    '''

    use_split_pattern: bool = None
    ''' Enable chain splitting by dashed line patterns

    :type: bool
    '''

    use_texture: bool = None
    ''' Enable or disable textured strokes

    :type: bool
    '''


class GreasePencil(ID, bpy_struct):
    ''' Freehand annotation sketchbook
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    layers: 'GreasePencilLayers' = None
    ''' 

    :type: 'GreasePencilLayers'
    '''

    palettes: 'GreasePencilPalettes' = None
    ''' 

    :type: 'GreasePencilPalettes'
    '''

    show_stroke_direction: bool = None
    ''' Show stroke drawing direction with a bigger green dot (start) and smaller red dot (end) points

    :type: bool
    '''

    use_onion_skinning: bool = None
    ''' Show ghosts of the frames before and after the current frame, toggle to enable on active layer or disable all

    :type: bool
    '''

    use_stroke_edit_mode: bool = None
    ''' Edit Grease Pencil strokes instead of viewport data

    :type: bool
    '''

    def clear(self):
        ''' Remove all the grease pencil data

        '''
        pass


class Group(ID, bpy_struct):
    ''' Group of Object data-blocks
    '''

    dupli_offset: bpy_prop_array[float] = None
    ''' Offset from the origin to use when instancing as DupliGroup

    :type: bpy_prop_array[float]
    '''

    layers: typing.List[bool] = None
    ''' Layers visible when this group is instanced as a dupli

    :type: typing.List[bool]
    '''

    objects: 'GroupObjects' = None
    ''' A collection of this groups objects

    :type: 'GroupObjects'
    '''

    users_dupli_group = None
    ''' The dupli group this group is used in (readonly)'''


class Image(ID, bpy_struct):
    ''' Image data-block referencing an external or packed image
    '''

    alpha_mode: typing.Union[str, int] = None
    ''' Representation of alpha information in the RGBA pixels * ``STRAIGHT`` Straight, Transparent RGB and alpha pixels are unmodified. * ``PREMUL`` Premultiplied, Transparent RGB pixels are multiplied by the alpha channel.

    :type: typing.Union[str, int]
    '''

    bindcode: bpy_prop_array[int] = None
    ''' OpenGL bindcode

    :type: bpy_prop_array[int]
    '''

    channels: int = None
    ''' Number of channels in pixels buffer

    :type: int
    '''

    colorspace_settings: 'ColorManagedInputColorspaceSettings' = None
    ''' Input color space settings

    :type: 'ColorManagedInputColorspaceSettings'
    '''

    depth: int = None
    ''' Image bit depth

    :type: int
    '''

    display_aspect: bpy_prop_array[float] = None
    ''' Display Aspect for this image, does not affect rendering

    :type: bpy_prop_array[float]
    '''

    field_order: typing.Union[str, int] = None
    ''' Order of video fields (select which lines are displayed first) * ``EVEN`` Upper First, Upper field first. * ``ODD`` Lower First, Lower field first.

    :type: typing.Union[str, int]
    '''

    file_format: typing.Union[str, int] = None
    ''' Format used for re-saving this file * ``BMP`` BMP, Output image in bitmap format. * ``IRIS`` Iris, Output image in (old!) SGI IRIS format. * ``PNG`` PNG, Output image in PNG format. * ``JPEG`` JPEG, Output image in JPEG format. * ``JPEG2000`` JPEG 2000, Output image in JPEG 2000 format. * ``TARGA`` Targa, Output image in Targa format. * ``TARGA_RAW`` Targa Raw, Output image in uncompressed Targa format. * ``CINEON`` Cineon, Output image in Cineon format. * ``DPX`` DPX, Output image in DPX format. * ``OPEN_EXR_MULTILAYER`` OpenEXR MultiLayer, Output image in multilayer OpenEXR format. * ``OPEN_EXR`` OpenEXR, Output image in OpenEXR format. * ``HDR`` Radiance HDR, Output image in Radiance HDR format. * ``TIFF`` TIFF, Output image in TIFF format. * ``AVI_JPEG`` AVI JPEG, Output video in AVI JPEG format. * ``AVI_RAW`` AVI Raw, Output video in AVI Raw format. * ``FRAMESERVER`` Frame Server, Output image to a frameserver. * ``H264`` H.264, Output video in H.264 format. * ``FFMPEG`` MPEG, Output video in MPEG format. * ``THEORA`` Ogg Theora, Output video in Ogg format. * ``XVID`` Xvid, Output video in Xvid format.

    :type: typing.Union[str, int]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Image/Movie file name

    :type: typing.Union[str, typing.Any]
    '''

    filepath_raw: typing.Union[str, typing.Any] = None
    ''' Image/Movie file name (without data refreshing)

    :type: typing.Union[str, typing.Any]
    '''

    fps: int = None
    ''' Speed of the animation in frames per second

    :type: int
    '''

    frame_duration: int = None
    ''' Duration (in frames) of the image (1 when not a video/sequence)

    :type: int
    '''

    frame_end: int = None
    ''' End frame of an animated texture

    :type: int
    '''

    frame_start: int = None
    ''' Start frame of an animated texture

    :type: int
    '''

    generated_color: bpy_prop_array[float] = None
    ''' Fill color for the generated image

    :type: bpy_prop_array[float]
    '''

    generated_height: int = None
    ''' Generated image height

    :type: int
    '''

    generated_type: typing.Union[str, int] = None
    ''' Generated image type * ``BLANK`` Blank, Generate a blank image. * ``UV_GRID`` UV Grid, Generated grid to test UV mappings. * ``COLOR_GRID`` Color Grid, Generated improved UV grid to test UV mappings.

    :type: typing.Union[str, int]
    '''

    generated_width: int = None
    ''' Generated image width

    :type: int
    '''

    has_data: typing.Union[bool, typing.Any] = None
    ''' True if this image has data

    :type: typing.Union[bool, typing.Any]
    '''

    is_dirty: typing.Union[bool, typing.Any] = None
    ''' Image has changed and is not saved

    :type: typing.Union[bool, typing.Any]
    '''

    is_float: typing.Union[bool, typing.Any] = None
    ''' True if this image is stored in float buffer

    :type: typing.Union[bool, typing.Any]
    '''

    is_multiview: typing.Union[bool, typing.Any] = None
    ''' Image has more than one view

    :type: typing.Union[bool, typing.Any]
    '''

    is_stereo_3d: typing.Union[bool, typing.Any] = None
    ''' Image has left and right views

    :type: typing.Union[bool, typing.Any]
    '''

    mapping: typing.Union[str, int] = None
    ''' Mapping type to use for this image in the game engine * ``UV`` UV Coordinates, Use UV coordinates for mapping the image. * ``REFLECTION`` Reflection, Use reflection mapping for mapping the image.

    :type: typing.Union[str, int]
    '''

    packed_file: 'PackedFile' = None
    ''' First packed file of the image

    :type: 'PackedFile'
    '''

    packed_files: bpy_prop_collection['ImagePackedFile'] = None
    ''' Collection of packed images

    :type: bpy_prop_collection['ImagePackedFile']
    '''

    pixels: float = None
    ''' Image pixels in floating point values

    :type: float
    '''

    render_slots: 'RenderSlots' = None
    ''' Render slots of the image

    :type: 'RenderSlots'
    '''

    resolution: bpy_prop_array[float] = None
    ''' X/Y pixels per meter

    :type: bpy_prop_array[float]
    '''

    size: bpy_prop_array[int] = None
    ''' Width and height in pixels, zero when image data cant be loaded

    :type: bpy_prop_array[int]
    '''

    source: typing.Union[str, int] = None
    ''' Where the image comes from * ``FILE`` Single Image, Single image file. * ``SEQUENCE`` Image Sequence, Multiple image files, as a sequence. * ``MOVIE`` Movie, Movie file. * ``GENERATED`` Generated, Generated image. * ``VIEWER`` Viewer, Compositing node viewer.

    :type: typing.Union[str, int]
    '''

    stereo_3d_format: 'Stereo3dFormat' = None
    ''' Settings for stereo 3d

    :type: 'Stereo3dFormat'
    '''

    tiles_x: int = None
    ''' Degree of repetition in the X direction

    :type: int
    '''

    tiles_y: int = None
    ''' Degree of repetition in the Y direction

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' How to generate the image

    :type: typing.Union[str, int]
    '''

    use_alpha: bool = None
    ''' Use the alpha channel information from the image or make image fully opaque

    :type: bool
    '''

    use_animation: bool = None
    ''' Use as animated texture in the game engine

    :type: bool
    '''

    use_clamp_x: bool = None
    ''' Disable texture repeating horizontally

    :type: bool
    '''

    use_clamp_y: bool = None
    ''' Disable texture repeating vertically

    :type: bool
    '''

    use_deinterlace: bool = None
    ''' Deinterlace movie file on load

    :type: bool
    '''

    use_fields: bool = None
    ''' Use fields of the image

    :type: bool
    '''

    use_generated_float: bool = None
    ''' Generate floating point buffer

    :type: bool
    '''

    use_multiview: bool = None
    ''' Use Multiple Views (when available)

    :type: bool
    '''

    use_tiles: bool = None
    ''' Use of tilemode for faces (default shift-LMB to pick the tile for selected faces)

    :type: bool
    '''

    use_view_as_render: bool = None
    ''' Apply render part of display transformation when displaying this image on the screen

    :type: bool
    '''

    views_format: typing.Union[str, int] = None
    ''' Mode to load image views * ``INDIVIDUAL`` Individual, Individual files for each view with the prefix as defined by the scene views. * ``STEREO_3D`` Stereo 3D, Single file with an encoded stereo pair.

    :type: typing.Union[str, int]
    '''

    def save_render(self,
                    filepath: typing.Union[str, typing.Any],
                    scene: typing.Optional['Scene'] = None):
        ''' Save image to a specific path using a scenes render settings

        :param filepath: Save path
        :type filepath: typing.Union[str, typing.Any]
        :param scene: Scene to take image parameters from
        :type scene: typing.Optional['Scene']
        '''
        pass

    def save(self):
        ''' Save image to its source path

        '''
        pass

    def pack(self,
             as_png: typing.Optional[typing.Union[bool, typing.Any]] = False,
             data: typing.Union[str, typing.Any] = "",
             data_len: typing.Optional[typing.Any] = 0):
        ''' Pack an image as embedded data into the .blend file

        :param as_png: as_png, Pack the image as PNG (needed for generated/dirty images)
        :type as_png: typing.Optional[typing.Union[bool, typing.Any]]
        :param data: data, Raw data (bytes, exact content of the embedded file)
        :type data: typing.Union[str, typing.Any]
        :param data_len: data_len, length of given data (mandatory if data is provided)
        :type data_len: typing.Optional[typing.Any]
        '''
        pass

    def unpack(self, method: typing.Optional[typing.Any] = 'USE_LOCAL'):
        ''' Save an image packed in the .blend file to disk

        :param method: method, How to unpack
        :type method: typing.Optional[typing.Any]
        '''
        pass

    def reload(self):
        ''' Reload the image from its source path

        '''
        pass

    def update(self):
        ''' Update the display image from the floating point buffer

        '''
        pass

    def scale(self, width: typing.Optional[int], height: typing.Optional[int]):
        ''' Scale the image in pixels

        :param width: Width
        :type width: typing.Optional[int]
        :param height: Height
        :type height: typing.Optional[int]
        '''
        pass

    def gl_touch(self,
                 frame: typing.Optional[typing.Any] = 0,
                 filter: typing.Optional[typing.Any] = 9985,
                 mag: typing.Optional[typing.Any] = 9729) -> int:
        ''' Delay the image from being cleaned from the cache due inactivity

        :param frame: Frame, Frame of image sequence or movie
        :type frame: typing.Optional[typing.Any]
        :param filter: Filter, The texture minifying function to use if the image wasn't loaded
        :type filter: typing.Optional[typing.Any]
        :param mag: Magnification, The texture magnification function to use if the image wasn't loaded
        :type mag: typing.Optional[typing.Any]
        :rtype: int
        :return: Error, OpenGL error value
        '''
        pass

    def gl_load(self,
                frame: typing.Optional[typing.Any] = 0,
                filter: typing.Optional[typing.Any] = 9985,
                mag: typing.Optional[typing.Any] = 9729) -> int:
        ''' Load the image into OpenGL graphics memory

        :param frame: Frame, Frame of image sequence or movie
        :type frame: typing.Optional[typing.Any]
        :param filter: Filter, The texture minifying function
        :type filter: typing.Optional[typing.Any]
        :param mag: Magnification, The texture magnification function
        :type mag: typing.Optional[typing.Any]
        :rtype: int
        :return: Error, OpenGL error value
        '''
        pass

    def gl_free(self):
        ''' Free the image from OpenGL graphics memory

        '''
        pass

    def filepath_from_user(self,
                           image_user: typing.Optional['ImageUser'] = None
                           ) -> typing.Union[str, typing.Any]:
        ''' Return the absolute path to the filepath of an image frame specified by the image user

        :param image_user: Image user of the image to get filepath for
        :type image_user: typing.Optional['ImageUser']
        :rtype: typing.Union[str, typing.Any]
        :return: File Path, The resulting filepath from the image and it's user
        '''
        pass

    def buffers_free(self):
        ''' Free the image buffers from memory

        '''
        pass


class Key(ID, bpy_struct):
    ''' Shape keys data-block containing different shapes of geometric data-blocks
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    eval_time: float = None
    ''' Evaluation time for absolute shape keys

    :type: float
    '''

    key_blocks: bpy_prop_collection['ShapeKey'] = None
    ''' Shape keys

    :type: bpy_prop_collection['ShapeKey']
    '''

    reference_key: 'ShapeKey' = None
    ''' 

    :type: 'ShapeKey'
    '''

    use_relative: bool = None
    ''' Make shape keys relative, otherwise play through shapes as a sequence using the evaluation time

    :type: bool
    '''

    user: 'ID' = None
    ''' Datablock using these shape keys

    :type: 'ID'
    '''


class Lamp(ID, bpy_struct):
    ''' Lamp data-block for lighting a scene
    '''

    active_texture: 'Texture' = None
    ''' Active texture slot being displayed

    :type: 'Texture'
    '''

    active_texture_index: int = None
    ''' Index of active texture slot

    :type: int
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    color: bpy_prop_array[float] = None
    ''' Light color

    :type: bpy_prop_array[float]
    '''

    cycles: 'CyclesLampSettings' = None
    ''' Cycles lamp settings

    :type: 'CyclesLampSettings'
    '''

    distance: float = None
    ''' Falloff distance - the light is at half the original intensity at this point

    :type: float
    '''

    energy: float = None
    ''' Amount of light that the lamp emits

    :type: float
    '''

    node_tree: 'NodeTree' = None
    ''' Node tree for node based lamps

    :type: 'NodeTree'
    '''

    texture_slots: 'LampTextureSlots' = None
    ''' Texture slots defining the mapping and influence of textures

    :type: 'LampTextureSlots'
    '''

    type: typing.Union[str, int] = None
    ''' Type of Lamp * ``POINT`` Point, Omnidirectional point light source. * ``SUN`` Sun, Constant direction parallel ray light source. * ``SPOT`` Spot, Directional cone light source. * ``HEMI`` Hemi, 180 degree constant light source. * ``AREA`` Area, Directional area light source.

    :type: typing.Union[str, int]
    '''

    use_diffuse: bool = None
    ''' Do diffuse shading

    :type: bool
    '''

    use_negative: bool = None
    ''' Cast negative light

    :type: bool
    '''

    use_nodes: bool = None
    ''' Use shader nodes to render the lamp

    :type: bool
    '''

    use_own_layer: bool = None
    ''' Illuminate objects only on the same layers the lamp is on

    :type: bool
    '''

    use_specular: bool = None
    ''' Create specular highlights

    :type: bool
    '''


class Lattice(ID, bpy_struct):
    ''' Lattice data-block defining a grid for deforming other objects
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    interpolation_type_u: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    interpolation_type_v: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    interpolation_type_w: typing.Union[str, int] = None
    ''' 

    :type: typing.Union[str, int]
    '''

    is_editmode: typing.Union[bool, typing.Any] = None
    ''' True when used in editmode

    :type: typing.Union[bool, typing.Any]
    '''

    points: bpy_prop_collection['LatticePoint'] = None
    ''' Points of the lattice

    :type: bpy_prop_collection['LatticePoint']
    '''

    points_u: int = None
    ''' Point in U direction (can't be changed when there are shape keys)

    :type: int
    '''

    points_v: int = None
    ''' Point in V direction (can't be changed when there are shape keys)

    :type: int
    '''

    points_w: int = None
    ''' Point in W direction (can't be changed when there are shape keys)

    :type: int
    '''

    shape_keys: 'Key' = None
    ''' 

    :type: 'Key'
    '''

    use_outside: bool = None
    ''' Only draw, and take into account, the outer vertices

    :type: bool
    '''

    vertex_group: typing.Union[str, typing.Any] = None
    ''' Vertex group to apply the influence of the lattice

    :type: typing.Union[str, typing.Any]
    '''

    def transform(self,
                  matrix: typing.Optional[typing.Iterable[float]],
                  shape_keys: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = False):
        ''' Transform lattice by a matrix

        :param matrix: Matrix
        :type matrix: typing.Optional[typing.Iterable[float]]
        :param shape_keys: Transform Shape Keys
        :type shape_keys: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass


class Library(ID, bpy_struct):
    ''' External .blend file from which data is linked
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Path to the library .blend file

    :type: typing.Union[str, typing.Any]
    '''

    packed_file: 'PackedFile' = None
    ''' 

    :type: 'PackedFile'
    '''

    parent: 'Library' = None
    ''' 

    :type: 'Library'
    '''

    users_id = None
    ''' ID data blocks which use this library (readonly)'''

    def reload(self):
        ''' Reload this library and all its linked datablocks

        '''
        pass


class Mask(ID, bpy_struct):
    ''' Mask data-block defining mask for compositing
    '''

    active_layer_index: int = None
    ''' Index of active layer in list of all mask's layers

    :type: int
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    frame_end: int = None
    ''' Final frame of the mask (used for sequencer)

    :type: int
    '''

    frame_start: int = None
    ''' First frame of the mask (used for sequencer)

    :type: int
    '''

    layers: 'MaskLayers' = None
    ''' Collection of layers which defines this mask

    :type: 'MaskLayers'
    '''


class Material(ID, bpy_struct):
    ''' Material data-block to define the appearance of geometric objects for rendering
    '''

    active_node_material: 'Material' = None
    ''' Active node material

    :type: 'Material'
    '''

    active_texture: 'Texture' = None
    ''' Active texture slot being displayed

    :type: 'Texture'
    '''

    active_texture_index: int = None
    ''' Index of active texture slot

    :type: int
    '''

    alpha: float = None
    ''' Alpha transparency of the material

    :type: float
    '''

    ambient: float = None
    ''' Amount of global ambient color the material receives

    :type: float
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    cycles: 'CyclesMaterialSettings' = None
    ''' Cycles material settings

    :type: 'CyclesMaterialSettings'
    '''

    darkness: float = None
    ''' Minnaert darkness

    :type: float
    '''

    diffuse_color: bpy_prop_array[float] = None
    ''' Diffuse color of the material

    :type: bpy_prop_array[float]
    '''

    diffuse_fresnel: float = None
    ''' Power of Fresnel

    :type: float
    '''

    diffuse_fresnel_factor: float = None
    ''' Blending factor of Fresnel

    :type: float
    '''

    diffuse_intensity: float = None
    ''' Amount of diffuse reflection

    :type: float
    '''

    diffuse_ramp: 'ColorRamp' = None
    ''' Color ramp used to affect diffuse shading

    :type: 'ColorRamp'
    '''

    diffuse_ramp_blend: typing.Union[str, int] = None
    ''' Blending method of the ramp and the diffuse color

    :type: typing.Union[str, int]
    '''

    diffuse_ramp_factor: float = None
    ''' Blending factor (also uses alpha in Colorband)

    :type: float
    '''

    diffuse_ramp_input: typing.Union[str, int] = None
    ''' How the ramp maps on the surface

    :type: typing.Union[str, int]
    '''

    diffuse_shader: typing.Union[str, int] = None
    ''' * ``LAMBERT`` Lambert, Use a Lambertian shader. * ``OREN_NAYAR`` Oren-Nayar, Use an Oren-Nayar shader. * ``TOON`` Toon, Use a toon shader. * ``MINNAERT`` Minnaert, Use a Minnaert shader. * ``FRESNEL`` Fresnel, Use a Fresnel shader.

    :type: typing.Union[str, int]
    '''

    diffuse_toon_size: float = None
    ''' Size of diffuse toon area

    :type: float
    '''

    diffuse_toon_smooth: float = None
    ''' Smoothness of diffuse toon area

    :type: float
    '''

    emit: float = None
    ''' Amount of light to emit

    :type: float
    '''

    game_settings: 'MaterialGameSettings' = None
    ''' Game material settings

    :type: 'MaterialGameSettings'
    '''

    halo: 'MaterialHalo' = None
    ''' Halo settings for the material

    :type: 'MaterialHalo'
    '''

    invert_z: bool = None
    ''' Render material's faces with an inverted Z buffer (scanline only)

    :type: bool
    '''

    light_group: 'Group' = None
    ''' Limit lighting to lamps in this Group

    :type: 'Group'
    '''

    line_color: bpy_prop_array[float] = None
    ''' Line color used for Freestyle line rendering

    :type: bpy_prop_array[float]
    '''

    line_priority: int = None
    ''' The line color of a higher priority is used at material boundaries

    :type: int
    '''

    mirror_color: bpy_prop_array[float] = None
    ''' Mirror color of the material

    :type: bpy_prop_array[float]
    '''

    node_tree: 'NodeTree' = None
    ''' Node tree for node based materials

    :type: 'NodeTree'
    '''

    offset_z: float = None
    ''' Give faces an artificial offset in the Z buffer for Z transparency

    :type: float
    '''

    paint_active_slot: int = None
    ''' Index of active texture paint slot

    :type: int
    '''

    paint_clone_slot: int = None
    ''' Index of clone texture paint slot

    :type: int
    '''

    pass_index: int = None
    ''' Index number for the "Material Index" render pass

    :type: int
    '''

    physics: 'MaterialPhysics' = None
    ''' Game physics settings

    :type: 'MaterialPhysics'
    '''

    preview_render_type: typing.Union[str, int] = None
    ''' Type of preview render * ``FLAT`` Flat, Flat XY plane. * ``SPHERE`` Sphere, Sphere. * ``CUBE`` Cube, Cube. * ``MONKEY`` Monkey, Monkey. * ``HAIR`` Hair, Hair strands. * ``SPHERE_A`` World Sphere, Large sphere with sky.

    :type: typing.Union[str, int]
    '''

    raytrace_mirror: 'MaterialRaytraceMirror' = None
    ''' Raytraced reflection settings for the material

    :type: 'MaterialRaytraceMirror'
    '''

    raytrace_transparency: 'MaterialRaytraceTransparency' = None
    ''' Raytraced transparency settings for the material

    :type: 'MaterialRaytraceTransparency'
    '''

    roughness: float = None
    ''' Oren-Nayar Roughness

    :type: float
    '''

    shadow_buffer_bias: float = None
    ''' Factor to multiply shadow buffer bias with (0 is ignore)

    :type: float
    '''

    shadow_cast_alpha: float = None
    ''' Shadow casting alpha, in use for Irregular and Deep shadow buffer

    :type: float
    '''

    shadow_only_type: typing.Union[str, int] = None
    ''' How to draw shadows * ``SHADOW_ONLY_OLD`` Shadow and Distance, Old shadow only method. * ``SHADOW_ONLY`` Shadow Only, Improved shadow only method. * ``SHADOW_ONLY_SHADED`` Shadow and Shading, Improved shadow only method which also renders lightless areas as shadows.

    :type: typing.Union[str, int]
    '''

    shadow_ray_bias: float = None
    ''' Shadow raytracing bias to prevent terminator problems on shadow boundary

    :type: float
    '''

    specular_alpha: float = None
    ''' Alpha transparency for specular areas

    :type: float
    '''

    specular_color: bpy_prop_array[float] = None
    ''' Specular color of the material

    :type: bpy_prop_array[float]
    '''

    specular_hardness: int = None
    ''' How hard (sharp) the specular reflection is

    :type: int
    '''

    specular_intensity: float = None
    ''' How intense (bright) the specular reflection is

    :type: float
    '''

    specular_ior: float = None
    ''' Specular index of refraction

    :type: float
    '''

    specular_ramp: 'ColorRamp' = None
    ''' Color ramp used to affect specular shading

    :type: 'ColorRamp'
    '''

    specular_ramp_blend: typing.Union[str, int] = None
    ''' Blending method of the ramp and the specular color

    :type: typing.Union[str, int]
    '''

    specular_ramp_factor: float = None
    ''' Blending factor (also uses alpha in Colorband)

    :type: float
    '''

    specular_ramp_input: typing.Union[str, int] = None
    ''' How the ramp maps on the surface

    :type: typing.Union[str, int]
    '''

    specular_shader: typing.Union[str, int] = None
    ''' * ``COOKTORR`` CookTorr, Use a Cook-Torrance shader. * ``PHONG`` Phong, Use a Phong shader. * ``BLINN`` Blinn, Use a Blinn shader. * ``TOON`` Toon, Use a toon shader. * ``WARDISO`` WardIso, Use a Ward anisotropic shader.

    :type: typing.Union[str, int]
    '''

    specular_slope: float = None
    ''' The standard deviation of surface slope

    :type: float
    '''

    specular_toon_size: float = None
    ''' Size of specular toon area

    :type: float
    '''

    specular_toon_smooth: float = None
    ''' Smoothness of specular toon area

    :type: float
    '''

    strand: 'MaterialStrand' = None
    ''' Strand settings for the material

    :type: 'MaterialStrand'
    '''

    subsurface_scattering: 'MaterialSubsurfaceScattering' = None
    ''' Subsurface scattering settings for the material

    :type: 'MaterialSubsurfaceScattering'
    '''

    texture_paint_images: bpy_prop_collection['Image'] = None
    ''' Texture images used for texture painting

    :type: bpy_prop_collection['Image']
    '''

    texture_paint_slots: bpy_prop_collection['TexPaintSlot'] = None
    ''' Texture slots defining the mapping and influence of textures

    :type: bpy_prop_collection['TexPaintSlot']
    '''

    texture_slots: 'MaterialTextureSlots' = None
    ''' Texture slots defining the mapping and influence of textures

    :type: 'MaterialTextureSlots'
    '''

    translucency: float = None
    ''' Amount of diffuse shading on the back side

    :type: float
    '''

    transparency_method: typing.Union[str, int] = None
    ''' Method to use for rendering transparency * ``MASK`` Mask, Mask the background. * ``Z_TRANSPARENCY`` Z Transparency, Use alpha buffer for transparent faces. * ``RAYTRACE`` Raytrace, Use raytracing for transparent refraction rendering.

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' Material type defining how the object is rendered * ``SURFACE`` Surface, Render object as a surface. * ``WIRE`` Wire, Render the edges of faces as wires (not supported in raytracing). * ``VOLUME`` Volume, Render object as a volume. * ``HALO`` Halo, Render object as halo particles.

    :type: typing.Union[str, int]
    '''

    use_cast_approximate: bool = None
    ''' Allow this material to cast shadows when using approximate ambient occlusion

    :type: bool
    '''

    use_cast_buffer_shadows: bool = None
    ''' Allow this material to cast shadows from shadow buffer lamps

    :type: bool
    '''

    use_cast_shadows: bool = None
    ''' Allow this material to cast shadows

    :type: bool
    '''

    use_cast_shadows_only: bool = None
    ''' Make objects with this material appear invisible (not rendered), only casting shadows

    :type: bool
    '''

    use_cubic: bool = None
    ''' Use cubic interpolation for diffuse values, for smoother transitions

    :type: bool
    '''

    use_diffuse_ramp: bool = None
    ''' Toggle diffuse ramp operations

    :type: bool
    '''

    use_face_texture: bool = None
    ''' Replace the object's base color with color from UV map image textures

    :type: bool
    '''

    use_face_texture_alpha: bool = None
    ''' Replace the object's base alpha value with alpha from UV map image textures

    :type: bool
    '''

    use_full_oversampling: bool = None
    ''' Force this material to render full shading/textures for all anti-aliasing samples

    :type: bool
    '''

    use_light_group_exclusive: bool = None
    ''' Material uses the light group exclusively - these lamps are excluded from other scene lighting

    :type: bool
    '''

    use_light_group_local: bool = None
    ''' When linked in, material uses local light group with the same name

    :type: bool
    '''

    use_mist: bool = None
    ''' Use mist with this material (in world settings)

    :type: bool
    '''

    use_nodes: bool = None
    ''' Use shader nodes to render the material

    :type: bool
    '''

    use_object_color: bool = None
    ''' Modulate the result with a per-object color

    :type: bool
    '''

    use_only_shadow: bool = None
    ''' Render shadows as the material's alpha value, making the material transparent except for shadowed areas

    :type: bool
    '''

    use_ray_shadow_bias: bool = None
    ''' Prevent raytraced shadow errors on surfaces with smooth shaded normals (terminator problem)

    :type: bool
    '''

    use_raytrace: bool = None
    ''' Include this material and geometry that uses it in raytracing calculations

    :type: bool
    '''

    use_shadeless: bool = None
    ''' Make this material insensitive to light or shadow

    :type: bool
    '''

    use_shadows: bool = None
    ''' Allow this material to receive shadows

    :type: bool
    '''

    use_sky: bool = None
    ''' Render this material with zero alpha, with sky background in place (scanline only)

    :type: bool
    '''

    use_specular_ramp: bool = None
    ''' Toggle specular ramp operations

    :type: bool
    '''

    use_tangent_shading: bool = None
    ''' Use the material's tangent vector instead of the normal for shading - for anisotropic shading effects

    :type: bool
    '''

    use_textures: typing.List[bool] = None
    ''' Enable/Disable each texture

    :type: typing.List[bool]
    '''

    use_transparency: bool = None
    ''' Render material as transparent

    :type: bool
    '''

    use_transparent_shadows: bool = None
    ''' Allow this object to receive transparent shadows cast through other objects

    :type: bool
    '''

    use_uv_project: bool = None
    ''' Use to ensure UV interpolation is correct for camera projections (use with UV project modifier)

    :type: bool
    '''

    use_vertex_color_light: bool = None
    ''' Add vertex colors as additional lighting

    :type: bool
    '''

    use_vertex_color_paint: bool = None
    ''' Replace object base color with vertex colors (multiply with 'texture face' face assigned textures)

    :type: bool
    '''

    volume: 'MaterialVolume' = None
    ''' Volume settings for the material

    :type: 'MaterialVolume'
    '''


class Mesh(ID, bpy_struct):
    ''' Mesh data-block defining geometric surfaces
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    auto_smooth_angle: float = None
    ''' Maximum angle between face normals that will be considered as smooth (unused if custom split normals data are available)

    :type: float
    '''

    auto_texspace: bool = None
    ''' Adjust active object's texture space automatically when transforming object

    :type: bool
    '''

    cycles: 'CyclesMeshSettings' = None
    ''' Cycles mesh settings

    :type: 'CyclesMeshSettings'
    '''

    edges: 'MeshEdges' = None
    ''' Edges of the mesh

    :type: 'MeshEdges'
    '''

    has_custom_normals: typing.Union[bool, typing.Any] = None
    ''' True if there are custom split normals data in this mesh

    :type: typing.Union[bool, typing.Any]
    '''

    is_editmode: typing.Union[bool, typing.Any] = None
    ''' True when used in editmode

    :type: typing.Union[bool, typing.Any]
    '''

    loops: 'MeshLoops' = None
    ''' Loops of the mesh (polygon corners)

    :type: 'MeshLoops'
    '''

    materials: 'IDMaterials' = None
    ''' 

    :type: 'IDMaterials'
    '''

    polygon_layers_float: 'PolygonFloatProperties' = None
    ''' 

    :type: 'PolygonFloatProperties'
    '''

    polygon_layers_int: 'PolygonIntProperties' = None
    ''' 

    :type: 'PolygonIntProperties'
    '''

    polygon_layers_string: 'PolygonStringProperties' = None
    ''' 

    :type: 'PolygonStringProperties'
    '''

    polygons: 'MeshPolygons' = None
    ''' Polygons of the mesh

    :type: 'MeshPolygons'
    '''

    shape_keys: 'Key' = None
    ''' 

    :type: 'Key'
    '''

    show_double_sided: bool = None
    ''' Display the mesh with double or single sided lighting (OpenGL only)

    :type: bool
    '''

    show_edge_bevel_weight: bool = None
    ''' Display weights created for the Bevel modifier

    :type: bool
    '''

    show_edge_crease: bool = None
    ''' Display creases created for subsurf weighting

    :type: bool
    '''

    show_edge_seams: bool = None
    ''' Display UV unwrapping seams

    :type: bool
    '''

    show_edge_sharp: bool = None
    ''' Display sharp edges, used with the EdgeSplit modifier

    :type: bool
    '''

    show_edges: bool = None
    ''' Display selected edges using highlights in the 3D view and UV editor

    :type: bool
    '''

    show_extra_edge_angle: bool = None
    ''' Display selected edge angle, using global values when set in the transform panel

    :type: bool
    '''

    show_extra_edge_length: bool = None
    ''' Display selected edge lengths, using global values when set in the transform panel

    :type: bool
    '''

    show_extra_face_angle: bool = None
    ''' Display the angles in the selected edges, using global values when set in the transform panel

    :type: bool
    '''

    show_extra_face_area: bool = None
    ''' Display the area of selected faces, using global values when set in the transform panel

    :type: bool
    '''

    show_extra_indices: bool = None
    ''' Display the index numbers of selected vertices, edges, and faces

    :type: bool
    '''

    show_faces: bool = None
    ''' Display all faces as shades in the 3D view and UV editor

    :type: bool
    '''

    show_freestyle_edge_marks: bool = None
    ''' Display Freestyle edge marks, used with the Freestyle renderer

    :type: bool
    '''

    show_freestyle_face_marks: bool = None
    ''' Display Freestyle face marks, used with the Freestyle renderer

    :type: bool
    '''

    show_normal_face: bool = None
    ''' Display face normals as lines

    :type: bool
    '''

    show_normal_loop: bool = None
    ''' Display vertex-per-face normals as lines

    :type: bool
    '''

    show_normal_vertex: bool = None
    ''' Display vertex normals as lines

    :type: bool
    '''

    show_statvis: bool = None
    ''' Display statistical information about the mesh

    :type: bool
    '''

    show_weight: bool = None
    ''' Draw weights in editmode

    :type: bool
    '''

    skin_vertices: bpy_prop_collection['MeshSkinVertexLayer'] = None
    ''' All skin vertices

    :type: bpy_prop_collection['MeshSkinVertexLayer']
    '''

    tessface_uv_textures: 'TessfaceUVTextures' = None
    ''' All UV maps for tessellated faces (read-only, for use by renderers)

    :type: 'TessfaceUVTextures'
    '''

    tessface_vertex_colors: 'VertexColors' = None
    ''' All tessellated face colors (read-only, for use by renderers)

    :type: 'VertexColors'
    '''

    tessfaces: 'MeshTessFaces' = None
    ''' Tessellated faces of the mesh (derived from polygons)

    :type: 'MeshTessFaces'
    '''

    texco_mesh: 'Mesh' = None
    ''' Derive texture coordinates from another mesh

    :type: 'Mesh'
    '''

    texspace_location: bpy_prop_array[float] = None
    ''' Texture space location

    :type: bpy_prop_array[float]
    '''

    texspace_size: bpy_prop_array[float] = None
    ''' Texture space size

    :type: bpy_prop_array[float]
    '''

    texture_mesh: 'Mesh' = None
    ''' Use another mesh for texture indices (vertex indices must be aligned)

    :type: 'Mesh'
    '''

    total_edge_sel: int = None
    ''' Selected edge count in editmode

    :type: int
    '''

    total_face_sel: int = None
    ''' Selected face count in editmode

    :type: int
    '''

    total_vert_sel: int = None
    ''' Selected vertex count in editmode

    :type: int
    '''

    use_auto_smooth: bool = None
    ''' Auto smooth (based on smooth/sharp faces/edges and angle between faces), or use custom split normals data if available

    :type: bool
    '''

    use_auto_texspace: bool = None
    ''' Adjust active object's texture space automatically when transforming object

    :type: bool
    '''

    use_customdata_edge_bevel: bool = None
    ''' 

    :type: bool
    '''

    use_customdata_edge_crease: bool = None
    ''' 

    :type: bool
    '''

    use_customdata_vertex_bevel: bool = None
    ''' 

    :type: bool
    '''

    use_mirror_topology: bool = None
    ''' Use topology based mirroring (for when both sides of mesh have matching, unique topology)

    :type: bool
    '''

    use_mirror_x: bool = None
    ''' X Axis mirror editing

    :type: bool
    '''

    use_paint_mask: bool = None
    ''' Face selection masking for painting

    :type: bool
    '''

    use_paint_mask_vertex: bool = None
    ''' Vertex selection masking for painting (weight paint only)

    :type: bool
    '''

    uv_layer_clone: 'MeshUVLoopLayer' = None
    ''' UV loop layer to be used as cloning source

    :type: 'MeshUVLoopLayer'
    '''

    uv_layer_clone_index: int = None
    ''' Clone UV loop layer index

    :type: int
    '''

    uv_layer_stencil: 'MeshUVLoopLayer' = None
    ''' UV loop layer to mask the painted area

    :type: 'MeshUVLoopLayer'
    '''

    uv_layer_stencil_index: int = None
    ''' Mask UV loop layer index

    :type: int
    '''

    uv_layers: 'UVLoopLayers' = None
    ''' All UV loop layers

    :type: 'UVLoopLayers'
    '''

    uv_texture_clone: 'MeshTexturePolyLayer' = None
    ''' UV map to be used as cloning source

    :type: 'MeshTexturePolyLayer'
    '''

    uv_texture_clone_index: int = None
    ''' Clone UV map index

    :type: int
    '''

    uv_texture_stencil: 'MeshTexturePolyLayer' = None
    ''' UV map to mask the painted area

    :type: 'MeshTexturePolyLayer'
    '''

    uv_texture_stencil_index: int = None
    ''' Mask UV map index

    :type: int
    '''

    uv_textures: 'UVTextures' = None
    ''' All UV maps

    :type: 'UVTextures'
    '''

    vertex_colors: 'LoopColors' = None
    ''' All vertex colors

    :type: 'LoopColors'
    '''

    vertex_layers_float: 'VertexFloatProperties' = None
    ''' 

    :type: 'VertexFloatProperties'
    '''

    vertex_layers_int: 'VertexIntProperties' = None
    ''' 

    :type: 'VertexIntProperties'
    '''

    vertex_layers_string: 'VertexStringProperties' = None
    ''' 

    :type: 'VertexStringProperties'
    '''

    vertex_paint_masks: bpy_prop_collection['MeshPaintMaskLayer'] = None
    ''' Vertex paint mask

    :type: bpy_prop_collection['MeshPaintMaskLayer']
    '''

    vertices: 'MeshVertices' = None
    ''' Vertices of the mesh

    :type: 'MeshVertices'
    '''

    edge_keys = None
    ''' (readonly)'''

    def transform(self,
                  matrix: typing.Optional[typing.Iterable[float]],
                  shape_keys: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = False):
        ''' Transform mesh vertices by a matrix (Warning: inverts normals if matrix is negative)

        :param matrix: Matrix
        :type matrix: typing.Optional[typing.Iterable[float]]
        :param shape_keys: Transform Shape Keys
        :type shape_keys: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def flip_normals(self):
        ''' Invert winding of all polygons (clears tessellation, does not handle custom normals)

        '''
        pass

    def calc_normals(self):
        ''' Calculate vertex normals

        '''
        pass

    def create_normals_split(self):
        ''' Empty split vertex normals

        '''
        pass

    def calc_normals_split(self):
        ''' Calculate split vertex normals, which preserve sharp edges

        '''
        pass

    def free_normals_split(self):
        ''' Free split vertex normals

        '''
        pass

    def split_faces(self):
        ''' Spli faces based on the edge angle

        '''
        pass

    def calc_tangents(self, uvmap: typing.Union[str, typing.Any] = ""):
        ''' Compute tangents and bitangent signs, to be used together with the split normals to get a complete tangent space for normal mapping (split normals are also computed if not yet present)

        :param uvmap: Name of the UV map to use for tangent space computation
        :type uvmap: typing.Union[str, typing.Any]
        '''
        pass

    def free_tangents(self):
        ''' Free tangents

        '''
        pass

    def calc_tessface(self,
                      free_mpoly: typing.Optional[typing.Union[bool, typing.
                                                               Any]] = False):
        ''' Calculate face tessellation (supports editmode too)

        :param free_mpoly: Free MPoly, Free data used by polygons and loops. WARNING: This destructive operation removes regular faces, only used on temporary mesh data-blocks to reduce memory footprint of render engines and export scripts
        :type free_mpoly: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def calc_smooth_groups(self,
                           use_bitflags: typing.Optional[
                               typing.Union[bool, typing.Any]] = False):
        ''' Calculate smooth groups from sharp edges

        :param use_bitflags: Produce bitflags groups instead of simple numeric values
        :type use_bitflags: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def normals_split_custom_set(
            self, normals: typing.Optional[typing.Iterable[float]]):
        ''' Define custom split normals of this mesh (use zero-vectors to keep auto ones)

        :param normals: Normals
        :type normals: typing.Optional[typing.Iterable[float]]
        '''
        pass

    def normals_split_custom_set_from_vertices(
            self, normals: typing.Optional[typing.Iterable[float]]):
        ''' Define custom split normals of this mesh, from vertices' normals (use zero-vectors to keep auto ones)

        :param normals: Normals
        :type normals: typing.Optional[typing.Iterable[float]]
        '''
        pass

    def update(self,
               calc_edges: typing.Optional[typing.Union[bool, typing.
                                                        Any]] = False,
               calc_tessface: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = False):
        ''' update

        :param calc_edges: Calculate Edges, Force recalculation of edges
        :type calc_edges: typing.Optional[typing.Union[bool, typing.Any]]
        :param calc_tessface: Calculate Tessellation, Force recalculation of tessellation faces
        :type calc_tessface: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass

    def unit_test_compare(self, mesh: typing.Optional['Mesh'] = None
                          ) -> typing.Union[str, typing.Any]:
        ''' unit_test_compare

        :param mesh: Mesh to compare to
        :type mesh: typing.Optional['Mesh']
        :rtype: typing.Union[str, typing.Any]
        :return: Return value, String description of result of comparison
        '''
        pass

    def validate(
            self,
            verbose: typing.Optional[typing.Union[bool, typing.Any]] = False,
            clean_customdata: typing.Optional[
                typing.Union[bool, typing.Any]] = True) -> bool:
        ''' Validate geometry, return True when the mesh has had invalid geometry corrected/removed

        :param verbose: Verbose, Output information about the errors found
        :type verbose: typing.Optional[typing.Union[bool, typing.Any]]
        :param clean_customdata: Clean Custom Data, Remove temp/cached custom-data layers, like e.g. normals...
        :type clean_customdata: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: bool
        :return: Result
        '''
        pass

    def validate_material_indices(self) -> bool:
        ''' Validate material indices of polygons, return True when the mesh has had invalid indices corrected (to default 0)

        :rtype: bool
        :return: Result
        '''
        pass

    def from_pydata(self, vertices: typing.Optional[typing.List],
                    edges: typing.Optional[typing.List],
                    faces: typing.Optional[typing.List]):
        ''' Make a mesh from a list of vertices/edges/faces Until we have a nicer way to make geometry, use this.

        :param vertices: float triplets each representing (X, Y, Z) eg: [(0.0, 1.0, 0.5), ...].
        :type vertices: typing.Optional[typing.List]
        :param edges: int pairs, each pair contains two indices to the *vertices* argument. eg: [(1, 2), ...]
        :type edges: typing.Optional[typing.List]
        :param faces: iterator of faces, each faces contains three or more indices to the *vertices* argument. eg: [(5, 6, 8, 9), (1, 2, 3), ...]
        :type faces: typing.Optional[typing.List]
        '''
        pass


class MetaBall(ID, bpy_struct):
    ''' Metaball data-block to defined blobby surfaces
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    cycles: 'CyclesMeshSettings' = None
    ''' Cycles mesh settings

    :type: 'CyclesMeshSettings'
    '''

    elements: 'MetaBallElements' = None
    ''' Meta elements

    :type: 'MetaBallElements'
    '''

    is_editmode: typing.Union[bool, typing.Any] = None
    ''' True when used in editmode

    :type: typing.Union[bool, typing.Any]
    '''

    materials: 'IDMaterials' = None
    ''' 

    :type: 'IDMaterials'
    '''

    render_resolution: float = None
    ''' Polygonization resolution in rendering

    :type: float
    '''

    resolution: float = None
    ''' Polygonization resolution in the 3D viewport

    :type: float
    '''

    texspace_location: bpy_prop_array[float] = None
    ''' Texture space location

    :type: bpy_prop_array[float]
    '''

    texspace_size: bpy_prop_array[float] = None
    ''' Texture space size

    :type: bpy_prop_array[float]
    '''

    threshold: float = None
    ''' Influence of meta elements

    :type: float
    '''

    update_method: typing.Union[str, int] = None
    ''' Metaball edit update behavior * ``UPDATE_ALWAYS`` Always, While editing, update metaball always. * ``HALFRES`` Half, While editing, update metaball in half resolution. * ``FAST`` Fast, While editing, update metaball without polygonization. * ``NEVER`` Never, While editing, don't update metaball at all.

    :type: typing.Union[str, int]
    '''

    use_auto_texspace: bool = None
    ''' Adjust active object's texture space automatically when transforming object

    :type: bool
    '''

    def transform(self, matrix: typing.Optional[typing.Iterable[float]]):
        ''' Transform meta elements by a matrix

        :param matrix: Matrix
        :type matrix: typing.Optional[typing.Iterable[float]]
        '''
        pass


class MovieClip(ID, bpy_struct):
    ''' MovieClip data-block referencing an external movie file
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    colorspace_settings: 'ColorManagedInputColorspaceSettings' = None
    ''' Input color space settings

    :type: 'ColorManagedInputColorspaceSettings'
    '''

    display_aspect: bpy_prop_array[float] = None
    ''' Display Aspect for this clip, does not affect rendering

    :type: bpy_prop_array[float]
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Filename of the movie or sequence file

    :type: typing.Union[str, typing.Any]
    '''

    frame_duration: int = None
    ''' Detected duration of movie clip in frames

    :type: int
    '''

    frame_offset: int = None
    ''' Offset of footage first frame relative to it's file name (affects only how footage is loading, does not change data associated with a clip)

    :type: int
    '''

    frame_start: int = None
    ''' Global scene frame number at which this movie starts playing (affects all data associated with a clip)

    :type: int
    '''

    grease_pencil: 'GreasePencil' = None
    ''' Grease pencil data for this movie clip

    :type: 'GreasePencil'
    '''

    proxy: 'MovieClipProxy' = None
    ''' 

    :type: 'MovieClipProxy'
    '''

    size: bpy_prop_array[int] = None
    ''' Width and height in pixels, zero when image data cant be loaded

    :type: bpy_prop_array[int]
    '''

    source: typing.Union[str, int] = None
    ''' Where the clip comes from * ``SEQUENCE`` Image Sequence, Multiple image files, as a sequence. * ``MOVIE`` Movie File, Movie file.

    :type: typing.Union[str, int]
    '''

    tracking: 'MovieTracking' = None
    ''' 

    :type: 'MovieTracking'
    '''

    use_proxy: bool = None
    ''' Use a preview proxy and/or timecode index for this clip

    :type: bool
    '''

    use_proxy_custom_directory: bool = None
    ''' Create proxy images in a custom directory (default is movie location)

    :type: bool
    '''


class NodeTree(ID, bpy_struct):
    ''' Node tree consisting of linked nodes used for shading, textures and compositing
    '''

    active_input: int = None
    ''' Index of the active input

    :type: int
    '''

    active_output: int = None
    ''' Index of the active output

    :type: int
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    bl_description: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_icon: typing.Union[str, int] = None
    ''' The node tree icon

    :type: typing.Union[str, int]
    '''

    bl_idname: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    bl_label: typing.Union[str, typing.Any] = None
    ''' The node tree label

    :type: typing.Union[str, typing.Any]
    '''

    grease_pencil: 'GreasePencil' = None
    ''' Grease Pencil data-block

    :type: 'GreasePencil'
    '''

    inputs: 'NodeTreeInputs' = None
    ''' Node tree inputs

    :type: 'NodeTreeInputs'
    '''

    links: 'NodeLinks' = None
    ''' 

    :type: 'NodeLinks'
    '''

    nodes: 'Nodes' = None
    ''' 

    :type: 'Nodes'
    '''

    outputs: 'NodeTreeOutputs' = None
    ''' Node tree outputs

    :type: 'NodeTreeOutputs'
    '''

    type: typing.Union[str, int] = None
    ''' Node Tree type (deprecated, bl_idname is the actual node tree type identifier) * ``SHADER`` Shader, Shader nodes. * ``TEXTURE`` Texture, Texture nodes. * ``COMPOSITING`` Compositing, Compositing nodes.

    :type: typing.Union[str, int]
    '''

    view_center: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    def interface_update(self, context: 'Context'):
        ''' Updated node group interface

        :param context: 
        :type context: 'Context'
        '''
        pass

    @classmethod
    def poll(cls, context: 'Context') -> bool:
        ''' Check visibility in the editor

        :param context: 
        :type context: 'Context'
        :rtype: bool
        '''
        pass

    def update(self):
        ''' Update on editor changes

        '''
        pass

    @classmethod
    def get_from_context(cls, context: 'Context'):
        ''' Get a node tree from the context

        :param context: 
        :type context: 'Context'
        '''
        pass


class Object(ID, bpy_struct):
    ''' Object data-block defining an object in a scene
    '''

    active_material: 'Material' = None
    ''' Active material being displayed

    :type: 'Material'
    '''

    active_material_index: int = None
    ''' Index of active material slot

    :type: int
    '''

    active_shape_key: 'ShapeKey' = None
    ''' Current shape key

    :type: 'ShapeKey'
    '''

    active_shape_key_index: int = None
    ''' Current shape key index

    :type: int
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    animation_visualization: 'AnimViz' = None
    ''' Animation data for this data-block

    :type: 'AnimViz'
    '''

    bound_box: bpy_prop_array[float] = None
    ''' Object's bounding box in object-space coordinates, all values are -1.0 when not available

    :type: bpy_prop_array[float]
    '''

    collision: 'CollisionSettings' = None
    ''' Settings for using the object as a collider in physics simulation

    :type: 'CollisionSettings'
    '''

    color: bpy_prop_array[float] = None
    ''' Object color and alpha, used when faces have the ObColor mode enabled

    :type: bpy_prop_array[float]
    '''

    constraints: 'ObjectConstraints' = None
    ''' Constraints affecting the transformation of the object

    :type: 'ObjectConstraints'
    '''

    cycles: 'CyclesObjectSettings' = None
    ''' Cycles object settings

    :type: 'CyclesObjectSettings'
    '''

    cycles_visibility: 'CyclesVisibilitySettings' = None
    ''' Cycles visibility settings

    :type: 'CyclesVisibilitySettings'
    '''

    data: 'ID' = None
    ''' Object data

    :type: 'ID'
    '''

    delta_location: bpy_prop_array[float] = None
    ''' Extra translation added to the location of the object

    :type: bpy_prop_array[float]
    '''

    delta_rotation_euler: bpy_prop_array[float] = None
    ''' Extra rotation added to the rotation of the object (when using Euler rotations)

    :type: bpy_prop_array[float]
    '''

    delta_rotation_quaternion: bpy_prop_array[float] = None
    ''' Extra rotation added to the rotation of the object (when using Quaternion rotations)

    :type: bpy_prop_array[float]
    '''

    delta_scale: bpy_prop_array[float] = None
    ''' Extra scaling added to the scale of the object

    :type: bpy_prop_array[float]
    '''

    dimensions: bpy_prop_array[float] = None
    ''' Absolute bounding box dimensions of the object

    :type: bpy_prop_array[float]
    '''

    draw_bounds_type: typing.Union[str, int] = None
    ''' Object boundary display type * ``BOX`` Box, Draw bounds as box. * ``SPHERE`` Sphere, Draw bounds as sphere. * ``CYLINDER`` Cylinder, Draw bounds as cylinder. * ``CONE`` Cone, Draw bounds as cone. * ``CAPSULE`` Capsule, Draw bounds as capsule.

    :type: typing.Union[str, int]
    '''

    draw_type: typing.Union[str, int] = None
    ''' Maximum draw type to display object with in viewport * ``BOUNDS`` Bounds, Draw the bounds of the object. * ``WIRE`` Wire, Draw the object as a wireframe. * ``SOLID`` Solid, Draw the object as a solid (if solid drawing is enabled in the viewport). * ``TEXTURED`` Textured, Draw the object with textures (if textures are enabled in the viewport).

    :type: typing.Union[str, int]
    '''

    dupli_faces_scale: float = None
    ''' Scale the DupliFace objects

    :type: float
    '''

    dupli_frames_end: int = None
    ''' End frame for DupliFrames

    :type: int
    '''

    dupli_frames_off: int = None
    ''' Recurring frames to exclude from the Dupliframes

    :type: int
    '''

    dupli_frames_on: int = None
    ''' Number of frames to use between DupOff frames

    :type: int
    '''

    dupli_frames_start: int = None
    ''' Start frame for DupliFrames

    :type: int
    '''

    dupli_group: 'Group' = None
    ''' Instance an existing group

    :type: 'Group'
    '''

    dupli_list: bpy_prop_collection['DupliObject'] = None
    ''' Object duplis

    :type: bpy_prop_collection['DupliObject']
    '''

    dupli_type: typing.Union[str, int] = None
    ''' If not None, object duplication method to use * ``NONE`` None. * ``FRAMES`` Frames, Make copy of object for every frame. * ``VERTS`` Verts, Duplicate child objects on all vertices. * ``FACES`` Faces, Duplicate child objects on all faces. * ``GROUP`` Group, Enable group instancing.

    :type: typing.Union[str, int]
    '''

    empty_draw_size: float = None
    ''' Size of display for empties in the viewport

    :type: float
    '''

    empty_draw_type: typing.Union[str, int] = None
    ''' Viewport display style for empties

    :type: typing.Union[str, int]
    '''

    empty_image_offset: bpy_prop_array[float] = None
    ''' Origin offset distance

    :type: bpy_prop_array[float]
    '''

    field: 'FieldSettings' = None
    ''' Settings for using the object as a field in physics simulation

    :type: 'FieldSettings'
    '''

    game: 'GameObjectSettings' = None
    ''' Game engine related settings for the object

    :type: 'GameObjectSettings'
    '''

    grease_pencil: 'GreasePencil' = None
    ''' Grease Pencil data-block

    :type: 'GreasePencil'
    '''

    hide: bool = None
    ''' Restrict visibility in the viewport

    :type: bool
    '''

    hide_render: bool = None
    ''' Restrict renderability

    :type: bool
    '''

    hide_select: bool = None
    ''' Restrict selection in the viewport

    :type: bool
    '''

    image_user: 'ImageUser' = None
    ''' Parameters defining which layer, pass and frame of the image is displayed

    :type: 'ImageUser'
    '''

    is_duplicator: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    layers: typing.List[bool] = None
    ''' Layers the object is on

    :type: typing.List[bool]
    '''

    layers_local_view: typing.List[bool] = None
    ''' 3D local view layers the object is on

    :type: typing.List[bool]
    '''

    location: bpy_prop_array[float] = None
    ''' Location of the object

    :type: bpy_prop_array[float]
    '''

    lock_location: typing.List[bool] = None
    ''' Lock editing of location in the interface

    :type: typing.List[bool]
    '''

    lock_rotation: typing.List[bool] = None
    ''' Lock editing of rotation in the interface

    :type: typing.List[bool]
    '''

    lock_rotation_w: bool = None
    ''' Lock editing of 'angle' component of four-component rotations in the interface

    :type: bool
    '''

    lock_rotations_4d: bool = None
    ''' Lock editing of four component rotations by components (instead of as Eulers)

    :type: bool
    '''

    lock_scale: typing.List[bool] = None
    ''' Lock editing of scale in the interface

    :type: typing.List[bool]
    '''

    lod_levels: bpy_prop_collection['LodLevel'] = None
    ''' A collection of detail levels to automatically switch between

    :type: bpy_prop_collection['LodLevel']
    '''

    material_slots: bpy_prop_collection['MaterialSlot'] = None
    ''' Material slots in the object

    :type: bpy_prop_collection['MaterialSlot']
    '''

    matrix_basis: bpy_prop_array[float] = None
    ''' Matrix access to location, rotation and scale (including deltas), before constraints and parenting are applied

    :type: bpy_prop_array[float]
    '''

    matrix_local: bpy_prop_array[float] = None
    ''' Parent relative transformation matrix - WARNING: Only takes into account 'Object' parenting, so e.g. in case of bone parenting you get a matrix relative to the Armature object, not to the actual parent bone

    :type: bpy_prop_array[float]
    '''

    matrix_parent_inverse: bpy_prop_array[float] = None
    ''' Inverse of object's parent matrix at time of parenting

    :type: bpy_prop_array[float]
    '''

    matrix_world: bpy_prop_array[float] = None
    ''' Worldspace transformation matrix

    :type: bpy_prop_array[float]
    '''

    mode: typing.Union[str, int] = None
    ''' Object interaction mode * ``OBJECT`` Object Mode. * ``EDIT`` Edit Mode. * ``POSE`` Pose Mode. * ``SCULPT`` Sculpt Mode. * ``VERTEX_PAINT`` Vertex Paint. * ``WEIGHT_PAINT`` Weight Paint. * ``TEXTURE_PAINT`` Texture Paint. * ``PARTICLE_EDIT`` Particle Edit. * ``GPENCIL_EDIT`` Edit Strokes, Edit Grease Pencil Strokes.

    :type: typing.Union[str, int]
    '''

    modifiers: 'ObjectModifiers' = None
    ''' Modifiers affecting the geometric data of the object

    :type: 'ObjectModifiers'
    '''

    motion_path: 'MotionPath' = None
    ''' Motion Path for this element

    :type: 'MotionPath'
    '''

    parent: 'Object' = None
    ''' Parent Object

    :type: 'Object'
    '''

    parent_bone: typing.Union[str, typing.Any] = None
    ''' Name of parent bone in case of a bone parenting relation

    :type: typing.Union[str, typing.Any]
    '''

    parent_type: typing.Union[str, int] = None
    ''' Type of parent relation * ``OBJECT`` Object, The object is parented to an object. * ``ARMATURE`` Armature. * ``LATTICE`` Lattice, The object is parented to a lattice. * ``VERTEX`` Vertex, The object is parented to a vertex. * ``VERTEX_3`` 3 Vertices. * ``BONE`` Bone, The object is parented to a bone.

    :type: typing.Union[str, int]
    '''

    parent_vertices: bpy_prop_array[int] = None
    ''' Indices of vertices in case of a vertex parenting relation

    :type: bpy_prop_array[int]
    '''

    particle_systems: 'ParticleSystems' = None
    ''' Particle systems emitted from the object

    :type: 'ParticleSystems'
    '''

    pass_index: int = None
    ''' Index number for the "Object Index" render pass

    :type: int
    '''

    pose: 'Pose' = None
    ''' Current pose for armatures

    :type: 'Pose'
    '''

    pose_library: 'Action' = None
    ''' Action used as a pose library for armatures

    :type: 'Action'
    '''

    proxy: 'Object' = None
    ''' Library object this proxy object controls

    :type: 'Object'
    '''

    proxy_group: 'Object' = None
    ''' Library group duplicator object this proxy object controls

    :type: 'Object'
    '''

    rigid_body: 'RigidBodyObject' = None
    ''' Settings for rigid body simulation

    :type: 'RigidBodyObject'
    '''

    rigid_body_constraint: 'RigidBodyConstraint' = None
    ''' Constraint constraining rigid bodies

    :type: 'RigidBodyConstraint'
    '''

    rotation_axis_angle: bpy_prop_array[float] = None
    ''' Angle of Rotation for Axis-Angle rotation representation

    :type: bpy_prop_array[float]
    '''

    rotation_euler: bpy_prop_array[float] = None
    ''' Rotation in Eulers

    :type: bpy_prop_array[float]
    '''

    rotation_mode: typing.Union[str, int] = None
    ''' * ``QUATERNION`` Quaternion (WXYZ), No Gimbal Lock. * ``XYZ`` XYZ Euler, XYZ Rotation Order - prone to Gimbal Lock (default). * ``XZY`` XZY Euler, XZY Rotation Order - prone to Gimbal Lock. * ``YXZ`` YXZ Euler, YXZ Rotation Order - prone to Gimbal Lock. * ``YZX`` YZX Euler, YZX Rotation Order - prone to Gimbal Lock. * ``ZXY`` ZXY Euler, ZXY Rotation Order - prone to Gimbal Lock. * ``ZYX`` ZYX Euler, ZYX Rotation Order - prone to Gimbal Lock. * ``AXIS_ANGLE`` Axis Angle, Axis Angle (W+XYZ), defines a rotation around some axis defined by 3D-Vector.

    :type: typing.Union[str, int]
    '''

    rotation_quaternion: bpy_prop_array[float] = None
    ''' Rotation in Quaternions

    :type: bpy_prop_array[float]
    '''

    scale: bpy_prop_array[float] = None
    ''' Scaling of the object

    :type: bpy_prop_array[float]
    '''

    select: bool = None
    ''' Object selection state

    :type: bool
    '''

    show_all_edges: bool = None
    ''' Display all edges for mesh objects

    :type: bool
    '''

    show_axis: bool = None
    ''' Display the object's origin and axes

    :type: bool
    '''

    show_bounds: bool = None
    ''' Display the object's bounds

    :type: bool
    '''

    show_name: bool = None
    ''' Display the object's name

    :type: bool
    '''

    show_only_shape_key: bool = None
    ''' Always show the current Shape for this Object

    :type: bool
    '''

    show_texture_space: bool = None
    ''' Display the object's texture space

    :type: bool
    '''

    show_transparent: bool = None
    ''' Display material transparency in the object (unsupported for duplicator drawing)

    :type: bool
    '''

    show_wire: bool = None
    ''' Add the object's wireframe over solid drawing

    :type: bool
    '''

    show_x_ray: bool = None
    ''' Make the object draw in front of others (unsupported for duplicator drawing)

    :type: bool
    '''

    slow_parent_offset: float = None
    ''' Delay in the parent relationship

    :type: float
    '''

    soft_body: 'SoftBodySettings' = None
    ''' Settings for soft body simulation

    :type: 'SoftBodySettings'
    '''

    track_axis: typing.Union[str, int] = None
    ''' Axis that points in 'forward' direction (applies to DupliFrame when parent 'Follow' is enabled)

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    ''' Type of Object

    :type: typing.Union[str, int]
    '''

    up_axis: typing.Union[str, int] = None
    ''' Axis that points in the upward direction (applies to DupliFrame when parent 'Follow' is enabled)

    :type: typing.Union[str, int]
    '''

    use_dupli_faces_scale: bool = None
    ''' Scale dupli based on face size

    :type: bool
    '''

    use_dupli_frames_speed: bool = None
    ''' Set dupliframes to use the current frame instead of parent curve's evaluation time

    :type: bool
    '''

    use_dupli_vertices_rotation: bool = None
    ''' Rotate dupli according to vertex normal

    :type: bool
    '''

    use_dynamic_topology_sculpting: typing.Union[bool, typing.Any] = None
    ''' 

    :type: typing.Union[bool, typing.Any]
    '''

    use_extra_recalc_data: bool = None
    ''' Refresh this object's data again on frame changes, dependency graph hack

    :type: bool
    '''

    use_extra_recalc_object: bool = None
    ''' Refresh this object again on frame changes, dependency graph hack

    :type: bool
    '''

    use_shape_key_edit_mode: bool = None
    ''' Apply shape keys in edit mode (for Meshes only)

    :type: bool
    '''

    use_slow_parent: bool = None
    ''' Create a delay in the parent relationship (beware: this isn't renderfarm safe and may be invalid after jumping around the timeline)

    :type: bool
    '''

    vertex_groups: 'VertexGroups' = None
    ''' Vertex groups of the object

    :type: 'VertexGroups'
    '''

    children = None
    ''' All the children of this object (readonly)'''

    users_group = None
    ''' The groups this object is in (readonly)'''

    users_scene = None
    ''' The scenes this object is in (readonly)'''

    def convert_space(
            self,
            pose_bone: typing.Optional['PoseBone'] = None,
            matrix: typing.Optional[typing.Any] = (0.0, 0.0, 0.0, 0.0, 0.0,
                                                   0.0, 0.0, 0.0, 0.0, 0.0,
                                                   0.0, 0.0, 0.0, 0.0, 0.0,
                                                   0.0),
            from_space: typing.Optional[typing.Any] = 'WORLD',
            to_space: typing.Optional[typing.Any] = 'WORLD'
    ) -> bpy_prop_array[float]:
        ''' Convert (transform) the given matrix from one space to another

        :param pose_bone: Bone to use to define spaces (may be None, in which case only the two 'WORLD' and 'LOCAL' spaces are usable)
        :type pose_bone: typing.Optional['PoseBone']
        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Any]
        :param from_space: The space in which 'matrix' is currently * ``WORLD`` World Space, The most gobal space in Blender. * ``POSE`` Pose Space, The pose space of a bone (its armature's object space). * ``LOCAL_WITH_PARENT`` Local With Parent, The local space of a bone's parent bone. * ``LOCAL`` Local Space, The local space of an object/bone.
        :type from_space: typing.Optional[typing.Any]
        :param to_space: The space to which you want to transform 'matrix' * ``WORLD`` World Space, The most gobal space in Blender. * ``POSE`` Pose Space, The pose space of a bone (its armature's object space). * ``LOCAL_WITH_PARENT`` Local With Parent, The local space of a bone's parent bone. * ``LOCAL`` Local Space, The local space of an object/bone.
        :type to_space: typing.Optional[typing.Any]
        :rtype: bpy_prop_array[float]
        :return: The transformed matrix
        '''
        pass

    def calc_matrix_camera(self,
                           x: typing.Optional[typing.Any] = 1,
                           y: typing.Optional[typing.Any] = 1,
                           scale_x: typing.Optional[typing.Any] = 1.0,
                           scale_y: typing.Optional[typing.Any] = 1.0
                           ) -> bpy_prop_array[float]:
        ''' Generate the camera projection matrix of this object (mostly useful for Camera and Lamp types)

        :param x: Width of the render area
        :type x: typing.Optional[typing.Any]
        :param y: Height of the render area
        :type y: typing.Optional[typing.Any]
        :param scale_x: Width scaling factor
        :type scale_x: typing.Optional[typing.Any]
        :param scale_y: height scaling factor
        :type scale_y: typing.Optional[typing.Any]
        :rtype: bpy_prop_array[float]
        :return: The camera projection matrix
        '''
        pass

    def camera_fit_coords(self, scene: typing.Optional['Scene'],
                          coordinates: typing.Any):
        ''' Compute the coordinate (and scale for ortho cameras) given object should be to 'see' all given coordinates

        :param scene: Scene to get render size information from, if available
        :type scene: typing.Optional['Scene']
        :param coordinates: Coordinates to fit in
        :type coordinates: typing.Any
        '''
        pass

    def to_mesh(self,
                scene: 'Scene',
                apply_modifiers: typing.Optional[bool],
                settings: typing.Optional[typing.Union[str, int]],
                calc_tessface: typing.Optional[typing.Union[bool, typing.
                                                            Any]] = True,
                calc_undeformed: typing.Optional[
                    typing.Union[bool, typing.Any]] = False) -> 'Mesh':
        ''' Create a Mesh data-block with modifiers applied

        :param scene: Scene within which to evaluate modifiers
        :type scene: 'Scene'
        :param apply_modifiers: Apply modifiers
        :type apply_modifiers: typing.Optional[bool]
        :param settings: Modifier settings to apply * ``PREVIEW`` Preview, Apply modifier preview settings. * ``RENDER`` Render, Apply modifier render settings.
        :type settings: typing.Optional[typing.Union[str, int]]
        :param calc_tessface: Calculate Tessellation, Calculate tessellation faces
        :type calc_tessface: typing.Optional[typing.Union[bool, typing.Any]]
        :param calc_undeformed: Calculate Undeformed, Calculate undeformed vertex coordinates
        :type calc_undeformed: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'Mesh'
        :return: Mesh created from object, remove it if it is only used for export
        '''
        pass

    def dupli_list_create(self,
                          scene: 'Scene',
                          settings: typing.Optional[typing.Any] = 'VIEWPORT'):
        ''' Create a list of dupli objects for this object, needs to be freed manually with free_dupli_list to restore the objects real matrix and layers

        :param scene: Scene within which to evaluate duplis
        :type scene: 'Scene'
        :param settings: Generate texture coordinates for rendering * ``VIEWPORT`` Viewport, Generate duplis using viewport settings. * ``PREVIEW`` Preview, Generate duplis using preview settings. * ``RENDER`` Render, Generate duplis using render settings.
        :type settings: typing.Optional[typing.Any]
        '''
        pass

    def dupli_list_clear(self):
        ''' Free the list of dupli objects

        '''
        pass

    def find_armature(self) -> 'Object':
        ''' Find armature influencing this object as a parent or via a modifier

        :rtype: 'Object'
        :return: Armature object influencing this object or NULL
        '''
        pass

    def shape_key_add(
            self,
            name: typing.Union[str, typing.Any] = "Key",
            from_mix: typing.Optional[typing.Union[bool, typing.Any]] = True
    ) -> 'ShapeKey':
        ''' Add shape key to this object

        :param name: Unique name for the new keyblock
        :type name: typing.Union[str, typing.Any]
        :param from_mix: Create new shape from existing mix of shapes
        :type from_mix: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ShapeKey'
        :return: New shape keyblock
        '''
        pass

    def shape_key_remove(self, key: 'ShapeKey'):
        ''' Remove a Shape Key from this object

        :param key: Keyblock to be removed
        :type key: 'ShapeKey'
        '''
        pass

    def ray_cast(self,
                 origin: typing.Optional[typing.Iterable[float]],
                 direction: typing.Optional[typing.Iterable[float]],
                 distance: typing.Optional[typing.Any] = 1.70141e+38):
        ''' Cast a ray onto in object space

        :param origin: 
        :type origin: typing.Optional[typing.Iterable[float]]
        :param direction: 
        :type direction: typing.Optional[typing.Iterable[float]]
        :param distance: Maximum distance
        :type distance: typing.Optional[typing.Any]
        '''
        pass

    def closest_point_on_mesh(
            self,
            origin: typing.Optional[typing.Iterable[float]],
            distance: typing.Optional[typing.Any] = 1.84467e+19):
        ''' Find the nearest point in object space

        :param origin: 
        :type origin: typing.Optional[typing.Iterable[float]]
        :param distance: Maximum distance
        :type distance: typing.Optional[typing.Any]
        '''
        pass

    def is_visible(self, scene: 'Scene') -> bool:
        ''' Determine if object is visible in a given scene

        :param scene: 
        :type scene: 'Scene'
        :rtype: bool
        :return: Object visibility
        '''
        pass

    def is_modified(self, scene: 'Scene',
                    settings: typing.Optional[typing.Union[str, int]]) -> bool:
        ''' Determine if this object is modified from the base mesh data

        :param scene: 
        :type scene: 'Scene'
        :param settings: Modifier settings to apply * ``PREVIEW`` Preview, Apply modifier preview settings. * ``RENDER`` Render, Apply modifier render settings.
        :type settings: typing.Optional[typing.Union[str, int]]
        :rtype: bool
        :return: Object visibility
        '''
        pass

    def is_deform_modified(
            self, scene: 'Scene',
            settings: typing.Optional[typing.Union[str, int]]) -> bool:
        ''' Determine if this object is modified by a deformation from the base mesh data

        :param scene: 
        :type scene: 'Scene'
        :param settings: Modifier settings to apply * ``PREVIEW`` Preview, Apply modifier preview settings. * ``RENDER`` Render, Apply modifier render settings.
        :type settings: typing.Optional[typing.Union[str, int]]
        :rtype: bool
        :return: Object visibility
        '''
        pass

    def update_from_editmode(self) -> bool:
        ''' Load the objects edit-mode data into the object data

        :rtype: bool
        :return: Success
        '''
        pass

    def cache_release(self):
        ''' Release memory used by caches associated with this object. Intended to be used by render engines only

        '''
        pass


class PaintCurve(ID, bpy_struct):
    pass


class Palette(ID, bpy_struct):
    colors: 'PaletteColors' = None
    ''' 

    :type: 'PaletteColors'
    '''


class ParticleSettings(ID, bpy_struct):
    ''' Particle settings, reusable by multiple particle systems
    '''

    active_dupliweight: 'ParticleDupliWeight' = None
    ''' 

    :type: 'ParticleDupliWeight'
    '''

    active_dupliweight_index: int = None
    ''' 

    :type: int
    '''

    active_texture: 'Texture' = None
    ''' Active texture slot being displayed

    :type: 'Texture'
    '''

    active_texture_index: int = None
    ''' Index of active texture slot

    :type: int
    '''

    adaptive_angle: int = None
    ''' How many degrees path has to curve to make another render segment

    :type: int
    '''

    adaptive_pixel: int = None
    ''' How many pixels path has to cover to make another render segment

    :type: int
    '''

    angular_velocity_factor: float = None
    ''' Angular velocity amount (in radians per second)

    :type: float
    '''

    angular_velocity_mode: typing.Union[str, int] = None
    ''' What axis is used to change particle rotation with time

    :type: typing.Union[str, int]
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    apply_effector_to_children: bool = None
    ''' Apply effectors to children

    :type: bool
    '''

    apply_guide_to_children: bool = None
    ''' 

    :type: bool
    '''

    bending_random: float = None
    ''' Random stiffness of hairs

    :type: float
    '''

    billboard_align: typing.Union[str, int] = None
    ''' In respect to what the billboards are aligned

    :type: typing.Union[str, int]
    '''

    billboard_animation: typing.Union[str, int] = None
    ''' How to animate billboard textures

    :type: typing.Union[str, int]
    '''

    billboard_object: 'Object' = None
    ''' Billboards face this object (default is active camera)

    :type: 'Object'
    '''

    billboard_offset: bpy_prop_array[float] = None
    ''' 

    :type: bpy_prop_array[float]
    '''

    billboard_offset_split: typing.Union[str, int] = None
    ''' How to offset billboard textures

    :type: typing.Union[str, int]
    '''

    billboard_size: bpy_prop_array[float] = None
    ''' Scale billboards relative to particle size

    :type: bpy_prop_array[float]
    '''

    billboard_tilt: float = None
    ''' Tilt of the billboards

    :type: float
    '''

    billboard_tilt_random: float = None
    ''' Random tilt of the billboards

    :type: float
    '''

    billboard_uv_split: int = None
    ''' Number of rows/columns to split UV coordinates for billboards

    :type: int
    '''

    billboard_velocity_head: float = None
    ''' Scale billboards by velocity

    :type: float
    '''

    billboard_velocity_tail: float = None
    ''' Scale billboards by velocity

    :type: float
    '''

    boids: 'BoidSettings' = None
    ''' 

    :type: 'BoidSettings'
    '''

    branch_threshold: float = None
    ''' Threshold of branching

    :type: float
    '''

    brownian_factor: float = None
    ''' Amount of random, erratic particle movement

    :type: float
    '''

    child_length: float = None
    ''' Length of child paths

    :type: float
    '''

    child_length_threshold: float = None
    ''' Amount of particles left untouched by child path length

    :type: float
    '''

    child_nbr: int = None
    ''' Number of children/parent

    :type: int
    '''

    child_parting_factor: float = None
    ''' Create parting in the children based on parent strands

    :type: float
    '''

    child_parting_max: float = None
    ''' Maximum root to tip angle (tip distance/root distance for long hair)

    :type: float
    '''

    child_parting_min: float = None
    ''' Minimum root to tip angle (tip distance/root distance for long hair)

    :type: float
    '''

    child_radius: float = None
    ''' Radius of children around parent

    :type: float
    '''

    child_roundness: float = None
    ''' Roundness of children around parent

    :type: float
    '''

    child_size: float = None
    ''' A multiplier for the child particle size

    :type: float
    '''

    child_size_random: float = None
    ''' Random variation to the size of the child particles

    :type: float
    '''

    child_type: typing.Union[str, int] = None
    ''' Create child particles

    :type: typing.Union[str, int]
    '''

    clump_curve: 'CurveMapping' = None
    ''' Curve defining clump tapering

    :type: 'CurveMapping'
    '''

    clump_factor: float = None
    ''' Amount of clumping

    :type: float
    '''

    clump_noise_size: float = None
    ''' Size of clump noise

    :type: float
    '''

    clump_shape: float = None
    ''' Shape of clumping

    :type: float
    '''

    collision_group: 'Group' = None
    ''' Limit colliders to this Group

    :type: 'Group'
    '''

    color_maximum: float = None
    ''' Maximum length of the particle color vector

    :type: float
    '''

    count: int = None
    ''' Total number of particles

    :type: int
    '''

    courant_target: float = None
    ''' The relative distance a particle can move before requiring more subframes (target Courant number); 0.01-0.3 is the recommended range

    :type: float
    '''

    create_long_hair_children: bool = None
    ''' Calculate children that suit long hair well

    :type: bool
    '''

    cycles: 'CyclesCurveSettings' = None
    ''' Cycles hair settings

    :type: 'CyclesCurveSettings'
    '''

    damping: float = None
    ''' Amount of damping

    :type: float
    '''

    distribution: typing.Union[str, int] = None
    ''' How to distribute particles on selected element

    :type: typing.Union[str, int]
    '''

    drag_factor: float = None
    ''' Amount of air-drag

    :type: float
    '''

    draw_color: typing.Union[str, int] = None
    ''' Draw additional particle data as a color

    :type: typing.Union[str, int]
    '''

    draw_method: typing.Union[str, int] = None
    ''' How particles are drawn in viewport

    :type: typing.Union[str, int]
    '''

    draw_percentage: int = None
    ''' Percentage of particles to display in 3D view

    :type: int
    '''

    draw_size: int = None
    ''' Size of particles on viewport in pixels (0=default)

    :type: int
    '''

    draw_step: int = None
    ''' How many steps paths are drawn with (power of 2)

    :type: int
    '''

    dupli_group: 'Group' = None
    ''' Show Objects in this Group in place of particles

    :type: 'Group'
    '''

    dupli_object: 'Object' = None
    ''' Show this Object in place of particles

    :type: 'Object'
    '''

    dupli_weights: bpy_prop_collection['ParticleDupliWeight'] = None
    ''' Weights for all of the objects in the dupli group

    :type: bpy_prop_collection['ParticleDupliWeight']
    '''

    effect_hair: float = None
    ''' Hair stiffness for effectors

    :type: float
    '''

    effector_amount: int = None
    ''' How many particles are effectors (0 is all particles)

    :type: int
    '''

    effector_weights: 'EffectorWeights' = None
    ''' 

    :type: 'EffectorWeights'
    '''

    emit_from: typing.Union[str, int] = None
    ''' Where to emit particles from

    :type: typing.Union[str, int]
    '''

    factor_random: float = None
    ''' Give the starting velocity a random variation

    :type: float
    '''

    fluid: 'SPHFluidSettings' = None
    ''' 

    :type: 'SPHFluidSettings'
    '''

    force_field_1: 'FieldSettings' = None
    ''' 

    :type: 'FieldSettings'
    '''

    force_field_2: 'FieldSettings' = None
    ''' 

    :type: 'FieldSettings'
    '''

    frame_end: float = None
    ''' Frame number to stop emitting particles

    :type: float
    '''

    frame_start: float = None
    ''' Frame number to start emitting particles

    :type: float
    '''

    grid_random: float = None
    ''' Add random offset to the grid locations

    :type: float
    '''

    grid_resolution: int = None
    ''' The resolution of the particle grid

    :type: int
    '''

    hair_length: float = None
    ''' Length of the hair

    :type: float
    '''

    hair_step: int = None
    ''' Number of hair segments

    :type: int
    '''

    hexagonal_grid: bool = None
    ''' Create the grid in a hexagonal pattern

    :type: bool
    '''

    integrator: typing.Union[str, int] = None
    ''' Algorithm used to calculate physics, from the fastest to the most stable/accurate: Midpoint, Euler, Verlet, RK4 (Old)

    :type: typing.Union[str, int]
    '''

    invert_grid: bool = None
    ''' Invert what is considered object and what is not

    :type: bool
    '''

    is_fluid: typing.Union[bool, typing.Any] = None
    ''' Particles were created by a fluid simulation

    :type: typing.Union[bool, typing.Any]
    '''

    jitter_factor: float = None
    ''' Amount of jitter applied to the sampling

    :type: float
    '''

    keyed_loops: int = None
    ''' Number of times the keys are looped

    :type: int
    '''

    keys_step: int = None
    ''' 

    :type: int
    '''

    kink: typing.Union[str, int] = None
    ''' Type of periodic offset on the path

    :type: typing.Union[str, int]
    '''

    kink_amplitude: float = None
    ''' The amplitude of the offset

    :type: float
    '''

    kink_amplitude_clump: float = None
    ''' How much clump affects kink amplitude

    :type: float
    '''

    kink_amplitude_random: float = None
    ''' Random variation of the amplitude

    :type: float
    '''

    kink_axis: typing.Union[str, int] = None
    ''' Which axis to use for offset

    :type: typing.Union[str, int]
    '''

    kink_axis_random: float = None
    ''' Random variation of the orientation

    :type: float
    '''

    kink_extra_steps: int = None
    ''' Extra steps for resolution of special kink features

    :type: int
    '''

    kink_flat: float = None
    ''' How flat the hairs are

    :type: float
    '''

    kink_frequency: float = None
    ''' The frequency of the offset (1/total length)

    :type: float
    '''

    kink_shape: float = None
    ''' Adjust the offset to the beginning/end

    :type: float
    '''

    length_random: float = None
    ''' Give path length a random variation

    :type: float
    '''

    lifetime: float = None
    ''' Life span of the particles

    :type: float
    '''

    lifetime_random: float = None
    ''' Give the particle life a random variation

    :type: float
    '''

    line_length_head: float = None
    ''' Length of the line's head

    :type: float
    '''

    line_length_tail: float = None
    ''' Length of the line's tail

    :type: float
    '''

    lock_billboard: bool = None
    ''' Lock the billboards align axis

    :type: bool
    '''

    lock_boids_to_surface: bool = None
    ''' Constrain boids to a surface

    :type: bool
    '''

    mass: float = None
    ''' Mass of the particles

    :type: float
    '''

    material: int = None
    ''' Index of material slot used for rendering particles

    :type: int
    '''

    material_slot: typing.Union[str, int] = None
    ''' Material slot used for rendering particles

    :type: typing.Union[str, int]
    '''

    normal_factor: float = None
    ''' Let the surface normal give the particle a starting velocity

    :type: float
    '''

    object_align_factor: bpy_prop_array[float] = None
    ''' Let the emitter object orientation give the particle a starting velocity

    :type: bpy_prop_array[float]
    '''

    object_factor: float = None
    ''' Let the object give the particle a starting velocity

    :type: float
    '''

    particle_factor: float = None
    ''' Let the target particle give the particle a starting velocity

    :type: float
    '''

    particle_size: float = None
    ''' The size of the particles

    :type: float
    '''

    path_end: float = None
    ''' End time of drawn path

    :type: float
    '''

    path_start: float = None
    ''' Starting time of drawn path

    :type: float
    '''

    phase_factor: float = None
    ''' Rotation around the chosen orientation axis

    :type: float
    '''

    phase_factor_random: float = None
    ''' Randomize rotation around the chosen orientation axis

    :type: float
    '''

    physics_type: typing.Union[str, int] = None
    ''' Particle physics type

    :type: typing.Union[str, int]
    '''

    react_event: typing.Union[str, int] = None
    ''' The event of target particles to react on

    :type: typing.Union[str, int]
    '''

    reactor_factor: float = None
    ''' Let the vector away from the target particle's location give the particle a starting velocity

    :type: float
    '''

    regrow_hair: bool = None
    ''' Regrow hair for each frame

    :type: bool
    '''

    render_step: int = None
    ''' How many steps paths are rendered with (power of 2)

    :type: int
    '''

    render_type: typing.Union[str, int] = None
    ''' How particles are rendered

    :type: typing.Union[str, int]
    '''

    rendered_child_count: int = None
    ''' Number of children/parent for rendering

    :type: int
    '''

    rotation_factor_random: float = None
    ''' Randomize particle orientation

    :type: float
    '''

    rotation_mode: typing.Union[str, int] = None
    ''' Particle orientation axis (does not affect Explode modifier's results)

    :type: typing.Union[str, int]
    '''

    roughness_1: float = None
    ''' Amount of location dependent rough

    :type: float
    '''

    roughness_1_size: float = None
    ''' Size of location dependent rough

    :type: float
    '''

    roughness_2: float = None
    ''' Amount of random rough

    :type: float
    '''

    roughness_2_size: float = None
    ''' Size of random rough

    :type: float
    '''

    roughness_2_threshold: float = None
    ''' Amount of particles left untouched by random rough

    :type: float
    '''

    roughness_curve: 'CurveMapping' = None
    ''' Curve defining roughness

    :type: 'CurveMapping'
    '''

    roughness_end_shape: float = None
    ''' Shape of end point rough

    :type: float
    '''

    roughness_endpoint: float = None
    ''' Amount of end point rough

    :type: float
    '''

    show_guide_hairs: bool = None
    ''' Show guide hairs

    :type: bool
    '''

    show_hair_grid: bool = None
    ''' Show hair simulation grid

    :type: bool
    '''

    show_health: bool = None
    ''' Draw boid health

    :type: bool
    '''

    show_number: bool = None
    ''' Show particle number

    :type: bool
    '''

    show_size: bool = None
    ''' Show particle size

    :type: bool
    '''

    show_unborn: bool = None
    ''' Show particles before they are emitted

    :type: bool
    '''

    show_velocity: bool = None
    ''' Show particle velocity

    :type: bool
    '''

    simplify_rate: float = None
    ''' Speed of simplification

    :type: float
    '''

    simplify_refsize: int = None
    ''' Reference size in pixels, after which simplification begins

    :type: int
    '''

    simplify_transition: float = None
    ''' Transition period for fading out strands

    :type: float
    '''

    simplify_viewport: float = None
    ''' Speed of Simplification

    :type: float
    '''

    size_random: float = None
    ''' Give the particle size a random variation

    :type: float
    '''

    subframes: int = None
    ''' Subframes to simulate for improved stability and finer granularity simulations (dt = timestep / (subframes + 1))

    :type: int
    '''

    tangent_factor: float = None
    ''' Let the surface tangent give the particle a starting velocity

    :type: float
    '''

    tangent_phase: float = None
    ''' Rotate the surface tangent

    :type: float
    '''

    texture_slots: 'ParticleSettingsTextureSlots' = None
    ''' Texture slots defining the mapping and influence of textures

    :type: 'ParticleSettingsTextureSlots'
    '''

    time_tweak: float = None
    ''' A multiplier for physics timestep (1.0 means one frame = 1/25 seconds)

    :type: float
    '''

    timestep: float = None
    ''' The simulation timestep per frame (seconds per frame)

    :type: float
    '''

    trail_count: int = None
    ''' Number of trail particles

    :type: int
    '''

    type: typing.Union[str, int] = None
    ''' Particle Type

    :type: typing.Union[str, int]
    '''

    use_absolute_path_time: bool = None
    ''' Path timing is in absolute frames

    :type: bool
    '''

    use_adaptive_subframes: bool = None
    ''' Automatically set the number of subframes

    :type: bool
    '''

    use_advanced_hair: bool = None
    ''' Use full physics calculations for growing hair

    :type: bool
    '''

    use_clump_curve: bool = None
    ''' Use a curve to define clump tapering

    :type: bool
    '''

    use_clump_noise: bool = None
    ''' Create random clumps around the parent

    :type: bool
    '''

    use_dead: bool = None
    ''' Show particles after they have died

    :type: bool
    '''

    use_die_on_collision: bool = None
    ''' Particles die when they collide with a deflector object

    :type: bool
    '''

    use_dynamic_rotation: bool = None
    ''' Particle rotations are affected by collisions and effectors

    :type: bool
    '''

    use_emit_random: bool = None
    ''' Emit in random order of elements

    :type: bool
    '''

    use_even_distribution: bool = None
    ''' Use even distribution from faces based on face areas or edge lengths

    :type: bool
    '''

    use_global_dupli: bool = None
    ''' Use object's global coordinates for duplication

    :type: bool
    '''

    use_group_count: bool = None
    ''' Use object multiple times in the same group

    :type: bool
    '''

    use_group_pick_random: bool = None
    ''' Pick objects from group randomly

    :type: bool
    '''

    use_hair_bspline: bool = None
    ''' Interpolate hair using B-Splines

    :type: bool
    '''

    use_modifier_stack: bool = None
    ''' Emit particles from mesh with modifiers applied (must use same subsurf level for viewport and render for correct results)

    :type: bool
    '''

    use_multiply_size_mass: bool = None
    ''' Multiply mass by particle size

    :type: bool
    '''

    use_parent_particles: bool = None
    ''' Render parent particles

    :type: bool
    '''

    use_react_multiple: bool = None
    ''' React multiple times

    :type: bool
    '''

    use_react_start_end: bool = None
    ''' Give birth to unreacted particles eventually

    :type: bool
    '''

    use_render_adaptive: bool = None
    ''' Draw steps of the particle path

    :type: bool
    '''

    use_render_emitter: bool = None
    ''' Render emitter Object also

    :type: bool
    '''

    use_rotation_dupli: bool = None
    ''' Use object's rotation for duplication (global x-axis is aligned particle rotation axis)

    :type: bool
    '''

    use_rotations: bool = None
    ''' Calculate particle rotations

    :type: bool
    '''

    use_roughness_curve: bool = None
    ''' Use a curve to define roughness

    :type: bool
    '''

    use_scale_dupli: bool = None
    ''' Use object's scale for duplication

    :type: bool
    '''

    use_self_effect: bool = None
    ''' Particle effectors affect themselves

    :type: bool
    '''

    use_simplify: bool = None
    ''' Remove child strands as the object becomes smaller on the screen

    :type: bool
    '''

    use_simplify_viewport: bool = None
    ''' 

    :type: bool
    '''

    use_size_deflect: bool = None
    ''' Use particle's size in deflection

    :type: bool
    '''

    use_strand_primitive: bool = None
    ''' Use the strand primitive for rendering

    :type: bool
    '''

    use_velocity_length: bool = None
    ''' Multiply line length by particle speed

    :type: bool
    '''

    use_whole_group: bool = None
    ''' Use whole group at once

    :type: bool
    '''

    userjit: int = None
    ''' Emission locations / face (0 = automatic)

    :type: int
    '''

    virtual_parents: float = None
    ''' Relative amount of virtual parents

    :type: float
    '''


class Scene(ID, bpy_struct):
    ''' Scene data block, consisting in objects and defining time and render related settings
    '''

    active_clip: 'MovieClip' = None
    ''' Active movie clip used for constraints and viewport drawing

    :type: 'MovieClip'
    '''

    active_layer: int = None
    ''' Active scene layer index

    :type: int
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    audio_distance_model: typing.Union[str, int] = None
    ''' Distance model for distance attenuation calculation * ``NONE`` None, No distance attenuation. * ``INVERSE`` Inverse, Inverse distance model. * ``INVERSE_CLAMPED`` Inverse Clamped, Inverse distance model with clamping. * ``LINEAR`` Linear, Linear distance model. * ``LINEAR_CLAMPED`` Linear Clamped, Linear distance model with clamping. * ``EXPONENT`` Exponent, Exponent distance model. * ``EXPONENT_CLAMPED`` Exponent Clamped, Exponent distance model with clamping.

    :type: typing.Union[str, int]
    '''

    audio_doppler_factor: float = None
    ''' Pitch factor for Doppler effect calculation

    :type: float
    '''

    audio_doppler_speed: float = None
    ''' Speed of sound for Doppler effect calculation

    :type: float
    '''

    audio_volume: float = None
    ''' Audio volume

    :type: float
    '''

    background_set: 'Scene' = None
    ''' Background set scene

    :type: 'Scene'
    '''

    camera: 'Object' = None
    ''' Active camera, used for rendering the scene

    :type: 'Object'
    '''

    cursor_location: bpy_prop_array[float] = None
    ''' 3D cursor location

    :type: bpy_prop_array[float]
    '''

    cycles: 'CyclesRenderSettings' = None
    ''' Cycles render settings

    :type: 'CyclesRenderSettings'
    '''

    cycles_curves: 'CyclesCurveRenderSettings' = None
    ''' Cycles hair rendering settings

    :type: 'CyclesCurveRenderSettings'
    '''

    depsgraph: 'Depsgraph' = None
    ''' Dependencies in the scene data

    :type: 'Depsgraph'
    '''

    display_settings: 'ColorManagedDisplaySettings' = None
    ''' Settings of device saved image would be displayed on

    :type: 'ColorManagedDisplaySettings'
    '''

    frame_current: int = None
    ''' Current Frame, to update animation data from python frame_set() instead

    :type: int
    '''

    frame_current_final: float = None
    ''' Current frame with subframe and time remapping applied

    :type: float
    '''

    frame_end: int = None
    ''' Final frame of the playback/rendering range

    :type: int
    '''

    frame_preview_end: int = None
    ''' Alternative end frame for UI playback

    :type: int
    '''

    frame_preview_start: int = None
    ''' Alternative start frame for UI playback

    :type: int
    '''

    frame_start: int = None
    ''' First frame of the playback/rendering range

    :type: int
    '''

    frame_step: int = None
    ''' Number of frames to skip forward while rendering/playing back each frame

    :type: int
    '''

    frame_subframe: float = None
    ''' 

    :type: float
    '''

    game_settings: 'SceneGameData' = None
    ''' 

    :type: 'SceneGameData'
    '''

    gravity: bpy_prop_array[float] = None
    ''' Constant acceleration in a given direction

    :type: bpy_prop_array[float]
    '''

    grease_pencil: 'GreasePencil' = None
    ''' Grease Pencil data-block

    :type: 'GreasePencil'
    '''

    is_nla_tweakmode: typing.Union[bool, typing.Any] = None
    ''' Whether there is any action referenced by NLA being edited (strictly read-only)

    :type: typing.Union[bool, typing.Any]
    '''

    keying_sets: 'KeyingSets' = None
    ''' Absolute Keying Sets for this Scene

    :type: 'KeyingSets'
    '''

    keying_sets_all: 'KeyingSetsAll' = None
    ''' All Keying Sets available for use (Builtins and Absolute Keying Sets for this Scene)

    :type: 'KeyingSetsAll'
    '''

    layers: typing.List[bool] = None
    ''' Visible layers - Shift-Click/Drag to select multiple layers

    :type: typing.List[bool]
    '''

    lock_frame_selection_to_range: bool = None
    ''' Don't allow frame to be selected with mouse outside of frame range

    :type: bool
    '''

    node_tree: 'NodeTree' = None
    ''' Compositing node tree

    :type: 'NodeTree'
    '''

    object_bases: 'SceneBases' = None
    ''' 

    :type: 'SceneBases'
    '''

    objects: 'SceneObjects' = None
    ''' 

    :type: 'SceneObjects'
    '''

    orientations: bpy_prop_collection['TransformOrientation'] = None
    ''' 

    :type: bpy_prop_collection['TransformOrientation']
    '''

    render: 'RenderSettings' = None
    ''' 

    :type: 'RenderSettings'
    '''

    rigidbody_world: 'RigidBodyWorld' = None
    ''' 

    :type: 'RigidBodyWorld'
    '''

    safe_areas: 'DisplaySafeAreas' = None
    ''' 

    :type: 'DisplaySafeAreas'
    '''

    sequence_editor: 'SequenceEditor' = None
    ''' 

    :type: 'SequenceEditor'
    '''

    sequencer_colorspace_settings: 'ColorManagedSequencerColorspaceSettings' = None
    ''' Settings of color space sequencer is working in

    :type: 'ColorManagedSequencerColorspaceSettings'
    '''

    show_keys_from_selected_only: bool = None
    ''' Consider keyframes for active Object and/or its selected bones only (in timeline and when jumping between keyframes)

    :type: bool
    '''

    sync_mode: typing.Union[str, int] = None
    ''' How to sync playback * ``NONE`` No Sync, Do not sync, play every frame. * ``FRAME_DROP`` Frame Dropping, Drop frames if playback is too slow. * ``AUDIO_SYNC`` AV-sync, Sync to audio playback, dropping frames.

    :type: typing.Union[str, int]
    '''

    timeline_markers: 'TimelineMarkers' = None
    ''' Markers used in all timelines for the current scene

    :type: 'TimelineMarkers'
    '''

    tool_settings: 'ToolSettings' = None
    ''' 

    :type: 'ToolSettings'
    '''

    unit_settings: 'UnitSettings' = None
    ''' Unit editing settings

    :type: 'UnitSettings'
    '''

    use_audio: bool = None
    ''' Play back of audio from Sequence Editor will be muted

    :type: bool
    '''

    use_audio_scrub: bool = None
    ''' Play audio from Sequence Editor while scrubbing

    :type: bool
    '''

    use_audio_sync: bool = None
    ''' Play back and sync with audio clock, dropping frames if frame display is too slow

    :type: bool
    '''

    use_frame_drop: bool = None
    ''' Play back dropping frames if frame display is too slow

    :type: bool
    '''

    use_gravity: bool = None
    ''' Use global gravity for all dynamics

    :type: bool
    '''

    use_nodes: bool = None
    ''' Enable the compositing node tree

    :type: bool
    '''

    use_preview_range: bool = None
    ''' Use an alternative start/end frame range for animation playback and OpenGL renders instead of the Render properties start/end frame range

    :type: bool
    '''

    use_stamp_note: typing.Union[str, typing.Any] = None
    ''' User defined note for the render stamping

    :type: typing.Union[str, typing.Any]
    '''

    view_settings: 'ColorManagedViewSettings' = None
    ''' Color management settings applied on image before saving

    :type: 'ColorManagedViewSettings'
    '''

    world: 'World' = None
    ''' World used for rendering the scene

    :type: 'World'
    '''

    def sequence_editor_create(self) -> 'SequenceEditor':
        ''' Ensure sequence editor is valid in this scene

        :rtype: 'SequenceEditor'
        :return: New sequence editor data or NULL
        '''
        pass

    def sequence_editor_clear(self):
        ''' Clear sequence editor in this scene

        '''
        pass

    def statistics(self) -> typing.Union[str, typing.Any]:
        ''' statistics

        :rtype: typing.Union[str, typing.Any]
        :return: Statistics
        '''
        pass

    def frame_set(self,
                  frame: typing.Optional[int],
                  subframe: typing.Optional[typing.Any] = 0.0):
        ''' Set scene frame updating all objects immediately

        :param frame: Frame number to set
        :type frame: typing.Optional[int]
        :param subframe: Sub-frame time, between 0.0 and 1.0
        :type subframe: typing.Optional[typing.Any]
        '''
        pass

    def update(self):
        ''' Update data tagged to be updated from previous access to data or operators

        '''
        pass

    def uvedit_aspect(self, object: 'Object') -> bpy_prop_array[float]:
        ''' Get uv aspect for current object

        :param object: Object
        :type object: 'Object'
        :rtype: bpy_prop_array[float]
        :return: aspect
        '''
        pass

    def ray_cast(self,
                 origin: typing.Optional[typing.Iterable[float]],
                 direction: typing.Optional[typing.Iterable[float]],
                 distance: typing.Optional[typing.Any] = 1.70141e+38):
        ''' Cast a ray onto in object space

        :param origin: 
        :type origin: typing.Optional[typing.Iterable[float]]
        :param direction: 
        :type direction: typing.Optional[typing.Iterable[float]]
        :param distance: Maximum distance
        :type distance: typing.Optional[typing.Any]
        '''
        pass

    def collada_export(
            self,
            filepath: typing.Union[str, typing.Any],
            apply_modifiers: typing.Optional[typing.Union[bool, typing.
                                                          Any]] = False,
            export_mesh_type: typing.Optional[typing.Any] = 0,
            selected: typing.Optional[typing.Union[bool, typing.Any]] = False,
            include_children: typing.Optional[typing.Union[bool, typing.
                                                           Any]] = False,
            include_armatures: typing.Optional[typing.Union[bool, typing.
                                                            Any]] = False,
            include_shapekeys: typing.Optional[typing.Union[bool, typing.
                                                            Any]] = False,
            deform_bones_only: typing.Optional[typing.Union[bool, typing.
                                                            Any]] = False,
            active_uv_only: typing.Optional[typing.Union[bool, typing.
                                                         Any]] = False,
            include_uv_textures: typing.Optional[typing.Union[bool, typing.
                                                              Any]] = False,
            include_material_textures: typing.Optional[
                typing.Union[bool, typing.Any]] = False,
            use_texture_copies: typing.Optional[typing.Union[bool, typing.
                                                             Any]] = False,
            use_ngons: typing.Optional[typing.Union[bool, typing.Any]] = True,
            use_object_instantiation: typing.Optional[
                typing.Union[bool, typing.Any]] = True,
            use_blender_profile: typing.Optional[typing.Union[bool, typing.
                                                              Any]] = True,
            sort_by_name: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = False,
            open_sim: typing.Optional[typing.Union[bool, typing.Any]] = False,
            export_transformation_type: typing.Optional[typing.Any] = 0):
        ''' Export to collada file

        :param filepath: File Path, File path to write Collada file
        :type filepath: typing.Union[str, typing.Any]
        :param apply_modifiers: Apply Modifiers, Apply modifiers
        :type apply_modifiers: typing.Optional[typing.Union[bool, typing.Any]]
        :param export_mesh_type: Resolution, Modifier resolution for export
        :type export_mesh_type: typing.Optional[typing.Any]
        :param selected: Selection Only, Export only selected elements
        :type selected: typing.Optional[typing.Union[bool, typing.Any]]
        :param include_children: Include Children, Export all children of selected objects (even if not selected)
        :type include_children: typing.Optional[typing.Union[bool, typing.Any]]
        :param include_armatures: Include Armatures, Export related armatures (even if not selected)
        :type include_armatures: typing.Optional[typing.Union[bool, typing.Any]]
        :param include_shapekeys: Include Shape Keys, Export all Shape Keys from Mesh Objects
        :type include_shapekeys: typing.Optional[typing.Union[bool, typing.Any]]
        :param deform_bones_only: Deform Bones only, Only export deforming bones with armatures
        :type deform_bones_only: typing.Optional[typing.Union[bool, typing.Any]]
        :param active_uv_only: Active UV Layer only, Export only the active UV Layer
        :type active_uv_only: typing.Optional[typing.Union[bool, typing.Any]]
        :param include_uv_textures: Include UV Textures, Export textures assigned to the object UV maps
        :type include_uv_textures: typing.Optional[typing.Union[bool, typing.Any]]
        :param include_material_textures: Include Material Textures, Export textures assigned to the object Materials
        :type include_material_textures: typing.Optional[typing.Union[bool, typing.Any]]
        :param use_texture_copies: copy, Copy textures to same folder where the .dae file is exported
        :type use_texture_copies: typing.Optional[typing.Union[bool, typing.Any]]
        :param use_ngons: Use NGons, Keep NGons in Export
        :type use_ngons: typing.Optional[typing.Union[bool, typing.Any]]
        :param use_object_instantiation: Use Object Instances, Instantiate multiple Objects from same Data
        :type use_object_instantiation: typing.Optional[typing.Union[bool, typing.Any]]
        :param use_blender_profile: Use Blender Profile, Export additional Blender specific information (for material, shaders, bones, etc.)
        :type use_blender_profile: typing.Optional[typing.Union[bool, typing.Any]]
        :param sort_by_name: Sort by Object name, Sort exported data by Object name
        :type sort_by_name: typing.Optional[typing.Union[bool, typing.Any]]
        :param open_sim: Export for SL/OpenSim, Compatibility mode for SL, OpenSim and similar online worlds
        :type open_sim: typing.Optional[typing.Union[bool, typing.Any]]
        :param export_transformation_type: Transformation, Transformation type for translation, scale and rotation
        :type export_transformation_type: typing.Optional[typing.Any]
        '''
        pass

    def alembic_export(
            self,
            filepath: typing.Union[str, typing.Any],
            frame_start: typing.Optional[typing.Any] = 1,
            frame_end: typing.Optional[typing.Any] = 1,
            xform_samples: typing.Optional[typing.Any] = 1,
            geom_samples: typing.Optional[typing.Any] = 1,
            shutter_open: typing.Optional[typing.Any] = 0.0,
            shutter_close: typing.Optional[typing.Any] = 1.0,
            selected_only: typing.Optional[typing.Union[bool, typing.
                                                        Any]] = False,
            uvs: typing.Optional[typing.Union[bool, typing.Any]] = True,
            normals: typing.Optional[typing.Union[bool, typing.Any]] = True,
            vcolors: typing.Optional[typing.Union[bool, typing.Any]] = False,
            apply_subdiv: typing.Optional[typing.Union[bool, typing.
                                                       Any]] = True,
            flatten: typing.Optional[typing.Union[bool, typing.Any]] = False,
            visible_layers_only: typing.Optional[typing.Union[bool, typing.
                                                              Any]] = False,
            renderable_only: typing.Optional[typing.Union[bool, typing.
                                                          Any]] = False,
            face_sets: typing.Optional[typing.Union[bool, typing.Any]] = False,
            subdiv_schema: typing.Optional[typing.Union[bool, typing.
                                                        Any]] = False,
            compression_type: typing.Optional[typing.Any] = 'OGAWA',
            packuv: typing.Optional[typing.Union[bool, typing.Any]] = False,
            scale: typing.Optional[typing.Any] = 1.0):
        ''' Export to Alembic file

        :param filepath: File Path, File path to write Alembic file
        :type filepath: typing.Union[str, typing.Any]
        :param frame_start: Start, Start Frame
        :type frame_start: typing.Optional[typing.Any]
        :param frame_end: End, End Frame
        :type frame_end: typing.Optional[typing.Any]
        :param xform_samples: Xform samples, Transform samples per frame
        :type xform_samples: typing.Optional[typing.Any]
        :param geom_samples: Geom samples, Geometry samples per frame
        :type geom_samples: typing.Optional[typing.Any]
        :param shutter_open: Shutter open
        :type shutter_open: typing.Optional[typing.Any]
        :param shutter_close: Shutter close
        :type shutter_close: typing.Optional[typing.Any]
        :param selected_only: Selected only, Export only selected objects
        :type selected_only: typing.Optional[typing.Union[bool, typing.Any]]
        :param uvs: UVs, Export UVs
        :type uvs: typing.Optional[typing.Union[bool, typing.Any]]
        :param normals: Normals, Export cormals
        :type normals: typing.Optional[typing.Union[bool, typing.Any]]
        :param vcolors: Vertex colors, Export vertex colors
        :type vcolors: typing.Optional[typing.Union[bool, typing.Any]]
        :param apply_subdiv: Subsurfs as meshes, Export subdivision surfaces as meshes
        :type apply_subdiv: typing.Optional[typing.Union[bool, typing.Any]]
        :param flatten: Flatten hierarchy, Flatten hierarchy
        :type flatten: typing.Optional[typing.Union[bool, typing.Any]]
        :param visible_layers_only: Visible layers only, Export only objects in visible layers
        :type visible_layers_only: typing.Optional[typing.Union[bool, typing.Any]]
        :param renderable_only: Renderable objects only, Export only objects marked renderable in the outliner
        :type renderable_only: typing.Optional[typing.Union[bool, typing.Any]]
        :param face_sets: Facesets, Export face sets
        :type face_sets: typing.Optional[typing.Union[bool, typing.Any]]
        :param subdiv_schema: Use Alembic subdivision Schema, Use Alembic subdivision Schema
        :type subdiv_schema: typing.Optional[typing.Union[bool, typing.Any]]
        :param compression_type: Compression
        :type compression_type: typing.Optional[typing.Any]
        :param packuv: Export with packed UV islands, Export with packed UV islands
        :type packuv: typing.Optional[typing.Union[bool, typing.Any]]
        :param scale: Scale, Value by which to enlarge or shrink the objects with respect to the world's origin
        :type scale: typing.Optional[typing.Any]
        '''
        pass


class Screen(ID, bpy_struct):
    ''' Screen data-block, defining the layout of areas in a window
    '''

    areas: bpy_prop_collection['Area'] = None
    ''' Areas the screen is subdivided into

    :type: bpy_prop_collection['Area']
    '''

    is_animation_playing: typing.Union[bool, typing.Any] = None
    ''' Animation playback is active

    :type: typing.Union[bool, typing.Any]
    '''

    scene: 'Scene' = None
    ''' Active scene to be edited in the screen

    :type: 'Scene'
    '''

    show_fullscreen: typing.Union[bool, typing.Any] = None
    ''' An area is maximized, filling this screen

    :type: typing.Union[bool, typing.Any]
    '''

    use_follow: bool = None
    ''' Follow current frame in editors

    :type: bool
    '''

    use_play_3d_editors: bool = None
    ''' 

    :type: bool
    '''

    use_play_animation_editors: bool = None
    ''' 

    :type: bool
    '''

    use_play_clip_editors: bool = None
    ''' 

    :type: bool
    '''

    use_play_image_editors: bool = None
    ''' 

    :type: bool
    '''

    use_play_node_editors: bool = None
    ''' 

    :type: bool
    '''

    use_play_properties_editors: bool = None
    ''' 

    :type: bool
    '''

    use_play_sequence_editors: bool = None
    ''' 

    :type: bool
    '''

    use_play_top_left_3d_editor: bool = None
    ''' 

    :type: bool
    '''


class Sound(ID, bpy_struct):
    ''' Sound data-block referencing an external or packed sound file
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Sound sample file used by this Sound data-block

    :type: typing.Union[str, typing.Any]
    '''

    packed_file: 'PackedFile' = None
    ''' 

    :type: 'PackedFile'
    '''

    use_memory_cache: bool = None
    ''' The sound file is decoded and loaded into RAM

    :type: bool
    '''

    use_mono: bool = None
    ''' If the file contains multiple audio channels they are rendered to a single one

    :type: bool
    '''

    factory = None
    ''' The aud.Factory object of the sound. (readonly)'''

    def pack(self):
        ''' Pack the sound into the current blend file

        '''
        pass

    def unpack(self, method: typing.Optional[typing.Any] = 'USE_LOCAL'):
        ''' Unpack the sound to the samples filename

        :param method: method, How to unpack
        :type method: typing.Optional[typing.Any]
        '''
        pass


class Speaker(ID, bpy_struct):
    ''' Speaker data-block for 3D audio speaker objects
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    attenuation: float = None
    ''' How strong the distance affects volume, depending on distance model

    :type: float
    '''

    cone_angle_inner: float = None
    ''' Angle of the inner cone, in degrees, inside the cone the volume is 100 %

    :type: float
    '''

    cone_angle_outer: float = None
    ''' Angle of the outer cone, in degrees, outside this cone the volume is the outer cone volume, between inner and outer cone the volume is interpolated

    :type: float
    '''

    cone_volume_outer: float = None
    ''' Volume outside the outer cone

    :type: float
    '''

    distance_max: float = None
    ''' Maximum distance for volume calculation, no matter how far away the object is

    :type: float
    '''

    distance_reference: float = None
    ''' Reference distance at which volume is 100 %

    :type: float
    '''

    muted: bool = None
    ''' Mute the speaker

    :type: bool
    '''

    pitch: float = None
    ''' Playback pitch of the sound

    :type: float
    '''

    relative: typing.Union[bool, typing.Any] = None
    ''' Whether the source is relative to the camera or not

    :type: typing.Union[bool, typing.Any]
    '''

    sound: 'Sound' = None
    ''' Sound data-block used by this speaker

    :type: 'Sound'
    '''

    volume: float = None
    ''' How loud the sound is

    :type: float
    '''

    volume_max: float = None
    ''' Maximum volume, no matter how near the object is

    :type: float
    '''

    volume_min: float = None
    ''' Minimum volume, no matter how far away the object is

    :type: float
    '''


class Text(ID, bpy_struct):
    ''' Text data-block referencing an external or packed text file
    '''

    current_character: int = None
    ''' Index of current character in current line, and also start index of character in selection if one exists

    :type: int
    '''

    current_line: 'TextLine' = None
    ''' Current line, and start line of selection if one exists

    :type: 'TextLine'
    '''

    current_line_index: int = None
    ''' Index of current TextLine in TextLine collection

    :type: int
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' Filename of the text file

    :type: typing.Union[str, typing.Any]
    '''

    is_dirty: typing.Union[bool, typing.Any] = None
    ''' Text file has been edited since last save

    :type: typing.Union[bool, typing.Any]
    '''

    is_in_memory: typing.Union[bool, typing.Any] = None
    ''' Text file is in memory, without a corresponding file on disk

    :type: typing.Union[bool, typing.Any]
    '''

    is_modified: typing.Union[bool, typing.Any] = None
    ''' Text file on disk is different than the one in memory

    :type: typing.Union[bool, typing.Any]
    '''

    lines: bpy_prop_collection['TextLine'] = None
    ''' Lines of text

    :type: bpy_prop_collection['TextLine']
    '''

    select_end_character: int = None
    ''' Index of character after end of selection in the selection end line

    :type: int
    '''

    select_end_line: 'TextLine' = None
    ''' End line of selection

    :type: 'TextLine'
    '''

    use_module: bool = None
    ''' Register this text as a module on loading, Text name must end with ".py"

    :type: bool
    '''

    use_tabs_as_spaces: bool = None
    ''' Automatically converts all new tabs into spaces

    :type: bool
    '''

    users_logic = None
    ''' Logic bricks that use this text (readonly)'''

    def clear(self):
        ''' clear the text block

        '''
        pass

    def write(self, text: typing.Union[str, typing.Any]):
        ''' write text at the cursor location and advance to the end of the text block

        :param text: New text for this data-block
        :type text: typing.Union[str, typing.Any]
        '''
        pass

    def as_string(self):
        ''' Return the text as a string.

        '''
        pass

    def from_string(self, string):
        ''' Replace text with this string.

        '''
        pass


class Texture(ID, bpy_struct):
    ''' Texture data-block used by materials, lamps, worlds and brushes
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    color_ramp: 'ColorRamp' = None
    ''' 

    :type: 'ColorRamp'
    '''

    contrast: float = None
    ''' Adjust the contrast of the texture

    :type: float
    '''

    factor_blue: float = None
    ''' 

    :type: float
    '''

    factor_green: float = None
    ''' 

    :type: float
    '''

    factor_red: float = None
    ''' 

    :type: float
    '''

    intensity: float = None
    ''' Adjust the brightness of the texture

    :type: float
    '''

    node_tree: 'NodeTree' = None
    ''' Node tree for node-based textures

    :type: 'NodeTree'
    '''

    saturation: float = None
    ''' Adjust the saturation of colors in the texture

    :type: float
    '''

    type: typing.Union[str, int] = None
    ''' * ``NONE`` None. * ``BLEND`` Blend, Procedural - create a ramp texture. * ``CLOUDS`` Clouds, Procedural - create a cloud-like fractal noise texture. * ``DISTORTED_NOISE`` Distorted Noise, Procedural - noise texture distorted by two noise algorithms. * ``ENVIRONMENT_MAP`` Environment Map, Create a render of the environment mapped to a texture. * ``IMAGE`` Image or Movie, Allow for images or movies to be used as textures. * ``MAGIC`` Magic, Procedural - color texture based on trigonometric functions. * ``MARBLE`` Marble, Procedural - marble-like noise texture with wave generated bands. * ``MUSGRAVE`` Musgrave, Procedural - highly flexible fractal noise texture. * ``NOISE`` Noise, Procedural - random noise, gives a different result every time, for every frame, for every pixel. * ``OCEAN`` Ocean, Use a texture generated by an Ocean modifier. * ``POINT_DENSITY`` Point Density. * ``STUCCI`` Stucci, Procedural - create a fractal noise texture. * ``VORONOI`` Voronoi, Procedural - create cell-like patterns based on Worley noise. * ``VOXEL_DATA`` Voxel Data, Create a 3D texture based on volumetric data. * ``WOOD`` Wood, Procedural - wave generated bands or rings, with optional noise.

    :type: typing.Union[str, int]
    '''

    use_clamp: bool = None
    ''' Set negative texture RGB and intensity values to zero, for some uses like displacement this option can be disabled to get the full range

    :type: bool
    '''

    use_color_ramp: bool = None
    ''' Toggle color ramp operations

    :type: bool
    '''

    use_nodes: bool = None
    ''' Make this a node-based texture

    :type: bool
    '''

    use_preview_alpha: bool = None
    ''' Show Alpha in Preview Render

    :type: bool
    '''

    users_material = None
    ''' Materials that use this texture (readonly)'''

    users_object_modifier = None
    ''' Object modifiers that use this texture (readonly)'''

    def evaluate(self, value: typing.Optional[typing.Iterable[float]]
                 ) -> bpy_prop_array[float]:
        ''' Evaluate the texture at the coordinates given

        :param value: 
        :type value: typing.Optional[typing.Iterable[float]]
        :rtype: bpy_prop_array[float]
        :return: Result
        '''
        pass


class VectorFont(ID, bpy_struct):
    ''' Vector font for Text objects
    '''

    filepath: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    packed_file: 'PackedFile' = None
    ''' 

    :type: 'PackedFile'
    '''

    def pack(self):
        ''' Pack the font into the current blend file

        '''
        pass

    def unpack(self, method: typing.Optional[typing.Any] = 'USE_LOCAL'):
        ''' Unpack the font to the samples filename

        :param method: method, How to unpack
        :type method: typing.Optional[typing.Any]
        '''
        pass


class WindowManager(ID, bpy_struct):
    ''' Window manager data-block defining open windows and other user interface data
    '''

    addon_filter: typing.Union[str, int] = None
    ''' Filter add-ons by category

    :type: typing.Union[str, int]
    '''

    addon_search: typing.Union[str, typing.Any] = None
    ''' Search within the selected filter

    :type: typing.Union[str, typing.Any]
    '''

    addon_support: typing.Union[typing.Set[str], typing.Set[int]] = None
    ''' Display support level * ``OFFICIAL`` Official, Officially supported. * ``COMMUNITY`` Community, Maintained by community developers. * ``TESTING`` Testing, Newly contributed scripts (excluded from release builds).

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    clipboard: typing.Union[str, typing.Any] = None
    ''' 

    :type: typing.Union[str, typing.Any]
    '''

    keyconfigs: 'KeyConfigurations' = None
    ''' Registered key configurations

    :type: 'KeyConfigurations'
    '''

    operators: bpy_prop_collection['Operator'] = None
    ''' Operator registry

    :type: bpy_prop_collection['Operator']
    '''

    windows: bpy_prop_collection['Window'] = None
    ''' Open windows

    :type: bpy_prop_collection['Window']
    '''

    @classmethod
    def fileselect_add(cls, operator: typing.Optional['Operator']):
        ''' Opens a file selector with an operator. The string properties 'filepath', 'filename', 'directory' and a 'files' collection are assigned when present in the operator

        :param operator: Operator to call
        :type operator: typing.Optional['Operator']
        '''
        pass

    @classmethod
    def modal_handler_add(cls, operator: typing.Optional['Operator']) -> bool:
        ''' Add a modal handler to the window manager, for the given modal operator (called by invoke() with self, just before returning {'RUNNING_MODAL'})

        :param operator: Operator to call
        :type operator: typing.Optional['Operator']
        :rtype: bool
        :return: Whether adding the handler was successful
        '''
        pass

    def event_timer_add(self,
                        time_step: typing.Optional[float],
                        window: typing.Optional['Window'] = None) -> 'Timer':
        ''' Add a timer to the given window, to generate periodic 'TIMER' events

        :param time_step: Time Step, Interval in seconds between timer events
        :type time_step: typing.Optional[float]
        :param window: Window to attach the timer to, or None
        :type window: typing.Optional['Window']
        :rtype: 'Timer'
        '''
        pass

    def event_timer_remove(self, timer: 'Timer'):
        ''' event_timer_remove

        :param timer: 
        :type timer: 'Timer'
        '''
        pass

    def progress_begin(self, min: typing.Optional[float],
                       max: typing.Optional[float]):
        ''' Start progress report

        :param min: min, any value in range [0,9999]
        :type min: typing.Optional[float]
        :param max: max, any value in range [min+1,9998]
        :type max: typing.Optional[float]
        '''
        pass

    def progress_update(self, value: typing.Optional[float]):
        ''' Update the progress feedback

        :param value: value, Any value between min and max as set in progress_begin()
        :type value: typing.Optional[float]
        '''
        pass

    def progress_end(self):
        ''' Terminate progress report

        '''
        pass

    @classmethod
    def invoke_props_popup(cls, operator: typing.Optional['Operator'],
                           event: typing.Optional['Event']
                           ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Operator popup invoke (show operator properties and execute it automatically on changes)

        :param operator: Operator to call
        :type operator: typing.Optional['Operator']
        :param event: Event
        :type event: typing.Optional['Event']
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * ``RUNNING_MODAL`` Running Modal, Keep the operator running with blender. * ``CANCELLED`` Cancelled, When no action has been taken, operator exits. * ``FINISHED`` Finished, When the operator is complete, operator exits. * ``PASS_THROUGH`` Pass Through, Do nothing and pass the event on. * ``INTERFACE`` Interface, Handled but not executed (popup menus).
        '''
        pass

    @classmethod
    def invoke_props_dialog(
            cls,
            operator: typing.Optional['Operator'],
            width: typing.Optional[typing.Any] = 300,
            height: typing.Optional[typing.Any] = 20
    ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Operator dialog (non-autoexec popup) invoke (show operator properties and only execute it on click on OK button)

        :param operator: Operator to call
        :type operator: typing.Optional['Operator']
        :param width: Width of the popup
        :type width: typing.Optional[typing.Any]
        :param height: Height of the popup
        :type height: typing.Optional[typing.Any]
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * ``RUNNING_MODAL`` Running Modal, Keep the operator running with blender. * ``CANCELLED`` Cancelled, When no action has been taken, operator exits. * ``FINISHED`` Finished, When the operator is complete, operator exits. * ``PASS_THROUGH`` Pass Through, Do nothing and pass the event on. * ``INTERFACE`` Interface, Handled but not executed (popup menus).
        '''
        pass

    @classmethod
    def invoke_search_popup(cls, operator: typing.Optional['Operator']):
        ''' Operator search popup invoke (search in values of operator's type 'prop' EnumProperty, and execute it on confirmation)

        :param operator: Operator to call
        :type operator: typing.Optional['Operator']
        '''
        pass

    @classmethod
    def invoke_popup(cls,
                     operator: typing.Optional['Operator'],
                     width: typing.Optional[typing.Any] = 300,
                     height: typing.Optional[typing.Any] = 20
                     ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Operator popup invoke (only shows operator's properties, without executing it)

        :param operator: Operator to call
        :type operator: typing.Optional['Operator']
        :param width: Width of the popup
        :type width: typing.Optional[typing.Any]
        :param height: Height of the popup
        :type height: typing.Optional[typing.Any]
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * ``RUNNING_MODAL`` Running Modal, Keep the operator running with blender. * ``CANCELLED`` Cancelled, When no action has been taken, operator exits. * ``FINISHED`` Finished, When the operator is complete, operator exits. * ``PASS_THROUGH`` Pass Through, Do nothing and pass the event on. * ``INTERFACE`` Interface, Handled but not executed (popup menus).
        '''
        pass

    @classmethod
    def invoke_confirm(cls, operator: typing.Optional['Operator'],
                       event: typing.Optional['Event']
                       ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        ''' Operator confirmation popup (only to let user confirm the execution, no operator properties shown)

        :param operator: Operator to call
        :type operator: typing.Optional['Operator']
        :param event: Event
        :type event: typing.Optional['Event']
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return: result * ``RUNNING_MODAL`` Running Modal, Keep the operator running with blender. * ``CANCELLED`` Cancelled, When no action has been taken, operator exits. * ``FINISHED`` Finished, When the operator is complete, operator exits. * ``PASS_THROUGH`` Pass Through, Do nothing and pass the event on. * ``INTERFACE`` Interface, Handled but not executed (popup menus).
        '''
        pass

    @classmethod
    def pupmenu_begin__internal(
            cls,
            title: typing.Union[str, typing.Any],
            icon: typing.Optional[typing.Any] = 'NONE') -> 'UIPopupMenu':
        ''' pupmenu_begin__internal

        :param title: 
        :type title: typing.Union[str, typing.Any]
        :param icon: icon
        :type icon: typing.Optional[typing.Any]
        :rtype: 'UIPopupMenu'
        '''
        pass

    @classmethod
    def pupmenu_end__internal(cls, menu: 'UIPopupMenu' = None):
        ''' pupmenu_end__internal

        :param menu: 
        :type menu: 'UIPopupMenu'
        '''
        pass

    @classmethod
    def piemenu_begin__internal(cls,
                                title: typing.Union[str, typing.Any],
                                icon: typing.Optional[typing.Any] = 'NONE',
                                event: 'Event' = None) -> 'UIPieMenu':
        ''' piemenu_begin__internal

        :param title: 
        :type title: typing.Union[str, typing.Any]
        :param icon: icon
        :type icon: typing.Optional[typing.Any]
        :param event: 
        :type event: 'Event'
        :rtype: 'UIPieMenu'
        '''
        pass

    @classmethod
    def piemenu_end__internal(cls, menu: 'UIPieMenu' = None):
        ''' piemenu_end__internal

        :param menu: 
        :type menu: 'UIPieMenu'
        '''
        pass

    def popup_menu(self, draw_func, title='', icon='NONE'):
        ''' Popup menus can be useful for creating menus without having to register menu classes. Note that they will not block the scripts execution, so the caller can't wait for user input.

        '''
        pass

    def popup_menu_pie(self, event, draw_func, title='', icon='NONE'):
        ''' 

        '''
        pass


class World(ID, bpy_struct):
    ''' World data-block describing the environment and ambient lighting of a scene
    '''

    active_texture: 'Texture' = None
    ''' Active texture slot being displayed

    :type: 'Texture'
    '''

    active_texture_index: int = None
    ''' Index of active texture slot

    :type: int
    '''

    ambient_color: bpy_prop_array[float] = None
    ''' Ambient color of the world

    :type: bpy_prop_array[float]
    '''

    animation_data: 'AnimData' = None
    ''' Animation data for this data-block

    :type: 'AnimData'
    '''

    color_range: float = None
    ''' The color range that will be mapped to 0-1

    :type: float
    '''

    cycles: 'CyclesWorldSettings' = None
    ''' Cycles world settings

    :type: 'CyclesWorldSettings'
    '''

    cycles_visibility: 'CyclesVisibilitySettings' = None
    ''' Cycles visibility settings

    :type: 'CyclesVisibilitySettings'
    '''

    exposure: float = None
    ''' Amount of exponential color correction for light

    :type: float
    '''

    horizon_color: bpy_prop_array[float] = None
    ''' Color at the horizon

    :type: bpy_prop_array[float]
    '''

    light_settings: 'WorldLighting' = None
    ''' World lighting settings

    :type: 'WorldLighting'
    '''

    mist_settings: 'WorldMistSettings' = None
    ''' World mist settings

    :type: 'WorldMistSettings'
    '''

    node_tree: 'NodeTree' = None
    ''' Node tree for node based worlds

    :type: 'NodeTree'
    '''

    texture_slots: 'WorldTextureSlots' = None
    ''' Texture slots defining the mapping and influence of textures

    :type: 'WorldTextureSlots'
    '''

    use_nodes: bool = None
    ''' Use shader nodes to render the world

    :type: bool
    '''

    use_sky_blend: bool = None
    ''' Render background with natural progression from horizon to zenith

    :type: bool
    '''

    use_sky_paper: bool = None
    ''' Flatten blend or texture coordinates

    :type: bool
    '''

    use_sky_real: bool = None
    ''' Render background with a real horizon, relative to the camera angle

    :type: bool
    '''

    zenith_color: bpy_prop_array[float] = None
    ''' Color at the zenith

    :type: bpy_prop_array[float]
    '''


class Itasc(IKParam, bpy_struct):
    ''' Parameters for the iTaSC IK solver
    '''

    damping_epsilon: float = None
    ''' Singular value under which damping is progressively applied (higher values=more stability, less reactivity - default=0.1)

    :type: float
    '''

    damping_max: float = None
    ''' Maximum damping coefficient when singular value is nearly 0 (higher values=more stability, less reactivity - default=0.5)

    :type: float
    '''

    feedback: float = None
    ''' Feedback coefficient for error correction, average response time is 1/feedback (default=20)

    :type: float
    '''

    iterations: int = None
    ''' Maximum number of iterations for convergence in case of reiteration

    :type: int
    '''

    mode: typing.Union[str, int] = None
    ''' * ``ANIMATION`` Animation, Stateless solver computing pose starting from current action and non-IK constraints. * ``SIMULATION`` Simulation, State-full solver running in real-time context and ignoring actions and non-IK constraints.

    :type: typing.Union[str, int]
    '''

    precision: float = None
    ''' Precision of convergence in case of reiteration

    :type: float
    '''

    reiteration_method: typing.Union[str, int] = None
    ''' Defines if the solver is allowed to reiterate (converge until precision is met) on none, first or all frames * ``NEVER`` Never, The solver does not reiterate, not even on first frame (starts from rest pose). * ``INITIAL`` Initial, The solver reiterates (converges) on the first frame but not on subsequent frame. * ``ALWAYS`` Always, The solver reiterates (converges) on all frames.

    :type: typing.Union[str, int]
    '''

    solver: typing.Union[str, int] = None
    ''' Solving method selection: automatic damping or manual damping * ``SDLS`` SDLS, Selective Damped Least Square. * ``DLS`` DLS, Damped Least Square with Numerical Filtering.

    :type: typing.Union[str, int]
    '''

    step_count: int = None
    ''' Divide the frame interval into this many steps

    :type: int
    '''

    step_max: float = None
    ''' Higher bound for timestep in second in case of automatic substeps

    :type: float
    '''

    step_min: float = None
    ''' Lower bound for timestep in second in case of automatic substeps

    :type: float
    '''

    use_auto_step: bool = None
    ''' Automatically determine the optimal number of steps for best performance/accuracy trade off

    :type: bool
    '''

    velocity_max: float = None
    ''' Maximum joint velocity in rad/s (default=50)

    :type: float
    '''


class KeyConfigurations(bpy_prop_collection[KeyConfig], bpy_struct):
    ''' Collection of KeyConfigs
    '''

    active: 'KeyConfig' = None
    ''' Active key configuration (preset)

    :type: 'KeyConfig'
    '''

    addon: 'KeyConfig' = None
    ''' Key configuration that can be extended by add-ons, and is added to the active configuration when handling events

    :type: 'KeyConfig'
    '''

    default: 'KeyConfig' = None
    ''' Default builtin key configuration

    :type: 'KeyConfig'
    '''

    user: 'KeyConfig' = None
    ''' Final key configuration that combines keymaps from the active and add-on configurations, and can be edited by the user

    :type: 'KeyConfig'
    '''

    def new(self, name: typing.Union[str, typing.Any]) -> 'KeyConfig':
        ''' new

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'KeyConfig'
        :return: Key Configuration, Added key configuration
        '''
        pass

    def remove(self, keyconfig: 'KeyConfig'):
        ''' remove

        :param keyconfig: Key Configuration, Removed key configuration
        :type keyconfig: 'KeyConfig'
        '''
        pass


class KeyMaps(bpy_prop_collection[KeyMap], bpy_struct):
    ''' Collection of keymaps
    '''

    def new(self,
            name: typing.Union[str, typing.Any],
            space_type: typing.Optional[typing.Any] = 'EMPTY',
            region_type: typing.Optional[typing.Any] = 'WINDOW',
            modal: typing.Optional[typing.Union[bool, typing.Any]] = False
            ) -> 'KeyMap':
        ''' new

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param space_type: Space Type * ``EMPTY`` Empty. * ``VIEW_3D`` 3D View, 3D viewport. * ``TIMELINE`` Timeline, Timeline and playback controls. * ``GRAPH_EDITOR`` Graph Editor, Edit drivers and keyframe interpolation. * ``DOPESHEET_EDITOR`` Dope Sheet, Adjust timing of keyframes. * ``NLA_EDITOR`` NLA Editor, Combine and layer Actions. * ``IMAGE_EDITOR`` UV/Image Editor, View and edit images and UV Maps. * ``SEQUENCE_EDITOR`` Video Sequence Editor, Video editing tools. * ``CLIP_EDITOR`` Movie Clip Editor, Motion tracking tools. * ``TEXT_EDITOR`` Text Editor, Edit scripts and in-file documentation. * ``NODE_EDITOR`` Node Editor, Editor for node-based shading and compositing tools. * ``LOGIC_EDITOR`` Logic Editor, Game logic editing. * ``PROPERTIES`` Properties, Edit properties of active object and related data-blocks. * ``OUTLINER`` Outliner, Overview of scene graph and all available data-blocks. * ``USER_PREFERENCES`` User Preferences, Edit persistent configuration settings. * ``INFO`` Info, Main menu bar and list of error messages (drag down to expand and display). * ``FILE_BROWSER`` File Browser, Browse for files and assets. * ``CONSOLE`` Python Console, Interactive programmatic console for advanced editing and script development.
        :type space_type: typing.Optional[typing.Any]
        :param region_type: Region Type
        :type region_type: typing.Optional[typing.Any]
        :param modal: Modal
        :type modal: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'KeyMap'
        :return: Key Map, Added key map
        '''
        pass

    def remove(self, keymap: 'KeyMap'):
        ''' remove

        :param keymap: Key Map, Removed key map
        :type keymap: 'KeyMap'
        '''
        pass

    def find(self,
             name: typing.Union[str, typing.Any],
             space_type: typing.Optional[typing.Any] = 'EMPTY',
             region_type: typing.Optional[typing.Any] = 'WINDOW') -> 'KeyMap':
        ''' find

        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param space_type: Space Type * ``EMPTY`` Empty. * ``VIEW_3D`` 3D View, 3D viewport. * ``TIMELINE`` Timeline, Timeline and playback controls. * ``GRAPH_EDITOR`` Graph Editor, Edit drivers and keyframe interpolation. * ``DOPESHEET_EDITOR`` Dope Sheet, Adjust timing of keyframes. * ``NLA_EDITOR`` NLA Editor, Combine and layer Actions. * ``IMAGE_EDITOR`` UV/Image Editor, View and edit images and UV Maps. * ``SEQUENCE_EDITOR`` Video Sequence Editor, Video editing tools. * ``CLIP_EDITOR`` Movie Clip Editor, Motion tracking tools. * ``TEXT_EDITOR`` Text Editor, Edit scripts and in-file documentation. * ``NODE_EDITOR`` Node Editor, Editor for node-based shading and compositing tools. * ``LOGIC_EDITOR`` Logic Editor, Game logic editing. * ``PROPERTIES`` Properties, Edit properties of active object and related data-blocks. * ``OUTLINER`` Outliner, Overview of scene graph and all available data-blocks. * ``USER_PREFERENCES`` User Preferences, Edit persistent configuration settings. * ``INFO`` Info, Main menu bar and list of error messages (drag down to expand and display). * ``FILE_BROWSER`` File Browser, Browse for files and assets. * ``CONSOLE`` Python Console, Interactive programmatic console for advanced editing and script development.
        :type space_type: typing.Optional[typing.Any]
        :param region_type: Region Type
        :type region_type: typing.Optional[typing.Any]
        :rtype: 'KeyMap'
        :return: Key Map, Corresponding key map
        '''
        pass

    def find_modal(self, name: typing.Union[str, typing.Any]) -> 'KeyMap':
        ''' find_modal

        :param name: Operator Name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'KeyMap'
        :return: Key Map, Corresponding key map
        '''
        pass


class KeyMapItems(bpy_prop_collection[KeyMapItem], bpy_struct):
    ''' Collection of keymap items
    '''

    def new(self,
            idname: typing.Union[str, typing.Any],
            type: typing.Optional[typing.Union[str, int]],
            value: typing.Optional[typing.Union[str, int]],
            any: typing.Optional[typing.Union[bool, typing.Any]] = False,
            shift: typing.Optional[typing.Union[bool, typing.Any]] = False,
            ctrl: typing.Optional[typing.Union[bool, typing.Any]] = False,
            alt: typing.Optional[typing.Union[bool, typing.Any]] = False,
            oskey: typing.Optional[typing.Union[bool, typing.Any]] = False,
            key_modifier: typing.Optional[typing.Any] = 'NONE',
            head: typing.Optional[typing.Union[bool, typing.Any]] = False
            ) -> 'KeyMapItem':
        ''' new

        :param idname: Operator Identifier
        :type idname: typing.Union[str, typing.Any]
        :param type: Type * ``NONE`` . * ``LEFTMOUSE`` Left Mouse, LMB. * ``MIDDLEMOUSE`` Middle Mouse, MMB. * ``RIGHTMOUSE`` Right Mouse, RMB. * ``BUTTON4MOUSE`` Button4 Mouse, MB4. * ``BUTTON5MOUSE`` Button5 Mouse, MB5. * ``BUTTON6MOUSE`` Button6 Mouse, MB6. * ``BUTTON7MOUSE`` Button7 Mouse, MB7. * ``ACTIONMOUSE`` Action Mouse, MBA. * ``SELECTMOUSE`` Select Mouse, MBS. * ``PEN`` Pen. * ``ERASER`` Eraser. * ``MOUSEMOVE`` Mouse Move, MsMov. * ``INBETWEEN_MOUSEMOVE`` In-between Move, MsSubMov. * ``TRACKPADPAN`` Mouse/Trackpad Pan, MsPan. * ``TRACKPADZOOM`` Mouse/Trackpad Zoom, MsZoom. * ``MOUSEROTATE`` Mouse/Trackpad Rotate, MsRot. * ``WHEELUPMOUSE`` Wheel Up, WhUp. * ``WHEELDOWNMOUSE`` Wheel Down, WhDown. * ``WHEELINMOUSE`` Wheel In, WhIn. * ``WHEELOUTMOUSE`` Wheel Out, WhOut. * ``EVT_TWEAK_L`` Tweak Left, TwkL. * ``EVT_TWEAK_M`` Tweak Middle, TwkM. * ``EVT_TWEAK_R`` Tweak Right, TwkR. * ``EVT_TWEAK_A`` Tweak Action, TwkA. * ``EVT_TWEAK_S`` Tweak Select, TwkS. * ``A`` A. * ``B`` B. * ``C`` C. * ``D`` D. * ``E`` E. * ``F`` F. * ``G`` G. * ``H`` H. * ``I`` I. * ``J`` J. * ``K`` K. * ``L`` L. * ``M`` M. * ``N`` N. * ``O`` O. * ``P`` P. * ``Q`` Q. * ``R`` R. * ``S`` S. * ``T`` T. * ``U`` U. * ``V`` V. * ``W`` W. * ``X`` X. * ``Y`` Y. * ``Z`` Z. * ``ZERO`` 0. * ``ONE`` 1. * ``TWO`` 2. * ``THREE`` 3. * ``FOUR`` 4. * ``FIVE`` 5. * ``SIX`` 6. * ``SEVEN`` 7. * ``EIGHT`` 8. * ``NINE`` 9. * ``LEFT_CTRL`` Left Ctrl, CtrlL. * ``LEFT_ALT`` Left Alt, AltL. * ``LEFT_SHIFT`` Left Shift, ShiftL. * ``RIGHT_ALT`` Right Alt, AltR. * ``RIGHT_CTRL`` Right Ctrl, CtrlR. * ``RIGHT_SHIFT`` Right Shift, ShiftR. * ``OSKEY`` OS Key, Cmd. * ``GRLESS`` Grless. * ``ESC`` Esc. * ``TAB`` Tab. * ``RET`` Return, Enter. * ``SPACE`` Spacebar, Space. * ``LINE_FEED`` Line Feed. * ``BACK_SPACE`` Back Space, BkSpace. * ``DEL`` Delete, Del. * ``SEMI_COLON`` ;. * ``PERIOD`` .. * ``COMMA`` ,. * ``QUOTE`` ". * ``ACCENT_GRAVE`` \`. * ``MINUS`` -. * ``PLUS`` +. * ``SLASH`` /. * ``BACK_SLASH`` \\. * ``EQUAL`` =. * ``LEFT_BRACKET`` [. * ``RIGHT_BRACKET`` ]. * ``LEFT_ARROW`` Left Arrow, ←. * ``DOWN_ARROW`` Down Arrow, ↓. * ``RIGHT_ARROW`` Right Arrow, →. * ``UP_ARROW`` Up Arrow, ↑. * ``NUMPAD_2`` Numpad 2, Pad2. * ``NUMPAD_4`` Numpad 4, Pad4. * ``NUMPAD_6`` Numpad 6, Pad6. * ``NUMPAD_8`` Numpad 8, Pad8. * ``NUMPAD_1`` Numpad 1, Pad1. * ``NUMPAD_3`` Numpad 3, Pad3. * ``NUMPAD_5`` Numpad 5, Pad5. * ``NUMPAD_7`` Numpad 7, Pad7. * ``NUMPAD_9`` Numpad 9, Pad9. * ``NUMPAD_PERIOD`` Numpad ., Pad.. * ``NUMPAD_SLASH`` Numpad /, Pad/. * ``NUMPAD_ASTERIX`` Numpad \*, Pad\*. * ``NUMPAD_0`` Numpad 0, Pad0. * ``NUMPAD_MINUS`` Numpad -, Pad-. * ``NUMPAD_ENTER`` Numpad Enter, PadEnter. * ``NUMPAD_PLUS`` Numpad +, Pad+. * ``F1`` F1. * ``F2`` F2. * ``F3`` F3. * ``F4`` F4. * ``F5`` F5. * ``F6`` F6. * ``F7`` F7. * ``F8`` F8. * ``F9`` F9. * ``F10`` F10. * ``F11`` F11. * ``F12`` F12. * ``F13`` F13. * ``F14`` F14. * ``F15`` F15. * ``F16`` F16. * ``F17`` F17. * ``F18`` F18. * ``F19`` F19. * ``PAUSE`` Pause. * ``INSERT`` Insert, Ins. * ``HOME`` Home. * ``PAGE_UP`` Page Up, PgUp. * ``PAGE_DOWN`` Page Down, PgDown. * ``END`` End. * ``MEDIA_PLAY`` Media Play/Pause, >/\|\|. * ``MEDIA_STOP`` Media Stop, Stop. * ``MEDIA_FIRST`` Media First, \|<<. * ``MEDIA_LAST`` Media Last, >>\|. * ``TEXTINPUT`` Text Input, TxtIn. * ``WINDOW_DEACTIVATE`` Window Deactivate. * ``TIMER`` Timer, Tmr. * ``TIMER0`` Timer 0, Tmr0. * ``TIMER1`` Timer 1, Tmr1. * ``TIMER2`` Timer 2, Tmr2. * ``TIMER_JOBS`` Timer Jobs, TmrJob. * ``TIMER_AUTOSAVE`` Timer Autosave, TmrSave. * ``TIMER_REPORT`` Timer Report, TmrReport. * ``TIMERREGION`` Timer Region, TmrReg. * ``NDOF_MOTION`` NDOF Motion, NdofMov. * ``NDOF_BUTTON_MENU`` NDOF Menu, NdofMenu. * ``NDOF_BUTTON_FIT`` NDOF Fit, NdofFit. * ``NDOF_BUTTON_TOP`` NDOF Top, Ndof↑. * ``NDOF_BUTTON_BOTTOM`` NDOF Bottom, Ndof↓. * ``NDOF_BUTTON_LEFT`` NDOF Left, Ndof←. * ``NDOF_BUTTON_RIGHT`` NDOF Right, Ndof→. * ``NDOF_BUTTON_FRONT`` NDOF Front, NdofFront. * ``NDOF_BUTTON_BACK`` NDOF Back, NdofBack. * ``NDOF_BUTTON_ISO1`` NDOF Isometric 1, NdofIso1. * ``NDOF_BUTTON_ISO2`` NDOF Isometric 2, NdofIso2. * ``NDOF_BUTTON_ROLL_CW`` NDOF Roll CW, NdofRCW. * ``NDOF_BUTTON_ROLL_CCW`` NDOF Roll CCW, NdofRCCW. * ``NDOF_BUTTON_SPIN_CW`` NDOF Spin CW, NdofSCW. * ``NDOF_BUTTON_SPIN_CCW`` NDOF Spin CCW, NdofSCCW. * ``NDOF_BUTTON_TILT_CW`` NDOF Tilt CW, NdofTCW. * ``NDOF_BUTTON_TILT_CCW`` NDOF Tilt CCW, NdofTCCW. * ``NDOF_BUTTON_ROTATE`` NDOF Rotate, NdofRot. * ``NDOF_BUTTON_PANZOOM`` NDOF Pan/Zoom, NdofPanZoom. * ``NDOF_BUTTON_DOMINANT`` NDOF Dominant, NdofDom. * ``NDOF_BUTTON_PLUS`` NDOF Plus, Ndof+. * ``NDOF_BUTTON_MINUS`` NDOF Minus, Ndof-. * ``NDOF_BUTTON_ESC`` NDOF Esc, NdofEsc. * ``NDOF_BUTTON_ALT`` NDOF Alt, NdofAlt. * ``NDOF_BUTTON_SHIFT`` NDOF Shift, NdofShift. * ``NDOF_BUTTON_CTRL`` NDOF Ctrl, NdofCtrl. * ``NDOF_BUTTON_1`` NDOF Button 1, NdofB1. * ``NDOF_BUTTON_2`` NDOF Button 2, NdofB2. * ``NDOF_BUTTON_3`` NDOF Button 3, NdofB3. * ``NDOF_BUTTON_4`` NDOF Button 4, NdofB4. * ``NDOF_BUTTON_5`` NDOF Button 5, NdofB5. * ``NDOF_BUTTON_6`` NDOF Button 6, NdofB6. * ``NDOF_BUTTON_7`` NDOF Button 7, NdofB7. * ``NDOF_BUTTON_8`` NDOF Button 8, NdofB8. * ``NDOF_BUTTON_9`` NDOF Button 9, NdofB9. * ``NDOF_BUTTON_10`` NDOF Button 10, NdofB10. * ``NDOF_BUTTON_A`` NDOF Button A, NdofBA. * ``NDOF_BUTTON_B`` NDOF Button B, NdofBB. * ``NDOF_BUTTON_C`` NDOF Button C, NdofBC.
        :type type: typing.Optional[typing.Union[str, int]]
        :param value: Value
        :type value: typing.Optional[typing.Union[str, int]]
        :param any: Any
        :type any: typing.Optional[typing.Union[bool, typing.Any]]
        :param shift: Shift
        :type shift: typing.Optional[typing.Union[bool, typing.Any]]
        :param ctrl: Ctrl
        :type ctrl: typing.Optional[typing.Union[bool, typing.Any]]
        :param alt: Alt
        :type alt: typing.Optional[typing.Union[bool, typing.Any]]
        :param oskey: OS Key
        :type oskey: typing.Optional[typing.Union[bool, typing.Any]]
        :param key_modifier: Key Modifier * ``NONE`` . * ``LEFTMOUSE`` Left Mouse, LMB. * ``MIDDLEMOUSE`` Middle Mouse, MMB. * ``RIGHTMOUSE`` Right Mouse, RMB. * ``BUTTON4MOUSE`` Button4 Mouse, MB4. * ``BUTTON5MOUSE`` Button5 Mouse, MB5. * ``BUTTON6MOUSE`` Button6 Mouse, MB6. * ``BUTTON7MOUSE`` Button7 Mouse, MB7. * ``ACTIONMOUSE`` Action Mouse, MBA. * ``SELECTMOUSE`` Select Mouse, MBS. * ``PEN`` Pen. * ``ERASER`` Eraser. * ``MOUSEMOVE`` Mouse Move, MsMov. * ``INBETWEEN_MOUSEMOVE`` In-between Move, MsSubMov. * ``TRACKPADPAN`` Mouse/Trackpad Pan, MsPan. * ``TRACKPADZOOM`` Mouse/Trackpad Zoom, MsZoom. * ``MOUSEROTATE`` Mouse/Trackpad Rotate, MsRot. * ``WHEELUPMOUSE`` Wheel Up, WhUp. * ``WHEELDOWNMOUSE`` Wheel Down, WhDown. * ``WHEELINMOUSE`` Wheel In, WhIn. * ``WHEELOUTMOUSE`` Wheel Out, WhOut. * ``EVT_TWEAK_L`` Tweak Left, TwkL. * ``EVT_TWEAK_M`` Tweak Middle, TwkM. * ``EVT_TWEAK_R`` Tweak Right, TwkR. * ``EVT_TWEAK_A`` Tweak Action, TwkA. * ``EVT_TWEAK_S`` Tweak Select, TwkS. * ``A`` A. * ``B`` B. * ``C`` C. * ``D`` D. * ``E`` E. * ``F`` F. * ``G`` G. * ``H`` H. * ``I`` I. * ``J`` J. * ``K`` K. * ``L`` L. * ``M`` M. * ``N`` N. * ``O`` O. * ``P`` P. * ``Q`` Q. * ``R`` R. * ``S`` S. * ``T`` T. * ``U`` U. * ``V`` V. * ``W`` W. * ``X`` X. * ``Y`` Y. * ``Z`` Z. * ``ZERO`` 0. * ``ONE`` 1. * ``TWO`` 2. * ``THREE`` 3. * ``FOUR`` 4. * ``FIVE`` 5. * ``SIX`` 6. * ``SEVEN`` 7. * ``EIGHT`` 8. * ``NINE`` 9. * ``LEFT_CTRL`` Left Ctrl, CtrlL. * ``LEFT_ALT`` Left Alt, AltL. * ``LEFT_SHIFT`` Left Shift, ShiftL. * ``RIGHT_ALT`` Right Alt, AltR. * ``RIGHT_CTRL`` Right Ctrl, CtrlR. * ``RIGHT_SHIFT`` Right Shift, ShiftR. * ``OSKEY`` OS Key, Cmd. * ``GRLESS`` Grless. * ``ESC`` Esc. * ``TAB`` Tab. * ``RET`` Return, Enter. * ``SPACE`` Spacebar, Space. * ``LINE_FEED`` Line Feed. * ``BACK_SPACE`` Back Space, BkSpace. * ``DEL`` Delete, Del. * ``SEMI_COLON`` ;. * ``PERIOD`` .. * ``COMMA`` ,. * ``QUOTE`` ". * ``ACCENT_GRAVE`` \`. * ``MINUS`` -. * ``PLUS`` +. * ``SLASH`` /. * ``BACK_SLASH`` \\. * ``EQUAL`` =. * ``LEFT_BRACKET`` [. * ``RIGHT_BRACKET`` ]. * ``LEFT_ARROW`` Left Arrow, ←. * ``DOWN_ARROW`` Down Arrow, ↓. * ``RIGHT_ARROW`` Right Arrow, →. * ``UP_ARROW`` Up Arrow, ↑. * ``NUMPAD_2`` Numpad 2, Pad2. * ``NUMPAD_4`` Numpad 4, Pad4. * ``NUMPAD_6`` Numpad 6, Pad6. * ``NUMPAD_8`` Numpad 8, Pad8. * ``NUMPAD_1`` Numpad 1, Pad1. * ``NUMPAD_3`` Numpad 3, Pad3. * ``NUMPAD_5`` Numpad 5, Pad5. * ``NUMPAD_7`` Numpad 7, Pad7. * ``NUMPAD_9`` Numpad 9, Pad9. * ``NUMPAD_PERIOD`` Numpad ., Pad.. * ``NUMPAD_SLASH`` Numpad /, Pad/. * ``NUMPAD_ASTERIX`` Numpad \*, Pad\*. * ``NUMPAD_0`` Numpad 0, Pad0. * ``NUMPAD_MINUS`` Numpad -, Pad-. * ``NUMPAD_ENTER`` Numpad Enter, PadEnter. * ``NUMPAD_PLUS`` Numpad +, Pad+. * ``F1`` F1. * ``F2`` F2. * ``F3`` F3. * ``F4`` F4. * ``F5`` F5. * ``F6`` F6. * ``F7`` F7. * ``F8`` F8. * ``F9`` F9. * ``F10`` F10. * ``F11`` F11. * ``F12`` F12. * ``F13`` F13. * ``F14`` F14. * ``F15`` F15. * ``F16`` F16. * ``F17`` F17. * ``F18`` F18. * ``F19`` F19. * ``PAUSE`` Pause. * ``INSERT`` Insert, Ins. * ``HOME`` Home. * ``PAGE_UP`` Page Up, PgUp. * ``PAGE_DOWN`` Page Down, PgDown. * ``END`` End. * ``MEDIA_PLAY`` Media Play/Pause, >/\|\|. * ``MEDIA_STOP`` Media Stop, Stop. * ``MEDIA_FIRST`` Media First, \|<<. * ``MEDIA_LAST`` Media Last, >>\|. * ``TEXTINPUT`` Text Input, TxtIn. * ``WINDOW_DEACTIVATE`` Window Deactivate. * ``TIMER`` Timer, Tmr. * ``TIMER0`` Timer 0, Tmr0. * ``TIMER1`` Timer 1, Tmr1. * ``TIMER2`` Timer 2, Tmr2. * ``TIMER_JOBS`` Timer Jobs, TmrJob. * ``TIMER_AUTOSAVE`` Timer Autosave, TmrSave. * ``TIMER_REPORT`` Timer Report, TmrReport. * ``TIMERREGION`` Timer Region, TmrReg. * ``NDOF_MOTION`` NDOF Motion, NdofMov. * ``NDOF_BUTTON_MENU`` NDOF Menu, NdofMenu. * ``NDOF_BUTTON_FIT`` NDOF Fit, NdofFit. * ``NDOF_BUTTON_TOP`` NDOF Top, Ndof↑. * ``NDOF_BUTTON_BOTTOM`` NDOF Bottom, Ndof↓. * ``NDOF_BUTTON_LEFT`` NDOF Left, Ndof←. * ``NDOF_BUTTON_RIGHT`` NDOF Right, Ndof→. * ``NDOF_BUTTON_FRONT`` NDOF Front, NdofFront. * ``NDOF_BUTTON_BACK`` NDOF Back, NdofBack. * ``NDOF_BUTTON_ISO1`` NDOF Isometric 1, NdofIso1. * ``NDOF_BUTTON_ISO2`` NDOF Isometric 2, NdofIso2. * ``NDOF_BUTTON_ROLL_CW`` NDOF Roll CW, NdofRCW. * ``NDOF_BUTTON_ROLL_CCW`` NDOF Roll CCW, NdofRCCW. * ``NDOF_BUTTON_SPIN_CW`` NDOF Spin CW, NdofSCW. * ``NDOF_BUTTON_SPIN_CCW`` NDOF Spin CCW, NdofSCCW. * ``NDOF_BUTTON_TILT_CW`` NDOF Tilt CW, NdofTCW. * ``NDOF_BUTTON_TILT_CCW`` NDOF Tilt CCW, NdofTCCW. * ``NDOF_BUTTON_ROTATE`` NDOF Rotate, NdofRot. * ``NDOF_BUTTON_PANZOOM`` NDOF Pan/Zoom, NdofPanZoom. * ``NDOF_BUTTON_DOMINANT`` NDOF Dominant, NdofDom. * ``NDOF_BUTTON_PLUS`` NDOF Plus, Ndof+. * ``NDOF_BUTTON_MINUS`` NDOF Minus, Ndof-. * ``NDOF_BUTTON_ESC`` NDOF Esc, NdofEsc. * ``NDOF_BUTTON_ALT`` NDOF Alt, NdofAlt. * ``NDOF_BUTTON_SHIFT`` NDOF Shift, NdofShift. * ``NDOF_BUTTON_CTRL`` NDOF Ctrl, NdofCtrl. * ``NDOF_BUTTON_1`` NDOF Button 1, NdofB1. * ``NDOF_BUTTON_2`` NDOF Button 2, NdofB2. * ``NDOF_BUTTON_3`` NDOF Button 3, NdofB3. * ``NDOF_BUTTON_4`` NDOF Button 4, NdofB4. * ``NDOF_BUTTON_5`` NDOF Button 5, NdofB5. * ``NDOF_BUTTON_6`` NDOF Button 6, NdofB6. * ``NDOF_BUTTON_7`` NDOF Button 7, NdofB7. * ``NDOF_BUTTON_8`` NDOF Button 8, NdofB8. * ``NDOF_BUTTON_9`` NDOF Button 9, NdofB9. * ``NDOF_BUTTON_10`` NDOF Button 10, NdofB10. * ``NDOF_BUTTON_A`` NDOF Button A, NdofBA. * ``NDOF_BUTTON_B`` NDOF Button B, NdofBB. * ``NDOF_BUTTON_C`` NDOF Button C, NdofBC.
        :type key_modifier: typing.Optional[typing.Any]
        :param head: At Head, Force item to be added at start (not end) of key map so that it doesn't get blocked by an existing key map item
        :type head: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'KeyMapItem'
        :return: Item, Added key map item
        '''
        pass

    def new_modal(
            self,
            propvalue: typing.Union[str, typing.Any],
            type: typing.Optional[typing.Union[str, int]],
            value: typing.Optional[typing.Union[str, int]],
            any: typing.Optional[typing.Union[bool, typing.Any]] = False,
            shift: typing.Optional[typing.Union[bool, typing.Any]] = False,
            ctrl: typing.Optional[typing.Union[bool, typing.Any]] = False,
            alt: typing.Optional[typing.Union[bool, typing.Any]] = False,
            oskey: typing.Optional[typing.Union[bool, typing.Any]] = False,
            key_modifier: typing.Optional[typing.Any] = 'NONE'
    ) -> 'KeyMapItem':
        ''' new_modal

        :param propvalue: Property Value
        :type propvalue: typing.Union[str, typing.Any]
        :param type: Type * ``NONE`` . * ``LEFTMOUSE`` Left Mouse, LMB. * ``MIDDLEMOUSE`` Middle Mouse, MMB. * ``RIGHTMOUSE`` Right Mouse, RMB. * ``BUTTON4MOUSE`` Button4 Mouse, MB4. * ``BUTTON5MOUSE`` Button5 Mouse, MB5. * ``BUTTON6MOUSE`` Button6 Mouse, MB6. * ``BUTTON7MOUSE`` Button7 Mouse, MB7. * ``ACTIONMOUSE`` Action Mouse, MBA. * ``SELECTMOUSE`` Select Mouse, MBS. * ``PEN`` Pen. * ``ERASER`` Eraser. * ``MOUSEMOVE`` Mouse Move, MsMov. * ``INBETWEEN_MOUSEMOVE`` In-between Move, MsSubMov. * ``TRACKPADPAN`` Mouse/Trackpad Pan, MsPan. * ``TRACKPADZOOM`` Mouse/Trackpad Zoom, MsZoom. * ``MOUSEROTATE`` Mouse/Trackpad Rotate, MsRot. * ``WHEELUPMOUSE`` Wheel Up, WhUp. * ``WHEELDOWNMOUSE`` Wheel Down, WhDown. * ``WHEELINMOUSE`` Wheel In, WhIn. * ``WHEELOUTMOUSE`` Wheel Out, WhOut. * ``EVT_TWEAK_L`` Tweak Left, TwkL. * ``EVT_TWEAK_M`` Tweak Middle, TwkM. * ``EVT_TWEAK_R`` Tweak Right, TwkR. * ``EVT_TWEAK_A`` Tweak Action, TwkA. * ``EVT_TWEAK_S`` Tweak Select, TwkS. * ``A`` A. * ``B`` B. * ``C`` C. * ``D`` D. * ``E`` E. * ``F`` F. * ``G`` G. * ``H`` H. * ``I`` I. * ``J`` J. * ``K`` K. * ``L`` L. * ``M`` M. * ``N`` N. * ``O`` O. * ``P`` P. * ``Q`` Q. * ``R`` R. * ``S`` S. * ``T`` T. * ``U`` U. * ``V`` V. * ``W`` W. * ``X`` X. * ``Y`` Y. * ``Z`` Z. * ``ZERO`` 0. * ``ONE`` 1. * ``TWO`` 2. * ``THREE`` 3. * ``FOUR`` 4. * ``FIVE`` 5. * ``SIX`` 6. * ``SEVEN`` 7. * ``EIGHT`` 8. * ``NINE`` 9. * ``LEFT_CTRL`` Left Ctrl, CtrlL. * ``LEFT_ALT`` Left Alt, AltL. * ``LEFT_SHIFT`` Left Shift, ShiftL. * ``RIGHT_ALT`` Right Alt, AltR. * ``RIGHT_CTRL`` Right Ctrl, CtrlR. * ``RIGHT_SHIFT`` Right Shift, ShiftR. * ``OSKEY`` OS Key, Cmd. * ``GRLESS`` Grless. * ``ESC`` Esc. * ``TAB`` Tab. * ``RET`` Return, Enter. * ``SPACE`` Spacebar, Space. * ``LINE_FEED`` Line Feed. * ``BACK_SPACE`` Back Space, BkSpace. * ``DEL`` Delete, Del. * ``SEMI_COLON`` ;. * ``PERIOD`` .. * ``COMMA`` ,. * ``QUOTE`` ". * ``ACCENT_GRAVE`` \`. * ``MINUS`` -. * ``PLUS`` +. * ``SLASH`` /. * ``BACK_SLASH`` \\. * ``EQUAL`` =. * ``LEFT_BRACKET`` [. * ``RIGHT_BRACKET`` ]. * ``LEFT_ARROW`` Left Arrow, ←. * ``DOWN_ARROW`` Down Arrow, ↓. * ``RIGHT_ARROW`` Right Arrow, →. * ``UP_ARROW`` Up Arrow, ↑. * ``NUMPAD_2`` Numpad 2, Pad2. * ``NUMPAD_4`` Numpad 4, Pad4. * ``NUMPAD_6`` Numpad 6, Pad6. * ``NUMPAD_8`` Numpad 8, Pad8. * ``NUMPAD_1`` Numpad 1, Pad1. * ``NUMPAD_3`` Numpad 3, Pad3. * ``NUMPAD_5`` Numpad 5, Pad5. * ``NUMPAD_7`` Numpad 7, Pad7. * ``NUMPAD_9`` Numpad 9, Pad9. * ``NUMPAD_PERIOD`` Numpad ., Pad.. * ``NUMPAD_SLASH`` Numpad /, Pad/. * ``NUMPAD_ASTERIX`` Numpad \*, Pad\*. * ``NUMPAD_0`` Numpad 0, Pad0. * ``NUMPAD_MINUS`` Numpad -, Pad-. * ``NUMPAD_ENTER`` Numpad Enter, PadEnter. * ``NUMPAD_PLUS`` Numpad +, Pad+. * ``F1`` F1. * ``F2`` F2. * ``F3`` F3. * ``F4`` F4. * ``F5`` F5. * ``F6`` F6. * ``F7`` F7. * ``F8`` F8. * ``F9`` F9. * ``F10`` F10. * ``F11`` F11. * ``F12`` F12. * ``F13`` F13. * ``F14`` F14. * ``F15`` F15. * ``F16`` F16. * ``F17`` F17. * ``F18`` F18. * ``F19`` F19. * ``PAUSE`` Pause. * ``INSERT`` Insert, Ins. * ``HOME`` Home. * ``PAGE_UP`` Page Up, PgUp. * ``PAGE_DOWN`` Page Down, PgDown. * ``END`` End. * ``MEDIA_PLAY`` Media Play/Pause, >/\|\|. * ``MEDIA_STOP`` Media Stop, Stop. * ``MEDIA_FIRST`` Media First, \|<<. * ``MEDIA_LAST`` Media Last, >>\|. * ``TEXTINPUT`` Text Input, TxtIn. * ``WINDOW_DEACTIVATE`` Window Deactivate. * ``TIMER`` Timer, Tmr. * ``TIMER0`` Timer 0, Tmr0. * ``TIMER1`` Timer 1, Tmr1. * ``TIMER2`` Timer 2, Tmr2. * ``TIMER_JOBS`` Timer Jobs, TmrJob. * ``TIMER_AUTOSAVE`` Timer Autosave, TmrSave. * ``TIMER_REPORT`` Timer Report, TmrReport. * ``TIMERREGION`` Timer Region, TmrReg. * ``NDOF_MOTION`` NDOF Motion, NdofMov. * ``NDOF_BUTTON_MENU`` NDOF Menu, NdofMenu. * ``NDOF_BUTTON_FIT`` NDOF Fit, NdofFit. * ``NDOF_BUTTON_TOP`` NDOF Top, Ndof↑. * ``NDOF_BUTTON_BOTTOM`` NDOF Bottom, Ndof↓. * ``NDOF_BUTTON_LEFT`` NDOF Left, Ndof←. * ``NDOF_BUTTON_RIGHT`` NDOF Right, Ndof→. * ``NDOF_BUTTON_FRONT`` NDOF Front, NdofFront. * ``NDOF_BUTTON_BACK`` NDOF Back, NdofBack. * ``NDOF_BUTTON_ISO1`` NDOF Isometric 1, NdofIso1. * ``NDOF_BUTTON_ISO2`` NDOF Isometric 2, NdofIso2. * ``NDOF_BUTTON_ROLL_CW`` NDOF Roll CW, NdofRCW. * ``NDOF_BUTTON_ROLL_CCW`` NDOF Roll CCW, NdofRCCW. * ``NDOF_BUTTON_SPIN_CW`` NDOF Spin CW, NdofSCW. * ``NDOF_BUTTON_SPIN_CCW`` NDOF Spin CCW, NdofSCCW. * ``NDOF_BUTTON_TILT_CW`` NDOF Tilt CW, NdofTCW. * ``NDOF_BUTTON_TILT_CCW`` NDOF Tilt CCW, NdofTCCW. * ``NDOF_BUTTON_ROTATE`` NDOF Rotate, NdofRot. * ``NDOF_BUTTON_PANZOOM`` NDOF Pan/Zoom, NdofPanZoom. * ``NDOF_BUTTON_DOMINANT`` NDOF Dominant, NdofDom. * ``NDOF_BUTTON_PLUS`` NDOF Plus, Ndof+. * ``NDOF_BUTTON_MINUS`` NDOF Minus, Ndof-. * ``NDOF_BUTTON_ESC`` NDOF Esc, NdofEsc. * ``NDOF_BUTTON_ALT`` NDOF Alt, NdofAlt. * ``NDOF_BUTTON_SHIFT`` NDOF Shift, NdofShift. * ``NDOF_BUTTON_CTRL`` NDOF Ctrl, NdofCtrl. * ``NDOF_BUTTON_1`` NDOF Button 1, NdofB1. * ``NDOF_BUTTON_2`` NDOF Button 2, NdofB2. * ``NDOF_BUTTON_3`` NDOF Button 3, NdofB3. * ``NDOF_BUTTON_4`` NDOF Button 4, NdofB4. * ``NDOF_BUTTON_5`` NDOF Button 5, NdofB5. * ``NDOF_BUTTON_6`` NDOF Button 6, NdofB6. * ``NDOF_BUTTON_7`` NDOF Button 7, NdofB7. * ``NDOF_BUTTON_8`` NDOF Button 8, NdofB8. * ``NDOF_BUTTON_9`` NDOF Button 9, NdofB9. * ``NDOF_BUTTON_10`` NDOF Button 10, NdofB10. * ``NDOF_BUTTON_A`` NDOF Button A, NdofBA. * ``NDOF_BUTTON_B`` NDOF Button B, NdofBB. * ``NDOF_BUTTON_C`` NDOF Button C, NdofBC.
        :type type: typing.Optional[typing.Union[str, int]]
        :param value: Value
        :type value: typing.Optional[typing.Union[str, int]]
        :param any: Any
        :type any: typing.Optional[typing.Union[bool, typing.Any]]
        :param shift: Shift
        :type shift: typing.Optional[typing.Union[bool, typing.Any]]
        :param ctrl: Ctrl
        :type ctrl: typing.Optional[typing.Union[bool, typing.Any]]
        :param alt: Alt
        :type alt: typing.Optional[typing.Union[bool, typing.Any]]
        :param oskey: OS Key
        :type oskey: typing.Optional[typing.Union[bool, typing.Any]]
        :param key_modifier: Key Modifier * ``NONE`` . * ``LEFTMOUSE`` Left Mouse, LMB. * ``MIDDLEMOUSE`` Middle Mouse, MMB. * ``RIGHTMOUSE`` Right Mouse, RMB. * ``BUTTON4MOUSE`` Button4 Mouse, MB4. * ``BUTTON5MOUSE`` Button5 Mouse, MB5. * ``BUTTON6MOUSE`` Button6 Mouse, MB6. * ``BUTTON7MOUSE`` Button7 Mouse, MB7. * ``ACTIONMOUSE`` Action Mouse, MBA. * ``SELECTMOUSE`` Select Mouse, MBS. * ``PEN`` Pen. * ``ERASER`` Eraser. * ``MOUSEMOVE`` Mouse Move, MsMov. * ``INBETWEEN_MOUSEMOVE`` In-between Move, MsSubMov. * ``TRACKPADPAN`` Mouse/Trackpad Pan, MsPan. * ``TRACKPADZOOM`` Mouse/Trackpad Zoom, MsZoom. * ``MOUSEROTATE`` Mouse/Trackpad Rotate, MsRot. * ``WHEELUPMOUSE`` Wheel Up, WhUp. * ``WHEELDOWNMOUSE`` Wheel Down, WhDown. * ``WHEELINMOUSE`` Wheel In, WhIn. * ``WHEELOUTMOUSE`` Wheel Out, WhOut. * ``EVT_TWEAK_L`` Tweak Left, TwkL. * ``EVT_TWEAK_M`` Tweak Middle, TwkM. * ``EVT_TWEAK_R`` Tweak Right, TwkR. * ``EVT_TWEAK_A`` Tweak Action, TwkA. * ``EVT_TWEAK_S`` Tweak Select, TwkS. * ``A`` A. * ``B`` B. * ``C`` C. * ``D`` D. * ``E`` E. * ``F`` F. * ``G`` G. * ``H`` H. * ``I`` I. * ``J`` J. * ``K`` K. * ``L`` L. * ``M`` M. * ``N`` N. * ``O`` O. * ``P`` P. * ``Q`` Q. * ``R`` R. * ``S`` S. * ``T`` T. * ``U`` U. * ``V`` V. * ``W`` W. * ``X`` X. * ``Y`` Y. * ``Z`` Z. * ``ZERO`` 0. * ``ONE`` 1. * ``TWO`` 2. * ``THREE`` 3. * ``FOUR`` 4. * ``FIVE`` 5. * ``SIX`` 6. * ``SEVEN`` 7. * ``EIGHT`` 8. * ``NINE`` 9. * ``LEFT_CTRL`` Left Ctrl, CtrlL. * ``LEFT_ALT`` Left Alt, AltL. * ``LEFT_SHIFT`` Left Shift, ShiftL. * ``RIGHT_ALT`` Right Alt, AltR. * ``RIGHT_CTRL`` Right Ctrl, CtrlR. * ``RIGHT_SHIFT`` Right Shift, ShiftR. * ``OSKEY`` OS Key, Cmd. * ``GRLESS`` Grless. * ``ESC`` Esc. * ``TAB`` Tab. * ``RET`` Return, Enter. * ``SPACE`` Spacebar, Space. * ``LINE_FEED`` Line Feed. * ``BACK_SPACE`` Back Space, BkSpace. * ``DEL`` Delete, Del. * ``SEMI_COLON`` ;. * ``PERIOD`` .. * ``COMMA`` ,. * ``QUOTE`` ". * ``ACCENT_GRAVE`` \`. * ``MINUS`` -. * ``PLUS`` +. * ``SLASH`` /. * ``BACK_SLASH`` \\. * ``EQUAL`` =. * ``LEFT_BRACKET`` [. * ``RIGHT_BRACKET`` ]. * ``LEFT_ARROW`` Left Arrow, ←. * ``DOWN_ARROW`` Down Arrow, ↓. * ``RIGHT_ARROW`` Right Arrow, →. * ``UP_ARROW`` Up Arrow, ↑. * ``NUMPAD_2`` Numpad 2, Pad2. * ``NUMPAD_4`` Numpad 4, Pad4. * ``NUMPAD_6`` Numpad 6, Pad6. * ``NUMPAD_8`` Numpad 8, Pad8. * ``NUMPAD_1`` Numpad 1, Pad1. * ``NUMPAD_3`` Numpad 3, Pad3. * ``NUMPAD_5`` Numpad 5, Pad5. * ``NUMPAD_7`` Numpad 7, Pad7. * ``NUMPAD_9`` Numpad 9, Pad9. * ``NUMPAD_PERIOD`` Numpad ., Pad.. * ``NUMPAD_SLASH`` Numpad /, Pad/. * ``NUMPAD_ASTERIX`` Numpad \*, Pad\*. * ``NUMPAD_0`` Numpad 0, Pad0. * ``NUMPAD_MINUS`` Numpad -, Pad-. * ``NUMPAD_ENTER`` Numpad Enter, PadEnter. * ``NUMPAD_PLUS`` Numpad +, Pad+. * ``F1`` F1. * ``F2`` F2. * ``F3`` F3. * ``F4`` F4. * ``F5`` F5. * ``F6`` F6. * ``F7`` F7. * ``F8`` F8. * ``F9`` F9. * ``F10`` F10. * ``F11`` F11. * ``F12`` F12. * ``F13`` F13. * ``F14`` F14. * ``F15`` F15. * ``F16`` F16. * ``F17`` F17. * ``F18`` F18. * ``F19`` F19. * ``PAUSE`` Pause. * ``INSERT`` Insert, Ins. * ``HOME`` Home. * ``PAGE_UP`` Page Up, PgUp. * ``PAGE_DOWN`` Page Down, PgDown. * ``END`` End. * ``MEDIA_PLAY`` Media Play/Pause, >/\|\|. * ``MEDIA_STOP`` Media Stop, Stop. * ``MEDIA_FIRST`` Media First, \|<<. * ``MEDIA_LAST`` Media Last, >>\|. * ``TEXTINPUT`` Text Input, TxtIn. * ``WINDOW_DEACTIVATE`` Window Deactivate. * ``TIMER`` Timer, Tmr. * ``TIMER0`` Timer 0, Tmr0. * ``TIMER1`` Timer 1, Tmr1. * ``TIMER2`` Timer 2, Tmr2. * ``TIMER_JOBS`` Timer Jobs, TmrJob. * ``TIMER_AUTOSAVE`` Timer Autosave, TmrSave. * ``TIMER_REPORT`` Timer Report, TmrReport. * ``TIMERREGION`` Timer Region, TmrReg. * ``NDOF_MOTION`` NDOF Motion, NdofMov. * ``NDOF_BUTTON_MENU`` NDOF Menu, NdofMenu. * ``NDOF_BUTTON_FIT`` NDOF Fit, NdofFit. * ``NDOF_BUTTON_TOP`` NDOF Top, Ndof↑. * ``NDOF_BUTTON_BOTTOM`` NDOF Bottom, Ndof↓. * ``NDOF_BUTTON_LEFT`` NDOF Left, Ndof←. * ``NDOF_BUTTON_RIGHT`` NDOF Right, Ndof→. * ``NDOF_BUTTON_FRONT`` NDOF Front, NdofFront. * ``NDOF_BUTTON_BACK`` NDOF Back, NdofBack. * ``NDOF_BUTTON_ISO1`` NDOF Isometric 1, NdofIso1. * ``NDOF_BUTTON_ISO2`` NDOF Isometric 2, NdofIso2. * ``NDOF_BUTTON_ROLL_CW`` NDOF Roll CW, NdofRCW. * ``NDOF_BUTTON_ROLL_CCW`` NDOF Roll CCW, NdofRCCW. * ``NDOF_BUTTON_SPIN_CW`` NDOF Spin CW, NdofSCW. * ``NDOF_BUTTON_SPIN_CCW`` NDOF Spin CCW, NdofSCCW. * ``NDOF_BUTTON_TILT_CW`` NDOF Tilt CW, NdofTCW. * ``NDOF_BUTTON_TILT_CCW`` NDOF Tilt CCW, NdofTCCW. * ``NDOF_BUTTON_ROTATE`` NDOF Rotate, NdofRot. * ``NDOF_BUTTON_PANZOOM`` NDOF Pan/Zoom, NdofPanZoom. * ``NDOF_BUTTON_DOMINANT`` NDOF Dominant, NdofDom. * ``NDOF_BUTTON_PLUS`` NDOF Plus, Ndof+. * ``NDOF_BUTTON_MINUS`` NDOF Minus, Ndof-. * ``NDOF_BUTTON_ESC`` NDOF Esc, NdofEsc. * ``NDOF_BUTTON_ALT`` NDOF Alt, NdofAlt. * ``NDOF_BUTTON_SHIFT`` NDOF Shift, NdofShift. * ``NDOF_BUTTON_CTRL`` NDOF Ctrl, NdofCtrl. * ``NDOF_BUTTON_1`` NDOF Button 1, NdofB1. * ``NDOF_BUTTON_2`` NDOF Button 2, NdofB2. * ``NDOF_BUTTON_3`` NDOF Button 3, NdofB3. * ``NDOF_BUTTON_4`` NDOF Button 4, NdofB4. * ``NDOF_BUTTON_5`` NDOF Button 5, NdofB5. * ``NDOF_BUTTON_6`` NDOF Button 6, NdofB6. * ``NDOF_BUTTON_7`` NDOF Button 7, NdofB7. * ``NDOF_BUTTON_8`` NDOF Button 8, NdofB8. * ``NDOF_BUTTON_9`` NDOF Button 9, NdofB9. * ``NDOF_BUTTON_10`` NDOF Button 10, NdofB10. * ``NDOF_BUTTON_A`` NDOF Button A, NdofBA. * ``NDOF_BUTTON_B`` NDOF Button B, NdofBB. * ``NDOF_BUTTON_C`` NDOF Button C, NdofBC.
        :type key_modifier: typing.Optional[typing.Any]
        :rtype: 'KeyMapItem'
        :return: Item, Added key map item
        '''
        pass

    def remove(self, item: 'KeyMapItem'):
        ''' remove

        :param item: Item
        :type item: 'KeyMapItem'
        '''
        pass

    def from_id(self, id: typing.Optional[int]) -> 'KeyMapItem':
        ''' from_id

        :param id: id, ID of the item
        :type id: typing.Optional[int]
        :rtype: 'KeyMapItem'
        :return: Item
        '''
        pass


class FCurveKeyframePoints(bpy_prop_collection[Keyframe], bpy_struct):
    ''' Collection of keyframe points
    '''

    def insert(self,
               frame: typing.Optional[float],
               value: typing.Optional[float],
               options: typing.Optional[typing.Any] = {},
               keyframe_type: typing.Optional[typing.Any] = 'KEYFRAME'
               ) -> 'Keyframe':
        ''' Add a keyframe point to a F-Curve

        :param frame: X Value of this keyframe point
        :type frame: typing.Optional[float]
        :param value: Y Value of this keyframe point
        :type value: typing.Optional[float]
        :param options: Keyframe options * ``REPLACE`` Replace, Don't add any new keyframes, but just replace existing ones. * ``NEEDED`` Needed, Only adds keyframes that are needed. * ``FAST`` Fast, Fast keyframe insertion to avoid recalculating the curve each time.
        :type options: typing.Optional[typing.Any]
        :param keyframe_type: Type of keyframe to insert * ``KEYFRAME`` Keyframe, Normal keyframe - e.g. for key poses. * ``BREAKDOWN`` Breakdown, A breakdown pose - e.g. for transitions between key poses. * ``MOVING_HOLD`` Moving Hold, A keyframe that is part of a moving hold. * ``EXTREME`` Extreme, An 'extreme' pose, or some other purpose as needed. * ``JITTER`` Jitter, A filler or baked keyframe for keying on ones, or some other purpose as needed.
        :type keyframe_type: typing.Optional[typing.Any]
        :rtype: 'Keyframe'
        :return: Newly created keyframe
        '''
        pass

    def add(self, count: typing.Optional[typing.Any] = 1):
        ''' Add a keyframe point to a F-Curve

        :param count: Number, Number of points to add to the spline
        :type count: typing.Optional[typing.Any]
        '''
        pass

    def remove(self,
               keyframe: 'Keyframe',
               fast: typing.Optional[typing.Union[bool, typing.Any]] = False):
        ''' Remove keyframe from an F-Curve

        :param keyframe: Keyframe to remove
        :type keyframe: 'Keyframe'
        :param fast: Fast, Fast keyframe removal to avoid recalculating the curve each time
        :type fast: typing.Optional[typing.Union[bool, typing.Any]]
        '''
        pass


class KeyingSets(bpy_prop_collection[KeyingSet], bpy_struct):
    ''' Scene keying sets
    '''

    active: 'KeyingSet' = None
    ''' Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSet'
    '''

    active_index: int = None
    ''' Current Keying Set index (negative for 'builtin' and positive for 'absolute')

    :type: int
    '''

    def new(self,
            idname: typing.Union[str, typing.Any] = "KeyingSet",
            name: typing.Union[str, typing.Any] = "KeyingSet") -> 'KeyingSet':
        ''' Add a new Keying Set to Scene

        :param idname: IDName, Internal identifier of Keying Set
        :type idname: typing.Union[str, typing.Any]
        :param name: Name, User visible name of Keying Set
        :type name: typing.Union[str, typing.Any]
        :rtype: 'KeyingSet'
        :return: Newly created Keying Set
        '''
        pass


class KeyingSetsAll(bpy_prop_collection[KeyingSet], bpy_struct):
    ''' All available keying sets
    '''

    active: 'KeyingSet' = None
    ''' Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSet'
    '''

    active_index: int = None
    ''' Current Keying Set index (negative for 'builtin' and positive for 'absolute')

    :type: int
    '''


class Available(KeyingSetInfo, bpy_struct):
    @staticmethod
    def generate(ksi, context, ks, data):
        ''' 

        '''
        pass

    @staticmethod
    def iterator(ksi, context, ks):
        ''' 

        '''
        pass

    @staticmethod
    def poll(ksi, context):
        ''' 

        '''
        pass


class LocRotScale(KeyingSetInfo, bpy_struct):
    def generate(self, context, ks, data):
        ''' 

        '''
        pass

    @staticmethod
    def iterator(ksi, context, ks):
        ''' 

        '''
        pass

    @staticmethod
    def poll(ksi, context):
        ''' 

        '''
        pass


class Location(KeyingSetInfo, bpy_struct):
    @staticmethod
    def generate(ksi, context, ks, data):
        ''' 

        '''
        pass

    @staticmethod
    def iterator(ksi, context, ks):
        ''' 

        '''
        pass

    @staticmethod
    def poll(ksi, context):
        ''' 

        '''
        pass


class Rotation(KeyingSetInfo, bpy_struct):
    @staticmethod
    def generate(ksi, context, ks, data):
        ''' 

        '''
        pass

    @staticmethod
    def iterator(ksi, context, ks):
        ''' 

        '''
        pass

    @staticmethod
    def poll(ksi, context):
        ''' 

        '''
        pass


class Scaling(KeyingSetInfo, bpy_struct):
    @staticmethod
    def generate(ksi, context, ks, data):
        ''' 

        '''
        pass

    @staticmethod
    def iterator(ksi, context, ks):
        ''' 

        '''
        pass

    @staticmethod
    def poll(ksi, context):
        ''' 

        '''
        pass


class WholeCharacter(KeyingSetInfo, bpy_struct):
    @staticmethod
    def addProp(ksi, ks, bone, prop, index=-1, use_groups=True):
        ''' 

        '''
        pass

    @staticmethod
    def doBBone(ksi, context, ks, pchan):
        ''' 

        '''
        pass

    @staticmethod
    def doCustomProps(ksi, ks, bone):
        ''' 

        '''
        pass

    @staticmethod
    def doLoc(ksi, ks, bone):
        ''' 

        '''
        pass

    @staticmethod
    def doRot3d(ksi, ks, bone):
        ''' 

        '''
        pass

    @staticmethod
    def doRot4d(ksi, ks, bone):
        ''' 

        '''
        pass

    @staticmethod
    def doScale(ksi, ks, bone):
        ''' 

        '''
        pass

    @staticmethod
    def generate(ksi, context, ks, bone):
        ''' 

        '''
        pass

    @staticmethod
    def iterator(ksi, context, ks):
        ''' 

        '''
        pass

    @staticmethod
    def poll(ksi, context):
        ''' 

        '''
        pass


class KeyingSetPaths(bpy_prop_collection[KeyingSetPath], bpy_struct):
    ''' Collection of keying set paths
    '''

    active: 'KeyingSetPath' = None
    ''' Active Keying Set used to insert/delete keyframes

    :type: 'KeyingSetPath'
    '''

    active_index: int = None
    ''' Current Keying Set index

    :type: int
    '''

    def add(self,
            target_id: typing.Optional['ID'],
            data_path: typing.Union[str, typing.Any],
            index: typing.Optional[typing.Any] = -1,
            group_method: typing.Optional[typing.Any] = 'KEYINGSET',
            group_name: typing.Union[str, typing.Any] = "") -> 'KeyingSetPath':
        ''' Add a new path for the Keying Set

        :param target_id: Target ID, ID-Datablock for the destination
        :type target_id: typing.Optional['ID']
        :param data_path: Data-Path, RNA-Path to destination property
        :type data_path: typing.Union[str, typing.Any]
        :param index: Index, The index of the destination property (i.e. axis of Location/Rotation/etc.), or -1 for the entire array
        :type index: typing.Optional[typing.Any]
        :param group_method: Grouping Method, Method used to define which Group-name to use
        :type group_method: typing.Optional[typing.Any]
        :param group_name: Group Name, Name of Action Group to assign destination to (only if grouping mode is to use this name)
        :type group_name: typing.Union[str, typing.Any]
        :rtype: 'KeyingSetPath'
        :return: New Path, Path created and added to the Keying Set
        '''
        pass

    def remove(self, path: 'KeyingSetPath'):
        ''' Remove the given path from the Keying Set

        :param path: Path
        :type path: 'KeyingSetPath'
        '''
        pass

    def clear(self):
        ''' Remove all the paths from the Keying Set

        '''
        pass


class LineStyleAlphaModifier(LineStyleModifier, bpy_struct):
    ''' Base type to define alpha transparency modifiers
    '''

    pass


class LineStyleColorModifier(LineStyleModifier, bpy_struct):
    ''' Base type to define line color modifiers
    '''

    pass


class LineStyleGeometryModifier(LineStyleModifier, bpy_struct):
    ''' Base type to define stroke geometry modifiers
    '''

    pass


class LineStyleThicknessModifier(LineStyleModifier, bpy_struct):
    ''' Base type to define line thickness modifiers
    '''

    pass


class MaskLayers(bpy_prop_collection[MaskLayer], bpy_struct):
    ''' Collection of layers used by mask
    '''

    active: 'MaskLayer' = None
    ''' Active layer in this mask

    :type: 'MaskLayer'
    '''

    def new(self, name: typing.Union[str, typing.Any] = "") -> 'MaskLayer':
        ''' Add layer to this mask

        :param name: Name, Name of new layer
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MaskLayer'
        :return: New mask layer
        '''
        pass

    def remove(self, layer: 'MaskLayer'):
        ''' Remove layer from this mask

        :param layer: Shape to be removed
        :type layer: 'MaskLayer'
        '''
        pass

    def clear(self):
        ''' Remove all mask layers

        '''
        pass


class MaskSplines(bpy_prop_collection[MaskSpline], bpy_struct):
    ''' Collection of masking splines
    '''

    active: 'MaskSpline' = None
    ''' Active spline of masking layer

    :type: 'MaskSpline'
    '''

    active_point: 'MaskSplinePoint' = None
    ''' Active spline of masking layer

    :type: 'MaskSplinePoint'
    '''

    def new(self) -> 'MaskSpline':
        ''' Add a new spline to the layer

        :rtype: 'MaskSpline'
        :return: The newly created spline
        '''
        pass

    def remove(self, spline: 'MaskSpline'):
        ''' Remove a spline from a layer

        :param spline: The spline to remove
        :type spline: 'MaskSpline'
        '''
        pass


class MaskSplinePoints(bpy_prop_collection[MaskSplinePoint], bpy_struct):
    ''' Collection of masking spline points
    '''

    def add(self, count: typing.Optional[typing.Any] = 1):
        ''' Add a number of point to this spline

        :param count: Number, Number of points to add to the spline
        :type count: typing.Optional[typing.Any]
        '''
        pass

    def remove(self, point: 'MaskSplinePoint'):
        ''' Remove a point from a spline

        :param point: The point to remove
        :type point: 'MaskSplinePoint'
        '''
        pass


class GPENCIL_PIE_sculpt(Menu, bpy_struct):
    def draw(self, context):
        ''' 

        '''
        pass

    def draw_preset(self, context):
        ''' Define these on the subclass: - preset_operator (string) - preset_subdir (string) Optionally: - preset_extensions (set of strings) - preset_operator_defaults (dict of keyword args)

        '''
        pass

    def path_menu(self,
                  searchpaths,
                  operator,
                  props_default=None,
                  filter_ext=None):
        ''' 

        '''
        pass


class GPENCIL_PIE_settings_palette(Menu, bpy_struct):
    def draw(self, context):
        ''' 

        '''
        pass

    def draw_preset(self, context):
        ''' Define these on the subclass: - preset_operator (string) - preset_subdir (string) Optionally: - preset_extensions (set of strings) - preset_operator_defaults (dict of keyword args)

        '''
        pass

    def path_menu(self,
                  searchpaths,
                  operator,
                  props_default=None,
                  filter_ext=None):
        ''' 

        '''
        pass


class GPENCIL_PIE_tool_palette(Menu, bpy_struct):
    def draw(self, context):
        ''' 

        '''
        pass

    def draw_preset(self, context):
        ''' Define these on the subclass: - preset_operator (string) - preset_subdir (string) Optionally: - preset_extensions (set of strings) - preset_operator_defaults (dict of keyword args)

        '''
        pass

    def path_menu(self,
                  searchpaths,
                  operator,
                  props_default=None,
                  filter_ext=None):
        ''' 

        '''
        pass


class GPENCIL_PIE_tools_more(Menu, bpy_struct):
    def draw(self, context):
        ''' 

        '''
        pass

    def draw_preset(self, context):
        ''' Define these on the subclass: - preset_operator (string) - preset_subdir (string) Optionally: - preset_extensions (set of strings) - preset_operator_defaults (dict of keyword args)

        '''
        pass

    def path_menu(self,
                  searchpaths,
                  operator,
                  props_default=None,
                  filter_ext=None):
        ''' 

        '''
        pass


class VertexColors(bpy_prop_collection[MeshColorLayer], bpy_struct):
    ''' Collection of vertex colors
    '''

    active: 'MeshColorLayer' = None
    ''' Active vertex color layer

    :type: 'MeshColorLayer'
    '''

    active_index: int = None
    ''' Active vertex color index

    :type: int
    '''

    def new(self,
            name: typing.Union[str, typing.Any] = "Col") -> 'MeshColorLayer':
        ''' Add a vertex color layer to Mesh

        :param name: Vertex color name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MeshColorLayer'
        :return: The newly created layer
        '''
        pass


class MeshEdges(bpy_prop_collection[MeshEdge], bpy_struct):
    ''' Collection of mesh edges
    '''

    def add(self, count: typing.Optional[typing.Any] = 0):
        ''' add

        :param count: Count, Number of edges to add
        :type count: typing.Optional[typing.Any]
        '''
        pass


class MeshLoops(bpy_prop_collection[MeshLoop], bpy_struct):
    ''' Collection of mesh loops
    '''

    def add(self, count: typing.Optional[typing.Any] = 0):
        ''' add

        :param count: Count, Number of loops to add
        :type count: typing.Optional[typing.Any]
        '''
        pass


class LoopColors(bpy_prop_collection[MeshLoopColorLayer], bpy_struct):
    ''' Collection of vertex colors
    '''

    active: 'MeshLoopColorLayer' = None
    ''' Active vertex color layer

    :type: 'MeshLoopColorLayer'
    '''

    active_index: int = None
    ''' Active vertex color index

    :type: int
    '''

    def new(self, name: typing.Union[str, typing.Any] = "Col"
            ) -> 'MeshLoopColorLayer':
        ''' Add a vertex color layer to Mesh

        :param name: Vertex color name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MeshLoopColorLayer'
        :return: The newly created layer
        '''
        pass

    def remove(self, layer: 'MeshLoopColorLayer'):
        ''' Remove a vertex color layer

        :param layer: The layer to remove
        :type layer: 'MeshLoopColorLayer'
        '''
        pass


class MeshPolygons(bpy_prop_collection[MeshPolygon], bpy_struct):
    ''' Collection of mesh polygons
    '''

    active: int = None
    ''' The active polygon for this mesh

    :type: int
    '''

    def add(self, count: typing.Optional[typing.Any] = 0):
        ''' add

        :param count: Count, Number of polygons to add
        :type count: typing.Optional[typing.Any]
        '''
        pass


class PolygonFloatProperties(
        bpy_prop_collection[MeshPolygonFloatPropertyLayer], bpy_struct):
    ''' Collection of float properties
    '''

    def new(self, name: typing.Union[str, typing.Any] = "Float Prop"
            ) -> 'MeshPolygonFloatPropertyLayer':
        ''' Add a float property layer to Mesh

        :param name: Float property name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MeshPolygonFloatPropertyLayer'
        :return: The newly created layer
        '''
        pass


class PolygonIntProperties(bpy_prop_collection[MeshPolygonIntPropertyLayer],
                           bpy_struct):
    ''' Collection of int properties
    '''

    def new(self, name: typing.Union[str, typing.Any] = "Int Prop"
            ) -> 'MeshPolygonIntPropertyLayer':
        ''' Add a integer property layer to Mesh

        :param name: Int property name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MeshPolygonIntPropertyLayer'
        :return: The newly created layer
        '''
        pass


class PolygonStringProperties(
        bpy_prop_collection[MeshPolygonStringPropertyLayer], bpy_struct):
    ''' Collection of string properties
    '''

    def new(self, name: typing.Union[str, typing.Any] = "String Prop"
            ) -> 'MeshPolygonStringPropertyLayer':
        ''' Add a string property layer to Mesh

        :param name: String property name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MeshPolygonStringPropertyLayer'
        :return: The newly created layer
        '''
        pass


class MeshTessFaces(bpy_prop_collection[MeshTessFace], bpy_struct):
    ''' Collection of mesh faces
    '''

    active: int = None
    ''' The active face for this mesh

    :type: int
    '''

    def add(self, count: typing.Optional[typing.Any] = 0):
        ''' add

        :param count: Count, Number of faces to add
        :type count: typing.Optional[typing.Any]
        '''
        pass


class TessfaceUVTextures(bpy_prop_collection[MeshTextureFaceLayer],
                         bpy_struct):
    ''' Collection of UV maps for tessellated faces
    '''

    active: 'MeshTextureFaceLayer' = None
    ''' Active UV Map

    :type: 'MeshTextureFaceLayer'
    '''

    active_index: int = None
    ''' Active UV Map index

    :type: int
    '''

    def new(self, name: typing.Union[str, typing.Any] = "UVMap"
            ) -> 'MeshTextureFaceLayer':
        ''' Add a UV tessface-texture layer to Mesh (only for meshes with no polygons)

        :param name: UV map name
        :type name: typing.Union[str, typing.Any]
        :rtype: 'MeshTextureFaceLayer'
        :return: The newly created layer
        '''
        pass


class UVTextures(bpy_prop_collection[MeshTexturePolyLayer], bpy_struct):
    ''' Collection of UV maps
    '''

    active: 'MeshTexturePolyLayer' = None
    ''' Active UV Map

    :type: 'MeshTexturePolyLayer'
    '''

    active_index: int = None
    ''' Active UV Map index

    :type: int
    '''

    def new(self, name: typing.Union[str, typing.Any] = "UVMap"
            ) -> 'MeshTexturePolyLayer':
        ''' Add a UV map 