# Generated by Django 3.0.7 on 2020-06-13 05:29

import datetime

import django.contrib.postgres.fields.jsonb
import django.contrib.sites.managers
import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("core", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="ExemptionRequest",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "extended_data",
                    models.JSONField(default=dict, editable=False),
                ),
                (
                    "from_date",
                    models.DateField(
                        default=datetime.date.today, verbose_name="Start date"
                    ),
                ),
                (
                    "from_time",
                    models.TimeField(
                        default=django.utils.timezone.now, verbose_name="Start time"
                    ),
                ),
                (
                    "to_date",
                    models.DateField(
                        default=datetime.date.today, verbose_name="End date"
                    ),
                ),
                (
                    "to_time",
                    models.TimeField(
                        default=django.utils.timezone.now, verbose_name="End time"
                    ),
                ),
                ("description", models.TextField()),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (0, "In process 1"),
                            (1, "In process 2"),
                            (2, "Approved"),
                            (3, "Rejected"),
                        ],
                        default=0,
                        verbose_name="Status",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        default=1,
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="sites.Site",
                    ),
                ),
                (
                    "submitter",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="exemption_requests",
                        to="core.Person",
                        verbose_name="Submitter",
                    ),
                ),
            ],
            options={
                "verbose_name": "Exemption request",
                "verbose_name_plural": "Exemption requests",
                "permissions": (
                    ("check1_exemptionrequest", "First check of exemption request"),
                    ("check2_exemptionrequest", "Second check of exemption request"),
                ),
            },
            managers=[
                ("objects", django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
    ]
