from deli.kubernetes.resources.model import SystemResourceModel


class Flavor(SystemResourceModel):

    def __init__(self, raw=None):
        super().__init__(raw)
        if raw is None:
            self._raw['spec'] = {
                'vcpu': 0,
                'ram': 0,
                'disk': 0
            }

    @property
    def vcpus(self):
        return self._raw['status']["vcpu"]

    @vcpus.setter
    def vcpus(self, value):
        self._raw['status']["vcpu"] = value

    @property
    def ram(self):
        return self._raw['status']["ram"]

    @ram.setter
    def ram(self, value):
        self._raw['status']["ram"] = value

    @property
    def disk(self):
        return self._raw['status']["disk"]

    @disk.setter
    def disk(self, value):
        self._raw['status']["disk"] = value
