﻿'''_1578.py

LoadedNonLinearBearingResults
'''


from mastapy.materials.efficiency import (
    _106, _100, _102, _107,
    _98, _101
)
from mastapy._internal import constructor
from mastapy._internal.cast_exception import CastException
from mastapy.bearings.bearing_results import _1570
from mastapy._internal.python_net import python_net_import

_LOADED_NON_LINEAR_BEARING_RESULTS = python_net_import('SMT.MastaAPI.Bearings.BearingResults', 'LoadedNonLinearBearingResults')


__docformat__ = 'restructuredtext en'
__all__ = ('LoadedNonLinearBearingResults',)


class LoadedNonLinearBearingResults(_1570.LoadedBearingResults):
    '''LoadedNonLinearBearingResults

    This is a mastapy class.
    '''

    TYPE = _LOADED_NON_LINEAR_BEARING_RESULTS

    __hash__ = None

    def __init__(self, instance_to_wrap: 'LoadedNonLinearBearingResults.TYPE'):
        super().__init__(instance_to_wrap)

    @property
    def power_loss(self) -> '_106.PowerLoss':
        '''PowerLoss: 'PowerLoss' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return constructor.new(_106.PowerLoss)(self.wrapped.PowerLoss) if self.wrapped.PowerLoss else None

    @property
    def power_loss_of_type_independent_power_loss(self) -> '_100.IndependentPowerLoss':
        '''IndependentPowerLoss: 'PowerLoss' is the original name of this property.

        Note:
            This property is readonly.
        '''

        if _100.IndependentPowerLoss.TYPE not in self.wrapped.PowerLoss.__class__.__mro__:
            raise CastException('Failed to cast power_loss to IndependentPowerLoss. Expected: {}.'.format(self.wrapped.PowerLoss.__class__.__qualname__))

        return constructor.new(_100.IndependentPowerLoss)(self.wrapped.PowerLoss) if self.wrapped.PowerLoss else None

    @property
    def power_loss_of_type_load_and_speed_combined_power_loss(self) -> '_102.LoadAndSpeedCombinedPowerLoss':
        '''LoadAndSpeedCombinedPowerLoss: 'PowerLoss' is the original name of this property.

        Note:
            This property is readonly.
        '''

        if _102.LoadAndSpeedCombinedPowerLoss.TYPE not in self.wrapped.PowerLoss.__class__.__mro__:
            raise CastException('Failed to cast power_loss to LoadAndSpeedCombinedPowerLoss. Expected: {}.'.format(self.wrapped.PowerLoss.__class__.__qualname__))

        return constructor.new(_102.LoadAndSpeedCombinedPowerLoss)(self.wrapped.PowerLoss) if self.wrapped.PowerLoss else None

    @property
    def resistive_torque(self) -> '_107.ResistiveTorque':
        '''ResistiveTorque: 'ResistiveTorque' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return constructor.new(_107.ResistiveTorque)(self.wrapped.ResistiveTorque) if self.wrapped.ResistiveTorque else None

    @property
    def resistive_torque_of_type_combined_resistive_torque(self) -> '_98.CombinedResistiveTorque':
        '''CombinedResistiveTorque: 'ResistiveTorque' is the original name of this property.

        Note:
            This property is readonly.
        '''

        if _98.CombinedResistiveTorque.TYPE not in self.wrapped.ResistiveTorque.__class__.__mro__:
            raise CastException('Failed to cast resistive_torque to CombinedResistiveTorque. Expected: {}.'.format(self.wrapped.ResistiveTorque.__class__.__qualname__))

        return constructor.new(_98.CombinedResistiveTorque)(self.wrapped.ResistiveTorque) if self.wrapped.ResistiveTorque else None

    @property
    def resistive_torque_of_type_independent_resistive_torque(self) -> '_101.IndependentResistiveTorque':
        '''IndependentResistiveTorque: 'ResistiveTorque' is the original name of this property.

        Note:
            This property is readonly.
        '''

        if _101.IndependentResistiveTorque.TYPE not in self.wrapped.ResistiveTorque.__class__.__mro__:
            raise CastException('Failed to cast resistive_torque to IndependentResistiveTorque. Expected: {}.'.format(self.wrapped.ResistiveTorque.__class__.__qualname__))

        return constructor.new(_101.IndependentResistiveTorque)(self.wrapped.ResistiveTorque) if self.wrapped.ResistiveTorque else None
