/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// AffineLoopFusion
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AffineLoopFusionBase : public ::mlir::FunctionPass {
public:
  AffineLoopFusionBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  AffineLoopFusionBase(const AffineLoopFusionBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "affine-loop-fusion"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "AffineLoopFusion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::Option<double> computeToleranceThreshold{*this, "fusion-compute-tolerance", ::llvm::cl::desc("Fractional increase in additional computation tolerated while fusing"), ::llvm::cl::init(0.30f)};
  ::mlir::Pass::Option<unsigned> fastMemorySpace{*this, "fusion-fast-mem-space", ::llvm::cl::desc("Faster memory space number to promote fusion buffers to"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<uint64_t> localBufSizeThreshold{*this, "fusion-local-buf-threshold", ::llvm::cl::desc("Threshold size (KiB) for promoting local buffers to fast memory space"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<bool> maximalFusion{*this, "fusion-maximal", ::llvm::cl::desc("Enables maximal loop fusion"), ::llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// AffinePipelineDataTransfer
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AffinePipelineDataTransferBase : public ::mlir::FunctionPass {
public:
  AffinePipelineDataTransferBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  AffinePipelineDataTransferBase(const AffinePipelineDataTransferBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "affine-pipeline-data-transfer"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "AffinePipelineDataTransfer"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// BufferPlacement
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class BufferPlacementBase : public ::mlir::FunctionPass {
public:
  BufferPlacementBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  BufferPlacementBase(const BufferPlacementBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "buffer-placement"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "BufferPlacement"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<linalg::LinalgDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// CSE
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CSEBase : public ::mlir::OperationPass<> {
public:
  CSEBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  CSEBase(const CSEBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "cse"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "CSE"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::Statistic numCSE{this, "num-cse'd", "Number of operations CSE'd"};
  ::mlir::Pass::Statistic numDCE{this, "num-dce'd", "Number of operations DCE'd"};
};

//===----------------------------------------------------------------------===//
// Canonicalizer
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CanonicalizerBase : public ::mlir::OperationPass<> {
public:
  CanonicalizerBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  CanonicalizerBase(const CanonicalizerBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "canonicalize"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "Canonicalizer"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// CopyRemoval
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CopyRemovalBase : public ::mlir::FunctionPass {
public:
  CopyRemovalBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  CopyRemovalBase(const CopyRemovalBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "copy-removal"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "CopyRemoval"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// Inliner
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class InlinerBase : public ::mlir::OperationPass<> {
public:
  InlinerBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  InlinerBase(const InlinerBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "inline"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "Inliner"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::Option<bool> disableCanonicalization{*this, "disable-simplify", ::llvm::cl::desc("Disable running simplifications during inlining"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<unsigned> maxInliningIterations{*this, "max-iterations", ::llvm::cl::desc("Maximum number of iterations when inlining within an SCC"), ::llvm::cl::init(4)};
};

//===----------------------------------------------------------------------===//
// LocationSnapshot
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LocationSnapshotBase : public ::mlir::OperationPass<> {
public:
  LocationSnapshotBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  LocationSnapshotBase(const LocationSnapshotBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "snapshot-op-locations"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "LocationSnapshot"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::Option<std::string> fileName{*this, "filename", ::llvm::cl::desc("The filename to print the generated IR")};
  ::mlir::Pass::Option<std::string> tag{*this, "tag", ::llvm::cl::desc("A tag to use when fusing the new locations with the original. If unset, the locations are replaced.")};
};

//===----------------------------------------------------------------------===//
// LoopCoalescing
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LoopCoalescingBase : public ::mlir::FunctionPass {
public:
  LoopCoalescingBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  LoopCoalescingBase(const LoopCoalescingBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "loop-coalescing"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "LoopCoalescing"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// LoopInvariantCodeMotion
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LoopInvariantCodeMotionBase : public ::mlir::OperationPass<> {
public:
  LoopInvariantCodeMotionBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  LoopInvariantCodeMotionBase(const LoopInvariantCodeMotionBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "loop-invariant-code-motion"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "LoopInvariantCodeMotion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// MemRefDataFlowOpt
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class MemRefDataFlowOptBase : public ::mlir::FunctionPass {
public:
  MemRefDataFlowOptBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  MemRefDataFlowOptBase(const MemRefDataFlowOptBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "memref-dataflow-opt"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "MemRefDataFlowOpt"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// NormalizeMemRefs
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class NormalizeMemRefsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  NormalizeMemRefsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  NormalizeMemRefsBase(const NormalizeMemRefsBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "normalize-memrefs"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "NormalizeMemRefs"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ParallelLoopCollapsing
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ParallelLoopCollapsingBase : public ::mlir::OperationPass<> {
public:
  ParallelLoopCollapsingBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ParallelLoopCollapsingBase(const ParallelLoopCollapsingBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "parallel-loop-collapsing"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ParallelLoopCollapsing"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::ListOption<unsigned> clCollapsedIndices0{*this, "collapsed-indices-0", ::llvm::cl::desc("Which loop indices to combine 0th loop index"), llvm::cl::MiscFlags::CommaSeparated};
  ::mlir::Pass::ListOption<unsigned> clCollapsedIndices1{*this, "collapsed-indices-1", ::llvm::cl::desc("Which loop indices to combine into the position 1 loop index"), llvm::cl::MiscFlags::CommaSeparated};
  ::mlir::Pass::ListOption<unsigned> clCollapsedIndices2{*this, "collapsed-indices-2", ::llvm::cl::desc("Which loop indices to combine into the position 2 loop index"), llvm::cl::MiscFlags::CommaSeparated};
};

//===----------------------------------------------------------------------===//
// PrintCFG
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PrintCFGBase : public ::mlir::FunctionPass {
public:
  PrintCFGBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  PrintCFGBase(const PrintCFGBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "print-cfg-graph"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "PrintCFG"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// PrintOp
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PrintOpBase : public ::mlir::OperationPass<ModuleOp> {
public:
  PrintOpBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  PrintOpBase(const PrintOpBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "print-op-graph"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "PrintOp"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// PrintOpStats
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PrintOpStatsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  PrintOpStatsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  PrintOpStatsBase(const PrintOpStatsBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "print-op-stats"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "PrintOpStats"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// SCCP
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCCPBase : public ::mlir::OperationPass<> {
public:
  SCCPBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  SCCPBase(const SCCPBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "sccp"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SCCP"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// StripDebugInfo
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class StripDebugInfoBase : public ::mlir::OperationPass<> {
public:
  StripDebugInfoBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  StripDebugInfoBase(const StripDebugInfoBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "strip-debuginfo"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "StripDebugInfo"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// SymbolDCE
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SymbolDCEBase : public ::mlir::OperationPass<> {
public:
  SymbolDCEBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  SymbolDCEBase(const SymbolDCEBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "symbol-dce"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SymbolDCE"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// AffineLoopFusion Registration
//===----------------------------------------------------------------------===//

inline void registerAffineLoopFusionPass() {
  ::mlir::registerPass("affine-loop-fusion", "Fuse affine loop nests", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLoopFusionPass();
  });
}

//===----------------------------------------------------------------------===//
// AffinePipelineDataTransfer Registration
//===----------------------------------------------------------------------===//

inline void registerAffinePipelineDataTransferPass() {
  ::mlir::registerPass("affine-pipeline-data-transfer", "Pipeline non-blocking data transfers between explicitly managed levels of the memory hierarchy", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createPipelineDataTransferPass();
  });
}

//===----------------------------------------------------------------------===//
// BufferPlacement Registration
//===----------------------------------------------------------------------===//

inline void registerBufferPlacementPass() {
  ::mlir::registerPass("buffer-placement", "Optimizes placement of alloc and dealloc operations", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createBufferPlacementPass();
  });
}

//===----------------------------------------------------------------------===//
// CSE Registration
//===----------------------------------------------------------------------===//

inline void registerCSEPass() {
  ::mlir::registerPass("cse", "Eliminate common sub-expressions", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createCSEPass();
  });
}

//===----------------------------------------------------------------------===//
// Canonicalizer Registration
//===----------------------------------------------------------------------===//

inline void registerCanonicalizerPass() {
  ::mlir::registerPass("canonicalize", "Canonicalize operations", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createCanonicalizerPass();
  });
}

//===----------------------------------------------------------------------===//
// CopyRemoval Registration
//===----------------------------------------------------------------------===//

inline void registerCopyRemovalPass() {
  ::mlir::registerPass("copy-removal", "Remove the redundant copies from input IR", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createCopyRemovalPass();
  });
}

//===----------------------------------------------------------------------===//
// Inliner Registration
//===----------------------------------------------------------------------===//

inline void registerInlinerPass() {
  ::mlir::registerPass("inline", "Inline function calls", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createInlinerPass();
  });
}

//===----------------------------------------------------------------------===//
// LocationSnapshot Registration
//===----------------------------------------------------------------------===//

inline void registerLocationSnapshotPass() {
  ::mlir::registerPass("snapshot-op-locations", "Generate new locations from the current IR", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLocationSnapshotPass();
  });
}

//===----------------------------------------------------------------------===//
// LoopCoalescing Registration
//===----------------------------------------------------------------------===//

inline void registerLoopCoalescingPass() {
  ::mlir::registerPass("loop-coalescing", "Coalesce nested loops with independent bounds into a single loop", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLoopCoalescingPass();
  });
}

//===----------------------------------------------------------------------===//
// LoopInvariantCodeMotion Registration
//===----------------------------------------------------------------------===//

inline void registerLoopInvariantCodeMotionPass() {
  ::mlir::registerPass("loop-invariant-code-motion", "Hoist loop invariant instructions outside of the loop", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLoopInvariantCodeMotionPass();
  });
}

//===----------------------------------------------------------------------===//
// MemRefDataFlowOpt Registration
//===----------------------------------------------------------------------===//

inline void registerMemRefDataFlowOptPass() {
  ::mlir::registerPass("memref-dataflow-opt", "Perform store/load forwarding for memrefs", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createMemRefDataFlowOptPass();
  });
}

//===----------------------------------------------------------------------===//
// NormalizeMemRefs Registration
//===----------------------------------------------------------------------===//

inline void registerNormalizeMemRefsPass() {
  ::mlir::registerPass("normalize-memrefs", "Normalize memrefs", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createNormalizeMemRefsPass();
  });
}

//===----------------------------------------------------------------------===//
// ParallelLoopCollapsing Registration
//===----------------------------------------------------------------------===//

inline void registerParallelLoopCollapsingPass() {
  ::mlir::registerPass("parallel-loop-collapsing", "Collapse parallel loops to use less induction variables", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createParallelLoopCollapsingPass();
  });
}

//===----------------------------------------------------------------------===//
// PrintCFG Registration
//===----------------------------------------------------------------------===//

inline void registerPrintCFGPass() {
  ::mlir::registerPass("print-cfg-graph", "Print CFG graph per-Region", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createPrintCFGGraphPass();
  });
}

//===----------------------------------------------------------------------===//
// PrintOp Registration
//===----------------------------------------------------------------------===//

inline void registerPrintOpPass() {
  ::mlir::registerPass("print-op-graph", "Print op graph per-Region", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createPrintOpGraphPass();
  });
}

//===----------------------------------------------------------------------===//
// PrintOpStats Registration
//===----------------------------------------------------------------------===//

inline void registerPrintOpStatsPass() {
  ::mlir::registerPass("print-op-stats", "Print statistics of operations", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createPrintOpStatsPass();
  });
}

//===----------------------------------------------------------------------===//
// SCCP Registration
//===----------------------------------------------------------------------===//

inline void registerSCCPPass() {
  ::mlir::registerPass("sccp", "Sparse Conditional Constant Propagation", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSCCPPass();
  });
}

//===----------------------------------------------------------------------===//
// StripDebugInfo Registration
//===----------------------------------------------------------------------===//

inline void registerStripDebugInfoPass() {
  ::mlir::registerPass("strip-debuginfo", "Strip debug info from all operations", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createStripDebugInfoPass();
  });
}

//===----------------------------------------------------------------------===//
// SymbolDCE Registration
//===----------------------------------------------------------------------===//

inline void registerSymbolDCEPass() {
  ::mlir::registerPass("symbol-dce", "Eliminate dead symbols", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSymbolDCEPass();
  });
}

//===----------------------------------------------------------------------===//
// Transforms Registration
//===----------------------------------------------------------------------===//

inline void registerTransformsPasses() {
  registerAffineLoopFusionPass();
  registerAffinePipelineDataTransferPass();
  registerBufferPlacementPass();
  registerCSEPass();
  registerCanonicalizerPass();
  registerCopyRemovalPass();
  registerInlinerPass();
  registerLocationSnapshotPass();
  registerLoopCoalescingPass();
  registerLoopInvariantCodeMotionPass();
  registerMemRefDataFlowOptPass();
  registerNormalizeMemRefsPass();
  registerParallelLoopCollapsingPass();
  registerPrintCFGPass();
  registerPrintOpPass();
  registerPrintOpStatsPass();
  registerSCCPPass();
  registerStripDebugInfoPass();
  registerSymbolDCEPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
