# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetSelfServiceProfileResult',
    'AwaitableGetSelfServiceProfileResult',
    'get_self_service_profile',
    'get_self_service_profile_output',
]

@pulumi.output_type
class GetSelfServiceProfileResult:
    """
    A collection of values returned by getSelfServiceProfile.
    """
    def __init__(__self__, brandings=None, created_at=None, id=None, updated_at=None, user_attributes=None):
        if brandings and not isinstance(brandings, list):
            raise TypeError("Expected argument 'brandings' to be a list")
        pulumi.set(__self__, "brandings", brandings)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if user_attributes and not isinstance(user_attributes, list):
            raise TypeError("Expected argument 'user_attributes' to be a list")
        pulumi.set(__self__, "user_attributes", user_attributes)

    @property
    @pulumi.getter
    def brandings(self) -> Sequence['outputs.GetSelfServiceProfileBrandingResult']:
        """
        Field can be used to customize the look and feel of the wizard.
        """
        return pulumi.get(self, "brandings")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The ISO 8601 formatted date the profile was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the Self Service Profile
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The ISO 8601 formatted date the profile was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> Sequence['outputs.GetSelfServiceProfileUserAttributeResult']:
        """
        This array stores the mapping information that will be shown to the user during the SS-SSO flow. The user will be prompted to map the attributes on their identity provider to ensure the specified attributes get passed to Auth0.
        """
        return pulumi.get(self, "user_attributes")


class AwaitableGetSelfServiceProfileResult(GetSelfServiceProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSelfServiceProfileResult(
            brandings=self.brandings,
            created_at=self.created_at,
            id=self.id,
            updated_at=self.updated_at,
            user_attributes=self.user_attributes)


def get_self_service_profile(id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSelfServiceProfileResult:
    """
    Data source to retrieve a specific Auth0 Self-Service Profile by `id`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # An Auth0 Self-Service- Profile loaded using it's ID.
    auth0_self_service_profile = auth0.get_self_service_profile(id="some-profile-id")
    ```


    :param str id: The id of the Self Service Profile
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getSelfServiceProfile:getSelfServiceProfile', __args__, opts=opts, typ=GetSelfServiceProfileResult).value

    return AwaitableGetSelfServiceProfileResult(
        brandings=pulumi.get(__ret__, 'brandings'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        user_attributes=pulumi.get(__ret__, 'user_attributes'))


@_utilities.lift_output_func(get_self_service_profile)
def get_self_service_profile_output(id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSelfServiceProfileResult]:
    """
    Data source to retrieve a specific Auth0 Self-Service Profile by `id`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # An Auth0 Self-Service- Profile loaded using it's ID.
    auth0_self_service_profile = auth0.get_self_service_profile(id="some-profile-id")
    ```


    :param str id: The id of the Self Service Profile
    """
    ...
