"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContextLoader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
/**
 * A utility to load context values into a construct node.
 *
 * If you want to use this utility in your own construct, make sure to invoke it
 * before you create any child constructs.
 */
class ContextLoader {
    /**
     * Parses JSON file contents, then provides the values to a Node's context.
     *
     * @param filename - The JSON file with an object to use as context values.
     * @param node - The constructs node to receive the context values.
     */
    static loadContext(filename, node) {
        try {
            fs.accessSync(filename, fs.constants.F_OK);
        }
        catch (err) {
            throw new Error(`Context file does not exist: ${filename}`);
        }
        try {
            fs.accessSync(filename, fs.constants.R_OK);
        }
        catch (err) {
            throw new Error(`Context file is not readable: ${filename}`);
        }
        const data = fs.readFileSync(filename, { encoding: "utf8" });
        let defaults = {};
        try {
            defaults = JSON.parse(data);
        }
        catch (e) {
            throw new Error(`Context file contains invalid JSON syntax: ${filename}`);
        }
        for (const [k, v] of Object.entries(defaults)) {
            node.setContext(k, v);
        }
    }
}
exports.ContextLoader = ContextLoader;
_a = JSII_RTTI_SYMBOL_1;
ContextLoader[_a] = { fqn: "shady-island.ContextLoader", version: "0.1.12" };
//# sourceMappingURL=data:application/json;base64,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