#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.funct_system_interfaces.functional_action import FunctionalAction
from pycatia.funct_system_interfaces.functional_position import FunctionalPosition
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class FunctionalActions(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     FunctionalActions
                | 
                | The interface to access a collection of FunctionalActions.
    
    """

    def __init__(self, com_object, child_object=FunctionalAction):
        super().__init__(com_object, child_object=FunctionalAction)
        self.functional_actions = com_object
        self.child_object = child_object

    def create(self, i_name: str, i_from: FunctionalPosition, i_to: FunctionalPosition) -> FunctionalAction:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Create(CATBSTR iName,
                | FunctionalPosition iFrom,
                | FunctionalPosition iTo) As FunctionalAction
                | 
                |     Create a FunctionalAction.

        :param str i_name:
        :param FunctionalPosition i_from:
        :param FunctionalPosition i_to:
        :return: FunctionalAction
        :rtype: FunctionalAction
        """
        return FunctionalAction(self.functional_actions.Create(i_name, i_from.com_object, i_to.com_object))

    def delete(self, i_action: FunctionalAction) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Delete(FunctionalAction iAction)
                | 
                |     Delete a FunctionalAction.

        :param FunctionalAction i_action:
        :return: None
        :rtype: None
        """
        return self.functional_actions.Delete(i_action.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete'
        # # vba_code = """
        # # Public Function delete(functional_actions)
        # #     Dim iAction (2)
        # #     functional_actions.Delete iAction
        # #     delete = iAction
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def elem(self, i_index: cat_variant) -> FunctionalAction:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Elem(CATVariant iIndex) As FunctionalAction
                | 
                |     Returns an action using its index or its name from the actions
                |     collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the action to retrieve from the collection
                |             of actions. As a numerics, this index is the rank of the action in the
                |             collection. The index of the first action in the collection is 1, and the index
                |             of the last action is Count. As a string, it is the name you assigned to the
                |             action using the 
                | 
                |         AnyObject.Name property. 
                |     Returns:
                |         The retrieved action 
                |     Example:
                |         This example retrieves in Act1 the fifth action in the collection and
                |         in Act2 the action named Moves.
                | 
                |          Dim Act1 As FunctionalAction
                |          Set Act1 = Desc.Action(5)
                |          Dim Act2 As FunctionalAction
                |          Set Act2 = Desc.Action("Moves")

        :param CATVariant i_index:
        :return: FunctionalAction
        :rtype: FunctionalAction
        """
        return FunctionalAction(self.functional_actions.Elem(i_index))

    def __repr__(self):
        return f'FunctionalActions(name="{self.name}")'
