#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from typing import TYPE_CHECKING
from pycatia.funct_system_interfaces.functional_object import FunctionalObject

if TYPE_CHECKING:
    from pycatia.funct_system_interfaces.functional_description import FunctionalDescription


class FunctionalObjectProxy(FunctionalObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     CATFunctSystemItf.FunctionalElement
                |                         CATFunctSystemItf.FunctionalPosition
                |                             CATFunctSystemItf.FunctionalObject
                |                                 FunctionalObjectProxy
                | 
                | The interface to access a Functional ObjectProxy.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.functional_object_proxy = com_object

    @property
    def description(self) -> 'FunctionalDescription':
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Description() As FunctionalDescription (Read Only)
                | 
                |     Get the description attached to the proxi.

        :return: FunctionalDescription
        :rtype: FunctionalDescription
        """

        return FunctionalDescription(self.functional_object_proxy.Description)

    def set_description(self, i_desc: 'FunctionalDescription') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub set_Description(FunctionalDescription iDesc)
                | 
                |     set the description attached to the proxi.

        :param FunctionalDescription i_desc:
        :return: None
        :rtype: None
        """
        return self.functional_object_proxy.set_Description(i_desc.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_description'
        # # vba_code = """
        # # Public Function set_description(functional_object_proxy)
        # #     Dim iDesc (2)
        # #     functional_object_proxy.set_Description iDesc
        # #     set_description = iDesc
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'FunctionalObjectProxy(name="{self.name}")'
