#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-07-06 14:02:20.222384

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class LightSource(AnyObject):

    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     LightSource
                | 
                | Represents the light source.
                | The light source is the object that stores lighting data used by a viewer to
                | display a scene where a document is presented. Two kinds of light sources are
                | available: an infinite light source and a neon lighting system simulating a set
                | of parallel neon tubes.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.light_source = com_object

    def get_direction(self, o_direction: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub GetDirection(CATSafeArrayVariant oDirection)
                | 
                |     Returns the lighting direction as an array of 3 variants. This value is
                |     available with an infinite light source only.
                | 
                |     Example:
                |         This example gets the lighting direction of the LightSource light
                |         source to the direction with components (5,8,-2).
                | 
                |          Dim direction(2)
                |          LightSource.GetDirection direction

        :param tuple o_direction:
        :return: None
        :rtype: None
        """
        return self.light_source.GetDirection(o_direction)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_direction'
        # # vba_code = """
        # # Public Function get_direction(light_source)
        # #     Dim oDirection (2)
        # #     light_source.GetDirection oDirection
        # #     get_direction = oDirection
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def put_direction(self, o_direction: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub PutDirection(CATSafeArrayVariant oDirection)
                | 
                |     Defines the lighting direction as an array of 3 variants. This value can be
                |     set with an infinite light source only.
                | 
                |     Example:
                |         This example defines the lighting direction of the LightSource light
                |         source to the direction with components (5,8,-2).
                | 
                |          LightSource.PutDirection Array(5,8,-2)

        :param tuple o_direction:
        :return: None
        :rtype: None
        """
        return self.light_source.PutDirection(o_direction)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'put_direction'
        # # vba_code = """
        # # Public Function put_direction(light_source)
        # #     Dim oDirection (2)
        # #     light_source.PutDirection oDirection
        # #     put_direction = oDirection
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'LightSource(name="{ self.name }")'
